/*      */ package oracle.jdbc.xa.client;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.sql.CallableStatement;
/*      */ import java.sql.Connection;
/*      */ import java.sql.SQLException;
/*      */ import javax.transaction.xa.XAException;
/*      */ import javax.transaction.xa.Xid;
/*      */ import oracle.jdbc.internal.OracleConnection;
/*      */ import oracle.jdbc.oracore.Util;
/*      */ import oracle.jdbc.xa.OracleXAConnection;
/*      */ import oracle.jdbc.xa.OracleXAException;
/*      */ 
/*      */ public class OracleXAResource extends oracle.jdbc.xa.OracleXAResource
/*      */ {
/*   33 */   private short m_version = 0;
/*      */ 
/*   36 */   private boolean needStackingForCommitRollbackPrepare = false;
/*      */ 
/*   39 */   private static String xa_start_816 = "begin ? := JAVA_XA.xa_start(?,?,?,?); end;";
/*      */ 
/*   41 */   private static String xa_start_post_816 = "begin ? := JAVA_XA.xa_start_new(?,?,?,?,?); end;";
/*      */ 
/*   45 */   private static String xa_end_816 = "begin ? := JAVA_XA.xa_end(?,?); end;";
/*   46 */   private static String xa_end_post_816 = "begin ? := JAVA_XA.xa_end_new(?,?,?,?); end;";
/*      */ 
/*   49 */   private static String xa_commit_816 = "begin ? := JAVA_XA.xa_commit (?,?,?); end;";
/*      */ 
/*   51 */   private static String xa_commit_post_816 = "begin ? := JAVA_XA.xa_commit_new (?,?,?,?); end;";
/*      */ 
/*   54 */   private static String xa_prepare_816 = "begin ? := JAVA_XA.xa_prepare (?,?); end;";
/*      */ 
/*   56 */   private static String xa_prepare_post_816 = "begin ? := JAVA_XA.xa_prepare_new (?,?,?); end;";
/*      */ 
/*   59 */   private static String xa_rollback_816 = "begin ? := JAVA_XA.xa_rollback (?,?); end;";
/*      */ 
/*   61 */   private static String xa_rollback_post_816 = "begin ? := JAVA_XA.xa_rollback_new (?,?,?); end;";
/*      */ 
/*   64 */   private static String xa_forget_816 = "begin ? := JAVA_XA.xa_forget (?,?); end;";
/*      */ 
/*   66 */   private static String xa_forget_post_816 = "begin ? := JAVA_XA.xa_forget_new (?,?,?); end;";
/*      */ 
/*   74 */   boolean isTransLoose = false;
/*      */ 
/* 1097 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   public OracleXAResource()
/*      */   {
/*      */   }
/*      */ 
/*      */   public OracleXAResource(Connection paramConnection, OracleXAConnection paramOracleXAConnection)
/*      */     throws XAException
/*      */   {
/*   95 */     super(paramConnection, paramOracleXAConnection);
/*      */     try
/*      */     {
/*  106 */       this.m_version = ((OracleConnection)paramConnection).getVersionNumber();
/*  107 */       this.needStackingForCommitRollbackPrepare = (this.m_version < 9000);
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/*      */     }
/*      */ 
/*  114 */     if (this.m_version < 8170)
/*      */     {
/*  120 */       throw new XAException(-6);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void start(Xid paramXid, int paramInt)
/*      */     throws XAException
/*      */   {
/*  163 */     synchronized (this.connection)
/*      */     {
/*  168 */       int i = -1;
/*      */       try
/*      */       {
/*  175 */         if (paramXid == null)
/*      */         {
/*  179 */           throw new XAException(-5);
/*      */         }
/*      */ 
/*  183 */         int j = paramInt & 0xFF00;
/*      */ 
/*  185 */         paramInt &= -65281;
/*      */ 
/*  187 */         int k = paramInt & 0x10000 | (this.isTransLoose ? 65536 : 0);
/*      */ 
/*  189 */         paramInt &= -65537;
/*      */ 
/*  196 */         if (((paramInt & 0x8200002) != paramInt) || ((k != 0) && ((k & 0x10000) != 65536)))
/*      */         {
/*  202 */           throw new XAException(-5);
/*      */         }
/*      */ 
/*  213 */         if (((j & 0xFF00) != 0) && (j != 256) && (j != 512) && (j != 1024))
/*      */         {
/*  218 */           throw new XAException(-5);
/*      */         }
/*      */ 
/*  223 */         if (((paramInt & 0x8200000) != 0) && (((j & 0xFF00) != 0) || ((k & 0x10000) != 0)))
/*      */         {
/*  229 */           throw new XAException(-5);
/*      */         }
/*      */ 
/*  233 */         paramInt |= j | k;
/*      */ 
/*  235 */         saveAndAlterAutoCommitModeForGlobalTransaction();
/*      */         try
/*      */         {
/*  241 */           i = doStart(paramXid, paramInt);
/*      */         }
/*      */         catch (SQLException localSQLException)
/*      */         {
/*  246 */           checkError(localSQLException, -3);
/*      */         }
/*      */ 
/*  253 */         checkError(i);
/*      */ 
/*  257 */         boolean[] arrayOfBoolean = { false };
/*  258 */         super.createOrUpdateXid(paramXid, false, arrayOfBoolean);
/*      */       }
/*      */       catch (XAException localXAException)
/*      */       {
/*  264 */         restoreAutoCommitModeForGlobalTransaction();
/*      */ 
/*  266 */         throw localXAException;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected int doStart(Xid paramXid, int paramInt)
/*      */     throws XAException, SQLException
/*      */   {
/*  278 */     int i = -1;
/*  279 */     CallableStatement localCallableStatement = null;
/*      */     try
/*      */     {
/*  283 */       localCallableStatement = this.connection.prepareCall(xa_start_post_816);
/*      */ 
/*  285 */       localCallableStatement.registerOutParameter(1, 2);
/*  286 */       localCallableStatement.setInt(2, paramXid.getFormatId());
/*  287 */       localCallableStatement.setBytes(3, paramXid.getGlobalTransactionId());
/*  288 */       localCallableStatement.setBytes(4, paramXid.getBranchQualifier());
/*  289 */       localCallableStatement.setInt(5, this.timeout);
/*  290 */       localCallableStatement.setInt(6, paramInt);
/*      */ 
/*  292 */       localCallableStatement.execute();
/*      */ 
/*  294 */       i = localCallableStatement.getInt(1);
/*      */     }
/*      */     catch (SQLException localSQLException2)
/*      */     {
/*  298 */       i = localSQLException2.getErrorCode();
/*      */ 
/*  305 */       if (i == 0) {
/*  306 */         throw new XAException(-6);
/*      */       }
/*      */ 
/*  309 */       throw localSQLException2;
/*      */     }
/*      */     finally
/*      */     {
/*      */       try
/*      */       {
/*  315 */         if (localCallableStatement != null)
/*  316 */           localCallableStatement.close();
/*      */       }
/*      */       catch (SQLException localSQLException3) {
/*      */       }
/*  320 */       localCallableStatement = null;
/*      */     }
/*      */ 
/*  323 */     return i;
/*      */   }
/*      */ 
/*      */   public void end(Xid paramXid, int paramInt)
/*      */     throws XAException
/*      */   {
/*  358 */     synchronized (this.connection)
/*      */     {
/*  360 */       int i = -1;
/*  361 */       int j = 0;
/*  362 */       int k = 0;
/*      */       try
/*      */       {
/*  366 */         if (paramXid == null)
/*      */         {
/*  370 */           throw new XAException(-5);
/*      */         }
/*      */ 
/*  374 */         int m = 638582786;
/*  375 */         if ((paramInt & m) != paramInt)
/*      */         {
/*  379 */           throw new XAException(-5);
/*      */         }
/*      */ 
/*  390 */         Xid localXid = null;
/*  391 */         j = (paramInt & 0x4000000) != 0 ? 1 : 0;
/*  392 */         k = (paramInt & 0x20000000) != 0 ? 1 : 0;
/*      */ 
/*  396 */         if ((j != 0) || (k != 0)) {
/*  397 */           localXid = super.suspendStacked(paramXid);
/*      */         }
/*      */         try
/*      */         {
/*  401 */           boolean bool = false;
/*      */           int n;
/*  402 */           if ((j != 0) || (k != 0))
/*      */           {
/*  405 */             bool = isXidSuspended(paramXid);
/*      */ 
/*  416 */             if (bool) {
/*  417 */               super.resumeStacked(paramXid);
/*      */             }
/*      */ 
/*  420 */             removeXidFromList(paramXid);
/*  421 */           } else if (paramInt == 33554432)
/*      */           {
/*  423 */             boolean[] arrayOfBoolean = { false };
/*  424 */             super.createOrUpdateXid(paramXid, true, arrayOfBoolean);
/*      */ 
/*  427 */             n = arrayOfBoolean[0];
/*      */           }
/*      */ 
/*  431 */           i = doEnd(paramXid, paramInt, n);
/*      */         }
/*      */         catch (SQLException localSQLException)
/*      */         {
/*  436 */           checkError(localSQLException, -3);
/*      */         }
/*      */ 
/*  439 */         if (localXid != null)
/*      */         {
/*  442 */           super.resumeStacked(localXid);
/*  443 */         } else if (isXidListEmpty())
/*      */         {
/*  447 */           exitGlobalTxnMode();
/*  448 */           this.activeXid = null;
/*      */         }
/*      */ 
/*  454 */         checkError(i);
/*      */ 
/*  456 */         if (((j != 0) && (paramInt != 67108864)) || ((k != 0) && (paramInt != 536870912)))
/*      */         {
/*  459 */           throw new XAException(-5);
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/*  464 */         restoreAutoCommitModeForGlobalTransaction();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected int doEnd(Xid paramXid, int paramInt, boolean paramBoolean)
/*      */     throws XAException, SQLException
/*      */   {
/*  477 */     CallableStatement localCallableStatement = null;
/*  478 */     int i = -1;
/*      */     try
/*      */     {
/*  484 */       localCallableStatement = this.connection.prepareCall(xa_end_post_816);
/*      */ 
/*  486 */       localCallableStatement.registerOutParameter(1, 2);
/*  487 */       localCallableStatement.setInt(2, paramXid.getFormatId());
/*  488 */       localCallableStatement.setBytes(3, paramXid.getGlobalTransactionId());
/*  489 */       localCallableStatement.setBytes(4, paramXid.getBranchQualifier());
/*  490 */       localCallableStatement.setInt(5, paramInt);
/*  491 */       localCallableStatement.execute();
/*      */ 
/*  493 */       i = localCallableStatement.getInt(1);
/*      */     }
/*      */     catch (SQLException localSQLException2)
/*      */     {
/*  497 */       i = localSQLException2.getErrorCode();
/*      */ 
/*  504 */       if (i == 0) {
/*  505 */         throw new XAException(-6);
/*      */       }
/*      */ 
/*  508 */       throw localSQLException2;
/*      */     }
/*      */     finally
/*      */     {
/*      */       try
/*      */       {
/*  514 */         if (localCallableStatement != null)
/*  515 */           localCallableStatement.close();
/*      */       }
/*      */       catch (SQLException localSQLException3) {
/*      */       }
/*  519 */       localCallableStatement = null;
/*      */     }
/*      */ 
/*  522 */     return i;
/*      */   }
/*      */ 
/*      */   public void commit(Xid paramXid, boolean paramBoolean)
/*      */     throws XAException
/*      */   {
/*  553 */     synchronized (this.connection)
/*      */     {
/*  555 */       if (paramXid == null)
/*      */       {
/*  559 */         throw new XAException(-5);
/*      */       }
/*      */ 
/*  563 */       Xid localXid = null;
/*  564 */       if (this.needStackingForCommitRollbackPrepare) {
/*  565 */         localXid = super.suspendStacked(paramXid);
/*      */       }
/*      */       else
/*      */       {
/*  573 */         removeXidFromList(paramXid);
/*      */ 
/*  575 */         if (this.activeXid == null) {
/*  576 */           exitGlobalTxnMode();
/*      */         }
/*      */       }
/*      */       try
/*      */       {
/*      */         try
/*      */         {
/*  583 */           doCommit(paramXid, paramBoolean);
/*      */         }
/*      */         catch (SQLException localSQLException1)
/*      */         {
/*  588 */           checkError(localSQLException1, -3);
/*      */         }
/*      */       }
/*      */       catch (XAException localXAException)
/*      */       {
/*  593 */         if (localXAException.errorCode == -7)
/*      */         {
/*      */           try
/*      */           {
/*  597 */             this.connection.close();
/*      */           }
/*      */           catch (SQLException localSQLException2) {
/*      */           }
/*      */         }
/*  602 */         else if (this.needStackingForCommitRollbackPrepare) {
/*  603 */           super.resumeStacked(localXid);
/*      */         }
/*  605 */         throw localXAException;
/*      */       }
/*      */ 
/*  608 */       if (this.needStackingForCommitRollbackPrepare)
/*  609 */         super.resumeStacked(localXid);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void doCommit(Xid paramXid, boolean paramBoolean)
/*      */     throws XAException, SQLException
/*      */   {
/*  620 */     CallableStatement localCallableStatement = null;
/*      */     try
/*      */     {
/*  626 */       localCallableStatement = this.connection.prepareCall(xa_commit_post_816);
/*      */ 
/*  628 */       localCallableStatement.registerOutParameter(1, 2);
/*  629 */       localCallableStatement.setInt(2, paramXid.getFormatId());
/*  630 */       localCallableStatement.setBytes(3, paramXid.getGlobalTransactionId());
/*  631 */       localCallableStatement.setBytes(4, paramXid.getBranchQualifier());
/*  632 */       localCallableStatement.setInt(5, paramBoolean ? 1 : 0);
/*      */ 
/*  634 */       localCallableStatement.execute();
/*      */ 
/*  636 */       int i = localCallableStatement.getInt(1);
/*  637 */       checkError(i, -7);
/*      */     }
/*      */     catch (SQLException localSQLException2)
/*      */     {
/*  641 */       int j = localSQLException2.getErrorCode();
/*      */ 
/*  648 */       if (j == 0) {
/*  649 */         throw new XAException(-6);
/*      */       }
/*      */ 
/*  652 */       throw localSQLException2;
/*      */     }
/*      */     finally
/*      */     {
/*      */       try
/*      */       {
/*  658 */         if (localCallableStatement != null)
/*  659 */           localCallableStatement.close();
/*      */       }
/*      */       catch (SQLException localSQLException3) {
/*      */       }
/*  663 */       localCallableStatement = null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public int prepare(Xid paramXid)
/*      */     throws XAException
/*      */   {
/*  693 */     synchronized (this.connection)
/*      */     {
/*  695 */       int i = 0;
/*      */ 
/*  697 */       if (paramXid == null)
/*      */       {
/*  701 */         throw new XAException(-5);
/*      */       }
/*      */ 
/*  705 */       Xid localXid = null;
/*  706 */       if (this.needStackingForCommitRollbackPrepare) {
/*  707 */         localXid = super.suspendStacked(paramXid);
/*      */       }
/*      */       try
/*      */       {
/*      */         try
/*      */         {
/*  713 */           i = doPrepare(paramXid);
/*  714 */           if ((i != 0) && (i != 3))
/*      */           {
/*  722 */             int j = OracleXAException.errorConvert(i);
/*      */ 
/*  724 */             if ((j != 0) && (j != 3))
/*      */             {
/*  726 */               XAException localXAException2 = OracleXAException.newXAException(getConnectionDuringExceptionHandling(), i);
/*  727 */               localXAException2.fillInStackTrace();
/*  728 */               throw localXAException2;
/*      */             }
/*      */ 
/*  731 */             i = j;
/*      */           }
/*      */ 
/*      */         }
/*      */         catch (SQLException localSQLException1)
/*      */         {
/*  737 */           checkError(localSQLException1, -3);
/*      */         }
/*      */       }
/*      */       catch (XAException localXAException1)
/*      */       {
/*  742 */         if (localXAException1.errorCode == -7)
/*      */         {
/*      */           try
/*      */           {
/*  746 */             this.connection.close();
/*      */           }
/*      */           catch (SQLException localSQLException2) {
/*      */           }
/*      */         }
/*  751 */         else if (this.needStackingForCommitRollbackPrepare) {
/*  752 */           super.resumeStacked(localXid);
/*      */         }
/*  754 */         throw localXAException1;
/*      */       }
/*      */ 
/*  758 */       if (this.needStackingForCommitRollbackPrepare) {
/*  759 */         super.resumeStacked(localXid);
/*      */       }
/*  761 */       return i;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected int doPrepare(Xid paramXid)
/*      */     throws XAException, SQLException
/*      */   {
/*  771 */     int i = 0;
/*  772 */     CallableStatement localCallableStatement = null;
/*      */     try
/*      */     {
/*  778 */       localCallableStatement = this.connection.prepareCall(xa_prepare_post_816);
/*      */ 
/*  780 */       localCallableStatement.registerOutParameter(1, 2);
/*  781 */       localCallableStatement.setInt(2, paramXid.getFormatId());
/*  782 */       localCallableStatement.setBytes(3, paramXid.getGlobalTransactionId());
/*  783 */       localCallableStatement.setBytes(4, paramXid.getBranchQualifier());
/*      */ 
/*  785 */       localCallableStatement.execute();
/*      */ 
/*  787 */       i = localCallableStatement.getInt(1);
/*      */     }
/*      */     catch (SQLException localSQLException2)
/*      */     {
/*  793 */       int j = localSQLException2.getErrorCode();
/*      */ 
/*  800 */       if (j == 0) {
/*  801 */         throw new XAException(-6);
/*      */       }
/*      */ 
/*  804 */       throw localSQLException2;
/*      */     }
/*      */     finally
/*      */     {
/*      */       try
/*      */       {
/*  810 */         if (localCallableStatement != null)
/*  811 */           localCallableStatement.close();
/*      */       }
/*      */       catch (SQLException localSQLException3) {
/*      */       }
/*  815 */       localCallableStatement = null;
/*      */     }
/*  817 */     return i;
/*      */   }
/*      */ 
/*      */   public void forget(Xid paramXid)
/*      */     throws XAException
/*      */   {
/*  832 */     synchronized (this.connection)
/*      */     {
/*  841 */       int i = 0;
/*      */ 
/*  843 */       if (paramXid == null)
/*      */       {
/*  847 */         throw new XAException(-5);
/*      */       }
/*      */ 
/*  851 */       removeXidFromList(paramXid);
/*      */       try
/*      */       {
/*  855 */         i = doForget(paramXid);
/*      */       }
/*      */       catch (SQLException localSQLException)
/*      */       {
/*  860 */         checkError(localSQLException, -3);
/*      */       }
/*      */ 
/*  866 */       checkError(i);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected int doForget(Xid paramXid)
/*      */     throws XAException, SQLException
/*      */   {
/*  877 */     int i = 0;
/*  878 */     CallableStatement localCallableStatement = null;
/*      */     try
/*      */     {
/*  884 */       localCallableStatement = this.connection.prepareCall(xa_forget_post_816);
/*      */ 
/*  886 */       localCallableStatement.registerOutParameter(1, 2);
/*  887 */       localCallableStatement.setInt(2, paramXid.getFormatId());
/*  888 */       localCallableStatement.setBytes(3, paramXid.getGlobalTransactionId());
/*  889 */       localCallableStatement.setBytes(4, paramXid.getBranchQualifier());
/*      */ 
/*  891 */       localCallableStatement.execute();
/*      */ 
/*  893 */       i = localCallableStatement.getInt(1);
/*      */     }
/*      */     catch (SQLException localSQLException2)
/*      */     {
/*  897 */       i = localSQLException2.getErrorCode();
/*      */ 
/*  904 */       if (i == 0) {
/*  905 */         throw new XAException(-6);
/*      */       }
/*      */ 
/*  908 */       throw localSQLException2;
/*      */     }
/*      */     finally
/*      */     {
/*      */       try
/*      */       {
/*  914 */         if (localCallableStatement != null)
/*  915 */           localCallableStatement.close();
/*      */       }
/*      */       catch (SQLException localSQLException3) {
/*      */       }
/*  919 */       localCallableStatement = null;
/*      */     }
/*      */ 
/*  922 */     return i;
/*      */   }
/*      */ 
/*      */   public void rollback(Xid paramXid)
/*      */     throws XAException
/*      */   {
/*  945 */     synchronized (this.connection)
/*      */     {
/*  947 */       int i = 0;
/*      */ 
/*  949 */       if (paramXid == null)
/*      */       {
/*  953 */         throw new XAException(-5);
/*      */       }
/*      */ 
/*  957 */       Xid localXid = null;
/*  958 */       if (this.needStackingForCommitRollbackPrepare) {
/*  959 */         localXid = super.suspendStacked(paramXid);
/*      */       }
/*      */       else
/*      */       {
/*  967 */         removeXidFromList(paramXid);
/*      */ 
/*  969 */         if (this.activeXid == null)
/*  970 */           exitGlobalTxnMode();
/*      */       }
/*      */       try
/*      */       {
/*  974 */         doRollback(paramXid);
/*      */       }
/*      */       catch (SQLException localSQLException)
/*      */       {
/*  979 */         checkError(localSQLException, -3);
/*      */       }
/*      */ 
/*  983 */       if (this.needStackingForCommitRollbackPrepare) {
/*  984 */         super.resumeStacked(localXid);
/*      */       }
/*      */ 
/*  989 */       checkError(i);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void doRollback(Xid paramXid)
/*      */     throws XAException, SQLException
/*      */   {
/* 1000 */     CallableStatement localCallableStatement = null;
/*      */     try
/*      */     {
/* 1006 */       localCallableStatement = this.connection.prepareCall(xa_rollback_post_816);
/*      */ 
/* 1008 */       localCallableStatement.registerOutParameter(1, 2);
/* 1009 */       localCallableStatement.setInt(2, paramXid.getFormatId());
/* 1010 */       localCallableStatement.setBytes(3, paramXid.getGlobalTransactionId());
/* 1011 */       localCallableStatement.setBytes(4, paramXid.getBranchQualifier());
/*      */ 
/* 1013 */       localCallableStatement.execute();
/*      */ 
/* 1015 */       int i = localCallableStatement.getInt(1);
/*      */ 
/* 1017 */       checkError(i, -7);
/*      */     }
/*      */     catch (SQLException localSQLException2)
/*      */     {
/* 1021 */       int j = localSQLException2.getErrorCode();
/*      */ 
/* 1025 */       if (j == 0) {
/* 1026 */         throw new XAException(-6);
/*      */       }
/*      */ 
/* 1029 */       throw localSQLException2;
/*      */     }
/*      */     finally
/*      */     {
/*      */       try
/*      */       {
/* 1035 */         if (localCallableStatement != null)
/* 1036 */           localCallableStatement.close();
/*      */       }
/*      */       catch (SQLException localSQLException3) {
/*      */       }
/* 1040 */       localCallableStatement = null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void doTwoPhaseAction(int paramInt1, int paramInt2, String[] paramArrayOfString, Xid[] paramArrayOfXid)
/*      */     throws XAException
/*      */   {
/* 1055 */     synchronized (this.connection)
/*      */     {
/* 1057 */       doDoTwoPhaseAction(paramInt1, paramInt2, paramArrayOfString, paramArrayOfXid);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected int doDoTwoPhaseAction(int paramInt1, int paramInt2, String[] paramArrayOfString, Xid[] paramArrayOfXid)
/*      */     throws XAException
/*      */   {
/* 1067 */     throw new XAException(-6);
/*      */   }
/*      */ 
/*      */   private static byte[] getSerializedBytes(Xid paramXid)
/*      */   {
/*      */     try
/*      */     {
/* 1083 */       return Util.serializeObject(paramXid);
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/*      */     }
/*      */ 
/* 1090 */     return null;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.xa.client.OracleXAResource
 * JD-Core Version:    0.6.2
 */