/*     */ package oracle.jdbc.xa.client;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.sql.Connection;
/*     */ import javax.transaction.xa.XAException;
/*     */ import javax.transaction.xa.Xid;
/*     */ import oracle.jdbc.oracore.Util;
/*     */ 
/*     */ public class OracleXAHeteroResource extends OracleXAResource
/*     */ {
/*  31 */   private int rmid = -1;
/*     */ 
/* 487 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public OracleXAHeteroResource(Connection paramConnection, OracleXAConnection paramOracleXAConnection)
/*     */     throws XAException
/*     */   {
/*  46 */     this.connection = paramConnection;
/*  47 */     this.xaconnection = paramOracleXAConnection;
/*     */ 
/*  49 */     if (this.connection == null)
/*  50 */       throw new XAException(-7);
/*     */   }
/*     */ 
/*     */   public void start(Xid paramXid, int paramInt)
/*     */     throws XAException
/*     */   {
/*  93 */     if (paramXid == null)
/*     */     {
/*  97 */       throw new XAException(-5);
/*     */     }
/*     */ 
/* 101 */     int i = paramInt & 0xFF00;
/*     */ 
/* 103 */     paramInt &= -65281;
/*     */ 
/* 106 */     if ((paramInt & 0x8200002) != paramInt)
/*     */     {
/* 110 */       throw new XAException(-5);
/*     */     }
/*     */ 
/* 114 */     if (((i & 0xFF00) != 0) && (i != 256) && (i != 512) && (i != 1024))
/*     */     {
/* 119 */       throw new XAException(-5);
/*     */     }
/*     */ 
/* 123 */     if (((i & 0xFF00) != 0) && ((paramInt & 0x8200000) != 0))
/*     */     {
/* 128 */       throw new XAException(-5);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 133 */       saveAndAlterAutoCommitModeForGlobalTransaction();
/*     */ 
/* 136 */       paramInt |= i;
/*     */ 
/* 138 */       int j = paramXid.getFormatId();
/* 139 */       byte[] arrayOfByte1 = paramXid.getGlobalTransactionId();
/* 140 */       byte[] arrayOfByte2 = paramXid.getBranchQualifier();
/*     */ 
/* 142 */       int k = t2cDoXaStart(j, arrayOfByte1, arrayOfByte2, this.rmid, paramInt, 0);
/*     */ 
/* 147 */       checkStatus(k);
/* 148 */       enterGlobalTxnMode();
/*     */     }
/*     */     catch (XAException localXAException)
/*     */     {
/* 153 */       restoreAutoCommitModeForGlobalTransaction();
/* 154 */       throw localXAException;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void end(Xid paramXid, int paramInt)
/*     */     throws XAException
/*     */   {
/*     */     try
/*     */     {
/* 193 */       if (paramXid == null)
/*     */       {
/* 197 */         throw new XAException(-5);
/*     */       }
/*     */ 
/* 201 */       int i = 638582786;
/* 202 */       if ((paramInt & i) != paramInt)
/*     */       {
/* 206 */         throw new XAException(-5);
/*     */       }
/*     */ 
/* 209 */       int j = paramXid.getFormatId();
/* 210 */       byte[] arrayOfByte1 = paramXid.getGlobalTransactionId();
/* 211 */       byte[] arrayOfByte2 = paramXid.getBranchQualifier();
/* 212 */       exitGlobalTxnMode();
/*     */ 
/* 215 */       int k = t2cDoXaEnd(j, arrayOfByte1, arrayOfByte2, this.rmid, paramInt, 0);
/*     */ 
/* 220 */       checkStatus(k);
/*     */     }
/*     */     finally
/*     */     {
/* 224 */       restoreAutoCommitModeForGlobalTransaction();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void commit(Xid paramXid, boolean paramBoolean)
/*     */     throws XAException
/*     */   {
/* 255 */     if (paramXid == null)
/*     */     {
/* 259 */       throw new XAException(-5);
/*     */     }
/*     */ 
/* 262 */     int i = paramBoolean ? 1073741824 : 0;
/*     */ 
/* 264 */     int j = paramXid.getFormatId();
/* 265 */     byte[] arrayOfByte1 = paramXid.getGlobalTransactionId();
/* 266 */     byte[] arrayOfByte2 = paramXid.getBranchQualifier();
/*     */ 
/* 268 */     int k = t2cDoXaCommit(j, arrayOfByte1, arrayOfByte2, this.rmid, i, 0);
/*     */ 
/* 273 */     checkStatus(k);
/*     */   }
/*     */ 
/*     */   public int prepare(Xid paramXid)
/*     */     throws XAException
/*     */   {
/* 300 */     if (paramXid == null)
/*     */     {
/* 304 */       throw new XAException(-5);
/*     */     }
/*     */ 
/* 307 */     int i = paramXid.getFormatId();
/* 308 */     byte[] arrayOfByte1 = paramXid.getGlobalTransactionId();
/* 309 */     byte[] arrayOfByte2 = paramXid.getBranchQualifier();
/*     */ 
/* 311 */     int j = t2cDoXaPrepare(i, arrayOfByte1, arrayOfByte2, this.rmid, 0, 0);
/*     */ 
/* 316 */     if ((j != 0) && (j != 3))
/*     */     {
/* 318 */       checkStatus(j);
/*     */     }
/*     */ 
/* 321 */     return j;
/*     */   }
/*     */ 
/*     */   public void forget(Xid paramXid)
/*     */     throws XAException
/*     */   {
/* 343 */     if (paramXid == null)
/*     */     {
/* 347 */       throw new XAException(-5);
/*     */     }
/*     */ 
/* 350 */     int i = paramXid.getFormatId();
/* 351 */     byte[] arrayOfByte1 = paramXid.getGlobalTransactionId();
/* 352 */     byte[] arrayOfByte2 = paramXid.getBranchQualifier();
/*     */ 
/* 354 */     int j = t2cDoXaForget(i, arrayOfByte1, arrayOfByte2, this.rmid, 0, 0);
/*     */ 
/* 359 */     checkStatus(j);
/*     */   }
/*     */ 
/*     */   public void rollback(Xid paramXid)
/*     */     throws XAException
/*     */   {
/* 380 */     if (paramXid == null)
/*     */     {
/* 384 */       throw new XAException(-5);
/*     */     }
/*     */ 
/* 387 */     int i = paramXid.getFormatId();
/* 388 */     byte[] arrayOfByte1 = paramXid.getGlobalTransactionId();
/* 389 */     byte[] arrayOfByte2 = paramXid.getBranchQualifier();
/*     */ 
/* 391 */     int j = t2cDoXaRollback(i, arrayOfByte1, arrayOfByte2, this.rmid, 0, 0);
/*     */ 
/* 396 */     checkStatus(j);
/*     */   }
/*     */ 
/*     */   private native int t2cDoXaStart(int paramInt1, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, int paramInt2, int paramInt3, int paramInt4);
/*     */ 
/*     */   private native int t2cDoXaEnd(int paramInt1, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, int paramInt2, int paramInt3, int paramInt4);
/*     */ 
/*     */   private native int t2cDoXaCommit(int paramInt1, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, int paramInt2, int paramInt3, int paramInt4);
/*     */ 
/*     */   private native int t2cDoXaPrepare(int paramInt1, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, int paramInt2, int paramInt3, int paramInt4);
/*     */ 
/*     */   private native int t2cDoXaForget(int paramInt1, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, int paramInt2, int paramInt3, int paramInt4);
/*     */ 
/*     */   private native int t2cDoXaRollback(int paramInt1, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, int paramInt2, int paramInt3, int paramInt4);
/*     */ 
/*     */   synchronized void setRmid(int paramInt)
/*     */   {
/* 431 */     this.rmid = paramInt;
/*     */   }
/*     */ 
/*     */   synchronized int getRmid()
/*     */   {
/* 446 */     return this.rmid;
/*     */   }
/*     */ 
/*     */   private static byte[] getSerializedBytes(Xid paramXid)
/*     */   {
/*     */     try
/*     */     {
/* 461 */       return Util.serializeObject(paramXid);
/*     */     }
/*     */     catch (IOException localIOException)
/*     */     {
/* 467 */       localIOException.printStackTrace();
/*     */     }
/*     */ 
/* 470 */     return null;
/*     */   }
/*     */ 
/*     */   private void checkStatus(int paramInt)
/*     */     throws XAException
/*     */   {
/* 480 */     if (paramInt != 0)
/* 481 */       throw new XAException(paramInt);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.xa.client.OracleXAHeteroResource
 * JD-Core Version:    0.6.2
 */