/*     */ package oracle.jdbc.xa.client;
/*     */ 
/*     */ import java.sql.Connection;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Properties;
/*     */ import javax.sql.PooledConnection;
/*     */ import javax.sql.XAConnection;
/*     */ import javax.transaction.xa.XAException;
/*     */ import oracle.jdbc.OracleConnection;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.driver.OracleDriver;
/*     */ import oracle.jdbc.driver.T2CConnection;
/*     */ import oracle.jdbc.driver.T4CXAConnection;
/*     */ 
/*     */ public class OracleXADataSource extends oracle.jdbc.xa.OracleXADataSource
/*     */ {
/*     */   private static final boolean DEBUG = false;
/*  44 */   private int rmid = -1;
/*  45 */   private String xaOpenString = null;
/*  46 */   private static boolean libraryLoaded = false;
/*     */   private static final String dbSuffix = "HeteroXA";
/*     */   private static final String dllName = "heteroxa12";
/*     */   private static final char atSignChar = '@';
/*  51 */   private static int rmidSeed = 0;
/*     */   private static final int MAX_RMID_SEED = 65536;
/*  55 */   private String driverCharSetIdString = null;
/*     */ 
/*  59 */   private String oldTnsEntry = null;
/*     */ 
/* 698 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public OracleXADataSource()
/*     */     throws SQLException
/*     */   {
/*  78 */     this.isOracleDataSource = true;
/*     */   }
/*     */ 
/*     */   public XAConnection getXAConnection()
/*     */     throws SQLException
/*     */   {
/* 100 */     Properties localProperties = new Properties(this.connectionProperties);
/*     */ 
/* 103 */     if ((this.user != null) && (this.password != null))
/*     */     {
/* 105 */       localProperties.setProperty("user", this.user);
/* 106 */       localProperties.setProperty("password", this.password);
/*     */     }
/*     */ 
/* 109 */     return getXAConnection(localProperties);
/*     */   }
/*     */ 
/*     */   public XAConnection getXAConnection(String paramString1, String paramString2)
/*     */     throws SQLException
/*     */   {
/* 131 */     Properties localProperties = new Properties(this.connectionProperties);
/* 132 */     if ((paramString1 != null) && (paramString2 != null))
/*     */     {
/* 134 */       localProperties.setProperty("user", paramString1);
/* 135 */       localProperties.setProperty("password", paramString2);
/*     */     }
/*     */     else {
/* 138 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 139 */       localSQLException.fillInStackTrace();
/* 140 */       throw localSQLException;
/*     */     }
/*     */ 
/* 143 */     return getXAConnection(localProperties);
/*     */   }
/*     */ 
/*     */   public XAConnection getXAConnection(Properties paramProperties)
/*     */     throws SQLException
/*     */   {
/* 166 */     if (this.connCachingEnabled)
/*     */     {
/* 169 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 163);
/* 170 */       localSQLException.fillInStackTrace();
/* 171 */       throw localSQLException;
/*     */     }
/*     */ 
/* 174 */     return (XAConnection)getPooledConnection(paramProperties);
/*     */   }
/*     */ 
/*     */   public PooledConnection getPooledConnection(String paramString1, String paramString2)
/*     */     throws SQLException
/*     */   {
/* 200 */     Properties localProperties = new Properties();
/* 201 */     localProperties.setProperty("user", paramString1);
/* 202 */     localProperties.setProperty("password", paramString2);
/*     */ 
/* 204 */     return getPooledConnection(localProperties);
/*     */   }
/*     */ 
/*     */   public PooledConnection getPooledConnection(Properties paramProperties)
/*     */     throws SQLException
/*     */   {
/*     */     try
/*     */     {
/* 233 */       String str1 = getURL();
/* 234 */       String str2 = paramProperties.getProperty("user");
/* 235 */       String str3 = paramProperties.getProperty("password");
/* 236 */       String str4 = null;
/* 237 */       String str5 = null;
/* 238 */       String str6 = null;
/* 239 */       int i = 0;
/*     */ 
/* 244 */       if ((this.useNativeXA) && ((str1.startsWith("jdbc:oracle:oci8")) || (str1.startsWith("jdbc:oracle:oci"))))
/*     */       {
/* 248 */         localObject1 = new long[] { 0L, 0L };
/*     */ 
/* 253 */         String str7 = null;
/* 254 */         String str8 = null;
/*     */ 
/* 256 */         synchronized (this)
/*     */         {
/* 259 */           if (this.tnsEntry != null)
/* 260 */             str7 = this.tnsEntry;
/*     */           else {
/* 262 */             str7 = getTNSEntryFromUrl(str1);
/*     */           }
/*     */ 
/* 265 */           if (((str7 != null) && (str7.length() == 0)) || (str7.startsWith("(DESCRIPTION")))
/*     */           {
/* 270 */             SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 207);
/* 271 */             localSQLException.fillInStackTrace();
/* 272 */             throw localSQLException;
/*     */           }
/*     */ 
/* 276 */           if (!libraryLoaded)
/*     */           {
/* 278 */             synchronized (OracleXADataSource.class)
/*     */             {
/* 280 */               if (!libraryLoaded)
/*     */               {
/*     */                 try
/*     */                 {
/* 284 */                   System.loadLibrary("heteroxa12");
/*     */ 
/* 286 */                   libraryLoaded = true;
/*     */                 }
/*     */                 catch (Error localError)
/*     */                 {
/* 294 */                   libraryLoaded = false;
/*     */ 
/* 296 */                   throw localError;
/*     */                 }
/*     */ 
/*     */               }
/*     */ 
/*     */             }
/*     */ 
/*     */           }
/*     */ 
/* 305 */           if (this.connectionProperties != null)
/*     */           {
/* 307 */             str8 = this.connectionProperties.getProperty("oracle.jdbc.ociNlsLangBackwardCompatible");
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 312 */         if ((str8 != null) && (str8.equalsIgnoreCase("true")))
/*     */         {
/* 319 */           ??? = T2CConnection.getDriverCharSetIdFromNLS_LANG(null);
/* 320 */           this.driverCharSetIdString = Integer.toString(???);
/*     */         }
/* 324 */         else if (!str7.equals(this.oldTnsEntry))
/*     */         {
/* 327 */           ??? = T2CConnection.getClientCharSetId();
/*     */ 
/* 329 */           this.driverCharSetIdString = Integer.toString(???);
/* 330 */           this.oldTnsEntry = str7;
/*     */         }
/*     */ 
/* 334 */         synchronized (this)
/*     */         {
/* 340 */           str4 = new StringBuilder().append(this.databaseName).append("HeteroXA").append(rmidSeed).toString();
/*     */ 
/* 342 */           this.rmid = (i = rmidSeed);
/*     */ 
/* 344 */           synchronized (OracleXADataSource.class)
/*     */           {
/* 346 */             rmidSeed = (rmidSeed + 1) % 65536;
/*     */           }
/*     */ 
/* 349 */           int k = 0;
/*     */ 
/* 364 */           localOracleXAHeteroConnection = this.connectionProperties != null ? this.connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
/*     */ 
/* 369 */           this.xaOpenString = (str6 = generateXAOpenString(str4, str7, str2, str3, 60, 2000, true, true, ".", k, false, (localOracleXAHeteroConnection != null) && (localOracleXAHeteroConnection.equalsIgnoreCase("true")), this.driverCharSetIdString, this.driverCharSetIdString));
/*     */ 
/* 377 */           str5 = generateXACloseString(str4, false);
/*     */         }
/*     */ 
/* 382 */         int j = t2cDoXaOpen(str6, i, 0, 0);
/*     */ 
/* 385 */         if (j != 0)
/*     */         {
/* 388 */           localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), -1 * j);
/* 389 */           ((SQLException)localObject2).fillInStackTrace();
/* 390 */           throw ((Throwable)localObject2);
/*     */         }
/*     */ 
/* 400 */         j = t2cConvertOciHandles(str4, (long[])localObject1);
/*     */ 
/* 402 */         if (j != 0)
/*     */         {
/* 407 */           localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), -1 * j);
/* 408 */           ((SQLException)localObject2).fillInStackTrace();
/* 409 */           throw ((Throwable)localObject2);
/*     */         }
/*     */ 
/* 420 */         paramProperties.put("OCISvcCtxHandle", String.valueOf(localObject1[0]));
/* 421 */         paramProperties.put("OCIEnvHandle", String.valueOf(localObject1[1]));
/* 422 */         paramProperties.put("JDBCDriverCharSetId", this.driverCharSetIdString);
/*     */ 
/* 424 */         if (this.loginTimeout != 0) {
/* 425 */           paramProperties.put("oracle.net.CONNECT_TIMEOUT", new StringBuilder().append("").append(this.loginTimeout * 1000).toString());
/*     */         }
/*     */ 
/* 430 */         Object localObject2 = this.driver.connect(getURL(), paramProperties);
/*     */ 
/* 433 */         ((OracleConnection)localObject2).setStatementCacheSize(this.maxStatements);
/* 434 */         ((OracleConnection)localObject2).setExplicitCachingEnabled(this.explicitCachingEnabled);
/* 435 */         ((OracleConnection)localObject2).setImplicitCachingEnabled(this.implicitCachingEnabled);
/*     */ 
/* 438 */         if ((this.maxStatements > 0) && (!this.explicitCachingEnabled) && (!this.implicitCachingEnabled))
/*     */         {
/* 442 */           ((OracleConnection)localObject2).setImplicitCachingEnabled(true);
/* 443 */           ((OracleConnection)localObject2).setExplicitCachingEnabled(true);
/*     */         }
/*     */ 
/* 448 */         OracleXAHeteroConnection localOracleXAHeteroConnection = new OracleXAHeteroConnection((Connection)localObject2);
/*     */ 
/* 450 */         if ((str2 != null) && (str3 != null))
/* 451 */           localOracleXAHeteroConnection.setUserName(str2, str3);
/* 452 */         localOracleXAHeteroConnection.setRmid(i);
/* 453 */         localOracleXAHeteroConnection.setXaCloseString(str5);
/* 454 */         localOracleXAHeteroConnection.registerCloseCallback(new OracleXAHeteroCloseCallback(), localOracleXAHeteroConnection);
/*     */ 
/* 456 */         return localOracleXAHeteroConnection;
/*     */       }
/* 458 */       if ((this.useNativeXA) && (str1.startsWith("jdbc:oracle:thin")))
/*     */       {
/* 465 */         localObject1 = new Properties();
/* 466 */         synchronized (this)
/*     */         {
/* 468 */           synchronized (OracleXADataSource.class)
/*     */           {
/* 470 */             rmidSeed = (rmidSeed + 1) % 65536;
/*     */ 
/* 472 */             this.rmid = rmidSeed;
/*     */           }
/*     */ 
/* 476 */           if (this.connectionProperties == null) {
/* 477 */             this.connectionProperties = new Properties();
/*     */           }
/* 479 */           this.connectionProperties.put("RessourceManagerId", Integer.toString(this.rmid));
/* 480 */           if (str2 != null)
/* 481 */             ((Properties)localObject1).setProperty("user", str2);
/* 482 */           if (str3 != null)
/* 483 */             ((Properties)localObject1).setProperty("password", str3);
/* 484 */           ((Properties)localObject1).setProperty("stmt_cache_size", new StringBuilder().append("").append(this.maxStatements).toString());
/*     */ 
/* 486 */           ((Properties)localObject1).setProperty("ImplicitStatementCachingEnabled", new StringBuilder().append("").append(this.implicitCachingEnabled).toString());
/*     */ 
/* 489 */           ((Properties)localObject1).setProperty("ExplicitStatementCachingEnabled", new StringBuilder().append("").append(this.explicitCachingEnabled).toString());
/*     */ 
/* 492 */           if (this.loginTimeout != 0)
/*     */           {
/* 494 */             ((Properties)localObject1).setProperty("LoginTimeout", new StringBuilder().append("").append(this.loginTimeout).toString());
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 500 */         ??? = new T4CXAConnection(super.getPhysicalConnection((Properties)localObject1));
/*     */ 
/* 506 */         if ((str2 != null) && (str3 != null)) {
/* 507 */           ((T4CXAConnection)???).setUserName(str2, str3);
/*     */         }
/* 509 */         ??? = this.connectionProperties != null ? this.connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
/*     */ 
/* 514 */         ((OracleXAConnection)???).isXAResourceTransLoose = ((??? != null) && ((((String)???).equals("true")) || (((String)???).equalsIgnoreCase("true"))));
/*     */ 
/* 517 */         return ???;
/*     */       }
/*     */ 
/* 523 */       Object localObject1 = new Properties();
/* 524 */       synchronized (this)
/*     */       {
/* 526 */         if (str2 != null)
/* 527 */           ((Properties)localObject1).setProperty("user", str2);
/* 528 */         if (str3 != null)
/* 529 */           ((Properties)localObject1).setProperty("password", str3);
/* 530 */         ((Properties)localObject1).setProperty("stmt_cache_size", new StringBuilder().append("").append(this.maxStatements).toString());
/*     */ 
/* 532 */         ((Properties)localObject1).setProperty("ImplicitStatementCachingEnabled", new StringBuilder().append("").append(this.implicitCachingEnabled).toString());
/*     */ 
/* 535 */         ((Properties)localObject1).setProperty("ExplicitStatementCachingEnabled", new StringBuilder().append("").append(this.explicitCachingEnabled).toString());
/*     */ 
/* 538 */         if (this.loginTimeout != 0)
/*     */         {
/* 540 */           ((Properties)localObject1).setProperty("LoginTimeout", new StringBuilder().append("").append(this.loginTimeout).toString());
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 546 */       ??? = new OracleXAConnection(super.getPhysicalConnection((Properties)localObject1));
/*     */ 
/* 551 */       if ((str2 != null) && (str3 != null)) {
/* 552 */         ((OracleXAConnection)???).setUserName(str2, str3);
/*     */       }
/* 554 */       ??? = this.connectionProperties != null ? this.connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
/*     */ 
/* 559 */       ((OracleXAConnection)???).isXAResourceTransLoose = ((??? != null) && ((((String)???).equals("true")) || (((String)???).equalsIgnoreCase("true"))));
/*     */ 
/* 563 */       return ???;
/*     */     }
/*     */     catch (XAException localXAException)
/*     */     {
/*     */     }
/*     */ 
/* 573 */     return null;
/*     */   }
/*     */ 
/*     */   private native int t2cDoXaOpen(String paramString, int paramInt1, int paramInt2, int paramInt3);
/*     */ 
/*     */   private native int t2cConvertOciHandles(String paramString, long[] paramArrayOfLong);
/*     */ 
/*     */   synchronized void setRmid(int paramInt)
/*     */   {
/* 598 */     this.rmid = paramInt;
/*     */   }
/*     */ 
/*     */   synchronized int getRmid()
/*     */   {
/* 613 */     return this.rmid;
/*     */   }
/*     */ 
/*     */   synchronized void setXaOpenString(String paramString)
/*     */   {
/* 629 */     this.xaOpenString = paramString;
/*     */   }
/*     */ 
/*     */   synchronized String getXaOpenString()
/*     */   {
/* 644 */     return this.xaOpenString;
/*     */   }
/*     */ 
/*     */   private String generateXAOpenString(String paramString1, String paramString2, String paramString3, String paramString4, int paramInt1, int paramInt2, boolean paramBoolean1, boolean paramBoolean2, String paramString5, int paramInt3, boolean paramBoolean3, boolean paramBoolean4, String paramString6, String paramString7)
/*     */   {
/* 666 */     return new StringBuilder().append("ORACLE_XA+DB=").append(paramString1).append("+ACC=P/").append(paramString3).append("/").append(paramString4).append("+SESTM=").append(paramInt2).append("+SESWT=").append(paramInt1).append("+LOGDIR=").append(paramString5).append("+SQLNET=").append(paramString2).append(paramBoolean1 ? "+THREADS=true" : "").append(paramBoolean2 ? "+OBJECTS=true" : "").append("+DBGFL=0x").append(paramInt3).append(paramBoolean3 ? "+CONNCACHE=t" : "+CONNCACHE=f").append(paramBoolean4 ? "+Loose_Coupling=t" : "").append("+CharSet=").append(paramString6).append("+NCharSet=").append(paramString7).toString();
/*     */   }
/*     */ 
/*     */   private String generateXACloseString(String paramString, boolean paramBoolean)
/*     */   {
/* 682 */     return new StringBuilder().append("ORACLE_XA+DB=").append(paramString).append(paramBoolean ? "+CONNCACHE=t" : "+CONNCACHE=f").toString();
/*     */   }
/*     */ 
/*     */   private String getTNSEntryFromUrl(String paramString)
/*     */   {
/* 691 */     int i = paramString.indexOf('@');
/*     */ 
/* 693 */     return paramString.substring(i + 1);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.xa.client.OracleXADataSource
 * JD-Core Version:    0.6.2
 */