/*     */ package oracle.jdbc.xa;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import javax.transaction.xa.XAException;
/*     */ import javax.transaction.xa.Xid;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ 
/*     */ public class OracleXid
/*     */   implements Xid, Serializable
/*     */ {
/*     */   private int formatId;
/*  37 */   private byte[] gtrid = null;
/*  38 */   private byte[] bqual = null;
/*  39 */   private byte[] txctx = null;
/*     */   public static final int MAXGTRIDSIZE = 64;
/*     */   public static final int MAXBQUALSIZE = 64;
/*     */   private int state;
/* 374 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public OracleXid(int paramInt, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2)
/*     */     throws XAException
/*     */   {
/*  62 */     this(paramInt, paramArrayOfByte1, paramArrayOfByte2, null);
/*     */   }
/*     */ 
/*     */   public OracleXid(int paramInt, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, byte[] paramArrayOfByte3)
/*     */     throws XAException
/*     */   {
/*  96 */     this.formatId = paramInt;
/*     */ 
/*  98 */     if ((paramArrayOfByte1 != null) && (paramArrayOfByte1.length > 64)) {
/*  99 */       throw new XAException(-4);
/*     */     }
/* 101 */     this.gtrid = paramArrayOfByte1;
/*     */ 
/* 103 */     if ((paramArrayOfByte2 != null) && (paramArrayOfByte2.length > 64)) {
/* 104 */       throw new XAException(-4);
/*     */     }
/* 106 */     this.bqual = paramArrayOfByte2;
/* 107 */     this.txctx = paramArrayOfByte3;
/* 108 */     this.state = 0;
/*     */   }
/*     */ 
/*     */   public void setState(int paramInt)
/*     */   {
/* 127 */     this.state = paramInt;
/*     */   }
/*     */ 
/*     */   public int getState()
/*     */   {
/* 145 */     return this.state;
/*     */   }
/*     */ 
/*     */   public int getFormatId()
/*     */   {
/* 164 */     return this.formatId;
/*     */   }
/*     */ 
/*     */   public byte[] getGlobalTransactionId()
/*     */   {
/* 184 */     return this.gtrid;
/*     */   }
/*     */ 
/*     */   public byte[] getBranchQualifier()
/*     */   {
/* 203 */     return this.bqual;
/*     */   }
/*     */ 
/*     */   public byte[] getTxContext()
/*     */   {
/* 220 */     return this.txctx;
/*     */   }
/*     */ 
/*     */   public void setTxContext(byte[] paramArrayOfByte)
/*     */   {
/* 255 */     this.txctx = paramArrayOfByte;
/*     */   }
/*     */ 
/*     */   public static final boolean isLocalTransaction(Xid paramXid)
/*     */   {
/* 267 */     byte[] arrayOfByte = paramXid.getGlobalTransactionId();
/*     */ 
/* 269 */     if (arrayOfByte == null) {
/* 270 */       return true;
/*     */     }
/* 272 */     for (int i = 0; i < arrayOfByte.length; i++)
/*     */     {
/* 274 */       if (arrayOfByte[i] != 0) {
/* 275 */         return false;
/*     */       }
/*     */     }
/* 278 */     return true;
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 369 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.xa.OracleXid
 * JD-Core Version:    0.6.2
 */