/*      */ package oracle.jdbc.xa;
/*      */ 
/*      */ import java.sql.Connection;
/*      */ import java.sql.ResultSet;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.Statement;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Hashtable;
/*      */ import javax.transaction.xa.XAException;
/*      */ import javax.transaction.xa.XAResource;
/*      */ import javax.transaction.xa.Xid;
/*      */ import oracle.jdbc.internal.OracleConnection;
/*      */ 
/*      */ public abstract class OracleXAResource
/*      */   implements XAResource
/*      */ {
/*      */   public static final int XA_OK = 0;
/*      */   public static final short DEFAULT_XA_TIMEOUT = 60;
/*   39 */   protected boolean savedConnectionAutoCommit = false;
/*   40 */   protected boolean savedXAConnectionAutoCommit = false;
/*      */   public static final int TMNOFLAGS = 0;
/*      */   public static final int TMNOMIGRATE = 2;
/*      */   public static final int TMENDRSCAN = 8388608;
/*      */   public static final int TMFAIL = 536870912;
/*      */   public static final int TMMIGRATE = 1048576;
/*      */   public static final int TMJOIN = 2097152;
/*      */   public static final int TMONEPHASE = 1073741824;
/*      */   public static final int TMRESUME = 134217728;
/*      */   public static final int TMSTARTRSCAN = 16777216;
/*      */   public static final int TMSUCCESS = 67108864;
/*      */   public static final int TMSUSPEND = 33554432;
/*      */   public static final int ORATMREADONLY = 256;
/*      */   public static final int ORATMREADWRITE = 512;
/*      */   public static final int ORATMSERIALIZABLE = 1024;
/*      */   public static final int ORAISOLATIONMASK = 65280;
/*      */   public static final int ORATRANSLOOSE = 65536;
/*   79 */   protected Connection connection = null;
/*   80 */   protected OracleXAConnection xaconnection = null;
/*   81 */   protected int timeout = 60;
/*   82 */   protected String dblink = null;
/*      */ 
/*   85 */   private Connection logicalConnection = null;
/*      */ 
/*   93 */   private String synchronizeBeforeRecoverNewCall = "BEGIN sys.dbms_xa.dist_txn_sync \n; END;";
/*      */ 
/*   96 */   private String synchronizeBeforeRecoverOldCall = "BEGIN sys.dbms_system.dist_txn_sync(0) \n; END;";
/*      */ 
/*  100 */   private String recoverySqlRows = "SELECT formatid, globalid, branchid FROM SYS.DBA_PENDING_TRANSACTIONS";
/*      */ 
/*  106 */   protected boolean canBeMigratablySuspended = false;
/*      */ 
/*  109 */   private boolean isTMRScanStarted = false;
/*      */ 
/*  111 */   private static final Xid[] NO_XID = new Xid[0];
/*      */ 
/*  207 */   Xid lastActiveXid = null;
/*      */ 
/*  210 */   protected Xid activeXid = null;
/*      */ 
/*  212 */   protected Hashtable<Xid, XidListEntry> xidHash = new Hashtable(50);
/*      */ 
/* 1235 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   public OracleXAResource()
/*      */   {
/*      */   }
/*      */ 
/*      */   public OracleXAResource(Connection paramConnection, OracleXAConnection paramOracleXAConnection)
/*      */     throws XAException
/*      */   {
/*  143 */     this.connection = paramConnection;
/*  144 */     this.xaconnection = paramOracleXAConnection;
/*      */ 
/*  146 */     if (this.connection == null)
/*  147 */       throw new XAException(-7);
/*      */   }
/*      */ 
/*      */   public synchronized void setConnection(Connection paramConnection)
/*      */     throws XAException
/*      */   {
/*  166 */     this.connection = paramConnection;
/*      */ 
/*  168 */     if (this.connection == null)
/*  169 */       throw new XAException(-7);
/*      */   }
/*      */ 
/*      */   final synchronized XidListEntry getMatchingXidListEntry(Xid paramXid)
/*      */   {
/*  231 */     XidListEntry localXidListEntry = (XidListEntry)this.xidHash.get(paramXid);
/*      */ 
/*  233 */     return localXidListEntry;
/*      */   }
/*      */ 
/*      */   protected final synchronized boolean removeXidFromList(Xid paramXid)
/*      */   {
/*  241 */     if (isSameXid(this.activeXid, paramXid)) {
/*  242 */       this.activeXid = null;
/*      */     }
/*  244 */     return this.xidHash.remove(paramXid) != null;
/*      */   }
/*      */ 
/*      */   final boolean isSameXid(Xid paramXid1, Xid paramXid2)
/*      */   {
/*  253 */     return paramXid1 == paramXid2;
/*      */   }
/*      */ 
/*      */   protected final boolean isOnStack(Xid paramXid)
/*      */     throws XAException
/*      */   {
/*  262 */     return this.xidHash.containsKey(paramXid);
/*      */   }
/*      */ 
/*      */   protected final synchronized boolean isXidListEmpty()
/*      */   {
/*  271 */     return this.xidHash.isEmpty();
/*      */   }
/*      */ 
/*      */   protected synchronized void createOrUpdateXid(Xid paramXid, boolean paramBoolean, boolean[] paramArrayOfBoolean)
/*      */   {
/*  293 */     XidListEntry localXidListEntry = getMatchingXidListEntry(paramXid);
/*      */ 
/*  295 */     if (localXidListEntry != null)
/*      */     {
/*  301 */       paramArrayOfBoolean[0] = true;
/*      */ 
/*  305 */       localXidListEntry.isSuspended = paramBoolean;
/*      */     }
/*      */     else
/*      */     {
/*  309 */       localXidListEntry = new XidListEntry(paramXid, paramBoolean);
/*  310 */       this.xidHash.put(paramXid, localXidListEntry);
/*      */     }
/*      */ 
/*  313 */     if (paramBoolean)
/*      */     {
/*  316 */       this.lastActiveXid = this.activeXid;
/*  317 */       this.activeXid = null;
/*      */     }
/*      */     else
/*      */     {
/*  322 */       enterGlobalTxnMode();
/*      */ 
/*  327 */       if ((this.lastActiveXid != null) && (isSameXid(paramXid, this.lastActiveXid))) {
/*  328 */         this.lastActiveXid = null;
/*      */       }
/*  330 */       this.activeXid = localXidListEntry.xid;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected synchronized boolean updateXidList(Xid paramXid, boolean[] paramArrayOfBoolean)
/*      */   {
/*  357 */     boolean bool = false;
/*  358 */     XidListEntry localXidListEntry = getMatchingXidListEntry(paramXid);
/*  359 */     if (localXidListEntry != null)
/*      */     {
/*  361 */       bool = true;
/*  362 */       paramArrayOfBoolean[0] = true;
/*  363 */       paramArrayOfBoolean[1] = localXidListEntry.isSuspended;
/*      */ 
/*  370 */       if (localXidListEntry.isSuspended)
/*      */       {
/*  372 */         enterGlobalTxnMode();
/*      */       }
/*      */       else
/*      */       {
/*  376 */         exitGlobalTxnMode();
/*      */       }
/*      */     }
/*      */ 
/*  380 */     return bool;
/*      */   }
/*      */ 
/*      */   protected boolean isXidSuspended(Xid paramXid)
/*      */     throws XAException
/*      */   {
/*  395 */     boolean bool = false;
/*  396 */     XidListEntry localXidListEntry = getMatchingXidListEntry(paramXid);
/*      */ 
/*  398 */     if (localXidListEntry != null) {
/*  399 */       bool = localXidListEntry.isSuspended;
/*      */     }
/*  401 */     return bool;
/*      */   }
/*      */ 
/*      */   protected Xid suspendStacked(Xid paramXid)
/*      */     throws XAException
/*      */   {
/*  427 */     Xid localXid = null;
/*      */ 
/*  429 */     if ((this.activeXid != null) && (!isSameXid(this.activeXid, paramXid)))
/*      */     {
/*  434 */       localXid = this.activeXid;
/*      */ 
/*  438 */       if (!isXidSuspended(this.activeXid))
/*      */       {
/*  440 */         end(this.activeXid, 33554432);
/*  441 */         this.lastActiveXid = this.activeXid;
/*  442 */         this.activeXid = null;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  447 */     return localXid;
/*      */   }
/*      */ 
/*      */   protected void resumeStacked(Xid paramXid)
/*      */     throws XAException
/*      */   {
/*  467 */     if (paramXid != null)
/*      */     {
/*  471 */       start(paramXid, 134217728);
/*  472 */       this.activeXid = paramXid;
/*      */     }
/*      */   }
/*      */ 
/*      */   public abstract void start(Xid paramXid, int paramInt)
/*      */     throws XAException;
/*      */ 
/*      */   public abstract void end(Xid paramXid, int paramInt)
/*      */     throws XAException;
/*      */ 
/*      */   public abstract void commit(Xid paramXid, boolean paramBoolean)
/*      */     throws XAException;
/*      */ 
/*      */   public abstract int prepare(Xid paramXid)
/*      */     throws XAException;
/*      */ 
/*      */   public abstract void forget(Xid paramXid)
/*      */     throws XAException;
/*      */ 
/*      */   public abstract void rollback(Xid paramXid)
/*      */     throws XAException;
/*      */ 
/*      */   public Xid[] recover(int paramInt)
/*      */     throws XAException
/*      */   {
/*  664 */     synchronized (this.connection)
/*      */     {
/*  672 */       if ((paramInt & 0x1800000) != paramInt)
/*      */       {
/*  676 */         throw new XAException(-5);
/*      */       }
/*      */ 
/*  679 */       if (paramInt == 16777216) {
/*  680 */         this.isTMRScanStarted = true; } else {
/*  681 */         if ((this.isTMRScanStarted) && (paramInt == 8388608))
/*      */         {
/*  683 */           this.isTMRScanStarted = false;
/*  684 */           return NO_XID;
/*      */         }
/*  686 */         if ((this.isTMRScanStarted) && (paramInt == 0))
/*  687 */           return NO_XID;
/*      */       }
/*  689 */       Statement localStatement = null;
/*  690 */       ResultSet localResultSet = null;
/*  691 */       ArrayList localArrayList = new ArrayList(50);
/*      */       try
/*      */       {
/*  695 */         localStatement = this.connection.createStatement();
/*      */         try
/*      */         {
/*  700 */           localStatement.execute(this.synchronizeBeforeRecoverNewCall);
/*      */         }
/*      */         catch (Exception localException1)
/*      */         {
/*  707 */           localStatement.execute(this.synchronizeBeforeRecoverOldCall);
/*      */         }
/*      */ 
/*  711 */         localResultSet = localStatement.executeQuery(this.recoverySqlRows);
/*      */ 
/*  713 */         while (localResultSet.next())
/*      */         {
/*  715 */           localArrayList.add(new OracleXid(localResultSet.getInt(1), localResultSet.getBytes(2), localResultSet.getBytes(3)));
/*      */         }
/*      */ 
/*      */       }
/*      */       catch (SQLException localSQLException)
/*      */       {
/*  727 */         throw new XAException(-3);
/*      */       }
/*      */       finally
/*      */       {
/*      */         try
/*      */         {
/*  733 */           if (localStatement != null) {
/*  734 */             localStatement.close();
/*      */           }
/*  736 */           if (localResultSet != null)
/*  737 */             localResultSet.close();
/*      */         }
/*      */         catch (Exception localException3) {
/*      */         }
/*      */       }
/*  742 */       int i = localArrayList.size();
/*  743 */       Xid[] arrayOfXid = new Xid[i];
/*  744 */       System.arraycopy(localArrayList.toArray(), 0, arrayOfXid, 0, i);
/*      */ 
/*  746 */       return arrayOfXid;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void restoreAutoCommitModeForGlobalTransaction()
/*      */     throws XAException
/*      */   {
/*  765 */     if ((this.savedConnectionAutoCommit) && (((OracleConnection)this.connection).getTxnMode() != 1))
/*      */     {
/*      */       try
/*      */       {
/*  771 */         this.connection.setAutoCommit(this.savedConnectionAutoCommit);
/*  772 */         this.xaconnection.setAutoCommit(this.savedXAConnectionAutoCommit);
/*      */       }
/*      */       catch (SQLException localSQLException)
/*      */       {
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void saveAndAlterAutoCommitModeForGlobalTransaction()
/*      */     throws XAException
/*      */   {
/*  794 */     if (((OracleConnection)this.connection).getTxnMode() != 1)
/*      */     {
/*      */       try
/*      */       {
/*  799 */         this.savedConnectionAutoCommit = this.connection.getAutoCommit();
/*  800 */         this.connection.setAutoCommit(false);
/*  801 */         this.savedXAConnectionAutoCommit = this.xaconnection.getAutoCommit();
/*  802 */         this.xaconnection.setAutoCommit(false);
/*      */       }
/*      */       catch (SQLException localSQLException)
/*      */       {
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void resume(Xid paramXid)
/*      */     throws XAException
/*      */   {
/*  829 */     start(paramXid, 134217728);
/*      */   }
/*      */ 
/*      */   public void join(Xid paramXid)
/*      */     throws XAException
/*      */   {
/*  851 */     start(paramXid, 2097152);
/*      */   }
/*      */ 
/*      */   public void suspend(Xid paramXid)
/*      */     throws XAException
/*      */   {
/*  872 */     end(paramXid, 33554432);
/*      */   }
/*      */ 
/*      */   public void join(Xid paramXid, int paramInt)
/*      */     throws XAException
/*      */   {
/*  895 */     this.timeout = paramInt;
/*      */ 
/*  897 */     start(paramXid, 2097152);
/*      */   }
/*      */ 
/*      */   public void resume(Xid paramXid, int paramInt)
/*      */     throws XAException
/*      */   {
/*  920 */     this.timeout = paramInt;
/*      */ 
/*  922 */     start(paramXid, 134217728);
/*      */   }
/*      */ 
/*      */   public Connection getConnection()
/*      */   {
/*  942 */     return this.connection;
/*      */   }
/*      */ 
/*      */   public int getTransactionTimeout()
/*      */     throws XAException
/*      */   {
/*  966 */     return this.timeout;
/*      */   }
/*      */ 
/*      */   public boolean isSameRM(XAResource paramXAResource)
/*      */     throws XAException
/*      */   {
/*  992 */     Connection localConnection = null;
/*      */ 
/*  995 */     if ((paramXAResource instanceof OracleXAResource)) {
/*  996 */       localConnection = ((OracleXAResource)paramXAResource).getConnection();
/*      */     }
/*      */     else {
/*  999 */       return false;
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/* 1004 */       if ((this.connection == null) || (((OracleConnection)this.connection).isClosed())) {
/* 1005 */         return false;
/*      */       }
/* 1007 */       String str1 = ((OracleConnection)this.connection).getURL();
/* 1008 */       String str2 = ((OracleConnection)this.connection).getProtocolType();
/*      */ 
/* 1010 */       if (localConnection != null)
/*      */       {
/* 1012 */         return (localConnection.equals(this.connection)) || (((OracleConnection)localConnection).getURL().equals(str1)) || ((((OracleConnection)localConnection).getProtocolType().equals(str2)) && (str2.equals("kprb")));
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/* 1028 */       throw new XAException(-3);
/*      */     }
/*      */ 
/* 1032 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean setTransactionTimeout(int paramInt)
/*      */     throws XAException
/*      */   {
/* 1060 */     if (paramInt < 0) {
/* 1061 */       throw new XAException(-5);
/*      */     }
/* 1063 */     this.timeout = paramInt;
/*      */ 
/* 1065 */     return true;
/*      */   }
/*      */ 
/*      */   public String getDBLink()
/*      */   {
/* 1084 */     return this.dblink;
/*      */   }
/*      */ 
/*      */   public void setDBLink(String paramString)
/*      */   {
/* 1104 */     this.dblink = paramString;
/*      */   }
/*      */ 
/*      */   public void setLogicalConnection(Connection paramConnection)
/*      */   {
/* 1124 */     this.logicalConnection = paramConnection;
/*      */   }
/*      */ 
/*      */   protected void allowGlobalTxnModeOnly(int paramInt)
/*      */     throws XAException
/*      */   {
/* 1150 */     if (((OracleConnection)this.connection).getTxnMode() != 1)
/*      */     {
/* 1152 */       throw new XAException(paramInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void exitGlobalTxnMode()
/*      */   {
/* 1164 */     ((OracleConnection)this.connection).setTxnMode(0);
/*      */   }
/*      */ 
/*      */   protected void enterGlobalTxnMode()
/*      */   {
/* 1176 */     ((OracleConnection)this.connection).setTxnMode(1);
/*      */   }
/*      */ 
/*      */   protected void checkError(int paramInt)
/*      */     throws XAException
/*      */   {
/* 1185 */     if ((paramInt & 0xFFFF) != 0)
/*      */     {
/* 1187 */       XAException localXAException = OracleXAException.newXAException(getConnectionDuringExceptionHandling(), paramInt);
/* 1188 */       localXAException.fillInStackTrace();
/* 1189 */       throw localXAException;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void checkError(int paramInt1, int paramInt2)
/*      */     throws XAException
/*      */   {
/* 1199 */     if ((paramInt1 & 0xFFFF) != 0)
/*      */     {
/* 1201 */       XAException localXAException = OracleXAException.newXAException(getConnectionDuringExceptionHandling(), paramInt1, paramInt2);
/* 1202 */       localXAException.fillInStackTrace();
/* 1203 */       throw localXAException;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void checkError(SQLException paramSQLException, int paramInt)
/*      */     throws XAException
/*      */   {
/* 1212 */     XAException localXAException = OracleXAException.newXAException(getConnectionDuringExceptionHandling(), paramSQLException, paramInt);
/* 1213 */     localXAException.fillInStackTrace();
/* 1214 */     throw localXAException;
/*      */   }
/*      */ 
/*      */   protected OracleConnection getConnectionDuringExceptionHandling()
/*      */   {
/* 1230 */     return (OracleConnection)this.connection;
/*      */   }
/*      */ 
/*      */   class XidListEntry
/*      */   {
/*      */     Xid xid;
/*      */     boolean isSuspended;
/*      */ 
/*      */     XidListEntry(Xid paramBoolean, boolean arg3)
/*      */     {
/*  222 */       this.xid = paramBoolean;
/*      */       boolean bool;
/*  223 */       this.isSuspended = bool;
/*      */     }
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.xa.OracleXAResource
 * JD-Core Version:    0.6.2
 */