/*     */ package oracle.jdbc.xa;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import javax.transaction.xa.XAException;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ 
/*     */ public class OracleXAException extends XAException
/*     */ {
/*  27 */   private int xaError = 0;
/*  28 */   private int primary = 0;
/*  29 */   private int secondary = 0;
/*     */ 
/* 410 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public OracleXAException()
/*     */   {
/*     */   }
/*     */ 
/*     */   public OracleXAException(int paramInt)
/*     */   {
/*  44 */     super(errorConvert(paramInt));
/*     */ 
/*  53 */     this.xaError = errorConvert(paramInt);
/*  54 */     this.primary = (paramInt & 0xFFFF);
/*  55 */     this.secondary = (paramInt >> 16);
/*     */   }
/*     */ 
/*     */   public OracleXAException(int paramInt1, int paramInt2)
/*     */   {
/*  62 */     super(errorConvert(paramInt1, paramInt2));
/*     */ 
/*  71 */     this.xaError = errorConvert(paramInt1, paramInt2);
/*  72 */     this.primary = (paramInt1 & 0xFFFF);
/*  73 */     this.secondary = (paramInt1 >> 16);
/*     */   }
/*     */ 
/*     */   public OracleXAException(SQLException paramSQLException, int paramInt)
/*     */   {
/*  81 */     this(paramSQLException.getErrorCode(), paramInt);
/*  82 */     initCause(paramSQLException);
/*     */   }
/*     */ 
/*     */   public static XAException newXAException(OracleConnection paramOracleConnection, int paramInt)
/*     */   {
/*  97 */     OracleXAException localOracleXAException = new OracleXAException(paramInt);
/*     */ 
/*  99 */     int i = localOracleXAException.getXAError();
/* 100 */     if (i == -7)
/*     */     {
/* 102 */       if (paramOracleConnection != null)
/*     */       {
/* 104 */         paramOracleConnection.setUsable(false);
/*     */       }
/*     */     }
/*     */ 
/* 108 */     return localOracleXAException;
/*     */   }
/*     */ 
/*     */   public static XAException newXAException(OracleConnection paramOracleConnection, int paramInt1, int paramInt2)
/*     */   {
/* 126 */     OracleXAException localOracleXAException = new OracleXAException(paramInt1, paramInt2);
/*     */ 
/* 128 */     int i = localOracleXAException.getXAError();
/* 129 */     if (i == -7)
/*     */     {
/* 131 */       if (paramOracleConnection != null)
/*     */       {
/* 133 */         paramOracleConnection.setUsable(false);
/*     */       }
/*     */     }
/*     */ 
/* 137 */     return localOracleXAException;
/*     */   }
/*     */ 
/*     */   public static XAException newXAException(OracleConnection paramOracleConnection, SQLException paramSQLException, int paramInt)
/*     */   {
/* 155 */     OracleXAException localOracleXAException = new OracleXAException(paramSQLException, paramInt);
/*     */ 
/* 157 */     int i = localOracleXAException.getXAError();
/* 158 */     if (i == -7)
/*     */     {
/* 160 */       if (paramOracleConnection != null)
/*     */       {
/* 162 */         paramOracleConnection.setUsable(false);
/*     */       }
/*     */     }
/*     */ 
/* 166 */     return localOracleXAException;
/*     */   }
/*     */ 
/*     */   public static int errorConvert(int paramInt)
/*     */   {
/* 177 */     return errorConvert(paramInt, -3);
/*     */   }
/*     */ 
/*     */   public static int errorConvert(int paramInt1, int paramInt2)
/*     */   {
/* 185 */     switch (paramInt1 & 0xFFFF)
/*     */     {
/*     */     case 24756:
/* 189 */       return -4;
/*     */     case 25351:
/*     */     case 30006:
/* 193 */       return 4;
/*     */     case 24764:
/* 196 */       return 7;
/*     */     case 24765:
/* 199 */       return 6;
/*     */     case 24766:
/* 202 */       return 5;
/*     */     case 24767:
/* 205 */       return 3;
/*     */     case 28:
/*     */     case 1031:
/*     */     case 1033:
/*     */     case 1034:
/*     */     case 1041:
/*     */     case 1089:
/*     */     case 1090:
/*     */     case 1092:
/*     */     case 3113:
/*     */     case 3114:
/*     */     case 12571:
/*     */     case 17002:
/*     */     case 17008:
/*     */     case 17410:
/*     */     case 24796:
/*     */     case 25400:
/*     */     case 25401:
/*     */     case 25402:
/*     */     case 25403:
/*     */     case 25404:
/*     */     case 25405:
/*     */     case 25406:
/*     */     case 25407:
/*     */     case 25408:
/*     */     case 25409:
/* 232 */       return -7;
/*     */     case 2056:
/*     */     case 17448:
/*     */     case 24763:
/*     */     case 24768:
/*     */     case 24769:
/*     */     case 24770:
/*     */     case 24775:
/*     */     case 24776:
/* 244 */       return -6;
/*     */     case 2091:
/*     */     case 2092:
/*     */     case 24761:
/* 249 */       return 100;
/*     */     case 24780:
/* 253 */       return -3;
/*     */     }
/*     */ 
/* 256 */     return paramInt2;
/*     */   }
/*     */ 
/*     */   public int getXAError()
/*     */   {
/* 278 */     return this.xaError;
/*     */   }
/*     */ 
/*     */   public int getOracleError()
/*     */   {
/* 298 */     return this.primary;
/*     */   }
/*     */ 
/*     */   public int getOracleSQLError()
/*     */   {
/* 319 */     return this.secondary;
/*     */   }
/*     */ 
/*     */   public static String getXAErrorMessage(int paramInt)
/*     */   {
/* 328 */     switch (paramInt)
/*     */     {
/*     */     case 7:
/* 332 */       return "The transaction branch has been heuristically committed.";
/*     */     case 8:
/* 335 */       return "The transaction branch may have been heuristically completed.";
/*     */     case 5:
/* 338 */       return "The transaction branch has been heuristically committed and rolled back.";
/*     */     case 6:
/* 342 */       return "The transaction branch has been heuristically rolled back.";
/*     */     case 9:
/* 345 */       return "Resumption must occur where suspension occured.";
/*     */     case 100:
/* 348 */       return "The inclusive lower bound oof the rollback codes.";
/*     */     case 101:
/* 351 */       return "Rollback was caused by communication failure.";
/*     */     case 102:
/* 354 */       return "A deadlock was detected.";
/*     */     case 107:
/* 357 */       return "The inclusive upper bound of the rollback error code.";
/*     */     case 103:
/* 360 */       return "A condition that violates the integrity of the resource was detected.";
/*     */     case 104:
/* 364 */       return "The resource manager rolled back the transaction branch for a reason not on this list.";
/*     */     case 105:
/* 368 */       return "A protocol error occured in the resource manager.";
/*     */     case 106:
/* 371 */       return "A transaction branch took too long.";
/*     */     case 3:
/* 374 */       return "The transaction branch has been read-only and has been committed.";
/*     */     case 4:
/* 377 */       return "Routine returned with no effect and may be reissued.";
/*     */     case -2:
/* 380 */       return "Asynchronous operation already outstanding.";
/*     */     case -8:
/* 383 */       return "The XID already exists.";
/*     */     case -5:
/* 386 */       return "Invalid arguments were given.";
/*     */     case -4:
/* 389 */       return "The XID is not valid.";
/*     */     case -9:
/* 392 */       return "The resource manager is doing work outside global transaction.";
/*     */     case -6:
/* 395 */       return "Routine was invoked in an inproper context.";
/*     */     case -3:
/* 398 */       return "A resource manager error has occured in the transaction branch.";
/*     */     case -7:
/* 401 */       return "Resource manager is unavailable.";
/*     */     }
/*     */ 
/* 404 */     return "Internal XA Error";
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.xa.OracleXAException
 * JD-Core Version:    0.6.2
 */