/*     */ package oracle.jdbc.xa;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import java.util.Properties;
/*     */ import javax.sql.XAConnection;
/*     */ import javax.sql.XADataSource;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.jdbc.pool.OracleConnectionPoolDataSource;
/*     */ import oracle.jdbc.pool.OracleDataSource;
/*     */ 
/*     */ public abstract class OracleXADataSource extends OracleConnectionPoolDataSource
/*     */   implements XADataSource
/*     */ {
/*  33 */   protected boolean useNativeXA = false;
/*     */ 
/* 169 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public OracleXADataSource()
/*     */     throws SQLException
/*     */   {
/*  51 */     this.dataSourceName = "OracleXADataSource";
/*     */   }
/*     */ 
/*     */   public abstract XAConnection getXAConnection()
/*     */     throws SQLException;
/*     */ 
/*     */   public abstract XAConnection getXAConnection(String paramString1, String paramString2)
/*     */     throws SQLException;
/*     */ 
/*     */   public abstract XAConnection getXAConnection(Properties paramProperties)
/*     */     throws SQLException;
/*     */ 
/*     */   public synchronized void setURL(String paramString)
/*     */   {
/*  84 */     super.setURL(paramString);
/*  85 */     if (paramString != null)
/*     */     {
/*  87 */       if (paramString.startsWith("jdbc:oracle:thin"))
/*     */       {
/*  89 */         this.useNativeXA = true;
/*     */       }
/*  91 */       else if ((paramString.startsWith("jdbc:oracle:oci")) || (paramString.startsWith("jdbc:oracle:oci8")))
/*     */       {
/*  94 */         this.useNativeXA = false;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void setNativeXA(boolean paramBoolean)
/*     */   {
/* 118 */     this.useNativeXA = paramBoolean;
/*     */   }
/*     */ 
/*     */   public synchronized boolean getNativeXA()
/*     */   {
/* 137 */     return this.useNativeXA;
/*     */   }
/*     */ 
/*     */   protected void copy(OracleDataSource paramOracleDataSource)
/*     */     throws SQLException
/*     */   {
/* 147 */     super.copy(paramOracleDataSource);
/*     */ 
/* 149 */     ((OracleXADataSource)paramOracleDataSource).useNativeXA = this.useNativeXA;
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 165 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.xa.OracleXADataSource
 * JD-Core Version:    0.6.2
 */