/*     */ package oracle.jdbc.xa;
/*     */ 
/*     */ import java.sql.Connection;
/*     */ import java.sql.SQLException;
/*     */ import javax.sql.XAConnection;
/*     */ import javax.transaction.xa.XAException;
/*     */ import javax.transaction.xa.XAResource;
/*     */ import oracle.jdbc.pool.OraclePooledConnection;
/*     */ 
/*     */ public abstract class OracleXAConnection extends OraclePooledConnection
/*     */   implements XAConnection
/*     */ {
/*  32 */   protected XAResource xaResource = null;
/*     */ 
/* 131 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public OracleXAConnection()
/*     */     throws XAException
/*     */   {
/*  41 */     this(null);
/*     */   }
/*     */ 
/*     */   public OracleXAConnection(Connection paramConnection)
/*     */     throws XAException
/*     */   {
/*  63 */     super(paramConnection);
/*     */   }
/*     */ 
/*     */   public abstract XAResource getXAResource();
/*     */ 
/*     */   public synchronized Connection getConnection()
/*     */     throws SQLException
/*     */   {
/* 104 */     Connection localConnection = super.getConnection();
/*     */ 
/* 106 */     if (this.xaResource != null) {
/* 107 */       ((OracleXAResource)this.xaResource).setLogicalConnection(localConnection);
/*     */     }
/* 109 */     return localConnection;
/*     */   }
/*     */ 
/*     */   boolean getAutoCommit()
/*     */     throws SQLException
/*     */   {
/* 117 */     return this.autoCommit;
/*     */   }
/*     */ 
/*     */   void setAutoCommit(boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/* 125 */     this.autoCommit = paramBoolean;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.xa.OracleXAConnection
 * JD-Core Version:    0.6.2
 */