/*     */ package oracle.jdbc.xa;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.util.Vector;
/*     */ 
/*     */ public class OracleMultiPhaseArgs
/*     */ {
/*  26 */   int action = 0;
/*  27 */   int nsites = 0;
/*  28 */   Vector dbLinks = null;
/*  29 */   Vector xids = null;
/*     */ 
/* 305 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public OracleMultiPhaseArgs()
/*     */   {
/*     */   }
/*     */ 
/*     */   public OracleMultiPhaseArgs(int paramInt1, int paramInt2, Vector paramVector1, Vector paramVector2)
/*     */   {
/*  53 */     if (paramInt2 <= 1)
/*     */     {
/*  55 */       this.action = 0;
/*  56 */       this.nsites = 0;
/*  57 */       this.dbLinks = null;
/*  58 */       this.xids = null;
/*     */     }
/*  64 */     else if ((!paramVector1.isEmpty()) && (!paramVector2.isEmpty()) && (paramVector2.size() == paramInt2) && (paramVector1.size() == 3 * paramInt2))
/*     */     {
/*  71 */       this.action = paramInt1;
/*  72 */       this.nsites = paramInt2;
/*  73 */       this.xids = paramVector1;
/*  74 */       this.dbLinks = paramVector2;
/*     */     }
/*     */   }
/*     */ 
/*     */   public OracleMultiPhaseArgs(byte[] paramArrayOfByte)
/*     */   {
/*  92 */     ByteArrayInputStream localByteArrayInputStream = new ByteArrayInputStream(paramArrayOfByte);
/*  93 */     DataInputStream localDataInputStream = new DataInputStream(localByteArrayInputStream);
/*     */ 
/*  95 */     this.xids = new Vector();
/*  96 */     this.dbLinks = new Vector();
/*     */     try
/*     */     {
/* 100 */       this.action = localDataInputStream.readInt();
/* 101 */       this.nsites = localDataInputStream.readInt();
/*     */ 
/* 103 */       int i = localDataInputStream.readInt();
/* 104 */       int j = localDataInputStream.readInt();
/* 105 */       byte[] arrayOfByte1 = new byte[j];
/* 106 */       int k = localDataInputStream.read(arrayOfByte1, 0, j);
/*     */ 
/* 108 */       for (int m = 0; m < this.nsites; m++)
/*     */       {
/* 110 */         int n = localDataInputStream.readInt();
/* 111 */         byte[] arrayOfByte2 = new byte[n];
/* 112 */         int i1 = localDataInputStream.read(arrayOfByte2, 0, n);
/*     */ 
/* 115 */         this.xids.addElement(Integer.valueOf(i));
/* 116 */         this.xids.addElement(arrayOfByte1);
/* 117 */         this.xids.addElement(arrayOfByte2);
/*     */ 
/* 119 */         String str = localDataInputStream.readUTF();
/*     */ 
/* 122 */         this.dbLinks.addElement(str);
/*     */       }
/*     */     }
/*     */     catch (IOException localIOException)
/*     */     {
/* 127 */       localIOException.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   public byte[] toByteArray()
/*     */   {
/* 144 */     return toByteArrayOS().toByteArray();
/*     */   }
/*     */ 
/*     */   public ByteArrayOutputStream toByteArrayOS()
/*     */   {
/* 150 */     Object localObject = null;
/* 151 */     int i = 0;
/*     */ 
/* 160 */     ByteArrayOutputStream localByteArrayOutputStream = new ByteArrayOutputStream();
/* 161 */     DataOutputStream localDataOutputStream = new DataOutputStream(localByteArrayOutputStream);
/*     */     try
/*     */     {
/* 165 */       localDataOutputStream.writeInt(this.action);
/* 166 */       localDataOutputStream.writeInt(this.nsites);
/*     */ 
/* 168 */       for (int j = 0; j < this.nsites; j++)
/*     */       {
/* 170 */         String str = (String)this.dbLinks.elementAt(j);
/* 171 */         int k = ((Integer)this.xids.elementAt(j * 3)).intValue();
/* 172 */         byte[] arrayOfByte1 = (byte[])this.xids.elementAt(j * 3 + 1);
/* 173 */         byte[] arrayOfByte2 = (byte[])this.xids.elementAt(j * 3 + 2);
/*     */ 
/* 175 */         if (j == 0)
/*     */         {
/* 177 */           i = k;
/* 178 */           localObject = arrayOfByte1;
/*     */ 
/* 180 */           localDataOutputStream.writeInt(k);
/* 181 */           localDataOutputStream.writeInt(arrayOfByte1.length);
/* 182 */           localDataOutputStream.write(arrayOfByte1, 0, arrayOfByte1.length);
/*     */         }
/*     */ 
/* 193 */         localDataOutputStream.writeInt(arrayOfByte2.length);
/* 194 */         localDataOutputStream.write(arrayOfByte2, 0, arrayOfByte2.length);
/* 195 */         localDataOutputStream.writeUTF(str);
/*     */       }
/*     */     }
/*     */     catch (IOException localIOException)
/*     */     {
/* 200 */       localIOException.printStackTrace();
/*     */     }
/*     */ 
/* 205 */     return localByteArrayOutputStream;
/*     */   }
/*     */ 
/*     */   public int getAction()
/*     */   {
/* 218 */     return this.action;
/*     */   }
/*     */ 
/*     */   public int getnsite()
/*     */   {
/* 231 */     return this.nsites;
/*     */   }
/*     */ 
/*     */   public Vector getdbLinks()
/*     */   {
/* 244 */     return this.dbLinks;
/*     */   }
/*     */ 
/*     */   public Vector getXids()
/*     */   {
/* 257 */     return this.xids;
/*     */   }
/*     */ 
/*     */   public void printMPArgs()
/*     */   {
/* 270 */     for (int i = 0; i < this.nsites; i++)
/*     */     {
/* 272 */       String str = (String)this.dbLinks.elementAt(i);
/* 273 */       int j = ((Integer)this.xids.elementAt(i * 3)).intValue();
/* 274 */       byte[] arrayOfByte1 = (byte[])this.xids.elementAt(i * 3 + 1);
/* 275 */       byte[] arrayOfByte2 = (byte[])this.xids.elementAt(i * 3 + 2);
/*     */ 
/* 279 */       printByteArray(arrayOfByte1);
/*     */ 
/* 282 */       printByteArray(arrayOfByte2);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void printByteArray(byte[] paramArrayOfByte)
/*     */   {
/* 294 */     StringBuffer localStringBuffer = new StringBuffer();
/*     */ 
/* 296 */     for (int i = 0; i < paramArrayOfByte.length; i++)
/* 297 */       localStringBuffer.append(paramArrayOfByte[i] + " ");
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.xa.OracleMultiPhaseArgs
 * JD-Core Version:    0.6.2
 */