/*     */ package oracle.jdbc.util;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ 
/*     */ public class RepConversion
/*     */ {
/* 222 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public static void printInHex(byte paramByte)
/*     */   {
/*  34 */     System.out.print((char)nibbleToHex((byte)((paramByte & 0xF0) >> 4)));
/*  35 */     System.out.print((char)nibbleToHex((byte)(paramByte & 0xF)));
/*     */   }
/*     */ 
/*     */   public static byte nibbleToHex(byte paramByte)
/*     */   {
/*  50 */     paramByte = (byte)(paramByte & 0xF);
/*     */ 
/*  52 */     return (byte)(paramByte < 10 ? paramByte + 48 : paramByte - 10 + 65);
/*     */   }
/*     */ 
/*     */   public static byte asciiHexToNibble(byte paramByte)
/*     */   {
/*     */     byte b;
/*  73 */     if ((paramByte >= 97) && (paramByte <= 102)) {
/*  74 */       b = (byte)(paramByte - 97 + 10);
/*     */     }
/*  76 */     else if ((paramByte >= 65) && (paramByte <= 70)) {
/*  77 */       b = (byte)(paramByte - 65 + 10);
/*     */     }
/*  79 */     else if ((paramByte >= 48) && (paramByte <= 57)) {
/*  80 */       b = (byte)(paramByte - 48);
/*     */     }
/*     */     else {
/*  83 */       b = paramByte;
/*     */     }
/*  85 */     return b;
/*     */   }
/*     */ 
/*     */   public static void bArray2Nibbles(byte[] paramArrayOfByte1, byte[] paramArrayOfByte2)
/*     */   {
/*  99 */     for (int i = 0; i < paramArrayOfByte1.length; i++)
/*     */     {
/* 101 */       paramArrayOfByte2[(i * 2)] = nibbleToHex((byte)((paramArrayOfByte1[i] & 0xF0) >> 4));
/* 102 */       paramArrayOfByte2[(i * 2 + 1)] = nibbleToHex((byte)(paramArrayOfByte1[i] & 0xF));
/*     */     }
/*     */   }
/*     */ 
/*     */   public static String bArray2String(byte[] paramArrayOfByte)
/*     */   {
/* 116 */     StringBuffer localStringBuffer = new StringBuffer(paramArrayOfByte.length * 2);
/*     */ 
/* 118 */     for (int i = 0; i < paramArrayOfByte.length; i++)
/*     */     {
/* 120 */       localStringBuffer.append((char)nibbleToHex((byte)((paramArrayOfByte[i] & 0xF0) >> 4)));
/* 121 */       localStringBuffer.append((char)nibbleToHex((byte)(paramArrayOfByte[i] & 0xF)));
/*     */     }
/*     */ 
/* 124 */     return localStringBuffer.toString();
/*     */   }
/*     */ 
/*     */   public static byte[] nibbles2bArray(byte[] paramArrayOfByte)
/*     */   {
/* 139 */     byte[] arrayOfByte = new byte[paramArrayOfByte.length / 2];
/*     */ 
/* 142 */     for (int i = 0; i < arrayOfByte.length; i++)
/*     */     {
/* 144 */       arrayOfByte[i] = ((byte)(asciiHexToNibble(paramArrayOfByte[(i * 2)]) << 4));
/*     */       int tmp31_30 = i;
/*     */       byte[] tmp31_29 = arrayOfByte; tmp31_29[tmp31_30] = ((byte)(tmp31_29[tmp31_30] | asciiHexToNibble(paramArrayOfByte[(i * 2 + 1)])));
/*     */     }
/*     */ 
/* 148 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   public static void printInHex(long paramLong)
/*     */   {
/* 154 */     byte[] arrayOfByte = toHex(paramLong);
/*     */ 
/* 156 */     System.out.print(new String(arrayOfByte, 0));
/*     */   }
/*     */ 
/*     */   public static void printInHex(int paramInt)
/*     */   {
/* 162 */     byte[] arrayOfByte = toHex(paramInt);
/*     */ 
/* 164 */     System.out.print(new String(arrayOfByte, 0));
/*     */   }
/*     */ 
/*     */   public static void printInHex(short paramShort)
/*     */   {
/* 170 */     byte[] arrayOfByte = toHex(paramShort);
/*     */ 
/* 172 */     System.out.print(new String(arrayOfByte, 0));
/*     */   }
/*     */ 
/*     */   public static byte[] toHex(long paramLong)
/*     */   {
/* 178 */     int i = 16;
/* 179 */     byte[] arrayOfByte = new byte[i];
/*     */ 
/* 181 */     for (int j = i - 1; j >= 0; j--)
/*     */     {
/* 183 */       arrayOfByte[j] = nibbleToHex((byte)(int)(paramLong & 0xF));
/* 184 */       paramLong >>= 4;
/*     */     }
/*     */ 
/* 187 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   public static byte[] toHex(int paramInt)
/*     */   {
/* 193 */     int i = 8;
/* 194 */     byte[] arrayOfByte = new byte[i];
/*     */ 
/* 196 */     for (int j = i - 1; j >= 0; j--)
/*     */     {
/* 198 */       arrayOfByte[j] = nibbleToHex((byte)(paramInt & 0xF));
/* 199 */       paramInt >>= 4;
/*     */     }
/*     */ 
/* 202 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   public static byte[] toHex(short paramShort)
/*     */   {
/* 208 */     int i = 4;
/* 209 */     byte[] arrayOfByte = new byte[i];
/*     */ 
/* 211 */     for (int j = i - 1; j >= 0; j--)
/*     */     {
/* 213 */       arrayOfByte[j] = nibbleToHex((byte)(paramShort & 0xF));
/* 214 */       paramShort = (short)(paramShort >> 4);
/*     */     }
/*     */ 
/* 217 */     return arrayOfByte;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.util.RepConversion
 * JD-Core Version:    0.6.2
 */