/*     */ package oracle.jdbc.rowset;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.Writer;
/*     */ import java.math.BigDecimal;
/*     */ import java.sql.Date;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.ResultSetMetaData;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Time;
/*     */ import java.sql.Timestamp;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import java.util.Stack;
/*     */ import javax.sql.RowSet;
/*     */ import javax.sql.RowSetInternal;
/*     */ import javax.sql.rowset.WebRowSet;
/*     */ import javax.sql.rowset.spi.SyncProvider;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.xml.util.XMLUtil;
/*     */ 
/*     */ class OracleWebRowSetXmlWriterImpl
/*     */   implements OracleWebRowSetXmlWriter
/*     */ {
/*     */   private Writer xmlWriter;
/*     */   private Stack xmlTagStack;
/*     */   private static final String WEBROWSET_ELEMENT = "webRowSet";
/*     */   private static final String PROPERTIES_ELEMENT = "properties";
/*     */   private static final String METADATA_ELEMENT = "metadata";
/*     */   private static final String DATA_ELEMENT = "data";
/*     */   private static final String PROPERTY_COMMAND = "command";
/*     */   private static final String PROPERTY_CONCURRENCY = "concurrency";
/*     */   private static final String PROPERTY_DATASOURCE = "datasource";
/*     */   private static final String PROPERTY_ESCAPEPROCESSING = "escape-processing";
/*     */   private static final String PROPERTY_FETCHDIRECTION = "fetch-direction";
/*     */   private static final String PROPERTY_FETCHSIZE = "fetch-size";
/*     */   private static final String PROPERTY_ISOLATIONLEVEL = "isolation-level";
/*     */   private static final String PROPERTY_KEYCOLUMNS = "key-columns";
/*     */   private static final String PROPERTY_MAP = "map";
/*     */   private static final String PROPERTY_MAXFIELDSIZE = "max-field-size";
/*     */   private static final String PROPERTY_MAXROWS = "max-rows";
/*     */   private static final String PROPERTY_QUERYTIMEOUT = "query-timeout";
/*     */   private static final String PROPERTY_READONLY = "read-only";
/*     */   private static final String PROPERTY_ROWSETTYPE = "rowset-type";
/*     */   private static final String PROPERTY_SHOWDELETED = "show-deleted";
/*     */   private static final String PROPERTY_TABLENAME = "table-name";
/*     */   private static final String PROPERTY_URL = "url";
/*     */   private static final String PROPERTY_SYNCPROVIDER = "sync-provider";
/*     */   private static final String PROPERTY_NULL = "null";
/*     */   private static final String PROPERTY_KC_COLUMN = "column";
/*     */   private static final String PROPERTY_MAP_TYPE = "type";
/*     */   private static final String PROPERTY_MAP_CLASS = "class";
/*     */   private static final String PROPERTY_S_PROVIDERNAME = "sync-provider-name";
/*     */   private static final String PROPERTY_S_PROVIDERVENDOR = "sync-provider-vendor";
/*     */   private static final String PROPERTY_S_PROVIDERVERSION = "sync-provider-version";
/*     */   private static final String PROPERTY_S_PROVIDERGRADE = "sync-provider-grade";
/*     */   private static final String PROPERTY_S_DATASOURCELOCK = "data-source-lock";
/*     */   private static final String METADATA_COLUMNCOUNT = "column-count";
/*     */   private static final String METADATA_COLUMNDEFINITION = "column-definition";
/*     */   private static final String METADATA_COLUMNINDEX = "column-index";
/*     */   private static final String METADATA_AUTOINCREMENT = "auto-increment";
/*     */   private static final String METADATA_CASESENSITIVE = "case-sensitive";
/*     */   private static final String METADATA_CURRENCY = "currency";
/*     */   private static final String METADATA_NULLABLE = "nullable";
/*     */   private static final String METADATA_SIGNED = "signed";
/*     */   private static final String METADATA_SEARCHABLE = "searchable";
/*     */   private static final String METADATA_COLUMNDISPLAYSIZE = "column-display-size";
/*     */   private static final String METADATA_COLUMNLABEL = "column-label";
/*     */   private static final String METADATA_COLUMNNAME = "column-name";
/*     */   private static final String METADATA_SCHEMANAME = "schema-name";
/*     */   private static final String METADATA_COLUMNPRECISION = "column-precision";
/*     */   private static final String METADATA_COLUMNSCALE = "column-scale";
/*     */   private static final String METADATA_TABLENAME = "table-name";
/*     */   private static final String METADATA_CATALOGNAME = "catalog-name";
/*     */   private static final String METADATA_COLUMNTYPE = "column-type";
/*     */   private static final String METADATA_COLUMNTYPENAME = "column-type-name";
/*     */   private static final String METADATA_NULL = "null";
/*     */   private static final String DATA_CURRENTROW = "currentRow";
/*     */   private static final String DATA_INSERTROW = "insertRow";
/*     */   private static final String DATA_DELETEROW = "deleteRow";
/*     */   private static final String DATA_MODIFYROW = "modifyRow";
/*     */   private static final String DATA_COLUMNVALUE = "columnValue";
/*     */   private static final String DATA_UPDATEVALUE = "updateValue";
/*     */   private static final String DATA_NULL = "null";
/* 673 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public void writeXML(WebRowSet paramWebRowSet, Writer paramWriter)
/*     */     throws SQLException
/*     */   {
/* 152 */     if (!(paramWebRowSet instanceof OracleWebRowSet))
/*     */     {
/* 154 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 359);
/* 155 */       localSQLException.fillInStackTrace();
/* 156 */       throw localSQLException;
/*     */     }
/*     */ 
/* 159 */     this.xmlTagStack = new Stack();
/* 160 */     this.xmlWriter = paramWriter;
/* 161 */     writeRowSet((OracleWebRowSet)paramWebRowSet);
/*     */   }
/*     */ 
/*     */   public boolean writeData(RowSetInternal paramRowSetInternal)
/*     */     throws SQLException
/*     */   {
/* 167 */     return false;
/*     */   }
/*     */ 
/*     */   private void writeRowSet(OracleWebRowSet paramOracleWebRowSet)
/*     */     throws SQLException
/*     */   {
/*     */     try
/*     */     {
/* 182 */       writeHeaderAndStartWebRowSetElement();
/* 183 */       writeProperties(paramOracleWebRowSet);
/* 184 */       writeMetaData(paramOracleWebRowSet);
/* 185 */       writeData(paramOracleWebRowSet);
/* 186 */       endWebRowSetElement();
/*     */     }
/*     */     catch (IOException localIOException)
/*     */     {
/* 190 */       throw new SQLException("IOException: " + localIOException.getMessage());
/*     */     }
/*     */   }
/*     */ 
/*     */   private void writeHeaderAndStartWebRowSetElement()
/*     */     throws IOException
/*     */   {
/* 197 */     this.xmlWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
/* 198 */     this.xmlWriter.write("\n");
/*     */ 
/* 200 */     setCurrentTag("webRowSet");
/*     */ 
/* 202 */     this.xmlWriter.write("<webRowSet xmlns=\"http://java.sun.com/xml/ns/jdbc\"\n");
/* 203 */     this.xmlWriter.write("           xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
/* 204 */     this.xmlWriter.write("           xsi:schemaLocation=\"http://java.sun.com/xml/ns/jdbc ");
/* 205 */     this.xmlWriter.write("http://java.sun.com/xml/ns/jdbc/webrowset.xsd");
/* 206 */     this.xmlWriter.write("\">\n");
/*     */   }
/*     */ 
/*     */   private void endWebRowSetElement()
/*     */     throws IOException
/*     */   {
/* 212 */     endTag("webRowSet");
/*     */   }
/*     */ 
/*     */   private void startElement(String paramString)
/*     */     throws IOException
/*     */   {
/* 218 */     startTag(paramString);
/* 219 */     this.xmlWriter.write("\n");
/*     */   }
/*     */ 
/*     */   private void endElement(String paramString)
/*     */     throws IOException
/*     */   {
/* 225 */     writeIndent(this.xmlTagStack.size());
/* 226 */     endTag(paramString);
/*     */   }
/*     */ 
/*     */   private void endElement()
/*     */     throws IOException
/*     */   {
/* 232 */     writeIndent(this.xmlTagStack.size());
/* 233 */     String str = getCurrentTag();
/* 234 */     this.xmlWriter.write("</" + str + ">\n");
/* 235 */     this.xmlWriter.flush();
/*     */   }
/*     */ 
/*     */   private void startTag(String paramString)
/*     */     throws IOException
/*     */   {
/* 241 */     setCurrentTag(paramString);
/* 242 */     writeIndent(this.xmlTagStack.size());
/* 243 */     this.xmlWriter.write("<" + paramString + ">");
/*     */   }
/*     */ 
/*     */   private void endTag(String paramString)
/*     */     throws IOException
/*     */   {
/* 249 */     String str = getCurrentTag();
/* 250 */     if (paramString.equals(str))
/* 251 */       this.xmlWriter.write("</" + str + ">\n");
/* 252 */     this.xmlWriter.flush();
/*     */   }
/*     */ 
/*     */   private void setCurrentTag(String paramString)
/*     */   {
/* 257 */     this.xmlTagStack.push(paramString);
/*     */   }
/*     */ 
/*     */   private String getCurrentTag()
/*     */   {
/* 262 */     return (String)this.xmlTagStack.pop();
/*     */   }
/*     */ 
/*     */   private void writeEmptyElement(String paramString)
/*     */     throws IOException
/*     */   {
/* 268 */     this.xmlWriter.write("<" + paramString + "/>");
/*     */   }
/*     */ 
/*     */   private void writeProperties(OracleWebRowSet paramOracleWebRowSet)
/*     */     throws IOException
/*     */   {
/* 274 */     startElement("properties");
/*     */     try
/*     */     {
/* 278 */       writeElementString("command", paramOracleWebRowSet.getCommand());
/* 279 */       writeElementInteger("concurrency", paramOracleWebRowSet.getConcurrency());
/* 280 */       writeElementString("datasource", paramOracleWebRowSet.getDataSourceName());
/* 281 */       writeElementBoolean("escape-processing", paramOracleWebRowSet.getEscapeProcessing());
/* 282 */       writeElementInteger("fetch-direction", paramOracleWebRowSet.getFetchDirection());
/* 283 */       writeElementInteger("fetch-size", paramOracleWebRowSet.getFetchSize());
/* 284 */       writeElementInteger("isolation-level", paramOracleWebRowSet.getTransactionIsolation());
/*     */ 
/* 286 */       startElement("key-columns");
/* 287 */       int[] arrayOfInt = paramOracleWebRowSet.getKeyColumns();
/* 288 */       for (int i = 0; (arrayOfInt != null) && (i < arrayOfInt.length); i++)
/* 289 */         writeElementInteger("column", arrayOfInt[i]);
/* 290 */       endElement("key-columns");
/*     */ 
/* 292 */       startElement("map");
/* 293 */       Map localMap = paramOracleWebRowSet.getTypeMap();
/* 294 */       if (localMap != null)
/*     */       {
/* 297 */         Set localSet = localMap.entrySet();
/* 298 */         for (Map.Entry localEntry : localSet)
/*     */         {
/* 300 */           writeElementString("type", (String)localEntry.getKey());
/* 301 */           writeElementString("class", ((Class)localEntry.getValue()).getName());
/*     */         }
/*     */       }
/* 304 */       endElement("map");
/*     */ 
/* 306 */       writeElementInteger("max-field-size", paramOracleWebRowSet.getMaxFieldSize());
/* 307 */       writeElementInteger("max-rows", paramOracleWebRowSet.getMaxRows());
/* 308 */       writeElementInteger("query-timeout", paramOracleWebRowSet.getQueryTimeout());
/* 309 */       writeElementBoolean("read-only", paramOracleWebRowSet.isReadOnly());
/* 310 */       writeElementInteger("rowset-type", paramOracleWebRowSet.getType());
/* 311 */       writeElementBoolean("show-deleted", paramOracleWebRowSet.getShowDeleted());
/* 312 */       writeElementString("table-name", paramOracleWebRowSet.getTableName());
/* 313 */       writeElementString("url", paramOracleWebRowSet.getUrl());
/*     */ 
/* 317 */       startElement("sync-provider");
/*     */ 
/* 319 */       SyncProvider localSyncProvider = paramOracleWebRowSet.getSyncProvider();
/* 320 */       writeElementString("sync-provider-name", localSyncProvider.getProviderID());
/* 321 */       writeElementString("sync-provider-vendor", localSyncProvider.getVendor());
/* 322 */       writeElementString("sync-provider-version", localSyncProvider.getVersion());
/* 323 */       writeElementInteger("sync-provider-grade", localSyncProvider.getProviderGrade());
/* 324 */       writeElementInteger("data-source-lock", localSyncProvider.getDataSourceLock());
/*     */ 
/* 326 */       endElement("sync-provider");
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 330 */       throw new IOException("SQLException: " + localSQLException.getMessage());
/*     */     }
/*     */ 
/* 333 */     endElement("properties");
/*     */   }
/*     */ 
/*     */   private void writeMetaData(OracleWebRowSet paramOracleWebRowSet)
/*     */     throws IOException
/*     */   {
/* 339 */     startElement("metadata");
/*     */     try
/*     */     {
/* 343 */       ResultSetMetaData localResultSetMetaData = paramOracleWebRowSet.getMetaData();
/*     */ 
/* 345 */       int i = localResultSetMetaData.getColumnCount();
/* 346 */       writeElementInteger("column-count", i);
/*     */ 
/* 348 */       for (int j = 1; j <= i; j++)
/*     */       {
/* 350 */         startElement("column-definition");
/*     */ 
/* 352 */         writeElementInteger("column-index", j);
/* 353 */         writeElementBoolean("auto-increment", localResultSetMetaData.isAutoIncrement(j));
/* 354 */         writeElementBoolean("case-sensitive", localResultSetMetaData.isCaseSensitive(j));
/* 355 */         writeElementBoolean("currency", localResultSetMetaData.isCurrency(j));
/* 356 */         writeElementInteger("nullable", localResultSetMetaData.isNullable(j));
/* 357 */         writeElementBoolean("signed", localResultSetMetaData.isSigned(j));
/* 358 */         writeElementBoolean("searchable", localResultSetMetaData.isSearchable(j));
/* 359 */         writeElementInteger("column-display-size", localResultSetMetaData.getColumnDisplaySize(j));
/* 360 */         writeElementString("column-label", localResultSetMetaData.getColumnLabel(j));
/* 361 */         writeElementString("column-name", localResultSetMetaData.getColumnName(j));
/* 362 */         writeElementString("schema-name", localResultSetMetaData.getSchemaName(j));
/* 363 */         writeElementInteger("column-precision", localResultSetMetaData.getPrecision(j));
/* 364 */         writeElementInteger("column-scale", localResultSetMetaData.getScale(j));
/* 365 */         writeElementString("table-name", localResultSetMetaData.getTableName(j));
/* 366 */         writeElementString("catalog-name", localResultSetMetaData.getCatalogName(j));
/* 367 */         writeElementInteger("column-type", localResultSetMetaData.getColumnType(j));
/* 368 */         writeElementString("column-type-name", localResultSetMetaData.getColumnTypeName(j));
/*     */ 
/* 370 */         endElement("column-definition");
/*     */       }
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 375 */       throw new IOException("SQLException: " + localSQLException.getMessage());
/*     */     }
/*     */ 
/* 378 */     endElement("metadata");
/*     */   }
/*     */ 
/*     */   private void writeElementBoolean(String paramString, boolean paramBoolean)
/*     */     throws IOException
/*     */   {
/* 384 */     startTag(paramString);
/* 385 */     writeBoolean(paramBoolean);
/* 386 */     endTag(paramString);
/*     */   }
/*     */ 
/*     */   private void writeElementInteger(String paramString, int paramInt)
/*     */     throws IOException
/*     */   {
/* 392 */     startTag(paramString);
/* 393 */     writeInteger(paramInt);
/* 394 */     endTag(paramString);
/*     */   }
/*     */ 
/*     */   private void writeElementString(String paramString1, String paramString2)
/*     */     throws IOException
/*     */   {
/* 400 */     startTag(paramString1);
/* 401 */     writeString(paramString2);
/* 402 */     endTag(paramString1);
/*     */   }
/*     */ 
/*     */   private void writeData(OracleWebRowSet paramOracleWebRowSet)
/*     */     throws IOException
/*     */   {
/*     */     try
/*     */     {
/* 410 */       ResultSetMetaData localResultSetMetaData = paramOracleWebRowSet.getMetaData();
/* 411 */       int i = localResultSetMetaData.getColumnCount();
/*     */ 
/* 413 */       startElement("data");
/*     */ 
/* 415 */       paramOracleWebRowSet.beforeFirst();
/* 416 */       paramOracleWebRowSet.setShowDeleted(true);
/* 417 */       for (; paramOracleWebRowSet.next(); endElement())
/*     */       {
/* 419 */         if ((paramOracleWebRowSet.rowDeleted()) && (paramOracleWebRowSet.rowInserted()))
/* 420 */           startElement("modifyRow");
/* 421 */         else if (paramOracleWebRowSet.rowDeleted())
/* 422 */           startElement("deleteRow");
/* 423 */         else if (paramOracleWebRowSet.rowInserted())
/* 424 */           startElement("insertRow");
/*     */         else
/* 426 */           startElement("currentRow");
/* 427 */         for (int j = 1; j <= i; j++)
/*     */         {
/* 429 */           if (paramOracleWebRowSet.columnUpdated(j))
/*     */           {
/* 431 */             ResultSet localResultSet = paramOracleWebRowSet.getOriginalRow();
/* 432 */             localResultSet.next();
/*     */ 
/* 434 */             startTag("columnValue");
/* 435 */             writeValue(j, (RowSet)localResultSet);
/* 436 */             endTag("columnValue");
/*     */ 
/* 438 */             startTag("updateValue");
/* 439 */             writeValue(j, paramOracleWebRowSet);
/* 440 */             endTag("updateValue");
/*     */           }
/*     */           else
/*     */           {
/* 444 */             startTag("columnValue");
/* 445 */             writeValue(j, paramOracleWebRowSet);
/* 446 */             endTag("columnValue");
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/* 451 */       endElement("data");
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 455 */       throw new IOException("SQLException: " + localSQLException.getMessage());
/*     */     }
/*     */   }
/*     */ 
/*     */   private void writeBigDecimal(BigDecimal paramBigDecimal)
/*     */     throws IOException
/*     */   {
/* 462 */     if (paramBigDecimal != null)
/* 463 */       this.xmlWriter.write(paramBigDecimal.toString());
/*     */     else
/* 465 */       writeEmptyElement("null");
/*     */   }
/*     */ 
/*     */   private void writeBoolean(boolean paramBoolean)
/*     */     throws IOException
/*     */   {
/* 471 */     this.xmlWriter.write(Boolean.valueOf(paramBoolean).toString());
/*     */   }
/*     */ 
/*     */   private void writeDouble(double paramDouble)
/*     */     throws IOException
/*     */   {
/* 477 */     this.xmlWriter.write(Double.toString(paramDouble));
/*     */   }
/*     */ 
/*     */   private void writeFloat(float paramFloat)
/*     */     throws IOException
/*     */   {
/* 483 */     this.xmlWriter.write(Float.toString(paramFloat));
/*     */   }
/*     */ 
/*     */   private void writeInteger(int paramInt)
/*     */     throws IOException
/*     */   {
/* 489 */     this.xmlWriter.write(Integer.toString(paramInt));
/*     */   }
/*     */ 
/*     */   private void writeLong(long paramLong)
/*     */     throws IOException
/*     */   {
/* 495 */     this.xmlWriter.write(Long.toString(paramLong));
/*     */   }
/*     */ 
/*     */   private void writeNull()
/*     */     throws IOException
/*     */   {
/* 501 */     writeEmptyElement("null");
/*     */   }
/*     */ 
/*     */   private void writeShort(short paramShort)
/*     */     throws IOException
/*     */   {
/* 507 */     this.xmlWriter.write(Short.toString(paramShort));
/*     */   }
/*     */ 
/*     */   private void writeBytes(byte[] paramArrayOfByte)
/*     */     throws IOException
/*     */   {
/* 513 */     String str = XMLUtil.printBase64Binary(paramArrayOfByte);
/* 514 */     this.xmlWriter.write(str);
/*     */   }
/*     */ 
/*     */   private void writeString(String paramString)
/*     */     throws IOException
/*     */   {
/* 525 */     if (paramString != null)
/* 526 */       this.xmlWriter.write(paramString);
/*     */     else
/* 528 */       this.xmlWriter.write("");
/*     */   }
/*     */ 
/*     */   private void writeIndent(int paramInt)
/*     */     throws IOException
/*     */   {
/* 534 */     for (int i = 1; i < paramInt; i++)
/* 535 */       this.xmlWriter.write("  ");
/*     */   }
/*     */ 
/*     */   private void writeValue(int paramInt, RowSet paramRowSet)
/*     */     throws IOException
/*     */   {
/*     */     try
/*     */     {
/* 544 */       int i = paramRowSet.getMetaData().getColumnType(paramInt);
/* 545 */       switch (i)
/*     */       {
/*     */       case -7:
/*     */       case 5:
/* 549 */         short s = paramRowSet.getShort(paramInt);
/* 550 */         if (paramRowSet.wasNull())
/* 551 */           writeNull();
/*     */         else
/* 553 */           writeShort(s);
/* 554 */         break;
/*     */       case 4:
/* 557 */         int j = paramRowSet.getInt(paramInt);
/* 558 */         if (paramRowSet.wasNull())
/* 559 */           writeNull();
/*     */         else
/* 561 */           writeInteger(j);
/* 562 */         break;
/*     */       case -5:
/* 565 */         long l = paramRowSet.getLong(paramInt);
/* 566 */         if (paramRowSet.wasNull())
/* 567 */           writeNull();
/*     */         else
/* 569 */           writeLong(l);
/* 570 */         break;
/*     */       case 6:
/*     */       case 7:
/* 574 */         float f = paramRowSet.getFloat(paramInt);
/* 575 */         if (paramRowSet.wasNull())
/* 576 */           writeNull();
/*     */         else
/* 578 */           writeFloat(f);
/* 579 */         break;
/*     */       case 8:
/* 582 */         double d = paramRowSet.getDouble(paramInt);
/* 583 */         if (paramRowSet.wasNull())
/* 584 */           writeNull();
/*     */         else
/* 586 */           writeDouble(d);
/* 587 */         break;
/*     */       case 2:
/*     */       case 3:
/* 591 */         BigDecimal localBigDecimal = paramRowSet.getBigDecimal(paramInt);
/* 592 */         if (paramRowSet.wasNull())
/* 593 */           writeNull();
/*     */         else
/* 595 */           writeBigDecimal(localBigDecimal);
/* 596 */         break;
/*     */       case 91:
/* 599 */         Date localDate = paramRowSet.getDate(paramInt);
/* 600 */         if (paramRowSet.wasNull())
/* 601 */           writeNull();
/*     */         else
/* 603 */           writeLong(localDate.getTime());
/* 604 */         break;
/*     */       case 92:
/* 607 */         Time localTime = paramRowSet.getTime(paramInt);
/* 608 */         if (paramRowSet.wasNull())
/* 609 */           writeNull();
/*     */         else
/* 611 */           writeLong(localTime.getTime());
/* 612 */         break;
/*     */       case 93:
/* 615 */         Timestamp localTimestamp = paramRowSet.getTimestamp(paramInt);
/* 616 */         if (paramRowSet.wasNull())
/* 617 */           writeNull();
/*     */         else
/* 619 */           writeLong(localTimestamp.getTime());
/* 620 */         break;
/*     */       case -4:
/*     */       case -3:
/*     */       case -2:
/*     */       case 2004:
/* 626 */         byte[] arrayOfByte = paramRowSet.getBytes(paramInt);
/* 627 */         if (paramRowSet.wasNull())
/* 628 */           writeNull();
/*     */         else
/* 630 */           writeBytes(arrayOfByte);
/* 631 */         break;
/*     */       case -15:
/*     */       case -9:
/*     */       case -1:
/*     */       case 1:
/*     */       case 12:
/*     */       case 2005:
/*     */       case 2011:
/* 640 */         String str = paramRowSet.getString(paramInt);
/* 641 */         if (paramRowSet.wasNull())
/* 642 */           writeNull();
/*     */         else
/* 644 */           writeString(str);
/* 645 */         break;
/*     */       default:
/* 648 */         throw new SQLException("The type " + i + " is not supported currently.");
/*     */       }
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 653 */       throw new IOException("Failed to writeValue: " + localSQLException.getMessage());
/*     */     }
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 668 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.rowset.OracleWebRowSetXmlWriterImpl
 * JD-Core Version:    0.6.2
 */