/*     */ package oracle.jdbc.rowset;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.io.Reader;
/*     */ import java.sql.SQLException;
/*     */ import javax.sql.RowSetInternal;
/*     */ import javax.sql.rowset.WebRowSet;
/*     */ import javax.xml.parsers.DocumentBuilder;
/*     */ import javax.xml.parsers.DocumentBuilderFactory;
/*     */ import javax.xml.parsers.FactoryConfigurationError;
/*     */ import javax.xml.parsers.ParserConfigurationException;
/*     */ import javax.xml.parsers.SAXParser;
/*     */ import javax.xml.parsers.SAXParserFactory;
/*     */ import org.w3c.dom.Document;
/*     */ import org.xml.sax.InputSource;
/*     */ import org.xml.sax.SAXException;
/*     */ import org.xml.sax.SAXNotRecognizedException;
/*     */ import org.xml.sax.SAXParseException;
/*     */ import org.xml.sax.XMLReader;
/*     */ 
/*     */ class OracleWebRowSetXmlReaderImpl
/*     */   implements OracleWebRowSetXmlReader
/*     */ {
/*     */   private static final String JAVA_SAXPARSER_PROPERTY = "javax.xml.parsers.SAXParserFactory";
/*     */   private static final String JAVA_DOMPARSER_PROPERTY = "javax.xml.parsers.DocumentBuilderFactory";
/*     */   private static final String ORACLE_JAXP_SAXPARSER_FACTORY = "oracle.xml.jaxp.JXSAXParserFactory";
/*     */   private static final String ORACLE_JAXP_DOMPARSER_FACTORY = "oracle.xml.jaxp.JXDocumentBuilderFactory";
/*     */   private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
/*     */   private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
/*     */   private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
/*     */   private static final String WEBROWSET_SCHEMA = "http://java.sun.com/xml/ns/jdbc/webrowset.xsd";
/*     */   private Document document;
/*     */   private String parserStr;
/* 299 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   OracleWebRowSetXmlReaderImpl()
/*     */   {
/*  82 */     this.document = null;
/*  83 */     this.parserStr = null;
/*     */   }
/*     */ 
/*     */   public void readXML(WebRowSet paramWebRowSet, Reader paramReader)
/*     */     throws SQLException
/*     */   {
/* 112 */     this.parserStr = getSystemProperty("javax.xml.parsers.SAXParserFactory");
/* 113 */     if (this.parserStr != null)
/*     */     {
/* 115 */       readXMLSax((OracleWebRowSet)paramWebRowSet, paramReader);
/*     */     }
/*     */     else
/*     */     {
/* 119 */       this.parserStr = getSystemProperty("javax.xml.parsers.DocumentBuilderFactory");
/* 120 */       if (this.parserStr != null)
/*     */       {
/* 122 */         readXMLDom((OracleWebRowSet)paramWebRowSet, paramReader);
/*     */       }
/*     */       else
/* 125 */         throw new SQLException("No valid JAXP parser property specified");
/*     */     }
/*     */   }
/*     */ 
/*     */   public void readData(RowSetInternal paramRowSetInternal)
/*     */     throws SQLException
/*     */   {
/*     */   }
/*     */ 
/*     */   private void readXMLSax(OracleWebRowSet paramOracleWebRowSet, Reader paramReader)
/*     */     throws SQLException
/*     */   {
/*     */     try
/*     */     {
/* 146 */       InputSource localInputSource = new InputSource(paramReader);
/* 147 */       OracleWebRowSetXmlReaderContHandler localOracleWebRowSetXmlReaderContHandler = new OracleWebRowSetXmlReaderContHandler(paramOracleWebRowSet);
/*     */ 
/* 150 */       SAXParserFactory localSAXParserFactory = SAXParserFactory.newInstance();
/*     */ 
/* 153 */       localSAXParserFactory.setNamespaceAware(true);
/* 154 */       localSAXParserFactory.setValidating(true);
/* 155 */       SAXParser localSAXParser = localSAXParserFactory.newSAXParser();
/*     */ 
/* 158 */       localSAXParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
/* 159 */       localSAXParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", "http://java.sun.com/xml/ns/jdbc/webrowset.xsd");
/*     */ 
/* 161 */       XMLReader localXMLReader = localSAXParser.getXMLReader();
/* 162 */       localXMLReader.setContentHandler(localOracleWebRowSetXmlReaderContHandler);
/*     */ 
/* 176 */       localXMLReader.parse(localInputSource);
/*     */     }
/*     */     catch (SAXParseException localSAXParseException)
/*     */     {
/* 180 */       System.out.println("** Parsing error, line " + localSAXParseException.getLineNumber() + ", uri " + localSAXParseException.getSystemId());
/*     */ 
/* 183 */       System.out.println("   " + localSAXParseException.getMessage());
/* 184 */       localSAXParseException.printStackTrace();
/* 185 */       throw new SQLException(localSAXParseException.getMessage());
/*     */     }
/*     */     catch (SAXNotRecognizedException localSAXNotRecognizedException)
/*     */     {
/* 190 */       localSAXNotRecognizedException.printStackTrace();
/* 191 */       throw new SQLException("readXMLSax: SAXNotRecognizedException: " + localSAXNotRecognizedException.getMessage());
/*     */     }
/*     */     catch (SAXException localSAXException)
/*     */     {
/* 195 */       localSAXException.printStackTrace();
/* 196 */       throw new SQLException("readXMLSax: SAXException: " + localSAXException.getMessage());
/*     */     }
/*     */     catch (FactoryConfigurationError localFactoryConfigurationError)
/*     */     {
/* 200 */       localFactoryConfigurationError.printStackTrace();
/* 201 */       throw new SQLException("readXMLSax: Parser factory config: " + localFactoryConfigurationError.getMessage());
/*     */     }
/*     */     catch (ParserConfigurationException localParserConfigurationException)
/*     */     {
/* 205 */       localParserConfigurationException.printStackTrace();
/* 206 */       throw new SQLException("readXMLSax: Parser config: " + localParserConfigurationException.getMessage());
/*     */     }
/*     */     catch (Exception localException)
/*     */     {
/* 210 */       localException.printStackTrace();
/* 211 */       throw new SQLException("readXMLSax: " + localException.getMessage());
/*     */     }
/*     */   }
/*     */ 
/*     */   private void readXMLDom(OracleWebRowSet paramOracleWebRowSet, Reader paramReader)
/*     */     throws SQLException
/*     */   {
/*     */     try
/*     */     {
/* 221 */       InputSource localInputSource = new InputSource(paramReader);
/* 222 */       OracleWebRowSetXmlReaderDomHandler localOracleWebRowSetXmlReaderDomHandler = new OracleWebRowSetXmlReaderDomHandler(paramOracleWebRowSet);
/*     */ 
/* 242 */       DocumentBuilderFactory localDocumentBuilderFactory = DocumentBuilderFactory.newInstance();
/*     */ 
/* 246 */       localDocumentBuilderFactory.setNamespaceAware(true);
/* 247 */       localDocumentBuilderFactory.setValidating(true);
/*     */ 
/* 250 */       localDocumentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
/* 251 */       localDocumentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", "http://java.sun.com/xml/ns/jdbc/webrowset.xsd");
/* 252 */       DocumentBuilder localDocumentBuilder = localDocumentBuilderFactory.newDocumentBuilder();
/*     */ 
/* 254 */       this.document = localDocumentBuilder.parse(localInputSource);
/*     */ 
/* 257 */       localOracleWebRowSetXmlReaderDomHandler.readXMLDocument(this.document);
/*     */     }
/*     */     catch (SAXException localSAXException)
/*     */     {
/* 261 */       localSAXException.printStackTrace();
/* 262 */       throw new SQLException("readXMLDom: SAXException: " + localSAXException.getMessage());
/*     */     }
/*     */     catch (FactoryConfigurationError localFactoryConfigurationError)
/*     */     {
/* 267 */       localFactoryConfigurationError.printStackTrace();
/* 268 */       throw new SQLException("readXMLDom: Parser factory config: " + localFactoryConfigurationError.getMessage());
/*     */     }
/*     */     catch (ParserConfigurationException localParserConfigurationException)
/*     */     {
/* 272 */       localParserConfigurationException.printStackTrace();
/* 273 */       throw new SQLException("readXMLDom: Parser config: " + localParserConfigurationException.getMessage());
/*     */     }
/*     */     catch (Exception localException)
/*     */     {
/* 277 */       localException.printStackTrace();
/* 278 */       throw new SQLException("readXMLDom: " + localException.getMessage());
/*     */     }
/*     */   }
/*     */ 
/*     */   private String getSystemProperty(String paramString)
/*     */   {
/* 285 */     String str = null;
/*     */     try
/*     */     {
/* 288 */       str = System.getProperty(paramString);
/*     */     }
/*     */     catch (SecurityException localSecurityException)
/*     */     {
/* 292 */       str = null;
/*     */     }
/*     */ 
/* 295 */     return str;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.rowset.OracleWebRowSetXmlReaderImpl
 * JD-Core Version:    0.6.2
 */