/*      */ package oracle.jdbc.rowset;
/*      */ 
/*      */ import java.io.PrintStream;
/*      */ import java.math.BigDecimal;
/*      */ import java.sql.Blob;
/*      */ import java.sql.Clob;
/*      */ import java.sql.Date;
/*      */ import java.sql.NClob;
/*      */ import java.sql.ResultSetMetaData;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.Time;
/*      */ import java.sql.Timestamp;
/*      */ import java.util.Hashtable;
/*      */ import java.util.Iterator;
/*      */ import java.util.Vector;
/*      */ import javax.sql.RowSet;
/*      */ import javax.sql.RowSetMetaData;
/*      */ import oracle.jdbc.driver.DatabaseError;
/*      */ import oracle.jdbc.internal.OracleConnection;
/*      */ import oracle.xml.util.XMLUtil;
/*      */ import org.xml.sax.Attributes;
/*      */ import org.xml.sax.SAXException;
/*      */ import org.xml.sax.SAXParseException;
/*      */ import org.xml.sax.helpers.DefaultHandler;
/*      */ 
/*      */ class OracleWebRowSetXmlReaderContHandler extends DefaultHandler
/*      */ {
/*      */   private OracleWebRowSet wrset;
/*      */   private RowSetMetaData rsetMetaData;
/*      */   private Vector updatesToRowSet;
/*      */   private Vector keyCols;
/*      */   private String columnValue;
/*      */   private String propertyValue;
/*      */   private String metadataValue;
/*      */   private boolean isNullValue;
/*      */   private int columnIndex;
/*      */   private Hashtable propertyNameTagMap;
/*      */   private Hashtable metadataNameTagMap;
/*      */   private Hashtable dataNameTagMap;
/*      */   protected static final String WEBROWSET_ELEMENT_NAME = "webRowSet";
/*      */   protected static final String PROPERTIES_ELEMENT_NAME = "properties";
/*      */   protected static final String METADATA_ELEMENT_NAME = "metadata";
/*      */   protected static final String DATA_ELEMENT_NAME = "data";
/*      */   private int state;
/*      */   private static final int INITIAL_STATE = 0;
/*      */   private static final int PROPERTIES_STATE = 1;
/*      */   private static final int METADATA_STATE = 2;
/*      */   private static final int DATA_STATE = 3;
/*      */   private int tag;
/*      */   private static final int NO_TAG = -1;
/*   83 */   private String[] propertyNames = { "command", "concurrency", "datasource", "escape-processing", "fetch-direction", "fetch-size", "isolation-level", "key-columns", "map", "max-field-size", "max-rows", "query-timeout", "read-only", "rowset-type", "show-deleted", "table-name", "url", "sync-provider", "null", "column", "type", "class", "sync-provider-name", "sync-provider-vendor", "sync-provider-version", "sync-provider-grade", "data-source-lock" };
/*      */   private boolean readReadOnlyValue;
/*      */   private static final int PROPERTY_COMMAND_TAG = 0;
/*      */   private static final int PROPERTY_CONCURRENCY_TAG = 1;
/*      */   private static final int PROPERTY_DATASOURCETAG = 2;
/*      */   private static final int PROPERTY_ESCAPEPROCESSING_TAG = 3;
/*      */   private static final int PROPERTY_FETCHDIRECTION_TAG = 4;
/*      */   private static final int PROPERTY_FETCHSIZE_TAG = 5;
/*      */   private static final int PROPERTY_ISOLATIONLEVEL_TAG = 6;
/*      */   private static final int PROPERTY_KEYCOLUMNS_TAG = 7;
/*      */   private static final int PROPERTY_MAP_TAG = 8;
/*      */   private static final int PROPERTY_MAXFIELDSIZE_TAG = 9;
/*      */   private static final int PROPERTY_MAXROWS_TAG = 10;
/*      */   private static final int PROPERTY_QUERYTIMEOUT_TAG = 11;
/*      */   private static final int PROPERTY_READONLY_TAG = 12;
/*      */   private static final int PROPERTY_ROWSETTYPE_TAG = 13;
/*      */   private static final int PROPERTY_SHOWDELETED_TAG = 14;
/*      */   private static final int PROPERTY_TABLENAME_TAG = 15;
/*      */   private static final int PROPERTY_URL_TAG = 16;
/*      */   private static final int PROPERTY_SYNCPROVIDER_TAG = 17;
/*      */   private static final int PROPERTY_NULL_TAG = 18;
/*      */   private static final int PROPERTY_COLUMN_TAG = 19;
/*      */   private static final int PROPERTY_TYPE_TAG = 20;
/*      */   private static final int PROPERTY_CLASS_TAG = 21;
/*      */   private static final int PROPERTY_SYNCPROVIDERNAME_TAG = 22;
/*      */   private static final int PROPERTY_SYNCPROVIDERVENDOR_TAG = 23;
/*      */   private static final int PROPERTY_SYNCPROVIDERVERSION_TAG = 24;
/*      */   private static final int PROPERTY_SYNCPROVIDERGRADE_TAG = 25;
/*      */   private static final int PROPERTY_DATASOURCELOCK_TAG = 26;
/*  148 */   private String[] metadataNames = { "column-count", "column-definition", "column-index", "auto-increment", "case-sensitive", "currency", "nullable", "signed", "searchable", "column-display-size", "column-label", "column-name", "schema-name", "column-precision", "column-scale", "table-name", "catalog-name", "column-type", "column-type-name", "null" };
/*      */   private static final int METADATA_COLUMNCOUNT_TAG = 0;
/*      */   private static final int METADATA_COLUMNDEFINITION_TAG = 1;
/*      */   private static final int METADATA_COLUMNINDEX_TAG = 2;
/*      */   private static final int METADATA_AUTOINCREMENT_TAG = 3;
/*      */   private static final int METADATA_CASESENSITIVE_TAG = 4;
/*      */   private static final int METADATA_CURRENCY_TAG = 5;
/*      */   private static final int METADATA_NULLABLE_TAG = 6;
/*      */   private static final int METADATA_SIGNED_TAG = 7;
/*      */   private static final int METADATA_SEARCHABLE_TAG = 8;
/*      */   private static final int METADATA_COLUMNDISPLAYSIZE_TAG = 9;
/*      */   private static final int METADATA_COLUMNLABEL_TAG = 10;
/*      */   private static final int METADATA_COLUMNNAME_TAG = 11;
/*      */   private static final int METADATA_SCHEMANAME_TAG = 12;
/*      */   private static final int METADATA_COLUMNPRECISION_TAG = 13;
/*      */   private static final int METADATA_COLUMNSCALE_TAG = 14;
/*      */   private static final int METADATA_TABLENAME_TAG = 15;
/*      */   private static final int METADATA_CATALOGNAME_TAG = 16;
/*      */   private static final int METADATA_COLUMNTYPE_TAG = 17;
/*      */   private static final int METADATA_COLUMNTYPENAME_TAG = 18;
/*      */   private static final int METADATA_NULL_TAG = 19;
/*  196 */   private String[] dataNames = { "currentRow", "insertRow", "deleteRow", "modifyRow", "columnValue", "updateValue", "null" };
/*      */   private static final int DATA_CURRENTROW_TAG = 0;
/*      */   private static final int DATA_INSERTROW_TAG = 1;
/*      */   private static final int DATA_DELETEROW_TAG = 2;
/*      */   private static final int DATA_MODIFYROW_TAG = 3;
/*      */   private static final int DATA_COLUMNVALUE_TAG = 4;
/*      */   private static final int DATA_UPDATEVALUE_TAG = 5;
/*      */   private static final int DATA_NULL_TAG = 6;
/* 1541 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   OracleWebRowSetXmlReaderContHandler(RowSet paramRowSet)
/*      */   {
/*  223 */     this.wrset = ((OracleWebRowSet)paramRowSet);
/*      */ 
/*  225 */     initialize();
/*      */   }
/*      */ 
/*      */   public void characters(char[] paramArrayOfChar, int paramInt1, int paramInt2)
/*      */     throws SAXException
/*      */   {
/*  246 */     String str = new String(paramArrayOfChar, paramInt1, paramInt2);
/*  247 */     processElement(str);
/*      */   }
/*      */ 
/*      */   public void endDocument()
/*      */     throws SAXException
/*      */   {
/*      */     try
/*      */     {
/*  260 */       if (this.readReadOnlyValue)
/*      */       {
/*  262 */         this.wrset.setReadOnly(this.readReadOnlyValue);
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/*  268 */       throw new SAXException(localSQLException.getMessage());
/*      */     }
/*      */   }
/*      */ 
/*      */   public void endElement(String paramString1, String paramString2, String paramString3)
/*      */     throws SAXException
/*      */   {
/*  291 */     String str = (paramString2 == null) || (paramString2.equals("")) ? paramString3 : paramString2;
/*      */ 
/*  293 */     switch (getState())
/*      */     {
/*      */     case 1:
/*  296 */       if (str.equals("properties"))
/*      */       {
/*  298 */         this.state = 0;
/*      */       }
/*      */       else
/*      */       {
/*      */         try
/*      */         {
/*  304 */           int i = ((Integer)this.propertyNameTagMap.get(str)).intValue();
/*      */ 
/*  306 */           switch (i)
/*      */           {
/*      */           case 7:
/*  309 */             if (this.keyCols != null)
/*      */             {
/*  311 */               int[] arrayOfInt = new int[this.keyCols.size()];
/*      */ 
/*  313 */               for (int k = 0; k < arrayOfInt.length; k++) {
/*  314 */                 arrayOfInt[k] = Integer.parseInt((String)this.keyCols.elementAt(k));
/*      */               }
/*  316 */               this.wrset.setKeyColumns(arrayOfInt);
/*      */             }
/*      */ 
/*      */             break;
/*      */           }
/*      */ 
/*  329 */           setPropertyValue(this.propertyValue);
/*      */         }
/*      */         catch (SQLException localSQLException1)
/*      */         {
/*  334 */           throw new SAXException(localSQLException1.getMessage());
/*      */         }
/*      */ 
/*  338 */         this.propertyValue = "";
/*      */ 
/*  341 */         setNullValue(false);
/*      */ 
/*  344 */         setTag(-1);
/*      */       }
/*      */ 
/*  347 */       break;
/*      */     case 2:
/*  350 */       if (str.equals("metadata"))
/*      */       {
/*      */         try
/*      */         {
/*  354 */           this.wrset.setMetaData(this.rsetMetaData);
/*      */ 
/*  359 */           this.state = 0;
/*      */         }
/*      */         catch (SQLException localSQLException2)
/*      */         {
/*  365 */           throw new SAXException("Error setting metadata in WebRowSet: " + localSQLException2.getMessage());
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/*      */         try
/*      */         {
/*  382 */           setMetaDataValue(this.metadataValue);
/*      */         }
/*      */         catch (SQLException localSQLException3)
/*      */         {
/*  391 */           throw new SAXException("Error setting metadata value: " + localSQLException3.getMessage());
/*      */         }
/*      */ 
/*  397 */         this.metadataValue = "";
/*      */ 
/*  400 */         setNullValue(false);
/*      */ 
/*  403 */         setTag(-1);
/*      */       }
/*      */ 
/*  406 */       break;
/*      */     case 3:
/*  409 */       if (str.equals("data"))
/*      */       {
/*  411 */         this.state = 0;
/*  412 */         return;
/*      */       }
/*      */ 
/*  416 */       int j = ((Integer)this.dataNameTagMap.get(str)).intValue();
/*      */ 
/*  418 */       switch (j)
/*      */       {
/*      */       default:
/*  421 */         break;
/*      */       case 4:
/*      */         try
/*      */         {
/*  426 */           this.columnIndex += 1;
/*      */ 
/*  437 */           insertValue(this.columnValue);
/*      */ 
/*  441 */           this.columnValue = "";
/*      */ 
/*  444 */           setNullValue(false);
/*      */ 
/*  447 */           setTag(-1);
/*      */         }
/*      */         catch (SQLException localSQLException4)
/*      */         {
/*  451 */           throw new SAXException("Error inserting column values: " + localSQLException4.getMessage());
/*      */         }
/*      */ 
/*      */       case 0:
/*      */         try
/*      */         {
/*  461 */           this.wrset.insertRow();
/*  462 */           this.wrset.moveToCurrentRow();
/*  463 */           this.wrset.next();
/*      */ 
/*  465 */           OracleRow localOracleRow1 = this.wrset.getCurrentRow();
/*  466 */           localOracleRow1.setInsertedFlag(false);
/*  467 */           applyUpdates();
/*      */         }
/*      */         catch (SQLException localSQLException5)
/*      */         {
/*  471 */           throw new SAXException("Error constructing current row: " + localSQLException5.getMessage());
/*      */         }
/*      */ 
/*      */       case 2:
/*      */         try
/*      */         {
/*  481 */           this.wrset.insertRow();
/*  482 */           this.wrset.moveToCurrentRow();
/*  483 */           this.wrset.next();
/*      */ 
/*  485 */           OracleRow localOracleRow2 = this.wrset.getCurrentRow();
/*  486 */           localOracleRow2.setInsertedFlag(false);
/*  487 */           localOracleRow2.setRowDeleted(true);
/*  488 */           applyUpdates();
/*      */         }
/*      */         catch (SQLException localSQLException6)
/*      */         {
/*  492 */           throw new SAXException("Error constructing deleted row: " + localSQLException6.getMessage());
/*      */         }
/*      */ 
/*      */       case 1:
/*      */         try
/*      */         {
/*  502 */           this.wrset.insertRow();
/*  503 */           this.wrset.moveToCurrentRow();
/*  504 */           this.wrset.next();
/*      */ 
/*  506 */           applyUpdates();
/*      */         }
/*      */         catch (SQLException localSQLException7)
/*      */         {
/*  510 */           throw new SAXException("Error constructing inserted row: " + localSQLException7.getMessage());
/*      */         }
/*      */ 
/*      */       case 3:
/*      */         try
/*      */         {
/*  520 */           this.wrset.insertRow();
/*  521 */           this.wrset.moveToCurrentRow();
/*  522 */           this.wrset.next();
/*      */ 
/*  524 */           OracleRow localOracleRow3 = this.wrset.getCurrentRow();
/*  525 */           localOracleRow3.setRowDeleted(true);
/*  526 */           applyUpdates();
/*      */         }
/*      */         catch (SQLException localSQLException8)
/*      */         {
/*  530 */           throw new SAXException("Error constructing modified row: " + localSQLException8.getMessage());
/*      */         }
/*      */       }
/*      */       break;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void startElement(String paramString1, String paramString2, String paramString3, Attributes paramAttributes)
/*      */     throws SAXException
/*      */   {
/*  549 */     String str = (paramString2 == null) || (paramString2.equals("")) ? paramString3 : paramString2;
/*      */ 
/*  552 */     switch (getState())
/*      */     {
/*      */     case 1:
/*  555 */       int i = ((Integer)this.propertyNameTagMap.get(str)).intValue();
/*      */ 
/*  560 */       if (i == 18)
/*      */       {
/*  563 */         setNullValue(true);
/*  564 */         this.propertyValue = null;
/*      */       }
/*      */       else
/*      */       {
/*  569 */         setTag(i);
/*      */       }
/*      */ 
/*  572 */       break;
/*      */     case 2:
/*  575 */       int j = ((Integer)this.metadataNameTagMap.get(str)).intValue();
/*      */ 
/*  580 */       if (j == 19)
/*      */       {
/*  583 */         setNullValue(true);
/*  584 */         this.metadataValue = null;
/*      */       }
/*      */       else
/*      */       {
/*  589 */         setTag(j);
/*      */       }
/*      */ 
/*  592 */       break;
/*      */     case 3:
/*  595 */       int k = ((Integer)this.dataNameTagMap.get(str)).intValue();
/*      */ 
/*  598 */       if (k == 6)
/*      */       {
/*  600 */         setNullValue(true);
/*  601 */         this.columnValue = null;
/*      */       }
/*      */       else
/*      */       {
/*  605 */         setTag(k);
/*      */ 
/*  607 */         if ((k == 0) || (k == 1) || (k == 2) || (k == 3))
/*      */         {
/*  615 */           this.columnIndex = 0;
/*      */           try
/*      */           {
/*  619 */             this.wrset.moveToInsertRow();
/*      */           } catch (SQLException localSQLException) {
/*      */           }
/*      */         }
/*      */       }
/*      */       break;
/*      */     default:
/*  626 */       setState(str);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void error(SAXParseException paramSAXParseException)
/*      */     throws SAXParseException
/*      */   {
/*  636 */     throw paramSAXParseException;
/*      */   }
/*      */ 
/*      */   public void warning(SAXParseException paramSAXParseException)
/*      */     throws SAXParseException
/*      */   {
/*  643 */     System.out.println("** Warning, line " + paramSAXParseException.getLineNumber() + ", uri " + paramSAXParseException.getSystemId());
/*      */ 
/*  645 */     System.out.println("   " + paramSAXParseException.getMessage());
/*      */   }
/*      */ 
/*      */   private void initialize()
/*      */   {
/*  657 */     this.propertyNameTagMap = new Hashtable(30);
/*  658 */     int i = this.propertyNames.length;
/*  659 */     for (int j = 0; j < i; j++) {
/*  660 */       this.propertyNameTagMap.put(this.propertyNames[j], Integer.valueOf(j));
/*      */     }
/*  662 */     this.metadataNameTagMap = new Hashtable(30);
/*  663 */     i = this.metadataNames.length;
/*  664 */     for (j = 0; j < i; j++) {
/*  665 */       this.metadataNameTagMap.put(this.metadataNames[j], Integer.valueOf(j));
/*      */     }
/*  667 */     this.dataNameTagMap = new Hashtable(10);
/*  668 */     i = this.dataNames.length;
/*  669 */     for (j = 0; j < i; j++) {
/*  670 */       this.dataNameTagMap.put(this.dataNames[j], Integer.valueOf(j));
/*      */     }
/*  672 */     this.updatesToRowSet = new Vector();
/*  673 */     this.columnValue = "";
/*  674 */     this.propertyValue = "";
/*  675 */     this.metadataValue = "";
/*  676 */     this.isNullValue = false;
/*  677 */     this.columnIndex = 0;
/*      */ 
/*  679 */     this.readReadOnlyValue = false;
/*      */   }
/*      */ 
/*      */   protected void processElement(String paramString)
/*      */     throws SAXException
/*      */   {
/*      */     try
/*      */     {
/*  688 */       switch (getState())
/*      */       {
/*      */       case 1:
/*  691 */         this.propertyValue = paramString;
/*  692 */         break;
/*      */       case 2:
/*  695 */         this.metadataValue = paramString;
/*  696 */         break;
/*      */       case 3:
/*  699 */         setDataValue(paramString);
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/*  706 */       throw new SAXException("processElement: " + localSQLException.getMessage());
/*      */     }
/*      */   }
/*      */ 
/*      */   private BigDecimal getBigDecimalValue(String paramString)
/*      */   {
/*  712 */     return new BigDecimal(paramString);
/*      */   }
/*      */ 
/*      */   private byte[] getBinaryValue(String paramString) throws SQLException
/*      */   {
/*  717 */     byte[] arrayOfByte = XMLUtil.parseBase64Binary(paramString);
/*  718 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   private boolean getBooleanValue(String paramString)
/*      */   {
/*  723 */     return Boolean.valueOf(paramString).booleanValue();
/*      */   }
/*      */ 
/*      */   private byte getByteValue(String paramString)
/*      */   {
/*  728 */     return Byte.parseByte(paramString);
/*      */   }
/*      */ 
/*      */   private Date getDateValue(String paramString)
/*      */   {
/*  733 */     return new Date(getLongValue(paramString));
/*      */   }
/*      */ 
/*      */   private double getDoubleValue(String paramString)
/*      */   {
/*  738 */     return Double.parseDouble(paramString);
/*      */   }
/*      */ 
/*      */   private float getFloatValue(String paramString)
/*      */   {
/*  743 */     return Float.parseFloat(paramString);
/*      */   }
/*      */ 
/*      */   private int getIntegerValue(String paramString)
/*      */   {
/*  748 */     return Integer.parseInt(paramString);
/*      */   }
/*      */ 
/*      */   private long getLongValue(String paramString)
/*      */   {
/*  753 */     return Long.parseLong(paramString);
/*      */   }
/*      */ 
/*      */   private boolean getNullValue()
/*      */   {
/*  758 */     return this.isNullValue;
/*      */   }
/*      */ 
/*      */   private short getShortValue(String paramString)
/*      */   {
/*  763 */     return Short.parseShort(paramString);
/*      */   }
/*      */ 
/*      */   private String getStringValue(String paramString)
/*      */   {
/*  768 */     return paramString;
/*      */   }
/*      */ 
/*      */   private Time getTimeValue(String paramString)
/*      */   {
/*  773 */     return new Time(getLongValue(paramString));
/*      */   }
/*      */ 
/*      */   private Timestamp getTimestampValue(String paramString)
/*      */   {
/*  778 */     return new Timestamp(getLongValue(paramString));
/*      */   }
/*      */ 
/*      */   private Blob getBlobValue(String paramString)
/*      */     throws SQLException
/*      */   {
/*  784 */     byte[] arrayOfByte = XMLUtil.parseBase64Binary(paramString);
/*  785 */     return new OracleSerialBlob(arrayOfByte);
/*      */   }
/*      */ 
/*      */   private Clob getClobValue(String paramString)
/*      */     throws SQLException
/*      */   {
/*  791 */     return new OracleSerialClob(paramString.toCharArray());
/*      */   }
/*      */ 
/*      */   private void applyUpdates()
/*      */     throws SAXException
/*      */   {
/*  797 */     if (this.updatesToRowSet.size() > 0)
/*      */     {
/*      */       try
/*      */       {
/*  802 */         Iterator localIterator = this.updatesToRowSet.iterator();
/*  803 */         while (localIterator.hasNext())
/*      */         {
/*  805 */           Object[] arrayOfObject = (Object[])localIterator.next();
/*  806 */           this.columnIndex = ((Integer)arrayOfObject[0]).intValue();
/*  807 */           insertValue((String)arrayOfObject[1]);
/*      */         }
/*      */ 
/*  810 */         this.wrset.updateRow();
/*      */       }
/*      */       catch (SQLException localSQLException)
/*      */       {
/*  814 */         throw new SAXException("Error updating row: " + localSQLException.getMessage());
/*      */       }
/*      */ 
/*  818 */       this.updatesToRowSet.removeAllElements();
/*      */     }
/*      */   }
/*      */ 
/*      */   private void insertValue(String paramString)
/*      */     throws SQLException
/*      */   {
/*  825 */     if ((getNullValue()) || (paramString == null))
/*      */     {
/*  827 */       this.wrset.updateNull(this.columnIndex);
/*  828 */       return;
/*      */     }
/*      */ 
/*  831 */     int i = this.wrset.getMetaData().getColumnType(this.columnIndex);
/*      */ 
/*  833 */     switch (i)
/*      */     {
/*      */     case -7:
/*  836 */       this.wrset.updateByte(this.columnIndex, getByteValue(paramString));
/*  837 */       break;
/*      */     case 5:
/*  840 */       this.wrset.updateShort(this.columnIndex, getShortValue(paramString));
/*  841 */       break;
/*      */     case 4:
/*  844 */       this.wrset.updateInt(this.columnIndex, getIntegerValue(paramString));
/*  845 */       break;
/*      */     case -5:
/*  848 */       this.wrset.updateLong(this.columnIndex, getLongValue(paramString));
/*  849 */       break;
/*      */     case 6:
/*      */     case 7:
/*  853 */       this.wrset.updateFloat(this.columnIndex, getFloatValue(paramString));
/*  854 */       break;
/*      */     case 8:
/*  857 */       this.wrset.updateDouble(this.columnIndex, getDoubleValue(paramString));
/*  858 */       break;
/*      */     case 2:
/*      */     case 3:
/*  862 */       this.wrset.updateObject(this.columnIndex, getBigDecimalValue(paramString));
/*  863 */       break;
/*      */     case -4:
/*      */     case -3:
/*      */     case -2:
/*  868 */       this.wrset.updateBytes(this.columnIndex, getBinaryValue(paramString));
/*  869 */       break;
/*      */     case 91:
/*  872 */       this.wrset.updateDate(this.columnIndex, getDateValue(paramString));
/*  873 */       break;
/*      */     case 92:
/*  876 */       this.wrset.updateTime(this.columnIndex, getTimeValue(paramString));
/*  877 */       break;
/*      */     case 93:
/*  880 */       this.wrset.updateTimestamp(this.columnIndex, getTimestampValue(paramString));
/*  881 */       break;
/*      */     case -15:
/*      */     case -9:
/*      */     case -1:
/*      */     case 1:
/*      */     case 12:
/*  888 */       this.wrset.updateString(this.columnIndex, getStringValue(paramString));
/*  889 */       break;
/*      */     case 2004:
/*  892 */       this.wrset.updateBlob(this.columnIndex, getBlobValue(paramString));
/*  893 */       break;
/*      */     case 2005:
/*  896 */       this.wrset.updateClob(this.columnIndex, getClobValue(paramString));
/*  897 */       break;
/*      */     case 2011:
/*  900 */       this.wrset.updateNClob(this.columnIndex, (NClob)getClobValue(paramString));
/*  901 */       break;
/*      */     default:
/*  904 */       throw new SQLException("The type " + i + " is not supported currently.");
/*      */     }
/*      */   }
/*      */ 
/*      */   private void setPropertyValue(String paramString)
/*      */     throws SQLException
/*      */   {
/*  911 */     boolean bool = getNullValue();
/*      */     SQLException localSQLException1;
/*      */     SQLException localSQLException2;
/*  913 */     switch (getTag()) { case 7:
/*      */     case 8:
/*      */     case 17:
/*      */     case 18:
/*      */     case 20:
/*      */     case 21:
/*      */     default:
/*  920 */       break;
/*      */     case 0:
/*  923 */       if (bool)
/*      */       {
/*  926 */         this.wrset.setCommand(null);
/*      */       }
/*      */       else
/*      */       {
/*  931 */         this.wrset.setCommand(paramString);
/*      */       }
/*      */ 
/*  934 */       break;
/*      */     case 1:
/*  937 */       if (bool)
/*      */       {
/*  941 */         localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 357);
/*  942 */         localSQLException1.fillInStackTrace();
/*  943 */         throw localSQLException1;
/*      */       }
/*      */ 
/*  948 */       this.wrset.setConcurrency(getIntegerValue(paramString));
/*  949 */       break;
/*      */     case 2:
/*  952 */       if (bool)
/*      */       {
/*  955 */         this.wrset.setDataSourceName(null);
/*      */       }
/*      */       else
/*      */       {
/*  960 */         this.wrset.setDataSourceName(paramString);
/*      */       }
/*      */ 
/*  963 */       break;
/*      */     case 3:
/*  966 */       if (bool)
/*      */       {
/*  970 */         localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 357);
/*  971 */         localSQLException1.fillInStackTrace();
/*  972 */         throw localSQLException1;
/*      */       }
/*      */ 
/*  977 */       this.wrset.setEscapeProcessing(getBooleanValue(paramString));
/*  978 */       break;
/*      */     case 4:
/*  981 */       if (bool)
/*      */       {
/*  985 */         localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 357);
/*  986 */         localSQLException1.fillInStackTrace();
/*  987 */         throw localSQLException1;
/*      */       }
/*      */ 
/*  992 */       int i = this.wrset.getType();
/*  993 */       if (i != 1005)
/*      */       {
/*  995 */         this.wrset.setFetchDirection(getIntegerValue(paramString)); } break;
/*      */     case 5:
/* 1001 */       if (bool)
/*      */       {
/* 1005 */         localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 357);
/* 1006 */         localSQLException2.fillInStackTrace();
/* 1007 */         throw localSQLException2;
/*      */       }
/*      */ 
/* 1012 */       this.wrset.setFetchSize(getIntegerValue(paramString));
/* 1013 */       break;
/*      */     case 6:
/* 1016 */       if (bool)
/*      */       {
/* 1020 */         localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 357);
/* 1021 */         localSQLException2.fillInStackTrace();
/* 1022 */         throw localSQLException2;
/*      */       }
/*      */ 
/* 1027 */       this.wrset.setTransactionIsolation(getIntegerValue(paramString));
/* 1028 */       break;
/*      */     case 19:
/* 1031 */       if (this.keyCols == null)
/*      */       {
/* 1033 */         this.keyCols = new Vector();
/*      */       }
/*      */ 
/* 1036 */       this.keyCols.add(paramString);
/* 1037 */       break;
/*      */     case 9:
/* 1040 */       if (bool)
/*      */       {
/* 1044 */         localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 357);
/* 1045 */         localSQLException2.fillInStackTrace();
/* 1046 */         throw localSQLException2;
/*      */       }
/*      */ 
/* 1051 */       this.wrset.setMaxFieldSize(getIntegerValue(paramString));
/* 1052 */       break;
/*      */     case 10:
/* 1055 */       if (bool)
/*      */       {
/* 1059 */         localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 357);
/* 1060 */         localSQLException2.fillInStackTrace();
/* 1061 */         throw localSQLException2;
/*      */       }
/*      */ 
/* 1066 */       this.wrset.setMaxRows(getIntegerValue(paramString));
/* 1067 */       break;
/*      */     case 11:
/* 1070 */       if (bool)
/*      */       {
/* 1074 */         localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 357);
/* 1075 */         localSQLException2.fillInStackTrace();
/* 1076 */         throw localSQLException2;
/*      */       }
/*      */ 
/* 1081 */       this.wrset.setQueryTimeout(getIntegerValue(paramString));
/* 1082 */       break;
/*      */     case 12:
/* 1085 */       if (bool)
/*      */       {
/* 1089 */         localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 357);
/* 1090 */         localSQLException2.fillInStackTrace();
/* 1091 */         throw localSQLException2;
/*      */       }
/*      */ 
/* 1097 */       this.readReadOnlyValue = getBooleanValue(paramString);
/*      */ 
/* 1099 */       break;
/*      */     case 13:
/* 1102 */       if (bool)
/*      */       {
/* 1106 */         localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 357);
/* 1107 */         localSQLException2.fillInStackTrace();
/* 1108 */         throw localSQLException2;
/*      */       }
/*      */ 
/* 1113 */       this.wrset.setType(getIntegerValue(paramString));
/*      */ 
/* 1115 */       break;
/*      */     case 14:
/* 1118 */       if (bool)
/*      */       {
/* 1122 */         localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 357);
/* 1123 */         localSQLException2.fillInStackTrace();
/* 1124 */         throw localSQLException2;
/*      */       }
/*      */ 
/* 1129 */       this.wrset.setShowDeleted(getBooleanValue(paramString));
/* 1130 */       break;
/*      */     case 15:
/* 1133 */       if (bool)
/*      */       {
/* 1136 */         this.wrset.setTableName(null);
/*      */       }
/*      */       else
/*      */       {
/* 1141 */         this.wrset.setTableName(paramString);
/*      */       }
/*      */ 
/* 1144 */       break;
/*      */     case 16:
/* 1147 */       if (bool)
/*      */       {
/* 1150 */         this.wrset.setUrl(null);
/*      */       }
/*      */       else
/*      */       {
/* 1155 */         this.wrset.setUrl(paramString);
/*      */       }
/*      */ 
/* 1158 */       break;
/*      */     case 22:
/* 1161 */       if (bool)
/*      */       {
/* 1164 */         this.wrset.setSyncProvider(null);
/*      */       }
/*      */       else
/*      */       {
/* 1169 */         this.wrset.setSyncProvider(paramString);
/*      */       }
/*      */       break;
/*      */     }
/*      */   }
/*      */ 
/*      */   private void setMetaDataValue(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1180 */     boolean bool = getNullValue();
/*      */     SQLException localSQLException2;
/* 1182 */     switch (getTag())
/*      */     {
/*      */     case 1:
/*      */     default:
/* 1186 */       break;
/*      */     case 0:
/* 1189 */       if (bool)
/*      */       {
/* 1193 */         SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 358);
/* 1194 */         localSQLException1.fillInStackTrace();
/* 1195 */         throw localSQLException1;
/*      */       }
/*      */ 
/* 1200 */       int i = getIntegerValue(paramString);
/*      */ 
/* 1203 */       this.rsetMetaData = new OracleRowSetMetaData(i);
/*      */ 
/* 1206 */       this.columnIndex = 0;
/*      */ 
/* 1208 */       break;
/*      */     case 2:
/* 1211 */       this.columnIndex += 1;
/* 1212 */       break;
/*      */     case 3:
/* 1215 */       if (bool)
/*      */       {
/* 1219 */         localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 358);
/* 1220 */         localSQLException2.fillInStackTrace();
/* 1221 */         throw localSQLException2;
/*      */       }
/*      */ 
/* 1226 */       this.rsetMetaData.setAutoIncrement(this.columnIndex, getBooleanValue(paramString));
/* 1227 */       break;
/*      */     case 4:
/* 1230 */       if (bool)
/*      */       {
/* 1234 */         localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 358);
/* 1235 */         localSQLException2.fillInStackTrace();
/* 1236 */         throw localSQLException2;
/*      */       }
/*      */ 
/* 1241 */       this.rsetMetaData.setCaseSensitive(this.columnIndex, getBooleanValue(paramString));
/* 1242 */       break;
/*      */     case 5:
/* 1245 */       if (bool)
/*      */       {
/* 1249 */         localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 358);
/* 1250 */         localSQLException2.fillInStackTrace();
/* 1251 */         throw localSQLException2;
/*      */       }
/*      */ 
/* 1256 */       this.rsetMetaData.setCurrency(this.columnIndex, getBooleanValue(paramString));
/* 1257 */       break;
/*      */     case 6:
/* 1260 */       if (bool)
/*      */       {
/* 1264 */         localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 358);
/* 1265 */         localSQLException2.fillInStackTrace();
/* 1266 */         throw localSQLException2;
/*      */       }
/*      */ 
/* 1271 */       this.rsetMetaData.setNullable(this.columnIndex, getIntegerValue(paramString));
/* 1272 */       break;
/*      */     case 7:
/* 1275 */       if (bool)
/*      */       {
/* 1279 */         localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 358);
/* 1280 */         localSQLException2.fillInStackTrace();
/* 1281 */         throw localSQLException2;
/*      */       }
/*      */ 
/* 1286 */       this.rsetMetaData.setSigned(this.columnIndex, getBooleanValue(paramString));
/* 1287 */       break;
/*      */     case 8:
/* 1290 */       if (bool)
/*      */       {
/* 1294 */         localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 358);
/* 1295 */         localSQLException2.fillInStackTrace();
/* 1296 */         throw localSQLException2;
/*      */       }
/*      */ 
/* 1301 */       this.rsetMetaData.setSearchable(this.columnIndex, getBooleanValue(paramString));
/* 1302 */       break;
/*      */     case 9:
/* 1305 */       if (bool)
/*      */       {
/* 1309 */         localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 358);
/* 1310 */         localSQLException2.fillInStackTrace();
/* 1311 */         throw localSQLException2;
/*      */       }
/*      */ 
/* 1316 */       this.rsetMetaData.setColumnDisplaySize(this.columnIndex, getIntegerValue(paramString));
/* 1317 */       break;
/*      */     case 10:
/* 1320 */       if (bool)
/*      */       {
/* 1323 */         this.rsetMetaData.setColumnLabel(this.columnIndex, null);
/*      */       }
/*      */       else
/*      */       {
/* 1328 */         this.rsetMetaData.setColumnLabel(this.columnIndex, paramString);
/*      */       }
/*      */ 
/* 1331 */       break;
/*      */     case 11:
/* 1334 */       if (bool)
/*      */       {
/* 1337 */         this.rsetMetaData.setColumnName(this.columnIndex, null);
/*      */       }
/*      */       else
/*      */       {
/* 1342 */         this.rsetMetaData.setColumnName(this.columnIndex, paramString);
/*      */       }
/*      */ 
/* 1345 */       break;
/*      */     case 12:
/* 1348 */       if (bool)
/*      */       {
/* 1351 */         this.rsetMetaData.setSchemaName(this.columnIndex, null);
/*      */       }
/*      */       else
/*      */       {
/* 1356 */         this.rsetMetaData.setSchemaName(this.columnIndex, paramString);
/*      */       }
/*      */ 
/* 1359 */       break;
/*      */     case 13:
/* 1362 */       if (bool)
/*      */       {
/* 1366 */         localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 358);
/* 1367 */         localSQLException2.fillInStackTrace();
/* 1368 */         throw localSQLException2;
/*      */       }
/*      */ 
/* 1373 */       this.rsetMetaData.setPrecision(this.columnIndex, getIntegerValue(paramString));
/* 1374 */       break;
/*      */     case 14:
/* 1377 */       if (bool)
/*      */       {
/* 1381 */         localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 358);
/* 1382 */         localSQLException2.fillInStackTrace();
/* 1383 */         throw localSQLException2;
/*      */       }
/*      */ 
/* 1388 */       this.rsetMetaData.setScale(this.columnIndex, getIntegerValue(paramString));
/* 1389 */       break;
/*      */     case 15:
/* 1392 */       if (bool)
/*      */       {
/* 1395 */         this.rsetMetaData.setTableName(this.columnIndex, null);
/*      */       }
/*      */       else
/*      */       {
/* 1400 */         this.rsetMetaData.setTableName(this.columnIndex, paramString);
/*      */       }
/*      */ 
/* 1403 */       break;
/*      */     case 16:
/* 1406 */       if (bool)
/*      */       {
/* 1409 */         this.rsetMetaData.setCatalogName(this.columnIndex, null);
/*      */       }
/*      */       else
/*      */       {
/* 1414 */         this.rsetMetaData.setCatalogName(this.columnIndex, paramString);
/*      */       }
/*      */ 
/* 1417 */       break;
/*      */     case 17:
/* 1420 */       if (bool)
/*      */       {
/* 1424 */         localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 358);
/* 1425 */         localSQLException2.fillInStackTrace();
/* 1426 */         throw localSQLException2;
/*      */       }
/*      */ 
/* 1431 */       this.rsetMetaData.setColumnType(this.columnIndex, getIntegerValue(paramString));
/* 1432 */       break;
/*      */     case 18:
/* 1435 */       if (bool)
/*      */       {
/* 1438 */         this.rsetMetaData.setColumnTypeName(this.columnIndex, null);
/*      */       }
/*      */       else
/*      */       {
/* 1443 */         this.rsetMetaData.setColumnTypeName(this.columnIndex, paramString);
/*      */       }
/*      */       break;
/*      */     }
/*      */   }
/*      */ 
/*      */   private void setDataValue(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1454 */     switch (getTag())
/*      */     {
/*      */     case 1:
/*      */     case 2:
/*      */     case 3:
/*      */     default:
/* 1460 */       break;
/*      */     case 4:
/* 1463 */       this.columnValue = paramString;
/* 1464 */       break;
/*      */     case 5:
/* 1467 */       Object[] arrayOfObject = new Object[2];
/* 1468 */       arrayOfObject[1] = paramString;
/* 1469 */       arrayOfObject[0] = Integer.valueOf(this.columnIndex);
/* 1470 */       this.updatesToRowSet.add(arrayOfObject);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void setNullValue(boolean paramBoolean)
/*      */   {
/* 1478 */     this.isNullValue = paramBoolean;
/*      */   }
/*      */ 
/*      */   private int getState()
/*      */   {
/* 1483 */     return this.state;
/*      */   }
/*      */ 
/*      */   private int getTag()
/*      */   {
/* 1488 */     return this.tag;
/*      */   }
/*      */ 
/*      */   private void setState(String paramString)
/*      */     throws SAXException
/*      */   {
/* 1494 */     if (paramString.equals("webRowSet")) {
/* 1495 */       this.state = 0;
/*      */     }
/* 1497 */     else if (paramString.equals("properties"))
/*      */     {
/* 1499 */       if (this.state != 1)
/* 1500 */         this.state = 1;
/*      */       else {
/* 1502 */         this.state = 0;
/*      */       }
/*      */     }
/* 1505 */     else if (paramString.equals("metadata"))
/*      */     {
/* 1507 */       if (this.state != 2)
/* 1508 */         this.state = 2;
/*      */       else {
/* 1510 */         this.state = 0;
/*      */       }
/*      */     }
/* 1513 */     else if (paramString.equals("data"))
/* 1514 */       if (this.state != 3)
/* 1515 */         this.state = 3;
/*      */       else
/* 1517 */         this.state = 0;
/*      */   }
/*      */ 
/*      */   private void setTag(int paramInt)
/*      */   {
/* 1522 */     this.tag = paramInt;
/*      */   }
/*      */ 
/*      */   protected OracleConnection getConnectionDuringExceptionHandling()
/*      */   {
/* 1536 */     return null;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.rowset.OracleWebRowSetXmlReaderContHandler
 * JD-Core Version:    0.6.2
 */