/*     */ package oracle.jdbc.rowset;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.io.InputStreamReader;
/*     */ import java.io.OutputStream;
/*     */ import java.io.OutputStreamWriter;
/*     */ import java.io.Reader;
/*     */ import java.io.Writer;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import javax.sql.rowset.WebRowSet;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ 
/*     */ public class OracleWebRowSet extends OracleCachedRowSet
/*     */   implements WebRowSet
/*     */ {
/*     */   static final long serialVersionUID = 617253792409477080L;
/*     */   private transient OracleWebRowSetXmlReader xmlReader;
/*     */   private transient OracleWebRowSetXmlWriter xmlWriter;
/* 224 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public OracleWebRowSet()
/*     */     throws SQLException
/*     */   {
/*  53 */     this.xmlReader = new OracleWebRowSetXmlReaderImpl();
/*  54 */     this.xmlWriter = new OracleWebRowSetXmlWriterImpl();
/*     */ 
/*  57 */     setReadOnly(false);
/*     */   }
/*     */ 
/*     */   public void readXml(Reader paramReader)
/*     */     throws SQLException
/*     */   {
/*  79 */     if (this.xmlReader != null)
/*     */     {
/*  81 */       this.xmlReader.readXML(this, paramReader);
/*     */     }
/*     */     else
/*     */     {
/*  86 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 355);
/*  87 */       localSQLException.fillInStackTrace();
/*  88 */       throw localSQLException;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void writeXml(Writer paramWriter)
/*     */     throws SQLException
/*     */   {
/* 114 */     if (this.xmlWriter != null)
/*     */     {
/* 116 */       this.xmlWriter.writeXML(this, paramWriter);
/*     */     }
/*     */     else
/*     */     {
/* 121 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 356);
/* 122 */       localSQLException.fillInStackTrace();
/* 123 */       throw localSQLException;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void writeXml(ResultSet paramResultSet, Writer paramWriter)
/*     */     throws SQLException
/*     */   {
/* 148 */     populate(paramResultSet);
/* 149 */     writeXml(paramWriter);
/*     */   }
/*     */ 
/*     */   public void readXml(InputStream paramInputStream)
/*     */     throws SQLException
/*     */   {
/* 171 */     readXml(new InputStreamReader(paramInputStream));
/*     */   }
/*     */ 
/*     */   public void writeXml(OutputStream paramOutputStream)
/*     */     throws SQLException
/*     */   {
/* 195 */     writeXml(new OutputStreamWriter(paramOutputStream));
/*     */   }
/*     */ 
/*     */   public void writeXml(ResultSet paramResultSet, OutputStream paramOutputStream)
/*     */     throws SQLException
/*     */   {
/* 218 */     writeXml(paramResultSet, new OutputStreamWriter(paramOutputStream));
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.rowset.OracleWebRowSet
 * JD-Core Version:    0.6.2
 */