/*     */ package oracle.jdbc.rowset;
/*     */ 
/*     */ import java.io.BufferedReader;
/*     */ import java.io.CharArrayReader;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.io.Reader;
/*     */ import java.io.Serializable;
/*     */ import java.io.StringBufferInputStream;
/*     */ import java.io.Writer;
/*     */ import java.sql.Clob;
/*     */ import java.sql.NClob;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ 
/*     */ public class OracleSerialClob
/*     */   implements Clob, NClob, Serializable, Cloneable
/*     */ {
/*     */   private static final int MAX_CHAR_BUFFER_SIZE = 1024;
/*     */   private char[] buffer;
/*     */   private long length;
/*  38 */   private boolean isFreed = false;
/*     */ 
/* 684 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public OracleSerialClob(char[] paramArrayOfChar)
/*     */     throws SQLException
/*     */   {
/*  50 */     if (paramArrayOfChar == null)
/*     */     {
/*  53 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  54 */       localSQLException.fillInStackTrace();
/*  55 */       throw localSQLException;
/*     */     }
/*     */ 
/*  58 */     this.length = paramArrayOfChar.length;
/*  59 */     this.buffer = new char[(int)this.length];
/*  60 */     for (int i = 0; i < this.length; i++)
/*  61 */       this.buffer[i] = paramArrayOfChar[i];
/*     */   }
/*     */ 
/*     */   public OracleSerialClob(Clob paramClob)
/*     */     throws SQLException
/*     */   {
/*  76 */     if (paramClob == null)
/*     */     {
/*  79 */       localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  80 */       ((SQLException)localObject1).fillInStackTrace();
/*  81 */       throw ((Throwable)localObject1);
/*     */     }
/*     */ 
/*  85 */     this.length = paramClob.length();
/*  86 */     this.buffer = new char[(int)this.length];
/*  87 */     Object localObject1 = new BufferedReader(paramClob.getCharacterStream());
/*     */     try
/*     */     {
/*  91 */       int i = 0;
/*  92 */       int j = 0;
/*     */       do
/*     */       {
/*  97 */         i = ((BufferedReader)localObject1).read(this.buffer, j, (int)(this.length - j));
/*     */ 
/*  99 */         j += i;
/* 100 */       }while (i > 0);
/*     */     }
/*     */     catch (IOException localIOException2)
/*     */     {
/* 105 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 347, localIOException2.getMessage());
/* 106 */       localSQLException1.fillInStackTrace();
/* 107 */       throw localSQLException1;
/*     */     }
/*     */     finally
/*     */     {
/*     */       try {
/* 112 */         if (localObject1 != null)
/* 113 */           ((BufferedReader)localObject1).close();
/*     */       }
/*     */       catch (IOException localIOException3)
/*     */       {
/* 117 */         SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 347, localIOException3.getMessage());
/* 118 */         localSQLException2.fillInStackTrace();
/* 119 */         throw localSQLException2;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public OracleSerialClob(Reader paramReader)
/*     */     throws SQLException
/*     */   {
/* 137 */     if (paramReader == null)
/*     */     {
/* 140 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 141 */       localSQLException.fillInStackTrace();
/* 142 */       throw localSQLException;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 148 */       int i = 0;
/* 149 */       localObject = new char[1024];
/* 150 */       StringBuilder localStringBuilder = new StringBuilder(1024);
/*     */       while (true)
/*     */       {
/* 154 */         i = paramReader.read((char[])localObject);
/*     */ 
/* 158 */         if (i == -1) {
/*     */           break;
/*     */         }
/* 161 */         localStringBuilder.append((char[])localObject, 0, i);
/*     */       }
/*     */ 
/* 164 */       paramReader.close();
/*     */ 
/* 166 */       this.buffer = localStringBuilder.toString().toCharArray();
/* 167 */       this.length = this.buffer.length;
/*     */     }
/*     */     catch (Exception localException)
/*     */     {
/* 172 */       Object localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 347, localException.getMessage());
/* 173 */       ((SQLException)localObject).fillInStackTrace();
/* 174 */       throw ((Throwable)localObject);
/*     */     }
/*     */   }
/*     */ 
/*     */   public OracleSerialClob(Reader paramReader, long paramLong)
/*     */     throws SQLException
/*     */   {
/* 191 */     if (paramReader == null)
/*     */     {
/* 194 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 195 */       localSQLException1.fillInStackTrace();
/* 196 */       throw localSQLException1;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 202 */       int i = 0;
/* 203 */       long l = paramLong;
/* 204 */       char[] arrayOfChar = new char[1024];
/* 205 */       StringBuilder localStringBuilder = new StringBuilder(1024);
/*     */ 
/* 207 */       while (l > 0L)
/*     */       {
/* 209 */         i = paramReader.read(arrayOfChar, 0, Math.min(1024, (int)l));
/*     */ 
/* 214 */         if (i == -1) {
/*     */           break;
/*     */         }
/* 217 */         localStringBuilder.append(arrayOfChar, 0, i);
/* 218 */         l -= i;
/*     */       }
/*     */ 
/* 221 */       paramReader.close();
/*     */ 
/* 223 */       this.buffer = localStringBuilder.toString().toCharArray();
/* 224 */       this.length = this.buffer.length;
/*     */     }
/*     */     catch (Exception localException)
/*     */     {
/* 229 */       SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 347, localException.getMessage());
/* 230 */       localSQLException2.fillInStackTrace();
/* 231 */       throw localSQLException2;
/*     */     }
/*     */   }
/*     */ 
/*     */   public InputStream getAsciiStream()
/*     */     throws SQLException
/*     */   {
/* 248 */     if (this.isFreed)
/*     */     {
/* 250 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 251 */       localSQLException.fillInStackTrace();
/* 252 */       throw localSQLException;
/*     */     }
/*     */ 
/* 255 */     return new StringBufferInputStream(new String(this.buffer));
/*     */   }
/*     */ 
/*     */   public Reader getCharacterStream()
/*     */     throws SQLException
/*     */   {
/* 269 */     if (this.isFreed)
/*     */     {
/* 271 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 272 */       localSQLException.fillInStackTrace();
/* 273 */       throw localSQLException;
/*     */     }
/*     */ 
/* 276 */     return new CharArrayReader(this.buffer);
/*     */   }
/*     */ 
/*     */   public String getSubString(long paramLong, int paramInt)
/*     */     throws SQLException
/*     */   {
/*     */     SQLException localSQLException;
/* 292 */     if (this.isFreed)
/*     */     {
/* 294 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 295 */       localSQLException.fillInStackTrace();
/* 296 */       throw localSQLException;
/*     */     }
/*     */ 
/* 299 */     if ((paramLong < 1L) || (paramInt < 0) || (paramInt > this.length) || (paramLong + paramInt - 1L > this.length))
/*     */     {
/* 303 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 304 */       localSQLException.fillInStackTrace();
/* 305 */       throw localSQLException;
/*     */     }
/* 307 */     if (paramInt == 0) {
/* 308 */       return new String();
/*     */     }
/* 310 */     return new String(this.buffer, (int)paramLong - 1, paramInt);
/*     */   }
/*     */ 
/*     */   public long length()
/*     */     throws SQLException
/*     */   {
/* 325 */     if (this.isFreed)
/*     */     {
/* 327 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 328 */       localSQLException.fillInStackTrace();
/* 329 */       throw localSQLException;
/*     */     }
/*     */ 
/* 332 */     return this.length;
/*     */   }
/*     */ 
/*     */   public long position(String paramString, long paramLong)
/*     */     throws SQLException
/*     */   {
/* 348 */     if (this.isFreed)
/*     */     {
/* 350 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 351 */       ((SQLException)localObject).fillInStackTrace();
/* 352 */       throw ((Throwable)localObject);
/*     */     }
/*     */ 
/* 355 */     if (paramLong < 1L)
/*     */     {
/* 357 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "position()");
/* 358 */       ((SQLException)localObject).fillInStackTrace();
/* 359 */       throw ((Throwable)localObject);
/*     */     }
/*     */ 
/* 362 */     if ((paramLong > this.length) || (paramLong + paramString.length() - 1L > this.length)) {
/* 363 */       return -1L;
/*     */     }
/* 365 */     Object localObject = paramString.toCharArray();
/* 366 */     int i = (int)(paramLong - 1L);
/* 367 */     int j = 0;
/* 368 */     long l1 = localObject.length;
/*     */ 
/* 370 */     while (i < this.length)
/*     */     {
/* 372 */       int k = 0;
/* 373 */       long l2 = i + 1;
/* 374 */       int m = i;
/* 375 */       while ((k < l1) && (m < this.length) && (localObject[k] == this.buffer[m]))
/*     */       {
/* 377 */         k++;
/* 378 */         m++;
/* 379 */         if (k == l1) {
/* 380 */           return l2;
/*     */         }
/*     */       }
/* 383 */       i++;
/*     */     }
/* 385 */     return -1L;
/*     */   }
/*     */ 
/*     */   public long position(Clob paramClob, long paramLong)
/*     */     throws SQLException
/*     */   {
/* 399 */     if (this.isFreed)
/*     */     {
/* 401 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 402 */       localSQLException.fillInStackTrace();
/* 403 */       throw localSQLException;
/*     */     }
/*     */ 
/* 406 */     return position(paramClob.getSubString(1L, (int)paramClob.length()), paramLong);
/*     */   }
/*     */ 
/*     */   public int setString(long paramLong, String paramString)
/*     */     throws SQLException
/*     */   {
/* 440 */     if (this.isFreed)
/*     */     {
/* 442 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 443 */       localSQLException.fillInStackTrace();
/* 444 */       throw localSQLException;
/*     */     }
/*     */ 
/* 448 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 449 */     localSQLException.fillInStackTrace();
/* 450 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   public int setString(long paramLong, String paramString, int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 485 */     if (this.isFreed)
/*     */     {
/* 487 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 488 */       localSQLException.fillInStackTrace();
/* 489 */       throw localSQLException;
/*     */     }
/*     */ 
/* 493 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 494 */     localSQLException.fillInStackTrace();
/* 495 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   public OutputStream setAsciiStream(long paramLong)
/*     */     throws SQLException
/*     */   {
/* 526 */     if (this.isFreed)
/*     */     {
/* 528 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 529 */       localSQLException.fillInStackTrace();
/* 530 */       throw localSQLException;
/*     */     }
/*     */ 
/* 534 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 535 */     localSQLException.fillInStackTrace();
/* 536 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   public Writer setCharacterStream(long paramLong)
/*     */     throws SQLException
/*     */   {
/* 568 */     if (this.isFreed)
/*     */     {
/* 570 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 571 */       localSQLException.fillInStackTrace();
/* 572 */       throw localSQLException;
/*     */     }
/*     */ 
/* 576 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 577 */     localSQLException.fillInStackTrace();
/* 578 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   public void truncate(long paramLong)
/*     */     throws SQLException
/*     */   {
/* 606 */     if (this.isFreed)
/*     */     {
/* 608 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 609 */       localSQLException.fillInStackTrace();
/* 610 */       throw localSQLException;
/*     */     }
/*     */ 
/* 614 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 615 */     localSQLException.fillInStackTrace();
/* 616 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   public void free()
/*     */     throws SQLException
/*     */   {
/* 630 */     if (this.isFreed) return;
/*     */ 
/* 632 */     this.isFreed = true;
/* 633 */     this.buffer = null;
/* 634 */     this.length = 0L;
/*     */   }
/*     */ 
/*     */   public Reader getCharacterStream(long paramLong1, long paramLong2)
/*     */     throws SQLException
/*     */   {
/*     */     SQLException localSQLException;
/* 642 */     if (this.isFreed)
/*     */     {
/* 644 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 645 */       localSQLException.fillInStackTrace();
/* 646 */       throw localSQLException;
/*     */     }
/*     */ 
/* 653 */     paramLong1 -= 1L;
/* 654 */     if ((paramLong1 < 0L) || (paramLong1 + 1L > this.length) || (paramLong2 < 0L) || (paramLong2 > this.length) || (paramLong1 + paramLong2 > this.length))
/*     */     {
/* 658 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 659 */       localSQLException.fillInStackTrace();
/* 660 */       throw localSQLException;
/*     */     }
/*     */ 
/* 665 */     return new CharArrayReader(this.buffer, (int)paramLong1, (int)paramLong2);
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 679 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.rowset.OracleSerialClob
 * JD-Core Version:    0.6.2
 */