/*     */ package oracle.jdbc.rowset;
/*     */ 
/*     */ import java.io.BufferedInputStream;
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.sql.Blob;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ 
/*     */ public class OracleSerialBlob
/*     */   implements Blob, Serializable, Cloneable
/*     */ {
/*     */   private byte[] buffer;
/*     */   private long length;
/*  32 */   private boolean isFreed = false;
/*     */ 
/* 510 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public OracleSerialBlob(byte[] paramArrayOfByte)
/*     */     throws SQLException
/*     */   {
/*  44 */     if (paramArrayOfByte == null)
/*     */     {
/*  47 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  48 */       localSQLException.fillInStackTrace();
/*  49 */       throw localSQLException;
/*     */     }
/*     */ 
/*  53 */     this.length = paramArrayOfByte.length;
/*  54 */     this.buffer = new byte[(int)this.length];
/*  55 */     for (int i = 0; i < this.length; i++)
/*  56 */       this.buffer[i] = paramArrayOfByte[i];
/*     */   }
/*     */ 
/*     */   public OracleSerialBlob(Blob paramBlob)
/*     */     throws SQLException
/*     */   {
/*  71 */     if (paramBlob == null)
/*     */     {
/*  74 */       localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  75 */       ((SQLException)localObject1).fillInStackTrace();
/*  76 */       throw ((Throwable)localObject1);
/*     */     }
/*     */ 
/*  79 */     this.length = paramBlob.length();
/*  80 */     this.buffer = new byte[(int)this.length];
/*  81 */     Object localObject1 = new BufferedInputStream(paramBlob.getBinaryStream());
/*     */     try
/*     */     {
/*  85 */       int i = 0;
/*  86 */       int j = 0;
/*     */       do
/*     */       {
/*  91 */         i = ((BufferedInputStream)localObject1).read(this.buffer, j, (int)(this.length - j));
/*     */ 
/*  93 */         j += i;
/*  94 */       }while (i > 0);
/*     */     }
/*     */     catch (IOException localIOException2)
/*     */     {
/*  99 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 346, localIOException2.getMessage());
/* 100 */       localSQLException1.fillInStackTrace();
/* 101 */       throw localSQLException1;
/*     */     }
/*     */     finally
/*     */     {
/*     */       try {
/* 106 */         if (localObject1 != null)
/* 107 */           ((BufferedInputStream)localObject1).close();
/*     */       }
/*     */       catch (IOException localIOException3)
/*     */       {
/* 111 */         SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 346, localIOException3.getMessage());
/* 112 */         localSQLException2.fillInStackTrace();
/* 113 */         throw localSQLException2;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public InputStream getBinaryStream()
/*     */     throws SQLException
/*     */   {
/* 131 */     if (this.isFreed)
/*     */     {
/* 133 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 134 */       localSQLException.fillInStackTrace();
/* 135 */       throw localSQLException;
/*     */     }
/*     */ 
/* 138 */     return new ByteArrayInputStream(this.buffer);
/*     */   }
/*     */ 
/*     */   public byte[] getBytes(long paramLong, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 154 */     if (this.isFreed)
/*     */     {
/* 156 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 157 */       ((SQLException)localObject).fillInStackTrace();
/* 158 */       throw ((Throwable)localObject);
/*     */     }
/*     */ 
/* 161 */     Object localObject = null;
/*     */ 
/* 163 */     paramLong -= 1L;
/* 164 */     if ((paramLong < 0L) || (paramInt > this.length) || (paramLong + paramInt > this.length))
/*     */     {
/* 166 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 167 */       localSQLException.fillInStackTrace();
/* 168 */       throw localSQLException;
/*     */     }
/*     */ 
/* 172 */     localObject = new byte[paramInt];
/* 173 */     System.arraycopy(this.buffer, (int)paramLong, localObject, 0, paramInt);
/*     */ 
/* 176 */     return localObject;
/*     */   }
/*     */ 
/*     */   public long length()
/*     */     throws SQLException
/*     */   {
/* 190 */     if (this.isFreed)
/*     */     {
/* 192 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 193 */       localSQLException.fillInStackTrace();
/* 194 */       throw localSQLException;
/*     */     }
/*     */ 
/* 197 */     return this.length;
/*     */   }
/*     */ 
/*     */   public long position(byte[] paramArrayOfByte, long paramLong)
/*     */     throws SQLException
/*     */   {
/*     */     SQLException localSQLException;
/* 213 */     if (this.isFreed)
/*     */     {
/* 215 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 216 */       localSQLException.fillInStackTrace();
/* 217 */       throw localSQLException;
/*     */     }
/*     */ 
/* 220 */     if (paramLong < 1L)
/*     */     {
/* 222 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "position()");
/* 223 */       localSQLException.fillInStackTrace();
/* 224 */       throw localSQLException;
/*     */     }
/*     */ 
/* 227 */     if ((paramLong > this.length) || (paramLong + paramArrayOfByte.length - 1L > this.length)) {
/* 228 */       return -1L;
/*     */     }
/* 230 */     int i = (int)(paramLong - 1L);
/* 231 */     int j = 0;
/* 232 */     long l1 = paramArrayOfByte.length;
/*     */ 
/* 234 */     while (i < this.length)
/*     */     {
/* 236 */       int k = 0;
/* 237 */       long l2 = i + 1;
/* 238 */       int m = i;
/* 239 */       while ((k < l1) && (m < this.length) && (paramArrayOfByte[k] == this.buffer[m]))
/*     */       {
/* 241 */         k++;
/* 242 */         m++;
/* 243 */         if (k == l1) {
/* 244 */           return l2;
/*     */         }
/*     */       }
/* 247 */       i++;
/*     */     }
/*     */ 
/* 250 */     return -1L;
/*     */   }
/*     */ 
/*     */   public long position(Blob paramBlob, long paramLong)
/*     */     throws SQLException
/*     */   {
/* 264 */     if (this.isFreed)
/*     */     {
/* 266 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 267 */       localSQLException.fillInStackTrace();
/* 268 */       throw localSQLException;
/*     */     }
/*     */ 
/* 271 */     return position(paramBlob.getBytes(1L, (int)paramBlob.length()), paramLong);
/*     */   }
/*     */ 
/*     */   public int setBytes(long paramLong, byte[] paramArrayOfByte)
/*     */     throws SQLException
/*     */   {
/* 305 */     if (this.isFreed)
/*     */     {
/* 307 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 308 */       localSQLException.fillInStackTrace();
/* 309 */       throw localSQLException;
/*     */     }
/*     */ 
/* 313 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 314 */     localSQLException.fillInStackTrace();
/* 315 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   public int setBytes(long paramLong, byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 353 */     if (this.isFreed)
/*     */     {
/* 355 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 356 */       localSQLException.fillInStackTrace();
/* 357 */       throw localSQLException;
/*     */     }
/*     */ 
/* 361 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 362 */     localSQLException.fillInStackTrace();
/* 363 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   public OutputStream setBinaryStream(long paramLong)
/*     */     throws SQLException
/*     */   {
/* 394 */     if (this.isFreed)
/*     */     {
/* 396 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 397 */       localSQLException.fillInStackTrace();
/* 398 */       throw localSQLException;
/*     */     }
/*     */ 
/* 402 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 403 */     localSQLException.fillInStackTrace();
/* 404 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   public void truncate(long paramLong)
/*     */     throws SQLException
/*     */   {
/* 431 */     if (this.isFreed)
/*     */     {
/* 433 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 434 */       localSQLException.fillInStackTrace();
/* 435 */       throw localSQLException;
/*     */     }
/*     */ 
/* 439 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 440 */     localSQLException.fillInStackTrace();
/* 441 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   public void free()
/*     */     throws SQLException
/*     */   {
/* 455 */     if (this.isFreed) return;
/*     */ 
/* 457 */     this.isFreed = true;
/* 458 */     this.buffer = null;
/* 459 */     this.length = 0L;
/*     */   }
/*     */ 
/*     */   public InputStream getBinaryStream(long paramLong1, long paramLong2)
/*     */     throws SQLException
/*     */   {
/*     */     SQLException localSQLException;
/* 467 */     if (this.isFreed)
/*     */     {
/* 469 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 470 */       localSQLException.fillInStackTrace();
/* 471 */       throw localSQLException;
/*     */     }
/*     */ 
/* 478 */     paramLong1 -= 1L;
/* 479 */     if ((paramLong1 < 0L) || (paramLong1 + 1L > this.length) || (paramLong2 > this.length) || (paramLong1 > 2147483647L) || (this.length > 2147483647L) || (paramLong1 + paramLong2 > this.length))
/*     */     {
/* 484 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 485 */       localSQLException.fillInStackTrace();
/* 486 */       throw localSQLException;
/*     */     }
/*     */ 
/* 491 */     return new ByteArrayInputStream(this.buffer, (int)paramLong1, (int)paramLong2);
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 505 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.rowset.OracleSerialBlob
 * JD-Core Version:    0.6.2
 */