/*      */ package oracle.jdbc.rowset;
/*      */ 
/*      */ import java.io.Serializable;
/*      */ import java.sql.ResultSetMetaData;
/*      */ import java.sql.SQLException;
/*      */ import javax.sql.RowSetMetaData;
/*      */ import oracle.jdbc.driver.DatabaseError;
/*      */ import oracle.jdbc.internal.OracleConnection;
/*      */ 
/*      */ public class OracleRowSetMetaData
/*      */   implements RowSetMetaData, Serializable
/*      */ {
/*      */   private int columnCount;
/*      */   private int[] nullable;
/*      */   private int[] columnDisplaySize;
/*      */   private int[] precision;
/*      */   private int[] scale;
/*      */   private int[] columnType;
/*      */   private boolean[] searchable;
/*      */   private boolean[] caseSensitive;
/*      */   private boolean[] readOnly;
/*      */   private boolean[] writable;
/*      */   private boolean[] definatelyWritable;
/*      */   private boolean[] currency;
/*      */   private boolean[] autoIncrement;
/*      */   private boolean[] signed;
/*      */   private String[] columnLabel;
/*      */   private String[] schemaName;
/*      */   private String[] columnName;
/*      */   private String[] tableName;
/*      */   private String[] columnTypeName;
/*      */   private String[] catalogName;
/*      */   private String[] columnClassName;
/* 1096 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   OracleRowSetMetaData(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  146 */     this.columnCount = paramInt;
/*  147 */     this.searchable = new boolean[this.columnCount];
/*  148 */     this.caseSensitive = new boolean[this.columnCount];
/*  149 */     this.readOnly = new boolean[this.columnCount];
/*  150 */     this.nullable = new int[this.columnCount];
/*  151 */     this.signed = new boolean[this.columnCount];
/*  152 */     this.columnDisplaySize = new int[this.columnCount];
/*  153 */     this.columnType = new int[this.columnCount];
/*  154 */     this.columnLabel = new String[this.columnCount];
/*  155 */     this.columnName = new String[this.columnCount];
/*  156 */     this.schemaName = new String[this.columnCount];
/*  157 */     this.precision = new int[this.columnCount];
/*  158 */     this.scale = new int[this.columnCount];
/*  159 */     this.tableName = new String[this.columnCount];
/*  160 */     this.columnTypeName = new String[this.columnCount];
/*  161 */     this.writable = new boolean[this.columnCount];
/*  162 */     this.definatelyWritable = new boolean[this.columnCount];
/*  163 */     this.currency = new boolean[this.columnCount];
/*  164 */     this.autoIncrement = new boolean[this.columnCount];
/*  165 */     this.catalogName = new String[this.columnCount];
/*  166 */     this.columnClassName = new String[this.columnCount];
/*      */ 
/*  168 */     for (int i = 0; i < this.columnCount; i++)
/*      */     {
/*  170 */       this.searchable[i] = false;
/*  171 */       this.caseSensitive[i] = false;
/*  172 */       this.readOnly[i] = false;
/*  173 */       this.nullable[i] = 1;
/*  174 */       this.signed[i] = false;
/*  175 */       this.columnDisplaySize[i] = 0;
/*  176 */       this.columnType[i] = 0;
/*  177 */       this.columnLabel[i] = "";
/*  178 */       this.columnName[i] = "";
/*  179 */       this.schemaName[i] = "";
/*  180 */       this.precision[i] = 0;
/*  181 */       this.scale[i] = 0;
/*  182 */       this.tableName[i] = "";
/*  183 */       this.columnTypeName[i] = "";
/*  184 */       this.writable[i] = false;
/*  185 */       this.definatelyWritable[i] = false;
/*  186 */       this.currency[i] = false;
/*  187 */       this.autoIncrement[i] = true;
/*  188 */       this.catalogName[i] = "";
/*  189 */       this.columnClassName[i] = "";
/*      */     }
/*      */   }
/*      */ 
/*      */   OracleRowSetMetaData(ResultSetMetaData paramResultSetMetaData)
/*      */     throws SQLException
/*      */   {
/*  200 */     this.columnCount = paramResultSetMetaData.getColumnCount();
/*  201 */     this.searchable = new boolean[this.columnCount];
/*  202 */     this.caseSensitive = new boolean[this.columnCount];
/*  203 */     this.readOnly = new boolean[this.columnCount];
/*  204 */     this.nullable = new int[this.columnCount];
/*  205 */     this.signed = new boolean[this.columnCount];
/*  206 */     this.columnDisplaySize = new int[this.columnCount];
/*  207 */     this.columnType = new int[this.columnCount];
/*  208 */     this.columnLabel = new String[this.columnCount];
/*  209 */     this.columnName = new String[this.columnCount];
/*  210 */     this.schemaName = new String[this.columnCount];
/*  211 */     this.precision = new int[this.columnCount];
/*  212 */     this.scale = new int[this.columnCount];
/*  213 */     this.tableName = new String[this.columnCount];
/*  214 */     this.columnTypeName = new String[this.columnCount];
/*  215 */     this.writable = new boolean[this.columnCount];
/*  216 */     this.definatelyWritable = new boolean[this.columnCount];
/*  217 */     this.currency = new boolean[this.columnCount];
/*  218 */     this.autoIncrement = new boolean[this.columnCount];
/*  219 */     this.catalogName = new String[this.columnCount];
/*  220 */     this.columnClassName = new String[this.columnCount];
/*      */ 
/*  222 */     for (int i = 0; i < this.columnCount; i++)
/*      */     {
/*  224 */       this.searchable[i] = paramResultSetMetaData.isSearchable(i + 1);
/*  225 */       this.caseSensitive[i] = paramResultSetMetaData.isCaseSensitive(i + 1);
/*  226 */       this.readOnly[i] = paramResultSetMetaData.isReadOnly(i + 1);
/*  227 */       this.nullable[i] = paramResultSetMetaData.isNullable(i + 1);
/*  228 */       this.signed[i] = paramResultSetMetaData.isSigned(i + 1);
/*  229 */       this.columnDisplaySize[i] = paramResultSetMetaData.getColumnDisplaySize(i + 1);
/*  230 */       this.columnType[i] = paramResultSetMetaData.getColumnType(i + 1);
/*  231 */       this.columnLabel[i] = paramResultSetMetaData.getColumnLabel(i + 1);
/*  232 */       this.columnName[i] = paramResultSetMetaData.getColumnName(i + 1);
/*  233 */       this.schemaName[i] = paramResultSetMetaData.getSchemaName(i + 1);
/*      */ 
/*  235 */       if ((this.columnType[i] == 2) || (this.columnType[i] == 2) || (this.columnType[i] == -5) || (this.columnType[i] == 3) || (this.columnType[i] == 8) || (this.columnType[i] == 6) || (this.columnType[i] == 4))
/*      */       {
/*  243 */         this.precision[i] = paramResultSetMetaData.getPrecision(i + 1);
/*  244 */         this.scale[i] = paramResultSetMetaData.getScale(i + 1);
/*      */       }
/*      */       else
/*      */       {
/*  248 */         this.precision[i] = 0;
/*  249 */         this.scale[i] = 0;
/*      */       }
/*      */ 
/*  252 */       this.tableName[i] = paramResultSetMetaData.getTableName(i + 1);
/*  253 */       this.columnTypeName[i] = paramResultSetMetaData.getColumnTypeName(i + 1);
/*  254 */       this.writable[i] = paramResultSetMetaData.isWritable(i + 1);
/*  255 */       this.definatelyWritable[i] = paramResultSetMetaData.isDefinitelyWritable(i + 1);
/*  256 */       this.currency[i] = paramResultSetMetaData.isCurrency(i + 1);
/*  257 */       this.autoIncrement[i] = paramResultSetMetaData.isAutoIncrement(i + 1);
/*  258 */       this.catalogName[i] = paramResultSetMetaData.getCatalogName(i + 1);
/*  259 */       this.columnClassName[i] = paramResultSetMetaData.getColumnClassName(i + 1);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void validateColumnIndex(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  270 */     if ((paramInt < 1) || (paramInt > this.columnCount))
/*      */     {
/*  272 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3, "" + paramInt);
/*  273 */       localSQLException.fillInStackTrace();
/*  274 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public int getColumnCount()
/*      */     throws SQLException
/*      */   {
/*  295 */     return this.columnCount;
/*      */   }
/*      */ 
/*      */   public boolean isAutoIncrement(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  316 */     validateColumnIndex(paramInt);
/*  317 */     return this.autoIncrement[(paramInt - 1)];
/*      */   }
/*      */ 
/*      */   public boolean isCaseSensitive(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  338 */     validateColumnIndex(paramInt);
/*  339 */     return this.caseSensitive[(paramInt - 1)];
/*      */   }
/*      */ 
/*      */   public boolean isSearchable(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  360 */     validateColumnIndex(paramInt);
/*  361 */     return this.searchable[(paramInt - 1)];
/*      */   }
/*      */ 
/*      */   public boolean isCurrency(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  382 */     validateColumnIndex(paramInt);
/*  383 */     return this.currency[(paramInt - 1)];
/*      */   }
/*      */ 
/*      */   public int isNullable(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  405 */     validateColumnIndex(paramInt);
/*  406 */     return this.nullable[(paramInt - 1)];
/*      */   }
/*      */ 
/*      */   public boolean isSigned(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  426 */     validateColumnIndex(paramInt);
/*  427 */     return this.signed[(paramInt - 1)];
/*      */   }
/*      */ 
/*      */   public int getColumnDisplaySize(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  449 */     validateColumnIndex(paramInt);
/*  450 */     return this.columnDisplaySize[(paramInt - 1)];
/*      */   }
/*      */ 
/*      */   public String getColumnLabel(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  472 */     validateColumnIndex(paramInt);
/*  473 */     return this.columnLabel[(paramInt - 1)];
/*      */   }
/*      */ 
/*      */   public String getColumnName(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  494 */     validateColumnIndex(paramInt);
/*  495 */     return this.columnName[(paramInt - 1)];
/*      */   }
/*      */ 
/*      */   public String getSchemaName(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  516 */     validateColumnIndex(paramInt);
/*  517 */     return this.schemaName[(paramInt - 1)];
/*      */   }
/*      */ 
/*      */   public int getPrecision(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  538 */     validateColumnIndex(paramInt);
/*  539 */     return this.precision[(paramInt - 1)];
/*      */   }
/*      */ 
/*      */   public int getScale(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  560 */     validateColumnIndex(paramInt);
/*  561 */     return this.scale[(paramInt - 1)];
/*      */   }
/*      */ 
/*      */   public String getTableName(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  582 */     validateColumnIndex(paramInt);
/*  583 */     return this.tableName[(paramInt - 1)];
/*      */   }
/*      */ 
/*      */   public String getCatalogName(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  604 */     validateColumnIndex(paramInt);
/*  605 */     return this.catalogName[(paramInt - 1)];
/*      */   }
/*      */ 
/*      */   public int getColumnType(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  627 */     validateColumnIndex(paramInt);
/*  628 */     return this.columnType[(paramInt - 1)];
/*      */   }
/*      */ 
/*      */   public String getColumnTypeName(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  650 */     validateColumnIndex(paramInt);
/*  651 */     return this.columnTypeName[(paramInt - 1)];
/*      */   }
/*      */ 
/*      */   public boolean isReadOnly(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  672 */     validateColumnIndex(paramInt);
/*  673 */     return this.readOnly[(paramInt - 1)];
/*      */   }
/*      */ 
/*      */   public boolean isWritable(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  694 */     validateColumnIndex(paramInt);
/*  695 */     return this.writable[(paramInt - 1)];
/*      */   }
/*      */ 
/*      */   public boolean isDefinitelyWritable(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  716 */     validateColumnIndex(paramInt);
/*  717 */     return this.definatelyWritable[(paramInt - 1)];
/*      */   }
/*      */ 
/*      */   public String getColumnClassName(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  748 */     validateColumnIndex(paramInt);
/*  749 */     return this.columnClassName[(paramInt - 1)];
/*      */   }
/*      */ 
/*      */   public void setAutoIncrement(int paramInt, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  767 */     validateColumnIndex(paramInt);
/*  768 */     this.autoIncrement[(paramInt - 1)] = paramBoolean;
/*      */   }
/*      */ 
/*      */   public void setCaseSensitive(int paramInt, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  783 */     validateColumnIndex(paramInt);
/*  784 */     this.caseSensitive[(paramInt - 1)] = paramBoolean;
/*      */   }
/*      */ 
/*      */   public void setCatalogName(int paramInt, String paramString)
/*      */     throws SQLException
/*      */   {
/*  799 */     validateColumnIndex(paramInt);
/*  800 */     this.catalogName[(paramInt - 1)] = paramString;
/*      */   }
/*      */ 
/*      */   public void setColumnCount(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  815 */     this.columnCount = paramInt;
/*      */   }
/*      */ 
/*      */   public void setColumnDisplaySize(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*  830 */     validateColumnIndex(paramInt1);
/*  831 */     this.columnDisplaySize[(paramInt1 - 1)] = paramInt2;
/*      */   }
/*      */ 
/*      */   public void setColumnLabel(int paramInt, String paramString)
/*      */     throws SQLException
/*      */   {
/*  846 */     validateColumnIndex(paramInt);
/*  847 */     this.columnLabel[(paramInt - 1)] = paramString;
/*      */   }
/*      */ 
/*      */   public void setColumnName(int paramInt, String paramString)
/*      */     throws SQLException
/*      */   {
/*  862 */     validateColumnIndex(paramInt);
/*  863 */     this.columnName[(paramInt - 1)] = paramString;
/*      */   }
/*      */ 
/*      */   public void setColumnType(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*  878 */     validateColumnIndex(paramInt1);
/*  879 */     this.columnType[(paramInt1 - 1)] = paramInt2;
/*      */   }
/*      */ 
/*      */   public void setColumnTypeName(int paramInt, String paramString)
/*      */     throws SQLException
/*      */   {
/*  894 */     validateColumnIndex(paramInt);
/*  895 */     this.columnTypeName[(paramInt - 1)] = paramString;
/*      */   }
/*      */ 
/*      */   public void setCurrency(int paramInt, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  910 */     validateColumnIndex(paramInt);
/*  911 */     this.currency[(paramInt - 1)] = paramBoolean;
/*      */   }
/*      */ 
/*      */   public void setNullable(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*  926 */     validateColumnIndex(paramInt1);
/*  927 */     this.nullable[(paramInt1 - 1)] = paramInt2;
/*      */   }
/*      */ 
/*      */   public void setPrecision(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*  942 */     validateColumnIndex(paramInt1);
/*  943 */     this.precision[(paramInt1 - 1)] = paramInt2;
/*      */   }
/*      */ 
/*      */   public void setScale(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*  958 */     validateColumnIndex(paramInt1);
/*  959 */     this.scale[(paramInt1 - 1)] = paramInt2;
/*      */   }
/*      */ 
/*      */   public void setSchemaName(int paramInt, String paramString)
/*      */     throws SQLException
/*      */   {
/*  974 */     validateColumnIndex(paramInt);
/*  975 */     this.schemaName[(paramInt - 1)] = paramString;
/*      */   }
/*      */ 
/*      */   public void setSearchable(int paramInt, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  990 */     validateColumnIndex(paramInt);
/*  991 */     this.searchable[(paramInt - 1)] = paramBoolean;
/*      */   }
/*      */ 
/*      */   public void setSigned(int paramInt, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 1006 */     validateColumnIndex(paramInt);
/* 1007 */     this.signed[(paramInt - 1)] = paramBoolean;
/*      */   }
/*      */ 
/*      */   public void setTableName(int paramInt, String paramString)
/*      */     throws SQLException
/*      */   {
/* 1022 */     validateColumnIndex(paramInt);
/* 1023 */     this.tableName[(paramInt - 1)] = paramString;
/*      */   }
/*      */ 
/*      */   public boolean isWrapperFor(Class<?> paramClass)
/*      */     throws SQLException
/*      */   {
/* 1045 */     if (paramClass.isInterface()) return paramClass.isInstance(this);
/*      */ 
/* 1047 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 177);
/* 1048 */     localSQLException.fillInStackTrace();
/* 1049 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public <T> T unwrap(Class<T> paramClass)
/*      */     throws SQLException
/*      */   {
/* 1071 */     if ((paramClass.isInterface()) && (paramClass.isInstance(this))) return this;
/*      */ 
/* 1073 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 177);
/* 1074 */     localSQLException.fillInStackTrace();
/* 1075 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   protected OracleConnection getConnectionDuringExceptionHandling()
/*      */   {
/* 1091 */     return null;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.rowset.OracleRowSetMetaData
 * JD-Core Version:    0.6.2
 */