/*      */ package oracle.jdbc.rowset;
/*      */ 
/*      */ import java.io.Serializable;
/*      */ import java.sql.ResultSetMetaData;
/*      */ import java.sql.SQLException;
/*      */ import java.util.HashMap;
/*      */ import java.util.Map;
/*      */ import java.util.Vector;
/*      */ import javax.sql.RowSet;
/*      */ import javax.sql.RowSetEvent;
/*      */ import javax.sql.RowSetListener;
/*      */ import javax.sql.rowset.Joinable;
/*      */ import oracle.jdbc.driver.DatabaseError;
/*      */ import oracle.jdbc.internal.OracleConnection;
/*      */ 
/*      */ abstract class OracleRowSet
/*      */   implements Serializable, Cloneable, Joinable
/*      */ {
/*      */   protected String dataSource;
/*      */   protected String dataSourceName;
/*      */   protected String url;
/*      */   protected String username;
/*      */   protected String password;
/*      */   protected Map typeMap;
/*      */   protected int maxFieldSize;
/*      */   protected int maxRows;
/*      */   protected int queryTimeout;
/*      */   protected int fetchSize;
/*      */   protected int transactionIsolation;
/*      */   protected boolean escapeProcessing;
/*      */   protected String command;
/*      */   protected int concurrency;
/*      */   protected boolean readOnly;
/*      */   protected int fetchDirection;
/*      */   protected int rowsetType;
/*      */   protected boolean showDeleted;
/*      */   protected Vector listener;
/*      */   protected RowSetEvent rowsetEvent;
/*      */   protected Vector matchColumnIndexes;
/*      */   protected Vector matchColumnNames;
/*      */   protected boolean isClosed;
/* 1770 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   protected OracleRowSet()
/*      */     throws SQLException
/*      */   {
/*  258 */     initializeProperties();
/*      */ 
/*  263 */     this.matchColumnIndexes = new Vector(10);
/*  264 */     this.matchColumnNames = new Vector(10);
/*      */ 
/*  266 */     this.listener = new Vector();
/*  267 */     this.rowsetEvent = new RowSetEvent((RowSet)this);
/*      */ 
/*  269 */     this.isClosed = false;
/*      */   }
/*      */ 
/*      */   protected void initializeProperties()
/*      */   {
/*  282 */     this.command = null;
/*  283 */     this.concurrency = 1007;
/*  284 */     this.dataSource = null;
/*  285 */     this.dataSourceName = null;
/*      */ 
/*  287 */     this.escapeProcessing = true;
/*  288 */     this.fetchDirection = 1002;
/*  289 */     this.fetchSize = 0;
/*  290 */     this.maxFieldSize = 0;
/*  291 */     this.maxRows = 0;
/*  292 */     this.queryTimeout = 0;
/*  293 */     this.readOnly = false;
/*  294 */     this.showDeleted = false;
/*  295 */     this.transactionIsolation = 2;
/*  296 */     this.rowsetType = 1005;
/*  297 */     this.typeMap = new HashMap();
/*  298 */     this.username = null;
/*  299 */     this.password = null;
/*  300 */     this.url = null;
/*      */   }
/*      */ 
/*      */   public String getCommand()
/*      */   {
/*  321 */     return this.command;
/*      */   }
/*      */ 
/*      */   public int getConcurrency()
/*      */     throws SQLException
/*      */   {
/*  335 */     return this.concurrency;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public String getDataSource()
/*      */   {
/*  351 */     return this.dataSource;
/*      */   }
/*      */ 
/*      */   public String getDataSourceName()
/*      */   {
/*  364 */     return this.dataSourceName;
/*      */   }
/*      */ 
/*      */   public boolean getEscapeProcessing()
/*      */     throws SQLException
/*      */   {
/*  378 */     return this.escapeProcessing;
/*      */   }
/*      */ 
/*      */   public int getFetchDirection()
/*      */     throws SQLException
/*      */   {
/*  392 */     return this.fetchDirection;
/*      */   }
/*      */ 
/*      */   public int getFetchSize()
/*      */     throws SQLException
/*      */   {
/*  406 */     return this.fetchSize;
/*      */   }
/*      */ 
/*      */   public int getMaxFieldSize()
/*      */     throws SQLException
/*      */   {
/*  420 */     return this.maxFieldSize;
/*      */   }
/*      */ 
/*      */   public int getMaxRows()
/*      */     throws SQLException
/*      */   {
/*  434 */     return this.maxRows;
/*      */   }
/*      */ 
/*      */   public String getPassword()
/*      */   {
/*  447 */     return this.password;
/*      */   }
/*      */ 
/*      */   public int getQueryTimeout()
/*      */     throws SQLException
/*      */   {
/*  461 */     return this.queryTimeout;
/*      */   }
/*      */ 
/*      */   public boolean getReadOnly()
/*      */   {
/*  474 */     return isReadOnly();
/*      */   }
/*      */ 
/*      */   public boolean isReadOnly()
/*      */   {
/*  487 */     return this.readOnly;
/*      */   }
/*      */ 
/*      */   public boolean getShowDeleted()
/*      */   {
/*  500 */     return this.showDeleted;
/*      */   }
/*      */ 
/*      */   public int getTransactionIsolation()
/*      */   {
/*  513 */     return this.transactionIsolation;
/*      */   }
/*      */ 
/*      */   public int getType()
/*      */     throws SQLException
/*      */   {
/*  527 */     return this.rowsetType;
/*      */   }
/*      */ 
/*      */   public Map getTypeMap()
/*      */     throws SQLException
/*      */   {
/*  541 */     return this.typeMap;
/*      */   }
/*      */ 
/*      */   public String getUrl()
/*      */   {
/*  554 */     return this.url;
/*      */   }
/*      */ 
/*      */   public String getUsername()
/*      */   {
/*  567 */     return this.username;
/*      */   }
/*      */ 
/*      */   public void setCommand(String paramString)
/*      */     throws SQLException
/*      */   {
/*  582 */     this.command = paramString;
/*      */   }
/*      */ 
/*      */   public void setConcurrency(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  597 */     if ((paramInt == 1007) || (paramInt == 1008)) {
/*  598 */       this.concurrency = paramInt;
/*      */     }
/*      */     else {
/*  601 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  602 */       localSQLException.fillInStackTrace();
/*  603 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public void setDataSource(String paramString)
/*      */   {
/*  625 */     this.dataSource = paramString;
/*      */   }
/*      */ 
/*      */   public void setDataSourceName(String paramString)
/*      */     throws SQLException
/*      */   {
/*  640 */     this.dataSourceName = paramString;
/*      */   }
/*      */ 
/*      */   public void setEscapeProcessing(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  655 */     this.escapeProcessing = paramBoolean;
/*      */   }
/*      */ 
/*      */   public void setFetchDirection(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  676 */     this.fetchDirection = paramInt;
/*      */   }
/*      */ 
/*      */   public void setFetchSize(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  691 */     this.fetchSize = paramInt;
/*      */   }
/*      */ 
/*      */   public void setMaxFieldSize(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  707 */     this.maxFieldSize = paramInt;
/*      */   }
/*      */ 
/*      */   public void setMaxRows(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  722 */     this.maxRows = paramInt;
/*      */   }
/*      */ 
/*      */   public void setPassword(String paramString)
/*      */     throws SQLException
/*      */   {
/*  737 */     this.password = paramString;
/*      */   }
/*      */ 
/*      */   public void setQueryTimeout(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  752 */     this.queryTimeout = paramInt;
/*      */   }
/*      */ 
/*      */   public void setReadOnly(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  768 */     this.readOnly = paramBoolean;
/*      */   }
/*      */ 
/*      */   public void setShowDeleted(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  783 */     this.showDeleted = paramBoolean;
/*      */   }
/*      */ 
/*      */   public void setTransactionIsolation(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  798 */     this.transactionIsolation = paramInt;
/*      */   }
/*      */ 
/*      */   public void setType(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  813 */     if ((paramInt == 1003) || (paramInt == 1004) || (paramInt == 1005))
/*      */     {
/*  816 */       this.rowsetType = paramInt;
/*      */     }
/*      */     else {
/*  819 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  820 */       localSQLException.fillInStackTrace();
/*  821 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setTypeMap(Map paramMap)
/*      */     throws SQLException
/*      */   {
/*  837 */     this.typeMap = paramMap;
/*      */   }
/*      */ 
/*      */   public void setUrl(String paramString)
/*      */   {
/*  851 */     this.url = paramString;
/*      */   }
/*      */ 
/*      */   public void setUsername(String paramString)
/*      */     throws SQLException
/*      */   {
/*  866 */     this.username = paramString;
/*      */   }
/*      */ 
/*      */   public void addRowSetListener(RowSetListener paramRowSetListener)
/*      */   {
/*  891 */     for (int i = 0; i < this.listener.size(); i++)
/*  892 */       if (this.listener.elementAt(i).equals(paramRowSetListener))
/*  893 */         return;
/*  894 */     this.listener.add(paramRowSetListener);
/*      */   }
/*      */ 
/*      */   public void removeRowSetListener(RowSetListener paramRowSetListener)
/*      */   {
/*  908 */     for (int i = 0; i < this.listener.size(); i++)
/*  909 */       if (this.listener.elementAt(i).equals(paramRowSetListener))
/*  910 */         this.listener.remove(i);
/*      */   }
/*      */ 
/*      */   protected synchronized void notifyCursorMoved()
/*      */   {
/*  924 */     int i = this.listener.size();
/*  925 */     if (i > 0)
/*  926 */       for (int j = 0; j < i; j++)
/*  927 */         ((RowSetListener)this.listener.elementAt(j)).cursorMoved(this.rowsetEvent);
/*      */   }
/*      */ 
/*      */   protected void notifyRowChanged()
/*      */   {
/*  940 */     int i = this.listener.size();
/*  941 */     if (i > 0)
/*  942 */       for (int j = 0; j < i; j++)
/*      */       {
/*  944 */         ((RowSetListener)this.listener.elementAt(j)).rowChanged(this.rowsetEvent);
/*      */       }
/*      */   }
/*      */ 
/*      */   protected void notifyRowSetChanged()
/*      */   {
/*  958 */     int i = this.listener.size();
/*  959 */     if (i > 0)
/*  960 */       for (int j = 0; j < i; j++)
/*      */       {
/*  962 */         ((RowSetListener)this.listener.elementAt(j)).rowSetChanged(this.rowsetEvent);
/*      */       }
/*      */   }
/*      */ 
/*      */   public int[] getMatchColumnIndexes()
/*      */     throws SQLException
/*      */   {
/*  996 */     if ((this.matchColumnIndexes.size() == 0) && (this.matchColumnNames.size() == 0))
/*      */     {
/*  998 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 334);
/*  999 */       localSQLException1.fillInStackTrace();
/* 1000 */       throw localSQLException1;
/*      */     }
/*      */     int i;
/*      */     int[] arrayOfInt;
/*      */     int k;
/* 1006 */     if (this.matchColumnNames.size() > 0)
/*      */     {
/* 1008 */       String[] arrayOfString = getMatchColumnNames();
/* 1009 */       i = arrayOfString.length;
/* 1010 */       arrayOfInt = new int[i];
/*      */ 
/* 1012 */       for (k = 0; k < i; k++)
/*      */       {
/* 1014 */         arrayOfInt[k] = findColumn(arrayOfString[k]);
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/* 1019 */       i = this.matchColumnIndexes.size();
/* 1020 */       arrayOfInt = new int[i];
/* 1021 */       int j = -1;
/*      */ 
/* 1023 */       for (k = 0; k < i; k++)
/*      */       {
/*      */         try
/*      */         {
/* 1027 */           j = ((Integer)this.matchColumnIndexes.get(k)).intValue();
/*      */         }
/*      */         catch (Exception localException)
/*      */         {
/* 1033 */           SQLException localSQLException3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 336);
/* 1034 */           localSQLException3.fillInStackTrace();
/* 1035 */           throw localSQLException3;
/*      */         }
/*      */ 
/* 1041 */         if (j <= 0)
/*      */         {
/* 1044 */           SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 336);
/* 1045 */           localSQLException2.fillInStackTrace();
/* 1046 */           throw localSQLException2;
/*      */         }
/*      */ 
/* 1052 */         arrayOfInt[k] = j;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1057 */     return arrayOfInt;
/*      */   }
/*      */ 
/*      */   public String[] getMatchColumnNames()
/*      */     throws SQLException
/*      */   {
/* 1081 */     checkIfMatchColumnNamesSet();
/*      */ 
/* 1083 */     int i = this.matchColumnNames.size();
/* 1084 */     String[] arrayOfString = new String[i];
/* 1085 */     String str = null;
/*      */ 
/* 1087 */     for (int j = 0; j < i; j++)
/*      */     {
/*      */       try
/*      */       {
/* 1091 */         str = (String)this.matchColumnNames.get(j);
/*      */       }
/*      */       catch (Exception localException)
/*      */       {
/* 1097 */         SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 337);
/* 1098 */         localSQLException2.fillInStackTrace();
/* 1099 */         throw localSQLException2;
/*      */       }
/*      */ 
/* 1105 */       if ((str == null) || (str.equals("")))
/*      */       {
/* 1108 */         SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 337);
/* 1109 */         localSQLException1.fillInStackTrace();
/* 1110 */         throw localSQLException1;
/*      */       }
/*      */ 
/* 1116 */       arrayOfString[j] = str;
/*      */     }
/*      */ 
/* 1120 */     return arrayOfString;
/*      */   }
/*      */ 
/*      */   public void setMatchColumn(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1144 */     if (paramInt <= 0)
/*      */     {
/* 1147 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 336);
/* 1148 */       localSQLException1.fillInStackTrace();
/* 1149 */       throw localSQLException1;
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/* 1156 */       this.matchColumnIndexes.clear();
/* 1157 */       this.matchColumnNames.clear();
/*      */ 
/* 1159 */       this.matchColumnIndexes.add(0, Integer.valueOf(paramInt));
/*      */     }
/*      */     catch (Exception localException)
/*      */     {
/* 1165 */       SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 338);
/* 1166 */       localSQLException2.fillInStackTrace();
/* 1167 */       throw localSQLException2;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setMatchColumn(int[] paramArrayOfInt)
/*      */     throws SQLException
/*      */   {
/* 1195 */     this.matchColumnIndexes.clear();
/* 1196 */     this.matchColumnNames.clear();
/*      */ 
/* 1198 */     if (paramArrayOfInt == null)
/*      */     {
/* 1201 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 1202 */       localSQLException1.fillInStackTrace();
/* 1203 */       throw localSQLException1;
/*      */     }
/*      */ 
/* 1207 */     for (int i = 0; i < paramArrayOfInt.length; i++)
/*      */     {
/* 1209 */       if (paramArrayOfInt[i] <= 0)
/*      */       {
/* 1212 */         SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 336);
/* 1213 */         localSQLException2.fillInStackTrace();
/* 1214 */         throw localSQLException2;
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/* 1220 */         this.matchColumnIndexes.add(i, Integer.valueOf(paramArrayOfInt[i]));
/*      */       }
/*      */       catch (Exception localException)
/*      */       {
/* 1226 */         SQLException localSQLException3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 338);
/* 1227 */         localSQLException3.fillInStackTrace();
/* 1228 */         throw localSQLException3;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setMatchColumn(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1257 */     if ((paramString == null) || (paramString.equals("")))
/*      */     {
/* 1260 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 1261 */       localSQLException1.fillInStackTrace();
/* 1262 */       throw localSQLException1;
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/* 1269 */       this.matchColumnIndexes.clear();
/* 1270 */       this.matchColumnNames.clear();
/*      */ 
/* 1272 */       this.matchColumnNames.add(0, paramString.trim());
/*      */     }
/*      */     catch (Exception localException)
/*      */     {
/* 1278 */       SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 339);
/* 1279 */       localSQLException2.fillInStackTrace();
/* 1280 */       throw localSQLException2;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setMatchColumn(String[] paramArrayOfString)
/*      */     throws SQLException
/*      */   {
/* 1309 */     this.matchColumnIndexes.clear();
/* 1310 */     this.matchColumnNames.clear();
/*      */ 
/* 1312 */     for (int i = 0; i < paramArrayOfString.length; i++)
/*      */     {
/* 1314 */       if ((paramArrayOfString[i] == null) || (paramArrayOfString[i].equals("")))
/*      */       {
/* 1317 */         SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 1318 */         localSQLException1.fillInStackTrace();
/* 1319 */         throw localSQLException1;
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/* 1325 */         this.matchColumnNames.add(i, paramArrayOfString[i].trim());
/*      */       }
/*      */       catch (Exception localException)
/*      */       {
/* 1331 */         SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 339);
/* 1332 */         localSQLException2.fillInStackTrace();
/* 1333 */         throw localSQLException2;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void unsetMatchColumn(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1362 */     checkIfMatchColumnIndexesSet();
/*      */ 
/* 1364 */     if (paramInt <= 0)
/*      */     {
/* 1367 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 336);
/* 1368 */       localSQLException1.fillInStackTrace();
/* 1369 */       throw localSQLException1;
/*      */     }
/*      */ 
/* 1373 */     int i = -1;
/*      */     try
/*      */     {
/* 1377 */       i = ((Integer)this.matchColumnIndexes.get(0)).intValue();
/*      */     }
/*      */     catch (Exception localException)
/*      */     {
/* 1383 */       SQLException localSQLException3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 334);
/* 1384 */       localSQLException3.fillInStackTrace();
/* 1385 */       throw localSQLException3;
/*      */     }
/*      */ 
/* 1390 */     if (i != paramInt)
/*      */     {
/* 1393 */       SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 340);
/* 1394 */       localSQLException2.fillInStackTrace();
/* 1395 */       throw localSQLException2;
/*      */     }
/*      */ 
/* 1400 */     this.matchColumnIndexes.clear();
/* 1401 */     this.matchColumnNames.clear();
/*      */   }
/*      */ 
/*      */   public void unsetMatchColumn(int[] paramArrayOfInt)
/*      */     throws SQLException
/*      */   {
/* 1425 */     checkIfMatchColumnIndexesSet();
/*      */ 
/* 1427 */     if (paramArrayOfInt == null)
/*      */     {
/* 1430 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 1431 */       localSQLException1.fillInStackTrace();
/* 1432 */       throw localSQLException1;
/*      */     }
/*      */ 
/* 1436 */     int i = -1;
/*      */ 
/* 1438 */     for (int j = 0; j < paramArrayOfInt.length; j++)
/*      */     {
/* 1440 */       if (paramArrayOfInt[j] <= 0)
/*      */       {
/* 1443 */         SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 336);
/* 1444 */         localSQLException2.fillInStackTrace();
/* 1445 */         throw localSQLException2;
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/* 1451 */         i = ((Integer)this.matchColumnIndexes.get(j)).intValue();
/*      */       }
/*      */       catch (Exception localException)
/*      */       {
/* 1457 */         SQLException localSQLException4 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 334);
/* 1458 */         localSQLException4.fillInStackTrace();
/* 1459 */         throw localSQLException4;
/*      */       }
/*      */ 
/* 1464 */       if (i != paramArrayOfInt[j])
/*      */       {
/* 1467 */         SQLException localSQLException3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 340);
/* 1468 */         localSQLException3.fillInStackTrace();
/* 1469 */         throw localSQLException3;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1475 */     this.matchColumnIndexes.clear();
/* 1476 */     this.matchColumnNames.clear();
/*      */   }
/*      */ 
/*      */   public void unsetMatchColumn(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1501 */     checkIfMatchColumnNamesSet();
/*      */ 
/* 1503 */     if ((paramString == null) || (paramString.equals("")))
/*      */     {
/* 1506 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 1507 */       ((SQLException)localObject).fillInStackTrace();
/* 1508 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/* 1512 */     Object localObject = null;
/*      */     try
/*      */     {
/* 1516 */       localObject = (String)this.matchColumnNames.get(0);
/*      */     }
/*      */     catch (Exception localException)
/*      */     {
/* 1522 */       SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 335);
/* 1523 */       localSQLException2.fillInStackTrace();
/* 1524 */       throw localSQLException2;
/*      */     }
/*      */ 
/* 1530 */     if (!((String)localObject).equals(paramString.trim()))
/*      */     {
/* 1533 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 341);
/* 1534 */       localSQLException1.fillInStackTrace();
/* 1535 */       throw localSQLException1;
/*      */     }
/*      */ 
/* 1540 */     this.matchColumnIndexes.clear();
/* 1541 */     this.matchColumnNames.clear();
/*      */   }
/*      */ 
/*      */   public void unsetMatchColumn(String[] paramArrayOfString)
/*      */     throws SQLException
/*      */   {
/* 1565 */     checkIfMatchColumnNamesSet();
/*      */ 
/* 1567 */     if (paramArrayOfString == null)
/*      */     {
/* 1570 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 1571 */       ((SQLException)localObject).fillInStackTrace();
/* 1572 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/* 1576 */     Object localObject = null;
/*      */ 
/* 1578 */     for (int i = 0; i < paramArrayOfString.length; i++)
/*      */     {
/* 1580 */       if ((paramArrayOfString[i] == null) || (paramArrayOfString[i].equals("")))
/*      */       {
/* 1583 */         SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 1584 */         localSQLException1.fillInStackTrace();
/* 1585 */         throw localSQLException1;
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/* 1591 */         localObject = (String)this.matchColumnNames.get(i);
/*      */       }
/*      */       catch (Exception localException)
/*      */       {
/* 1597 */         SQLException localSQLException3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 335);
/* 1598 */         localSQLException3.fillInStackTrace();
/* 1599 */         throw localSQLException3;
/*      */       }
/*      */ 
/* 1605 */       if (!((String)localObject).equals(paramArrayOfString[i]))
/*      */       {
/* 1608 */         SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 341);
/* 1609 */         localSQLException2.fillInStackTrace();
/* 1610 */         throw localSQLException2;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1616 */     this.matchColumnIndexes.clear();
/* 1617 */     this.matchColumnNames.clear();
/*      */   }
/*      */ 
/*      */   protected void checkIfMatchColumnIndexesSet()
/*      */     throws SQLException
/*      */   {
/* 1632 */     if (this.matchColumnIndexes.size() == 0)
/*      */     {
/* 1634 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 334);
/* 1635 */       localSQLException.fillInStackTrace();
/* 1636 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void checkIfMatchColumnNamesSet()
/*      */     throws SQLException
/*      */   {
/* 1648 */     if (this.matchColumnNames.size() == 0)
/*      */     {
/* 1650 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 335);
/* 1651 */       localSQLException.fillInStackTrace();
/* 1652 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public abstract int findColumn(String paramString)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract ResultSetMetaData getMetaData()
/*      */     throws SQLException;
/*      */ 
/*      */   abstract String getTableName()
/*      */     throws SQLException;
/*      */ 
/*      */   public boolean isClosed()
/*      */     throws SQLException
/*      */   {
/* 1678 */     return this.isClosed;
/*      */   }
/*      */ 
/*      */   public int getHoldability()
/*      */     throws SQLException
/*      */   {
/* 1691 */     return 1;
/*      */   }
/*      */ 
/*      */   public boolean isWrapperFor(Class<?> paramClass)
/*      */     throws SQLException
/*      */   {
/* 1712 */     if (paramClass.isInterface()) return paramClass.isInstance(this);
/*      */ 
/* 1714 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 177);
/* 1715 */     localSQLException.fillInStackTrace();
/* 1716 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public <T> T unwrap(Class<T> paramClass)
/*      */     throws SQLException
/*      */   {
/* 1739 */     if ((paramClass.isInterface()) && (paramClass.isInstance(this))) return this;
/*      */ 
/* 1741 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 177);
/* 1742 */     localSQLException.fillInStackTrace();
/* 1743 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   protected OracleConnection getConnectionDuringExceptionHandling()
/*      */   {
/* 1765 */     return null;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.rowset.OracleRowSet
 * JD-Core Version:    0.6.2
 */