/*     */ package oracle.jdbc.rowset;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.math.BigDecimal;
/*     */ import java.sql.Date;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Timestamp;
/*     */ import java.util.Collection;
/*     */ import java.util.Vector;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ 
/*     */ public class OracleRow
/*     */   implements Serializable, Cloneable
/*     */ {
/*     */   private Object[] column;
/*     */   private Object[] changedColumn;
/*     */   private boolean[] isOriginalNull;
/*     */   private byte[] columnChangeFlag;
/*  71 */   private int noColumn = 0;
/*     */   private int noColumnsInserted;
/*  82 */   private boolean rowDeleted = false;
/*     */ 
/*  87 */   private boolean rowInserted = false;
/*     */   private static final byte COLUMN_CHANGED = 17;
/*  97 */   private boolean rowUpdated = false;
/*     */   long[][] columnTypeInfo;
/* 695 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public OracleRow(int paramInt)
/*     */   {
/* 118 */     this.noColumn = paramInt;
/* 119 */     this.column = new Object[paramInt];
/* 120 */     this.changedColumn = new Object[paramInt];
/* 121 */     this.columnChangeFlag = new byte[paramInt];
/* 122 */     this.isOriginalNull = new boolean[paramInt];
/* 123 */     this.columnTypeInfo = new long[paramInt][];
/* 124 */     for (int i = 0; i < paramInt; i++)
/* 125 */       this.columnChangeFlag[i] = 0;
/*     */   }
/*     */ 
/*     */   public OracleRow(int paramInt, boolean paramBoolean)
/*     */   {
/* 139 */     this(paramInt);
/*     */ 
/* 148 */     this.rowInserted = paramBoolean;
/* 149 */     this.noColumnsInserted = 0;
/*     */   }
/*     */ 
/*     */   public OracleRow(int paramInt, Object[] paramArrayOfObject)
/*     */   {
/* 163 */     this(paramInt);
/*     */ 
/* 172 */     System.arraycopy(paramArrayOfObject, 0, this.column, 0, paramInt);
/*     */   }
/*     */ 
/*     */   public void setColumnValue(int paramInt, Object paramObject)
/*     */   {
/* 193 */     if (this.rowInserted)
/* 194 */       this.noColumnsInserted += 1;
/* 195 */     this.column[(paramInt - 1)] = paramObject;
/*     */   }
/*     */ 
/*     */   void markOriginalNull(int paramInt, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/* 205 */     this.isOriginalNull[(paramInt - 1)] = paramBoolean;
/*     */   }
/*     */ 
/*     */   boolean isOriginalNull(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 215 */     return this.isOriginalNull[(paramInt - 1)];
/*     */   }
/*     */ 
/*     */   public void updateObject(int paramInt, Object paramObject)
/*     */   {
/* 235 */     updateObject(paramInt, paramObject, (long[])null);
/*     */   }
/*     */ 
/*     */   void updateObject(int paramInt, Object paramObject, long[] paramArrayOfLong)
/*     */   {
/* 244 */     if (this.rowInserted)
/* 245 */       this.noColumnsInserted += 1;
/* 246 */     this.columnChangeFlag[(paramInt - 1)] = 17;
/* 247 */     this.changedColumn[(paramInt - 1)] = paramObject;
/* 248 */     this.columnTypeInfo[(paramInt - 1)] = paramArrayOfLong;
/*     */   }
/*     */ 
/*     */   public void cancelRowUpdates()
/*     */   {
/* 265 */     this.noColumnsInserted = 0;
/* 266 */     for (int i = 0; i < this.noColumn; i++)
/* 267 */       this.columnChangeFlag[i] = 0;
/* 268 */     this.changedColumn = null;
/* 269 */     this.changedColumn = new Object[this.noColumn];
/*     */   }
/*     */ 
/*     */   public Object getColumn(int paramInt)
/*     */   {
/* 289 */     return this.column[(paramInt - 1)];
/*     */   }
/*     */ 
/*     */   public Object getModifiedColumn(int paramInt)
/*     */   {
/* 309 */     return this.changedColumn[(paramInt - 1)];
/*     */   }
/*     */ 
/*     */   public boolean isColumnChanged(int paramInt)
/*     */   {
/* 331 */     return this.columnChangeFlag[(paramInt - 1)] == 17;
/*     */   }
/*     */ 
/*     */   public boolean isRowUpdated()
/*     */   {
/* 352 */     if ((this.rowInserted) || (this.rowDeleted)) {
/* 353 */       return false;
/*     */     }
/* 355 */     for (int i = 0; i < this.noColumn; i++) {
/* 356 */       if (this.columnChangeFlag[i] == 17)
/* 357 */         return true;
/*     */     }
/* 359 */     return false;
/*     */   }
/*     */ 
/*     */   public void setRowUpdated(boolean paramBoolean)
/*     */   {
/* 376 */     this.rowUpdated = paramBoolean;
/* 377 */     if (!paramBoolean)
/* 378 */       cancelRowUpdates();
/*     */   }
/*     */ 
/*     */   public boolean isRowInserted()
/*     */   {
/* 398 */     return this.rowInserted;
/*     */   }
/*     */ 
/*     */   public void cancelRowDeletion()
/*     */   {
/* 414 */     this.rowDeleted = false;
/*     */   }
/*     */ 
/*     */   public void setRowDeleted(boolean paramBoolean)
/*     */   {
/* 432 */     this.rowDeleted = paramBoolean;
/*     */   }
/*     */ 
/*     */   public boolean isRowDeleted()
/*     */   {
/* 449 */     return this.rowDeleted;
/*     */   }
/*     */ 
/*     */   public Object[] getOriginalRow()
/*     */   {
/* 465 */     return this.column;
/*     */   }
/*     */ 
/*     */   public boolean isRowFullyPopulated()
/*     */   {
/* 482 */     if (!this.rowInserted) {
/* 483 */       return false;
/*     */     }
/* 485 */     return this.noColumnsInserted == this.noColumn;
/*     */   }
/*     */ 
/*     */   public void setInsertedFlag(boolean paramBoolean)
/*     */   {
/* 503 */     this.rowInserted = paramBoolean;
/*     */   }
/*     */ 
/*     */   void makeUpdatesOriginal()
/*     */   {
/* 517 */     for (int i = 0; i < this.noColumn; i++)
/*     */     {
/* 519 */       if (this.columnChangeFlag[i] == 17)
/*     */       {
/* 522 */         this.column[i] = this.changedColumn[i];
/* 523 */         this.changedColumn[i] = null;
/* 524 */         this.columnChangeFlag[i] = 0;
/*     */       }
/*     */     }
/*     */ 
/* 528 */     this.rowUpdated = false;
/*     */   }
/*     */ 
/*     */   public void insertRow()
/*     */   {
/* 547 */     this.columnChangeFlag = null;
/* 548 */     this.columnChangeFlag = new byte[this.noColumn];
/* 549 */     System.arraycopy(this.changedColumn, 0, this.column, 0, this.noColumn);
/* 550 */     this.changedColumn = null;
/* 551 */     this.changedColumn = new Object[this.noColumn];
/*     */   }
/*     */ 
/*     */   public Collection toCollection()
/*     */   {
/* 568 */     Vector localVector = new Vector(this.noColumn);
/* 569 */     for (int i = 1; i <= this.noColumn; i++) {
/* 570 */       localVector.add(isColumnChanged(i) ? getModifiedColumn(i) : getColumn(i));
/*     */     }
/*     */ 
/* 573 */     return localVector;
/*     */   }
/*     */ 
/*     */   public OracleRow createCopy()
/*     */     throws SQLException
/*     */   {
/* 587 */     OracleRow localOracleRow = new OracleRow(this.noColumn);
/* 588 */     for (int i = 0; i < this.noColumn; i++)
/*     */     {
/* 590 */       localOracleRow.column[i] = getCopy(this.column[i]);
/* 591 */       localOracleRow.changedColumn[i] = getCopy(this.changedColumn[i]);
/*     */     }
/*     */ 
/* 594 */     System.arraycopy(this.columnChangeFlag, 0, localOracleRow.columnChangeFlag, 0, this.noColumn);
/* 595 */     localOracleRow.noColumnsInserted = this.noColumnsInserted;
/* 596 */     localOracleRow.rowDeleted = this.rowDeleted;
/* 597 */     localOracleRow.rowInserted = this.rowInserted;
/* 598 */     localOracleRow.rowUpdated = this.rowUpdated;
/*     */ 
/* 600 */     return localOracleRow;
/*     */   }
/*     */ 
/*     */   public Object getCopy(Object paramObject)
/*     */     throws SQLException
/*     */   {
/* 614 */     Object localObject = null;
/*     */     try
/*     */     {
/* 617 */       if (paramObject == null) {
/* 618 */         return null;
/*     */       }
/* 620 */       if ((paramObject instanceof String)) {
/* 621 */         localObject = (String)paramObject;
/*     */       }
/* 623 */       else if ((paramObject instanceof Number)) {
/* 624 */         localObject = new BigDecimal(((Number)paramObject).toString());
/*     */       }
/* 626 */       else if ((paramObject instanceof Date)) {
/* 627 */         localObject = new Date(((Date)paramObject).getTime());
/*     */       }
/* 629 */       else if ((paramObject instanceof Timestamp)) {
/* 630 */         localObject = new Timestamp(((Timestamp)paramObject).getTime());
/*     */       }
/* 633 */       else if ((paramObject instanceof InputStream)) {
/* 634 */         localObject = new DataInputStream((InputStream)paramObject);
/*     */       }
/* 636 */       else if ((paramObject instanceof OutputStream)) {
/* 637 */         localObject = new DataOutputStream((OutputStream)paramObject);
/*     */       }
/*     */       else
/*     */       {
/* 641 */         SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 348, paramObject.getClass().getName());
/* 642 */         localSQLException1.fillInStackTrace();
/* 643 */         throw localSQLException1;
/*     */       }
/*     */     }
/*     */     catch (Exception localException)
/*     */     {
/* 648 */       SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 349, paramObject.getClass().getName() + localException.getMessage());
/* 649 */       localSQLException2.fillInStackTrace();
/* 650 */       throw localSQLException2;
/*     */     }
/*     */ 
/* 654 */     return localObject;
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */     throws CloneNotSupportedException
/*     */   {
/*     */     try
/*     */     {
/* 670 */       return createCopy();
/*     */     }
/*     */     catch (SQLException localSQLException) {
/* 673 */       throw new CloneNotSupportedException("Error while cloning\n" + localSQLException.getMessage());
/*     */     }
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 690 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.rowset.OracleRow
 * JD-Core Version:    0.6.2
 */