/*     */ package oracle.jdbc.rowset;
/*     */ 
/*     */ import java.sql.ResultSetMetaData;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Collection;
/*     */ import java.util.Vector;
/*     */ import javax.sql.RowSet;
/*     */ import javax.sql.RowSetMetaData;
/*     */ import javax.sql.rowset.CachedRowSet;
/*     */ import javax.sql.rowset.JoinRowSet;
/*     */ import javax.sql.rowset.Joinable;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ 
/*     */ public class OracleJoinRowSet extends OracleWebRowSet
/*     */   implements JoinRowSet
/*     */ {
/*     */   private static final String MATCH_COLUMN_SUFFIX = "#MATCH_COLUMN";
/*  39 */   private static boolean[] supportedJoins = { false, true, false, false, false };
/*     */   private int joinType;
/*     */   private Vector addedRowSets;
/*     */   private Vector addedRowSetNames;
/*     */   private Object lockForJoinActions;
/* 917 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public OracleJoinRowSet()
/*     */     throws SQLException
/*     */   {
/*  63 */     this.joinType = 1;
/*  64 */     this.addedRowSets = new Vector();
/*  65 */     this.addedRowSetNames = new Vector();
/*     */   }
/*     */ 
/*     */   public synchronized void addRowSet(Joinable paramJoinable)
/*     */     throws SQLException
/*     */   {
/* 106 */     if (paramJoinable == null)
/*     */     {
/* 108 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 350);
/* 109 */       ((SQLException)localObject).fillInStackTrace();
/* 110 */       throw ((Throwable)localObject);
/*     */     }
/*     */ 
/* 113 */     if (!(paramJoinable instanceof RowSet))
/*     */     {
/* 115 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 351);
/* 116 */       ((SQLException)localObject).fillInStackTrace();
/* 117 */       throw ((Throwable)localObject);
/*     */     }
/*     */ 
/* 120 */     Object localObject = checkAndWrapRowSet((RowSet)paramJoinable);
/* 121 */     String str = getMatchColumnTableName((RowSet)paramJoinable);
/*     */ 
/* 123 */     switch (this.joinType)
/*     */     {
/*     */     case 1:
/* 126 */       doInnerJoin((OracleCachedRowSet)localObject);
/*     */ 
/* 128 */       this.addedRowSets.add(paramJoinable);
/* 129 */       this.addedRowSetNames.add(str);
/* 130 */       break;
/*     */     case 0:
/*     */     case 2:
/*     */     case 3:
/*     */     case 4:
/*     */     default:
/* 138 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 352);
/* 139 */       localSQLException.fillInStackTrace();
/* 140 */       throw localSQLException;
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void addRowSet(RowSet paramRowSet, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 173 */     ((OracleRowSet)paramRowSet).setMatchColumn(paramInt);
/* 174 */     addRowSet((Joinable)paramRowSet);
/*     */   }
/*     */ 
/*     */   public synchronized void addRowSet(RowSet paramRowSet, String paramString)
/*     */     throws SQLException
/*     */   {
/* 205 */     ((OracleRowSet)paramRowSet).setMatchColumn(paramString);
/* 206 */     addRowSet((Joinable)paramRowSet);
/*     */   }
/*     */ 
/*     */   public synchronized void addRowSet(RowSet[] paramArrayOfRowSet, int[] paramArrayOfInt)
/*     */     throws SQLException
/*     */   {
/* 246 */     if (paramArrayOfRowSet.length != paramArrayOfInt.length)
/*     */     {
/* 248 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 353);
/* 249 */       localSQLException.fillInStackTrace();
/* 250 */       throw localSQLException;
/*     */     }
/*     */ 
/* 253 */     for (int i = 0; i < paramArrayOfRowSet.length; i++)
/*     */     {
/* 255 */       ((OracleRowSet)paramArrayOfRowSet[i]).setMatchColumn(paramArrayOfInt[i]);
/* 256 */       addRowSet((Joinable)paramArrayOfRowSet[i]);
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void addRowSet(RowSet[] paramArrayOfRowSet, String[] paramArrayOfString)
/*     */     throws SQLException
/*     */   {
/* 298 */     if (paramArrayOfRowSet.length != paramArrayOfString.length)
/*     */     {
/* 300 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 353);
/* 301 */       localSQLException.fillInStackTrace();
/* 302 */       throw localSQLException;
/*     */     }
/*     */ 
/* 305 */     for (int i = 0; i < paramArrayOfRowSet.length; i++)
/*     */     {
/* 307 */       ((OracleRowSet)paramArrayOfRowSet[i]).setMatchColumn(paramArrayOfString[i]);
/* 308 */       addRowSet((Joinable)paramArrayOfRowSet[i]);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Collection getRowSets()
/*     */     throws SQLException
/*     */   {
/* 335 */     return this.addedRowSets;
/*     */   }
/*     */ 
/*     */   public String[] getRowSetNames()
/*     */     throws SQLException
/*     */   {
/* 358 */     Object[] arrayOfObject = this.addedRowSetNames.toArray();
/* 359 */     String[] arrayOfString = new String[arrayOfObject.length];
/* 360 */     for (int i = 0; i < arrayOfObject.length; i++)
/*     */     {
/* 362 */       arrayOfString[i] = ((String)arrayOfObject[i]);
/*     */     }
/* 364 */     return arrayOfString;
/*     */   }
/*     */ 
/*     */   public CachedRowSet toCachedRowSet()
/*     */     throws SQLException
/*     */   {
/* 399 */     OracleCachedRowSet localOracleCachedRowSet = (OracleCachedRowSet)createCopy();
/*     */ 
/* 402 */     localOracleCachedRowSet.setCommand("");
/*     */ 
/* 404 */     return localOracleCachedRowSet;
/*     */   }
/*     */ 
/*     */   public int getJoinType()
/*     */   {
/* 427 */     return this.joinType;
/*     */   }
/*     */ 
/*     */   public boolean supportsCrossJoin()
/*     */   {
/* 445 */     return supportedJoins[0];
/*     */   }
/*     */ 
/*     */   public boolean supportsInnerJoin()
/*     */   {
/* 463 */     return supportedJoins[1];
/*     */   }
/*     */ 
/*     */   public boolean supportsLeftOuterJoin()
/*     */   {
/* 481 */     return supportedJoins[2];
/*     */   }
/*     */ 
/*     */   public boolean supportsRightOuterJoin()
/*     */   {
/* 499 */     return supportedJoins[3];
/*     */   }
/*     */ 
/*     */   public boolean supportsFullJoin()
/*     */   {
/* 517 */     return supportedJoins[4];
/*     */   }
/*     */ 
/*     */   public void setJoinType(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 540 */     if (paramInt != 1)
/*     */     {
/* 542 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 352);
/* 543 */       localSQLException.fillInStackTrace();
/* 544 */       throw localSQLException;
/*     */     }
/*     */ 
/* 547 */     this.joinType = paramInt;
/*     */   }
/*     */ 
/*     */   public synchronized String getWhereClause()
/*     */     throws SQLException
/*     */   {
/* 571 */     if (this.addedRowSets.size() < 2) {
/* 572 */       return "WHERE";
/*     */     }
/* 574 */     StringBuffer localStringBuffer = new StringBuffer();
/* 575 */     localStringBuffer.append("WHERE\n");
/*     */ 
/* 577 */     Object localObject1 = (OracleRowSet)this.addedRowSets.get(0);
/* 578 */     Object localObject2 = ((OracleRowSet)localObject1).getMatchColumnIndexes();
/* 579 */     Object localObject3 = ((OracleRowSet)localObject1).getMetaData();
/* 580 */     Object localObject4 = ((OracleRowSet)localObject1).getTableName();
/*     */ 
/* 587 */     for (int i = 1; i < this.addedRowSets.size(); i++)
/*     */     {
/* 589 */       if (i > 1)
/*     */       {
/* 591 */         localStringBuffer.append("\nAND\n");
/*     */       }
/*     */ 
/* 594 */       OracleRowSet localOracleRowSet = (OracleRowSet)this.addedRowSets.get(i);
/* 595 */       int[] arrayOfInt = localOracleRowSet.getMatchColumnIndexes();
/* 596 */       ResultSetMetaData localResultSetMetaData = localOracleRowSet.getMetaData();
/* 597 */       String str = localOracleRowSet.getTableName();
/*     */ 
/* 599 */       for (int j = 0; j < localObject2.length; j++)
/*     */       {
/* 601 */         if (j > 0)
/*     */         {
/* 603 */           localStringBuffer.append("\nAND\n");
/*     */         }
/*     */ 
/* 606 */         localStringBuffer.append("(" + (String)localObject4 + "." + ((ResultSetMetaData)localObject3).getColumnName(localObject2[j]) + " = " + str + "." + localResultSetMetaData.getColumnName(arrayOfInt[j]) + ")");
/*     */       }
/*     */ 
/* 613 */       localObject1 = localOracleRowSet;
/* 614 */       localObject2 = arrayOfInt;
/* 615 */       localObject3 = localResultSetMetaData;
/* 616 */       localObject4 = str;
/*     */     }
/*     */ 
/* 619 */     localStringBuffer.append(";");
/*     */ 
/* 621 */     return localStringBuffer.toString();
/*     */   }
/*     */ 
/*     */   private void doInnerJoin(OracleCachedRowSet paramOracleCachedRowSet)
/*     */     throws SQLException
/*     */   {
/* 647 */     if (this.addedRowSets.isEmpty())
/*     */     {
/* 650 */       setMetaData((RowSetMetaData)paramOracleCachedRowSet.getMetaData());
/* 651 */       populate(paramOracleCachedRowSet);
/*     */ 
/* 653 */       setMatchColumn(paramOracleCachedRowSet.getMatchColumnIndexes());
/*     */     }
/*     */     else
/*     */     {
/* 657 */       Vector localVector = new Vector(100);
/* 658 */       OracleRowSetMetaData localOracleRowSetMetaData = new OracleRowSetMetaData(10);
/*     */ 
/* 660 */       int[] arrayOfInt1 = getMatchColumnIndexes();
/* 661 */       int[] arrayOfInt2 = paramOracleCachedRowSet.getMatchColumnIndexes();
/*     */ 
/* 664 */       int i = getMetaData().getColumnCount() + paramOracleCachedRowSet.getMetaData().getColumnCount() - arrayOfInt2.length;
/*     */ 
/* 667 */       localOracleRowSetMetaData.setColumnCount(i);
/*     */ 
/* 670 */       String str = getTableName() + "#" + paramOracleCachedRowSet.getTableName();
/*     */       boolean bool;
/* 673 */       for (int j = 1; j <= this.colCount; j++)
/*     */       {
/* 675 */         bool = false;
/* 676 */         for (k = 0; k < arrayOfInt1.length; k++)
/*     */         {
/* 678 */           if (j == arrayOfInt1[k])
/*     */           {
/* 680 */             bool = true;
/* 681 */             break;
/*     */           }
/*     */         }
/*     */ 
/* 685 */         setNewColumnMetaData(j, localOracleRowSetMetaData, j, (RowSetMetaData)this.rowsetMetaData, bool, str);
/*     */       }
/*     */ 
/* 690 */       RowSetMetaData localRowSetMetaData = (RowSetMetaData)paramOracleCachedRowSet.getMetaData();
/*     */ 
/* 692 */       int k = localRowSetMetaData.getColumnCount();
/*     */ 
/* 695 */       int m = this.colCount + 1;
/* 696 */       int[] arrayOfInt3 = new int[k];
/*     */ 
/* 698 */       for (int n = 1; n <= k; n++)
/*     */       {
/* 700 */         bool = false;
/* 701 */         for (i1 = 0; i1 < arrayOfInt2.length; i1++)
/*     */         {
/* 703 */           if (n == arrayOfInt1[i1])
/*     */           {
/* 705 */             bool = true;
/* 706 */             break;
/*     */           }
/*     */         }
/*     */ 
/* 710 */         if (!bool)
/*     */         {
/* 712 */           setNewColumnMetaData(m, localOracleRowSetMetaData, n, localRowSetMetaData, bool, str);
/*     */ 
/* 716 */           arrayOfInt3[(n - 1)] = m;
/* 717 */           m++;
/*     */         }
/*     */         else
/*     */         {
/* 722 */           arrayOfInt3[(n - 1)] = -1;
/*     */         }
/*     */       }
/*     */ 
/* 726 */       beforeFirst();
/*     */ 
/* 729 */       n = paramOracleCachedRowSet.size();
/* 730 */       int i1 = 0;
/*     */ 
/* 732 */       for (int i2 = 1; i2 <= this.rowCount; i2++)
/*     */       {
/* 734 */         next();
/* 735 */         paramOracleCachedRowSet.beforeFirst();
/*     */ 
/* 737 */         for (int i3 = 1; i3 <= n; i3++)
/*     */         {
/* 739 */           paramOracleCachedRowSet.next();
/*     */ 
/* 741 */           i1 = 1;
/* 742 */           for (int i4 = 0; i4 < arrayOfInt1.length; i4++)
/*     */           {
/* 744 */             Object localObject1 = getObject(arrayOfInt1[i4]);
/* 745 */             Object localObject2 = paramOracleCachedRowSet.getObject(arrayOfInt2[i4]);
/* 746 */             if (!localObject1.equals(localObject2))
/*     */             {
/* 748 */               i1 = 0;
/* 749 */               break;
/*     */             }
/*     */           }
/*     */ 
/* 753 */           if (i1 != 0)
/*     */           {
/* 755 */             OracleRow localOracleRow = new OracleRow(i, true);
/*     */ 
/* 758 */             for (int i5 = 1; i5 <= this.colCount; i5++)
/*     */             {
/* 760 */               localOracleRow.updateObject(i5, getObject(i5));
/*     */             }
/*     */ 
/* 763 */             for (i5 = 1; i5 <= k; i5++)
/*     */             {
/* 765 */               if (arrayOfInt3[(i5 - 1)] != -1)
/*     */               {
/* 767 */                 localOracleRow.updateObject(arrayOfInt3[(i5 - 1)], paramOracleCachedRowSet.getObject(i5));
/*     */               }
/*     */ 
/*     */             }
/*     */ 
/* 772 */             localVector.add(localOracleRow);
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/* 777 */       this.rows = localVector;
/* 778 */       this.presentRow = 0;
/* 779 */       this.rowCount = this.rows.size();
/* 780 */       setMetaData(localOracleRowSetMetaData);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void setNewColumnMetaData(int paramInt1, RowSetMetaData paramRowSetMetaData1, int paramInt2, RowSetMetaData paramRowSetMetaData2, boolean paramBoolean, String paramString)
/*     */     throws SQLException
/*     */   {
/* 816 */     paramRowSetMetaData1.setAutoIncrement(paramInt1, paramRowSetMetaData2.isAutoIncrement(paramInt2));
/* 817 */     paramRowSetMetaData1.setCaseSensitive(paramInt1, paramRowSetMetaData2.isCaseSensitive(paramInt2));
/* 818 */     paramRowSetMetaData1.setCatalogName(paramInt1, paramRowSetMetaData2.getCatalogName(paramInt2));
/* 819 */     paramRowSetMetaData1.setColumnDisplaySize(paramInt1, paramRowSetMetaData2.getColumnDisplaySize(paramInt2));
/*     */ 
/* 822 */     if (paramBoolean)
/*     */     {
/* 824 */       paramRowSetMetaData1.setColumnName(paramInt1, paramRowSetMetaData2.getColumnName(paramInt1) + "#MATCH_COLUMN");
/*     */     }
/*     */     else
/*     */     {
/* 829 */       paramRowSetMetaData1.setColumnName(paramInt1, paramRowSetMetaData2.getColumnName(paramInt2));
/*     */     }
/*     */ 
/* 832 */     paramRowSetMetaData1.setColumnLabel(paramInt1, paramRowSetMetaData1.getColumnName(paramInt2));
/*     */ 
/* 834 */     paramRowSetMetaData1.setColumnType(paramInt1, paramRowSetMetaData2.getColumnType(paramInt2));
/* 835 */     paramRowSetMetaData1.setColumnTypeName(paramInt1, paramRowSetMetaData2.getColumnTypeName(paramInt2));
/* 836 */     paramRowSetMetaData1.setCurrency(paramInt1, paramRowSetMetaData2.isCurrency(paramInt2));
/* 837 */     paramRowSetMetaData1.setNullable(paramInt1, paramRowSetMetaData2.isNullable(paramInt2));
/* 838 */     paramRowSetMetaData1.setPrecision(paramInt1, paramRowSetMetaData2.getPrecision(paramInt2));
/* 839 */     paramRowSetMetaData1.setScale(paramInt1, paramRowSetMetaData2.getScale(paramInt2));
/* 840 */     paramRowSetMetaData1.setSchemaName(paramInt1, paramRowSetMetaData2.getSchemaName(paramInt2));
/* 841 */     paramRowSetMetaData1.setSearchable(paramInt1, paramRowSetMetaData2.isSearchable(paramInt2));
/* 842 */     paramRowSetMetaData1.setSigned(paramInt1, paramRowSetMetaData2.isSigned(paramInt2));
/*     */ 
/* 844 */     if (paramBoolean)
/*     */     {
/* 846 */       paramRowSetMetaData1.setTableName(paramInt1, paramString);
/*     */     }
/*     */     else
/*     */     {
/* 850 */       paramRowSetMetaData1.setTableName(paramInt1, paramRowSetMetaData2.getTableName(paramInt2));
/*     */     }
/*     */   }
/*     */ 
/*     */   private OracleCachedRowSet checkAndWrapRowSet(RowSet paramRowSet)
/*     */     throws SQLException
/*     */   {
/* 873 */     OracleCachedRowSet localOracleCachedRowSet = null;
/*     */ 
/* 877 */     if ((paramRowSet instanceof OracleCachedRowSet))
/*     */     {
/* 879 */       localOracleCachedRowSet = (OracleCachedRowSet)paramRowSet;
/*     */     }
/*     */     else
/*     */     {
/*     */       Object localObject;
/* 881 */       if ((paramRowSet instanceof OracleJDBCRowSet))
/*     */       {
/* 883 */         localOracleCachedRowSet = new OracleCachedRowSet();
/* 884 */         localOracleCachedRowSet.populate(paramRowSet);
/*     */ 
/* 886 */         localObject = ((OracleJDBCRowSet)paramRowSet).getMatchColumnIndexes();
/* 887 */         localOracleCachedRowSet.setMatchColumn((int[])localObject);
/*     */       }
/*     */       else
/*     */       {
/* 891 */         localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 354);
/* 892 */         ((SQLException)localObject).fillInStackTrace();
/* 893 */         throw ((Throwable)localObject);
/*     */       }
/*     */     }
/* 896 */     return localOracleCachedRowSet;
/*     */   }
/*     */ 
/*     */   private String getMatchColumnTableName(RowSet paramRowSet)
/*     */     throws SQLException
/*     */   {
/* 906 */     String str = null;
/* 907 */     if ((paramRowSet instanceof OracleRowSet))
/*     */     {
/* 909 */       str = ((OracleRowSet)paramRowSet).getTableName();
/*     */     }
/*     */ 
/* 912 */     return str;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.rowset.OracleJoinRowSet
 * JD-Core Version:    0.6.2
 */