/*      */ package oracle.jdbc.rowset;
/*      */ 
/*      */ import java.io.InputStream;
/*      */ import java.io.Reader;
/*      */ import java.math.BigDecimal;
/*      */ import java.net.URL;
/*      */ import java.sql.Array;
/*      */ import java.sql.Blob;
/*      */ import java.sql.Clob;
/*      */ import java.sql.Connection;
/*      */ import java.sql.Date;
/*      */ import java.sql.DriverManager;
/*      */ import java.sql.NClob;
/*      */ import java.sql.PreparedStatement;
/*      */ import java.sql.Ref;
/*      */ import java.sql.ResultSet;
/*      */ import java.sql.ResultSetMetaData;
/*      */ import java.sql.RowId;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.SQLWarning;
/*      */ import java.sql.SQLXML;
/*      */ import java.sql.Savepoint;
/*      */ import java.sql.Statement;
/*      */ import java.sql.Time;
/*      */ import java.sql.Timestamp;
/*      */ import java.util.Calendar;
/*      */ import java.util.Map;
/*      */ import javax.naming.InitialContext;
/*      */ import javax.naming.NamingException;
/*      */ import javax.sql.DataSource;
/*      */ import javax.sql.RowSet;
/*      */ import javax.sql.rowset.JdbcRowSet;
/*      */ import javax.sql.rowset.RowSetWarning;
/*      */ import oracle.jdbc.OracleResultSet;
/*      */ import oracle.jdbc.OracleSavepoint;
/*      */ import oracle.jdbc.driver.DatabaseError;
/*      */ import oracle.jdbc.driver.OracleDriver;
/*      */ import oracle.jdbc.internal.OraclePreparedStatement;
/*      */ 
/*      */ public class OracleJDBCRowSet extends OracleRowSet
/*      */   implements RowSet, JdbcRowSet
/*      */ {
/*      */   private Connection connection;
/*      */   private static boolean driverManagerInitialized;
/*      */   private PreparedStatement preparedStatement;
/*      */   private ResultSet resultSet;
/* 5629 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   public OracleJDBCRowSet()
/*      */     throws SQLException
/*      */   {
/*  176 */     driverManagerInitialized = false;
/*      */   }
/*      */ 
/*      */   public OracleJDBCRowSet(Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/*  191 */     this();
/*      */ 
/*  200 */     this.connection = paramConnection;
/*      */   }
/*      */ 
/*      */   public void execute()
/*      */     throws SQLException
/*      */   {
/*  215 */     this.connection = getConnection(this);
/*      */     try
/*      */     {
/*  221 */       this.connection.setTransactionIsolation(getTransactionIsolation());
/*      */     }
/*      */     catch (Exception localException)
/*      */     {
/*      */     }
/*      */ 
/*  228 */     this.connection.setTypeMap(getTypeMap());
/*      */ 
/*  230 */     if (this.preparedStatement == null) {
/*  231 */       this.preparedStatement = this.connection.prepareStatement(getCommand(), getType(), getConcurrency());
/*      */     }
/*  233 */     this.preparedStatement.setFetchSize(getFetchSize());
/*  234 */     this.preparedStatement.setFetchDirection(getFetchDirection());
/*  235 */     this.preparedStatement.setMaxFieldSize(getMaxFieldSize());
/*  236 */     this.preparedStatement.setMaxRows(getMaxRows());
/*  237 */     this.preparedStatement.setQueryTimeout(getQueryTimeout());
/*  238 */     this.preparedStatement.setEscapeProcessing(getEscapeProcessing());
/*      */ 
/*  242 */     this.resultSet = this.preparedStatement.executeQuery();
/*  243 */     notifyRowSetChanged();
/*      */   }
/*      */ 
/*      */   public void close()
/*      */     throws SQLException
/*      */   {
/*  260 */     if (this.resultSet != null) {
/*  261 */       this.resultSet.close();
/*      */     }
/*  263 */     if (this.preparedStatement != null) {
/*  264 */       this.preparedStatement.close();
/*      */     }
/*  266 */     if ((this.connection != null) && (!this.connection.isClosed()))
/*      */     {
/*  268 */       if (!this.connection.getAutoCommit())
/*      */       {
/*  270 */         this.connection.commit();
/*      */       }
/*  272 */       this.connection.close();
/*      */     }
/*  274 */     notifyRowSetChanged();
/*      */ 
/*  276 */     this.isClosed = true;
/*      */   }
/*      */ 
/*      */   private Connection getConnection(RowSet paramRowSet)
/*      */     throws SQLException
/*      */   {
/*  294 */     Connection localConnection = null;
/*      */ 
/*  298 */     if ((this.connection != null) && (!this.connection.isClosed()))
/*      */     {
/*  300 */       localConnection = this.connection;
/*      */     }
/*      */     else
/*      */     {
/*      */       Object localObject;
/*  302 */       if (paramRowSet.getDataSourceName() != null)
/*      */       {
/*      */         try
/*      */         {
/*  306 */           InitialContext localInitialContext = new InitialContext();
/*  307 */           localObject = (DataSource)localInitialContext.lookup(paramRowSet.getDataSourceName());
/*      */ 
/*  312 */           if ((paramRowSet.getUsername() == null) || (paramRowSet.getPassword() == null))
/*      */           {
/*  315 */             localConnection = ((DataSource)localObject).getConnection();
/*      */           }
/*      */           else
/*      */           {
/*  319 */             localConnection = ((DataSource)localObject).getConnection(paramRowSet.getUsername(), paramRowSet.getPassword());
/*      */           }
/*      */ 
/*      */         }
/*      */         catch (NamingException localNamingException)
/*      */         {
/*  326 */           localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 300, localNamingException.getMessage());
/*  327 */           ((SQLException)localObject).fillInStackTrace();
/*  328 */           throw ((Throwable)localObject);
/*      */         }
/*      */ 
/*      */       }
/*  332 */       else if (paramRowSet.getUrl() != null)
/*      */       {
/*  334 */         if (!driverManagerInitialized)
/*      */         {
/*  336 */           DriverManager.registerDriver(new OracleDriver());
/*  337 */           driverManagerInitialized = true;
/*      */         }
/*  339 */         String str1 = paramRowSet.getUrl();
/*  340 */         localObject = paramRowSet.getUsername();
/*  341 */         String str2 = paramRowSet.getPassword();
/*      */ 
/*  345 */         if ((str1.equals("")) || (((String)localObject).equals("")) || (str2.equals("")))
/*      */         {
/*  348 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 301);
/*  349 */           localSQLException.fillInStackTrace();
/*  350 */           throw localSQLException;
/*      */         }
/*      */ 
/*  353 */         localConnection = DriverManager.getConnection(str1, (String)localObject, str2);
/*      */       }
/*      */     }
/*  356 */     return localConnection;
/*      */   }
/*      */ 
/*      */   public boolean wasNull()
/*      */     throws SQLException
/*      */   {
/*  374 */     return this.resultSet.wasNull();
/*      */   }
/*      */ 
/*      */   public SQLWarning getWarnings()
/*      */     throws SQLException
/*      */   {
/*  388 */     return this.resultSet.getWarnings();
/*      */   }
/*      */ 
/*      */   public void clearWarnings()
/*      */     throws SQLException
/*      */   {
/*  402 */     this.resultSet.clearWarnings();
/*      */   }
/*      */ 
/*      */   public String getCursorName()
/*      */     throws SQLException
/*      */   {
/*  417 */     return this.resultSet.getCursorName();
/*      */   }
/*      */ 
/*      */   public ResultSetMetaData getMetaData()
/*      */     throws SQLException
/*      */   {
/*  431 */     return new OracleRowSetMetaData(this.resultSet.getMetaData());
/*      */   }
/*      */ 
/*      */   public int findColumn(String paramString)
/*      */     throws SQLException
/*      */   {
/*  445 */     return this.resultSet.findColumn(paramString);
/*      */   }
/*      */ 
/*      */   public void clearParameters()
/*      */     throws SQLException
/*      */   {
/*  459 */     this.preparedStatement.clearParameters();
/*      */   }
/*      */ 
/*      */   public Statement getStatement()
/*      */     throws SQLException
/*      */   {
/*  479 */     return this.resultSet.getStatement();
/*      */   }
/*      */ 
/*      */   public void setCommand(String paramString)
/*      */     throws SQLException
/*      */   {
/*  499 */     super.setCommand(paramString);
/*      */ 
/*  501 */     if ((this.connection == null) || (this.connection.isClosed())) {
/*  502 */       this.connection = getConnection(this);
/*      */     }
/*  504 */     if (this.preparedStatement != null)
/*      */     {
/*      */       try
/*      */       {
/*  508 */         this.preparedStatement.close();
/*  509 */         this.preparedStatement = null;
/*      */       } catch (SQLException localSQLException) {
/*      */       }
/*      */     }
/*  513 */     this.preparedStatement = this.connection.prepareStatement(paramString, getType(), getConcurrency());
/*      */   }
/*      */ 
/*      */   public void setReadOnly(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  528 */     super.setReadOnly(paramBoolean);
/*      */ 
/*  530 */     if (this.connection != null)
/*      */     {
/*  532 */       this.connection.setReadOnly(paramBoolean);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setFetchDirection(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  550 */     super.setFetchDirection(paramInt);
/*      */ 
/*  552 */     this.resultSet.setFetchDirection(this.fetchDirection);
/*      */   }
/*      */ 
/*      */   public void setShowDeleted(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  567 */     if (paramBoolean)
/*      */     {
/*  570 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 303);
/*  571 */       localSQLException.fillInStackTrace();
/*  572 */       throw localSQLException;
/*      */     }
/*      */ 
/*  577 */     super.setShowDeleted(paramBoolean);
/*      */   }
/*      */ 
/*      */   public boolean next()
/*      */     throws SQLException
/*      */   {
/*  597 */     boolean bool = this.resultSet.next();
/*      */ 
/*  601 */     if (bool) {
/*  602 */       notifyCursorMoved();
/*      */     }
/*  604 */     return bool;
/*      */   }
/*      */ 
/*      */   public boolean previous()
/*      */     throws SQLException
/*      */   {
/*  618 */     boolean bool = this.resultSet.previous();
/*      */ 
/*  622 */     if (bool) {
/*  623 */       notifyCursorMoved();
/*      */     }
/*  625 */     return bool;
/*      */   }
/*      */ 
/*      */   public void beforeFirst()
/*      */     throws SQLException
/*      */   {
/*  639 */     if (!isBeforeFirst())
/*      */     {
/*  641 */       this.resultSet.beforeFirst();
/*  642 */       notifyCursorMoved();
/*      */     }
/*      */   }
/*      */ 
/*      */   public void afterLast()
/*      */     throws SQLException
/*      */   {
/*  658 */     if (!isAfterLast())
/*      */     {
/*  660 */       this.resultSet.afterLast();
/*  661 */       notifyCursorMoved();
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean first()
/*      */     throws SQLException
/*      */   {
/*  677 */     boolean bool = this.resultSet.first();
/*      */ 
/*  681 */     if (bool) {
/*  682 */       notifyCursorMoved();
/*      */     }
/*  684 */     return bool;
/*      */   }
/*      */ 
/*      */   public boolean last()
/*      */     throws SQLException
/*      */   {
/*  698 */     boolean bool = this.resultSet.last();
/*      */ 
/*  702 */     if (bool) {
/*  703 */       notifyCursorMoved();
/*      */     }
/*  705 */     return bool;
/*      */   }
/*      */ 
/*      */   public boolean absolute(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  720 */     boolean bool = this.resultSet.absolute(paramInt);
/*      */ 
/*  724 */     if (bool) {
/*  725 */       notifyCursorMoved();
/*      */     }
/*  727 */     return bool;
/*      */   }
/*      */ 
/*      */   public boolean relative(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  741 */     boolean bool = this.resultSet.relative(paramInt);
/*      */ 
/*  745 */     if (bool) {
/*  746 */       notifyCursorMoved();
/*      */     }
/*  748 */     return bool;
/*      */   }
/*      */ 
/*      */   public boolean isBeforeFirst()
/*      */     throws SQLException
/*      */   {
/*  762 */     return this.resultSet.isBeforeFirst();
/*      */   }
/*      */ 
/*      */   public boolean isAfterLast()
/*      */     throws SQLException
/*      */   {
/*  776 */     return this.resultSet.isAfterLast();
/*      */   }
/*      */ 
/*      */   public boolean isFirst()
/*      */     throws SQLException
/*      */   {
/*  790 */     return this.resultSet.isFirst();
/*      */   }
/*      */ 
/*      */   public boolean isLast()
/*      */     throws SQLException
/*      */   {
/*  804 */     return this.resultSet.isLast();
/*      */   }
/*      */ 
/*      */   public void insertRow()
/*      */     throws SQLException
/*      */   {
/*  823 */     if (isReadOnly())
/*      */     {
/*  825 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/*  826 */       localSQLException.fillInStackTrace();
/*  827 */       throw localSQLException;
/*      */     }
/*      */ 
/*  830 */     this.resultSet.insertRow();
/*  831 */     notifyRowChanged();
/*      */   }
/*      */ 
/*      */   public void updateRow()
/*      */     throws SQLException
/*      */   {
/*  846 */     if (isReadOnly())
/*      */     {
/*  848 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/*  849 */       localSQLException.fillInStackTrace();
/*  850 */       throw localSQLException;
/*      */     }
/*      */ 
/*  853 */     this.resultSet.updateRow();
/*  854 */     notifyRowChanged();
/*      */   }
/*      */ 
/*      */   public void deleteRow()
/*      */     throws SQLException
/*      */   {
/*  869 */     if (isReadOnly())
/*      */     {
/*  871 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/*  872 */       localSQLException.fillInStackTrace();
/*  873 */       throw localSQLException;
/*      */     }
/*      */ 
/*  876 */     this.resultSet.deleteRow();
/*  877 */     notifyRowChanged();
/*      */   }
/*      */ 
/*      */   public void refreshRow()
/*      */     throws SQLException
/*      */   {
/*  892 */     this.resultSet.refreshRow();
/*      */   }
/*      */ 
/*      */   public void cancelRowUpdates()
/*      */     throws SQLException
/*      */   {
/*  907 */     this.resultSet.cancelRowUpdates();
/*  908 */     notifyRowChanged();
/*      */   }
/*      */ 
/*      */   public void moveToInsertRow()
/*      */     throws SQLException
/*      */   {
/*  923 */     if (isReadOnly())
/*      */     {
/*  925 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/*  926 */       localSQLException.fillInStackTrace();
/*  927 */       throw localSQLException;
/*      */     }
/*      */ 
/*  930 */     this.resultSet.moveToInsertRow();
/*      */   }
/*      */ 
/*      */   public void moveToCurrentRow()
/*      */     throws SQLException
/*      */   {
/*  945 */     if (isReadOnly())
/*      */     {
/*  947 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/*  948 */       localSQLException.fillInStackTrace();
/*  949 */       throw localSQLException;
/*      */     }
/*      */ 
/*  952 */     this.resultSet.moveToCurrentRow();
/*      */   }
/*      */ 
/*      */   public int getRow()
/*      */     throws SQLException
/*      */   {
/*  967 */     return this.resultSet.getRow();
/*      */   }
/*      */ 
/*      */   public boolean rowUpdated()
/*      */     throws SQLException
/*      */   {
/*  981 */     return this.resultSet.rowUpdated();
/*      */   }
/*      */ 
/*      */   public boolean rowInserted()
/*      */     throws SQLException
/*      */   {
/*  995 */     return this.resultSet.rowInserted();
/*      */   }
/*      */ 
/*      */   public boolean rowDeleted()
/*      */     throws SQLException
/*      */   {
/* 1009 */     return this.resultSet.rowDeleted();
/*      */   }
/*      */ 
/*      */   public void setNull(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 1028 */     this.preparedStatement.setNull(paramInt1, paramInt2);
/*      */   }
/*      */ 
/*      */   public void setNull(int paramInt1, int paramInt2, String paramString)
/*      */     throws SQLException
/*      */   {
/* 1043 */     this.preparedStatement.setNull(paramInt1, paramInt2, paramString);
/*      */   }
/*      */ 
/*      */   public void setBoolean(int paramInt, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 1058 */     this.preparedStatement.setBoolean(paramInt, paramBoolean);
/*      */   }
/*      */ 
/*      */   public void setByte(int paramInt, byte paramByte)
/*      */     throws SQLException
/*      */   {
/* 1073 */     this.preparedStatement.setByte(paramInt, paramByte);
/*      */   }
/*      */ 
/*      */   public void setShort(int paramInt, short paramShort)
/*      */     throws SQLException
/*      */   {
/* 1088 */     this.preparedStatement.setShort(paramInt, paramShort);
/*      */   }
/*      */ 
/*      */   public void setInt(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 1103 */     this.preparedStatement.setInt(paramInt1, paramInt2);
/*      */   }
/*      */ 
/*      */   public void setLong(int paramInt, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 1118 */     this.preparedStatement.setLong(paramInt, paramLong);
/*      */   }
/*      */ 
/*      */   public void setFloat(int paramInt, float paramFloat)
/*      */     throws SQLException
/*      */   {
/* 1133 */     this.preparedStatement.setFloat(paramInt, paramFloat);
/*      */   }
/*      */ 
/*      */   public void setDouble(int paramInt, double paramDouble)
/*      */     throws SQLException
/*      */   {
/* 1148 */     this.preparedStatement.setDouble(paramInt, paramDouble);
/*      */   }
/*      */ 
/*      */   public void setBigDecimal(int paramInt, BigDecimal paramBigDecimal)
/*      */     throws SQLException
/*      */   {
/* 1163 */     this.preparedStatement.setBigDecimal(paramInt, paramBigDecimal);
/*      */   }
/*      */ 
/*      */   public void setString(int paramInt, String paramString)
/*      */     throws SQLException
/*      */   {
/* 1178 */     this.preparedStatement.setString(paramInt, paramString);
/*      */   }
/*      */ 
/*      */   public void setBytes(int paramInt, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 1193 */     this.preparedStatement.setBytes(paramInt, paramArrayOfByte);
/*      */   }
/*      */ 
/*      */   public void setDate(int paramInt, Date paramDate)
/*      */     throws SQLException
/*      */   {
/* 1208 */     this.preparedStatement.setDate(paramInt, paramDate);
/*      */   }
/*      */ 
/*      */   public void setTime(int paramInt, Time paramTime)
/*      */     throws SQLException
/*      */   {
/* 1223 */     this.preparedStatement.setTime(paramInt, paramTime);
/*      */   }
/*      */ 
/*      */   public void setObject(int paramInt, Object paramObject)
/*      */     throws SQLException
/*      */   {
/* 1238 */     this.preparedStatement.setObject(paramInt, paramObject);
/*      */   }
/*      */ 
/*      */   public void setRef(int paramInt, Ref paramRef)
/*      */     throws SQLException
/*      */   {
/* 1253 */     this.preparedStatement.setRef(paramInt, paramRef);
/*      */   }
/*      */ 
/*      */   public void setBlob(int paramInt, Blob paramBlob)
/*      */     throws SQLException
/*      */   {
/* 1268 */     this.preparedStatement.setBlob(paramInt, paramBlob);
/*      */   }
/*      */ 
/*      */   public void setClob(int paramInt, Clob paramClob)
/*      */     throws SQLException
/*      */   {
/* 1283 */     this.preparedStatement.setClob(paramInt, paramClob);
/*      */   }
/*      */ 
/*      */   public void setArray(int paramInt, Array paramArray)
/*      */     throws SQLException
/*      */   {
/* 1298 */     this.preparedStatement.setArray(paramInt, paramArray);
/*      */   }
/*      */ 
/*      */   public void setBinaryStream(int paramInt1, InputStream paramInputStream, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 1314 */     this.preparedStatement.setBinaryStream(paramInt1, paramInputStream, paramInt2);
/*      */   }
/*      */ 
/*      */   public void setTime(int paramInt, Time paramTime, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 1329 */     this.preparedStatement.setTime(paramInt, paramTime, paramCalendar);
/*      */   }
/*      */ 
/*      */   public void setTimestamp(int paramInt, Timestamp paramTimestamp, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 1345 */     this.preparedStatement.setTimestamp(paramInt, paramTimestamp, paramCalendar);
/*      */   }
/*      */ 
/*      */   public void setTimestamp(int paramInt, Timestamp paramTimestamp)
/*      */     throws SQLException
/*      */   {
/* 1360 */     this.preparedStatement.setTimestamp(paramInt, paramTimestamp);
/*      */   }
/*      */ 
/*      */   public void setAsciiStream(int paramInt1, InputStream paramInputStream, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 1376 */     this.preparedStatement.setAsciiStream(paramInt1, paramInputStream, paramInt2);
/*      */   }
/*      */ 
/*      */   public void setCharacterStream(int paramInt1, Reader paramReader, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 1392 */     this.preparedStatement.setCharacterStream(paramInt1, paramReader, paramInt2);
/*      */   }
/*      */ 
/*      */   public void setObject(int paramInt1, Object paramObject, int paramInt2, int paramInt3)
/*      */     throws SQLException
/*      */   {
/* 1408 */     this.preparedStatement.setObject(paramInt1, paramObject, paramInt2, paramInt3);
/*      */   }
/*      */ 
/*      */   public void setObject(int paramInt1, Object paramObject, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 1423 */     this.preparedStatement.setObject(paramInt1, paramObject, paramInt2);
/*      */   }
/*      */ 
/*      */   public void setDate(int paramInt, Date paramDate, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 1438 */     this.preparedStatement.setDate(paramInt, paramDate, paramCalendar);
/*      */   }
/*      */ 
/*      */   public Object getObject(int paramInt, Map paramMap)
/*      */     throws SQLException
/*      */   {
/* 1457 */     return this.resultSet.getObject(paramInt, paramMap);
/*      */   }
/*      */ 
/*      */   public BigDecimal getBigDecimal(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1471 */     return this.resultSet.getBigDecimal(paramInt);
/*      */   }
/*      */ 
/*      */   public Ref getRef(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1485 */     return this.resultSet.getRef(paramInt);
/*      */   }
/*      */ 
/*      */   public Blob getBlob(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1499 */     return this.resultSet.getBlob(paramInt);
/*      */   }
/*      */ 
/*      */   public Clob getClob(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1513 */     return this.resultSet.getClob(paramInt);
/*      */   }
/*      */ 
/*      */   public Array getArray(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1527 */     return this.resultSet.getArray(paramInt);
/*      */   }
/*      */ 
/*      */   public Date getDate(int paramInt, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 1541 */     return this.resultSet.getDate(paramInt, paramCalendar);
/*      */   }
/*      */ 
/*      */   public Reader getCharacterStream(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1555 */     return this.resultSet.getCharacterStream(paramInt);
/*      */   }
/*      */ 
/*      */   public Time getTime(int paramInt, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 1569 */     return this.resultSet.getTime(paramInt, paramCalendar);
/*      */   }
/*      */ 
/*      */   public InputStream getBinaryStream(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1583 */     return this.resultSet.getBinaryStream(paramInt);
/*      */   }
/*      */ 
/*      */   public Timestamp getTimestamp(int paramInt, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 1597 */     return this.resultSet.getTimestamp(paramInt, paramCalendar);
/*      */   }
/*      */ 
/*      */   public String getString(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1610 */     return this.resultSet.getString(paramInt);
/*      */   }
/*      */ 
/*      */   public boolean getBoolean(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1624 */     return this.resultSet.getBoolean(paramInt);
/*      */   }
/*      */ 
/*      */   public byte getByte(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1638 */     return this.resultSet.getByte(paramInt);
/*      */   }
/*      */ 
/*      */   public short getShort(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1652 */     return this.resultSet.getShort(paramInt);
/*      */   }
/*      */ 
/*      */   public long getLong(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1666 */     return this.resultSet.getLong(paramInt);
/*      */   }
/*      */ 
/*      */   public float getFloat(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1680 */     return this.resultSet.getFloat(paramInt);
/*      */   }
/*      */ 
/*      */   public double getDouble(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1694 */     return this.resultSet.getDouble(paramInt);
/*      */   }
/*      */ 
/*      */   public BigDecimal getBigDecimal(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 1708 */     return this.resultSet.getBigDecimal(paramInt1, paramInt2);
/*      */   }
/*      */ 
/*      */   public byte[] getBytes(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1722 */     return this.resultSet.getBytes(paramInt);
/*      */   }
/*      */ 
/*      */   public Date getDate(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1736 */     return this.resultSet.getDate(paramInt);
/*      */   }
/*      */ 
/*      */   public Time getTime(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1750 */     return this.resultSet.getTime(paramInt);
/*      */   }
/*      */ 
/*      */   public Timestamp getTimestamp(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1764 */     return this.resultSet.getTimestamp(paramInt);
/*      */   }
/*      */ 
/*      */   public InputStream getAsciiStream(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1778 */     return this.resultSet.getAsciiStream(paramInt);
/*      */   }
/*      */ 
/*      */   public InputStream getUnicodeStream(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1792 */     return this.resultSet.getUnicodeStream(paramInt);
/*      */   }
/*      */ 
/*      */   public int getInt(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1806 */     return this.resultSet.getInt(paramInt);
/*      */   }
/*      */ 
/*      */   public Object getObject(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1821 */     return this.resultSet.getObject(paramInt);
/*      */   }
/*      */ 
/*      */   public int getInt(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1840 */     return this.resultSet.getInt(paramString);
/*      */   }
/*      */ 
/*      */   public long getLong(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1854 */     return this.resultSet.getLong(paramString);
/*      */   }
/*      */ 
/*      */   public float getFloat(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1868 */     return this.resultSet.getFloat(paramString);
/*      */   }
/*      */ 
/*      */   public double getDouble(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1882 */     return this.resultSet.getDouble(paramString);
/*      */   }
/*      */ 
/*      */   public BigDecimal getBigDecimal(String paramString, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1896 */     return this.resultSet.getBigDecimal(paramString, paramInt);
/*      */   }
/*      */ 
/*      */   public byte[] getBytes(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1910 */     return this.resultSet.getBytes(paramString);
/*      */   }
/*      */ 
/*      */   public Date getDate(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1924 */     return this.resultSet.getDate(paramString);
/*      */   }
/*      */ 
/*      */   public Time getTime(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1938 */     return this.resultSet.getTime(paramString);
/*      */   }
/*      */ 
/*      */   public Timestamp getTimestamp(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1952 */     return this.resultSet.getTimestamp(paramString);
/*      */   }
/*      */ 
/*      */   public InputStream getAsciiStream(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1966 */     return this.resultSet.getAsciiStream(paramString);
/*      */   }
/*      */ 
/*      */   public InputStream getUnicodeStream(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1980 */     return this.resultSet.getUnicodeStream(paramString);
/*      */   }
/*      */ 
/*      */   public Object getObject(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1994 */     return this.resultSet.getObject(paramString);
/*      */   }
/*      */ 
/*      */   public Reader getCharacterStream(String paramString)
/*      */     throws SQLException
/*      */   {
/* 2008 */     return this.resultSet.getCharacterStream(paramString);
/*      */   }
/*      */ 
/*      */   public Object getObject(String paramString, Map paramMap)
/*      */     throws SQLException
/*      */   {
/* 2023 */     return this.resultSet.getObject(paramString, paramMap);
/*      */   }
/*      */ 
/*      */   public Ref getRef(String paramString)
/*      */     throws SQLException
/*      */   {
/* 2037 */     return this.resultSet.getRef(paramString);
/*      */   }
/*      */ 
/*      */   public Blob getBlob(String paramString)
/*      */     throws SQLException
/*      */   {
/* 2051 */     return this.resultSet.getBlob(paramString);
/*      */   }
/*      */ 
/*      */   public Clob getClob(String paramString)
/*      */     throws SQLException
/*      */   {
/* 2065 */     return this.resultSet.getClob(paramString);
/*      */   }
/*      */ 
/*      */   public Array getArray(String paramString)
/*      */     throws SQLException
/*      */   {
/* 2079 */     return this.resultSet.getArray(paramString);
/*      */   }
/*      */ 
/*      */   public BigDecimal getBigDecimal(String paramString)
/*      */     throws SQLException
/*      */   {
/* 2093 */     return this.resultSet.getBigDecimal(paramString);
/*      */   }
/*      */ 
/*      */   public Date getDate(String paramString, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 2107 */     return this.resultSet.getDate(paramString, paramCalendar);
/*      */   }
/*      */ 
/*      */   public Time getTime(String paramString, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 2121 */     return this.resultSet.getTime(paramString, paramCalendar);
/*      */   }
/*      */ 
/*      */   public InputStream getBinaryStream(String paramString)
/*      */     throws SQLException
/*      */   {
/* 2135 */     return this.resultSet.getBinaryStream(paramString);
/*      */   }
/*      */ 
/*      */   public Timestamp getTimestamp(String paramString, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 2149 */     return this.resultSet.getTimestamp(paramString, paramCalendar);
/*      */   }
/*      */ 
/*      */   public String getString(String paramString)
/*      */     throws SQLException
/*      */   {
/* 2162 */     return this.resultSet.getString(paramString);
/*      */   }
/*      */ 
/*      */   public boolean getBoolean(String paramString)
/*      */     throws SQLException
/*      */   {
/* 2176 */     return this.resultSet.getBoolean(paramString);
/*      */   }
/*      */ 
/*      */   public byte getByte(String paramString)
/*      */     throws SQLException
/*      */   {
/* 2190 */     return this.resultSet.getByte(paramString);
/*      */   }
/*      */ 
/*      */   public short getShort(String paramString)
/*      */     throws SQLException
/*      */   {
/* 2204 */     return this.resultSet.getShort(paramString);
/*      */   }
/*      */ 
/*      */   public void updateNull(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2223 */     if (isReadOnly())
/*      */     {
/* 2225 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2226 */       localSQLException.fillInStackTrace();
/* 2227 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2230 */     this.resultSet.updateNull(paramInt);
/*      */   }
/*      */ 
/*      */   public void updateCharacterStream(int paramInt1, Reader paramReader, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 2246 */     if (isReadOnly())
/*      */     {
/* 2248 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2249 */       localSQLException.fillInStackTrace();
/* 2250 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2253 */     this.resultSet.updateCharacterStream(paramInt1, paramReader, paramInt2);
/*      */   }
/*      */ 
/*      */   public void updateTimestamp(int paramInt, Timestamp paramTimestamp)
/*      */     throws SQLException
/*      */   {
/* 2268 */     if (isReadOnly())
/*      */     {
/* 2270 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2271 */       localSQLException.fillInStackTrace();
/* 2272 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2275 */     this.resultSet.updateTimestamp(paramInt, paramTimestamp);
/*      */   }
/*      */ 
/*      */   public void updateBinaryStream(int paramInt1, InputStream paramInputStream, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 2291 */     if (isReadOnly())
/*      */     {
/* 2293 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2294 */       localSQLException.fillInStackTrace();
/* 2295 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2298 */     this.resultSet.updateBinaryStream(paramInt1, paramInputStream, paramInt2);
/*      */   }
/*      */ 
/*      */   public void updateAsciiStream(int paramInt1, InputStream paramInputStream, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 2314 */     if (isReadOnly())
/*      */     {
/* 2316 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2317 */       localSQLException.fillInStackTrace();
/* 2318 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2321 */     this.resultSet.updateAsciiStream(paramInt1, paramInputStream, paramInt2);
/*      */   }
/*      */ 
/*      */   public void updateBoolean(int paramInt, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 2336 */     if (isReadOnly())
/*      */     {
/* 2338 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2339 */       localSQLException.fillInStackTrace();
/* 2340 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2343 */     this.resultSet.updateBoolean(paramInt, paramBoolean);
/*      */   }
/*      */ 
/*      */   public void updateByte(int paramInt, byte paramByte)
/*      */     throws SQLException
/*      */   {
/* 2358 */     if (isReadOnly())
/*      */     {
/* 2360 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2361 */       localSQLException.fillInStackTrace();
/* 2362 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2365 */     this.resultSet.updateByte(paramInt, paramByte);
/*      */   }
/*      */ 
/*      */   public void updateShort(int paramInt, short paramShort)
/*      */     throws SQLException
/*      */   {
/* 2380 */     if (isReadOnly())
/*      */     {
/* 2382 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2383 */       localSQLException.fillInStackTrace();
/* 2384 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2387 */     this.resultSet.updateShort(paramInt, paramShort);
/*      */   }
/*      */ 
/*      */   public void updateInt(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 2402 */     if (isReadOnly())
/*      */     {
/* 2404 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2405 */       localSQLException.fillInStackTrace();
/* 2406 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2409 */     this.resultSet.updateInt(paramInt1, paramInt2);
/*      */   }
/*      */ 
/*      */   public void updateLong(int paramInt, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 2424 */     if (isReadOnly())
/*      */     {
/* 2426 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2427 */       localSQLException.fillInStackTrace();
/* 2428 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2431 */     this.resultSet.updateLong(paramInt, paramLong);
/*      */   }
/*      */ 
/*      */   public void updateFloat(int paramInt, float paramFloat)
/*      */     throws SQLException
/*      */   {
/* 2446 */     if (isReadOnly())
/*      */     {
/* 2448 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2449 */       localSQLException.fillInStackTrace();
/* 2450 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2453 */     this.resultSet.updateFloat(paramInt, paramFloat);
/*      */   }
/*      */ 
/*      */   public void updateDouble(int paramInt, double paramDouble)
/*      */     throws SQLException
/*      */   {
/* 2468 */     if (isReadOnly())
/*      */     {
/* 2470 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2471 */       localSQLException.fillInStackTrace();
/* 2472 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2475 */     this.resultSet.updateDouble(paramInt, paramDouble);
/*      */   }
/*      */ 
/*      */   public void updateBigDecimal(int paramInt, BigDecimal paramBigDecimal)
/*      */     throws SQLException
/*      */   {
/* 2490 */     if (isReadOnly())
/*      */     {
/* 2492 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2493 */       localSQLException.fillInStackTrace();
/* 2494 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2497 */     this.resultSet.updateBigDecimal(paramInt, paramBigDecimal);
/*      */   }
/*      */ 
/*      */   public void updateString(int paramInt, String paramString)
/*      */     throws SQLException
/*      */   {
/* 2512 */     if (isReadOnly())
/*      */     {
/* 2514 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2515 */       localSQLException.fillInStackTrace();
/* 2516 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2519 */     this.resultSet.updateString(paramInt, paramString);
/*      */   }
/*      */ 
/*      */   public void updateBytes(int paramInt, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 2534 */     if (isReadOnly())
/*      */     {
/* 2536 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2537 */       localSQLException.fillInStackTrace();
/* 2538 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2541 */     this.resultSet.updateBytes(paramInt, paramArrayOfByte);
/*      */   }
/*      */ 
/*      */   public void updateDate(int paramInt, Date paramDate)
/*      */     throws SQLException
/*      */   {
/* 2556 */     if (isReadOnly())
/*      */     {
/* 2558 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2559 */       localSQLException.fillInStackTrace();
/* 2560 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2563 */     this.resultSet.updateDate(paramInt, paramDate);
/*      */   }
/*      */ 
/*      */   public void updateTime(int paramInt, Time paramTime)
/*      */     throws SQLException
/*      */   {
/* 2578 */     if (isReadOnly())
/*      */     {
/* 2580 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2581 */       localSQLException.fillInStackTrace();
/* 2582 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2585 */     this.resultSet.updateTime(paramInt, paramTime);
/*      */   }
/*      */ 
/*      */   public void updateObject(int paramInt, Object paramObject)
/*      */     throws SQLException
/*      */   {
/* 2600 */     if (isReadOnly())
/*      */     {
/* 2602 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2603 */       localSQLException.fillInStackTrace();
/* 2604 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2607 */     this.resultSet.updateObject(paramInt, paramObject);
/*      */   }
/*      */ 
/*      */   public void updateObject(int paramInt1, Object paramObject, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 2622 */     if (isReadOnly())
/*      */     {
/* 2624 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2625 */       localSQLException.fillInStackTrace();
/* 2626 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2629 */     this.resultSet.updateObject(paramInt1, paramObject, paramInt2);
/*      */   }
/*      */ 
/*      */   public void updateNull(String paramString)
/*      */     throws SQLException
/*      */   {
/* 2649 */     if (isReadOnly())
/*      */     {
/* 2651 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2652 */       localSQLException.fillInStackTrace();
/* 2653 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2656 */     this.resultSet.updateNull(paramString);
/*      */   }
/*      */ 
/*      */   public void updateBoolean(String paramString, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 2671 */     if (isReadOnly())
/*      */     {
/* 2673 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2674 */       localSQLException.fillInStackTrace();
/* 2675 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2678 */     this.resultSet.updateBoolean(paramString, paramBoolean);
/*      */   }
/*      */ 
/*      */   public void updateByte(String paramString, byte paramByte)
/*      */     throws SQLException
/*      */   {
/* 2693 */     if (isReadOnly())
/*      */     {
/* 2695 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2696 */       localSQLException.fillInStackTrace();
/* 2697 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2700 */     this.resultSet.updateByte(paramString, paramByte);
/*      */   }
/*      */ 
/*      */   public void updateShort(String paramString, short paramShort)
/*      */     throws SQLException
/*      */   {
/* 2715 */     if (isReadOnly())
/*      */     {
/* 2717 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2718 */       localSQLException.fillInStackTrace();
/* 2719 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2722 */     this.resultSet.updateShort(paramString, paramShort);
/*      */   }
/*      */ 
/*      */   public void updateInt(String paramString, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2737 */     if (isReadOnly())
/*      */     {
/* 2739 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2740 */       localSQLException.fillInStackTrace();
/* 2741 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2744 */     this.resultSet.updateInt(paramString, paramInt);
/*      */   }
/*      */ 
/*      */   public void updateLong(String paramString, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 2759 */     if (isReadOnly())
/*      */     {
/* 2761 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2762 */       localSQLException.fillInStackTrace();
/* 2763 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2766 */     this.resultSet.updateLong(paramString, paramLong);
/*      */   }
/*      */ 
/*      */   public void updateFloat(String paramString, float paramFloat)
/*      */     throws SQLException
/*      */   {
/* 2781 */     if (isReadOnly())
/*      */     {
/* 2783 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2784 */       localSQLException.fillInStackTrace();
/* 2785 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2788 */     this.resultSet.updateFloat(paramString, paramFloat);
/*      */   }
/*      */ 
/*      */   public void updateDouble(String paramString, double paramDouble)
/*      */     throws SQLException
/*      */   {
/* 2803 */     if (isReadOnly())
/*      */     {
/* 2805 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2806 */       localSQLException.fillInStackTrace();
/* 2807 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2810 */     this.resultSet.updateDouble(paramString, paramDouble);
/*      */   }
/*      */ 
/*      */   public void updateBigDecimal(String paramString, BigDecimal paramBigDecimal)
/*      */     throws SQLException
/*      */   {
/* 2825 */     if (isReadOnly())
/*      */     {
/* 2827 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2828 */       localSQLException.fillInStackTrace();
/* 2829 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2832 */     this.resultSet.updateBigDecimal(paramString, paramBigDecimal);
/*      */   }
/*      */ 
/*      */   public void updateString(String paramString1, String paramString2)
/*      */     throws SQLException
/*      */   {
/* 2847 */     if (isReadOnly())
/*      */     {
/* 2849 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2850 */       localSQLException.fillInStackTrace();
/* 2851 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2854 */     this.resultSet.updateString(paramString1, paramString2);
/*      */   }
/*      */ 
/*      */   public void updateBytes(String paramString, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 2869 */     if (isReadOnly())
/*      */     {
/* 2871 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2872 */       localSQLException.fillInStackTrace();
/* 2873 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2876 */     this.resultSet.updateBytes(paramString, paramArrayOfByte);
/*      */   }
/*      */ 
/*      */   public void updateDate(String paramString, Date paramDate)
/*      */     throws SQLException
/*      */   {
/* 2891 */     if (isReadOnly())
/*      */     {
/* 2893 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2894 */       localSQLException.fillInStackTrace();
/* 2895 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2898 */     this.resultSet.updateDate(paramString, paramDate);
/*      */   }
/*      */ 
/*      */   public void updateTime(String paramString, Time paramTime)
/*      */     throws SQLException
/*      */   {
/* 2913 */     if (isReadOnly())
/*      */     {
/* 2915 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2916 */       localSQLException.fillInStackTrace();
/* 2917 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2920 */     this.resultSet.updateTime(paramString, paramTime);
/*      */   }
/*      */ 
/*      */   public void updateObject(String paramString, Object paramObject)
/*      */     throws SQLException
/*      */   {
/* 2935 */     if (isReadOnly())
/*      */     {
/* 2937 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2938 */       localSQLException.fillInStackTrace();
/* 2939 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2942 */     this.resultSet.updateObject(paramString, paramObject);
/*      */   }
/*      */ 
/*      */   public void updateObject(String paramString, Object paramObject, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2957 */     if (isReadOnly())
/*      */     {
/* 2959 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2960 */       localSQLException.fillInStackTrace();
/* 2961 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2964 */     this.resultSet.updateObject(paramString, paramObject, paramInt);
/*      */   }
/*      */ 
/*      */   public void updateBinaryStream(String paramString, InputStream paramInputStream, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2980 */     if (isReadOnly())
/*      */     {
/* 2982 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2983 */       localSQLException.fillInStackTrace();
/* 2984 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2987 */     this.resultSet.updateBinaryStream(paramString, paramInputStream, paramInt);
/*      */   }
/*      */ 
/*      */   public void updateAsciiStream(String paramString, InputStream paramInputStream, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3003 */     if (isReadOnly())
/*      */     {
/* 3005 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 3006 */       localSQLException.fillInStackTrace();
/* 3007 */       throw localSQLException;
/*      */     }
/*      */ 
/* 3010 */     this.resultSet.updateAsciiStream(paramString, paramInputStream, paramInt);
/*      */   }
/*      */ 
/*      */   public void updateTimestamp(String paramString, Timestamp paramTimestamp)
/*      */     throws SQLException
/*      */   {
/* 3025 */     if (isReadOnly())
/*      */     {
/* 3027 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 3028 */       localSQLException.fillInStackTrace();
/* 3029 */       throw localSQLException;
/*      */     }
/*      */ 
/* 3032 */     this.resultSet.updateTimestamp(paramString, paramTimestamp);
/*      */   }
/*      */ 
/*      */   public void updateCharacterStream(String paramString, Reader paramReader, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3048 */     if (isReadOnly())
/*      */     {
/* 3050 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 3051 */       localSQLException.fillInStackTrace();
/* 3052 */       throw localSQLException;
/*      */     }
/*      */ 
/* 3055 */     this.resultSet.updateCharacterStream(paramString, paramReader, paramInt);
/*      */   }
/*      */ 
/*      */   public URL getURL(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3088 */     return ((OracleResultSet)this.resultSet).getURL(paramInt);
/*      */   }
/*      */ 
/*      */   public URL getURL(String paramString)
/*      */     throws SQLException
/*      */   {
/* 3117 */     return ((OracleResultSet)this.resultSet).getURL(paramString);
/*      */   }
/*      */ 
/*      */   public void updateRef(int paramInt, Ref paramRef)
/*      */     throws SQLException
/*      */   {
/* 3145 */     if (isReadOnly())
/*      */     {
/* 3147 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 3148 */       localSQLException.fillInStackTrace();
/* 3149 */       throw localSQLException;
/*      */     }
/*      */ 
/* 3152 */     ((OracleResultSet)this.resultSet).updateRef(paramInt, paramRef);
/*      */   }
/*      */ 
/*      */   public void updateRef(String paramString, Ref paramRef)
/*      */     throws SQLException
/*      */   {
/* 3181 */     if (isReadOnly())
/*      */     {
/* 3183 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 3184 */       localSQLException.fillInStackTrace();
/* 3185 */       throw localSQLException;
/*      */     }
/*      */ 
/* 3188 */     ((OracleResultSet)this.resultSet).updateRef(paramString, paramRef);
/*      */   }
/*      */ 
/*      */   public void updateBlob(int paramInt, Blob paramBlob)
/*      */     throws SQLException
/*      */   {
/* 3217 */     if (isReadOnly())
/*      */     {
/* 3219 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 3220 */       localSQLException.fillInStackTrace();
/* 3221 */       throw localSQLException;
/*      */     }
/*      */ 
/* 3224 */     ((OracleResultSet)this.resultSet).updateBlob(paramInt, paramBlob);
/*      */   }
/*      */ 
/*      */   public void updateBlob(String paramString, Blob paramBlob)
/*      */     throws SQLException
/*      */   {
/* 3253 */     if (isReadOnly())
/*      */     {
/* 3255 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 3256 */       localSQLException.fillInStackTrace();
/* 3257 */       throw localSQLException;
/*      */     }
/*      */ 
/* 3260 */     ((OracleResultSet)this.resultSet).updateBlob(paramString, paramBlob);
/*      */   }
/*      */ 
/*      */   public void updateClob(int paramInt, Clob paramClob)
/*      */     throws SQLException
/*      */   {
/* 3289 */     if (isReadOnly())
/*      */     {
/* 3291 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 3292 */       localSQLException.fillInStackTrace();
/* 3293 */       throw localSQLException;
/*      */     }
/*      */ 
/* 3296 */     ((OracleResultSet)this.resultSet).updateClob(paramInt, paramClob);
/*      */   }
/*      */ 
/*      */   public void updateClob(String paramString, Clob paramClob)
/*      */     throws SQLException
/*      */   {
/* 3325 */     if (isReadOnly())
/*      */     {
/* 3327 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 3328 */       localSQLException.fillInStackTrace();
/* 3329 */       throw localSQLException;
/*      */     }
/*      */ 
/* 3332 */     ((OracleResultSet)this.resultSet).updateClob(paramString, paramClob);
/*      */   }
/*      */ 
/*      */   public void updateArray(int paramInt, Array paramArray)
/*      */     throws SQLException
/*      */   {
/* 3361 */     if (isReadOnly())
/*      */     {
/* 3363 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 3364 */       localSQLException.fillInStackTrace();
/* 3365 */       throw localSQLException;
/*      */     }
/*      */ 
/* 3368 */     ((OracleResultSet)this.resultSet).updateArray(paramInt, paramArray);
/*      */   }
/*      */ 
/*      */   public void updateArray(String paramString, Array paramArray)
/*      */     throws SQLException
/*      */   {
/* 3397 */     if (isReadOnly())
/*      */     {
/* 3399 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 3400 */       localSQLException.fillInStackTrace();
/* 3401 */       throw localSQLException;
/*      */     }
/*      */ 
/* 3404 */     ((OracleResultSet)this.resultSet).updateArray(paramString, paramArray);
/*      */   }
/*      */ 
/*      */   public void commit()
/*      */     throws SQLException
/*      */   {
/* 3434 */     if (this.connection != null)
/*      */     {
/* 3436 */       this.connection.commit();
/*      */     }
/*      */     else
/*      */     {
/* 3441 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 302);
/* 3442 */       localSQLException.fillInStackTrace();
/* 3443 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void rollback()
/*      */     throws SQLException
/*      */   {
/* 3472 */     if (this.connection != null)
/*      */     {
/* 3474 */       this.connection.rollback();
/*      */     }
/*      */     else
/*      */     {
/* 3479 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 302);
/* 3480 */       localSQLException.fillInStackTrace();
/* 3481 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void rollback(Savepoint paramSavepoint)
/*      */     throws SQLException
/*      */   {
/* 3512 */     if (this.connection != null)
/*      */     {
/* 3514 */       this.connection.rollback(paramSavepoint);
/*      */     }
/*      */     else
/*      */     {
/* 3519 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 302);
/* 3520 */       localSQLException.fillInStackTrace();
/* 3521 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void oracleRollback(OracleSavepoint paramOracleSavepoint)
/*      */     throws SQLException
/*      */   {
/* 3554 */     if (this.connection != null)
/*      */     {
/* 3556 */       ((oracle.jdbc.OracleConnection)this.connection).oracleRollback(paramOracleSavepoint);
/*      */     }
/*      */     else
/*      */     {
/* 3561 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 302);
/* 3562 */       localSQLException.fillInStackTrace();
/* 3563 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean getAutoCommit()
/*      */     throws SQLException
/*      */   {
/* 3590 */     if (this.connection != null)
/*      */     {
/* 3592 */       return this.connection.getAutoCommit();
/*      */     }
/*      */ 
/* 3597 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 302);
/* 3598 */     localSQLException.fillInStackTrace();
/* 3599 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public void setAutoCommit(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 3630 */     if (this.connection != null)
/*      */     {
/* 3632 */       this.connection.setAutoCommit(paramBoolean);
/*      */     }
/*      */     else
/*      */     {
/* 3637 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 302);
/* 3638 */       localSQLException.fillInStackTrace();
/* 3639 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public RowSetWarning getRowSetWarnings()
/*      */     throws SQLException
/*      */   {
/* 3661 */     return null;
/*      */   }
/*      */ 
/*      */   String getTableName()
/*      */     throws SQLException
/*      */   {
/* 3674 */     return getMetaData().getTableName(getMatchColumnIndexes()[0]);
/*      */   }
/*      */ 
/*      */   public Reader getNCharacterStream(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3694 */     return this.resultSet.getNCharacterStream(paramInt);
/*      */   }
/*      */ 
/*      */   public NClob getNClob(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3708 */     return this.resultSet.getNClob(paramInt);
/*      */   }
/*      */ 
/*      */   public NClob getNClob(String paramString)
/*      */     throws SQLException
/*      */   {
/* 3722 */     return this.resultSet.getNClob(paramString);
/*      */   }
/*      */ 
/*      */   public String getNString(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3736 */     return this.resultSet.getNString(paramInt);
/*      */   }
/*      */ 
/*      */   public RowId getRowId(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3750 */     return this.resultSet.getRowId(paramInt);
/*      */   }
/*      */ 
/*      */   public SQLXML getSQLXML(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3764 */     return this.resultSet.getSQLXML(paramInt);
/*      */   }
/*      */ 
/*      */   public Reader getNCharacterStream(String paramString)
/*      */     throws SQLException
/*      */   {
/* 3782 */     return this.resultSet.getNCharacterStream(paramString);
/*      */   }
/*      */ 
/*      */   public String getNString(String paramString)
/*      */     throws SQLException
/*      */   {
/* 3796 */     return this.resultSet.getNString(paramString);
/*      */   }
/*      */ 
/*      */   public RowId getRowId(String paramString)
/*      */     throws SQLException
/*      */   {
/* 3810 */     return this.resultSet.getRowId(paramString);
/*      */   }
/*      */ 
/*      */   public SQLXML getSQLXML(String paramString)
/*      */     throws SQLException
/*      */   {
/* 3824 */     return this.resultSet.getSQLXML(paramString);
/*      */   }
/*      */ 
/*      */   public void setAsciiStream(int paramInt, InputStream paramInputStream)
/*      */     throws SQLException
/*      */   {
/* 3842 */     this.preparedStatement.setAsciiStream(paramInt, paramInputStream);
/*      */   }
/*      */ 
/*      */   public void setBinaryStream(int paramInt, InputStream paramInputStream)
/*      */     throws SQLException
/*      */   {
/* 3857 */     this.preparedStatement.setBinaryStream(paramInt, paramInputStream);
/*      */   }
/*      */ 
/*      */   public void setBlob(int paramInt, InputStream paramInputStream)
/*      */     throws SQLException
/*      */   {
/* 3872 */     this.preparedStatement.setBlob(paramInt, paramInputStream);
/*      */   }
/*      */ 
/*      */   public void setBlob(int paramInt, InputStream paramInputStream, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 3887 */     this.preparedStatement.setBlob(paramInt, paramInputStream, paramLong);
/*      */   }
/*      */ 
/*      */   public void setCharacterStream(int paramInt, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 3902 */     this.preparedStatement.setCharacterStream(paramInt, paramReader);
/*      */   }
/*      */ 
/*      */   public void setClob(int paramInt, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 3917 */     this.preparedStatement.setClob(paramInt, paramReader);
/*      */   }
/*      */ 
/*      */   public void setClob(int paramInt, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 3932 */     this.preparedStatement.setClob(paramInt, paramReader, paramLong);
/*      */   }
/*      */ 
/*      */   public void setNCharacterStream(int paramInt, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 3947 */     this.preparedStatement.setNCharacterStream(paramInt, paramReader);
/*      */   }
/*      */ 
/*      */   public void setNCharacterStream(int paramInt, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 3962 */     this.preparedStatement.setNCharacterStream(paramInt, paramReader, paramLong);
/*      */   }
/*      */ 
/*      */   public void setNClob(int paramInt, NClob paramNClob)
/*      */     throws SQLException
/*      */   {
/* 3977 */     this.preparedStatement.setNClob(paramInt, paramNClob);
/*      */   }
/*      */ 
/*      */   public void setNClob(int paramInt, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 3992 */     this.preparedStatement.setNClob(paramInt, paramReader);
/*      */   }
/*      */ 
/*      */   public void setNClob(int paramInt, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 4007 */     this.preparedStatement.setNClob(paramInt, paramReader);
/*      */   }
/*      */ 
/*      */   public void setNString(int paramInt, String paramString)
/*      */     throws SQLException
/*      */   {
/* 4022 */     this.preparedStatement.setNString(paramInt, paramString);
/*      */   }
/*      */ 
/*      */   public void setRowId(int paramInt, RowId paramRowId)
/*      */     throws SQLException
/*      */   {
/* 4037 */     this.preparedStatement.setRowId(paramInt, paramRowId);
/*      */   }
/*      */ 
/*      */   public void setSQLXML(int paramInt, SQLXML paramSQLXML)
/*      */     throws SQLException
/*      */   {
/* 4052 */     this.preparedStatement.setSQLXML(paramInt, paramSQLXML);
/*      */   }
/*      */ 
/*      */   public void setURL(int paramInt, URL paramURL)
/*      */     throws SQLException
/*      */   {
/* 4067 */     this.preparedStatement.setURL(paramInt, paramURL);
/*      */   }
/*      */ 
/*      */   public void setArray(String paramString, Array paramArray)
/*      */     throws SQLException
/*      */   {
/* 4090 */     ((OraclePreparedStatement)this.preparedStatement).setArrayAtName(paramString, paramArray);
/*      */   }
/*      */ 
/*      */   public void setBigDecimal(String paramString, BigDecimal paramBigDecimal)
/*      */     throws SQLException
/*      */   {
/* 4105 */     ((OraclePreparedStatement)this.preparedStatement).setBigDecimalAtName(paramString, paramBigDecimal);
/*      */   }
/*      */ 
/*      */   public void setBlob(String paramString, Blob paramBlob)
/*      */     throws SQLException
/*      */   {
/* 4120 */     ((OraclePreparedStatement)this.preparedStatement).setBlobAtName(paramString, paramBlob);
/*      */   }
/*      */ 
/*      */   public void setBoolean(String paramString, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 4135 */     ((OraclePreparedStatement)this.preparedStatement).setBooleanAtName(paramString, paramBoolean);
/*      */   }
/*      */ 
/*      */   public void setByte(String paramString, byte paramByte)
/*      */     throws SQLException
/*      */   {
/* 4150 */     ((OraclePreparedStatement)this.preparedStatement).setByteAtName(paramString, paramByte);
/*      */   }
/*      */ 
/*      */   public void setBytes(String paramString, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 4165 */     ((OraclePreparedStatement)this.preparedStatement).setBytesAtName(paramString, paramArrayOfByte);
/*      */   }
/*      */ 
/*      */   public void setClob(String paramString, Clob paramClob)
/*      */     throws SQLException
/*      */   {
/* 4180 */     ((OraclePreparedStatement)this.preparedStatement).setClobAtName(paramString, paramClob);
/*      */   }
/*      */ 
/*      */   public void setDate(String paramString, Date paramDate)
/*      */     throws SQLException
/*      */   {
/* 4195 */     ((OraclePreparedStatement)this.preparedStatement).setDateAtName(paramString, paramDate);
/*      */   }
/*      */ 
/*      */   public void setDate(String paramString, Date paramDate, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 4210 */     ((OraclePreparedStatement)this.preparedStatement).setDateAtName(paramString, paramDate, paramCalendar);
/*      */   }
/*      */ 
/*      */   public void setDouble(String paramString, double paramDouble)
/*      */     throws SQLException
/*      */   {
/* 4225 */     ((OraclePreparedStatement)this.preparedStatement).setDoubleAtName(paramString, paramDouble);
/*      */   }
/*      */ 
/*      */   public void setFloat(String paramString, float paramFloat)
/*      */     throws SQLException
/*      */   {
/* 4240 */     ((OraclePreparedStatement)this.preparedStatement).setFloatAtName(paramString, paramFloat);
/*      */   }
/*      */ 
/*      */   public void setInt(String paramString, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 4255 */     ((OraclePreparedStatement)this.preparedStatement).setIntAtName(paramString, paramInt);
/*      */   }
/*      */ 
/*      */   public void setLong(String paramString, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 4270 */     ((OraclePreparedStatement)this.preparedStatement).setLongAtName(paramString, paramLong);
/*      */   }
/*      */ 
/*      */   public void setNClob(String paramString, NClob paramNClob)
/*      */     throws SQLException
/*      */   {
/* 4285 */     ((OraclePreparedStatement)this.preparedStatement).setNClobAtName(paramString, paramNClob);
/*      */   }
/*      */ 
/*      */   public void setNString(String paramString1, String paramString2)
/*      */     throws SQLException
/*      */   {
/* 4300 */     ((OraclePreparedStatement)this.preparedStatement).setNStringAtName(paramString1, paramString2);
/*      */   }
/*      */ 
/*      */   public void setObject(String paramString, Object paramObject)
/*      */     throws SQLException
/*      */   {
/* 4315 */     ((OraclePreparedStatement)this.preparedStatement).setObjectAtName(paramString, paramObject);
/*      */   }
/*      */ 
/*      */   public void setObject(String paramString, Object paramObject, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 4330 */     ((OraclePreparedStatement)this.preparedStatement).setObjectAtName(paramString, paramObject, paramInt);
/*      */   }
/*      */ 
/*      */   public void setRef(String paramString, Ref paramRef)
/*      */     throws SQLException
/*      */   {
/* 4345 */     ((OraclePreparedStatement)this.preparedStatement).setRefAtName(paramString, paramRef);
/*      */   }
/*      */ 
/*      */   public void setRowId(String paramString, RowId paramRowId)
/*      */     throws SQLException
/*      */   {
/* 4360 */     ((OraclePreparedStatement)this.preparedStatement).setRowIdAtName(paramString, paramRowId);
/*      */   }
/*      */ 
/*      */   public void setShort(String paramString, short paramShort)
/*      */     throws SQLException
/*      */   {
/* 4375 */     ((OraclePreparedStatement)this.preparedStatement).setShortAtName(paramString, paramShort);
/*      */   }
/*      */ 
/*      */   public void setSQLXML(String paramString, SQLXML paramSQLXML)
/*      */     throws SQLException
/*      */   {
/* 4390 */     ((OraclePreparedStatement)this.preparedStatement).setSQLXMLAtName(paramString, paramSQLXML);
/*      */   }
/*      */ 
/*      */   public void setString(String paramString1, String paramString2)
/*      */     throws SQLException
/*      */   {
/* 4405 */     ((OraclePreparedStatement)this.preparedStatement).setStringAtName(paramString1, paramString2);
/*      */   }
/*      */ 
/*      */   public void setTime(String paramString, Time paramTime)
/*      */     throws SQLException
/*      */   {
/* 4420 */     ((OraclePreparedStatement)this.preparedStatement).setTimeAtName(paramString, paramTime);
/*      */   }
/*      */ 
/*      */   public void setTime(String paramString, Time paramTime, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 4435 */     ((OraclePreparedStatement)this.preparedStatement).setTimeAtName(paramString, paramTime, paramCalendar);
/*      */   }
/*      */ 
/*      */   public void setTimestamp(String paramString, Timestamp paramTimestamp)
/*      */     throws SQLException
/*      */   {
/* 4450 */     ((OraclePreparedStatement)this.preparedStatement).setTimestampAtName(paramString, paramTimestamp);
/*      */   }
/*      */ 
/*      */   public void setTimestamp(String paramString, Timestamp paramTimestamp, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 4465 */     ((OraclePreparedStatement)this.preparedStatement).setTimestampAtName(paramString, paramTimestamp, paramCalendar);
/*      */   }
/*      */ 
/*      */   public void setURL(String paramString, URL paramURL)
/*      */     throws SQLException
/*      */   {
/* 4480 */     ((OraclePreparedStatement)this.preparedStatement).setURLAtName(paramString, paramURL);
/*      */   }
/*      */ 
/*      */   public void setBlob(String paramString, InputStream paramInputStream)
/*      */     throws SQLException
/*      */   {
/* 4495 */     ((OraclePreparedStatement)this.preparedStatement).setBlobAtName(paramString, paramInputStream);
/*      */   }
/*      */ 
/*      */   public void setBlob(String paramString, InputStream paramInputStream, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 4510 */     ((OraclePreparedStatement)this.preparedStatement).setBlobAtName(paramString, paramInputStream, paramLong);
/*      */   }
/*      */ 
/*      */   public void setClob(String paramString, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 4525 */     ((OraclePreparedStatement)this.preparedStatement).setClobAtName(paramString, paramReader);
/*      */   }
/*      */ 
/*      */   public void setClob(String paramString, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 4540 */     ((OraclePreparedStatement)this.preparedStatement).setClobAtName(paramString, paramReader, paramLong);
/*      */   }
/*      */ 
/*      */   public void setNClob(String paramString, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 4555 */     ((OraclePreparedStatement)this.preparedStatement).setNClobAtName(paramString, paramReader);
/*      */   }
/*      */ 
/*      */   public void setNClob(String paramString, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 4570 */     ((OraclePreparedStatement)this.preparedStatement).setNClobAtName(paramString, paramReader, paramLong);
/*      */   }
/*      */ 
/*      */   public void setAsciiStream(String paramString, InputStream paramInputStream)
/*      */     throws SQLException
/*      */   {
/* 4585 */     ((OraclePreparedStatement)this.preparedStatement).setAsciiStreamAtName(paramString, paramInputStream);
/*      */   }
/*      */ 
/*      */   public void setAsciiStream(String paramString, InputStream paramInputStream, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 4600 */     ((OraclePreparedStatement)this.preparedStatement).setAsciiStreamAtName(paramString, paramInputStream, paramInt);
/*      */   }
/*      */ 
/*      */   public void setAsciiStream(String paramString, InputStream paramInputStream, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 4615 */     ((OraclePreparedStatement)this.preparedStatement).setAsciiStreamAtName(paramString, paramInputStream, paramLong);
/*      */   }
/*      */ 
/*      */   public void setBinaryStream(String paramString, InputStream paramInputStream)
/*      */     throws SQLException
/*      */   {
/* 4630 */     ((OraclePreparedStatement)this.preparedStatement).setBinaryStreamAtName(paramString, paramInputStream);
/*      */   }
/*      */ 
/*      */   public void setBinaryStream(String paramString, InputStream paramInputStream, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 4645 */     ((OraclePreparedStatement)this.preparedStatement).setBinaryStreamAtName(paramString, paramInputStream, paramInt);
/*      */   }
/*      */ 
/*      */   public void setBinaryStream(String paramString, InputStream paramInputStream, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 4660 */     ((OraclePreparedStatement)this.preparedStatement).setBinaryStreamAtName(paramString, paramInputStream, paramLong);
/*      */   }
/*      */ 
/*      */   public void setCharacterStream(String paramString, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 4675 */     ((OraclePreparedStatement)this.preparedStatement).setCharacterStreamAtName(paramString, paramReader);
/*      */   }
/*      */ 
/*      */   public void setCharacterStream(String paramString, Reader paramReader, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 4690 */     ((OraclePreparedStatement)this.preparedStatement).setCharacterStreamAtName(paramString, paramReader, paramInt);
/*      */   }
/*      */ 
/*      */   public void setCharacterStream(String paramString, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 4705 */     ((OraclePreparedStatement)this.preparedStatement).setCharacterStreamAtName(paramString, paramReader, paramLong);
/*      */   }
/*      */ 
/*      */   public void setNCharacterStream(String paramString, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 4720 */     ((OraclePreparedStatement)this.preparedStatement).setNCharacterStreamAtName(paramString, paramReader);
/*      */   }
/*      */ 
/*      */   public void setNCharacterStream(String paramString, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 4735 */     ((OraclePreparedStatement)this.preparedStatement).setNCharacterStreamAtName(paramString, paramReader, paramLong);
/*      */   }
/*      */ 
/*      */   public void setUnicodeStream(String paramString, InputStream paramInputStream, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 4750 */     ((OraclePreparedStatement)this.preparedStatement).setUnicodeStreamAtName(paramString, paramInputStream, paramInt);
/*      */   }
/*      */ 
/*      */   public void setNull(String paramString, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 4772 */     ((OraclePreparedStatement)this.preparedStatement).setNullAtName(paramString, paramInt);
/*      */   }
/*      */ 
/*      */   public void setNull(String paramString1, int paramInt, String paramString2)
/*      */     throws SQLException
/*      */   {
/* 4787 */     ((OraclePreparedStatement)this.preparedStatement).setNullAtName(paramString1, paramInt, paramString2);
/*      */   }
/*      */ 
/*      */   public void setObject(String paramString, Object paramObject, int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 4803 */     ((OraclePreparedStatement)this.preparedStatement).setObjectAtName(paramString, paramObject, paramInt1, paramInt2);
/*      */   }
/*      */ 
/*      */   public void updateAsciiStream(int paramInt, InputStream paramInputStream)
/*      */     throws SQLException
/*      */   {
/* 4822 */     if (isReadOnly())
/*      */     {
/* 4824 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 4825 */       localSQLException.fillInStackTrace();
/* 4826 */       throw localSQLException;
/*      */     }
/*      */ 
/* 4829 */     this.resultSet.updateAsciiStream(paramInt, paramInputStream);
/*      */   }
/*      */ 
/*      */   public void updateAsciiStream(int paramInt, InputStream paramInputStream, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 4844 */     if (isReadOnly())
/*      */     {
/* 4846 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 4847 */       localSQLException.fillInStackTrace();
/* 4848 */       throw localSQLException;
/*      */     }
/*      */ 
/* 4851 */     this.resultSet.updateAsciiStream(paramInt, paramInputStream, paramLong);
/*      */   }
/*      */ 
/*      */   public void updateAsciiStream(String paramString, InputStream paramInputStream)
/*      */     throws SQLException
/*      */   {
/* 4866 */     if (isReadOnly())
/*      */     {
/* 4868 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 4869 */       localSQLException.fillInStackTrace();
/* 4870 */       throw localSQLException;
/*      */     }
/*      */ 
/* 4873 */     this.resultSet.updateAsciiStream(paramString, paramInputStream);
/*      */   }
/*      */ 
/*      */   public void updateAsciiStream(String paramString, InputStream paramInputStream, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 4888 */     if (isReadOnly())
/*      */     {
/* 4890 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 4891 */       localSQLException.fillInStackTrace();
/* 4892 */       throw localSQLException;
/*      */     }
/*      */ 
/* 4895 */     this.resultSet.updateAsciiStream(paramString, paramInputStream, paramLong);
/*      */   }
/*      */ 
/*      */   public void updateBinaryStream(int paramInt, InputStream paramInputStream)
/*      */     throws SQLException
/*      */   {
/* 4910 */     if (isReadOnly())
/*      */     {
/* 4912 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 4913 */       localSQLException.fillInStackTrace();
/* 4914 */       throw localSQLException;
/*      */     }
/*      */ 
/* 4917 */     this.resultSet.updateBinaryStream(paramInt, paramInputStream);
/*      */   }
/*      */ 
/*      */   public void updateBinaryStream(int paramInt, InputStream paramInputStream, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 4932 */     if (isReadOnly())
/*      */     {
/* 4934 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 4935 */       localSQLException.fillInStackTrace();
/* 4936 */       throw localSQLException;
/*      */     }
/*      */ 
/* 4939 */     this.resultSet.updateBinaryStream(paramInt, paramInputStream, paramLong);
/*      */   }
/*      */ 
/*      */   public void updateBinaryStream(String paramString, InputStream paramInputStream)
/*      */     throws SQLException
/*      */   {
/* 4954 */     if (isReadOnly())
/*      */     {
/* 4956 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 4957 */       localSQLException.fillInStackTrace();
/* 4958 */       throw localSQLException;
/*      */     }
/*      */ 
/* 4961 */     this.resultSet.updateBinaryStream(paramString, paramInputStream);
/*      */   }
/*      */ 
/*      */   public void updateBinaryStream(String paramString, InputStream paramInputStream, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 4976 */     if (isReadOnly())
/*      */     {
/* 4978 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 4979 */       localSQLException.fillInStackTrace();
/* 4980 */       throw localSQLException;
/*      */     }
/*      */ 
/* 4983 */     this.resultSet.updateBinaryStream(paramString, paramInputStream, paramLong);
/*      */   }
/*      */ 
/*      */   public void updateBlob(int paramInt, InputStream paramInputStream)
/*      */     throws SQLException
/*      */   {
/* 4998 */     if (isReadOnly())
/*      */     {
/* 5000 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 5001 */       localSQLException.fillInStackTrace();
/* 5002 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5005 */     this.resultSet.updateBlob(paramInt, paramInputStream);
/*      */   }
/*      */ 
/*      */   public void updateBlob(int paramInt, InputStream paramInputStream, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 5020 */     if (isReadOnly())
/*      */     {
/* 5022 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 5023 */       localSQLException.fillInStackTrace();
/* 5024 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5027 */     this.resultSet.updateBlob(paramInt, paramInputStream, paramLong);
/*      */   }
/*      */ 
/*      */   public void updateBlob(String paramString, InputStream paramInputStream)
/*      */     throws SQLException
/*      */   {
/* 5042 */     if (isReadOnly())
/*      */     {
/* 5044 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 5045 */       localSQLException.fillInStackTrace();
/* 5046 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5049 */     this.resultSet.updateBlob(paramString, paramInputStream);
/*      */   }
/*      */ 
/*      */   public void updateBlob(String paramString, InputStream paramInputStream, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 5064 */     if (isReadOnly())
/*      */     {
/* 5066 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 5067 */       localSQLException.fillInStackTrace();
/* 5068 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5071 */     this.resultSet.updateBlob(paramString, paramInputStream, paramLong);
/*      */   }
/*      */ 
/*      */   public void updateCharacterStream(int paramInt, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 5086 */     if (isReadOnly())
/*      */     {
/* 5088 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 5089 */       localSQLException.fillInStackTrace();
/* 5090 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5093 */     this.resultSet.updateCharacterStream(paramInt, paramReader);
/*      */   }
/*      */ 
/*      */   public void updateCharacterStream(int paramInt, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 5108 */     if (isReadOnly())
/*      */     {
/* 5110 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 5111 */       localSQLException.fillInStackTrace();
/* 5112 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5115 */     this.resultSet.updateCharacterStream(paramInt, paramReader, paramLong);
/*      */   }
/*      */ 
/*      */   public void updateCharacterStream(String paramString, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 5130 */     if (isReadOnly())
/*      */     {
/* 5132 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 5133 */       localSQLException.fillInStackTrace();
/* 5134 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5137 */     this.resultSet.updateCharacterStream(paramString, paramReader);
/*      */   }
/*      */ 
/*      */   public void updateCharacterStream(String paramString, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 5152 */     if (isReadOnly())
/*      */     {
/* 5154 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 5155 */       localSQLException.fillInStackTrace();
/* 5156 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5159 */     this.resultSet.updateCharacterStream(paramString, paramReader, paramLong);
/*      */   }
/*      */ 
/*      */   public void updateClob(int paramInt, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 5174 */     if (isReadOnly())
/*      */     {
/* 5176 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 5177 */       localSQLException.fillInStackTrace();
/* 5178 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5181 */     this.resultSet.updateClob(paramInt, paramReader);
/*      */   }
/*      */ 
/*      */   public void updateClob(int paramInt, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 5196 */     if (isReadOnly())
/*      */     {
/* 5198 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 5199 */       localSQLException.fillInStackTrace();
/* 5200 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5203 */     this.resultSet.updateClob(paramInt, paramReader, paramLong);
/*      */   }
/*      */ 
/*      */   public void updateClob(String paramString, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 5218 */     if (isReadOnly())
/*      */     {
/* 5220 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 5221 */       localSQLException.fillInStackTrace();
/* 5222 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5225 */     this.resultSet.updateClob(paramString, paramReader);
/*      */   }
/*      */ 
/*      */   public void updateClob(String paramString, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 5240 */     if (isReadOnly())
/*      */     {
/* 5242 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 5243 */       localSQLException.fillInStackTrace();
/* 5244 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5247 */     this.resultSet.updateClob(paramString, paramReader, paramLong);
/*      */   }
/*      */ 
/*      */   public void updateNCharacterStream(int paramInt, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 5262 */     if (isReadOnly())
/*      */     {
/* 5264 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 5265 */       localSQLException.fillInStackTrace();
/* 5266 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5269 */     this.resultSet.updateNCharacterStream(paramInt, paramReader);
/*      */   }
/*      */ 
/*      */   public void updateNCharacterStream(int paramInt, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 5284 */     if (isReadOnly())
/*      */     {
/* 5286 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 5287 */       localSQLException.fillInStackTrace();
/* 5288 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5291 */     this.resultSet.updateNCharacterStream(paramInt, paramReader, paramLong);
/*      */   }
/*      */ 
/*      */   public void updateNCharacterStream(String paramString, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 5306 */     if (isReadOnly())
/*      */     {
/* 5308 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 5309 */       localSQLException.fillInStackTrace();
/* 5310 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5313 */     this.resultSet.updateNCharacterStream(paramString, paramReader);
/*      */   }
/*      */ 
/*      */   public void updateNCharacterStream(String paramString, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 5328 */     if (isReadOnly())
/*      */     {
/* 5330 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 5331 */       localSQLException.fillInStackTrace();
/* 5332 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5335 */     this.resultSet.updateNCharacterStream(paramString, paramReader, paramLong);
/*      */   }
/*      */ 
/*      */   public void updateNClob(int paramInt, NClob paramNClob)
/*      */     throws SQLException
/*      */   {
/* 5350 */     if (isReadOnly())
/*      */     {
/* 5352 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 5353 */       localSQLException.fillInStackTrace();
/* 5354 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5357 */     this.resultSet.updateNClob(paramInt, paramNClob);
/*      */   }
/*      */ 
/*      */   public void updateNClob(int paramInt, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 5372 */     if (isReadOnly())
/*      */     {
/* 5374 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 5375 */       localSQLException.fillInStackTrace();
/* 5376 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5379 */     this.resultSet.updateNClob(paramInt, paramReader);
/*      */   }
/*      */ 
/*      */   public void updateNClob(int paramInt, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 5394 */     if (isReadOnly())
/*      */     {
/* 5396 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 5397 */       localSQLException.fillInStackTrace();
/* 5398 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5401 */     this.resultSet.updateNClob(paramInt, paramReader, paramLong);
/*      */   }
/*      */ 
/*      */   public void updateNClob(String paramString, NClob paramNClob)
/*      */     throws SQLException
/*      */   {
/* 5416 */     if (isReadOnly())
/*      */     {
/* 5418 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 5419 */       localSQLException.fillInStackTrace();
/* 5420 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5423 */     this.resultSet.updateNClob(paramString, paramNClob);
/*      */   }
/*      */ 
/*      */   public void updateNClob(String paramString, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 5438 */     if (isReadOnly())
/*      */     {
/* 5440 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 5441 */       localSQLException.fillInStackTrace();
/* 5442 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5445 */     this.resultSet.updateNClob(paramString, paramReader);
/*      */   }
/*      */ 
/*      */   public void updateNClob(String paramString, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 5460 */     if (isReadOnly())
/*      */     {
/* 5462 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 5463 */       localSQLException.fillInStackTrace();
/* 5464 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5467 */     this.resultSet.updateNClob(paramString, paramReader, paramLong);
/*      */   }
/*      */ 
/*      */   public void updateNString(int paramInt, String paramString)
/*      */     throws SQLException
/*      */   {
/* 5482 */     if (isReadOnly())
/*      */     {
/* 5484 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 5485 */       localSQLException.fillInStackTrace();
/* 5486 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5489 */     this.resultSet.updateNString(paramInt, paramString);
/*      */   }
/*      */ 
/*      */   public void updateNString(String paramString1, String paramString2)
/*      */     throws SQLException
/*      */   {
/* 5504 */     if (isReadOnly())
/*      */     {
/* 5506 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 5507 */       localSQLException.fillInStackTrace();
/* 5508 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5511 */     this.resultSet.updateNString(paramString1, paramString2);
/*      */   }
/*      */ 
/*      */   public void updateRowId(int paramInt, RowId paramRowId)
/*      */     throws SQLException
/*      */   {
/* 5526 */     if (isReadOnly())
/*      */     {
/* 5528 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 5529 */       localSQLException.fillInStackTrace();
/* 5530 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5533 */     this.resultSet.updateRowId(paramInt, paramRowId);
/*      */   }
/*      */ 
/*      */   public void updateRowId(String paramString, RowId paramRowId)
/*      */     throws SQLException
/*      */   {
/* 5548 */     if (isReadOnly())
/*      */     {
/* 5550 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 5551 */       localSQLException.fillInStackTrace();
/* 5552 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5555 */     this.resultSet.updateRowId(paramString, paramRowId);
/*      */   }
/*      */ 
/*      */   public void updateSQLXML(int paramInt, SQLXML paramSQLXML)
/*      */     throws SQLException
/*      */   {
/* 5570 */     if (isReadOnly())
/*      */     {
/* 5572 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 5573 */       localSQLException.fillInStackTrace();
/* 5574 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5577 */     this.resultSet.updateSQLXML(paramInt, paramSQLXML);
/*      */   }
/*      */ 
/*      */   public void updateSQLXML(String paramString, SQLXML paramSQLXML)
/*      */     throws SQLException
/*      */   {
/* 5592 */     if (isReadOnly())
/*      */     {
/* 5594 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 5595 */       localSQLException.fillInStackTrace();
/* 5596 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5599 */     this.resultSet.updateSQLXML(paramString, paramSQLXML);
/*      */   }
/*      */ 
/*      */   protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling()
/*      */   {
/*      */     try
/*      */     {
/* 5618 */       return (oracle.jdbc.internal.OracleConnection)this.connection;
/*      */     }
/*      */     catch (Exception localException) {
/*      */     }
/* 5622 */     return null;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.rowset.OracleJDBCRowSet
 * JD-Core Version:    0.6.2
 */