/*     */ package oracle.jdbc.rowset;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import javax.sql.rowset.FilteredRowSet;
/*     */ import javax.sql.rowset.Predicate;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ 
/*     */ public class OracleFilteredRowSet extends OracleWebRowSet
/*     */   implements FilteredRowSet
/*     */ {
/*     */   private Predicate predicate;
/* 269 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public OracleFilteredRowSet()
/*     */     throws SQLException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void setFilter(Predicate paramPredicate)
/*     */     throws SQLException
/*     */   {
/*  82 */     this.predicate = paramPredicate;
/*     */   }
/*     */ 
/*     */   public Predicate getFilter()
/*     */   {
/* 103 */     return this.predicate;
/*     */   }
/*     */ 
/*     */   public boolean next()
/*     */     throws SQLException
/*     */   {
/* 118 */     if (this.rowCount <= 0) {
/* 119 */       return false;
/*     */     }
/* 121 */     if (this.presentRow >= this.rowCount) {
/* 122 */       return false;
/*     */     }
/* 124 */     int i = 0;
/*     */     do
/*     */     {
/* 128 */       this.presentRow += 1;
/*     */ 
/* 130 */       if ((this.predicate == null) || ((this.predicate != null) && (this.predicate.evaluate(this))))
/*     */       {
/* 133 */         i = 1;
/* 134 */         break;
/*     */       }
/*     */     }
/* 137 */     while (this.presentRow <= this.rowCount);
/*     */ 
/* 139 */     if (i != 0)
/*     */     {
/* 141 */       notifyCursorMoved();
/* 142 */       return true;
/*     */     }
/*     */ 
/* 146 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean previous()
/*     */     throws SQLException
/*     */   {
/* 163 */     if (this.rowsetType == 1003)
/*     */     {
/* 165 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 344);
/* 166 */       localSQLException.fillInStackTrace();
/* 167 */       throw localSQLException;
/*     */     }
/*     */ 
/* 170 */     if (this.rowCount <= 0) {
/* 171 */       return false;
/*     */     }
/* 173 */     if (this.presentRow <= 1) {
/* 174 */       return false;
/*     */     }
/* 176 */     int i = 0;
/*     */     do
/*     */     {
/* 180 */       this.presentRow -= 1;
/*     */ 
/* 182 */       if ((this.predicate == null) || ((this.predicate != null) && (this.predicate.evaluate(this))))
/*     */       {
/* 185 */         i = 1;
/* 186 */         break;
/*     */       }
/*     */     }
/* 189 */     while (this.presentRow >= 1);
/*     */ 
/* 191 */     if (i != 0)
/*     */     {
/* 193 */       notifyCursorMoved();
/* 194 */       return true;
/*     */     }
/*     */ 
/* 198 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean absolute(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 216 */     if (this.rowsetType == 1003)
/*     */     {
/* 218 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 344);
/* 219 */       localSQLException.fillInStackTrace();
/* 220 */       throw localSQLException;
/*     */     }
/*     */ 
/* 223 */     if ((paramInt == 0) || (Math.abs(paramInt) > this.rowCount)) {
/* 224 */       return false;
/*     */     }
/*     */ 
/* 227 */     int i = paramInt < 0 ? this.rowCount + paramInt + 1 : paramInt;
/*     */ 
/* 229 */     int j = 0;
/* 230 */     this.presentRow = 0;
/*     */ 
/* 233 */     while ((j < i) && (this.presentRow <= this.rowCount))
/*     */     {
/* 235 */       if (next())
/* 236 */         j++;
/*     */       else {
/* 238 */         return false;
/*     */       }
/*     */     }
/* 241 */     if (j == i)
/*     */     {
/* 243 */       notifyCursorMoved();
/* 244 */       return true;
/*     */     }
/*     */ 
/* 247 */     return false;
/*     */   }
/*     */ 
/*     */   protected void checkAndFilterObject(int paramInt, Object paramObject)
/*     */     throws SQLException
/*     */   {
/* 258 */     if ((this.predicate != null) && (!this.predicate.evaluate(paramObject, paramInt)))
/*     */     {
/* 260 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 345);
/* 261 */       localSQLException.fillInStackTrace();
/* 262 */       throw localSQLException;
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.rowset.OracleFilteredRowSet
 * JD-Core Version:    0.6.2
 */