/*     */ package oracle.jdbc.rowset;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.io.Reader;
/*     */ import java.io.Serializable;
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.ResultSetMetaData;
/*     */ import java.sql.SQLException;
/*     */ import java.util.StringTokenizer;
/*     */ import javax.sql.RowSet;
/*     */ import javax.sql.RowSetInternal;
/*     */ import javax.sql.RowSetWriter;
/*     */ import oracle.jdbc.OraclePreparedStatement;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ 
/*     */ public class OracleCachedRowSetWriter
/*     */   implements RowSetWriter, Serializable
/*     */ {
/*     */   static final long serialVersionUID = 8932894189919931169L;
/*  59 */   private StringBuffer updateClause = new StringBuffer("");
/*     */ 
/*  65 */   private StringBuffer deleteClause = new StringBuffer("");
/*     */ 
/*  71 */   private StringBuffer insertClause = new StringBuffer("");
/*     */   private PreparedStatement insertStmt;
/*     */   private PreparedStatement updateStmt;
/*     */   private PreparedStatement deleteStmt;
/*     */   private ResultSetMetaData rsmd;
/*     */   private transient Connection connection;
/*     */   private int columnCount;
/*     */   static final int ASCII_STREAM = 1;
/*     */   static final int BINARY_STREAM = 2;
/*     */   static final int CHARACTER_STREAM = 3;
/*     */   static final int NCHARACTER_STREAM = 4;
/*     */   static final int ASCII_STREAM_LENGTH_UNSPECIFIED = 5;
/*     */   static final int BINARY_STREAM_LENGTH_UNSPECIFIED = 6;
/*     */   static final int CHARACTER_STREAM_LENGTH_UNSPECIFIED = 7;
/*     */   static final int NCHARACTER_STREAM_LENGTH_UNSPECIFIED = 8;
/* 662 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   private String getSchemaName(RowSet paramRowSet)
/*     */     throws SQLException
/*     */   {
/* 137 */     return paramRowSet.getUsername();
/*     */   }
/*     */ 
/*     */   private String getTableName(RowSet paramRowSet)
/*     */     throws SQLException
/*     */   {
/* 146 */     String str1 = ((OracleCachedRowSet)paramRowSet).getTableName();
/* 147 */     if (str1 != null) {
/* 148 */       return str1;
/*     */     }
/* 150 */     String str2 = paramRowSet.getCommand();
/*     */ 
/* 155 */     if (str2 == null)
/*     */     {
/* 158 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 343, "Please use RowSet.setCommand (String) to set the SQL query string.");
/* 159 */       localSQLException.fillInStackTrace();
/* 160 */       throw localSQLException;
/*     */     }
/*     */ 
/* 163 */     str2 = str2.toUpperCase();
/*     */ 
/* 167 */     int i = str2.indexOf(" FROM ");
/*     */ 
/* 171 */     if (i == -1)
/*     */     {
/* 173 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 343, str2.length() != 0 ? str2 : "Please use RowSet.setCommand (String) to set the SQL query string.");
/* 174 */       ((SQLException)localObject).fillInStackTrace();
/* 175 */       throw ((Throwable)localObject);
/*     */     }
/*     */ 
/* 181 */     Object localObject = str2.substring(i + 6).trim();
/*     */ 
/* 185 */     StringTokenizer localStringTokenizer = new StringTokenizer((String)localObject);
/* 186 */     if (localStringTokenizer.hasMoreTokens()) {
/* 187 */       localObject = localStringTokenizer.nextToken();
/*     */     }
/* 189 */     return localObject;
/*     */   }
/*     */ 
/*     */   private void initSQLStatement(RowSet paramRowSet)
/*     */     throws SQLException
/*     */   {
/* 201 */     this.insertClause = new StringBuffer("INSERT INTO " + getTableName(paramRowSet) + "(");
/* 202 */     this.updateClause = new StringBuffer("UPDATE " + getTableName(paramRowSet) + " SET ");
/* 203 */     this.deleteClause = new StringBuffer("DELETE FROM " + getTableName(paramRowSet) + " WHERE ");
/*     */ 
/* 206 */     this.rsmd = paramRowSet.getMetaData();
/* 207 */     this.columnCount = this.rsmd.getColumnCount();
/*     */ 
/* 211 */     for (int i = 0; i < this.columnCount; i++)
/*     */     {
/* 213 */       if (i != 0) this.insertClause.append(", ");
/* 214 */       this.insertClause.append(this.rsmd.getColumnName(i + 1));
/*     */ 
/* 216 */       if (i != 0) this.updateClause.append(", ");
/* 217 */       this.updateClause.append(this.rsmd.getColumnName(i + 1) + " = :" + i);
/*     */ 
/* 219 */       if (i != 0) this.deleteClause.append(" AND ");
/* 220 */       this.deleteClause.append(this.rsmd.getColumnName(i + 1) + " = :" + i);
/*     */     }
/* 222 */     this.insertClause.append(") VALUES (");
/* 223 */     this.updateClause.append(" WHERE ");
/*     */ 
/* 225 */     for (i = 0; i < this.columnCount; i++)
/*     */     {
/* 227 */       if (i != 0) this.insertClause.append(", ");
/* 228 */       this.insertClause.append(":" + i);
/*     */ 
/* 230 */       if (i != 0) this.updateClause.append(" AND ");
/* 231 */       this.updateClause.append(this.rsmd.getColumnName(i + 1) + " = :" + i);
/*     */     }
/* 233 */     this.insertClause.append(")");
/*     */ 
/* 235 */     this.insertStmt = this.connection.prepareStatement(this.insertClause.substring(0, this.insertClause.length()));
/*     */ 
/* 237 */     this.updateStmt = this.connection.prepareStatement(this.updateClause.substring(0, this.updateClause.length()));
/*     */ 
/* 239 */     this.deleteStmt = this.connection.prepareStatement(this.deleteClause.substring(0, this.deleteClause.length()));
/*     */   }
/*     */ 
/*     */   private boolean insertRow(OracleRow paramOracleRow)
/*     */     throws SQLException
/*     */   {
/* 255 */     this.insertStmt.clearParameters();
/* 256 */     for (int i = 1; i <= this.columnCount; i++)
/*     */     {
/* 258 */       Object localObject = null;
/* 259 */       localObject = paramOracleRow.isColumnChanged(i) ? paramOracleRow.getModifiedColumn(i) : paramOracleRow.getColumn(i);
/*     */ 
/* 264 */       if (localObject == null) {
/* 265 */         this.insertStmt.setNull(i, this.rsmd.getColumnType(i));
/* 266 */         paramOracleRow.markOriginalNull(i, true);
/*     */       } else {
/* 268 */         this.insertStmt.setObject(i, localObject);
/*     */       }
/*     */     }
/* 271 */     return this.insertStmt.executeUpdate() == 1;
/*     */   }
/*     */ 
/*     */   private boolean updateRow(RowSet paramRowSet, OracleRow paramOracleRow)
/*     */     throws SQLException
/*     */   {
/* 279 */     for (int i = 1; i <= this.columnCount; i++) {
/* 280 */       if (paramOracleRow.isOriginalNull(i)) {
/* 281 */         return updateRowWithNull(paramRowSet, paramOracleRow);
/*     */       }
/*     */     }
/* 284 */     return updateRowNoNulls(paramRowSet, paramOracleRow);
/*     */   }
/*     */ 
/*     */   private boolean updateRowNoNulls(RowSet paramRowSet, OracleRow paramOracleRow)
/*     */     throws SQLException
/*     */   {
/* 292 */     this.updateStmt.clearParameters();
/* 293 */     for (int i = 1; i <= this.columnCount; i++)
/*     */     {
/* 295 */       Object localObject = null;
/* 296 */       localObject = paramOracleRow.isColumnChanged(i) ? paramOracleRow.getModifiedColumn(i) : paramOracleRow.getColumn(i);
/*     */ 
/* 301 */       if (localObject == null) {
/* 302 */         this.updateStmt.setNull(i, this.rsmd.getColumnType(i));
/*     */       }
/* 305 */       else if ((localObject instanceof Reader)) {
/* 306 */         int j = 0;
/* 307 */         OraclePreparedStatement localOraclePreparedStatement = (OraclePreparedStatement)this.updateStmt;
/* 308 */         if (paramOracleRow.columnTypeInfo[(i - 1)][1] == 4L) {
/* 309 */           localOraclePreparedStatement.setFormOfUse(i, (short)2);
/* 310 */         } else if (paramOracleRow.columnTypeInfo[(i - 1)][1] == 3L) {
/* 311 */           localOraclePreparedStatement.setFormOfUse(i, (short)1);
/* 312 */         } else if (paramOracleRow.columnTypeInfo[(i - 1)][1] == 8L) {
/* 313 */           j = 1;
/* 314 */           localOraclePreparedStatement.setFormOfUse(i, (short)2);
/* 315 */         } else if (paramOracleRow.columnTypeInfo[(i - 1)][1] == 7L) {
/* 316 */           j = 1;
/* 317 */           localOraclePreparedStatement.setFormOfUse(i, (short)1);
/*     */         }
/*     */ 
/* 320 */         if (j != 0) {
/* 321 */           this.updateStmt.setCharacterStream(i, (Reader)localObject);
/*     */         }
/*     */         else {
/* 324 */           this.updateStmt.setCharacterStream(i, (Reader)localObject, paramOracleRow.columnTypeInfo[(i - 1)][0]);
/*     */         }
/*     */ 
/*     */       }
/* 329 */       else if ((localObject instanceof InputStream)) {
/* 330 */         if (paramOracleRow.columnTypeInfo[(i - 1)][1] == 2L) {
/* 331 */           this.updateStmt.setBinaryStream(i, (InputStream)localObject, paramOracleRow.columnTypeInfo[(i - 1)][0]);
/*     */         }
/* 334 */         else if (paramOracleRow.columnTypeInfo[(i - 1)][1] == 6L) {
/* 335 */           this.updateStmt.setBinaryStream(i, (InputStream)localObject);
/*     */         }
/* 337 */         else if (paramOracleRow.columnTypeInfo[(i - 1)][1] == 1L) {
/* 338 */           this.updateStmt.setAsciiStream(i, (InputStream)localObject, paramOracleRow.columnTypeInfo[(i - 1)][0]);
/*     */         }
/* 342 */         else if (paramOracleRow.columnTypeInfo[(i - 1)][1] == 5L)
/* 343 */           this.updateStmt.setAsciiStream(i, (InputStream)localObject);
/*     */       }
/*     */       else {
/* 346 */         this.updateStmt.setObject(i, localObject);
/*     */       }
/*     */     }
/* 349 */     for (i = 1; i <= this.columnCount; i++)
/*     */     {
/* 351 */       this.updateStmt.setObject(i + this.columnCount, paramOracleRow.getColumn(i));
/*     */     }
/* 353 */     return this.updateStmt.executeUpdate() == 1;
/*     */   }
/*     */ 
/*     */   private boolean updateRowWithNull(RowSet paramRowSet, OracleRow paramOracleRow)
/*     */     throws SQLException
/*     */   {
/* 362 */     boolean bool = false;
/* 363 */     StringBuffer localStringBuffer = new StringBuffer("UPDATE " + getTableName(paramRowSet) + " SET ");
/*     */ 
/* 366 */     for (int i = 1; i <= this.columnCount; i++)
/*     */     {
/* 368 */       if (i != 1) {
/* 369 */         localStringBuffer.append(", ");
/*     */       }
/* 371 */       localStringBuffer.append(this.rsmd.getColumnName(i) + " = :" + i);
/*     */     }
/*     */ 
/* 374 */     localStringBuffer.append(" WHERE ");
/*     */ 
/* 376 */     for (i = 1; i <= this.columnCount; i++)
/*     */     {
/* 378 */       if (i != 1)
/* 379 */         localStringBuffer.append(" AND ");
/* 380 */       if (paramOracleRow.isOriginalNull(i))
/* 381 */         localStringBuffer.append(this.rsmd.getColumnName(i) + " IS NULL ");
/*     */       else {
/* 383 */         localStringBuffer.append(this.rsmd.getColumnName(i) + " = :" + i);
/*     */       }
/*     */     }
/* 386 */     PreparedStatement localPreparedStatement = null;
/*     */     try
/*     */     {
/* 389 */       localPreparedStatement = this.connection.prepareStatement(localStringBuffer.substring(0, localStringBuffer.length()));
/*     */ 
/* 392 */       for (int j = 1; j <= this.columnCount; j++)
/*     */       {
/* 394 */         Object localObject1 = null;
/* 395 */         localObject1 = paramOracleRow.isColumnChanged(j) ? paramOracleRow.getModifiedColumn(j) : paramOracleRow.getColumn(j);
/*     */ 
/* 400 */         if (localObject1 == null) {
/* 401 */           localPreparedStatement.setNull(j, this.rsmd.getColumnType(j));
/*     */         }
/* 404 */         else if ((localObject1 instanceof Reader))
/*     */         {
/* 406 */           int m = 0;
/* 407 */           OraclePreparedStatement localOraclePreparedStatement = (OraclePreparedStatement)localPreparedStatement;
/* 408 */           if (paramOracleRow.columnTypeInfo[(j - 1)][1] == 4L) {
/* 409 */             localOraclePreparedStatement.setFormOfUse(j, (short)2);
/* 410 */           } else if (paramOracleRow.columnTypeInfo[(j - 1)][1] == 3L) {
/* 411 */             localOraclePreparedStatement.setFormOfUse(j, (short)1);
/* 412 */           } else if (paramOracleRow.columnTypeInfo[(j - 1)][1] == 8L) {
/* 413 */             m = 1;
/* 414 */             localOraclePreparedStatement.setFormOfUse(j, (short)2);
/*     */           }
/* 416 */           else if (paramOracleRow.columnTypeInfo[(j - 1)][1] == 7L) {
/* 417 */             m = 1;
/* 418 */             localOraclePreparedStatement.setFormOfUse(j, (short)1);
/*     */           }
/* 420 */           if (m != 0) {
/* 421 */             localPreparedStatement.setCharacterStream(j, (Reader)localObject1);
/*     */           }
/*     */           else
/*     */           {
/* 425 */             localPreparedStatement.setCharacterStream(j, (Reader)localObject1, paramOracleRow.columnTypeInfo[(j - 1)][0]);
/*     */           }
/*     */ 
/*     */         }
/* 430 */         else if ((localObject1 instanceof InputStream)) {
/* 431 */           if (paramOracleRow.columnTypeInfo[(j - 1)][1] == 2L) {
/* 432 */             localPreparedStatement.setBinaryStream(j, (InputStream)localObject1, paramOracleRow.columnTypeInfo[(j - 1)][0]);
/*     */           }
/* 435 */           else if (paramOracleRow.columnTypeInfo[(j - 1)][1] == 6L) {
/* 436 */             localPreparedStatement.setBinaryStream(j, (InputStream)localObject1);
/*     */           }
/* 438 */           else if (paramOracleRow.columnTypeInfo[(j - 1)][1] == 1L) {
/* 439 */             localPreparedStatement.setAsciiStream(j, (InputStream)localObject1, paramOracleRow.columnTypeInfo[(j - 1)][0]);
/*     */           }
/* 442 */           else if (paramOracleRow.columnTypeInfo[(j - 1)][1] == 5L) {
/* 443 */             localPreparedStatement.setAsciiStream(j, (InputStream)localObject1);
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 448 */           localPreparedStatement.setObject(j, localObject1);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 453 */       j = 1; for (int k = 1; j <= this.columnCount; j++)
/*     */       {
/* 455 */         if (!paramOracleRow.isOriginalNull(j))
/*     */         {
/* 458 */           localPreparedStatement.setObject(k + this.columnCount, paramOracleRow.getColumn(j));
/*     */ 
/* 460 */           k++;
/*     */         }
/*     */       }
/* 462 */       bool = localPreparedStatement.executeUpdate() == 1;
/*     */     }
/*     */     finally {
/* 465 */       if (localPreparedStatement != null) {
/* 466 */         localPreparedStatement.close();
/*     */       }
/*     */     }
/* 469 */     return bool;
/*     */   }
/*     */ 
/*     */   private boolean deleteRow(RowSet paramRowSet, OracleRow paramOracleRow)
/*     */     throws SQLException
/*     */   {
/* 482 */     this.deleteStmt.clearParameters();
/* 483 */     for (int i = 1; i <= this.columnCount; i++)
/*     */     {
/* 485 */       if (paramOracleRow.isOriginalNull(i)) {
/* 486 */         return deleteRowWithNull(paramRowSet, paramOracleRow);
/*     */       }
/* 488 */       Object localObject = paramOracleRow.getColumn(i);
/* 489 */       if (localObject == null)
/* 490 */         this.deleteStmt.setNull(i, this.rsmd.getColumnType(i));
/*     */       else {
/* 492 */         this.deleteStmt.setObject(i, localObject);
/*     */       }
/*     */     }
/* 495 */     return this.deleteStmt.executeUpdate() == 1;
/*     */   }
/*     */ 
/*     */   private boolean deleteRowWithNull(RowSet paramRowSet, OracleRow paramOracleRow)
/*     */     throws SQLException
/*     */   {
/* 505 */     boolean bool = false;
/* 506 */     StringBuffer localStringBuffer = new StringBuffer("DELETE FROM " + getTableName(paramRowSet) + " WHERE ");
/*     */ 
/* 509 */     for (int i = 1; i <= this.columnCount; i++)
/*     */     {
/* 511 */       if (i != 1)
/* 512 */         localStringBuffer.append(" AND ");
/* 513 */       if (paramOracleRow.isOriginalNull(i))
/* 514 */         localStringBuffer.append(this.rsmd.getColumnName(i) + " IS NULL ");
/*     */       else {
/* 516 */         localStringBuffer.append(this.rsmd.getColumnName(i) + " = :" + i);
/*     */       }
/*     */     }
/* 519 */     PreparedStatement localPreparedStatement = null;
/*     */     try
/*     */     {
/* 522 */       localPreparedStatement = this.connection.prepareStatement(localStringBuffer.substring(0, localStringBuffer.length()));
/*     */ 
/* 526 */       int j = 1; for (int k = 1; j <= this.columnCount; j++)
/*     */       {
/* 528 */         if (!paramOracleRow.isOriginalNull(j))
/*     */         {
/* 531 */           localPreparedStatement.setObject(k++, paramOracleRow.getColumn(j));
/*     */         }
/*     */       }
/* 533 */       bool = localPreparedStatement.executeUpdate() == 1;
/*     */     }
/*     */     finally {
/* 536 */       if (localPreparedStatement != null) {
/* 537 */         localPreparedStatement.close();
/*     */       }
/*     */     }
/* 540 */     return bool;
/*     */   }
/*     */ 
/*     */   public synchronized boolean writeData(RowSetInternal paramRowSetInternal)
/*     */     throws SQLException
/*     */   {
/* 554 */     OracleCachedRowSet localOracleCachedRowSet = (OracleCachedRowSet)paramRowSetInternal;
/* 555 */     this.connection = ((OracleCachedRowSetReader)localOracleCachedRowSet.getReader()).getConnection(paramRowSetInternal);
/*     */ 
/* 560 */     if (this.connection == null)
/*     */     {
/* 562 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 342);
/* 563 */       localSQLException.fillInStackTrace();
/* 564 */       throw localSQLException;
/*     */     }
/*     */ 
/* 567 */     if (this.connection.getAutoCommit()) {
/* 568 */       this.connection.setAutoCommit(false);
/*     */     }
/*     */     try
/*     */     {
/* 572 */       this.connection.setTransactionIsolation(localOracleCachedRowSet.getTransactionIsolation());
/*     */     }
/*     */     catch (Exception localException)
/*     */     {
/*     */     }
/*     */ 
/* 579 */     initSQLStatement(localOracleCachedRowSet);
/* 580 */     if (this.columnCount < 1)
/*     */     {
/* 582 */       this.connection.close();
/* 583 */       return true;
/*     */     }
/* 585 */     boolean bool = localOracleCachedRowSet.getShowDeleted();
/* 586 */     localOracleCachedRowSet.setShowDeleted(true);
/* 587 */     localOracleCachedRowSet.beforeFirst();
/* 588 */     int i = 1;
/* 589 */     int j = 1;
/* 590 */     int k = 1;
/* 591 */     OracleRow localOracleRow = null;
/* 592 */     while (localOracleCachedRowSet.next())
/*     */     {
/* 594 */       if (localOracleCachedRowSet.rowInserted())
/*     */       {
/* 597 */         if (!localOracleCachedRowSet.rowDeleted())
/*     */         {
/* 599 */           localOracleRow = localOracleCachedRowSet.getCurrentRow();
/*     */ 
/* 601 */           j = (insertRow(localOracleRow)) || (j != 0) ? 1 : 0;
/*     */         }
/* 603 */       } else if (localOracleCachedRowSet.rowUpdated())
/*     */       {
/* 605 */         localOracleRow = localOracleCachedRowSet.getCurrentRow();
/*     */ 
/* 607 */         i = (updateRow(localOracleCachedRowSet, localOracleRow)) || (i != 0) ? 1 : 0;
/*     */       }
/* 609 */       else if (localOracleCachedRowSet.rowDeleted())
/*     */       {
/* 611 */         localOracleRow = localOracleCachedRowSet.getCurrentRow();
/*     */ 
/* 613 */         k = (deleteRow(localOracleCachedRowSet, localOracleRow)) || (k != 0) ? 1 : 0;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 620 */     if ((i != 0) && (j != 0) && (k != 0))
/*     */     {
/* 623 */       this.connection.commit();
/*     */ 
/* 625 */       localOracleCachedRowSet.setOriginal();
/*     */     }
/*     */     else {
/* 628 */       this.connection.rollback();
/*     */     }
/* 630 */     this.insertStmt.close();
/* 631 */     this.updateStmt.close();
/* 632 */     this.deleteStmt.close();
/*     */ 
/* 636 */     if (!localOracleCachedRowSet.isConnectionStayingOpen())
/*     */     {
/* 638 */       this.connection.close();
/*     */     }
/*     */ 
/* 641 */     localOracleCachedRowSet.setShowDeleted(bool);
/* 642 */     return true;
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 657 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.rowset.OracleCachedRowSetWriter
 * JD-Core Version:    0.6.2
 */