/*     */ package oracle.jdbc.rowset;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.io.Reader;
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Array;
/*     */ import java.sql.Connection;
/*     */ import java.sql.Date;
/*     */ import java.sql.DriverManager;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Time;
/*     */ import java.sql.Timestamp;
/*     */ import java.util.Calendar;
/*     */ import java.util.Properties;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import javax.sql.DataSource;
/*     */ import javax.sql.RowSet;
/*     */ import javax.sql.RowSetInternal;
/*     */ import javax.sql.RowSetReader;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.driver.OracleDriver;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ 
/*     */ public class OracleCachedRowSetReader
/*     */   implements RowSetReader, Serializable
/*     */ {
/*     */   static final long serialVersionUID = -3565405169674271176L;
/*     */   static final transient int SETUNICODESTREAM_INTLENGTH = 1;
/*     */   static final transient int SETBINARYSTREAM_INTLENGTH = 2;
/*     */   static final transient int SETASCIISTREAM_INTLENGTH = 3;
/*     */   static final transient int SETCHARACTERSTREAM_INTLENGTH = 4;
/*     */   static final transient int SETBINARYSTREAM = 5;
/*     */   static final transient int SETBINARYSTREAM_LONGLENGTH = 6;
/*     */   static final transient int SETASCIISTREAM = 7;
/*     */   static final transient int SETASCIISTREAM_LONGLENGTH = 8;
/*     */   static final transient int SETCHARACTERSTREAM = 9;
/*     */   static final transient int SETCHARACTERSTREAM_LONGLENGTH = 10;
/*     */   static final transient int SETNCHARACTERSTREAM = 11;
/*     */   static final transient int SETNCHARACTERSTREAM_LONGLENGTH = 12;
/*     */   static final transient int SETBLOB_STREAM = 13;
/*     */   static final transient int SETBLOB_STREAM_LONG = 14;
/*     */   static final transient int SETCLOB_READER = 15;
/*     */   static final transient int SETCLOB_READER_LONG = 16;
/*     */   static final transient int SETNCLOB_READER = 17;
/*     */   static final transient int SETNCLOB_READER_LONG = 18;
/*     */   static final transient int TWO_PARAMETERS = 2;
/*     */   static final transient int THREE_PARAMETERS = 3;
/* 164 */   private static transient boolean driverManagerInitialized = false;
/*     */ 
/* 624 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   Connection getConnection(RowSetInternal paramRowSetInternal)
/*     */     throws SQLException
/*     */   {
/* 186 */     Object localObject1 = null;
/*     */ 
/* 193 */     Connection localConnection = paramRowSetInternal.getConnection();
/* 194 */     if ((localConnection != null) && (!localConnection.isClosed()))
/*     */     {
/* 196 */       localObject1 = localConnection;
/*     */     }
/*     */     else
/*     */     {
/*     */       Object localObject2;
/*     */       String str2;
/*     */       Object localObject3;
/* 198 */       if (((RowSet)paramRowSetInternal).getDataSourceName() != null)
/*     */       {
/*     */         try
/*     */         {
/* 202 */           InitialContext localInitialContext = null;
/*     */           try
/*     */           {
/* 208 */             Properties localProperties = System.getProperties();
/* 209 */             localInitialContext = new InitialContext(localProperties);
/*     */           }
/*     */           catch (SecurityException localSecurityException) {
/*     */           }
/* 213 */           if (localInitialContext == null)
/* 214 */             localInitialContext = new InitialContext();
/* 215 */           localObject2 = (DataSource)localInitialContext.lookup(((RowSet)paramRowSetInternal).getDataSourceName());
/*     */ 
/* 220 */           str2 = ((RowSet)paramRowSetInternal).getUsername();
/* 221 */           localObject3 = ((RowSet)paramRowSetInternal).getPassword();
/* 222 */           if ((str2 == null) && (localObject3 == null))
/*     */           {
/* 224 */             localObject1 = ((DataSource)localObject2).getConnection();
/*     */           }
/*     */           else
/*     */           {
/* 228 */             localObject1 = ((DataSource)localObject2).getConnection(str2, (String)localObject3);
/*     */           }
/*     */ 
/*     */         }
/*     */         catch (NamingException localNamingException)
/*     */         {
/* 234 */           localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 300, localNamingException.getMessage());
/* 235 */           ((SQLException)localObject2).fillInStackTrace();
/* 236 */           throw ((Throwable)localObject2);
/*     */         }
/*     */ 
/*     */       }
/* 240 */       else if (((RowSet)paramRowSetInternal).getUrl() != null)
/*     */       {
/* 242 */         if (!driverManagerInitialized)
/*     */         {
/* 244 */           DriverManager.registerDriver(new OracleDriver());
/* 245 */           driverManagerInitialized = true;
/*     */         }
/* 247 */         String str1 = ((RowSet)paramRowSetInternal).getUrl();
/* 248 */         localObject2 = ((RowSet)paramRowSetInternal).getUsername();
/* 249 */         str2 = ((RowSet)paramRowSetInternal).getPassword();
/*     */ 
/* 253 */         if ((str1.equals("")) || (((String)localObject2).equals("")) || (str2.equals("")))
/*     */         {
/* 256 */           localObject3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 301);
/* 257 */           ((SQLException)localObject3).fillInStackTrace();
/* 258 */           throw ((Throwable)localObject3);
/*     */         }
/*     */ 
/* 261 */         localObject1 = DriverManager.getConnection(str1, (String)localObject2, str2);
/*     */       }
/*     */     }
/* 264 */     return localObject1;
/*     */   }
/*     */ 
/*     */   private void setParams(Object[] paramArrayOfObject, PreparedStatement paramPreparedStatement)
/*     */     throws SQLException
/*     */   {
/* 277 */     for (int i = 0; i < paramArrayOfObject.length; i++)
/*     */     {
/* 279 */       int j = 0;
/*     */ 
/* 284 */       if ((paramArrayOfObject[i] instanceof byte[]))
/*     */       {
/* 286 */         paramPreparedStatement.setObject(i + 1, paramArrayOfObject[i]);
/*     */       }
/*     */       else
/*     */       {
/*     */         try
/*     */         {
/* 296 */           j = Array.getLength(paramArrayOfObject[i]);
/*     */         }
/*     */         catch (IllegalArgumentException localIllegalArgumentException)
/*     */         {
/* 300 */           paramPreparedStatement.setObject(i + 1, paramArrayOfObject[i]);
/* 301 */           continue;
/*     */         }
/*     */ 
/* 304 */         Object[] arrayOfObject = (Object[])paramArrayOfObject[i];
/*     */         SQLException localSQLException;
/* 308 */         if (j == 2)
/*     */         {
/* 310 */           if (arrayOfObject[0] == null) {
/* 311 */             paramPreparedStatement.setNull(i + 1, ((Integer)arrayOfObject[1]).intValue());
/*     */           }
/* 313 */           else if ((arrayOfObject[0] instanceof Date))
/*     */           {
/* 315 */             if ((arrayOfObject[1] instanceof Calendar))
/*     */             {
/* 317 */               paramPreparedStatement.setDate(i + 1, (Date)arrayOfObject[0], (Calendar)arrayOfObject[1]);
/*     */             }
/*     */             else
/*     */             {
/* 323 */               localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 323);
/* 324 */               localSQLException.fillInStackTrace();
/* 325 */               throw localSQLException;
/*     */             }
/*     */ 
/*     */           }
/* 329 */           else if ((arrayOfObject[0] instanceof Time))
/*     */           {
/* 331 */             if ((arrayOfObject[1] instanceof Calendar))
/*     */             {
/* 333 */               paramPreparedStatement.setTime(i + 1, (Time)arrayOfObject[0], (Calendar)arrayOfObject[1]);
/*     */             }
/*     */             else
/*     */             {
/* 339 */               localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 323);
/* 340 */               localSQLException.fillInStackTrace();
/* 341 */               throw localSQLException;
/*     */             }
/*     */ 
/*     */           }
/* 345 */           else if ((arrayOfObject[0] instanceof Timestamp))
/*     */           {
/* 347 */             if ((arrayOfObject[1] instanceof Calendar))
/*     */             {
/* 349 */               paramPreparedStatement.setTimestamp(i + 1, (Timestamp)arrayOfObject[0], (Calendar)arrayOfObject[1]);
/*     */             }
/*     */             else
/*     */             {
/* 355 */               localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 323);
/* 356 */               localSQLException.fillInStackTrace();
/* 357 */               throw localSQLException;
/*     */             }
/*     */ 
/*     */           }
/* 363 */           else if ((arrayOfObject[0] instanceof Reader))
/*     */           {
/* 365 */             switch (((Integer)arrayOfObject[1]).intValue())
/*     */             {
/*     */             case 9:
/* 368 */               paramPreparedStatement.setCharacterStream(i + 1, (Reader)arrayOfObject[0]);
/*     */ 
/* 370 */               break;
/*     */             case 11:
/* 373 */               paramPreparedStatement.setNCharacterStream(i + 1, (Reader)arrayOfObject[0]);
/*     */ 
/* 375 */               break;
/*     */             case 15:
/* 378 */               paramPreparedStatement.setClob(i + 1, (Reader)arrayOfObject[0]);
/* 379 */               break;
/*     */             case 17:
/* 382 */               paramPreparedStatement.setNClob(i + 1, (Reader)arrayOfObject[0]);
/* 383 */               break;
/*     */             case 10:
/*     */             case 12:
/*     */             case 13:
/*     */             case 14:
/*     */             case 16:
/*     */             default:
/* 387 */               localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 323);
/* 388 */               localSQLException.fillInStackTrace();
/* 389 */               throw localSQLException;
/*     */             }
/*     */ 
/*     */           }
/* 393 */           else if ((arrayOfObject[0] instanceof InputStream))
/*     */           {
/* 395 */             switch (((Integer)arrayOfObject[1]).intValue())
/*     */             {
/*     */             case 7:
/* 398 */               paramPreparedStatement.setAsciiStream(i + 1, (InputStream)arrayOfObject[0]);
/*     */ 
/* 400 */               break;
/*     */             case 5:
/* 403 */               paramPreparedStatement.setBinaryStream(i + 1, (InputStream)arrayOfObject[0]);
/*     */ 
/* 405 */               break;
/*     */             case 13:
/* 408 */               paramPreparedStatement.setBlob(i + 1, (InputStream)arrayOfObject[0]);
/* 409 */               break;
/*     */             default:
/* 413 */               localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 323);
/* 414 */               localSQLException.fillInStackTrace();
/* 415 */               throw localSQLException;
/*     */             }
/*     */ 
/*     */           }
/* 420 */           else if ((arrayOfObject[1] instanceof Integer)) {
/* 421 */             paramPreparedStatement.setObject(i + 1, arrayOfObject[0], ((Integer)arrayOfObject[1]).intValue());
/*     */           }
/*     */ 
/*     */         }
/* 426 */         else if (j == 3)
/*     */         {
/* 428 */           if (arrayOfObject[0] == null)
/*     */           {
/* 430 */             paramPreparedStatement.setNull(i + 1, ((Integer)arrayOfObject[1]).intValue(), (String)arrayOfObject[2]);
/*     */           }
/* 434 */           else if ((arrayOfObject[0] instanceof Reader))
/*     */           {
/* 436 */             switch (((Integer)arrayOfObject[2]).intValue())
/*     */             {
/*     */             case 4:
/* 439 */               paramPreparedStatement.setCharacterStream(i + 1, (Reader)arrayOfObject[0], ((Integer)arrayOfObject[1]).intValue());
/*     */ 
/* 442 */               break;
/*     */             case 10:
/* 445 */               paramPreparedStatement.setCharacterStream(i + 1, (Reader)arrayOfObject[0], ((Long)arrayOfObject[1]).longValue());
/*     */ 
/* 448 */               break;
/*     */             case 12:
/* 451 */               paramPreparedStatement.setNCharacterStream(i + 1, (Reader)arrayOfObject[0], ((Long)arrayOfObject[1]).longValue());
/*     */ 
/* 454 */               break;
/*     */             case 16:
/* 457 */               paramPreparedStatement.setClob(i + 1, (Reader)arrayOfObject[0], ((Long)arrayOfObject[1]).longValue());
/*     */ 
/* 460 */               break;
/*     */             case 18:
/* 463 */               paramPreparedStatement.setNClob(i + 1, (Reader)arrayOfObject[0], ((Long)arrayOfObject[1]).longValue());
/*     */ 
/* 466 */               break;
/*     */             case 5:
/*     */             case 6:
/*     */             case 7:
/*     */             case 8:
/*     */             case 9:
/*     */             case 11:
/*     */             case 13:
/*     */             case 14:
/*     */             case 15:
/*     */             case 17:
/*     */             default:
/* 470 */               localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 323);
/* 471 */               localSQLException.fillInStackTrace();
/* 472 */               throw localSQLException;
/*     */             }
/*     */ 
/*     */           }
/* 476 */           else if ((arrayOfObject[0] instanceof InputStream)) {
/* 477 */             switch (((Integer)arrayOfObject[2]).intValue())
/*     */             {
/*     */             case 1:
/* 480 */               paramPreparedStatement.setUnicodeStream(i + 1, (InputStream)arrayOfObject[0], ((Integer)arrayOfObject[1]).intValue());
/*     */ 
/* 483 */               break;
/*     */             case 2:
/* 486 */               paramPreparedStatement.setBinaryStream(i + 1, (InputStream)arrayOfObject[0], ((Integer)arrayOfObject[1]).intValue());
/*     */ 
/* 489 */               break;
/*     */             case 3:
/* 492 */               paramPreparedStatement.setAsciiStream(i + 1, (InputStream)arrayOfObject[0], ((Integer)arrayOfObject[1]).intValue());
/*     */ 
/* 495 */               break;
/*     */             case 6:
/* 498 */               paramPreparedStatement.setBinaryStream(i + 1, (InputStream)arrayOfObject[0], ((Long)arrayOfObject[1]).longValue());
/*     */ 
/* 501 */               break;
/*     */             case 8:
/* 504 */               paramPreparedStatement.setAsciiStream(i + 1, (InputStream)arrayOfObject[0], ((Long)arrayOfObject[1]).longValue());
/*     */ 
/* 507 */               break;
/*     */             case 14:
/* 510 */               paramPreparedStatement.setBlob(i + 1, (InputStream)arrayOfObject[0], ((Long)arrayOfObject[1]).longValue());
/*     */ 
/* 513 */               break;
/*     */             case 4:
/*     */             case 5:
/*     */             case 7:
/*     */             case 9:
/*     */             case 10:
/*     */             case 11:
/*     */             case 12:
/*     */             case 13:
/*     */             default:
/* 517 */               localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 323);
/* 518 */               localSQLException.fillInStackTrace();
/* 519 */               throw localSQLException;
/*     */             }
/*     */           }
/* 522 */           else if (((arrayOfObject[1] instanceof Integer)) && ((arrayOfObject[2] instanceof Integer)))
/*     */           {
/* 525 */             paramPreparedStatement.setObject(i + 1, arrayOfObject[0], ((Integer)arrayOfObject[1]).intValue(), ((Integer)arrayOfObject[2]).intValue());
/*     */           }
/*     */           else
/*     */           {
/* 531 */             localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 323);
/* 532 */             localSQLException.fillInStackTrace();
/* 533 */             throw localSQLException;
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void readData(RowSetInternal paramRowSetInternal)
/*     */     throws SQLException
/*     */   {
/* 554 */     OracleCachedRowSet localOracleCachedRowSet = (OracleCachedRowSet)paramRowSetInternal;
/*     */ 
/* 556 */     Connection localConnection = getConnection(paramRowSetInternal);
/*     */ 
/* 560 */     if ((localConnection == null) || (localOracleCachedRowSet.getCommand() == null))
/*     */     {
/* 562 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 342);
/* 563 */       localSQLException1.fillInStackTrace();
/* 564 */       throw localSQLException1;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 569 */       localConnection.setTransactionIsolation(localOracleCachedRowSet.getTransactionIsolation());
/*     */     }
/*     */     catch (Exception localException1)
/*     */     {
/*     */     }
/* 574 */     PreparedStatement localPreparedStatement = localConnection.prepareStatement(localOracleCachedRowSet.getCommand(), localOracleCachedRowSet.getType(), localOracleCachedRowSet.getConcurrency());
/*     */ 
/* 579 */     setParams(paramRowSetInternal.getParams(), localPreparedStatement);
/*     */     try
/*     */     {
/* 582 */       localPreparedStatement.setMaxRows(localOracleCachedRowSet.getMaxRows());
/* 583 */       localPreparedStatement.setMaxFieldSize(localOracleCachedRowSet.getMaxFieldSize());
/* 584 */       localPreparedStatement.setEscapeProcessing(localOracleCachedRowSet.getEscapeProcessing());
/* 585 */       localPreparedStatement.setQueryTimeout(localOracleCachedRowSet.getQueryTimeout());
/*     */     } catch (Exception localException2) {
/*     */     }
/* 588 */     ResultSet localResultSet = localPreparedStatement.executeQuery();
/* 589 */     localOracleCachedRowSet.populate(localResultSet, localOracleCachedRowSet.getCurrentPage() * localOracleCachedRowSet.getPageSize());
/* 590 */     localResultSet.close();
/* 591 */     localPreparedStatement.close();
/*     */     try
/*     */     {
/* 594 */       if (!localConnection.getAutoCommit())
/* 595 */         localConnection.commit();
/*     */     }
/*     */     catch (SQLException localSQLException2)
/*     */     {
/*     */     }
/* 600 */     if (!localOracleCachedRowSet.isConnectionStayingOpen())
/*     */     {
/* 602 */       localConnection.close();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 619 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.rowset.OracleCachedRowSetReader
 * JD-Core Version:    0.6.2
 */