/*      */ package oracle.jdbc.rowset;
/*      */ 
/*      */ import java.io.BufferedReader;
/*      */ import java.io.ByteArrayInputStream;
/*      */ import java.io.ByteArrayOutputStream;
/*      */ import java.io.CharArrayReader;
/*      */ import java.io.IOException;
/*      */ import java.io.InputStream;
/*      */ import java.io.PipedInputStream;
/*      */ import java.io.PipedOutputStream;
/*      */ import java.io.Reader;
/*      */ import java.io.Serializable;
/*      */ import java.io.StringBufferInputStream;
/*      */ import java.math.BigDecimal;
/*      */ import java.math.BigInteger;
/*      */ import java.net.MalformedURLException;
/*      */ import java.net.URL;
/*      */ import java.sql.Array;
/*      */ import java.sql.Blob;
/*      */ import java.sql.Clob;
/*      */ import java.sql.Connection;
/*      */ import java.sql.DatabaseMetaData;
/*      */ import java.sql.DriverManager;
/*      */ import java.sql.NClob;
/*      */ import java.sql.Ref;
/*      */ import java.sql.ResultSet;
/*      */ import java.sql.ResultSetMetaData;
/*      */ import java.sql.RowId;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.SQLWarning;
/*      */ import java.sql.SQLXML;
/*      */ import java.sql.Savepoint;
/*      */ import java.sql.Statement;
/*      */ import java.sql.Time;
/*      */ import java.sql.Timestamp;
/*      */ import java.util.Calendar;
/*      */ import java.util.Collection;
/*      */ import java.util.Collections;
/*      */ import java.util.Iterator;
/*      */ import java.util.Map;
/*      */ import java.util.Properties;
/*      */ import java.util.TimeZone;
/*      */ import java.util.TreeMap;
/*      */ import java.util.Vector;
/*      */ import javax.naming.InitialContext;
/*      */ import javax.naming.NamingException;
/*      */ import javax.sql.DataSource;
/*      */ import javax.sql.RowSet;
/*      */ import javax.sql.RowSetEvent;
/*      */ import javax.sql.RowSetInternal;
/*      */ import javax.sql.RowSetMetaData;
/*      */ import javax.sql.RowSetReader;
/*      */ import javax.sql.RowSetWriter;
/*      */ import javax.sql.rowset.CachedRowSet;
/*      */ import javax.sql.rowset.RowSetWarning;
/*      */ import javax.sql.rowset.spi.SyncFactory;
/*      */ import javax.sql.rowset.spi.SyncFactoryException;
/*      */ import javax.sql.rowset.spi.SyncProvider;
/*      */ import javax.sql.rowset.spi.SyncProviderException;
/*      */ import oracle.jdbc.OracleConnection;
/*      */ import oracle.jdbc.OracleSavepoint;
/*      */ import oracle.jdbc.driver.DBConversion;
/*      */ import oracle.jdbc.driver.DatabaseError;
/*      */ import oracle.jdbc.driver.OracleDriver;
/*      */ import oracle.sql.BLOB;
/*      */ import oracle.sql.CLOB;
/*      */ import oracle.sql.ROWID;
/*      */ import oracle.sql.TIMESTAMP;
/*      */ import oracle.sql.TIMESTAMPLTZ;
/*      */ import oracle.sql.TIMESTAMPTZ;
/*      */ 
/*      */ public class OracleCachedRowSet extends OracleRowSet
/*      */   implements RowSet, RowSetInternal, Serializable, Cloneable, CachedRowSet
/*      */ {
/*      */   static final long serialVersionUID = -2066958142885801470L;
/*      */   private SQLWarning sqlWarning;
/*      */   private RowSetWarning rowsetWarning;
/*      */   protected int presentRow;
/*      */   private int currentPage;
/*      */   private boolean isPopulateDone;
/*      */   private boolean previousColumnWasNull;
/*      */   private OracleRow insertRow;
/*      */   private int insertRowPosition;
/*      */   private boolean insertRowFlag;
/*      */   private int updateRowPosition;
/*      */   private boolean updateRowFlag;
/*      */   protected ResultSetMetaData rowsetMetaData;
/*      */   private transient ResultSet resultSet;
/*      */   private transient Connection connection;
/*  310 */   private transient boolean isConnectionStayingOpenForTxnControl = false;
/*      */ 
/*  315 */   private transient OracleSqlForRowSet osql = null;
/*      */   protected Vector rows;
/*      */   private Vector param;
/*      */   private String[] metaData;
/*      */   protected int colCount;
/*      */   protected int rowCount;
/*      */   private RowSetReader reader;
/*      */   private RowSetWriter writer;
/*      */   private int[] keyColumns;
/*      */   private int pageSize;
/*      */   private SyncProvider syncProvider;
/*      */   private static final String DEFAULT_SYNCPROVIDER = "com.sun.rowset.providers.RIOptimisticProvider";
/*      */   private String tableName;
/*  399 */   private boolean executeCalled = false;
/*      */ 
/*  401 */   private boolean driverManagerInitialized = false;
/*      */   private static final int MAX_CHAR_BUFFER_SIZE = 1024;
/*      */   private static final int MAX_BYTE_BUFFER_SIZE = 1024;
/* 9204 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   public OracleCachedRowSet()
/*      */     throws SQLException
/*      */   {
/*  430 */     this.insertRowFlag = false;
/*  431 */     this.updateRowFlag = false;
/*      */ 
/*  433 */     this.presentRow = 0;
/*  434 */     this.previousColumnWasNull = false;
/*      */ 
/*  436 */     this.param = new Vector();
/*      */ 
/*  438 */     this.rows = new Vector();
/*      */ 
/*  440 */     this.sqlWarning = new SQLWarning();
/*      */     try
/*      */     {
/*  446 */       this.syncProvider = SyncFactory.getInstance("com.sun.rowset.providers.RIOptimisticProvider");
/*      */     }
/*      */     catch (SyncFactoryException localSyncFactoryException)
/*      */     {
/*  454 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 304);
/*  455 */       localSQLException.fillInStackTrace();
/*  456 */       throw localSQLException;
/*      */     }
/*      */ 
/*  461 */     setReader(new OracleCachedRowSetReader());
/*  462 */     setWriter(new OracleCachedRowSetWriter());
/*      */ 
/*  464 */     this.currentPage = 0;
/*  465 */     this.pageSize = 0;
/*  466 */     this.isPopulateDone = false;
/*      */ 
/*  468 */     this.keyColumns = null;
/*  469 */     this.tableName = null;
/*      */   }
/*      */ 
/*      */   public Connection getConnection()
/*      */     throws SQLException
/*      */   {
/*  489 */     return getConnectionInternal();
/*      */   }
/*      */ 
/*      */   Connection getConnectionInternal()
/*      */     throws SQLException
/*      */   {
/*  498 */     if ((this.connection == null) || (this.connection.isClosed()))
/*      */     {
/*  500 */       String str1 = getUsername();
/*  501 */       String str2 = getPassword();
/*      */       Object localObject2;
/*  502 */       if (getDataSourceName() != null)
/*      */       {
/*      */         try
/*      */         {
/*  506 */           InitialContext localInitialContext = null;
/*      */           try
/*      */           {
/*  512 */             Properties localProperties = System.getProperties();
/*  513 */             localInitialContext = new InitialContext(localProperties);
/*      */           }
/*      */           catch (SecurityException localSecurityException)
/*      */           {
/*      */           }
/*  518 */           if (localInitialContext == null)
/*  519 */             localInitialContext = new InitialContext();
/*  520 */           localObject2 = (DataSource)localInitialContext.lookup(getDataSourceName());
/*      */ 
/*  525 */           if ((this.username == null) || (str2 == null))
/*  526 */             this.connection = ((DataSource)localObject2).getConnection();
/*      */           else {
/*  528 */             this.connection = ((DataSource)localObject2).getConnection(this.username, str2);
/*      */           }
/*      */         }
/*      */         catch (NamingException localNamingException)
/*      */         {
/*  533 */           localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 300, localNamingException.getMessage());
/*  534 */           ((SQLException)localObject2).fillInStackTrace();
/*  535 */           throw ((Throwable)localObject2);
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*      */         Object localObject1;
/*  539 */         if (getUrl() != null)
/*      */         {
/*  541 */           if (!this.driverManagerInitialized)
/*      */           {
/*  543 */             DriverManager.registerDriver(new OracleDriver());
/*  544 */             this.driverManagerInitialized = true;
/*      */           }
/*  546 */           localObject1 = getUrl();
/*      */ 
/*  555 */           if ((((String)localObject1).equals("")) || (str1 == null) || (str1.equals("")) || (str2 == null) || (str2.equals("")))
/*      */           {
/*  559 */             localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 301);
/*  560 */             ((SQLException)localObject2).fillInStackTrace();
/*  561 */             throw ((Throwable)localObject2);
/*      */           }
/*      */ 
/*  564 */           this.connection = DriverManager.getConnection((String)localObject1, str1, str2);
/*      */         }
/*      */         else
/*      */         {
/*  569 */           localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 301);
/*  570 */           ((SQLException)localObject1).fillInStackTrace();
/*  571 */           throw ((Throwable)localObject1);
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  576 */     return this.connection;
/*      */   }
/*      */ 
/*      */   public Statement getStatement()
/*      */     throws SQLException
/*      */   {
/*  592 */     if (this.resultSet == null)
/*      */     {
/*  596 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 305);
/*  597 */       localSQLException.fillInStackTrace();
/*  598 */       throw localSQLException;
/*      */     }
/*      */ 
/*  602 */     return this.resultSet.getStatement();
/*      */   }
/*      */ 
/*      */   public RowSetReader getReader()
/*      */   {
/*  615 */     return this.reader;
/*      */   }
/*      */ 
/*      */   public RowSetWriter getWriter()
/*      */   {
/*  628 */     return this.writer;
/*      */   }
/*      */ 
/*      */   public void setFetchDirection(int paramInt)
/*      */     throws SQLException
/*      */   {
/*      */     SQLException localSQLException;
/*  666 */     if (this.rowsetType == 1005)
/*      */     {
/*  668 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 306);
/*  669 */       localSQLException.fillInStackTrace();
/*  670 */       throw localSQLException;
/*      */     }
/*      */ 
/*  673 */     switch (paramInt)
/*      */     {
/*      */     case 1000:
/*      */     case 1002:
/*  677 */       this.presentRow = 0;
/*  678 */       break;
/*      */     case 1001:
/*  680 */       if (this.rowsetType == 1003)
/*      */       {
/*  682 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 307);
/*  683 */         localSQLException.fillInStackTrace();
/*  684 */         throw localSQLException;
/*      */       }
/*  686 */       this.presentRow = (this.rowCount + 1);
/*  687 */       break;
/*      */     default:
/*  690 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 308);
/*  691 */       localSQLException.fillInStackTrace();
/*  692 */       throw localSQLException;
/*      */     }
/*      */ 
/*  697 */     super.setFetchDirection(paramInt);
/*      */   }
/*      */ 
/*      */   public void setCommand(String paramString)
/*      */     throws SQLException
/*      */   {
/*  712 */     super.setCommand(paramString);
/*  713 */     if ((paramString == null) || (paramString.equals("")))
/*  714 */       this.osql = null;
/*      */     else
/*  716 */       this.osql = new OracleSqlForRowSet(paramString);
/*      */   }
/*      */ 
/*      */   public void setReader(RowSetReader paramRowSetReader)
/*      */   {
/*  730 */     this.reader = paramRowSetReader;
/*      */   }
/*      */ 
/*      */   public void setWriter(RowSetWriter paramRowSetWriter)
/*      */   {
/*  744 */     this.writer = paramRowSetWriter;
/*      */   }
/*      */ 
/*      */   private final int getColumnIndex(String paramString)
/*      */     throws SQLException
/*      */   {
/*  767 */     if ((paramString == null) || (paramString.equals("")))
/*      */     {
/*  769 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6, paramString);
/*  770 */       localSQLException1.fillInStackTrace();
/*  771 */       throw localSQLException1;
/*      */     }
/*      */ 
/*  774 */     paramString = paramString.toUpperCase();
/*  775 */     for (int i = 0; 
/*  776 */       i < this.metaData.length; i++)
/*      */     {
/*  778 */       if (paramString.equals(this.metaData[i]))
/*      */       {
/*      */         break;
/*      */       }
/*      */     }
/*      */ 
/*  784 */     if (i >= this.metaData.length)
/*      */     {
/*  786 */       SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 6, paramString);
/*  787 */       localSQLException2.fillInStackTrace();
/*  788 */       throw localSQLException2;
/*      */     }
/*      */ 
/*  791 */     return i + 1;
/*      */   }
/*      */ 
/*      */   private final void checkColumnIndex(int paramInt)
/*      */     throws SQLException
/*      */   {
/*      */     SQLException localSQLException;
/*  806 */     if (this.readOnly)
/*      */     {
/*  808 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/*  809 */       localSQLException.fillInStackTrace();
/*  810 */       throw localSQLException;
/*      */     }
/*  812 */     if ((paramInt < 1) || (paramInt > this.colCount))
/*      */     {
/*  814 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3, new StringBuilder().append("").append(paramInt).toString());
/*  815 */       localSQLException.fillInStackTrace();
/*  816 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   private final boolean isUpdated(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  835 */     if ((paramInt < 1) || (paramInt > this.colCount))
/*      */     {
/*  837 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3, new StringBuilder().append("").append(paramInt).toString());
/*  838 */       localSQLException.fillInStackTrace();
/*  839 */       throw localSQLException;
/*      */     }
/*      */ 
/*  842 */     return getCurrentRow().isColumnChanged(paramInt);
/*      */   }
/*      */ 
/*      */   private final void checkParamIndex(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  856 */     if (paramInt < 1)
/*      */     {
/*  858 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 310, new StringBuilder().append("").append(paramInt).toString());
/*  859 */       localSQLException.fillInStackTrace();
/*  860 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   private final void populateInit(ResultSet paramResultSet)
/*      */     throws SQLException
/*      */   {
/*  877 */     this.resultSet = paramResultSet;
/*  878 */     Statement localStatement = paramResultSet.getStatement();
/*      */ 
/*  882 */     this.maxFieldSize = localStatement.getMaxFieldSize();
/*      */ 
/*  885 */     this.fetchSize = localStatement.getFetchSize();
/*  886 */     this.queryTimeout = localStatement.getQueryTimeout();
/*      */ 
/*  888 */     this.connection = localStatement.getConnection();
/*      */ 
/*  892 */     this.transactionIsolation = this.connection.getTransactionIsolation();
/*      */ 
/*  896 */     this.typeMap = this.connection.getTypeMap();
/*  897 */     DatabaseMetaData localDatabaseMetaData = this.connection.getMetaData();
/*      */ 
/*  901 */     this.url = localDatabaseMetaData.getURL();
/*  902 */     this.username = localDatabaseMetaData.getUserName();
/*      */ 
/*  906 */     this.presentRow = 0;
/*      */   }
/*      */ 
/*      */   private synchronized InputStream getStream(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  923 */     Object localObject1 = getObject(paramInt);
/*      */ 
/*  927 */     if (localObject1 == null) {
/*  928 */       return null;
/*      */     }
/*  930 */     if ((localObject1 instanceof InputStream)) {
/*  931 */       return (InputStream)localObject1;
/*      */     }
/*  933 */     if ((localObject1 instanceof String))
/*      */     {
/*  935 */       return new ByteArrayInputStream(((String)localObject1).getBytes());
/*      */     }
/*  937 */     if ((localObject1 instanceof byte[]))
/*      */     {
/*  939 */       return new ByteArrayInputStream((byte[])localObject1);
/*      */     }
/*  941 */     if ((localObject1 instanceof OracleSerialClob))
/*  942 */       return ((OracleSerialClob)localObject1).getAsciiStream();
/*  943 */     if ((localObject1 instanceof OracleSerialBlob))
/*  944 */       return ((OracleSerialBlob)localObject1).getBinaryStream();
/*  945 */     if ((localObject1 instanceof Reader))
/*      */     {
/*  947 */       localObject2 = null;
/*  948 */       PipedOutputStream localPipedOutputStream = null;
/*      */       try
/*      */       {
/*  951 */         localObject2 = new BufferedReader((Reader)localObject1);
/*  952 */         int i = 0;
/*  953 */         localObject3 = new PipedInputStream();
/*  954 */         localPipedOutputStream = new PipedOutputStream((PipedInputStream)localObject3);
/*  955 */         while ((i = ((Reader)localObject2).read()) != -1)
/*  956 */           localPipedOutputStream.write(i);
/*      */         SQLException localSQLException1;
/*  957 */         return localObject3;
/*      */       }
/*      */       catch (IOException localIOException1)
/*      */       {
/*  962 */         Object localObject3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 311, localIOException1.getMessage());
/*  963 */         ((SQLException)localObject3).fillInStackTrace();
/*  964 */         throw ((Throwable)localObject3);
/*      */       }
/*      */       finally {
/*      */         SQLException localSQLException2;
/*      */         try {
/*  969 */           if (localObject2 != null)
/*  970 */             ((Reader)localObject2).close();
/*      */         }
/*      */         catch (IOException localIOException4)
/*      */         {
/*  974 */           localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 311, localIOException4.getMessage());
/*  975 */           localSQLException2.fillInStackTrace();
/*  976 */           throw localSQLException2;
/*      */         }
/*      */         try
/*      */         {
/*  980 */           if (localPipedOutputStream != null)
/*  981 */             localPipedOutputStream.close();
/*      */         }
/*      */         catch (IOException localIOException5)
/*      */         {
/*  985 */           localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 311, localIOException5.getMessage());
/*  986 */           localSQLException2.fillInStackTrace();
/*  987 */           throw localSQLException2;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  994 */     Object localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 312);
/*  995 */     ((SQLException)localObject2).fillInStackTrace();
/*  996 */     throw ((Throwable)localObject2);
/*      */   }
/*      */ 
/*      */   private final Calendar getSessionCalendar(Connection paramConnection)
/*      */   {
/* 1003 */     String str = ((OracleConnection)paramConnection).getSessionTimeZone();
/*      */     Calendar localCalendar;
/* 1006 */     if (str == null) {
/* 1007 */       localCalendar = Calendar.getInstance();
/*      */     }
/*      */     else {
/* 1010 */       TimeZone localTimeZone = TimeZone.getDefault();
/* 1011 */       localTimeZone.setID(str);
/* 1012 */       localCalendar = Calendar.getInstance(localTimeZone);
/*      */     }
/*      */ 
/* 1015 */     return localCalendar;
/*      */   }
/*      */ 
/*      */   private boolean isStreamType(int paramInt)
/*      */   {
/* 1021 */     return (paramInt == 2004) || (paramInt == 2005) || (paramInt == 2011) || (paramInt == -4) || (paramInt == -16) || (paramInt == -1);
/*      */   }
/*      */ 
/*      */   protected synchronized void notifyCursorMoved()
/*      */   {
/* 1053 */     if (this.insertRowFlag)
/*      */     {
/* 1055 */       this.insertRowFlag = false;
/* 1056 */       this.insertRow.setRowUpdated(false);
/* 1057 */       this.sqlWarning.setNextWarning(new SQLWarning("Cancelling insertion, due to cursor movement."));
/*      */     }
/* 1065 */     else if (this.updateRowFlag)
/*      */     {
/*      */       try
/*      */       {
/* 1069 */         this.updateRowFlag = false;
/* 1070 */         int i = this.presentRow;
/* 1071 */         this.presentRow = this.updateRowPosition;
/* 1072 */         getCurrentRow().setRowUpdated(false);
/* 1073 */         this.presentRow = i;
/* 1074 */         this.sqlWarning.setNextWarning(new SQLWarning("Cancelling all updates, due to cursor movement."));
/*      */       }
/*      */       catch (SQLException localSQLException)
/*      */       {
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1084 */     super.notifyCursorMoved();
/*      */   }
/*      */ 
/*      */   protected void checkAndFilterObject(int paramInt, Object paramObject)
/*      */     throws SQLException
/*      */   {
/*      */   }
/*      */ 
/*      */   OracleRow getCurrentRow()
/*      */     throws SQLException
/*      */   {
/* 1114 */     int i = this.presentRow - 1;
/*      */ 
/* 1118 */     if ((this.presentRow < 1) || (this.presentRow > this.rowCount))
/*      */     {
/* 1120 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 313);
/* 1121 */       localSQLException.fillInStackTrace();
/* 1122 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1125 */     return (OracleRow)this.rows.elementAt(this.presentRow - 1);
/*      */   }
/*      */ 
/*      */   boolean isExecuteCalled()
/*      */   {
/* 1135 */     return this.executeCalled;
/*      */   }
/*      */ 
/*      */   int getCurrentPage()
/*      */   {
/* 1144 */     return this.currentPage;
/*      */   }
/*      */ 
/*      */   boolean isConnectionStayingOpen()
/*      */   {
/* 1153 */     return this.isConnectionStayingOpenForTxnControl;
/*      */   }
/*      */ 
/*      */   void setOriginal()
/*      */     throws SQLException
/*      */   {
/* 1165 */     int i = 1;
/*      */     do
/*      */     {
/* 1169 */       boolean bool = setOriginalRowInternal(i);
/*      */ 
/* 1171 */       if (!bool)
/*      */       {
/* 1173 */         i++;
/*      */       }
/*      */     }
/* 1176 */     while (i <= this.rowCount);
/*      */ 
/* 1178 */     notifyRowSetChanged();
/*      */ 
/* 1182 */     this.presentRow = 0;
/*      */   }
/*      */ 
/*      */   boolean setOriginalRowInternal(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1195 */     if ((paramInt < 1) || (paramInt > this.rowCount))
/*      */     {
/* 1197 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 313);
/* 1198 */       localSQLException.fillInStackTrace();
/* 1199 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1202 */     boolean bool = false;
/*      */ 
/* 1204 */     OracleRow localOracleRow = (OracleRow)this.rows.elementAt(paramInt - 1);
/*      */ 
/* 1206 */     if (localOracleRow.isRowDeleted())
/*      */     {
/* 1208 */       this.rows.remove(paramInt - 1);
/* 1209 */       this.rowCount -= 1;
/* 1210 */       bool = true;
/*      */     }
/*      */     else
/*      */     {
/* 1215 */       if (localOracleRow.isRowInserted())
/*      */       {
/* 1217 */         localOracleRow.setInsertedFlag(false);
/*      */       }
/*      */ 
/* 1220 */       if (localOracleRow.isRowUpdated())
/*      */       {
/* 1222 */         localOracleRow.makeUpdatesOriginal();
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1229 */     return bool;
/*      */   }
/*      */ 
/*      */   public boolean next()
/*      */     throws SQLException
/*      */   {
/* 1279 */     if (this.isClosed)
/*      */     {
/* 1281 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10);
/* 1282 */       localSQLException.fillInStackTrace();
/* 1283 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1286 */     if (this.rowCount < 0)
/*      */     {
/* 1288 */       return false;
/*      */     }
/*      */ 
/* 1291 */     if ((this.fetchDirection == 1000) || (this.fetchDirection == 1002))
/*      */     {
/* 1293 */       if (this.presentRow + 1 <= this.rowCount)
/*      */       {
/* 1295 */         this.presentRow += 1;
/* 1296 */         if ((!this.showDeleted) && (getCurrentRow().isRowDeleted())) {
/* 1297 */           return next();
/*      */         }
/* 1299 */         notifyCursorMoved();
/* 1300 */         return true;
/*      */       }
/*      */ 
/* 1307 */       this.presentRow = (this.rowCount + 1);
/* 1308 */       return false;
/*      */     }
/*      */ 
/* 1311 */     if (this.fetchDirection == 1001)
/*      */     {
/* 1313 */       if (this.presentRow - 1 > 0)
/*      */       {
/* 1315 */         this.presentRow -= 1;
/* 1316 */         if ((!this.showDeleted) && (getCurrentRow().isRowDeleted())) {
/* 1317 */           return next();
/*      */         }
/* 1319 */         notifyCursorMoved();
/* 1320 */         return true;
/*      */       }
/*      */ 
/* 1327 */       this.presentRow = 0;
/* 1328 */       return false;
/*      */     }
/*      */ 
/* 1334 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean previous()
/*      */     throws SQLException
/*      */   {
/* 1354 */     if (this.rowCount < 0)
/*      */     {
/* 1356 */       return false;
/*      */     }
/*      */ 
/* 1359 */     if (this.fetchDirection == 1001)
/*      */     {
/* 1361 */       if (this.presentRow + 1 <= this.rowCount)
/*      */       {
/* 1363 */         this.presentRow += 1;
/* 1364 */         if ((!this.showDeleted) && (getCurrentRow().isRowDeleted())) {
/* 1365 */           return previous();
/*      */         }
/* 1367 */         notifyCursorMoved();
/* 1368 */         return true;
/*      */       }
/*      */ 
/* 1375 */       this.presentRow = (this.rowCount + 1);
/* 1376 */       return false;
/*      */     }
/*      */ 
/* 1380 */     if ((this.fetchDirection == 1000) || (this.fetchDirection == 1002))
/*      */     {
/* 1382 */       if (this.presentRow - 1 > 0)
/*      */       {
/* 1384 */         this.presentRow -= 1;
/* 1385 */         if ((!this.showDeleted) && (getCurrentRow().isRowDeleted())) {
/* 1386 */           return previous();
/*      */         }
/* 1388 */         notifyCursorMoved();
/* 1389 */         return true;
/*      */       }
/*      */ 
/* 1396 */       this.presentRow = 0;
/* 1397 */       return false;
/*      */     }
/*      */ 
/* 1403 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean isBeforeFirst()
/*      */     throws SQLException
/*      */   {
/* 1423 */     if (this.isClosed)
/*      */     {
/* 1425 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10);
/* 1426 */       localSQLException.fillInStackTrace();
/* 1427 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1430 */     return (this.rowCount > 0) && (this.presentRow == 0);
/*      */   }
/*      */ 
/*      */   public boolean isAfterLast()
/*      */     throws SQLException
/*      */   {
/* 1449 */     if (this.isClosed)
/*      */     {
/* 1451 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10);
/* 1452 */       localSQLException.fillInStackTrace();
/* 1453 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1456 */     return (this.rowCount > 0) && (this.presentRow == this.rowCount + 1);
/*      */   }
/*      */ 
/*      */   public boolean isFirst()
/*      */     throws SQLException
/*      */   {
/* 1473 */     if (this.isClosed)
/*      */     {
/* 1475 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10);
/* 1476 */       localSQLException.fillInStackTrace();
/* 1477 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1480 */     return this.presentRow == 1;
/*      */   }
/*      */ 
/*      */   public boolean isLast()
/*      */     throws SQLException
/*      */   {
/* 1499 */     if (this.isClosed)
/*      */     {
/* 1501 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10);
/* 1502 */       localSQLException.fillInStackTrace();
/* 1503 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1506 */     return this.presentRow == this.rowCount;
/*      */   }
/*      */ 
/*      */   public void beforeFirst()
/*      */     throws SQLException
/*      */   {
/* 1522 */     if (this.isClosed)
/*      */     {
/* 1524 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10);
/* 1525 */       localSQLException.fillInStackTrace();
/* 1526 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1529 */     this.presentRow = 0;
/*      */   }
/*      */ 
/*      */   public void afterLast()
/*      */     throws SQLException
/*      */   {
/* 1543 */     this.presentRow = (this.rowCount + 1);
/*      */ 
/* 1548 */     if (this.isClosed)
/*      */     {
/* 1550 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10);
/* 1551 */       localSQLException.fillInStackTrace();
/* 1552 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean first()
/*      */     throws SQLException
/*      */   {
/* 1569 */     return absolute(1);
/*      */   }
/*      */ 
/*      */   public boolean last()
/*      */     throws SQLException
/*      */   {
/* 1583 */     return absolute(-1);
/*      */   }
/*      */ 
/*      */   public boolean absolute(int paramInt)
/*      */     throws SQLException
/*      */   {
/*      */     SQLException localSQLException;
/* 1608 */     if (this.isClosed)
/*      */     {
/* 1610 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10);
/* 1611 */       localSQLException.fillInStackTrace();
/* 1612 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1615 */     if (this.rowsetType == 1003)
/*      */     {
/* 1617 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 314);
/* 1618 */       localSQLException.fillInStackTrace();
/* 1619 */       throw localSQLException;
/*      */     }
/* 1621 */     if ((paramInt == 0) || (Math.abs(paramInt) > this.rowCount))
/* 1622 */       return false;
/* 1623 */     this.presentRow = (paramInt < 0 ? this.rowCount + paramInt + 1 : paramInt);
/* 1624 */     notifyCursorMoved();
/*      */ 
/* 1626 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean relative(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1644 */     return absolute(this.presentRow + paramInt);
/*      */   }
/*      */ 
/*      */   public synchronized void populate(ResultSet paramResultSet)
/*      */     throws SQLException
/*      */   {
/* 1686 */     if (this.rows == null)
/*      */     {
/* 1689 */       this.rows = new Vector(50, 10);
/*      */     }
/*      */     else
/* 1692 */       this.rows.clear();
/* 1693 */     this.rowsetMetaData = new OracleRowSetMetaData(paramResultSet.getMetaData());
/* 1694 */     this.metaData = new String[this.colCount = this.rowsetMetaData.getColumnCount()];
/* 1695 */     for (int i = 0; i < this.colCount; i++) {
/* 1696 */       this.metaData[i] = this.rowsetMetaData.getColumnName(i + 1);
/*      */     }
/*      */ 
/* 1700 */     if (!(paramResultSet instanceof OracleCachedRowSet)) {
/* 1701 */       populateInit(paramResultSet);
/*      */     }
/*      */ 
/* 1711 */     i = (this.fetchDirection == 1000) || (this.fetchDirection == 1002) ? 1 : 0;
/*      */ 
/* 1714 */     this.rowCount = 0;
/* 1715 */     OracleRow localOracleRow = null;
/*      */     int j;
/* 1721 */     if ((this.maxRows == 0) && (this.pageSize == 0))
/*      */     {
/* 1723 */       j = 2147483647;
/*      */     }
/* 1725 */     else if ((this.maxRows == 0) || (this.pageSize == 0))
/*      */     {
/* 1727 */       j = Math.max(this.maxRows, this.pageSize);
/*      */     }
/*      */     else
/*      */     {
/* 1731 */       j = Math.min(this.maxRows, this.pageSize);
/*      */     }
/*      */ 
/* 1741 */     if ((paramResultSet.getType() != 1003) && (this.rows.size() == 0))
/*      */     {
/* 1743 */       if (i == 0)
/*      */       {
/* 1745 */         paramResultSet.afterLast();
/*      */       }
/*      */     }
/*      */ 
/* 1749 */     int k = 0;
/*      */ 
/* 1751 */     while (this.rowCount < j)
/*      */     {
/* 1753 */       if (i != 0)
/*      */       {
/* 1755 */         if (!paramResultSet.next())
/*      */         {
/* 1757 */           k = 1;
/* 1758 */           break;
/*      */         }
/*      */ 
/*      */       }
/* 1763 */       else if (!paramResultSet.previous())
/*      */       {
/* 1765 */         k = 1;
/* 1766 */         break;
/*      */       }
/*      */ 
/* 1770 */       localOracleRow = new OracleRow(this.colCount);
/* 1771 */       for (int m = 1; m <= this.colCount; m++)
/*      */       {
/* 1773 */         Object localObject = null;
/*      */         try
/*      */         {
/* 1776 */           localObject = paramResultSet.getObject(m, this.typeMap);
/*      */         }
/*      */         catch (Exception localException)
/*      */         {
/* 1780 */           localObject = paramResultSet.getObject(m);
/*      */         }
/*      */         catch (AbstractMethodError localAbstractMethodError)
/*      */         {
/* 1784 */           localObject = paramResultSet.getObject(m);
/*      */         }
/*      */ 
/* 1788 */         if (((localObject instanceof Clob)) || ((localObject instanceof CLOB))) {
/* 1789 */           localOracleRow.setColumnValue(m, new OracleSerialClob((Clob)localObject));
/*      */         }
/* 1791 */         else if (((localObject instanceof Blob)) || ((localObject instanceof BLOB))) {
/* 1792 */           localOracleRow.setColumnValue(m, new OracleSerialBlob((Blob)localObject));
/*      */         }
/*      */         else {
/* 1795 */           localOracleRow.setColumnValue(m, localObject);
/*      */         }
/* 1797 */         localOracleRow.markOriginalNull(m, paramResultSet.wasNull());
/*      */       }
/*      */ 
/* 1800 */       if (i != 0)
/*      */       {
/* 1802 */         this.rows.add(localOracleRow);
/*      */       }
/*      */       else
/*      */       {
/* 1807 */         this.rows.add(1, localOracleRow);
/*      */       }
/*      */ 
/* 1810 */       this.rowCount += 1;
/*      */     }
/*      */ 
/* 1813 */     if ((k != 0) || ((i != 0) && (paramResultSet.isAfterLast())) || ((i == 0) && (paramResultSet.isBeforeFirst())))
/*      */     {
/* 1817 */       this.isPopulateDone = true;
/*      */     }
/*      */ 
/* 1824 */     this.connection = null;
/*      */ 
/* 1826 */     notifyRowSetChanged();
/*      */   }
/*      */ 
/*      */   public String getCursorName()
/*      */     throws SQLException
/*      */   {
/* 1842 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 23);
/* 1843 */     localSQLException.fillInStackTrace();
/* 1844 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public synchronized void clearParameters()
/*      */     throws SQLException
/*      */   {
/* 1859 */     this.param = null;
/* 1860 */     this.param = new Vector();
/*      */   }
/*      */ 
/*      */   public boolean wasNull()
/*      */     throws SQLException
/*      */   {
/* 1877 */     if (this.isClosed)
/*      */     {
/* 1879 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 10);
/* 1880 */       localSQLException.fillInStackTrace();
/* 1881 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1884 */     return this.previousColumnWasNull;
/*      */   }
/*      */ 
/*      */   public void close()
/*      */     throws SQLException
/*      */   {
/* 1902 */     if (!this.isClosed)
/*      */     {
/* 1904 */       release();
/* 1905 */       this.isClosed = true;
/*      */     }
/*      */   }
/*      */ 
/*      */   public SQLWarning getWarnings()
/*      */     throws SQLException
/*      */   {
/* 1921 */     return this.sqlWarning;
/*      */   }
/*      */ 
/*      */   public void clearWarnings()
/*      */     throws SQLException
/*      */   {
/* 1935 */     this.sqlWarning = null;
/*      */   }
/*      */ 
/*      */   public ResultSetMetaData getMetaData()
/*      */     throws SQLException
/*      */   {
/* 1950 */     return this.rowsetMetaData;
/*      */   }
/*      */ 
/*      */   public int findColumn(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1964 */     return getColumnIndex(paramString);
/*      */   }
/*      */ 
/*      */   public Object[] getParams()
/*      */     throws SQLException
/*      */   {
/* 1978 */     return this.param.toArray();
/*      */   }
/*      */ 
/*      */   public void setMetaData(RowSetMetaData paramRowSetMetaData)
/*      */     throws SQLException
/*      */   {
/* 1992 */     this.rowsetMetaData = paramRowSetMetaData;
/*      */ 
/* 1996 */     if (paramRowSetMetaData != null)
/*      */     {
/* 1998 */       this.colCount = paramRowSetMetaData.getColumnCount();
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized void execute()
/*      */     throws SQLException
/*      */   {
/* 2015 */     this.isConnectionStayingOpenForTxnControl = false;
/* 2016 */     getReader().readData(this);
/*      */ 
/* 2018 */     this.executeCalled = true;
/* 2019 */     this.isClosed = false;
/*      */   }
/*      */ 
/*      */   public void acceptChanges()
/*      */     throws SyncProviderException
/*      */   {
/*      */     try
/*      */     {
/* 2041 */       getWriter().writeData(this);
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/* 2047 */       SyncProviderException localSyncProviderException = new SyncProviderException(localSQLException.getMessage());
/* 2048 */       localSyncProviderException.initCause(localSQLException);
/* 2049 */       throw localSyncProviderException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void acceptChanges(Connection paramConnection)
/*      */     throws SyncProviderException
/*      */   {
/* 2066 */     this.connection = paramConnection;
/*      */ 
/* 2070 */     this.isConnectionStayingOpenForTxnControl = true;
/* 2071 */     acceptChanges();
/*      */   }
/*      */ 
/*      */   public Object clone()
/*      */     throws CloneNotSupportedException
/*      */   {
/*      */     try
/*      */     {
/* 2090 */       return createCopy();
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/* 2094 */       throw new CloneNotSupportedException(new StringBuilder().append("SQL Error occured while cloning: ").append(localSQLException.getMessage()).toString());
/*      */     }
/*      */   }
/*      */ 
/*      */   public CachedRowSet createCopy()
/*      */     throws SQLException
/*      */   {
/* 2109 */     OracleCachedRowSet localOracleCachedRowSet = (OracleCachedRowSet)createShared();
/* 2110 */     int i = this.rows.size();
/* 2111 */     localOracleCachedRowSet.rows = new Vector(i);
/* 2112 */     for (int j = 0; j < i; j++) {
/* 2113 */       localOracleCachedRowSet.rows.add(((OracleRow)this.rows.elementAt(j)).createCopy());
/*      */     }
/* 2115 */     return localOracleCachedRowSet;
/*      */   }
/*      */ 
/*      */   public RowSet createShared()
/*      */     throws SQLException
/*      */   {
/* 2129 */     OracleCachedRowSet localOracleCachedRowSet = new OracleCachedRowSet();
/*      */ 
/* 2134 */     localOracleCachedRowSet.rows = this.rows;
/*      */ 
/* 2140 */     localOracleCachedRowSet.setDataSource(getDataSource());
/* 2141 */     localOracleCachedRowSet.setDataSourceName(getDataSourceName());
/* 2142 */     localOracleCachedRowSet.setUsername(getUsername());
/* 2143 */     localOracleCachedRowSet.setPassword(getPassword());
/* 2144 */     localOracleCachedRowSet.setUrl(getUrl());
/* 2145 */     localOracleCachedRowSet.setTypeMap(getTypeMap());
/* 2146 */     localOracleCachedRowSet.setMaxFieldSize(getMaxFieldSize());
/* 2147 */     localOracleCachedRowSet.setMaxRows(getMaxRows());
/* 2148 */     localOracleCachedRowSet.setQueryTimeout(getQueryTimeout());
/* 2149 */     localOracleCachedRowSet.setFetchSize(getFetchSize());
/* 2150 */     localOracleCachedRowSet.setEscapeProcessing(getEscapeProcessing());
/* 2151 */     localOracleCachedRowSet.setConcurrency(getConcurrency());
/* 2152 */     localOracleCachedRowSet.setReadOnly(this.readOnly);
/*      */ 
/* 2157 */     this.rowsetType = getType();
/* 2158 */     this.fetchDirection = getFetchDirection();
/* 2159 */     localOracleCachedRowSet.setCommand(getCommand());
/* 2160 */     localOracleCachedRowSet.setTransactionIsolation(getTransactionIsolation());
/*      */ 
/* 2163 */     localOracleCachedRowSet.presentRow = this.presentRow;
/* 2164 */     localOracleCachedRowSet.colCount = this.colCount;
/* 2165 */     localOracleCachedRowSet.rowCount = this.rowCount;
/* 2166 */     localOracleCachedRowSet.showDeleted = this.showDeleted;
/*      */ 
/* 2168 */     localOracleCachedRowSet.syncProvider = this.syncProvider;
/* 2169 */     localOracleCachedRowSet.currentPage = this.currentPage;
/* 2170 */     localOracleCachedRowSet.pageSize = this.pageSize;
/* 2171 */     localOracleCachedRowSet.tableName = (this.tableName == null ? null : this.tableName);
/* 2172 */     localOracleCachedRowSet.keyColumns = (this.keyColumns == null ? null : (int[])this.keyColumns.clone());
/*      */ 
/* 2174 */     int i = this.listener.size();
/* 2175 */     for (int j = 0; j < i; j++) {
/* 2176 */       localOracleCachedRowSet.listener.add(this.listener.elementAt(j));
/*      */     }
/*      */ 
/* 2185 */     localOracleCachedRowSet.rowsetMetaData = new OracleRowSetMetaData(this.rowsetMetaData);
/*      */ 
/* 2187 */     i = this.param.size();
/* 2188 */     for (j = 0; j < i; j++) {
/* 2189 */       localOracleCachedRowSet.param.add(this.param.elementAt(j));
/*      */     }
/* 2191 */     localOracleCachedRowSet.metaData = new String[this.metaData.length];
/* 2192 */     System.arraycopy(this.metaData, 0, localOracleCachedRowSet.metaData, 0, this.metaData.length);
/*      */ 
/* 2196 */     return localOracleCachedRowSet;
/*      */   }
/*      */ 
/*      */   public void release()
/*      */     throws SQLException
/*      */   {
/* 2210 */     this.rows = null;
/* 2211 */     this.rows = new Vector();
/* 2212 */     if ((this.connection != null) && (!this.connection.isClosed()))
/* 2213 */       this.connection.close();
/* 2214 */     this.rowCount = 0;
/* 2215 */     this.presentRow = 0;
/* 2216 */     notifyRowSetChanged();
/*      */   }
/*      */ 
/*      */   public void restoreOriginal()
/*      */     throws SQLException
/*      */   {
/* 2231 */     int i = 0;
/* 2232 */     for (int j = 0; j < this.rowCount; j++)
/*      */     {
/* 2234 */       OracleRow localOracleRow = (OracleRow)this.rows.elementAt(j);
/* 2235 */       if (localOracleRow.isRowInserted())
/*      */       {
/* 2237 */         this.rows.remove(j);
/* 2238 */         this.rowCount -= 1;
/*      */ 
/* 2243 */         j--;
/* 2244 */         i = 1;
/*      */       }
/* 2246 */       else if (localOracleRow.isRowUpdated())
/*      */       {
/* 2248 */         localOracleRow.setRowUpdated(false);
/* 2249 */         i = 1;
/*      */       }
/* 2251 */       else if (localOracleRow.isRowDeleted())
/*      */       {
/* 2253 */         localOracleRow.setRowDeleted(false);
/* 2254 */         i = 1;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2260 */     if (i == 0)
/*      */     {
/* 2262 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 315);
/* 2263 */       localSQLException.fillInStackTrace();
/* 2264 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2268 */     notifyRowSetChanged();
/*      */ 
/* 2271 */     this.presentRow = 0;
/*      */   }
/*      */ 
/*      */   public Collection toCollection()
/*      */     throws SQLException
/*      */   {
/* 2287 */     Map localMap = Collections.synchronizedMap(new TreeMap());
/*      */     try
/*      */     {
/* 2291 */       for (int i = 0; i < this.rowCount; i++)
/*      */       {
/* 2293 */         localMap.put(Integer.valueOf(i), ((OracleRow)this.rows.elementAt(i)).toCollection());
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (Exception localException)
/*      */     {
/* 2300 */       localMap = null;
/*      */ 
/* 2302 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 316);
/* 2303 */       localSQLException.fillInStackTrace();
/* 2304 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2309 */     return localMap.values();
/*      */   }
/*      */ 
/*      */   public Collection toCollection(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2323 */     if ((paramInt < 1) || (paramInt > this.colCount))
/*      */     {
/* 2325 */       localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3, new StringBuilder().append("").append(paramInt).toString());
/* 2326 */       ((SQLException)localObject1).fillInStackTrace();
/* 2327 */       throw ((Throwable)localObject1);
/*      */     }
/*      */ 
/* 2330 */     Object localObject1 = new Vector(this.rowCount);
/* 2331 */     for (int i = 0; i < this.rowCount; i++)
/*      */     {
/* 2333 */       OracleRow localOracleRow = (OracleRow)this.rows.elementAt(i);
/* 2334 */       Object localObject2 = localOracleRow.isColumnChanged(paramInt) ? localOracleRow.getModifiedColumn(paramInt) : localOracleRow.getColumn(paramInt);
/*      */ 
/* 2337 */       ((Vector)localObject1).add(localObject2);
/*      */     }
/*      */ 
/* 2340 */     return localObject1;
/*      */   }
/*      */ 
/*      */   public Collection toCollection(String paramString)
/*      */     throws SQLException
/*      */   {
/* 2354 */     return toCollection(getColumnIndex(paramString));
/*      */   }
/*      */ 
/*      */   public int getRow()
/*      */     throws SQLException
/*      */   {
/* 2377 */     if (this.presentRow > this.rowCount) {
/* 2378 */       return this.rowCount;
/*      */     }
/*      */ 
/* 2386 */     return this.presentRow;
/*      */   }
/*      */ 
/*      */   public void cancelRowInsert()
/*      */     throws SQLException
/*      */   {
/* 2400 */     if (getCurrentRow().isRowInserted())
/*      */     {
/* 2402 */       this.rows.remove(--this.presentRow);
/* 2403 */       this.rowCount -= 1;
/* 2404 */       notifyRowChanged();
/*      */     }
/*      */     else
/*      */     {
/* 2408 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 317);
/* 2409 */       localSQLException.fillInStackTrace();
/* 2410 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void cancelRowDelete()
/*      */     throws SQLException
/*      */   {
/* 2426 */     if (getCurrentRow().isRowDeleted())
/*      */     {
/* 2428 */       getCurrentRow().setRowDeleted(false);
/* 2429 */       notifyRowChanged();
/*      */     }
/*      */     else
/*      */     {
/* 2433 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 318);
/* 2434 */       localSQLException.fillInStackTrace();
/* 2435 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void cancelRowUpdates()
/*      */     throws SQLException
/*      */   {
/* 2451 */     if (getCurrentRow().isRowUpdated())
/*      */     {
/* 2453 */       this.updateRowFlag = false;
/* 2454 */       getCurrentRow().setRowUpdated(false);
/* 2455 */       notifyRowChanged();
/*      */     }
/*      */     else
/*      */     {
/* 2459 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 319);
/* 2460 */       localSQLException.fillInStackTrace();
/* 2461 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void insertRow()
/*      */     throws SQLException
/*      */   {
/*      */     SQLException localSQLException;
/* 2479 */     if (isReadOnly())
/*      */     {
/* 2481 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2482 */       localSQLException.fillInStackTrace();
/* 2483 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2486 */     if (!this.insertRowFlag)
/*      */     {
/* 2488 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 317);
/* 2489 */       localSQLException.fillInStackTrace();
/* 2490 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2493 */     if (!this.insertRow.isRowFullyPopulated())
/*      */     {
/* 2495 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 320);
/* 2496 */       localSQLException.fillInStackTrace();
/* 2497 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2503 */     this.insertRow.insertRow();
/* 2504 */     this.rows.insertElementAt(this.insertRow, this.insertRowPosition - 1);
/* 2505 */     this.insertRowFlag = false;
/* 2506 */     this.rowCount += 1;
/* 2507 */     notifyRowChanged();
/*      */   }
/*      */ 
/*      */   public void updateRow()
/*      */     throws SQLException
/*      */   {
/*      */     SQLException localSQLException;
/* 2524 */     if (isReadOnly())
/*      */     {
/* 2526 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2527 */       localSQLException.fillInStackTrace();
/* 2528 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2531 */     if (this.updateRowFlag)
/*      */     {
/* 2533 */       this.updateRowFlag = false;
/* 2534 */       getCurrentRow().setRowUpdated(true);
/* 2535 */       notifyRowChanged();
/*      */     }
/*      */     else
/*      */     {
/* 2539 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 319);
/* 2540 */       localSQLException.fillInStackTrace();
/* 2541 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void deleteRow()
/*      */     throws SQLException
/*      */   {
/* 2557 */     if (isReadOnly())
/*      */     {
/* 2559 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2560 */       localSQLException.fillInStackTrace();
/* 2561 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2564 */     getCurrentRow().setRowDeleted(true);
/* 2565 */     notifyRowChanged();
/*      */   }
/*      */ 
/*      */   public void refreshRow()
/*      */     throws SQLException
/*      */   {
/* 2580 */     OracleRow localOracleRow = getCurrentRow();
/* 2581 */     if (localOracleRow.isRowUpdated())
/* 2582 */       localOracleRow.cancelRowUpdates();
/*      */   }
/*      */ 
/*      */   public void moveToInsertRow()
/*      */     throws SQLException
/*      */   {
/* 2599 */     if (isReadOnly())
/*      */     {
/* 2601 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2602 */       localSQLException.fillInStackTrace();
/* 2603 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2606 */     this.insertRow = new OracleRow(this.colCount, true);
/* 2607 */     this.insertRowFlag = true;
/*      */ 
/* 2609 */     if (isAfterLast())
/* 2610 */       this.insertRowPosition = this.presentRow;
/*      */     else
/* 2612 */       this.insertRowPosition = (this.presentRow + 1);
/*      */   }
/*      */ 
/*      */   public void moveToCurrentRow()
/*      */     throws SQLException
/*      */   {
/* 2629 */     if (isReadOnly())
/*      */     {
/* 2631 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 309);
/* 2632 */       localSQLException.fillInStackTrace();
/* 2633 */       throw localSQLException;
/*      */     }
/*      */ 
/* 2640 */     this.insertRowFlag = false;
/* 2641 */     this.updateRowFlag = false;
/* 2642 */     absolute(this.presentRow);
/*      */   }
/*      */ 
/*      */   public boolean rowUpdated()
/*      */     throws SQLException
/*      */   {
/* 2657 */     return getCurrentRow().isRowUpdated();
/*      */   }
/*      */ 
/*      */   public boolean rowInserted()
/*      */     throws SQLException
/*      */   {
/* 2671 */     return getCurrentRow().isRowInserted();
/*      */   }
/*      */ 
/*      */   public boolean rowDeleted()
/*      */     throws SQLException
/*      */   {
/* 2685 */     return getCurrentRow().isRowDeleted();
/*      */   }
/*      */ 
/*      */   public ResultSet getOriginalRow()
/*      */     throws SQLException
/*      */   {
/* 2702 */     OracleCachedRowSet localOracleCachedRowSet = new OracleCachedRowSet();
/* 2703 */     localOracleCachedRowSet.rowsetMetaData = this.rowsetMetaData;
/* 2704 */     localOracleCachedRowSet.rowCount = 1;
/* 2705 */     localOracleCachedRowSet.colCount = this.colCount;
/* 2706 */     localOracleCachedRowSet.presentRow = 0;
/* 2707 */     localOracleCachedRowSet.setReader(null);
/* 2708 */     localOracleCachedRowSet.setWriter(null);
/* 2709 */     OracleRow localOracleRow = new OracleRow(this.rowsetMetaData.getColumnCount(), getCurrentRow().getOriginalRow());
/*      */ 
/* 2712 */     localOracleCachedRowSet.rows.add(localOracleRow);
/*      */ 
/* 2714 */     return localOracleCachedRowSet;
/*      */   }
/*      */ 
/*      */   public ResultSet getOriginal()
/*      */     throws SQLException
/*      */   {
/* 2731 */     OracleCachedRowSet localOracleCachedRowSet = new OracleCachedRowSet();
/* 2732 */     localOracleCachedRowSet.rowsetMetaData = this.rowsetMetaData;
/* 2733 */     localOracleCachedRowSet.rowCount = this.rowCount;
/* 2734 */     localOracleCachedRowSet.colCount = this.colCount;
/*      */ 
/* 2737 */     localOracleCachedRowSet.presentRow = 0;
/*      */ 
/* 2740 */     localOracleCachedRowSet.setType(1004);
/* 2741 */     localOracleCachedRowSet.setConcurrency(1008);
/*      */ 
/* 2743 */     localOracleCachedRowSet.setReader(null);
/* 2744 */     localOracleCachedRowSet.setWriter(null);
/* 2745 */     int i = this.rowsetMetaData.getColumnCount();
/* 2746 */     OracleRow localOracleRow = null;
/*      */ 
/* 2748 */     Iterator localIterator = this.rows.iterator();
/*      */ 
/* 2750 */     for (; localIterator.hasNext(); 
/* 2750 */       localOracleCachedRowSet.rows.add(localOracleRow)) {
/* 2751 */       localOracleRow = new OracleRow(i, ((OracleRow)localIterator.next()).getOriginalRow());
/*      */     }
/* 2753 */     return localOracleCachedRowSet;
/*      */   }
/*      */ 
/*      */   public void setNull(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 2772 */     checkParamIndex(paramInt1);
/*      */ 
/* 2774 */     this.param.add(paramInt1 - 1, null);
/*      */   }
/*      */ 
/*      */   public void setNull(int paramInt1, int paramInt2, String paramString)
/*      */     throws SQLException
/*      */   {
/* 2789 */     checkParamIndex(paramInt1);
/* 2790 */     Object[] arrayOfObject = { Integer.valueOf(paramInt2), paramString };
/* 2791 */     this.param.add(paramInt1 - 1, arrayOfObject);
/*      */   }
/*      */ 
/*      */   public void setBoolean(int paramInt, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 2806 */     checkParamIndex(paramInt);
/* 2807 */     this.param.add(paramInt - 1, Boolean.valueOf(paramBoolean));
/*      */   }
/*      */ 
/*      */   public void setByte(int paramInt, byte paramByte)
/*      */     throws SQLException
/*      */   {
/* 2822 */     checkParamIndex(paramInt);
/* 2823 */     this.param.add(paramInt - 1, new Byte(paramByte));
/*      */   }
/*      */ 
/*      */   public void setShort(int paramInt, short paramShort)
/*      */     throws SQLException
/*      */   {
/* 2838 */     checkParamIndex(paramInt);
/* 2839 */     this.param.add(paramInt - 1, Short.valueOf(paramShort));
/*      */   }
/*      */ 
/*      */   public void setInt(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 2854 */     checkParamIndex(paramInt1);
/* 2855 */     this.param.add(paramInt1 - 1, Integer.valueOf(paramInt2));
/*      */   }
/*      */ 
/*      */   public void setLong(int paramInt, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 2870 */     checkParamIndex(paramInt);
/* 2871 */     this.param.add(paramInt - 1, Long.valueOf(paramLong));
/*      */   }
/*      */ 
/*      */   public void setFloat(int paramInt, float paramFloat)
/*      */     throws SQLException
/*      */   {
/* 2886 */     checkParamIndex(paramInt);
/* 2887 */     this.param.add(paramInt - 1, Float.valueOf(paramFloat));
/*      */   }
/*      */ 
/*      */   public void setDouble(int paramInt, double paramDouble)
/*      */     throws SQLException
/*      */   {
/* 2902 */     checkParamIndex(paramInt);
/* 2903 */     this.param.add(paramInt - 1, Double.valueOf(paramDouble));
/*      */   }
/*      */ 
/*      */   public void setBigDecimal(int paramInt, BigDecimal paramBigDecimal)
/*      */     throws SQLException
/*      */   {
/* 2918 */     checkParamIndex(paramInt);
/* 2919 */     this.param.add(paramInt - 1, paramBigDecimal);
/*      */   }
/*      */ 
/*      */   public void setString(int paramInt, String paramString)
/*      */     throws SQLException
/*      */   {
/* 2934 */     checkParamIndex(paramInt);
/* 2935 */     this.param.add(paramInt - 1, paramString);
/*      */   }
/*      */ 
/*      */   public void setBytes(int paramInt, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 2950 */     checkParamIndex(paramInt);
/* 2951 */     this.param.add(paramInt - 1, paramArrayOfByte);
/*      */   }
/*      */ 
/*      */   public void setDate(int paramInt, java.sql.Date paramDate)
/*      */     throws SQLException
/*      */   {
/* 2966 */     checkParamIndex(paramInt);
/* 2967 */     this.param.add(paramInt - 1, paramDate);
/*      */   }
/*      */ 
/*      */   public void setTime(int paramInt, Time paramTime)
/*      */     throws SQLException
/*      */   {
/* 2982 */     checkParamIndex(paramInt);
/* 2983 */     this.param.add(paramInt - 1, paramTime);
/*      */   }
/*      */ 
/*      */   public void setObject(int paramInt, Object paramObject)
/*      */     throws SQLException
/*      */   {
/* 2998 */     checkParamIndex(paramInt);
/* 2999 */     this.param.add(paramInt - 1, paramObject);
/*      */   }
/*      */ 
/*      */   public void setRef(int paramInt, Ref paramRef)
/*      */     throws SQLException
/*      */   {
/* 3014 */     checkParamIndex(paramInt);
/* 3015 */     this.param.add(paramInt - 1, paramRef);
/*      */   }
/*      */ 
/*      */   public void setBlob(int paramInt, Blob paramBlob)
/*      */     throws SQLException
/*      */   {
/* 3030 */     checkParamIndex(paramInt);
/* 3031 */     this.param.add(paramInt - 1, paramBlob);
/*      */   }
/*      */ 
/*      */   public void setClob(int paramInt, Clob paramClob)
/*      */     throws SQLException
/*      */   {
/* 3046 */     checkParamIndex(paramInt);
/* 3047 */     this.param.add(paramInt - 1, paramClob);
/*      */   }
/*      */ 
/*      */   public void setArray(int paramInt, Array paramArray)
/*      */     throws SQLException
/*      */   {
/* 3062 */     checkParamIndex(paramInt);
/* 3063 */     this.param.add(paramInt - 1, paramArray);
/*      */   }
/*      */ 
/*      */   public void setBinaryStream(int paramInt1, InputStream paramInputStream, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 3079 */     checkParamIndex(paramInt1);
/* 3080 */     Object[] arrayOfObject = { paramInputStream, Integer.valueOf(paramInt2), Integer.valueOf(2) };
/*      */ 
/* 3082 */     this.param.add(paramInt1 - 1, arrayOfObject);
/*      */   }
/*      */ 
/*      */   public void setTime(int paramInt, Time paramTime, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 3097 */     checkParamIndex(paramInt);
/* 3098 */     Object[] arrayOfObject = { paramTime, paramCalendar };
/* 3099 */     this.param.add(paramInt - 1, arrayOfObject);
/*      */   }
/*      */ 
/*      */   public void setTimestamp(int paramInt, Timestamp paramTimestamp, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 3114 */     checkParamIndex(paramInt);
/* 3115 */     Object[] arrayOfObject = { paramTimestamp, paramCalendar };
/* 3116 */     this.param.add(paramInt - 1, arrayOfObject);
/*      */   }
/*      */ 
/*      */   public void setTimestamp(int paramInt, Timestamp paramTimestamp)
/*      */     throws SQLException
/*      */   {
/* 3130 */     checkParamIndex(paramInt);
/* 3131 */     this.param.add(paramInt - 1, paramTimestamp);
/*      */   }
/*      */ 
/*      */   public void setAsciiStream(int paramInt1, InputStream paramInputStream, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 3146 */     checkParamIndex(paramInt1);
/* 3147 */     Object[] arrayOfObject = { paramInputStream, Integer.valueOf(paramInt2), Integer.valueOf(3) };
/*      */ 
/* 3149 */     this.param.add(paramInt1 - 1, arrayOfObject);
/*      */   }
/*      */ 
/*      */   public void setUnicodeStream(int paramInt1, InputStream paramInputStream, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 3164 */     checkParamIndex(paramInt1);
/* 3165 */     Object[] arrayOfObject = { paramInputStream, Integer.valueOf(paramInt2), Integer.valueOf(1) };
/*      */ 
/* 3167 */     this.param.add(paramInt1 - 1, arrayOfObject);
/*      */   }
/*      */ 
/*      */   public void setCharacterStream(int paramInt1, Reader paramReader, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 3182 */     checkParamIndex(paramInt1);
/* 3183 */     Object[] arrayOfObject = { paramReader, Integer.valueOf(paramInt2), Integer.valueOf(4) };
/*      */ 
/* 3185 */     this.param.add(paramInt1 - 1, arrayOfObject);
/*      */   }
/*      */ 
/*      */   public void setObject(int paramInt1, Object paramObject, int paramInt2, int paramInt3)
/*      */     throws SQLException
/*      */   {
/* 3200 */     checkParamIndex(paramInt1);
/* 3201 */     Object[] arrayOfObject = { paramObject, Integer.valueOf(paramInt2), Integer.valueOf(paramInt3) };
/* 3202 */     this.param.add(paramInt1 - 1, arrayOfObject);
/*      */   }
/*      */ 
/*      */   public void setObject(int paramInt1, Object paramObject, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 3217 */     checkParamIndex(paramInt1);
/* 3218 */     Object[] arrayOfObject = { paramObject, Integer.valueOf(paramInt2) };
/* 3219 */     this.param.add(paramInt1 - 1, arrayOfObject);
/*      */   }
/*      */ 
/*      */   public void setDate(int paramInt, java.sql.Date paramDate, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 3234 */     checkParamIndex(paramInt);
/* 3235 */     Object[] arrayOfObject = { paramDate, paramCalendar };
/* 3236 */     this.param.add(paramInt - 1, arrayOfObject);
/*      */   }
/*      */ 
/*      */   public void setURL(int paramInt, URL paramURL)
/*      */     throws SQLException
/*      */   {
/* 3251 */     checkParamIndex(paramInt);
/* 3252 */     this.param.add(paramInt - 1, paramURL.toString());
/*      */   }
/*      */ 
/*      */   public synchronized Object getObject(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3277 */     int i = this.presentRow * this.colCount + paramInt - 1;
/* 3278 */     Object localObject = null;
/*      */ 
/* 3280 */     if (!isUpdated(paramInt))
/* 3281 */       localObject = getCurrentRow().getColumn(paramInt);
/*      */     else
/* 3283 */       localObject = getCurrentRow().getModifiedColumn(paramInt);
/* 3284 */     this.previousColumnWasNull = (localObject == null);
/*      */ 
/* 3286 */     return localObject;
/*      */   }
/*      */ 
/*      */   private synchronized Number getNumber(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3301 */     Object localObject = getObject(paramInt);
/*      */ 
/* 3303 */     if ((localObject == null) || ((localObject instanceof BigDecimal)) || ((localObject instanceof Number)))
/*      */     {
/* 3306 */       return (Number)localObject;
/*      */     }
/* 3308 */     if ((localObject instanceof Boolean)) {
/* 3309 */       return Integer.valueOf(((Boolean)localObject).booleanValue() ? 1 : 0);
/*      */     }
/* 3311 */     if ((localObject instanceof String))
/*      */     {
/*      */       try
/*      */       {
/* 3315 */         return new BigDecimal((String)localObject);
/*      */       }
/*      */       catch (NumberFormatException localNumberFormatException)
/*      */       {
/* 3320 */         SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59);
/* 3321 */         localSQLException2.fillInStackTrace();
/* 3322 */         throw localSQLException2;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 3329 */     SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59);
/* 3330 */     localSQLException1.fillInStackTrace();
/* 3331 */     throw localSQLException1;
/*      */   }
/*      */ 
/*      */   public Object getObject(int paramInt, Map paramMap)
/*      */     throws SQLException
/*      */   {
/* 3348 */     return getObject(paramInt);
/*      */   }
/*      */ 
/*      */   public boolean getBoolean(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3362 */     Object localObject1 = getObject(paramInt);
/*      */ 
/* 3364 */     if (localObject1 == null) {
/* 3365 */       return false;
/*      */     }
/* 3367 */     if ((localObject1 instanceof Boolean)) {
/* 3368 */       return ((Boolean)localObject1).booleanValue();
/*      */     }
/* 3370 */     if ((localObject1 instanceof Number)) {
/* 3371 */       return ((Number)localObject1).doubleValue() != 0.0D;
/*      */     }
/*      */ 
/* 3379 */     if ((localObject1 instanceof String))
/*      */     {
/* 3381 */       localObject2 = ((String)localObject1).trim();
/*      */ 
/* 3383 */       if (((String)localObject2).equals("1")) {
/* 3384 */         return true;
/*      */       }
/* 3386 */       if (((String)localObject2).equals("0")) {
/* 3387 */         return false;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 3392 */     Object localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59);
/* 3393 */     ((SQLException)localObject2).fillInStackTrace();
/* 3394 */     throw ((Throwable)localObject2);
/*      */   }
/*      */ 
/*      */   public byte getByte(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3414 */     Object localObject1 = getObject(paramInt);
/*      */ 
/* 3416 */     if (localObject1 == null) {
/* 3417 */       return 0;
/*      */     }
/* 3419 */     if ((localObject1 instanceof BigDecimal))
/*      */     {
/* 3421 */       localObject2 = (BigDecimal)localObject1;
/* 3422 */       if ((((BigDecimal)localObject2).compareTo(new BigDecimal(127)) == 1) || (((BigDecimal)localObject2).compareTo(new BigDecimal(-128)) == -1))
/*      */       {
/* 3425 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 26);
/* 3426 */         localSQLException.fillInStackTrace();
/* 3427 */         throw localSQLException;
/*      */       }
/*      */ 
/* 3430 */       return ((BigDecimal)localObject2).byteValue();
/*      */     }
/*      */ 
/* 3433 */     if ((localObject1 instanceof Number)) {
/* 3434 */       return ((Number)localObject1).byteValue();
/*      */     }
/* 3436 */     if ((localObject1 instanceof String)) {
/* 3437 */       return ((String)localObject1).getBytes()[0];
/*      */     }
/* 3439 */     if ((localObject1 instanceof OracleSerialBlob))
/*      */     {
/* 3441 */       localObject2 = (OracleSerialBlob)localObject1;
/* 3442 */       return localObject2.getBytes(1L, 1)[0];
/*      */     }
/* 3444 */     if ((localObject1 instanceof OracleSerialClob))
/*      */     {
/* 3446 */       localObject2 = (OracleSerialClob)localObject1;
/* 3447 */       return localObject2.getSubString(1L, 1).getBytes()[0];
/*      */     }
/*      */ 
/* 3451 */     Object localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59);
/* 3452 */     ((SQLException)localObject2).fillInStackTrace();
/* 3453 */     throw ((Throwable)localObject2);
/*      */   }
/*      */ 
/*      */   public short getShort(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3469 */     Number localNumber = getNumber(paramInt);
/*      */ 
/* 3471 */     return localNumber == null ? 0 : localNumber.shortValue();
/*      */   }
/*      */ 
/*      */   public int getInt(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3485 */     Number localNumber = getNumber(paramInt);
/*      */ 
/* 3487 */     return localNumber == null ? 0 : localNumber.intValue();
/*      */   }
/*      */ 
/*      */   public long getLong(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3501 */     Number localNumber = getNumber(paramInt);
/*      */ 
/* 3503 */     return localNumber == null ? 0L : localNumber.longValue();
/*      */   }
/*      */ 
/*      */   public float getFloat(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3517 */     Number localNumber = getNumber(paramInt);
/*      */ 
/* 3519 */     return localNumber == null ? 0.0F : localNumber.floatValue();
/*      */   }
/*      */ 
/*      */   public double getDouble(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3533 */     Number localNumber = getNumber(paramInt);
/*      */ 
/* 3535 */     return localNumber == null ? 0.0D : localNumber.doubleValue();
/*      */   }
/*      */ 
/*      */   public BigDecimal getBigDecimal(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3549 */     Number localNumber = getNumber(paramInt);
/*      */ 
/* 3551 */     if ((localNumber == null) || ((localNumber instanceof BigDecimal))) {
/* 3552 */       return (BigDecimal)localNumber;
/*      */     }
/* 3554 */     return new BigDecimal(localNumber.doubleValue());
/*      */   }
/*      */ 
/*      */   public BigDecimal getBigDecimal(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 3569 */     return getBigDecimal(paramInt1);
/*      */   }
/*      */ 
/*      */   public java.sql.Date getDate(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3583 */     Object localObject1 = getObject(paramInt);
/*      */ 
/* 3585 */     if (localObject1 == null) {
/* 3586 */       return (java.sql.Date)localObject1;
/*      */     }
/* 3588 */     if ((localObject1 instanceof Time))
/*      */     {
/* 3590 */       localObject2 = (Time)localObject1;
/* 3591 */       return new java.sql.Date(((Time)localObject2).getTime());
/*      */     }
/*      */ 
/* 3594 */     if ((localObject1 instanceof java.util.Date))
/*      */     {
/* 3596 */       localObject2 = (java.util.Date)localObject1;
/* 3597 */       return new java.sql.Date(((java.util.Date)localObject2).getYear(), ((java.util.Date)localObject2).getMonth(), ((java.util.Date)localObject2).getDate());
/*      */     }
/*      */ 
/* 3600 */     if ((localObject1 instanceof TIMESTAMP)) {
/* 3601 */       return ((TIMESTAMP)localObject1).dateValue();
/*      */     }
/* 3603 */     if ((localObject1 instanceof TIMESTAMPTZ)) {
/* 3604 */       return ((TIMESTAMPTZ)localObject1).dateValue(getConnectionInternal());
/*      */     }
/* 3606 */     if ((localObject1 instanceof TIMESTAMPLTZ))
/*      */     {
/* 3608 */       localObject2 = getConnectionInternal();
/*      */ 
/* 3610 */       return ((TIMESTAMPLTZ)localObject1).dateValue((Connection)localObject2, getSessionCalendar((Connection)localObject2));
/*      */     }
/*      */ 
/* 3614 */     Object localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/* 3615 */     ((SQLException)localObject2).fillInStackTrace();
/* 3616 */     throw ((Throwable)localObject2);
/*      */   }
/*      */ 
/*      */   public java.sql.Date getDate(int paramInt, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 3632 */     return getDate(paramInt);
/*      */   }
/*      */ 
/*      */   public Time getTime(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3647 */     Object localObject1 = getObject(paramInt);
/*      */ 
/* 3649 */     if (localObject1 == null) {
/* 3650 */       return (Time)localObject1;
/*      */     }
/* 3652 */     if ((localObject1 instanceof java.util.Date))
/*      */     {
/* 3654 */       localObject2 = (java.util.Date)localObject1;
/* 3655 */       return new Time(((java.util.Date)localObject2).getHours(), ((java.util.Date)localObject2).getMinutes(), ((java.util.Date)localObject2).getSeconds());
/*      */     }
/*      */ 
/* 3659 */     if ((localObject1 instanceof TIMESTAMP)) {
/* 3660 */       return ((TIMESTAMP)localObject1).timeValue();
/*      */     }
/* 3662 */     if ((localObject1 instanceof TIMESTAMPTZ)) {
/* 3663 */       return ((TIMESTAMPTZ)localObject1).timeValue(getConnectionInternal());
/*      */     }
/* 3665 */     if ((localObject1 instanceof TIMESTAMPLTZ))
/*      */     {
/* 3667 */       localObject2 = getConnectionInternal();
/*      */ 
/* 3669 */       return ((TIMESTAMPLTZ)localObject1).timeValue((Connection)localObject2, getSessionCalendar((Connection)localObject2));
/*      */     }
/*      */ 
/* 3673 */     Object localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/* 3674 */     ((SQLException)localObject2).fillInStackTrace();
/* 3675 */     throw ((Throwable)localObject2);
/*      */   }
/*      */ 
/*      */   public Time getTime(int paramInt, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 3691 */     return getTime(paramInt);
/*      */   }
/*      */ 
/*      */   public Timestamp getTimestamp(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3705 */     Object localObject1 = getObject(paramInt);
/*      */ 
/* 3707 */     if ((localObject1 == null) || ((localObject1 instanceof Timestamp))) {
/* 3708 */       return (Timestamp)localObject1;
/*      */     }
/* 3710 */     if ((localObject1 instanceof java.util.Date)) {
/* 3711 */       return new Timestamp(((java.util.Date)localObject1).getTime());
/*      */     }
/* 3713 */     if ((localObject1 instanceof TIMESTAMP)) {
/* 3714 */       return ((TIMESTAMP)localObject1).timestampValue();
/*      */     }
/* 3716 */     if ((localObject1 instanceof TIMESTAMPTZ)) {
/* 3717 */       return ((TIMESTAMPTZ)localObject1).timestampValue(getConnectionInternal());
/*      */     }
/* 3719 */     if ((localObject1 instanceof TIMESTAMPLTZ))
/*      */     {
/* 3721 */       localObject2 = getConnectionInternal();
/*      */ 
/* 3723 */       return ((TIMESTAMPLTZ)localObject1).timestampValue((Connection)localObject2, getSessionCalendar((Connection)localObject2));
/*      */     }
/*      */ 
/* 3727 */     Object localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/* 3728 */     ((SQLException)localObject2).fillInStackTrace();
/* 3729 */     throw ((Throwable)localObject2);
/*      */   }
/*      */ 
/*      */   public Timestamp getTimestamp(int paramInt, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 3745 */     return getTimestamp(paramInt);
/*      */   }
/*      */ 
/*      */   public byte[] getBytes(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3759 */     Object localObject1 = getObject(paramInt);
/*      */ 
/* 3761 */     if (localObject1 == null) {
/* 3762 */       return (byte[])localObject1;
/*      */     }
/* 3764 */     if ((localObject1 instanceof byte[])) {
/* 3765 */       return (byte[])localObject1;
/*      */     }
/* 3767 */     if ((localObject1 instanceof String)) {
/* 3768 */       return (byte[])((String)localObject1).getBytes();
/*      */     }
/* 3770 */     if ((localObject1 instanceof Number)) {
/* 3771 */       return (byte[])((Number)localObject1).toString().getBytes();
/*      */     }
/* 3773 */     if ((localObject1 instanceof BigDecimal)) {
/* 3774 */       return (byte[])((BigDecimal)localObject1).toString().getBytes();
/*      */     }
/* 3776 */     if ((localObject1 instanceof OracleSerialBlob))
/*      */     {
/* 3778 */       localObject2 = (OracleSerialBlob)localObject1;
/* 3779 */       return ((OracleSerialBlob)localObject2).getBytes(1L, (int)((OracleSerialBlob)localObject2).length());
/*      */     }
/* 3781 */     if ((localObject1 instanceof OracleSerialClob))
/*      */     {
/* 3783 */       localObject2 = (OracleSerialClob)localObject1;
/* 3784 */       return ((OracleSerialClob)localObject2).getSubString(1L, (int)((OracleSerialClob)localObject2).length()).getBytes();
/*      */     }
/*      */ 
/* 3788 */     Object localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59);
/* 3789 */     ((SQLException)localObject2).fillInStackTrace();
/* 3790 */     throw ((Throwable)localObject2);
/*      */   }
/*      */ 
/*      */   public Ref getRef(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3806 */     Object localObject = getObject(paramInt);
/*      */ 
/* 3808 */     if ((localObject == null) || ((localObject instanceof Ref))) {
/* 3809 */       return (Ref)localObject;
/*      */     }
/*      */ 
/* 3812 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/* 3813 */     localSQLException.fillInStackTrace();
/* 3814 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public Blob getBlob(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3830 */     Object localObject = getObject(paramInt);
/*      */ 
/* 3832 */     if ((localObject == null) || ((localObject instanceof OracleSerialBlob))) {
/* 3833 */       return (Blob)localObject;
/*      */     }
/*      */ 
/* 3836 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/* 3837 */     localSQLException.fillInStackTrace();
/* 3838 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public Clob getClob(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3854 */     Object localObject = getObject(paramInt);
/*      */ 
/* 3856 */     if ((localObject == null) || ((localObject instanceof OracleSerialClob))) {
/* 3857 */       return (Clob)localObject;
/*      */     }
/*      */ 
/* 3860 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/* 3861 */     localSQLException.fillInStackTrace();
/* 3862 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public Array getArray(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3878 */     Object localObject = getObject(paramInt);
/*      */ 
/* 3880 */     if ((localObject == null) || ((localObject instanceof Array))) {
/* 3881 */       return (Array)localObject;
/*      */     }
/*      */ 
/* 3884 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/* 3885 */     localSQLException.fillInStackTrace();
/* 3886 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public String getString(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3901 */     Object localObject1 = getObject(paramInt);
/*      */ 
/* 3903 */     if (localObject1 == null) {
/* 3904 */       return (String)localObject1;
/*      */     }
/* 3906 */     if ((localObject1 instanceof String)) {
/* 3907 */       return (String)localObject1;
/*      */     }
/* 3909 */     if (((localObject1 instanceof Number)) || ((localObject1 instanceof BigDecimal))) {
/* 3910 */       return localObject1.toString();
/*      */     }
/* 3912 */     if ((localObject1 instanceof java.sql.Date)) {
/* 3913 */       return localObject1.toString();
/*      */     }
/* 3915 */     if ((localObject1 instanceof Timestamp)) {
/* 3916 */       return localObject1.toString();
/*      */     }
/* 3918 */     if ((localObject1 instanceof byte[]))
/* 3919 */       return new String((byte[])localObject1);
/*      */     Object localObject2;
/* 3921 */     if ((localObject1 instanceof OracleSerialClob))
/*      */     {
/* 3923 */       localObject2 = (OracleSerialClob)localObject1;
/* 3924 */       return ((OracleSerialClob)localObject2).getSubString(1L, (int)((OracleSerialClob)localObject2).length());
/*      */     }
/*      */ 
/* 3927 */     if ((localObject1 instanceof OracleSerialBlob))
/*      */     {
/* 3929 */       localObject2 = (OracleSerialBlob)localObject1;
/* 3930 */       return new String(((OracleSerialBlob)localObject2).getBytes(1L, (int)((OracleSerialBlob)localObject2).length()));
/*      */     }
/*      */ 
/* 3934 */     if ((localObject1 instanceof URL)) {
/* 3935 */       return ((URL)localObject1).toString();
/*      */     }
/* 3937 */     if ((localObject1 instanceof ROWID)) {
/* 3938 */       return ((ROWID)localObject1).stringValue();
/*      */     }
/* 3940 */     if ((localObject1 instanceof Reader))
/*      */     {
/*      */       try
/*      */       {
/* 3944 */         localObject2 = (Reader)localObject1;
/* 3945 */         localObject3 = new char[1024];
/* 3946 */         int i = 0;
/* 3947 */         StringBuffer localStringBuffer = new StringBuffer(1024);
/* 3948 */         while ((i = ((Reader)localObject2).read((char[])localObject3)) > 0)
/* 3949 */           localStringBuffer.append((char[])localObject3, 0, i);
/* 3950 */         return localStringBuffer.substring(0, localStringBuffer.length());
/*      */       }
/*      */       catch (IOException localIOException)
/*      */       {
/* 3955 */         Object localObject3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 321, localIOException.getMessage());
/* 3956 */         ((SQLException)localObject3).fillInStackTrace();
/* 3957 */         throw ((Throwable)localObject3);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 3963 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59);
/* 3964 */     localSQLException.fillInStackTrace();
/* 3965 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public InputStream getAsciiStream(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3981 */     InputStream localInputStream = getStream(paramInt);
/*      */ 
/* 3983 */     return localInputStream == null ? null : localInputStream;
/*      */   }
/*      */ 
/*      */   public InputStream getUnicodeStream(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3997 */     Object localObject = getObject(paramInt);
/*      */ 
/* 3999 */     if (localObject == null) {
/* 4000 */       return (InputStream)localObject;
/*      */     }
/*      */ 
/* 4003 */     if ((localObject instanceof String)) {
/* 4004 */       return new StringBufferInputStream((String)localObject);
/*      */     }
/*      */ 
/* 4007 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59);
/* 4008 */     localSQLException.fillInStackTrace();
/* 4009 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public InputStream getBinaryStream(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 4026 */     InputStream localInputStream = getStream(paramInt);
/*      */ 
/* 4028 */     return localInputStream == null ? null : localInputStream;
/*      */   }
/*      */ 
/*      */   public synchronized Reader getCharacterStream(int paramInt)
/*      */     throws SQLException
/*      */   {
/*      */     Object localObject;
/*      */     try
/*      */     {
/* 4045 */       InputStream localInputStream = getAsciiStream(paramInt);
/*      */ 
/* 4047 */       if (localInputStream == null) {
/* 4048 */         return null;
/*      */       }
/* 4050 */       localObject = new StringBuffer();
/* 4051 */       int i = 0;
/* 4052 */       while ((i = localInputStream.read()) != -1) {
/* 4053 */         ((StringBuffer)localObject).append((char)i);
/*      */       }
/*      */ 
/* 4057 */       char[] arrayOfChar = new char[((StringBuffer)localObject).length()];
/* 4058 */       ((StringBuffer)localObject).getChars(0, ((StringBuffer)localObject).length(), arrayOfChar, 0);
/* 4059 */       CharArrayReader localCharArrayReader = new CharArrayReader(arrayOfChar);
/* 4060 */       arrayOfChar = null;
/*      */ 
/* 4062 */       return localCharArrayReader;
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 4067 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 322);
/* 4068 */       ((SQLException)localObject).fillInStackTrace();
/* 4069 */     }throw ((Throwable)localObject);
/*      */   }
/*      */ 
/*      */   public synchronized Object getObject(String paramString)
/*      */     throws SQLException
/*      */   {
/* 4091 */     return getObject(getColumnIndex(paramString));
/*      */   }
/*      */ 
/*      */   public boolean getBoolean(String paramString)
/*      */     throws SQLException
/*      */   {
/* 4105 */     return getBoolean(getColumnIndex(paramString));
/*      */   }
/*      */ 
/*      */   public byte getByte(String paramString)
/*      */     throws SQLException
/*      */   {
/* 4119 */     return getByte(getColumnIndex(paramString));
/*      */   }
/*      */ 
/*      */   public short getShort(String paramString)
/*      */     throws SQLException
/*      */   {
/* 4133 */     return getShort(getColumnIndex(paramString));
/*      */   }
/*      */ 
/*      */   public int getInt(String paramString)
/*      */     throws SQLException
/*      */   {
/* 4147 */     return getInt(getColumnIndex(paramString));
/*      */   }
/*      */ 
/*      */   public long getLong(String paramString)
/*      */     throws SQLException
/*      */   {
/* 4161 */     return getLong(getColumnIndex(paramString));
/*      */   }
/*      */ 
/*      */   public float getFloat(String paramString)
/*      */     throws SQLException
/*      */   {
/* 4175 */     return getFloat(getColumnIndex(paramString));
/*      */   }
/*      */ 
/*      */   public double getDouble(String paramString)
/*      */     throws SQLException
/*      */   {
/* 4189 */     return getDouble(getColumnIndex(paramString));
/*      */   }
/*      */ 
/*      */   public BigDecimal getBigDecimal(String paramString, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 4203 */     return getBigDecimal(getColumnIndex(paramString), paramInt);
/*      */   }
/*      */ 
/*      */   public byte[] getBytes(String paramString)
/*      */     throws SQLException
/*      */   {
/* 4217 */     return getBytes(getColumnIndex(paramString));
/*      */   }
/*      */ 
/*      */   public java.sql.Date getDate(String paramString)
/*      */     throws SQLException
/*      */   {
/* 4231 */     return getDate(getColumnIndex(paramString));
/*      */   }
/*      */ 
/*      */   public Time getTime(String paramString)
/*      */     throws SQLException
/*      */   {
/* 4245 */     return getTime(getColumnIndex(paramString));
/*      */   }
/*      */ 
/*      */   public Timestamp getTimestamp(String paramString)
/*      */     throws SQLException
/*      */   {
/* 4259 */     return getTimestamp(getColumnIndex(paramString));
/*      */   }
/*      */ 
/*      */   public Time getTime(String paramString, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 4273 */     return getTime(getColumnIndex(paramString), paramCalendar);
/*      */   }
/*      */ 
/*      */   public java.sql.Date getDate(String paramString, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 4287 */     return getDate(getColumnIndex(paramString), paramCalendar);
/*      */   }
/*      */ 
/*      */   public InputStream getAsciiStream(String paramString)
/*      */     throws SQLException
/*      */   {
/* 4301 */     return getAsciiStream(getColumnIndex(paramString));
/*      */   }
/*      */ 
/*      */   public InputStream getUnicodeStream(String paramString)
/*      */     throws SQLException
/*      */   {
/* 4315 */     return getUnicodeStream(getColumnIndex(paramString));
/*      */   }
/*      */ 
/*      */   public String getString(String paramString)
/*      */     throws SQLException
/*      */   {
/* 4329 */     return getString(getColumnIndex(paramString));
/*      */   }
/*      */ 
/*      */   public InputStream getBinaryStream(String paramString)
/*      */     throws SQLException
/*      */   {
/* 4343 */     return getBinaryStream(getColumnIndex(paramString));
/*      */   }
/*      */ 
/*      */   public Reader getCharacterStream(String paramString)
/*      */     throws SQLException
/*      */   {
/* 4357 */     return getCharacterStream(getColumnIndex(paramString));
/*      */   }
/*      */ 
/*      */   public BigDecimal getBigDecimal(String paramString)
/*      */     throws SQLException
/*      */   {
/* 4371 */     return getBigDecimal(getColumnIndex(paramString));
/*      */   }
/*      */ 
/*      */   public Timestamp getTimestamp(String paramString, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 4385 */     return getTimestamp(getColumnIndex(paramString), paramCalendar);
/*      */   }
/*      */ 
/*      */   public Object getObject(String paramString, Map paramMap)
/*      */     throws SQLException
/*      */   {
/* 4398 */     return getObject(getColumnIndex(paramString), paramMap);
/*      */   }
/*      */ 
/*      */   public Ref getRef(String paramString)
/*      */     throws SQLException
/*      */   {
/* 4412 */     return getRef(getColumnIndex(paramString));
/*      */   }
/*      */ 
/*      */   public Blob getBlob(String paramString)
/*      */     throws SQLException
/*      */   {
/* 4426 */     return getBlob(getColumnIndex(paramString));
/*      */   }
/*      */ 
/*      */   public Clob getClob(String paramString)
/*      */     throws SQLException
/*      */   {
/* 4440 */     return getClob(getColumnIndex(paramString));
/*      */   }
/*      */ 
/*      */   public Array getArray(String paramString)
/*      */     throws SQLException
/*      */   {
/* 4454 */     return getArray(getColumnIndex(paramString));
/*      */   }
/*      */ 
/*      */   public void updateObject(int paramInt, Object paramObject)
/*      */     throws SQLException
/*      */   {
/* 4473 */     updateObject(paramInt, paramObject, (long[])null);
/*      */   }
/*      */ 
/*      */   protected synchronized void updateObject(int paramInt, Object paramObject, long[] paramArrayOfLong)
/*      */     throws SQLException
/*      */   {
/* 4496 */     checkColumnIndex(paramInt);
/* 4497 */     if (this.insertRowFlag)
/*      */     {
/* 4499 */       checkAndFilterObject(paramInt, paramObject);
/* 4500 */       this.insertRow.updateObject(paramInt, paramObject, paramArrayOfLong);
/*      */     }
/* 4502 */     else if ((!isBeforeFirst()) && (!isAfterLast()))
/*      */     {
/* 4506 */       this.updateRowFlag = true;
/* 4507 */       this.updateRowPosition = this.presentRow;
/* 4508 */       getCurrentRow().updateObject(paramInt, paramObject, paramArrayOfLong);
/*      */     }
/*      */     else {
/* 4511 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 90);
/* 4512 */       localSQLException.fillInStackTrace();
/* 4513 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateNull(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 4529 */     updateObject(paramInt, null);
/*      */   }
/*      */ 
/*      */   public void updateCharacterStream(int paramInt1, Reader paramReader, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 4545 */     updateCharacterStreamInternal(paramInt1, paramReader, paramInt2, false, true);
/*      */   }
/*      */ 
/*      */   synchronized void updateCharacterStreamInternal(int paramInt, Reader paramReader, long paramLong, boolean paramBoolean1, boolean paramBoolean2)
/*      */     throws SQLException
/*      */   {
/* 4556 */     checkColumnIndex(paramInt);
/*      */ 
/* 4558 */     if (paramLong < 0L)
/*      */     {
/* 4560 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 4561 */       localSQLException1.fillInStackTrace();
/* 4562 */       throw localSQLException1;
/*      */     }
/*      */ 
/* 4565 */     int i = getMetaData().getColumnType(paramInt);
/*      */     Object localObject;
/* 4566 */     if (!isStreamType(i))
/*      */     {
/* 4569 */       if ((paramBoolean2) && (paramLong > 2147483647L))
/*      */       {
/* 4571 */         SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 4572 */         localSQLException2.fillInStackTrace();
/* 4573 */         throw localSQLException2;
/*      */       }
/*      */       try
/*      */       {
/* 4577 */         int j = 0;
/* 4578 */         int m = paramBoolean2 ? (int)paramLong : 2147483647;
/* 4579 */         char[] arrayOfChar = new char[1024];
/* 4580 */         StringBuilder localStringBuilder = new StringBuilder(1024);
/*      */ 
/* 4582 */         while (m > 0)
/*      */         {
/* 4584 */           if (m >= 1024)
/* 4585 */             j = paramReader.read(arrayOfChar);
/*      */           else {
/* 4587 */             j = paramReader.read(arrayOfChar, 0, m);
/*      */           }
/*      */ 
/* 4591 */           if (j == -1) {
/*      */             break;
/*      */           }
/* 4594 */           localStringBuilder.append(arrayOfChar, 0, j);
/* 4595 */           m -= j;
/*      */         }
/*      */ 
/* 4598 */         paramReader.close();
/* 4599 */         if (m == paramLong)
/*      */         {
/* 4601 */           updateNull(paramInt);
/* 4602 */           return;
/*      */         }
/*      */ 
/* 4605 */         updateString(paramInt, localStringBuilder.toString());
/*      */       }
/*      */       catch (IOException localIOException)
/*      */       {
/* 4610 */         localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 4611 */         ((SQLException)localObject).fillInStackTrace();
/* 4612 */         throw ((Throwable)localObject);
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*      */       int k;
/* 4619 */       if (paramBoolean2) {
/* 4620 */         k = paramBoolean1 ? 4 : 3;
/*      */       }
/*      */       else
/*      */       {
/* 4624 */         k = paramBoolean1 ? 8 : 7;
/*      */       }
/*      */ 
/* 4628 */       localObject = new long[] { paramLong, k };
/*      */ 
/* 4630 */       updateObject(paramInt, paramReader, (long[])localObject);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateCharacterStream(String paramString, Reader paramReader, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 4646 */     updateCharacterStream(getColumnIndex(paramString), paramReader, paramInt);
/*      */   }
/*      */ 
/*      */   public void updateTimestamp(String paramString, Timestamp paramTimestamp)
/*      */     throws SQLException
/*      */   {
/* 4661 */     updateTimestamp(getColumnIndex(paramString), paramTimestamp);
/*      */   }
/*      */ 
/*      */   public void updateBinaryStream(String paramString, InputStream paramInputStream, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 4676 */     updateBinaryStream(getColumnIndex(paramString), paramInputStream, paramInt, true);
/*      */   }
/*      */ 
/*      */   public void updateBinaryStream(int paramInt1, InputStream paramInputStream, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 4691 */     updateBinaryStream(paramInt1, paramInputStream, paramInt2, true);
/*      */   }
/*      */ 
/*      */   synchronized void updateBinaryStream(int paramInt, InputStream paramInputStream, long paramLong, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 4701 */     checkColumnIndex(paramInt);
/*      */ 
/* 4703 */     if (paramLong < 0L)
/*      */     {
/* 4705 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 4706 */       localSQLException1.fillInStackTrace();
/* 4707 */       throw localSQLException1;
/*      */     }
/*      */ 
/* 4710 */     int i = getMetaData().getColumnType(paramInt);
/* 4711 */     if (!isStreamType(i))
/*      */     {
/* 4713 */       if ((paramBoolean) && (paramLong > 2147483647L))
/*      */       {
/* 4715 */         SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 4716 */         localSQLException2.fillInStackTrace();
/* 4717 */         throw localSQLException2;
/*      */       }
/*      */       try
/*      */       {
/* 4721 */         int j = 0;
/* 4722 */         int k = paramBoolean ? (int)paramLong : 2147483647;
/* 4723 */         byte[] arrayOfByte = new byte[1024];
/* 4724 */         ByteArrayOutputStream localByteArrayOutputStream = new ByteArrayOutputStream(1024);
/*      */ 
/* 4727 */         while (k > 0)
/*      */         {
/* 4729 */           if (k >= 1024)
/* 4730 */             j = paramInputStream.read(arrayOfByte);
/*      */           else {
/* 4732 */             j = paramInputStream.read(arrayOfByte, 0, k);
/*      */           }
/*      */ 
/* 4736 */           if (j == -1) {
/*      */             break;
/*      */           }
/* 4739 */           localByteArrayOutputStream.write(arrayOfByte, 0, j);
/* 4740 */           k -= j;
/*      */         }
/*      */ 
/* 4743 */         paramInputStream.close();
/* 4744 */         if (k == paramLong)
/*      */         {
/* 4746 */           updateNull(paramInt);
/* 4747 */           return;
/*      */         }
/*      */ 
/* 4750 */         updateBytes(paramInt, localByteArrayOutputStream.toByteArray());
/*      */       }
/*      */       catch (IOException localIOException)
/*      */       {
/* 4755 */         SQLException localSQLException3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 4756 */         localSQLException3.fillInStackTrace();
/* 4757 */         throw localSQLException3;
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 4763 */       long[] arrayOfLong = { paramLong, 0L };
/*      */ 
/* 4765 */       arrayOfLong[1] = (paramBoolean ? 2 : 6);
/*      */ 
/* 4768 */       updateObject(paramInt, paramInputStream, arrayOfLong);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateAsciiStream(int paramInt1, InputStream paramInputStream, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 4783 */     updateAsciiStream(paramInt1, paramInputStream, paramInt2, true);
/*      */   }
/*      */ 
/*      */   synchronized void updateAsciiStream(int paramInt, InputStream paramInputStream, long paramLong, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 4793 */     checkColumnIndex(paramInt);
/*      */ 
/* 4795 */     if (paramLong < 0L)
/*      */     {
/* 4797 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 4798 */       localSQLException1.fillInStackTrace();
/* 4799 */       throw localSQLException1;
/*      */     }
/*      */ 
/* 4802 */     int i = getMetaData().getColumnType(paramInt);
/* 4803 */     if (!isStreamType(i))
/*      */     {
/* 4805 */       if ((paramBoolean) && (paramLong > 2147483647L))
/*      */       {
/* 4807 */         SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 4808 */         localSQLException2.fillInStackTrace();
/* 4809 */         throw localSQLException2;
/*      */       }
/*      */       try
/*      */       {
/* 4813 */         int j = 0;
/* 4814 */         int k = paramBoolean ? (int)paramLong : 2147483647;
/* 4815 */         byte[] arrayOfByte = new byte[1024];
/* 4816 */         char[] arrayOfChar = new char[1024];
/* 4817 */         StringBuilder localStringBuilder = new StringBuilder(1024);
/*      */ 
/* 4819 */         while (k > 0)
/*      */         {
/* 4821 */           if (k >= 1024)
/* 4822 */             j = paramInputStream.read(arrayOfByte);
/*      */           else {
/* 4824 */             j = paramInputStream.read(arrayOfByte, 0, k);
/*      */           }
/*      */ 
/* 4828 */           if (j == -1) {
/*      */             break;
/*      */           }
/* 4831 */           DBConversion.asciiBytesToJavaChars(arrayOfByte, j, arrayOfChar);
/*      */ 
/* 4833 */           localStringBuilder.append(arrayOfChar, 0, j);
/* 4834 */           k -= j;
/*      */         }
/*      */ 
/* 4837 */         paramInputStream.close();
/* 4838 */         if (k == paramLong)
/*      */         {
/* 4840 */           updateNull(paramInt);
/* 4841 */           return;
/*      */         }
/*      */ 
/* 4844 */         updateString(paramInt, localStringBuilder.toString());
/*      */       }
/*      */       catch (IOException localIOException)
/*      */       {
/* 4849 */         SQLException localSQLException3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 4850 */         localSQLException3.fillInStackTrace();
/* 4851 */         throw localSQLException3;
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 4857 */       long[] arrayOfLong = { paramLong, 0L };
/*      */ 
/* 4859 */       arrayOfLong[1] = (paramBoolean ? 1 : 5);
/*      */ 
/* 4863 */       updateObject(paramInt, paramInputStream, arrayOfLong);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateTimestamp(int paramInt, Timestamp paramTimestamp)
/*      */     throws SQLException
/*      */   {
/* 4879 */     updateObject(paramInt, paramTimestamp);
/*      */   }
/*      */ 
/*      */   public void updateBoolean(int paramInt, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 4894 */     updateObject(paramInt, Boolean.valueOf(paramBoolean));
/*      */   }
/*      */ 
/*      */   public void updateByte(int paramInt, byte paramByte)
/*      */     throws SQLException
/*      */   {
/* 4909 */     updateObject(paramInt, new Byte(paramByte));
/*      */   }
/*      */ 
/*      */   public void updateShort(int paramInt, short paramShort)
/*      */     throws SQLException
/*      */   {
/* 4924 */     updateObject(paramInt, Short.valueOf(paramShort));
/*      */   }
/*      */ 
/*      */   public void updateInt(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 4939 */     updateObject(paramInt1, Integer.valueOf(paramInt2));
/*      */   }
/*      */ 
/*      */   public void updateLong(int paramInt, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 4954 */     updateObject(paramInt, Long.valueOf(paramLong));
/*      */   }
/*      */ 
/*      */   public void updateFloat(int paramInt, float paramFloat)
/*      */     throws SQLException
/*      */   {
/* 4969 */     updateObject(paramInt, Float.valueOf(paramFloat));
/*      */   }
/*      */ 
/*      */   public void updateDouble(int paramInt, double paramDouble)
/*      */     throws SQLException
/*      */   {
/* 4984 */     updateObject(paramInt, Double.valueOf(paramDouble));
/*      */   }
/*      */ 
/*      */   public void updateBigDecimal(int paramInt, BigDecimal paramBigDecimal)
/*      */     throws SQLException
/*      */   {
/* 4999 */     updateObject(paramInt, paramBigDecimal);
/*      */   }
/*      */ 
/*      */   public void updateString(int paramInt, String paramString)
/*      */     throws SQLException
/*      */   {
/* 5014 */     updateObject(paramInt, paramString);
/*      */   }
/*      */ 
/*      */   public void updateBytes(int paramInt, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 5029 */     updateObject(paramInt, paramArrayOfByte);
/*      */   }
/*      */ 
/*      */   public void updateDate(int paramInt, java.sql.Date paramDate)
/*      */     throws SQLException
/*      */   {
/* 5044 */     updateObject(paramInt, paramDate);
/*      */   }
/*      */ 
/*      */   public void updateTime(int paramInt, Time paramTime)
/*      */     throws SQLException
/*      */   {
/* 5059 */     updateObject(paramInt, new Timestamp(0, 0, 0, paramTime.getHours(), paramTime.getMinutes(), paramTime.getSeconds(), 0));
/*      */   }
/*      */ 
/*      */   public void updateObject(int paramInt1, Object paramObject, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 5076 */     if (!(paramObject instanceof Number))
/*      */     {
/* 5078 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 323);
/* 5079 */       localSQLException.fillInStackTrace();
/* 5080 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5083 */     updateObject(paramInt1, new BigDecimal(new BigInteger(((Number)paramObject).toString()), paramInt2));
/*      */   }
/*      */ 
/*      */   public void updateNull(String paramString)
/*      */     throws SQLException
/*      */   {
/* 5104 */     updateNull(getColumnIndex(paramString));
/*      */   }
/*      */ 
/*      */   public void updateAsciiStream(String paramString, InputStream paramInputStream, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 5119 */     updateAsciiStream(getColumnIndex(paramString), paramInputStream, paramInt, true);
/*      */   }
/*      */ 
/*      */   public void updateBoolean(String paramString, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 5134 */     updateBoolean(getColumnIndex(paramString), paramBoolean);
/*      */   }
/*      */ 
/*      */   public void updateByte(String paramString, byte paramByte)
/*      */     throws SQLException
/*      */   {
/* 5149 */     updateByte(getColumnIndex(paramString), paramByte);
/*      */   }
/*      */ 
/*      */   public void updateShort(String paramString, short paramShort)
/*      */     throws SQLException
/*      */   {
/* 5164 */     updateShort(getColumnIndex(paramString), paramShort);
/*      */   }
/*      */ 
/*      */   public void updateInt(String paramString, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 5179 */     updateInt(getColumnIndex(paramString), paramInt);
/*      */   }
/*      */ 
/*      */   public void updateLong(String paramString, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 5194 */     updateLong(getColumnIndex(paramString), paramLong);
/*      */   }
/*      */ 
/*      */   public void updateFloat(String paramString, float paramFloat)
/*      */     throws SQLException
/*      */   {
/* 5209 */     updateFloat(getColumnIndex(paramString), paramFloat);
/*      */   }
/*      */ 
/*      */   public void updateDouble(String paramString, double paramDouble)
/*      */     throws SQLException
/*      */   {
/* 5224 */     updateDouble(getColumnIndex(paramString), paramDouble);
/*      */   }
/*      */ 
/*      */   public void updateBigDecimal(String paramString, BigDecimal paramBigDecimal)
/*      */     throws SQLException
/*      */   {
/* 5239 */     updateBigDecimal(getColumnIndex(paramString), paramBigDecimal);
/*      */   }
/*      */ 
/*      */   public void updateString(String paramString1, String paramString2)
/*      */     throws SQLException
/*      */   {
/* 5254 */     updateString(getColumnIndex(paramString1), paramString2);
/*      */   }
/*      */ 
/*      */   public void updateBytes(String paramString, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 5269 */     updateBytes(getColumnIndex(paramString), paramArrayOfByte);
/*      */   }
/*      */ 
/*      */   public void updateDate(String paramString, java.sql.Date paramDate)
/*      */     throws SQLException
/*      */   {
/* 5284 */     updateDate(getColumnIndex(paramString), paramDate);
/*      */   }
/*      */ 
/*      */   public void updateTime(String paramString, Time paramTime)
/*      */     throws SQLException
/*      */   {
/* 5299 */     updateTime(getColumnIndex(paramString), paramTime);
/*      */   }
/*      */ 
/*      */   public void updateObject(String paramString, Object paramObject)
/*      */     throws SQLException
/*      */   {
/* 5315 */     updateObject(getColumnIndex(paramString), paramObject);
/*      */   }
/*      */ 
/*      */   public void updateObject(String paramString, Object paramObject, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 5330 */     updateObject(getColumnIndex(paramString), paramObject, paramInt);
/*      */   }
/*      */ 
/*      */   public URL getURL(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 5362 */     Object localObject = getObject(paramInt);
/*      */ 
/* 5364 */     if (localObject == null) {
/* 5365 */       return (URL)localObject;
/*      */     }
/* 5367 */     if ((localObject instanceof URL)) {
/* 5368 */       return (URL)localObject;
/*      */     }
/* 5370 */     if ((localObject instanceof String))
/*      */     {
/*      */       try
/*      */       {
/* 5374 */         return new URL((String)localObject);
/*      */       }
/*      */       catch (MalformedURLException localMalformedURLException)
/*      */       {
/* 5379 */         SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 136);
/* 5380 */         localSQLException2.fillInStackTrace();
/* 5381 */         throw localSQLException2;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 5387 */     SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/* 5388 */     localSQLException1.fillInStackTrace();
/* 5389 */     throw localSQLException1;
/*      */   }
/*      */ 
/*      */   public URL getURL(String paramString)
/*      */     throws SQLException
/*      */   {
/* 5420 */     return getURL(getColumnIndex(paramString));
/*      */   }
/*      */ 
/*      */   public void updateRef(int paramInt, Ref paramRef)
/*      */     throws SQLException
/*      */   {
/* 5448 */     updateObject(paramInt, paramRef);
/*      */   }
/*      */ 
/*      */   public void updateRef(String paramString, Ref paramRef)
/*      */     throws SQLException
/*      */   {
/* 5477 */     updateRef(getColumnIndex(paramString), paramRef);
/*      */   }
/*      */ 
/*      */   public void updateBlob(int paramInt, Blob paramBlob)
/*      */     throws SQLException
/*      */   {
/* 5506 */     updateObject(paramInt, paramBlob);
/*      */   }
/*      */ 
/*      */   public void updateBlob(String paramString, Blob paramBlob)
/*      */     throws SQLException
/*      */   {
/* 5535 */     updateBlob(getColumnIndex(paramString), paramBlob);
/*      */   }
/*      */ 
/*      */   public void updateClob(int paramInt, Clob paramClob)
/*      */     throws SQLException
/*      */   {
/* 5564 */     updateObject(paramInt, paramClob);
/*      */   }
/*      */ 
/*      */   public void updateClob(String paramString, Clob paramClob)
/*      */     throws SQLException
/*      */   {
/* 5593 */     updateClob(getColumnIndex(paramString), paramClob);
/*      */   }
/*      */ 
/*      */   public void updateArray(int paramInt, Array paramArray)
/*      */     throws SQLException
/*      */   {
/* 5622 */     updateObject(paramInt, paramArray);
/*      */   }
/*      */ 
/*      */   public void updateArray(String paramString, Array paramArray)
/*      */     throws SQLException
/*      */   {
/* 5651 */     updateArray(getColumnIndex(paramString), paramArray);
/*      */   }
/*      */ 
/*      */   public int[] getKeyColumns()
/*      */     throws SQLException
/*      */   {
/* 5682 */     return this.keyColumns;
/*      */   }
/*      */ 
/*      */   public void setKeyColumns(int[] paramArrayOfInt)
/*      */     throws SQLException
/*      */   {
/* 5712 */     int i = 0;
/*      */ 
/* 5714 */     if (this.rowsetMetaData != null)
/*      */     {
/* 5716 */       i = this.rowsetMetaData.getColumnCount();
/* 5717 */       if ((paramArrayOfInt == null) || (paramArrayOfInt.length > i))
/*      */       {
/* 5720 */         SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 324);
/* 5721 */         localSQLException1.fillInStackTrace();
/* 5722 */         throw localSQLException1;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 5727 */     int j = paramArrayOfInt.length;
/* 5728 */     this.keyColumns = new int[j];
/*      */ 
/* 5730 */     for (int k = 0; k < j; k++)
/*      */     {
/* 5732 */       if ((paramArrayOfInt[k] <= 0) || (paramArrayOfInt[k] > i))
/*      */       {
/* 5735 */         SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 3, new StringBuilder().append("").append(paramArrayOfInt[k]).toString());
/* 5736 */         localSQLException2.fillInStackTrace();
/* 5737 */         throw localSQLException2;
/*      */       }
/*      */ 
/* 5741 */       this.keyColumns[k] = paramArrayOfInt[k];
/*      */     }
/*      */   }
/*      */ 
/*      */   public int getPageSize()
/*      */   {
/* 5761 */     return this.pageSize;
/*      */   }
/*      */ 
/*      */   public void setPageSize(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 5786 */     if ((paramInt < 0) || ((this.maxRows > 0) && (paramInt > this.maxRows)))
/*      */     {
/* 5790 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 325);
/* 5791 */       localSQLException.fillInStackTrace();
/* 5792 */       throw localSQLException;
/*      */     }
/*      */ 
/* 5796 */     this.pageSize = paramInt;
/*      */   }
/*      */ 
/*      */   public SyncProvider getSyncProvider()
/*      */     throws SQLException
/*      */   {
/* 5819 */     return this.syncProvider;
/*      */   }
/*      */ 
/*      */   public void setSyncProvider(String paramString)
/*      */     throws SQLException
/*      */   {
/* 5842 */     this.syncProvider = SyncFactory.getInstance(paramString);
/* 5843 */     this.reader = this.syncProvider.getRowSetReader();
/* 5844 */     this.writer = this.syncProvider.getRowSetWriter();
/*      */   }
/*      */ 
/*      */   public String getTableName()
/*      */     throws SQLException
/*      */   {
/* 5869 */     return this.tableName;
/*      */   }
/*      */ 
/*      */   public void setTableName(String paramString)
/*      */     throws SQLException
/*      */   {
/* 5893 */     this.tableName = paramString;
/*      */   }
/*      */ 
/*      */   public CachedRowSet createCopyNoConstraints()
/*      */     throws SQLException
/*      */   {
/* 5926 */     OracleCachedRowSet localOracleCachedRowSet = (OracleCachedRowSet)createCopy();
/*      */ 
/* 5930 */     localOracleCachedRowSet.initializeProperties();
/*      */ 
/* 5933 */     localOracleCachedRowSet.listener = new Vector();
/*      */     try
/*      */     {
/* 5937 */       localOracleCachedRowSet.unsetMatchColumn(localOracleCachedRowSet.getMatchColumnIndexes());
/* 5938 */       localOracleCachedRowSet.unsetMatchColumn(localOracleCachedRowSet.getMatchColumnNames());
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/*      */     }
/*      */ 
/* 5944 */     return localOracleCachedRowSet;
/*      */   }
/*      */ 
/*      */   public CachedRowSet createCopySchema()
/*      */     throws SQLException
/*      */   {
/* 5972 */     OracleCachedRowSet localOracleCachedRowSet = (OracleCachedRowSet)createCopy();
/*      */ 
/* 5975 */     localOracleCachedRowSet.rows = null;
/* 5976 */     localOracleCachedRowSet.rowCount = 0;
/* 5977 */     localOracleCachedRowSet.currentPage = 0;
/*      */ 
/* 5979 */     return localOracleCachedRowSet;
/*      */   }
/*      */ 
/*      */   public boolean columnUpdated(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 6003 */     if (this.insertRowFlag)
/*      */     {
/* 6006 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 326);
/* 6007 */       localSQLException.fillInStackTrace();
/* 6008 */       throw localSQLException;
/*      */     }
/*      */ 
/* 6012 */     return getCurrentRow().isColumnChanged(paramInt);
/*      */   }
/*      */ 
/*      */   public boolean columnUpdated(String paramString)
/*      */     throws SQLException
/*      */   {
/* 6036 */     return columnUpdated(getColumnIndex(paramString));
/*      */   }
/*      */ 
/*      */   public synchronized void execute(Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/* 6073 */     this.connection = paramConnection;
/* 6074 */     execute();
/*      */   }
/*      */ 
/*      */   public void commit()
/*      */     throws SQLException
/*      */   {
/* 6107 */     getConnectionInternal().commit();
/*      */   }
/*      */ 
/*      */   public void rollback()
/*      */     throws SQLException
/*      */   {
/* 6132 */     getConnectionInternal().rollback();
/*      */   }
/*      */ 
/*      */   public void rollback(Savepoint paramSavepoint)
/*      */     throws SQLException
/*      */   {
/* 6159 */     getConnectionInternal().rollback(paramSavepoint);
/*      */   }
/*      */ 
/*      */   public void oracleRollback(OracleSavepoint paramOracleSavepoint)
/*      */     throws SQLException
/*      */   {
/* 6189 */     ((OracleConnection)getConnectionInternal()).oracleRollback(paramOracleSavepoint);
/*      */   }
/*      */ 
/*      */   public void setOriginalRow()
/*      */     throws SQLException
/*      */   {
/* 6216 */     if (this.insertRowFlag)
/*      */     {
/* 6219 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 327);
/* 6220 */       localSQLException.fillInStackTrace();
/* 6221 */       throw localSQLException;
/*      */     }
/*      */ 
/* 6226 */     setOriginalRowInternal(this.presentRow);
/*      */   }
/*      */ 
/*      */   public int size()
/*      */   {
/* 6246 */     return this.rowCount;
/*      */   }
/*      */ 
/*      */   public boolean nextPage()
/*      */     throws SQLException
/*      */   {
/*      */     SQLException localSQLException;
/* 6272 */     if ((this.fetchDirection == 1001) && (this.resultSet != null) && (this.resultSet.getType() == 1003))
/*      */     {
/* 6275 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 328);
/* 6276 */       localSQLException.fillInStackTrace();
/* 6277 */       throw localSQLException;
/*      */     }
/*      */ 
/* 6280 */     if ((this.rows.size() == 0) && (!this.isPopulateDone))
/*      */     {
/* 6282 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 329);
/* 6283 */       localSQLException.fillInStackTrace();
/* 6284 */       throw localSQLException;
/*      */     }
/*      */ 
/* 6287 */     if (((isExecuteCalled()) || (this.isPopulateDone)) && (this.rowCount < this.pageSize)) {
/* 6288 */       return false;
/*      */     }
/* 6290 */     if (isExecuteCalled())
/*      */     {
/* 6292 */       this.currentPage += 1;
/* 6293 */       execute();
/*      */     }
/*      */     else
/*      */     {
/* 6298 */       populate(this.resultSet);
/* 6299 */       this.currentPage += 1;
/*      */     }
/*      */ 
/* 6302 */     return !this.isPopulateDone;
/*      */   }
/*      */ 
/*      */   public boolean previousPage()
/*      */     throws SQLException
/*      */   {
/*      */     SQLException localSQLException;
/* 6328 */     if ((this.resultSet != null) && (this.resultSet.getType() == 1003))
/*      */     {
/* 6330 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 328);
/* 6331 */       localSQLException.fillInStackTrace();
/* 6332 */       throw localSQLException;
/*      */     }
/*      */ 
/* 6336 */     if ((this.rows.size() == 0) && (!this.isPopulateDone))
/*      */     {
/* 6338 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 329);
/* 6339 */       localSQLException.fillInStackTrace();
/* 6340 */       throw localSQLException;
/*      */     }
/*      */ 
/* 6343 */     if (this.currentPage == 0) {
/* 6344 */       return false;
/*      */     }
/*      */ 
/* 6348 */     if (this.fetchDirection == 1001)
/*      */     {
/* 6350 */       this.resultSet.relative(this.pageSize * 2);
/*      */     }
/*      */     else
/*      */     {
/* 6354 */       this.resultSet.relative(-2 * this.pageSize);
/*      */     }
/*      */ 
/* 6357 */     populate(this.resultSet);
/*      */ 
/* 6359 */     if (this.currentPage > 0)
/*      */     {
/* 6361 */       this.currentPage -= 1;
/*      */     }
/*      */ 
/* 6364 */     return this.currentPage != 0;
/*      */   }
/*      */ 
/*      */   public void rowSetPopulated(RowSetEvent paramRowSetEvent, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 6378 */     if ((paramInt <= 0) || (paramInt < this.fetchSize))
/*      */     {
/* 6381 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 330);
/* 6382 */       localSQLException.fillInStackTrace();
/* 6383 */       throw localSQLException;
/*      */     }
/*      */ 
/* 6387 */     if (this.rowCount % paramInt == 0)
/*      */     {
/* 6389 */       this.rowsetEvent = new RowSetEvent(this);
/* 6390 */       notifyRowSetChanged();
/*      */     }
/*      */   }
/*      */ 
/*      */   public RowSetWarning getRowSetWarnings()
/*      */     throws SQLException
/*      */   {
/* 6406 */     return this.rowsetWarning;
/*      */   }
/*      */ 
/*      */   public void populate(ResultSet paramResultSet, int paramInt)
/*      */     throws SQLException
/*      */   {
/*      */     SQLException localSQLException1;
/* 6420 */     if (paramInt < 0)
/*      */     {
/* 6422 */       localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 331);
/* 6423 */       localSQLException1.fillInStackTrace();
/* 6424 */       throw localSQLException1;
/*      */     }
/*      */ 
/* 6427 */     if (paramResultSet == null)
/*      */     {
/* 6429 */       localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 332);
/* 6430 */       localSQLException1.fillInStackTrace();
/* 6431 */       throw localSQLException1;
/*      */     }
/*      */ 
/* 6434 */     int i = paramResultSet.getType();
/*      */ 
/* 6436 */     if (i == 1003)
/*      */     {
/* 6438 */       int j = 0;
/* 6439 */       int k = 0;
/* 6440 */       while (j < paramInt)
/*      */       {
/* 6442 */         if (!paramResultSet.next())
/*      */         {
/* 6444 */           k = 1;
/* 6445 */           break;
/*      */         }
/* 6447 */         j++;
/*      */       }
/*      */ 
/* 6450 */       if ((j < paramInt) && (paramInt > 0) && (k != 0))
/*      */       {
/* 6452 */         SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 333);
/* 6453 */         localSQLException2.fillInStackTrace();
/* 6454 */         throw localSQLException2;
/*      */       }
/*      */ 
/*      */     }
/* 6459 */     else if (paramInt == 0) {
/* 6460 */       paramResultSet.beforeFirst();
/*      */     } else {
/* 6462 */       paramResultSet.absolute(paramInt);
/*      */     }
/*      */ 
/* 6465 */     populate(paramResultSet);
/*      */   }
/*      */ 
/*      */   public void undoDelete()
/*      */     throws SQLException
/*      */   {
/* 6480 */     cancelRowDelete();
/*      */   }
/*      */ 
/*      */   public void undoInsert()
/*      */     throws SQLException
/*      */   {
/* 6495 */     cancelRowInsert();
/*      */   }
/*      */ 
/*      */   public void undoUpdate()
/*      */     throws SQLException
/*      */   {
/* 6510 */     cancelRowUpdates();
/*      */   }
/*      */ 
/*      */   public Reader getNCharacterStream(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 6531 */     return getCharacterStream(paramInt);
/*      */   }
/*      */ 
/*      */   public NClob getNClob(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 6545 */     Object localObject = getObject(paramInt);
/*      */ 
/* 6547 */     if ((localObject == null) || ((localObject instanceof OracleSerialClob))) {
/* 6548 */       return (NClob)localObject;
/*      */     }
/*      */ 
/* 6551 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/* 6552 */     localSQLException.fillInStackTrace();
/* 6553 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public String getNString(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 6569 */     return getString(paramInt);
/*      */   }
/*      */ 
/*      */   public RowId getRowId(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 6583 */     Object localObject = getObject(paramInt);
/*      */ 
/* 6586 */     if ((localObject instanceof RowId)) {
/* 6587 */       return localObject == null ? null : (RowId)localObject;
/*      */     }
/*      */ 
/* 6590 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/* 6591 */     localSQLException.fillInStackTrace();
/* 6592 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public SQLXML getSQLXML(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 6608 */     Object localObject = getObject(paramInt);
/* 6609 */     if ((localObject == null) || ((localObject instanceof SQLXML))) {
/* 6610 */       return (SQLXML)localObject;
/*      */     }
/*      */ 
/* 6613 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4);
/* 6614 */     localSQLException.fillInStackTrace();
/* 6615 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public Reader getNCharacterStream(String paramString)
/*      */     throws SQLException
/*      */   {
/* 6635 */     return getNCharacterStream(getColumnIndex(paramString));
/*      */   }
/*      */ 
/*      */   public NClob getNClob(String paramString)
/*      */     throws SQLException
/*      */   {
/* 6649 */     return getNClob(getColumnIndex(paramString));
/*      */   }
/*      */ 
/*      */   public String getNString(String paramString)
/*      */     throws SQLException
/*      */   {
/* 6663 */     return getNString(getColumnIndex(paramString));
/*      */   }
/*      */ 
/*      */   public RowId getRowId(String paramString)
/*      */     throws SQLException
/*      */   {
/* 6677 */     return getRowId(getColumnIndex(paramString));
/*      */   }
/*      */ 
/*      */   public SQLXML getSQLXML(String paramString)
/*      */     throws SQLException
/*      */   {
/* 6691 */     return getSQLXML(getColumnIndex(paramString));
/*      */   }
/*      */ 
/*      */   public void setAsciiStream(int paramInt, InputStream paramInputStream)
/*      */     throws SQLException
/*      */   {
/* 6709 */     checkParamIndex(paramInt);
/* 6710 */     Object[] arrayOfObject = { paramInputStream, Integer.valueOf(7) };
/*      */ 
/* 6712 */     this.param.add(paramInt - 1, arrayOfObject);
/*      */   }
/*      */ 
/*      */   public void setAsciiStream(int paramInt, InputStream paramInputStream, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 6728 */     checkParamIndex(paramInt);
/* 6729 */     Object[] arrayOfObject = { paramInputStream, Long.valueOf(paramLong), Integer.valueOf(8) };
/*      */ 
/* 6731 */     this.param.add(paramInt - 1, arrayOfObject);
/*      */   }
/*      */ 
/*      */   public void setBinaryStream(int paramInt, InputStream paramInputStream)
/*      */     throws SQLException
/*      */   {
/* 6746 */     checkParamIndex(paramInt);
/* 6747 */     Object[] arrayOfObject = { paramInputStream, Integer.valueOf(5) };
/*      */ 
/* 6749 */     this.param.add(paramInt - 1, arrayOfObject);
/*      */   }
/*      */ 
/*      */   public void setBinaryStream(int paramInt, InputStream paramInputStream, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 6765 */     checkParamIndex(paramInt);
/* 6766 */     Object[] arrayOfObject = { paramInputStream, Long.valueOf(paramLong), Integer.valueOf(6) };
/*      */ 
/* 6768 */     this.param.add(paramInt - 1, arrayOfObject);
/*      */   }
/*      */ 
/*      */   public void setBlob(int paramInt, InputStream paramInputStream)
/*      */     throws SQLException
/*      */   {
/* 6783 */     checkParamIndex(paramInt);
/* 6784 */     Object[] arrayOfObject = { paramInputStream, Integer.valueOf(13) };
/*      */ 
/* 6786 */     this.param.add(paramInt - 1, arrayOfObject);
/*      */   }
/*      */ 
/*      */   public void setBlob(int paramInt, InputStream paramInputStream, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 6801 */     checkParamIndex(paramInt);
/* 6802 */     Object[] arrayOfObject = { paramInputStream, Long.valueOf(paramLong), Integer.valueOf(14) };
/*      */ 
/* 6804 */     this.param.add(paramInt - 1, arrayOfObject);
/*      */   }
/*      */ 
/*      */   public void setCharacterStream(int paramInt, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 6819 */     checkParamIndex(paramInt);
/* 6820 */     Object[] arrayOfObject = { paramReader, Integer.valueOf(9) };
/*      */ 
/* 6822 */     this.param.add(paramInt - 1, arrayOfObject);
/*      */   }
/*      */ 
/*      */   public void setCharacterStream(int paramInt, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 6837 */     checkParamIndex(paramInt);
/* 6838 */     Object[] arrayOfObject = { paramReader, Long.valueOf(paramLong), Integer.valueOf(10) };
/*      */ 
/* 6840 */     this.param.add(paramInt - 1, arrayOfObject);
/*      */   }
/*      */ 
/*      */   public void setClob(int paramInt, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 6855 */     checkParamIndex(paramInt);
/* 6856 */     Object[] arrayOfObject = { paramReader, Integer.valueOf(15) };
/*      */ 
/* 6858 */     this.param.add(paramInt - 1, arrayOfObject);
/*      */   }
/*      */ 
/*      */   public void setClob(int paramInt, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 6873 */     checkParamIndex(paramInt);
/* 6874 */     Object[] arrayOfObject = { this.reader, Long.valueOf(paramLong), Integer.valueOf(16) };
/*      */ 
/* 6876 */     this.param.add(paramInt - 1, arrayOfObject);
/*      */   }
/*      */ 
/*      */   public void setNCharacterStream(int paramInt, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 6891 */     checkParamIndex(paramInt);
/* 6892 */     Object[] arrayOfObject = { paramReader, Integer.valueOf(11) };
/*      */ 
/* 6894 */     this.param.add(paramInt - 1, arrayOfObject);
/*      */   }
/*      */ 
/*      */   public void setNCharacterStream(int paramInt, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 6909 */     checkParamIndex(paramInt);
/* 6910 */     Object[] arrayOfObject = { paramReader, Long.valueOf(paramLong), Integer.valueOf(12) };
/*      */ 
/* 6912 */     this.param.add(paramInt - 1, arrayOfObject);
/*      */   }
/*      */ 
/*      */   public void setNClob(int paramInt, NClob paramNClob)
/*      */     throws SQLException
/*      */   {
/* 6927 */     checkParamIndex(paramInt);
/* 6928 */     this.param.add(paramInt - 1, paramNClob);
/*      */   }
/*      */ 
/*      */   public void setNClob(int paramInt, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 6943 */     checkParamIndex(paramInt);
/* 6944 */     Object[] arrayOfObject = { this.reader, Integer.valueOf(17) };
/*      */ 
/* 6946 */     this.param.add(paramInt - 1, arrayOfObject);
/*      */   }
/*      */ 
/*      */   public void setNClob(int paramInt, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 6961 */     checkParamIndex(paramInt);
/* 6962 */     Object[] arrayOfObject = { this.reader, Long.valueOf(paramLong), Integer.valueOf(18) };
/*      */ 
/* 6964 */     this.param.add(paramInt - 1, arrayOfObject);
/*      */   }
/*      */ 
/*      */   public void setNString(int paramInt, String paramString)
/*      */     throws SQLException
/*      */   {
/* 6979 */     checkParamIndex(paramInt);
/* 6980 */     this.param.add(paramInt - 1, paramString);
/*      */   }
/*      */ 
/*      */   public void setRowId(int paramInt, RowId paramRowId)
/*      */     throws SQLException
/*      */   {
/* 6995 */     checkParamIndex(paramInt);
/* 6996 */     this.param.add(paramInt - 1, paramRowId);
/*      */   }
/*      */ 
/*      */   public void setSQLXML(int paramInt, SQLXML paramSQLXML)
/*      */     throws SQLException
/*      */   {
/* 7011 */     checkParamIndex(paramInt);
/* 7012 */     this.param.add(paramInt - 1, paramSQLXML);
/*      */   }
/*      */ 
/*      */   public void setArray(String paramString, Array paramArray)
/*      */     throws SQLException
/*      */   {
/* 7036 */     String str = paramString.intern();
/* 7037 */     String[] arrayOfString = this.osql.getParameterList();
/* 7038 */     int i = 0;
/* 7039 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 7041 */     for (int k = 0; k < j; k++) {
/* 7042 */       if (arrayOfString[k] == str)
/*      */       {
/* 7044 */         setArray(k + 1, paramArray);
/*      */ 
/* 7046 */         i = 1;
/*      */       }
/*      */     }
/* 7049 */     if (i == 0)
/*      */     {
/* 7051 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 7052 */       localSQLException.fillInStackTrace();
/* 7053 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setBigDecimal(String paramString, BigDecimal paramBigDecimal)
/*      */     throws SQLException
/*      */   {
/* 7070 */     String str = paramString.intern();
/* 7071 */     String[] arrayOfString = this.osql.getParameterList();
/* 7072 */     int i = 0;
/* 7073 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 7075 */     for (int k = 0; k < j; k++) {
/* 7076 */       if (arrayOfString[k] == str)
/*      */       {
/* 7078 */         setBigDecimal(k + 1, paramBigDecimal);
/*      */ 
/* 7080 */         i = 1;
/*      */       }
/*      */     }
/* 7083 */     if (i == 0)
/*      */     {
/* 7085 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 7086 */       localSQLException.fillInStackTrace();
/* 7087 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setBlob(String paramString, Blob paramBlob)
/*      */     throws SQLException
/*      */   {
/* 7104 */     String str = paramString.intern();
/* 7105 */     String[] arrayOfString = this.osql.getParameterList();
/* 7106 */     int i = 0;
/* 7107 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 7109 */     for (int k = 0; k < j; k++) {
/* 7110 */       if (arrayOfString[k] == str)
/*      */       {
/* 7112 */         setBlob(k + 1, paramBlob);
/*      */ 
/* 7114 */         i = 1;
/*      */       }
/*      */     }
/* 7117 */     if (i == 0)
/*      */     {
/* 7119 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 7120 */       localSQLException.fillInStackTrace();
/* 7121 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setBoolean(String paramString, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 7138 */     String str = paramString.intern();
/* 7139 */     String[] arrayOfString = this.osql.getParameterList();
/* 7140 */     int i = 0;
/* 7141 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 7143 */     for (int k = 0; k < j; k++) {
/* 7144 */       if (arrayOfString[k] == str)
/*      */       {
/* 7146 */         setBoolean(k + 1, paramBoolean);
/*      */ 
/* 7148 */         i = 1;
/*      */       }
/*      */     }
/* 7151 */     if (i == 0)
/*      */     {
/* 7153 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 7154 */       localSQLException.fillInStackTrace();
/* 7155 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setByte(String paramString, byte paramByte)
/*      */     throws SQLException
/*      */   {
/* 7172 */     String str = paramString.intern();
/* 7173 */     String[] arrayOfString = this.osql.getParameterList();
/* 7174 */     int i = 0;
/* 7175 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 7177 */     for (int k = 0; k < j; k++) {
/* 7178 */       if (arrayOfString[k] == str)
/*      */       {
/* 7180 */         setByte(k + 1, paramByte);
/*      */ 
/* 7182 */         i = 1;
/*      */       }
/*      */     }
/* 7185 */     if (i == 0)
/*      */     {
/* 7187 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 7188 */       localSQLException.fillInStackTrace();
/* 7189 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setBytes(String paramString, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 7206 */     String str = paramString.intern();
/* 7207 */     String[] arrayOfString = this.osql.getParameterList();
/* 7208 */     int i = 0;
/* 7209 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 7211 */     for (int k = 0; k < j; k++) {
/* 7212 */       if (arrayOfString[k] == str)
/*      */       {
/* 7214 */         setBytes(k + 1, paramArrayOfByte);
/*      */ 
/* 7216 */         i = 1;
/*      */       }
/*      */     }
/* 7219 */     if (i == 0)
/*      */     {
/* 7221 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 7222 */       localSQLException.fillInStackTrace();
/* 7223 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setClob(String paramString, Clob paramClob)
/*      */     throws SQLException
/*      */   {
/* 7240 */     String str = paramString.intern();
/* 7241 */     String[] arrayOfString = this.osql.getParameterList();
/* 7242 */     int i = 0;
/* 7243 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 7245 */     for (int k = 0; k < j; k++) {
/* 7246 */       if (arrayOfString[k] == str)
/*      */       {
/* 7248 */         setClob(k + 1, paramClob);
/*      */ 
/* 7250 */         i = 1;
/*      */       }
/*      */     }
/* 7253 */     if (i == 0)
/*      */     {
/* 7255 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 7256 */       localSQLException.fillInStackTrace();
/* 7257 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setDate(String paramString, java.sql.Date paramDate)
/*      */     throws SQLException
/*      */   {
/* 7274 */     String str = paramString.intern();
/* 7275 */     String[] arrayOfString = this.osql.getParameterList();
/* 7276 */     int i = 0;
/* 7277 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 7279 */     for (int k = 0; k < j; k++) {
/* 7280 */       if (arrayOfString[k] == str)
/*      */       {
/* 7282 */         setDate(k + 1, paramDate);
/*      */ 
/* 7284 */         i = 1;
/*      */       }
/*      */     }
/* 7287 */     if (i == 0)
/*      */     {
/* 7289 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 7290 */       localSQLException.fillInStackTrace();
/* 7291 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setDate(String paramString, java.sql.Date paramDate, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 7308 */     String str = paramString.intern();
/* 7309 */     String[] arrayOfString = this.osql.getParameterList();
/* 7310 */     int i = 0;
/* 7311 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 7313 */     for (int k = 0; k < j; k++) {
/* 7314 */       if (arrayOfString[k] == str)
/*      */       {
/* 7316 */         setDate(k + 1, paramDate, paramCalendar);
/*      */ 
/* 7318 */         i = 1;
/*      */       }
/*      */     }
/* 7321 */     if (i == 0)
/*      */     {
/* 7323 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 7324 */       localSQLException.fillInStackTrace();
/* 7325 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setDouble(String paramString, double paramDouble)
/*      */     throws SQLException
/*      */   {
/* 7342 */     String str = paramString.intern();
/* 7343 */     String[] arrayOfString = this.osql.getParameterList();
/* 7344 */     int i = 0;
/* 7345 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 7347 */     for (int k = 0; k < j; k++) {
/* 7348 */       if (arrayOfString[k] == str)
/*      */       {
/* 7350 */         setDouble(k + 1, paramDouble);
/*      */ 
/* 7352 */         i = 1;
/*      */       }
/*      */     }
/* 7355 */     if (i == 0)
/*      */     {
/* 7357 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 7358 */       localSQLException.fillInStackTrace();
/* 7359 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setFloat(String paramString, float paramFloat)
/*      */     throws SQLException
/*      */   {
/* 7376 */     String str = paramString.intern();
/* 7377 */     String[] arrayOfString = this.osql.getParameterList();
/* 7378 */     int i = 0;
/* 7379 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 7381 */     for (int k = 0; k < j; k++) {
/* 7382 */       if (arrayOfString[k] == str)
/*      */       {
/* 7384 */         setFloat(k + 1, paramFloat);
/*      */ 
/* 7386 */         i = 1;
/*      */       }
/*      */     }
/* 7389 */     if (i == 0)
/*      */     {
/* 7391 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 7392 */       localSQLException.fillInStackTrace();
/* 7393 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setInt(String paramString, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 7410 */     String str = paramString.intern();
/* 7411 */     String[] arrayOfString = this.osql.getParameterList();
/* 7412 */     int i = 0;
/* 7413 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 7415 */     for (int k = 0; k < j; k++) {
/* 7416 */       if (arrayOfString[k] == str)
/*      */       {
/* 7418 */         setInt(k + 1, paramInt);
/*      */ 
/* 7420 */         i = 1;
/*      */       }
/*      */     }
/* 7423 */     if (i == 0)
/*      */     {
/* 7425 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 7426 */       localSQLException.fillInStackTrace();
/* 7427 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setLong(String paramString, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 7444 */     String str = paramString.intern();
/* 7445 */     String[] arrayOfString = this.osql.getParameterList();
/* 7446 */     int i = 0;
/* 7447 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 7449 */     for (int k = 0; k < j; k++) {
/* 7450 */       if (arrayOfString[k] == str)
/*      */       {
/* 7452 */         setLong(k + 1, paramLong);
/*      */ 
/* 7454 */         i = 1;
/*      */       }
/*      */     }
/* 7457 */     if (i == 0)
/*      */     {
/* 7459 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 7460 */       localSQLException.fillInStackTrace();
/* 7461 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setNClob(String paramString, NClob paramNClob)
/*      */     throws SQLException
/*      */   {
/* 7478 */     String str = paramString.intern();
/* 7479 */     String[] arrayOfString = this.osql.getParameterList();
/* 7480 */     int i = 0;
/* 7481 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 7483 */     for (int k = 0; k < j; k++) {
/* 7484 */       if (arrayOfString[k] == str)
/*      */       {
/* 7486 */         setNClob(k + 1, paramNClob);
/*      */ 
/* 7488 */         i = 1;
/*      */       }
/*      */     }
/* 7491 */     if (i == 0)
/*      */     {
/* 7493 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 7494 */       localSQLException.fillInStackTrace();
/* 7495 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setNString(String paramString1, String paramString2)
/*      */     throws SQLException
/*      */   {
/* 7512 */     String str = paramString1.intern();
/* 7513 */     String[] arrayOfString = this.osql.getParameterList();
/* 7514 */     int i = 0;
/* 7515 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 7517 */     for (int k = 0; k < j; k++) {
/* 7518 */       if (arrayOfString[k] == str)
/*      */       {
/* 7520 */         setNString(k + 1, paramString2);
/*      */ 
/* 7522 */         i = 1;
/*      */       }
/*      */     }
/* 7525 */     if (i == 0)
/*      */     {
/* 7527 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString1);
/* 7528 */       localSQLException.fillInStackTrace();
/* 7529 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setObject(String paramString, Object paramObject)
/*      */     throws SQLException
/*      */   {
/* 7546 */     String str = paramString.intern();
/* 7547 */     String[] arrayOfString = this.osql.getParameterList();
/* 7548 */     int i = 0;
/* 7549 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 7551 */     for (int k = 0; k < j; k++) {
/* 7552 */       if (arrayOfString[k] == str)
/*      */       {
/* 7554 */         setObject(k + 1, paramObject);
/*      */ 
/* 7556 */         i = 1;
/*      */       }
/*      */     }
/* 7559 */     if (i == 0)
/*      */     {
/* 7561 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 7562 */       localSQLException.fillInStackTrace();
/* 7563 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setObject(String paramString, Object paramObject, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 7580 */     String str = paramString.intern();
/* 7581 */     String[] arrayOfString = this.osql.getParameterList();
/* 7582 */     int i = 0;
/* 7583 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 7585 */     for (int k = 0; k < j; k++) {
/* 7586 */       if (arrayOfString[k] == str)
/*      */       {
/* 7588 */         setObject(k + 1, paramObject, paramInt);
/*      */ 
/* 7590 */         i = 1;
/*      */       }
/*      */     }
/* 7593 */     if (i == 0)
/*      */     {
/* 7595 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 7596 */       localSQLException.fillInStackTrace();
/* 7597 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setRef(String paramString, Ref paramRef)
/*      */     throws SQLException
/*      */   {
/* 7614 */     String str = paramString.intern();
/* 7615 */     String[] arrayOfString = this.osql.getParameterList();
/* 7616 */     int i = 0;
/* 7617 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 7619 */     for (int k = 0; k < j; k++) {
/* 7620 */       if (arrayOfString[k] == str)
/*      */       {
/* 7622 */         setRef(k + 1, paramRef);
/*      */ 
/* 7624 */         i = 1;
/*      */       }
/*      */     }
/* 7627 */     if (i == 0)
/*      */     {
/* 7629 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 7630 */       localSQLException.fillInStackTrace();
/* 7631 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setRowId(String paramString, RowId paramRowId)
/*      */     throws SQLException
/*      */   {
/* 7648 */     String str = paramString.intern();
/* 7649 */     String[] arrayOfString = this.osql.getParameterList();
/* 7650 */     int i = 0;
/* 7651 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 7653 */     for (int k = 0; k < j; k++) {
/* 7654 */       if (arrayOfString[k] == str)
/*      */       {
/* 7656 */         setRowId(k + 1, paramRowId);
/*      */ 
/* 7658 */         i = 1;
/*      */       }
/*      */     }
/* 7661 */     if (i == 0)
/*      */     {
/* 7663 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 7664 */       localSQLException.fillInStackTrace();
/* 7665 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setShort(String paramString, short paramShort)
/*      */     throws SQLException
/*      */   {
/* 7682 */     String str = paramString.intern();
/* 7683 */     String[] arrayOfString = this.osql.getParameterList();
/* 7684 */     int i = 0;
/* 7685 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 7687 */     for (int k = 0; k < j; k++) {
/* 7688 */       if (arrayOfString[k] == str)
/*      */       {
/* 7690 */         setShort(k + 1, paramShort);
/*      */ 
/* 7692 */         i = 1;
/*      */       }
/*      */     }
/* 7695 */     if (i == 0)
/*      */     {
/* 7697 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 7698 */       localSQLException.fillInStackTrace();
/* 7699 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setSQLXML(String paramString, SQLXML paramSQLXML)
/*      */     throws SQLException
/*      */   {
/* 7716 */     String str = paramString.intern();
/* 7717 */     String[] arrayOfString = this.osql.getParameterList();
/* 7718 */     int i = 0;
/* 7719 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 7721 */     for (int k = 0; k < j; k++) {
/* 7722 */       if (arrayOfString[k] == str)
/*      */       {
/* 7724 */         setSQLXML(k + 1, paramSQLXML);
/*      */ 
/* 7726 */         i = 1;
/*      */       }
/*      */     }
/* 7729 */     if (i == 0)
/*      */     {
/* 7731 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 7732 */       localSQLException.fillInStackTrace();
/* 7733 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setString(String paramString1, String paramString2)
/*      */     throws SQLException
/*      */   {
/* 7750 */     String str = paramString1.intern();
/* 7751 */     String[] arrayOfString = this.osql.getParameterList();
/* 7752 */     int i = 0;
/* 7753 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 7755 */     for (int k = 0; k < j; k++) {
/* 7756 */       if (arrayOfString[k] == str)
/*      */       {
/* 7758 */         setString(k + 1, paramString2);
/*      */ 
/* 7760 */         i = 1;
/*      */       }
/*      */     }
/* 7763 */     if (i == 0)
/*      */     {
/* 7765 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString1);
/* 7766 */       localSQLException.fillInStackTrace();
/* 7767 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setTime(String paramString, Time paramTime)
/*      */     throws SQLException
/*      */   {
/* 7784 */     String str = paramString.intern();
/* 7785 */     String[] arrayOfString = this.osql.getParameterList();
/* 7786 */     int i = 0;
/* 7787 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 7789 */     for (int k = 0; k < j; k++) {
/* 7790 */       if (arrayOfString[k] == str)
/*      */       {
/* 7792 */         setTime(k + 1, paramTime);
/*      */ 
/* 7794 */         i = 1;
/*      */       }
/*      */     }
/* 7797 */     if (i == 0)
/*      */     {
/* 7799 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 7800 */       localSQLException.fillInStackTrace();
/* 7801 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setTime(String paramString, Time paramTime, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 7818 */     String str = paramString.intern();
/* 7819 */     String[] arrayOfString = this.osql.getParameterList();
/* 7820 */     int i = 0;
/* 7821 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 7823 */     for (int k = 0; k < j; k++) {
/* 7824 */       if (arrayOfString[k] == str)
/*      */       {
/* 7826 */         setTime(k + 1, paramTime, paramCalendar);
/*      */ 
/* 7828 */         i = 1;
/*      */       }
/*      */     }
/* 7831 */     if (i == 0)
/*      */     {
/* 7833 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 7834 */       localSQLException.fillInStackTrace();
/* 7835 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setTimestamp(String paramString, Timestamp paramTimestamp)
/*      */     throws SQLException
/*      */   {
/* 7852 */     String str = paramString.intern();
/* 7853 */     String[] arrayOfString = this.osql.getParameterList();
/* 7854 */     int i = 0;
/* 7855 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 7857 */     for (int k = 0; k < j; k++) {
/* 7858 */       if (arrayOfString[k] == str)
/*      */       {
/* 7860 */         setTimestamp(k + 1, paramTimestamp);
/*      */ 
/* 7862 */         i = 1;
/*      */       }
/*      */     }
/* 7865 */     if (i == 0)
/*      */     {
/* 7867 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 7868 */       localSQLException.fillInStackTrace();
/* 7869 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setTimestamp(String paramString, Timestamp paramTimestamp, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 7886 */     String str = paramString.intern();
/* 7887 */     String[] arrayOfString = this.osql.getParameterList();
/* 7888 */     int i = 0;
/* 7889 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 7891 */     for (int k = 0; k < j; k++) {
/* 7892 */       if (arrayOfString[k] == str)
/*      */       {
/* 7894 */         setTimestamp(k + 1, paramTimestamp, paramCalendar);
/*      */ 
/* 7896 */         i = 1;
/*      */       }
/*      */     }
/* 7899 */     if (i == 0)
/*      */     {
/* 7901 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 7902 */       localSQLException.fillInStackTrace();
/* 7903 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setURL(String paramString, URL paramURL)
/*      */     throws SQLException
/*      */   {
/* 7920 */     String str = paramString.intern();
/* 7921 */     String[] arrayOfString = this.osql.getParameterList();
/* 7922 */     int i = 0;
/* 7923 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 7925 */     for (int k = 0; k < j; k++) {
/* 7926 */       if (arrayOfString[k] == str)
/*      */       {
/* 7928 */         setURL(k + 1, paramURL);
/*      */ 
/* 7930 */         i = 1;
/*      */       }
/*      */     }
/* 7933 */     if (i == 0)
/*      */     {
/* 7935 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 7936 */       localSQLException.fillInStackTrace();
/* 7937 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setBlob(String paramString, InputStream paramInputStream)
/*      */     throws SQLException
/*      */   {
/* 7954 */     String str = paramString.intern();
/* 7955 */     String[] arrayOfString = this.osql.getParameterList();
/* 7956 */     int i = 0;
/* 7957 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 7959 */     for (int k = 0; k < j; k++) {
/* 7960 */       if (arrayOfString[k] == str)
/*      */       {
/* 7962 */         setBlob(k + 1, paramInputStream);
/*      */ 
/* 7964 */         i = 1;
/*      */       }
/*      */     }
/* 7967 */     if (i == 0)
/*      */     {
/* 7969 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 7970 */       localSQLException.fillInStackTrace();
/* 7971 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setBlob(String paramString, InputStream paramInputStream, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 7988 */     String str = paramString.intern();
/* 7989 */     String[] arrayOfString = this.osql.getParameterList();
/* 7990 */     int i = 0;
/* 7991 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 7993 */     for (int k = 0; k < j; k++) {
/* 7994 */       if (arrayOfString[k] == str)
/*      */       {
/* 7996 */         setBlob(k + 1, paramInputStream, paramLong);
/*      */ 
/* 7998 */         i = 1;
/*      */       }
/*      */     }
/* 8001 */     if (i == 0)
/*      */     {
/* 8003 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 8004 */       localSQLException.fillInStackTrace();
/* 8005 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setClob(String paramString, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 8022 */     String str = paramString.intern();
/* 8023 */     String[] arrayOfString = this.osql.getParameterList();
/* 8024 */     int i = 0;
/* 8025 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 8027 */     for (int k = 0; k < j; k++) {
/* 8028 */       if (arrayOfString[k] == str)
/*      */       {
/* 8030 */         setClob(k + 1, paramReader);
/*      */ 
/* 8032 */         i = 1;
/*      */       }
/*      */     }
/* 8035 */     if (i == 0)
/*      */     {
/* 8037 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 8038 */       localSQLException.fillInStackTrace();
/* 8039 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setClob(String paramString, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 8056 */     String str = paramString.intern();
/* 8057 */     String[] arrayOfString = this.osql.getParameterList();
/* 8058 */     int i = 0;
/* 8059 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 8061 */     for (int k = 0; k < j; k++) {
/* 8062 */       if (arrayOfString[k] == str)
/*      */       {
/* 8064 */         setClob(k + 1, paramReader, paramLong);
/*      */ 
/* 8066 */         i = 1;
/*      */       }
/*      */     }
/* 8069 */     if (i == 0)
/*      */     {
/* 8071 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 8072 */       localSQLException.fillInStackTrace();
/* 8073 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setNClob(String paramString, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 8090 */     String str = paramString.intern();
/* 8091 */     String[] arrayOfString = this.osql.getParameterList();
/* 8092 */     int i = 0;
/* 8093 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 8095 */     for (int k = 0; k < j; k++) {
/* 8096 */       if (arrayOfString[k] == str)
/*      */       {
/* 8098 */         setNClob(k + 1, paramReader);
/*      */ 
/* 8100 */         i = 1;
/*      */       }
/*      */     }
/* 8103 */     if (i == 0)
/*      */     {
/* 8105 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 8106 */       localSQLException.fillInStackTrace();
/* 8107 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setNClob(String paramString, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 8124 */     String str = paramString.intern();
/* 8125 */     String[] arrayOfString = this.osql.getParameterList();
/* 8126 */     int i = 0;
/* 8127 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 8129 */     for (int k = 0; k < j; k++) {
/* 8130 */       if (arrayOfString[k] == str)
/*      */       {
/* 8132 */         setNClob(k + 1, paramReader, paramLong);
/*      */ 
/* 8134 */         i = 1;
/*      */       }
/*      */     }
/* 8137 */     if (i == 0)
/*      */     {
/* 8139 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 8140 */       localSQLException.fillInStackTrace();
/* 8141 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setAsciiStream(String paramString, InputStream paramInputStream)
/*      */     throws SQLException
/*      */   {
/* 8158 */     String str = paramString.intern();
/* 8159 */     String[] arrayOfString = this.osql.getParameterList();
/* 8160 */     int i = 0;
/* 8161 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 8163 */     for (int k = 0; k < j; k++) {
/* 8164 */       if (arrayOfString[k] == str)
/*      */       {
/* 8166 */         setAsciiStream(k + 1, paramInputStream);
/*      */ 
/* 8168 */         i = 1;
/*      */       }
/*      */     }
/* 8171 */     if (i == 0)
/*      */     {
/* 8173 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 8174 */       localSQLException.fillInStackTrace();
/* 8175 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setAsciiStream(String paramString, InputStream paramInputStream, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 8192 */     String str = paramString.intern();
/* 8193 */     String[] arrayOfString = this.osql.getParameterList();
/* 8194 */     int i = 0;
/* 8195 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 8197 */     for (int k = 0; k < j; k++) {
/* 8198 */       if (arrayOfString[k] == str)
/*      */       {
/* 8200 */         setAsciiStream(k + 1, paramInputStream, paramInt);
/*      */ 
/* 8202 */         i = 1;
/*      */       }
/*      */     }
/* 8205 */     if (i == 0)
/*      */     {
/* 8207 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 8208 */       localSQLException.fillInStackTrace();
/* 8209 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setAsciiStream(String paramString, InputStream paramInputStream, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 8226 */     String str = paramString.intern();
/* 8227 */     String[] arrayOfString = this.osql.getParameterList();
/* 8228 */     int i = 0;
/* 8229 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 8231 */     for (int k = 0; k < j; k++) {
/* 8232 */       if (arrayOfString[k] == str)
/*      */       {
/* 8234 */         setAsciiStream(k + 1, paramInputStream, paramLong);
/*      */ 
/* 8236 */         i = 1;
/*      */       }
/*      */     }
/* 8239 */     if (i == 0)
/*      */     {
/* 8241 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 8242 */       localSQLException.fillInStackTrace();
/* 8243 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setBinaryStream(String paramString, InputStream paramInputStream)
/*      */     throws SQLException
/*      */   {
/* 8260 */     String str = paramString.intern();
/* 8261 */     String[] arrayOfString = this.osql.getParameterList();
/* 8262 */     int i = 0;
/* 8263 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 8265 */     for (int k = 0; k < j; k++) {
/* 8266 */       if (arrayOfString[k] == str)
/*      */       {
/* 8268 */         setBinaryStream(k + 1, paramInputStream);
/*      */ 
/* 8270 */         i = 1;
/*      */       }
/*      */     }
/* 8273 */     if (i == 0)
/*      */     {
/* 8275 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 8276 */       localSQLException.fillInStackTrace();
/* 8277 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setBinaryStream(String paramString, InputStream paramInputStream, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 8294 */     String str = paramString.intern();
/* 8295 */     String[] arrayOfString = this.osql.getParameterList();
/* 8296 */     int i = 0;
/* 8297 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 8299 */     for (int k = 0; k < j; k++) {
/* 8300 */       if (arrayOfString[k] == str)
/*      */       {
/* 8302 */         setBinaryStream(k + 1, paramInputStream, paramInt);
/*      */ 
/* 8304 */         i = 1;
/*      */       }
/*      */     }
/* 8307 */     if (i == 0)
/*      */     {
/* 8309 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 8310 */       localSQLException.fillInStackTrace();
/* 8311 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setBinaryStream(String paramString, InputStream paramInputStream, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 8328 */     String str = paramString.intern();
/* 8329 */     String[] arrayOfString = this.osql.getParameterList();
/* 8330 */     int i = 0;
/* 8331 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 8333 */     for (int k = 0; k < j; k++) {
/* 8334 */       if (arrayOfString[k] == str)
/*      */       {
/* 8336 */         setBinaryStream(k + 1, paramInputStream, paramLong);
/*      */ 
/* 8338 */         i = 1;
/*      */       }
/*      */     }
/* 8341 */     if (i == 0)
/*      */     {
/* 8343 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 8344 */       localSQLException.fillInStackTrace();
/* 8345 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setCharacterStream(String paramString, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 8362 */     String str = paramString.intern();
/* 8363 */     String[] arrayOfString = this.osql.getParameterList();
/* 8364 */     int i = 0;
/* 8365 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 8367 */     for (int k = 0; k < j; k++) {
/* 8368 */       if (arrayOfString[k] == str)
/*      */       {
/* 8370 */         setCharacterStream(k + 1, paramReader);
/*      */ 
/* 8372 */         i = 1;
/*      */       }
/*      */     }
/* 8375 */     if (i == 0)
/*      */     {
/* 8377 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 8378 */       localSQLException.fillInStackTrace();
/* 8379 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setCharacterStream(String paramString, Reader paramReader, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 8396 */     String str = paramString.intern();
/* 8397 */     String[] arrayOfString = this.osql.getParameterList();
/* 8398 */     int i = 0;
/* 8399 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 8401 */     for (int k = 0; k < j; k++) {
/* 8402 */       if (arrayOfString[k] == str)
/*      */       {
/* 8404 */         setCharacterStream(k + 1, paramReader, paramInt);
/*      */ 
/* 8406 */         i = 1;
/*      */       }
/*      */     }
/* 8409 */     if (i == 0)
/*      */     {
/* 8411 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 8412 */       localSQLException.fillInStackTrace();
/* 8413 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setCharacterStream(String paramString, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 8430 */     String str = paramString.intern();
/* 8431 */     String[] arrayOfString = this.osql.getParameterList();
/* 8432 */     int i = 0;
/* 8433 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 8435 */     for (int k = 0; k < j; k++) {
/* 8436 */       if (arrayOfString[k] == str)
/*      */       {
/* 8438 */         setCharacterStream(k + 1, paramReader, paramLong);
/*      */ 
/* 8440 */         i = 1;
/*      */       }
/*      */     }
/* 8443 */     if (i == 0)
/*      */     {
/* 8445 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 8446 */       localSQLException.fillInStackTrace();
/* 8447 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setNCharacterStream(String paramString, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 8464 */     String str = paramString.intern();
/* 8465 */     String[] arrayOfString = this.osql.getParameterList();
/* 8466 */     int i = 0;
/* 8467 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 8469 */     for (int k = 0; k < j; k++) {
/* 8470 */       if (arrayOfString[k] == str)
/*      */       {
/* 8472 */         setNCharacterStream(k + 1, paramReader);
/*      */ 
/* 8474 */         i = 1;
/*      */       }
/*      */     }
/* 8477 */     if (i == 0)
/*      */     {
/* 8479 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 8480 */       localSQLException.fillInStackTrace();
/* 8481 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setNCharacterStream(String paramString, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 8498 */     String str = paramString.intern();
/* 8499 */     String[] arrayOfString = this.osql.getParameterList();
/* 8500 */     int i = 0;
/* 8501 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 8503 */     for (int k = 0; k < j; k++) {
/* 8504 */       if (arrayOfString[k] == str)
/*      */       {
/* 8506 */         setNCharacterStream(k + 1, paramReader, paramLong);
/*      */ 
/* 8508 */         i = 1;
/*      */       }
/*      */     }
/* 8511 */     if (i == 0)
/*      */     {
/* 8513 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 8514 */       localSQLException.fillInStackTrace();
/* 8515 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setUnicodeStream(String paramString, InputStream paramInputStream, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 8532 */     String str = paramString.intern();
/* 8533 */     String[] arrayOfString = this.osql.getParameterList();
/* 8534 */     int i = 0;
/* 8535 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 8537 */     for (int k = 0; k < j; k++) {
/* 8538 */       if (arrayOfString[k] == str)
/*      */       {
/* 8540 */         setUnicodeStream(k + 1, paramInputStream, paramInt);
/*      */ 
/* 8542 */         i = 1;
/*      */       }
/*      */     }
/* 8545 */     if (i == 0)
/*      */     {
/* 8547 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 8548 */       localSQLException.fillInStackTrace();
/* 8549 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setNull(String paramString, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 8573 */     String str = paramString.intern();
/* 8574 */     String[] arrayOfString = this.osql.getParameterList();
/* 8575 */     int i = 0;
/* 8576 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 8578 */     for (int k = 0; k < j; k++) {
/* 8579 */       if (arrayOfString[k] == str)
/*      */       {
/* 8581 */         setNull(k + 1, paramInt);
/*      */ 
/* 8583 */         i = 1;
/*      */       }
/*      */     }
/* 8586 */     if (i == 0)
/*      */     {
/* 8588 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 8589 */       localSQLException.fillInStackTrace();
/* 8590 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setNull(String paramString1, int paramInt, String paramString2)
/*      */     throws SQLException
/*      */   {
/* 8607 */     String str = paramString1.intern();
/* 8608 */     String[] arrayOfString = this.osql.getParameterList();
/* 8609 */     int i = 0;
/* 8610 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 8612 */     for (int k = 0; k < j; k++) {
/* 8613 */       if (arrayOfString[k] == str)
/*      */       {
/* 8615 */         setNull(k + 1, paramInt, paramString2);
/*      */ 
/* 8617 */         i = 1;
/*      */       }
/*      */     }
/* 8620 */     if (i == 0)
/*      */     {
/* 8622 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString1);
/* 8623 */       localSQLException.fillInStackTrace();
/* 8624 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setObject(String paramString, Object paramObject, int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 8642 */     String str = paramString.intern();
/* 8643 */     String[] arrayOfString = this.osql.getParameterList();
/* 8644 */     int i = 0;
/* 8645 */     int j = Math.min(this.osql.getParameterCount(), arrayOfString.length);
/*      */ 
/* 8647 */     for (int k = 0; k < j; k++) {
/* 8648 */       if (arrayOfString[k] == str)
/*      */       {
/* 8650 */         setObject(k + 1, paramObject, paramInt1, paramInt2);
/*      */ 
/* 8652 */         i = 1;
/*      */       }
/*      */     }
/* 8655 */     if (i == 0)
/*      */     {
/* 8657 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 147, paramString);
/* 8658 */       localSQLException.fillInStackTrace();
/* 8659 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateAsciiStream(int paramInt, InputStream paramInputStream)
/*      */     throws SQLException
/*      */   {
/* 8679 */     updateAsciiStream(paramInt, paramInputStream, 0L, false);
/*      */   }
/*      */ 
/*      */   public void updateAsciiStream(int paramInt, InputStream paramInputStream, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 8693 */     updateAsciiStream(paramInt, paramInputStream, paramLong, true);
/*      */   }
/*      */ 
/*      */   public void updateAsciiStream(String paramString, InputStream paramInputStream)
/*      */     throws SQLException
/*      */   {
/* 8707 */     updateAsciiStream(getColumnIndex(paramString), paramInputStream);
/*      */   }
/*      */ 
/*      */   public void updateAsciiStream(String paramString, InputStream paramInputStream, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 8722 */     updateAsciiStream(getColumnIndex(paramString), paramInputStream, paramLong);
/*      */   }
/*      */ 
/*      */   public void updateBinaryStream(int paramInt, InputStream paramInputStream)
/*      */     throws SQLException
/*      */   {
/* 8737 */     updateBinaryStream(paramInt, paramInputStream, 0L, false);
/*      */   }
/*      */ 
/*      */   public void updateBinaryStream(int paramInt, InputStream paramInputStream, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 8751 */     updateBinaryStream(paramInt, paramInputStream, paramLong, true);
/*      */   }
/*      */ 
/*      */   public void updateBinaryStream(String paramString, InputStream paramInputStream)
/*      */     throws SQLException
/*      */   {
/* 8765 */     updateBinaryStream(getColumnIndex(paramString), paramInputStream, 9223372036854775807L, false);
/*      */   }
/*      */ 
/*      */   public void updateBinaryStream(String paramString, InputStream paramInputStream, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 8779 */     updateBinaryStream(getColumnIndex(paramString), paramInputStream, paramLong, true);
/*      */   }
/*      */ 
/*      */   public void updateBlob(int paramInt, InputStream paramInputStream)
/*      */     throws SQLException
/*      */   {
/* 8793 */     updateBinaryStream(paramInt, paramInputStream);
/*      */   }
/*      */ 
/*      */   public void updateBlob(int paramInt, InputStream paramInputStream, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 8808 */     updateBinaryStream(paramInt, paramInputStream, paramLong);
/*      */   }
/*      */ 
/*      */   public void updateBlob(String paramString, InputStream paramInputStream)
/*      */     throws SQLException
/*      */   {
/* 8823 */     updateBlob(getColumnIndex(paramString), paramInputStream);
/*      */   }
/*      */ 
/*      */   public void updateBlob(String paramString, InputStream paramInputStream, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 8838 */     updateBlob(getColumnIndex(paramString), paramInputStream, paramLong);
/*      */   }
/*      */ 
/*      */   public void updateCharacterStream(int paramInt, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 8853 */     updateCharacterStreamInternal(paramInt, paramReader, 0L, false, false);
/*      */   }
/*      */ 
/*      */   public void updateCharacterStream(int paramInt, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 8868 */     updateCharacterStreamInternal(paramInt, paramReader, paramLong, false, true);
/*      */   }
/*      */ 
/*      */   public void updateCharacterStream(String paramString, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 8883 */     updateCharacterStreamInternal(getColumnIndex(paramString), paramReader, 0L, false, false);
/*      */   }
/*      */ 
/*      */   public void updateCharacterStream(String paramString, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 8898 */     updateCharacterStreamInternal(getColumnIndex(paramString), paramReader, paramLong, false, true);
/*      */   }
/*      */ 
/*      */   public void updateClob(int paramInt, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 8913 */     updateCharacterStream(paramInt, paramReader);
/*      */   }
/*      */ 
/*      */   public void updateClob(int paramInt, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 8928 */     updateCharacterStream(paramInt, paramReader, paramLong);
/*      */   }
/*      */ 
/*      */   public void updateClob(String paramString, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 8943 */     updateClob(getColumnIndex(paramString), paramReader);
/*      */   }
/*      */ 
/*      */   public void updateClob(String paramString, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 8958 */     updateClob(getColumnIndex(paramString), paramReader, paramLong);
/*      */   }
/*      */ 
/*      */   public void updateNCharacterStream(int paramInt, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 8973 */     updateCharacterStreamInternal(paramInt, paramReader, 0L, true, false);
/*      */   }
/*      */ 
/*      */   public void updateNCharacterStream(int paramInt, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 8988 */     updateCharacterStreamInternal(paramInt, paramReader, paramLong, true, true);
/*      */   }
/*      */ 
/*      */   public void updateNCharacterStream(String paramString, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 9003 */     updateNCharacterStream(getColumnIndex(paramString), paramReader);
/*      */   }
/*      */ 
/*      */   public void updateNCharacterStream(String paramString, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 9018 */     updateNCharacterStream(getColumnIndex(paramString), paramReader, paramLong);
/*      */   }
/*      */ 
/*      */   public void updateNClob(int paramInt, NClob paramNClob)
/*      */     throws SQLException
/*      */   {
/* 9033 */     updateObject(paramInt, new OracleSerialClob(paramNClob));
/*      */   }
/*      */ 
/*      */   public void updateNClob(int paramInt, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 9048 */     updateClob(paramInt, new OracleSerialClob(paramReader));
/*      */   }
/*      */ 
/*      */   public void updateNClob(int paramInt, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 9063 */     updateClob(paramInt, new OracleSerialClob(paramReader, paramLong));
/*      */   }
/*      */ 
/*      */   public void updateNClob(String paramString, NClob paramNClob)
/*      */     throws SQLException
/*      */   {
/* 9078 */     updateNClob(getColumnIndex(paramString), paramNClob);
/*      */   }
/*      */ 
/*      */   public void updateNClob(String paramString, Reader paramReader)
/*      */     throws SQLException
/*      */   {
/* 9093 */     updateNClob(getColumnIndex(paramString), paramReader);
/*      */   }
/*      */ 
/*      */   public void updateNClob(String paramString, Reader paramReader, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 9108 */     updateNClob(getColumnIndex(paramString), paramReader, paramLong);
/*      */   }
/*      */ 
/*      */   public void updateNString(int paramInt, String paramString)
/*      */     throws SQLException
/*      */   {
/* 9123 */     updateObject(paramInt, paramString);
/*      */   }
/*      */ 
/*      */   public void updateNString(String paramString1, String paramString2)
/*      */     throws SQLException
/*      */   {
/* 9138 */     updateNString(getColumnIndex(paramString1), paramString2);
/*      */   }
/*      */ 
/*      */   public void updateRowId(int paramInt, RowId paramRowId)
/*      */     throws SQLException
/*      */   {
/* 9153 */     updateObject(paramInt, paramRowId);
/*      */   }
/*      */ 
/*      */   public void updateRowId(String paramString, RowId paramRowId)
/*      */     throws SQLException
/*      */   {
/* 9168 */     updateRowId(getColumnIndex(paramString), paramRowId);
/*      */   }
/*      */ 
/*      */   public void updateSQLXML(int paramInt, SQLXML paramSQLXML)
/*      */     throws SQLException
/*      */   {
/* 9183 */     updateObject(paramInt, paramSQLXML);
/*      */   }
/*      */ 
/*      */   public void updateSQLXML(String paramString, SQLXML paramSQLXML)
/*      */     throws SQLException
/*      */   {
/* 9198 */     updateSQLXML(getColumnIndex(paramString), paramSQLXML);
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.rowset.OracleCachedRowSet
 * JD-Core Version:    0.6.2
 */