/*     */ package oracle.jdbc.replay.driver;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.io.Reader;
/*     */ import java.lang.reflect.Method;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.SQLRecoverableException;
/*     */ import oracle.jdbc.internal.ACProxyable;
/*     */ import oracle.jdbc.internal.OracleCallableStatement;
/*     */ import oracle.jdbc.internal.OraclePreparedStatement;
/*     */ import oracle.jdbc.internal.OracleStatement;
/*     */ import oracle.jdbc.internal.OracleStatement.BindChecksumListener;
/*     */ import oracle.jdbc.proxy.annotation.GetCreator;
/*     */ import oracle.jdbc.proxy.annotation.GetDelegate;
/*     */ import oracle.jdbc.proxy.annotation.Methods;
/*     */ import oracle.jdbc.proxy.annotation.OnError;
/*     */ import oracle.jdbc.proxy.annotation.Post;
/*     */ import oracle.jdbc.proxy.annotation.Pre;
/*     */ import oracle.jdbc.proxy.annotation.ProxyAccess;
/*     */ import oracle.jdbc.proxy.annotation.ProxyFor;
/*     */ import oracle.jdbc.proxy.annotation.SetDelegate;
/*     */ 
/*     */ @ProxyFor({OracleCallableStatement.class, OraclePreparedStatement.class, OracleStatement.class})
/*     */ @ProxyAccess(ACProxyable.class)
/*     */ public abstract class TxnReplayableStatement extends TxnReplayableBase
/*     */   implements JDBCReplayable, OracleStatement.BindChecksumListener
/*     */ {
/* 651 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */ 
/*     */   protected TxnReplayableStatement()
/*     */   {
/*  58 */     this.thisProxyNameInLog = ("STMT" + this.thisProxyNameInLog);
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   protected void preForAll(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/*  68 */     super.preForAll(paramMethod, paramObject, paramArrayOfObject);
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="executeQuery", args={}), @oracle.jdbc.proxy.annotation.Signature(name="executeQuery", args={String.class})})
/*     */   protected void preForExecuteQuery(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/*  80 */     preForAll(paramMethod, paramObject, paramArrayOfObject);
/*     */ 
/*  82 */     TxnFailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*     */ 
/*  84 */     switch (1.$SwitchMap$oracle$jdbc$replay$driver$TxnFailoverManagerImpl$ReplayLifecycle[localReplayLifecycle.ordinal()])
/*     */     {
/*     */     case 1:
/*     */     case 2:
/*     */     case 3:
/*     */       try
/*     */       {
/*  91 */         OracleStatement localOracleStatement = (OracleStatement)getDelegate();
/*     */ 
/*  96 */         localOracleStatement.registerBindChecksumListener(this);
/*     */       }
/*     */       catch (SQLException localSQLException)
/*     */       {
/*     */       }
/*     */     case 4:
/*     */     case 5:
/*     */     case 6:
/*     */     case 7:
/*     */     case 8:
/*     */     }
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="execute", args={}), @oracle.jdbc.proxy.annotation.Signature(name="execute", args={String.class}), @oracle.jdbc.proxy.annotation.Signature(name="execute", args={String.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="execute", args={String.class, int[].class}), @oracle.jdbc.proxy.annotation.Signature(name="execute", args={String.class, String[].class})})
/*     */   protected void preForExecute(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/* 129 */     preForAll(paramMethod, paramObject, paramArrayOfObject);
/*     */ 
/* 131 */     TxnFailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*     */ 
/* 133 */     switch (1.$SwitchMap$oracle$jdbc$replay$driver$TxnFailoverManagerImpl$ReplayLifecycle[localReplayLifecycle.ordinal()])
/*     */     {
/*     */     case 1:
/*     */     case 2:
/*     */     case 3:
/*     */       try
/*     */       {
/* 140 */         OracleStatement localOracleStatement = (OracleStatement)getDelegate();
/*     */ 
/* 143 */         localOracleStatement.registerBindChecksumListener(this);
/*     */       }
/*     */       catch (SQLException localSQLException)
/*     */       {
/*     */       }
/*     */     case 4:
/*     */     case 5:
/*     */     case 6:
/*     */     case 7:
/*     */     case 8:
/*     */     }
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="executeUpdate", args={}), @oracle.jdbc.proxy.annotation.Signature(name="executeUpdate", args={String.class}), @oracle.jdbc.proxy.annotation.Signature(name="executeUpdate", args={String.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="executeUpdate", args={String.class, int[].class}), @oracle.jdbc.proxy.annotation.Signature(name="executeUpdate", args={String.class, String[].class})})
/*     */   protected void preForExecuteUpdate(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/* 176 */     preForAll(paramMethod, paramObject, paramArrayOfObject);
/*     */ 
/* 178 */     TxnFailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*     */ 
/* 180 */     switch (1.$SwitchMap$oracle$jdbc$replay$driver$TxnFailoverManagerImpl$ReplayLifecycle[localReplayLifecycle.ordinal()])
/*     */     {
/*     */     case 1:
/*     */     case 2:
/*     */     case 3:
/*     */       try
/*     */       {
/* 187 */         OracleStatement localOracleStatement = (OracleStatement)getDelegate();
/*     */ 
/* 190 */         localOracleStatement.registerBindChecksumListener(this);
/*     */       }
/*     */       catch (SQLException localSQLException)
/*     */       {
/*     */       }
/*     */     case 4:
/*     */     case 5:
/*     */     case 6:
/*     */     case 7:
/*     */     case 8:
/*     */     }
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="sendBatch", args={}), @oracle.jdbc.proxy.annotation.Signature(name="executeBatch", args={})})
/*     */   protected void preForBatches(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/* 220 */     preForAll(paramMethod, paramObject, paramArrayOfObject);
/*     */ 
/* 222 */     TxnFailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*     */ 
/* 224 */     switch (1.$SwitchMap$oracle$jdbc$replay$driver$TxnFailoverManagerImpl$ReplayLifecycle[localReplayLifecycle.ordinal()])
/*     */     {
/*     */     case 1:
/*     */     case 2:
/*     */     case 3:
/*     */       try
/*     */       {
/* 231 */         OracleStatement localOracleStatement = (OracleStatement)getDelegate();
/*     */ 
/* 234 */         localOracleStatement.registerBindChecksumListener(this);
/*     */       }
/*     */       catch (SQLException localSQLException)
/*     */       {
/*     */       }
/*     */     case 4:
/*     */     case 5:
/*     */     case 6:
/*     */     case 7:
/*     */     case 8:
/*     */     }
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="setAsciiStream", args={String.class, InputStream.class}), @oracle.jdbc.proxy.annotation.Signature(name="setAsciiStream", args={String.class, InputStream.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="setAsciiStream", args={String.class, InputStream.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="setBinaryStream", args={String.class, InputStream.class}), @oracle.jdbc.proxy.annotation.Signature(name="setBinaryStream", args={String.class, InputStream.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="setBinaryStream", args={String.class, InputStream.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="setCharacterStream", args={String.class, Reader.class}), @oracle.jdbc.proxy.annotation.Signature(name="setCharacterStream", args={String.class, Reader.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="setCharacterStream", args={String.class, Reader.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="setNCharacterStream", args={String.class, Reader.class}), @oracle.jdbc.proxy.annotation.Signature(name="setNCharacterStream", args={String.class, Reader.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="setAsciiStream", args={int.class, InputStream.class}), @oracle.jdbc.proxy.annotation.Signature(name="setAsciiStream", args={int.class, InputStream.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="setAsciiStream", args={int.class, InputStream.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="setBinaryStream", args={int.class, InputStream.class}), @oracle.jdbc.proxy.annotation.Signature(name="setBinaryStream", args={int.class, InputStream.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="setBinaryStream", args={int.class, InputStream.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="setCharacterStream", args={int.class, Reader.class}), @oracle.jdbc.proxy.annotation.Signature(name="setCharacterStream", args={int.class, Reader.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="setCharacterStream", args={int.class, Reader.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="setNCharacterStream", args={int.class, Reader.class}), @oracle.jdbc.proxy.annotation.Signature(name="setNCharacterStream", args={int.class, Reader.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="setUnicodeStream", args={int.class, InputStream.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="setAsciiStreamAtName", args={String.class, InputStream.class}), @oracle.jdbc.proxy.annotation.Signature(name="setAsciiStreamAtName", args={String.class, InputStream.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="setAsciiStreamAtName", args={String.class, InputStream.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="setBinaryStreamAtName", args={String.class, InputStream.class}), @oracle.jdbc.proxy.annotation.Signature(name="setBinaryStreamAtName", args={String.class, InputStream.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="setBinaryStreamAtName", args={String.class, InputStream.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="setCharacterStreamAtName", args={String.class, Reader.class}), @oracle.jdbc.proxy.annotation.Signature(name="setCharacterStreamAtName", args={String.class, Reader.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="setCharacterStreamAtName", args={String.class, Reader.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="setNCharacterStreamAtName", args={String.class, Reader.class}), @oracle.jdbc.proxy.annotation.Signature(name="setNCharacterStreamAtName", args={String.class, Reader.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="setUnicodeStreamAtName", args={String.class, InputStream.class, int.class})})
/*     */   protected void preForSetStreams(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/* 337 */     TxnFailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*     */ 
/* 339 */     if (localReplayLifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
/* 340 */       return;
/*     */     }
/*     */ 
/* 345 */     if (this.failoverMngr != null)
/* 346 */       this.failoverMngr.disableReplayInternal(paramMethod, 372, "Replay disabled because of nonreplayable call", null);
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="setObject", args={String.class, Object.class}), @oracle.jdbc.proxy.annotation.Signature(name="setObject", args={String.class, Object.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="setObject", args={String.class, Object.class, int.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="setObject", args={int.class, Object.class}), @oracle.jdbc.proxy.annotation.Signature(name="setObject", args={int.class, Object.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="setObject", args={int.class, Object.class, int.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="setObjectAtName", args={String.class, Object.class}), @oracle.jdbc.proxy.annotation.Signature(name="setObjectAtName", args={String.class, Object.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="setObjectAtName", args={String.class, Object.class, int.class, int.class})})
/*     */   protected void preForSetObjects(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/* 387 */     TxnFailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*     */ 
/* 389 */     if (localReplayLifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
/* 390 */       return;
/*     */     }
/*     */ 
/* 394 */     if (((paramArrayOfObject[1] instanceof InputStream)) || ((paramArrayOfObject[1] instanceof Reader)))
/*     */     {
/* 397 */       if (this.failoverMngr != null) {
/* 398 */         this.failoverMngr.disableReplayInternal(paramMethod, 372, "Replay disabled because of nonreplayable call", null);
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 409 */       preForAll(paramMethod, paramObject, paramArrayOfObject);
/*     */     }
/*     */   }
/*     */ 
/*     */   @Post
/*     */   protected void postForAll(Method paramMethod) {
/* 415 */     postForAll(paramMethod, null);
/*     */   }
/*     */ 
/*     */   @Post
/*     */   protected Object postForAll(Method paramMethod, Object paramObject)
/*     */   {
/* 422 */     return super.postForAll(paramMethod, paramObject);
/*     */   }
/*     */ 
/*     */   @Post
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="getResultSet", args={})})
/*     */   protected ResultSet postForGetResultSet(Method paramMethod, ResultSet paramResultSet)
/*     */   {
/* 435 */     postForAll(paramMethod, paramResultSet);
/*     */ 
/* 438 */     if (!this.failoverMngr.isSessionStateConsistencyDynamic())
/*     */     {
/* 440 */       TxnFailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*     */ 
/* 443 */       switch (1.$SwitchMap$oracle$jdbc$replay$driver$TxnFailoverManagerImpl$ReplayLifecycle[localReplayLifecycle.ordinal()])
/*     */       {
/*     */       case 1:
/* 448 */         for (TxnFailoverManagerImpl.CallHistoryEntry localCallHistoryEntry = this.tailSameProxy; 
/* 449 */           localCallHistoryEntry != this.headSameProxy; 
/* 450 */           localCallHistoryEntry = localCallHistoryEntry.prevEntrySameProxy)
/*     */         {
/* 453 */           if (("execute".equals(localCallHistoryEntry.method.getName())) && ((localCallHistoryEntry.result instanceof Integer)))
/*     */           {
/* 455 */             ((TxnReplayableResultSet)paramResultSet).creatorCallEntry = localCallHistoryEntry;
/*     */           }
/*     */         }
/* 458 */         break;
/*     */       case 2:
/*     */       case 3:
/*     */       case 4:
/*     */       case 5:
/*     */       case 6:
/*     */       case 7:
/*     */       case 8:
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 472 */     return paramResultSet;
/*     */   }
/*     */ 
/*     */   @Post
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="executeQuery", args={}), @oracle.jdbc.proxy.annotation.Signature(name="executeQuery", args={String.class})})
/*     */   protected ResultSet postForExecuteQuery(Method paramMethod, ResultSet paramResultSet)
/*     */   {
/* 486 */     postForAll(paramMethod, paramResultSet);
/*     */ 
/* 489 */     if (!this.failoverMngr.isSessionStateConsistencyDynamic())
/*     */     {
/* 491 */       TxnFailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*     */ 
/* 494 */       switch (1.$SwitchMap$oracle$jdbc$replay$driver$TxnFailoverManagerImpl$ReplayLifecycle[localReplayLifecycle.ordinal()])
/*     */       {
/*     */       case 1:
/* 499 */         ((TxnReplayableResultSet)paramResultSet).creatorCallEntry = this.tailSameProxy;
/*     */ 
/* 501 */         break;
/*     */       case 2:
/*     */       case 3:
/*     */       case 4:
/*     */       case 5:
/*     */       case 6:
/*     */       case 7:
/*     */       case 8:
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 515 */     return paramResultSet;
/*     */   }
/*     */ 
/*     */   @OnError(SQLException.class)
/*     */   protected void onErrorVoidForAll(Method paramMethod, SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/* 556 */     super.onErrorVoidForAll(paramMethod, paramSQLException);
/*     */   }
/*     */ 
/*     */   @OnError(SQLException.class)
/*     */   protected Object onErrorForAll(Method paramMethod, SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/* 563 */     return super.onErrorForAll(paramMethod, paramSQLException);
/*     */   }
/*     */ 
/*     */   @OnError(SQLException.class)
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="close", args={})})
/*     */   protected void onErrorVoidForClose(Method paramMethod, SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/* 572 */     if ((paramSQLException instanceof SQLRecoverableException)) {
/* 573 */       return;
/*     */     }
/* 575 */     super.onErrorVoidForAll(paramMethod, paramSQLException);
/*     */   }
/*     */ 
/*     */   @GetDelegate
/*     */   protected abstract Object getDelegate();
/*     */ 
/*     */   @SetDelegate
/*     */   protected abstract void setDelegate(Object paramObject);
/*     */ 
/*     */   @GetCreator
/*     */   protected abstract Object getCreator();
/*     */ 
/*     */   public boolean shouldContinue(long paramLong)
/*     */   {
/* 594 */     boolean bool = true;
/*     */ 
/* 597 */     TxnFailoverManagerImpl.CallHistoryEntry localCallHistoryEntry = this.tailSameProxy;
/*     */ 
/* 599 */     TxnFailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*     */ 
/* 601 */     switch (1.$SwitchMap$oracle$jdbc$replay$driver$TxnFailoverManagerImpl$ReplayLifecycle[localReplayLifecycle.ordinal()])
/*     */     {
/*     */     case 1:
/*     */     case 3:
/* 607 */       this.currentBindChecksum = paramLong;
/*     */ 
/* 611 */       break;
/*     */     case 4:
/*     */     case 5:
/*     */     case 6:
/*     */     case 7:
/*     */     case 8:
/* 619 */       break;
/*     */     case 2:
/* 625 */       if (localCallHistoryEntry.checksum != 0L)
/*     */       {
/* 629 */         if (localCallHistoryEntry.checksum != paramLong)
/*     */         {
/* 632 */           this.failoverMngr.disableReplayInternal(localCallHistoryEntry.method, 388, "Replay failed because of checksum mismatch", null);
/*     */ 
/* 639 */           bool = false;
/*     */         }
/*     */       }
/*     */       break;
/*     */     }
/*     */ 
/* 645 */     localCallHistoryEntry = null;
/*     */ 
/* 647 */     return bool;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.replay.driver.TxnReplayableStatement
 * JD-Core Version:    0.6.2
 */