/*     */ package oracle.jdbc.replay.driver;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.SQLRecoverableException;
/*     */ import oracle.jdbc.internal.ACProxyable;
/*     */ import oracle.jdbc.internal.OracleResultSet;
/*     */ import oracle.jdbc.proxy.annotation.GetCreator;
/*     */ import oracle.jdbc.proxy.annotation.GetDelegate;
/*     */ import oracle.jdbc.proxy.annotation.Methods;
/*     */ import oracle.jdbc.proxy.annotation.OnError;
/*     */ import oracle.jdbc.proxy.annotation.Post;
/*     */ import oracle.jdbc.proxy.annotation.Pre;
/*     */ import oracle.jdbc.proxy.annotation.ProxyAccess;
/*     */ import oracle.jdbc.proxy.annotation.ProxyFor;
/*     */ import oracle.jdbc.proxy.annotation.SetDelegate;
/*     */ 
/*     */ @ProxyFor({OracleResultSet.class})
/*     */ @ProxyAccess(ACProxyable.class)
/*     */ public abstract class TxnReplayableResultSet extends TxnReplayableBase
/*     */   implements JDBCReplayable
/*     */ {
/* 278 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */ 
/*     */   protected TxnReplayableResultSet()
/*     */   {
/*  54 */     this.thisProxyNameInLog = ("RSET" + this.thisProxyNameInLog);
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   protected void preForAll(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/*  64 */     super.preForAll(paramMethod, paramObject, paramArrayOfObject);
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="updateAsciiStream", args={String.class, java.io.InputStream.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateAsciiStream", args={String.class, java.io.InputStream.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateAsciiStream", args={String.class, java.io.InputStream.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateBinaryStream", args={String.class, java.io.InputStream.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateBinaryStream", args={String.class, java.io.InputStream.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateBinaryStream", args={String.class, java.io.InputStream.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateCharacterStream", args={String.class, java.io.Reader.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateCharacterStream", args={String.class, java.io.Reader.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateCharacterStream", args={String.class, java.io.Reader.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateNCharacterStream", args={String.class, java.io.Reader.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateNCharacterStream", args={String.class, java.io.Reader.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateAsciiStream", args={int.class, java.io.InputStream.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateAsciiStream", args={int.class, java.io.InputStream.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateAsciiStream", args={int.class, java.io.InputStream.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateBinaryStream", args={int.class, java.io.InputStream.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateBinaryStream", args={int.class, java.io.InputStream.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateBinaryStream", args={int.class, java.io.InputStream.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateCharacterStream", args={int.class, java.io.Reader.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateCharacterStream", args={int.class, java.io.Reader.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateCharacterStream", args={int.class, java.io.Reader.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateNCharacterStream", args={int.class, java.io.Reader.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateNCharacterStream", args={int.class, java.io.Reader.class, long.class})})
/*     */   protected void preForUpdateStreams(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/* 119 */     TxnFailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*     */ 
/* 121 */     if (localReplayLifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
/* 122 */       return;
/*     */     }
/*     */ 
/* 126 */     if (this.failoverMngr != null)
/* 127 */       this.failoverMngr.disableReplayInternal(paramMethod, 371, "Replay disabled because of active transaction", null);
/*     */   }
/*     */ 
/*     */   @Post
/*     */   protected void postForAll(Method paramMethod)
/*     */   {
/* 141 */     postForAll(paramMethod, null);
/*     */   }
/*     */ 
/*     */   @Post
/*     */   protected Object postForAll(Method paramMethod, Object paramObject)
/*     */   {
/* 147 */     return super.postForAll(paramMethod, paramObject);
/*     */   }
/*     */ 
/*     */   @OnError(SQLException.class)
/*     */   protected void onErrorVoidForAll(Method paramMethod, SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/* 216 */     onErrorForAll(paramMethod, paramSQLException);
/*     */   }
/*     */ 
/*     */   @OnError(SQLException.class)
/*     */   protected Object onErrorForAll(Method paramMethod, SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/* 223 */     return super.onErrorForAll(paramMethod, paramSQLException);
/*     */   }
/*     */ 
/*     */   @OnError(SQLException.class)
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="last", args={})})
/*     */   protected boolean onErrorForLast(Method paramMethod, SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/* 233 */     if (this.isClosedAndNoReplay) {
/* 234 */       throw paramSQLException;
/*     */     }
/* 236 */     TxnFailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*     */ 
/* 238 */     if (((paramSQLException instanceof SQLRecoverableException)) && (localReplayLifecycle == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING))
/*     */     {
/* 243 */       this.failoverMngr.disableReplayInternal(paramMethod, 372, "Replay disabled because of nonreplayable call", null);
/*     */     }
/*     */ 
/* 250 */     return ((Boolean)super.onErrorForAll(paramMethod, paramSQLException)).booleanValue();
/*     */   }
/*     */ 
/*     */   @GetDelegate
/*     */   protected abstract Object getDelegate();
/*     */ 
/*     */   @SetDelegate
/*     */   protected abstract void setDelegate(Object paramObject);
/*     */ 
/*     */   @GetCreator
/*     */   protected abstract Object getCreator();
/*     */ 
/*     */   public Object replayOneCall(TxnFailoverManagerImpl.CallHistoryEntry paramCallHistoryEntry, SQLRecoverableException paramSQLRecoverableException)
/*     */     throws SQLException
/*     */   {
/* 271 */     Object localObject = super.replayOneCall(paramCallHistoryEntry, paramSQLRecoverableException);
/*     */ 
/* 274 */     return localObject;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.replay.driver.TxnReplayableResultSet
 * JD-Core Version:    0.6.2
 */