/*     */ package oracle.jdbc.replay.driver;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.internal.ACProxyable;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.jdbc.internal.OracleNClob;
/*     */ import oracle.jdbc.proxy.annotation.GetCreator;
/*     */ import oracle.jdbc.proxy.annotation.GetDelegate;
/*     */ import oracle.jdbc.proxy.annotation.Methods;
/*     */ import oracle.jdbc.proxy.annotation.OnError;
/*     */ import oracle.jdbc.proxy.annotation.Post;
/*     */ import oracle.jdbc.proxy.annotation.Pre;
/*     */ import oracle.jdbc.proxy.annotation.ProxyAccess;
/*     */ import oracle.jdbc.proxy.annotation.ProxyFor;
/*     */ import oracle.jdbc.proxy.annotation.ProxyResult;
/*     */ import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
/*     */ import oracle.jdbc.proxy.annotation.SetDelegate;
/*     */ 
/*     */ @ProxyFor({OracleNClob.class})
/*     */ @ProxyAccess(ACProxyable.class)
/*     */ public abstract class TxnReplayableNClob extends TxnReplayableClob
/*     */   implements JDBCReplayable
/*     */ {
/* 130 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */ 
/*     */   @Pre
/*     */   protected void preForAll(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/*  54 */     super.preForAll(paramMethod, paramObject, paramArrayOfObject);
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="setString", args={long.class, String.class}), @oracle.jdbc.proxy.annotation.Signature(name="setString", args={long.class, String.class, int.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="truncate", args={long.class})})
/*     */   protected void preForClobWrites(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/*  67 */     TxnFailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*     */ 
/*  69 */     if (localReplayLifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
/*  70 */       return;
/*     */     }
/*     */ 
/*  74 */     super.preForClobWrites(paramMethod, paramObject, paramArrayOfObject);
/*     */   }
/*     */ 
/*     */   @Post
/*     */   protected void postForAll(Method paramMethod)
/*     */   {
/*  80 */     postForAll(paramMethod, null);
/*     */   }
/*     */ 
/*     */   @Post
/*     */   protected Object postForAll(Method paramMethod, Object paramObject)
/*     */   {
/*  87 */     if ((paramObject instanceof TxnReplayableBase))
/*     */     {
/*  89 */       TxnReplayableBase localTxnReplayableBase = (TxnReplayableBase)paramObject;
/*  90 */       localTxnReplayableBase.setFailoverManager(getFailoverManager());
/*     */     }
/*     */ 
/*  93 */     return super.postForAll(paramMethod, paramObject);
/*     */   }
/*     */ 
/*     */   @OnError(SQLException.class)
/*     */   protected void onErrorVoidForAll(Method paramMethod, SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/* 100 */     super.onErrorVoidForAll(paramMethod, paramSQLException);
/*     */   }
/*     */ 
/*     */   @OnError(SQLException.class)
/*     */   protected Object onErrorForAll(Method paramMethod, SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/* 107 */     return super.onErrorForAll(paramMethod, paramSQLException);
/*     */   }
/*     */   @GetDelegate
/*     */   protected abstract Object getDelegate();
/*     */ 
/*     */   @SetDelegate
/*     */   protected abstract void setDelegate(Object paramObject);
/*     */ 
/*     */   @GetCreator
/*     */   protected abstract Object getCreator();
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.MANUAL)
/*     */   public OracleConnection getInternalConnection() throws SQLException {
/* 123 */     OracleNClob localOracleNClob = (OracleNClob)getDelegate();
/*     */ 
/* 126 */     return localOracleNClob.getInternalConnection();
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.replay.driver.TxnReplayableNClob
 * JD-Core Version:    0.6.2
 */