/*     */ package oracle.jdbc.replay.driver;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.sql.Array;
/*     */ import java.sql.Connection;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Struct;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.ACProxyable;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.jdbc.proxy.annotation.GetCreator;
/*     */ import oracle.jdbc.proxy.annotation.GetDelegate;
/*     */ import oracle.jdbc.proxy.annotation.Methods;
/*     */ import oracle.jdbc.proxy.annotation.OnError;
/*     */ import oracle.jdbc.proxy.annotation.Post;
/*     */ import oracle.jdbc.proxy.annotation.Pre;
/*     */ import oracle.jdbc.proxy.annotation.ProxyAccess;
/*     */ import oracle.jdbc.proxy.annotation.ProxyFor;
/*     */ import oracle.jdbc.proxy.annotation.ProxyLocale;
/*     */ import oracle.jdbc.proxy.annotation.SetDelegate;
/*     */ import oracle.jdbc.replay.internal.OracleDataSource;
/*     */ import oracle.jdbc.replay.internal.ReplayableConnection;
/*     */ import oracle.sql.ARRAY;
/*     */ 
/*     */ @ProxyFor({OracleConnection.class})
/*     */ @ProxyLocale
/*     */ @ProxyAccess(ACProxyable.class)
/*     */ public abstract class TxnReplayableConnection extends TxnReplayableBase
/*     */   implements JDBCReplayable, ReplayableConnection
/*     */ {
/*  61 */   private static final Method CREATEARRAY_METHOD = getCreateARRAYMethod();
/*  62 */   private static final Method CREATEARRAYOF_METHOD = getCreateArrayOfMethod();
/*  63 */   private static final Method CREATESTRUCT_METHOD = getCreateStructMethod();
/*     */ 
/*  65 */   String originalUser = "";
/*  66 */   String originalPasswd = "";
/*     */ 
/* 514 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */ 
/*     */   protected TxnReplayableConnection()
/*     */   {
/*  72 */     this.thisProxyNameInLog = ("CONN" + this.thisProxyNameInLog);
/*     */   }
/*     */ 
/*     */   private static final Method getCreateARRAYMethod()
/*     */   {
/*     */     try
/*     */     {
/*  79 */       return OracleConnection.class.getMethod("createARRAY", new Class[] { String.class, Object.class });
/*     */     }
/*     */     catch (Exception localException)
/*     */     {
/*     */     }
/*     */ 
/*  85 */     return null;
/*     */   }
/*     */ 
/*     */   private static final Method getCreateArrayOfMethod()
/*     */   {
/*     */     try
/*     */     {
/*  93 */       return Connection.class.getDeclaredMethod("createArrayOf", new Class[] { String.class, [Ljava.lang.Object.class });
/*     */     }
/*     */     catch (Exception localException)
/*     */     {
/*     */     }
/*     */ 
/*  99 */     return null;
/*     */   }
/*     */ 
/*     */   private static final Method getCreateStructMethod()
/*     */   {
/*     */     try
/*     */     {
/* 107 */       return Connection.class.getDeclaredMethod("createStruct", new Class[] { String.class, [Ljava.lang.Object.class });
/*     */     }
/*     */     catch (Exception localException)
/*     */     {
/*     */     }
/*     */ 
/* 113 */     return null;
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   protected void preForAll(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/* 125 */     super.preForAll(paramMethod, paramObject, paramArrayOfObject);
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="prepareStatement", args={String.class}), @oracle.jdbc.proxy.annotation.Signature(name="prepareStatement", args={String.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="prepareStatement", args={String.class, int[].class}), @oracle.jdbc.proxy.annotation.Signature(name="prepareStatement", args={String.class, int.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="prepareStatement", args={String.class, int.class, int.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="prepareStatement", args={String.class, String[].class}), @oracle.jdbc.proxy.annotation.Signature(name="prepareCall", args={String.class}), @oracle.jdbc.proxy.annotation.Signature(name="prepareCall", args={String.class, int.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="prepareCall", args={String.class, int.class, int.class, int.class})})
/*     */   protected void preForStatementCreation(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/* 144 */     preForAll(paramMethod, paramObject, paramArrayOfObject);
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="abort", args={})})
/*     */   protected void preForAbort(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="close", args={}), @oracle.jdbc.proxy.annotation.Signature(name="close", args={int.class}), @oracle.jdbc.proxy.annotation.Signature(name="close", args={java.util.Properties.class})})
/*     */   protected void preForClosure(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/* 173 */     StackTraceElement[] arrayOfStackTraceElement = Thread.currentThread().getStackTrace();
/* 174 */     String str = (arrayOfStackTraceElement != null) && (arrayOfStackTraceElement.length > 4) ? arrayOfStackTraceElement[4].getClassName() : "";
/*     */ 
/* 179 */     if (str.startsWith("oracle.ucp")) {
/* 180 */       this.isClosedAndNoReplay = false;
/*     */     }
/*     */     else
/* 183 */       this.isClosedAndNoReplay = true;
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="cancel", args={})})
/*     */   protected void preForCancel(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="openProxySession", args={int.class, java.util.Properties.class})})
/*     */   protected void preForOpenProxySession(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/* 204 */     TxnFailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*     */ 
/* 206 */     if (localReplayLifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
/* 207 */       return;
/*     */     }
/*     */ 
/* 212 */     if (this.failoverMngr != null)
/* 213 */       this.failoverMngr.disableReplayInternal(paramMethod, 372, "Replay disabled because of nonreplayable call", null);
/*     */   }
/*     */ 
/*     */   @Post
/*     */   protected void postForAll(Method paramMethod)
/*     */   {
/* 227 */     postForAll(paramMethod, null);
/*     */   }
/*     */ 
/*     */   @Post
/*     */   protected Object postForAll(Method paramMethod, Object paramObject)
/*     */   {
/* 233 */     return super.postForAll(paramMethod, paramObject);
/*     */   }
/*     */ 
/*     */   @Post
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="abort", args={})})
/*     */   protected void postForAbort(Method paramMethod)
/*     */   {
/*     */   }
/*     */ 
/*     */   @Post
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="close", args={}), @oracle.jdbc.proxy.annotation.Signature(name="close", args={int.class}), @oracle.jdbc.proxy.annotation.Signature(name="close", args={java.util.Properties.class})})
/*     */   protected void postForClosure(Method paramMethod)
/*     */   {
/*     */   }
/*     */ 
/*     */   @Post
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="cancel", args={})})
/*     */   protected void postForCancel(Method paramMethod)
/*     */   {
/*     */   }
/*     */ 
/*     */   @OnError(SQLException.class)
/*     */   protected void onErrorVoidForAll(Method paramMethod, SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/* 272 */     super.onErrorVoidForAll(paramMethod, paramSQLException);
/*     */   }
/*     */ 
/*     */   @OnError(SQLException.class)
/*     */   protected Object onErrorForAll(Method paramMethod, SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/* 279 */     return super.onErrorForAll(paramMethod, paramSQLException);
/*     */   }
/*     */ 
/*     */   @GetDelegate
/*     */   protected abstract Object getDelegate();
/*     */ 
/*     */   @SetDelegate
/*     */   protected abstract void setDelegate(Object paramObject);
/*     */ 
/*     */   @GetCreator
/*     */   protected abstract Object getCreator();
/*     */ 
/*     */   public void setReplayInitiationTimeout(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 306 */     this.failoverMngr.setReplayInitiationTimeout(paramInt);
/*     */   }
/*     */ 
/*     */   public void initialize(OracleDataSource paramOracleDataSource, String paramString1, String paramString2)
/*     */     throws SQLException
/*     */   {
/* 312 */     TxnFailoverManagerImpl localTxnFailoverManagerImpl = (TxnFailoverManagerImpl)TxnFailoverManagerImpl.getFailoverManager(this, paramOracleDataSource);
/*     */ 
/* 315 */     setFailoverManager(localTxnFailoverManagerImpl);
/*     */ 
/* 318 */     this.originalUser = paramString1;
/* 319 */     this.originalPasswd = paramString2;
/*     */   }
/*     */ 
/*     */   public void setSessionStateConsistency(boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/* 327 */     this.failoverMngr.setSessionStateConsistency(paramBoolean);
/*     */   }
/*     */ 
/*     */   public void beginRequest()
/*     */     throws SQLException
/*     */   {
/* 337 */     this.failoverMngr.beginRequest();
/*     */   }
/*     */ 
/*     */   public void endRequest()
/*     */     throws SQLException
/*     */   {
/* 343 */     this.failoverMngr.endRequest();
/*     */   }
/*     */ 
/*     */   public void disableReplay()
/*     */     throws SQLException
/*     */   {
/* 351 */     this.failoverMngr.disableReplay();
/*     */   }
/*     */ 
/*     */   public ARRAY createARRAY(String paramString, Object paramObject)
/*     */     throws SQLException
/*     */   {
/*     */     Object localObject3;
/*     */     Object localObject1;
/* 365 */     if ((paramObject != null) && ((paramObject instanceof Object[])))
/*     */     {
/* 367 */       localObject2 = (Object[])paramObject;
/* 368 */       if (localObject2.length > 0)
/*     */       {
/* 370 */         localObject3 = new Object[localObject2.length];
/* 371 */         int i = 0;
/* 372 */         for (Object localObject5 : localObject2)
/*     */         {
/* 374 */           if ((localObject5 instanceof TxnReplayableBase))
/*     */           {
/* 376 */             localObject3[(i++)] = ((TxnReplayableBase)localObject5).getDelegate();
/*     */           }
/*     */           else
/* 379 */             localObject3[(i++)] = localObject5;
/*     */         }
/* 381 */         localObject1 = localObject3;
/*     */       }
/*     */       else {
/* 384 */         localObject1 = paramObject;
/*     */       }
/*     */     } else {
/* 387 */       localObject1 = paramObject;
/*     */     }
/* 389 */     if (CREATEARRAY_METHOD == null)
/*     */     {
/* 391 */       throw DatabaseError.createSqlException(1, "Cannot create ARRAY instance");
/*     */     }
/*     */ 
/* 395 */     Object localObject2 = CREATEARRAY_METHOD;
/*     */ 
/* 397 */     preForAll((Method)localObject2, this, new Object[] { paramString, localObject1 });
/*     */     try
/*     */     {
/* 401 */       localObject3 = (OracleConnection)getDelegate();
/*     */ 
/* 403 */       ARRAY localARRAY = ((OracleConnection)localObject3).createARRAY(paramString, localObject1);
/*     */ 
/* 405 */       return (ARRAY)postForAll((Method)localObject2, localARRAY);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 409 */       return (ARRAY)postForAll((Method)localObject2, onErrorForAll((Method)localObject2, localSQLException));
/*     */     }
/*     */   }
/*     */ 
/*     */   public Array createOracleArray(String paramString, Object paramObject)
/*     */     throws SQLException
/*     */   {
/* 416 */     return createARRAY(paramString, paramObject);
/*     */   }
/*     */ 
/*     */   public Array createArrayOf(String paramString, Object[] paramArrayOfObject)
/*     */     throws SQLException
/*     */   {
/*     */     Object[] arrayOfObject;
/* 425 */     if ((paramArrayOfObject != null) && (paramArrayOfObject.length > 0))
/*     */     {
/* 427 */       arrayOfObject = new Object[paramArrayOfObject.length];
/* 428 */       int i = 0;
/* 429 */       for (Object localObject2 : paramArrayOfObject)
/*     */       {
/* 431 */         if ((localObject2 instanceof TxnReplayableBase))
/*     */         {
/* 433 */           arrayOfObject[(i++)] = ((TxnReplayableBase)localObject2).getDelegate();
/*     */         }
/*     */         else
/* 436 */           arrayOfObject[(i++)] = localObject2;
/*     */       }
/*     */     }
/*     */     else {
/* 440 */       arrayOfObject = paramArrayOfObject;
/*     */     }
/* 442 */     if (CREATEARRAYOF_METHOD == null)
/*     */     {
/* 444 */       throw DatabaseError.createSqlException(1, "Cannot create Array instance");
/*     */     }
/*     */ 
/* 448 */     Method localMethod = CREATEARRAYOF_METHOD;
/*     */ 
/* 450 */     preForAll(localMethod, this, new Object[] { paramString, arrayOfObject });
/*     */     try
/*     */     {
/* 454 */       ??? = (Connection)getDelegate();
/*     */ 
/* 456 */       Array localArray = ((Connection)???).createArrayOf(paramString, arrayOfObject);
/*     */ 
/* 458 */       return (Array)postForAll(localMethod, localArray);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 462 */       return (Array)postForAll(localMethod, onErrorForAll(localMethod, localSQLException));
/*     */     }
/*     */   }
/*     */ 
/*     */   public Struct createStruct(String paramString, Object[] paramArrayOfObject)
/*     */     throws SQLException
/*     */   {
/*     */     Object[] arrayOfObject;
/* 472 */     if ((paramArrayOfObject != null) && (paramArrayOfObject.length > 0))
/*     */     {
/* 474 */       arrayOfObject = new Object[paramArrayOfObject.length];
/* 475 */       int i = 0;
/* 476 */       for (Object localObject2 : paramArrayOfObject)
/*     */       {
/* 478 */         if ((localObject2 instanceof TxnReplayableBase))
/*     */         {
/* 480 */           arrayOfObject[(i++)] = ((TxnReplayableBase)localObject2).getDelegate();
/*     */         }
/*     */         else
/* 483 */           arrayOfObject[(i++)] = localObject2;
/*     */       }
/*     */     }
/*     */     else {
/* 487 */       arrayOfObject = paramArrayOfObject;
/*     */     }
/* 489 */     if (CREATESTRUCT_METHOD == null)
/*     */     {
/* 491 */       throw DatabaseError.createSqlException(1, "Cannot create Struct instance");
/*     */     }
/*     */ 
/* 495 */     Method localMethod = CREATESTRUCT_METHOD;
/*     */ 
/* 497 */     preForAll(localMethod, this, new Object[] { paramString, arrayOfObject });
/*     */     try
/*     */     {
/* 501 */       ??? = (Connection)getDelegate();
/*     */ 
/* 503 */       Struct localStruct = ((Connection)???).createStruct(paramString, arrayOfObject);
/*     */ 
/* 505 */       return (Struct)postForAll(localMethod, localStruct);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 509 */       return (Struct)postForAll(localMethod, onErrorForAll(localMethod, localSQLException));
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.replay.driver.TxnReplayableConnection
 * JD-Core Version:    0.6.2
 */