/*     */ package oracle.jdbc.replay.driver;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.io.Reader;
/*     */ import java.io.Writer;
/*     */ import java.lang.reflect.Method;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.ACProxyable;
/*     */ import oracle.jdbc.internal.OracleClob;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.jdbc.proxy.annotation.GetCreator;
/*     */ import oracle.jdbc.proxy.annotation.GetDelegate;
/*     */ import oracle.jdbc.proxy.annotation.Methods;
/*     */ import oracle.jdbc.proxy.annotation.OnError;
/*     */ import oracle.jdbc.proxy.annotation.Post;
/*     */ import oracle.jdbc.proxy.annotation.Pre;
/*     */ import oracle.jdbc.proxy.annotation.ProxyAccess;
/*     */ import oracle.jdbc.proxy.annotation.ProxyFor;
/*     */ import oracle.jdbc.proxy.annotation.ProxyResult;
/*     */ import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
/*     */ import oracle.jdbc.proxy.annotation.SetDelegate;
/*     */ import oracle.sql.ClobDBAccess;
/*     */ 
/*     */ @ProxyFor({OracleClob.class})
/*     */ @ProxyAccess(ACProxyable.class)
/*     */ public abstract class TxnReplayableClob extends TxnReplayableBase
/*     */   implements JDBCReplayable
/*     */ {
/*  49 */   private static final Method GETASCIISTREAM_METHOD = getGetAsciiStreamMethod();
/*  50 */   private static final Method GETASCIISTREAM_LONG_METHOD = getGetAsciiStreamLongMethod();
/*  51 */   private static final Method GETCHARSTREAM_METHOD = getGetCharacterStreamMethod();
/*  52 */   private static final Method GETCHARSTREAM_LONG_METHOD = getGetCharacterStreamLongMethod();
/*  53 */   private static final Method GETCHARSTREAM_LONG_LONG_METHOD = getGetCharacterStreamLongLongMethod();
/*  54 */   private static final Method SETASCIISTREAM_LONG_METHOD = getSetAsciiStreamLongMethod();
/*  55 */   private static final Method SETCHARSTREAM_LONG_METHOD = getSetCharacterStreamLongMethod();
/*     */ 
/*  57 */   protected boolean isFreed = false;
/*     */ 
/* 594 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */ 
/*     */   protected TxnReplayableClob()
/*     */   {
/*  63 */     this.thisProxyNameInLog = ("CLOB" + this.thisProxyNameInLog);
/*     */   }
/*     */ 
/*     */   private static final Method getGetAsciiStreamMethod()
/*     */   {
/*     */     try
/*     */     {
/*  70 */       return OracleClob.class.getMethod("getAsciiStream", new Class[0]);
/*     */     }
/*     */     catch (Exception localException) {
/*     */     }
/*  74 */     return null;
/*     */   }
/*     */ 
/*     */   private static final Method getGetAsciiStreamLongMethod()
/*     */   {
/*     */     try
/*     */     {
/*  82 */       return OracleClob.class.getMethod("getAsciiStream", new Class[] { Long.TYPE });
/*     */     }
/*     */     catch (Exception localException) {
/*     */     }
/*  86 */     return null;
/*     */   }
/*     */ 
/*     */   private static final Method getGetCharacterStreamMethod()
/*     */   {
/*     */     try
/*     */     {
/*  94 */       return OracleClob.class.getMethod("getCharacterStream", new Class[0]);
/*     */     }
/*     */     catch (Exception localException) {
/*     */     }
/*  98 */     return null;
/*     */   }
/*     */ 
/*     */   private static final Method getGetCharacterStreamLongMethod()
/*     */   {
/*     */     try
/*     */     {
/* 106 */       return OracleClob.class.getMethod("getCharacterStream", new Class[] { Long.TYPE });
/*     */     }
/*     */     catch (Exception localException) {
/*     */     }
/* 110 */     return null;
/*     */   }
/*     */ 
/*     */   private static final Method getGetCharacterStreamLongLongMethod()
/*     */   {
/*     */     try
/*     */     {
/* 118 */       return OracleClob.class.getMethod("getCharacterStream", new Class[] { Long.TYPE, Long.TYPE });
/*     */     }
/*     */     catch (Exception localException) {
/*     */     }
/* 122 */     return null;
/*     */   }
/*     */ 
/*     */   private static final Method getSetAsciiStreamLongMethod()
/*     */   {
/*     */     try
/*     */     {
/* 130 */       return OracleClob.class.getMethod("setAsciiStream", new Class[] { Long.TYPE });
/*     */     }
/*     */     catch (Exception localException) {
/*     */     }
/* 134 */     return null;
/*     */   }
/*     */ 
/*     */   private static final Method getSetCharacterStreamLongMethod()
/*     */   {
/*     */     try
/*     */     {
/* 142 */       return OracleClob.class.getMethod("setCharacterStream", new Class[] { Long.TYPE });
/*     */     }
/*     */     catch (Exception localException) {
/*     */     }
/* 146 */     return null;
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   protected void preForAll(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/* 156 */     super.preForAll(paramMethod, paramObject, paramArrayOfObject);
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="free", args={})})
/*     */   protected void preForFree(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/* 166 */     this.isFreed = true;
/* 167 */     super.preForAll(paramMethod, paramObject, paramArrayOfObject);
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="setString", args={long.class, String.class}), @oracle.jdbc.proxy.annotation.Signature(name="setString", args={long.class, String.class, int.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="truncate", args={long.class})})
/*     */   protected void preForClobWrites(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/* 180 */     TxnFailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*     */ 
/* 182 */     if (localReplayLifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
/* 183 */       return;
/*     */     }
/*     */ 
/* 187 */     if (this.failoverMngr != null)
/* 188 */       this.failoverMngr.disableReplayInternal(paramMethod, 371, "Replay disabled because of active transaction", null);
/*     */   }
/*     */ 
/*     */   @Post
/*     */   protected void postForAll(Method paramMethod)
/*     */   {
/* 202 */     postForAll(paramMethod, null);
/*     */   }
/*     */ 
/*     */   @Post
/*     */   protected Object postForAll(Method paramMethod, Object paramObject)
/*     */   {
/* 209 */     if ((paramObject instanceof TxnReplayableBase))
/*     */     {
/* 211 */       TxnReplayableBase localTxnReplayableBase = (TxnReplayableBase)paramObject;
/* 212 */       localTxnReplayableBase.setFailoverManager(getFailoverManager());
/*     */     }
/*     */ 
/* 215 */     return super.postForAll(paramMethod, paramObject);
/*     */   }
/*     */ 
/*     */   @OnError(SQLException.class)
/*     */   protected void onErrorVoidForAll(Method paramMethod, SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/* 222 */     super.onErrorVoidForAll(paramMethod, paramSQLException);
/*     */   }
/*     */ 
/*     */   @OnError(SQLException.class)
/*     */   protected Object onErrorForAll(Method paramMethod, SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/* 229 */     return super.onErrorForAll(paramMethod, paramSQLException);
/*     */   }
/*     */ 
/*     */   @GetDelegate
/*     */   protected abstract Object getDelegate();
/*     */ 
/*     */   @SetDelegate
/*     */   protected abstract void setDelegate(Object paramObject);
/*     */ 
/*     */   @GetCreator
/*     */   protected abstract Object getCreator();
/*     */ 
/*     */   public InputStream getAsciiStream()
/*     */     throws SQLException
/*     */   {
/* 251 */     if (GETASCIISTREAM_METHOD == null)
/*     */     {
/* 253 */       throw DatabaseError.createSqlException(1, "Cannot get ascii stream");
/*     */     }
/*     */ 
/* 257 */     Method localMethod = GETASCIISTREAM_METHOD;
/*     */ 
/* 259 */     preForAll(localMethod, this, new Object[0]);
/*     */     try
/*     */     {
/* 263 */       OracleClob localOracleClob = (OracleClob)getDelegate();
/*     */       Object localObject;
/* 266 */       if (this.isFreed)
/*     */       {
/* 268 */         localObject = DatabaseError.createSqlException(localOracleClob.getInternalConnection(), 192);
/*     */ 
/* 271 */         ((SQLException)localObject).fillInStackTrace();
/* 272 */         throw ((Throwable)localObject);
/*     */       }
/*     */ 
/* 277 */       if (localOracleClob.canReadBasicLobDataInLocator())
/*     */       {
/* 279 */         localObject = localOracleClob.getAsciiStream();
/*     */       }
/*     */       else
/*     */       {
/* 283 */         localObject = localOracleClob.getDBAccess().newInputStream((OracleClob)this, localOracleClob.getBufferSize(), 0L);
/*     */       }
/*     */ 
/* 286 */       return (InputStream)postForAll(localMethod, localObject);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 290 */       return (InputStream)postForAll(localMethod, onErrorForAll(localMethod, localSQLException));
/*     */     }
/*     */   }
/*     */ 
/*     */   public InputStream getAsciiStream(long paramLong) throws SQLException
/*     */   {
/* 296 */     if (GETASCIISTREAM_LONG_METHOD == null)
/*     */     {
/* 298 */       throw DatabaseError.createSqlException(1, "Cannot get ascii stream");
/*     */     }
/*     */ 
/* 302 */     Method localMethod = GETASCIISTREAM_LONG_METHOD;
/*     */ 
/* 304 */     preForAll(localMethod, this, new Object[0]);
/*     */     try
/*     */     {
/* 308 */       OracleClob localOracleClob = (OracleClob)getDelegate();
/*     */       Object localObject;
/* 311 */       if (this.isFreed)
/*     */       {
/* 313 */         localObject = DatabaseError.createSqlException(localOracleClob.getInternalConnection(), 192);
/*     */ 
/* 316 */         ((SQLException)localObject).fillInStackTrace();
/* 317 */         throw ((Throwable)localObject);
/*     */       }
/*     */ 
/* 322 */       if (localOracleClob.canReadBasicLobDataInLocator())
/*     */       {
/* 324 */         localObject = localOracleClob.getAsciiStream(paramLong);
/*     */       }
/*     */       else
/*     */       {
/* 328 */         localObject = localOracleClob.getDBAccess().newInputStream((OracleClob)this, localOracleClob.getBufferSize(), paramLong);
/*     */       }
/*     */ 
/* 331 */       return (InputStream)postForAll(localMethod, localObject);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 335 */       return (InputStream)postForAll(localMethod, onErrorForAll(localMethod, localSQLException));
/*     */     }
/*     */   }
/*     */ 
/*     */   public Reader getCharacterStream() throws SQLException
/*     */   {
/* 341 */     if (GETCHARSTREAM_METHOD == null)
/*     */     {
/* 343 */       throw DatabaseError.createSqlException(1, "Cannot get character stream");
/*     */     }
/*     */ 
/* 347 */     Method localMethod = GETCHARSTREAM_METHOD;
/*     */ 
/* 349 */     preForAll(localMethod, this, new Object[0]);
/*     */     try
/*     */     {
/* 353 */       OracleClob localOracleClob = (OracleClob)getDelegate();
/*     */       Object localObject;
/* 356 */       if (this.isFreed)
/*     */       {
/* 358 */         localObject = DatabaseError.createSqlException(localOracleClob.getInternalConnection(), 192);
/*     */ 
/* 361 */         ((SQLException)localObject).fillInStackTrace();
/* 362 */         throw ((Throwable)localObject);
/*     */       }
/*     */ 
/* 367 */       if (localOracleClob.canReadBasicLobDataInLocator())
/*     */       {
/* 369 */         localObject = localOracleClob.getCharacterStream();
/*     */       }
/*     */       else
/*     */       {
/* 373 */         localObject = localOracleClob.getDBAccess().newReader((OracleClob)this, localOracleClob.getBufferSize(), 0L);
/*     */       }
/*     */ 
/* 376 */       return (Reader)postForAll(localMethod, localObject);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 380 */       return (Reader)postForAll(localMethod, onErrorForAll(localMethod, localSQLException));
/*     */     }
/*     */   }
/*     */ 
/*     */   public Reader getCharacterStream(long paramLong) throws SQLException
/*     */   {
/* 386 */     if (GETCHARSTREAM_LONG_METHOD == null)
/*     */     {
/* 388 */       throw DatabaseError.createSqlException(1, "Cannot get character stream");
/*     */     }
/*     */ 
/* 392 */     Method localMethod = GETCHARSTREAM_LONG_METHOD;
/*     */ 
/* 394 */     preForAll(localMethod, this, new Object[0]);
/*     */     try
/*     */     {
/* 398 */       OracleClob localOracleClob = (OracleClob)getDelegate();
/*     */       Object localObject;
/* 401 */       if (this.isFreed)
/*     */       {
/* 403 */         localObject = DatabaseError.createSqlException(localOracleClob.getInternalConnection(), 192);
/*     */ 
/* 406 */         ((SQLException)localObject).fillInStackTrace();
/* 407 */         throw ((Throwable)localObject);
/*     */       }
/*     */ 
/* 412 */       if (localOracleClob.canReadBasicLobDataInLocator())
/*     */       {
/* 414 */         localObject = localOracleClob.getCharacterStream(paramLong);
/*     */       }
/*     */       else
/*     */       {
/* 418 */         localObject = localOracleClob.getDBAccess().newReader((OracleClob)this, localOracleClob.getBufferSize(), paramLong);
/*     */       }
/*     */ 
/* 421 */       return (Reader)postForAll(localMethod, localObject);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 425 */       return (Reader)postForAll(localMethod, onErrorForAll(localMethod, localSQLException));
/*     */     }
/*     */   }
/*     */ 
/*     */   public Reader getCharacterStream(long paramLong1, long paramLong2)
/*     */     throws SQLException
/*     */   {
/* 432 */     if (GETCHARSTREAM_LONG_LONG_METHOD == null)
/*     */     {
/* 434 */       throw DatabaseError.createSqlException(1, "Cannot get character stream");
/*     */     }
/*     */ 
/* 438 */     Method localMethod = GETCHARSTREAM_LONG_LONG_METHOD;
/*     */ 
/* 440 */     preForAll(localMethod, this, new Object[0]);
/*     */     try
/*     */     {
/* 444 */       OracleClob localOracleClob = (OracleClob)getDelegate();
/*     */       Object localObject;
/* 447 */       if (this.isFreed)
/*     */       {
/* 449 */         localObject = DatabaseError.createSqlException(localOracleClob.getInternalConnection(), 192);
/*     */ 
/* 452 */         ((SQLException)localObject).fillInStackTrace();
/* 453 */         throw ((Throwable)localObject);
/*     */       }
/*     */ 
/* 458 */       if (localOracleClob.canReadBasicLobDataInLocator())
/*     */       {
/* 460 */         localObject = localOracleClob.getCharacterStream(paramLong1, paramLong2);
/*     */       }
/*     */       else
/*     */       {
/* 464 */         long l = localOracleClob.length();
/* 465 */         if ((paramLong1 < 1L) || (paramLong2 < 0L) || (paramLong1 > l) || (paramLong1 - 1L + paramLong2 > l))
/*     */         {
/* 467 */           SQLException localSQLException2 = DatabaseError.createSqlException(localOracleClob.getInternalConnection(), 68);
/*     */ 
/* 470 */           localSQLException2.fillInStackTrace();
/* 471 */           throw localSQLException2;
/*     */         }
/*     */ 
/* 474 */         localObject = localOracleClob.getDBAccess().newReader((OracleClob)this, localOracleClob.getBufferSize(), paramLong1, paramLong2);
/*     */       }
/*     */ 
/* 477 */       return (Reader)postForAll(localMethod, localObject);
/*     */     }
/*     */     catch (SQLException localSQLException1)
/*     */     {
/* 481 */       return (Reader)postForAll(localMethod, onErrorForAll(localMethod, localSQLException1));
/*     */     }
/*     */   }
/*     */ 
/*     */   public OutputStream setAsciiStream(long paramLong) throws SQLException
/*     */   {
/* 487 */     if (SETASCIISTREAM_LONG_METHOD == null)
/*     */     {
/* 489 */       throw DatabaseError.createSqlException(1, "Cannot set ascii stream");
/*     */     }
/*     */ 
/* 493 */     Method localMethod = SETASCIISTREAM_LONG_METHOD;
/*     */ 
/* 495 */     preForAll(localMethod, this, new Object[0]);
/*     */     try
/*     */     {
/* 499 */       OracleClob localOracleClob = (OracleClob)getDelegate();
/*     */ 
/* 502 */       if (this.isFreed)
/*     */       {
/* 504 */         localObject = DatabaseError.createSqlException(localOracleClob.getInternalConnection(), 192);
/*     */ 
/* 507 */         ((SQLException)localObject).fillInStackTrace();
/* 508 */         throw ((Throwable)localObject);
/*     */       }
/*     */ 
/* 511 */       Object localObject = localOracleClob.getDBAccess().newOutputStream((OracleClob)this, localOracleClob.getBufferSize(), paramLong, true);
/*     */ 
/* 514 */       return (OutputStream)postForAll(localMethod, localObject);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 518 */       return (OutputStream)postForAll(localMethod, onErrorForAll(localMethod, localSQLException));
/*     */     }
/*     */   }
/*     */ 
/*     */   public Writer setCharacterStream(long paramLong) throws SQLException
/*     */   {
/* 524 */     if (SETCHARSTREAM_LONG_METHOD == null)
/*     */     {
/* 526 */       throw DatabaseError.createSqlException(1, "Cannot set character stream");
/*     */     }
/*     */ 
/* 530 */     Method localMethod = SETCHARSTREAM_LONG_METHOD;
/*     */ 
/* 532 */     preForAll(localMethod, this, new Object[0]);
/*     */     try
/*     */     {
/* 536 */       OracleClob localOracleClob = (OracleClob)getDelegate();
/*     */ 
/* 539 */       if (this.isFreed)
/*     */       {
/* 541 */         localObject = DatabaseError.createSqlException(localOracleClob.getInternalConnection(), 192);
/*     */ 
/* 544 */         ((SQLException)localObject).fillInStackTrace();
/* 545 */         throw ((Throwable)localObject);
/*     */       }
/*     */ 
/* 548 */       Object localObject = localOracleClob.getDBAccess().newWriter((OracleClob)this, localOracleClob.getBufferSize(), paramLong, true);
/*     */ 
/* 551 */       return (Writer)postForAll(localMethod, localObject);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 555 */       return (Writer)postForAll(localMethod, onErrorForAll(localMethod, localSQLException));
/*     */     }
/*     */   }
/*     */ 
/*     */   public OutputStream getAsciiOutputStream()
/*     */     throws SQLException
/*     */   {
/* 562 */     return setAsciiStream(1L);
/*     */   }
/*     */ 
/*     */   public OutputStream getAsciiOutputStream(long paramLong)
/*     */     throws SQLException
/*     */   {
/* 568 */     return setAsciiStream(paramLong);
/*     */   }
/*     */ 
/*     */   public Writer getCharacterOutputStream()
/*     */     throws SQLException
/*     */   {
/* 574 */     return setCharacterStream(1L);
/*     */   }
/*     */ 
/*     */   public Writer getCharacterOutputStream(long paramLong)
/*     */     throws SQLException
/*     */   {
/* 580 */     return setCharacterStream(paramLong);
/*     */   }
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.MANUAL)
/*     */   public OracleConnection getInternalConnection()
/*     */     throws SQLException
/*     */   {
/* 587 */     OracleClob localOracleClob = (OracleClob)getDelegate();
/*     */ 
/* 590 */     return localOracleClob.getInternalConnection();
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.replay.driver.TxnReplayableClob
 * JD-Core Version:    0.6.2
 */