/*     */ package oracle.jdbc.replay.driver;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.lang.reflect.Method;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.ACProxyable;
/*     */ import oracle.jdbc.internal.OracleBlob;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.jdbc.proxy.annotation.GetCreator;
/*     */ import oracle.jdbc.proxy.annotation.GetDelegate;
/*     */ import oracle.jdbc.proxy.annotation.Methods;
/*     */ import oracle.jdbc.proxy.annotation.OnError;
/*     */ import oracle.jdbc.proxy.annotation.Post;
/*     */ import oracle.jdbc.proxy.annotation.Pre;
/*     */ import oracle.jdbc.proxy.annotation.ProxyAccess;
/*     */ import oracle.jdbc.proxy.annotation.ProxyFor;
/*     */ import oracle.jdbc.proxy.annotation.ProxyResult;
/*     */ import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
/*     */ import oracle.jdbc.proxy.annotation.SetDelegate;
/*     */ import oracle.sql.BlobDBAccess;
/*     */ 
/*     */ @ProxyFor({OracleBlob.class})
/*     */ @ProxyAccess(ACProxyable.class)
/*     */ public abstract class TxnReplayableBlob extends TxnReplayableBase
/*     */   implements JDBCReplayable
/*     */ {
/*  49 */   private static final Method GETBINSTREAM_METHOD = getGetBinaryStreamMethod();
/*  50 */   private static final Method GETBINSTREAM_LONG_METHOD = getGetBinaryStreamLongMethod();
/*  51 */   private static final Method GETBINSTREAM_LONG_LONG_METHOD = getGetBinaryStreamLongLongMethod();
/*  52 */   private static final Method SETBINSTREAM_LONG_METHOD = getSetBinaryStreamLongMethod();
/*     */ 
/*  54 */   protected boolean isFreed = false;
/*     */ 
/* 416 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */ 
/*     */   protected TxnReplayableBlob()
/*     */   {
/*  60 */     this.thisProxyNameInLog = ("BLOB" + this.thisProxyNameInLog);
/*     */   }
/*     */ 
/*     */   private static final Method getGetBinaryStreamMethod()
/*     */   {
/*     */     try
/*     */     {
/*  67 */       return OracleBlob.class.getMethod("getBinaryStream", new Class[0]);
/*     */     }
/*     */     catch (Exception localException) {
/*     */     }
/*  71 */     return null;
/*     */   }
/*     */ 
/*     */   private static final Method getGetBinaryStreamLongMethod()
/*     */   {
/*     */     try
/*     */     {
/*  79 */       return OracleBlob.class.getMethod("getBinaryStream", new Class[] { Long.TYPE });
/*     */     }
/*     */     catch (Exception localException) {
/*     */     }
/*  83 */     return null;
/*     */   }
/*     */ 
/*     */   private static final Method getGetBinaryStreamLongLongMethod()
/*     */   {
/*     */     try
/*     */     {
/*  91 */       return OracleBlob.class.getMethod("getBinaryStream", new Class[] { Long.TYPE, Long.TYPE });
/*     */     }
/*     */     catch (Exception localException) {
/*     */     }
/*  95 */     return null;
/*     */   }
/*     */ 
/*     */   private static final Method getSetBinaryStreamLongMethod()
/*     */   {
/*     */     try
/*     */     {
/* 103 */       return OracleBlob.class.getMethod("setBinaryStream", new Class[] { Long.TYPE });
/*     */     }
/*     */     catch (Exception localException) {
/*     */     }
/* 107 */     return null;
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   protected void preForAll(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/* 117 */     super.preForAll(paramMethod, paramObject, paramArrayOfObject);
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="free", args={})})
/*     */   protected void preForFree(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/* 127 */     this.isFreed = true;
/* 128 */     super.preForAll(paramMethod, paramObject, paramArrayOfObject);
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="setBytes", args={long.class, byte[].class}), @oracle.jdbc.proxy.annotation.Signature(name="setBytes", args={long.class, byte[].class, int.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="truncate", args={long.class})})
/*     */   protected void preForBlobWrites(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/* 141 */     TxnFailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*     */ 
/* 143 */     if (localReplayLifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
/* 144 */       return;
/*     */     }
/*     */ 
/* 148 */     if (this.failoverMngr != null)
/* 149 */       this.failoverMngr.disableReplayInternal(paramMethod, 371, "Replay disabled because of active transaction", null);
/*     */   }
/*     */ 
/*     */   @Post
/*     */   protected void postForAll(Method paramMethod)
/*     */   {
/* 163 */     postForAll(paramMethod, null);
/*     */   }
/*     */ 
/*     */   @Post
/*     */   protected Object postForAll(Method paramMethod, Object paramObject)
/*     */   {
/* 170 */     if ((paramObject instanceof TxnReplayableBase))
/*     */     {
/* 172 */       TxnReplayableBase localTxnReplayableBase = (TxnReplayableBase)paramObject;
/* 173 */       localTxnReplayableBase.setFailoverManager(getFailoverManager());
/*     */     }
/*     */ 
/* 176 */     return super.postForAll(paramMethod, paramObject);
/*     */   }
/*     */ 
/*     */   @OnError(SQLException.class)
/*     */   protected void onErrorVoidForAll(Method paramMethod, SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/* 183 */     super.onErrorVoidForAll(paramMethod, paramSQLException);
/*     */   }
/*     */ 
/*     */   @OnError(SQLException.class)
/*     */   protected Object onErrorForAll(Method paramMethod, SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/* 190 */     return super.onErrorForAll(paramMethod, paramSQLException);
/*     */   }
/*     */ 
/*     */   @GetDelegate
/*     */   protected abstract Object getDelegate();
/*     */ 
/*     */   @SetDelegate
/*     */   protected abstract void setDelegate(Object paramObject);
/*     */ 
/*     */   @GetCreator
/*     */   protected abstract Object getCreator();
/*     */ 
/*     */   public InputStream getBinaryStream()
/*     */     throws SQLException
/*     */   {
/* 212 */     if (GETBINSTREAM_METHOD == null)
/*     */     {
/* 214 */       throw DatabaseError.createSqlException(1, "Cannot get binary stream");
/*     */     }
/*     */ 
/* 218 */     Method localMethod = GETBINSTREAM_METHOD;
/*     */ 
/* 220 */     preForAll(localMethod, this, new Object[0]);
/*     */     try
/*     */     {
/* 224 */       OracleBlob localOracleBlob = (OracleBlob)getDelegate();
/*     */       Object localObject;
/* 227 */       if (this.isFreed)
/*     */       {
/* 229 */         localObject = DatabaseError.createSqlException(localOracleBlob.getInternalConnection(), 192);
/*     */ 
/* 232 */         ((SQLException)localObject).fillInStackTrace();
/* 233 */         throw ((Throwable)localObject);
/*     */       }
/*     */ 
/* 238 */       if (localOracleBlob.canReadBasicLobDataInLocator())
/*     */       {
/* 240 */         localObject = localOracleBlob.getBinaryStream();
/*     */       }
/*     */       else
/*     */       {
/* 244 */         localObject = localOracleBlob.getDBAccess().newInputStream((OracleBlob)this, localOracleBlob.getBufferSize(), 0L);
/*     */       }
/*     */ 
/* 247 */       return (InputStream)postForAll(localMethod, localObject);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 251 */       return (InputStream)postForAll(localMethod, onErrorForAll(localMethod, localSQLException));
/*     */     }
/*     */   }
/*     */ 
/*     */   public InputStream getBinaryStream(long paramLong) throws SQLException
/*     */   {
/* 257 */     if (GETBINSTREAM_LONG_METHOD == null)
/*     */     {
/* 259 */       throw DatabaseError.createSqlException(1, "Cannot get binary stream");
/*     */     }
/*     */ 
/* 263 */     Method localMethod = GETBINSTREAM_LONG_METHOD;
/*     */ 
/* 265 */     preForAll(localMethod, this, new Object[0]);
/*     */     try
/*     */     {
/* 269 */       OracleBlob localOracleBlob = (OracleBlob)getDelegate();
/*     */       Object localObject;
/* 272 */       if (this.isFreed)
/*     */       {
/* 274 */         localObject = DatabaseError.createSqlException(localOracleBlob.getInternalConnection(), 192);
/*     */ 
/* 277 */         ((SQLException)localObject).fillInStackTrace();
/* 278 */         throw ((Throwable)localObject);
/*     */       }
/*     */ 
/* 283 */       if (localOracleBlob.canReadBasicLobDataInLocator())
/*     */       {
/* 285 */         localObject = localOracleBlob.getBinaryStream(paramLong);
/*     */       }
/*     */       else
/*     */       {
/* 289 */         localObject = localOracleBlob.getDBAccess().newInputStream((OracleBlob)this, localOracleBlob.getBufferSize(), paramLong);
/*     */       }
/*     */ 
/* 292 */       return (InputStream)postForAll(localMethod, localObject);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 296 */       return (InputStream)postForAll(localMethod, onErrorForAll(localMethod, localSQLException));
/*     */     }
/*     */   }
/*     */ 
/*     */   public InputStream getBinaryStream(long paramLong1, long paramLong2)
/*     */     throws SQLException
/*     */   {
/* 303 */     if (GETBINSTREAM_LONG_LONG_METHOD == null)
/*     */     {
/* 305 */       throw DatabaseError.createSqlException(1, "Cannot get binary stream");
/*     */     }
/*     */ 
/* 309 */     Method localMethod = GETBINSTREAM_LONG_LONG_METHOD;
/*     */ 
/* 311 */     preForAll(localMethod, this, new Object[0]);
/*     */     try
/*     */     {
/* 315 */       OracleBlob localOracleBlob = (OracleBlob)getDelegate();
/*     */       Object localObject;
/* 318 */       if (this.isFreed)
/*     */       {
/* 320 */         localObject = DatabaseError.createSqlException(localOracleBlob.getInternalConnection(), 192);
/*     */ 
/* 323 */         ((SQLException)localObject).fillInStackTrace();
/* 324 */         throw ((Throwable)localObject);
/*     */       }
/*     */ 
/* 329 */       if (localOracleBlob.canReadBasicLobDataInLocator())
/*     */       {
/* 331 */         localObject = localOracleBlob.getBinaryStream(paramLong1, paramLong2);
/*     */       }
/*     */       else
/*     */       {
/* 335 */         long l = localOracleBlob.length();
/* 336 */         if ((paramLong1 < 1L) || (paramLong2 < 0L) || (paramLong1 > l) || (paramLong1 - 1L + paramLong2 > l))
/*     */         {
/* 338 */           SQLException localSQLException2 = DatabaseError.createSqlException(localOracleBlob.getInternalConnection(), 68);
/*     */ 
/* 341 */           localSQLException2.fillInStackTrace();
/* 342 */           throw localSQLException2;
/*     */         }
/*     */ 
/* 345 */         localObject = localOracleBlob.getDBAccess().newInputStream((OracleBlob)this, localOracleBlob.getBufferSize(), paramLong1, paramLong2);
/*     */       }
/*     */ 
/* 348 */       return (InputStream)postForAll(localMethod, localObject);
/*     */     }
/*     */     catch (SQLException localSQLException1)
/*     */     {
/* 352 */       return (InputStream)postForAll(localMethod, onErrorForAll(localMethod, localSQLException1));
/*     */     }
/*     */   }
/*     */ 
/*     */   public OutputStream setBinaryStream(long paramLong) throws SQLException
/*     */   {
/* 358 */     if (SETBINSTREAM_LONG_METHOD == null)
/*     */     {
/* 360 */       throw DatabaseError.createSqlException(1, "Cannot set binary stream");
/*     */     }
/*     */ 
/* 364 */     Method localMethod = SETBINSTREAM_LONG_METHOD;
/*     */ 
/* 366 */     preForAll(localMethod, this, new Object[0]);
/*     */     try
/*     */     {
/* 370 */       OracleBlob localOracleBlob = (OracleBlob)getDelegate();
/*     */ 
/* 373 */       if (this.isFreed)
/*     */       {
/* 375 */         localObject = DatabaseError.createSqlException(localOracleBlob.getInternalConnection(), 192);
/*     */ 
/* 378 */         ((SQLException)localObject).fillInStackTrace();
/* 379 */         throw ((Throwable)localObject);
/*     */       }
/*     */ 
/* 382 */       Object localObject = localOracleBlob.getDBAccess().newOutputStream((OracleBlob)this, localOracleBlob.getBufferSize(), paramLong, true);
/*     */ 
/* 385 */       return (OutputStream)postForAll(localMethod, localObject);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 389 */       return (OutputStream)postForAll(localMethod, onErrorForAll(localMethod, localSQLException));
/*     */     }
/*     */   }
/*     */ 
/*     */   public OutputStream getBinaryOutputStream()
/*     */     throws SQLException
/*     */   {
/* 396 */     return setBinaryStream(1L);
/*     */   }
/*     */ 
/*     */   public OutputStream getBinaryOutputStream(long paramLong)
/*     */     throws SQLException
/*     */   {
/* 402 */     return setBinaryStream(paramLong);
/*     */   }
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.MANUAL)
/*     */   public OracleConnection getInternalConnection()
/*     */     throws SQLException
/*     */   {
/* 409 */     OracleBlob localOracleBlob = (OracleBlob)getDelegate();
/*     */ 
/* 412 */     return localOracleBlob.getInternalConnection();
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.replay.driver.TxnReplayableBlob
 * JD-Core Version:    0.6.2
 */