/*     */ package oracle.jdbc.replay.driver;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.lang.reflect.Method;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.ACProxyable;
/*     */ import oracle.jdbc.internal.OracleBfile;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.jdbc.proxy.annotation.GetCreator;
/*     */ import oracle.jdbc.proxy.annotation.GetDelegate;
/*     */ import oracle.jdbc.proxy.annotation.OnError;
/*     */ import oracle.jdbc.proxy.annotation.Post;
/*     */ import oracle.jdbc.proxy.annotation.Pre;
/*     */ import oracle.jdbc.proxy.annotation.ProxyAccess;
/*     */ import oracle.jdbc.proxy.annotation.ProxyFor;
/*     */ import oracle.jdbc.proxy.annotation.ProxyResult;
/*     */ import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
/*     */ import oracle.jdbc.proxy.annotation.SetDelegate;
/*     */ import oracle.sql.BfileDBAccess;
/*     */ 
/*     */ @ProxyFor({OracleBfile.class})
/*     */ @ProxyAccess(ACProxyable.class)
/*     */ public abstract class TxnReplayableBfile extends TxnReplayableBase
/*     */   implements JDBCReplayable
/*     */ {
/*  46 */   private static final Method GETBINSTREAM_METHOD = getGetBinaryStreamMethod();
/*  47 */   private static final Method GETBINSTREAM_LONG_METHOD = getGetBinaryStreamLongMethod();
/*     */   private static final int MAX_CHUNK_SIZE = 32512;
/* 196 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */ 
/*     */   private static final Method getGetBinaryStreamMethod()
/*     */   {
/*     */     try
/*     */     {
/*  56 */       return OracleBfile.class.getMethod("getBinaryStream", new Class[0]);
/*     */     }
/*     */     catch (Exception localException) {
/*     */     }
/*  60 */     return null;
/*     */   }
/*     */ 
/*     */   private static final Method getGetBinaryStreamLongMethod()
/*     */   {
/*     */     try
/*     */     {
/*  68 */       return OracleBfile.class.getMethod("getBinaryStream", new Class[] { Long.TYPE });
/*     */     }
/*     */     catch (Exception localException) {
/*     */     }
/*  72 */     return null;
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   protected void preForAll(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/*  82 */     super.preForAll(paramMethod, paramObject, paramArrayOfObject);
/*     */   }
/*     */ 
/*     */   @Post
/*     */   protected void postForAll(Method paramMethod)
/*     */   {
/*  88 */     postForAll(paramMethod, null);
/*     */   }
/*     */ 
/*     */   @Post
/*     */   protected Object postForAll(Method paramMethod, Object paramObject)
/*     */   {
/*  95 */     if ((paramObject instanceof TxnReplayableBase))
/*     */     {
/*  97 */       TxnReplayableBase localTxnReplayableBase = (TxnReplayableBase)paramObject;
/*  98 */       localTxnReplayableBase.setFailoverManager(getFailoverManager());
/*     */     }
/*     */ 
/* 101 */     return super.postForAll(paramMethod, paramObject);
/*     */   }
/*     */ 
/*     */   @OnError(SQLException.class)
/*     */   protected void onErrorVoidForAll(Method paramMethod, SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/* 108 */     super.onErrorVoidForAll(paramMethod, paramSQLException);
/*     */   }
/*     */ 
/*     */   @OnError(SQLException.class)
/*     */   protected Object onErrorForAll(Method paramMethod, SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/* 115 */     return super.onErrorForAll(paramMethod, paramSQLException);
/*     */   }
/*     */   @GetDelegate
/*     */   protected abstract Object getDelegate();
/*     */ 
/*     */   @SetDelegate
/*     */   protected abstract void setDelegate(Object paramObject);
/*     */ 
/*     */   @GetCreator
/*     */   protected abstract Object getCreator();
/*     */ 
/* 129 */   public InputStream getBinaryStream() throws SQLException { if (GETBINSTREAM_METHOD == null)
/*     */     {
/* 131 */       throw DatabaseError.createSqlException(1, "Cannot get binary stream");
/*     */     }
/*     */ 
/* 135 */     Method localMethod = GETBINSTREAM_METHOD;
/*     */ 
/* 137 */     preForAll(localMethod, this, new Object[0]);
/*     */     try
/*     */     {
/* 141 */       OracleBfile localOracleBfile = (OracleBfile)getDelegate();
/*     */ 
/* 144 */       InputStream localInputStream = localOracleBfile.getDBAccess().newInputStream((OracleBfile)this, 32512, 0L);
/*     */ 
/* 148 */       return (InputStream)postForAll(localMethod, localInputStream);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 152 */       return (InputStream)postForAll(localMethod, onErrorForAll(localMethod, localSQLException));
/*     */     } }
/*     */ 
/*     */   public InputStream getBinaryStream(long paramLong)
/*     */     throws SQLException
/*     */   {
/* 158 */     if (GETBINSTREAM_LONG_METHOD == null)
/*     */     {
/* 160 */       throw DatabaseError.createSqlException(1, "Cannot get binary stream");
/*     */     }
/*     */ 
/* 164 */     Method localMethod = GETBINSTREAM_LONG_METHOD;
/*     */ 
/* 166 */     preForAll(localMethod, this, new Object[0]);
/*     */     try
/*     */     {
/* 170 */       OracleBfile localOracleBfile = (OracleBfile)getDelegate();
/*     */ 
/* 173 */       InputStream localInputStream = localOracleBfile.getDBAccess().newInputStream((OracleBfile)this, 32512, paramLong);
/*     */ 
/* 177 */       return (InputStream)postForAll(localMethod, localInputStream);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 181 */       return (InputStream)postForAll(localMethod, onErrorForAll(localMethod, localSQLException));
/*     */     }
/*     */   }
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.MANUAL)
/*     */   public OracleConnection getInternalConnection()
/*     */     throws SQLException
/*     */   {
/* 189 */     OracleBfile localOracleBfile = (OracleBfile)getDelegate();
/*     */ 
/* 192 */     return localOracleBfile.getInternalConnection();
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.replay.driver.TxnReplayableBfile
 * JD-Core Version:    0.6.2
 */