/*     */ package oracle.jdbc.replay.driver;
/*     */ 
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.sql.BatchUpdateException;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.SQLRecoverableException;
/*     */ import java.util.HashSet;
/*     */ import oracle.jdbc.internal.ACProxyable;
/*     */ import oracle.jdbc.internal.AdditionalDatabaseMetaData;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.jdbc.internal.OracleParameterMetaData;
/*     */ import oracle.jdbc.internal.OracleResultSetMetaData;
/*     */ import oracle.jdbc.internal.OracleRowId;
/*     */ import oracle.jdbc.internal.OracleSavepoint;
/*     */ import oracle.jdbc.internal.OracleTypeMetaData;
/*     */ import oracle.jdbc.internal.OracleTypeMetaData.Array;
/*     */ import oracle.jdbc.internal.OracleTypeMetaData.Opaque;
/*     */ import oracle.jdbc.internal.OracleTypeMetaData.Struct;
/*     */ import oracle.jdbc.proxy.annotation.GetCreator;
/*     */ import oracle.jdbc.proxy.annotation.GetDelegate;
/*     */ import oracle.jdbc.proxy.annotation.Methods;
/*     */ import oracle.jdbc.proxy.annotation.OnError;
/*     */ import oracle.jdbc.proxy.annotation.Post;
/*     */ import oracle.jdbc.proxy.annotation.Pre;
/*     */ import oracle.jdbc.proxy.annotation.ProxyAccess;
/*     */ import oracle.jdbc.proxy.annotation.ProxyFor;
/*     */ import oracle.jdbc.proxy.annotation.SetDelegate;
/*     */ import oracle.jdbc.replay.ReplayableConnection;
/*     */ 
/*     */ @ProxyFor({AdditionalDatabaseMetaData.class, OracleParameterMetaData.class, OracleRowId.class, OracleSavepoint.class, OracleTypeMetaData.class, OracleTypeMetaData.Array.class, OracleTypeMetaData.Opaque.class, OracleTypeMetaData.Struct.class, OracleResultSetMetaData.class})
/*     */ @ProxyAccess(ACProxyable.class)
/*     */ public abstract class TxnReplayableBase
/*     */   implements JDBCReplayable
/*     */ {
/*     */   protected TxnFailoverManagerImpl failoverMngr;
/*  67 */   protected TxnFailoverManagerImpl.CallHistoryEntry headSameProxy = null;
/*  68 */   protected TxnFailoverManagerImpl.CallHistoryEntry tailSameProxy = null;
/*     */ 
/*  71 */   protected TxnFailoverManagerImpl.CallHistoryEntry replayingCallEntry = null;
/*     */ 
/*  74 */   protected SQLRecoverableException originalError = null;
/*     */   protected static final int SVR_TXN_IN_REPLAY_ERROR_CODE1 = 603;
/*     */   protected static final int SVR_TXN_IN_REPLAY_ERROR_CODE2 = 29791;
/*  84 */   protected boolean isClosedAndNoReplay = false;
/*     */ 
/*  91 */   protected boolean isCreatingCallReplayable = true;
/*     */ 
/*  99 */   protected boolean isCurrentExecuteReplayable = true;
/*     */ 
/* 111 */   protected TxnFailoverManagerImpl.CallHistoryEntry creatorCallEntry = null;
/*     */ 
/* 114 */   protected long currentBindChecksum = 0L;
/*     */   private static final String PROXY_CLASS_SUFFIX = "$$$Proxy";
/* 119 */   protected String thisProxyNameInLog = "";
/*     */ 
/* 750 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */ 
/*     */   protected TxnReplayableBase()
/*     */   {
/* 128 */     StringBuffer localStringBuffer = new StringBuffer(getClass().getName());
/* 129 */     int i = localStringBuffer.indexOf("$$$Proxy");
/* 130 */     localStringBuffer.delete(0, i);
/* 131 */     localStringBuffer.append("@");
/* 132 */     localStringBuffer.append(Integer.toHexString(hashCode()));
/* 133 */     this.thisProxyNameInLog = localStringBuffer.toString();
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   protected void preForAll(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/* 143 */     TxnFailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*     */ 
/* 146 */     switch (1.$SwitchMap$oracle$jdbc$replay$driver$TxnFailoverManagerImpl$ReplayLifecycle[localReplayLifecycle.ordinal()])
/*     */     {
/*     */     case 1:
/* 149 */       this.failoverMngr.record(this, paramMethod, paramArrayOfObject, "started");
/*     */ 
/* 151 */       break;
/*     */     case 2:
/*     */     case 3:
/*     */     case 4:
/*     */     case 5:
/*     */     case 6:
/*     */     case 7:
/*     */     case 8:
/*     */     }
/*     */   }
/*     */ 
/*     */   @Post
/*     */   protected void postForAll(Method paramMethod)
/*     */   {
/* 167 */     postForAll(paramMethod, null);
/*     */   }
/*     */ 
/*     */   @Post
/*     */   protected Object postForAll(Method paramMethod, Object paramObject)
/*     */   {
/* 174 */     if ((paramObject instanceof TxnReplayableBase))
/*     */     {
/* 176 */       localObject = (TxnReplayableBase)paramObject;
/* 177 */       ((TxnReplayableBase)localObject).setFailoverManager(getFailoverManager());
/*     */     }
/*     */ 
/* 180 */     Object localObject = this.failoverMngr.getReplayLifecycle();
/*     */ 
/* 183 */     switch (1.$SwitchMap$oracle$jdbc$replay$driver$TxnFailoverManagerImpl$ReplayLifecycle[localObject.ordinal()])
/*     */     {
/*     */     case 1:
/*     */     case 8:
/* 189 */       doPostWhenRecording(paramMethod, paramObject, null);
/* 190 */       break;
/*     */     case 2:
/*     */     case 3:
/*     */     case 4:
/*     */     case 5:
/*     */     case 7:
/* 198 */       break;
/*     */     case 6:
/* 203 */       doPostWhenReplaying(paramMethod, paramObject, null);
/*     */     }
/*     */ 
/* 206 */     return paramObject;
/*     */   }
/*     */ 
/*     */   protected void doPostWhenRecording(Method paramMethod, Object paramObject, SQLException paramSQLException)
/*     */   {
/* 215 */     this.failoverMngr.update(this, null, paramObject, "completed", this.currentBindChecksum, paramSQLException);
/*     */ 
/* 219 */     this.currentBindChecksum = 0L;
/*     */   }
/*     */ 
/*     */   protected void doPostWhenReplaying(Method paramMethod, Object paramObject, SQLException paramSQLException)
/*     */   {
/*     */   }
/*     */ 
/*     */   @OnError(SQLException.class)
/*     */   protected void onErrorVoidForAll(Method paramMethod, SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/* 238 */     onErrorForAll(paramMethod, paramSQLException);
/*     */   }
/*     */ 
/*     */   @OnError(SQLException.class)
/*     */   protected Object onErrorForAll(Method paramMethod, SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/* 246 */     TxnReplayableBase localTxnReplayableBase = (TxnReplayableBase)this.failoverMngr.getConnectionProxy();
/*     */ 
/* 248 */     if (localTxnReplayableBase.isClosedAndNoReplay) {
/* 249 */       throw paramSQLException;
/*     */     }
/*     */ 
/* 252 */     if ((paramSQLException instanceof BatchUpdateException))
/*     */     {
/* 259 */       localObject = paramSQLException.getNextException();
/* 260 */       if ((localObject != null) && ((localObject instanceof SQLRecoverableException))) {
/* 261 */         paramSQLException = (SQLException)localObject;
/*     */       }
/*     */     }
/* 264 */     if ((paramSQLException instanceof SQLRecoverableException))
/*     */     {
/* 266 */       localObject = this.failoverMngr.getReplayLifecycle();
/*     */ 
/* 268 */       switch (1.$SwitchMap$oracle$jdbc$replay$driver$TxnFailoverManagerImpl$ReplayLifecycle[localObject.ordinal()])
/*     */       {
/*     */       case 1:
/* 275 */         this.failoverMngr.update(this, null, null, "incomplete", this.currentBindChecksum, paramSQLException);
/*     */ 
/* 279 */         this.currentBindChecksum = 0L;
/*     */       case 3:
/*     */       case 4:
/*     */       case 5:
/* 288 */         return this.failoverMngr.handleOutage((SQLRecoverableException)paramSQLException);
/*     */       case 8:
/* 296 */         this.failoverMngr.update(this, null, null, "incomplete", this.currentBindChecksum, paramSQLException);
/*     */ 
/* 300 */         this.currentBindChecksum = 0L;
/*     */       case 2:
/*     */       case 6:
/*     */       case 7:
/*     */       }
/*     */ 
/* 312 */       throw paramSQLException;
/*     */     }
/*     */ 
/* 319 */     Object localObject = this.failoverMngr.getReplayLifecycle();
/*     */ 
/* 321 */     switch (1.$SwitchMap$oracle$jdbc$replay$driver$TxnFailoverManagerImpl$ReplayLifecycle[localObject.ordinal()])
/*     */     {
/*     */     case 1:
/*     */     case 8:
/* 326 */       doPostWhenRecording(paramMethod, null, paramSQLException);
/*     */ 
/* 328 */       break;
/*     */     case 2:
/*     */     case 3:
/*     */     case 4:
/*     */     case 5:
/*     */     case 6:
/*     */     case 7:
/*     */     }
/*     */ 
/* 340 */     throw paramSQLException;
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="toString", args={})})
/*     */   protected void preForToString(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/*     */   }
/*     */ 
/*     */   @Post
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="toString", args={})})
/*     */   protected String postForToString(Method paramMethod, String paramString)
/*     */   {
/* 360 */     return paramString;
/*     */   }
/*     */ 
/*     */   @GetDelegate
/*     */   protected abstract Object getDelegate();
/*     */ 
/*     */   @SetDelegate
/*     */   protected abstract void setDelegate(Object paramObject);
/*     */ 
/*     */   @GetCreator
/*     */   protected abstract Object getCreator();
/*     */ 
/*     */   public Object replayOneCall(TxnFailoverManagerImpl.CallHistoryEntry paramCallHistoryEntry, SQLRecoverableException paramSQLRecoverableException)
/*     */     throws SQLException
/*     */   {
/* 423 */     Object localObject1 = null;
/*     */ 
/* 426 */     String str = ((TxnReplayableBase)paramCallHistoryEntry.jdbcProxy).thisProxyNameInLog;
/*     */     try
/*     */     {
/* 432 */       ((JDBCReplayable)paramCallHistoryEntry.jdbcProxy).setReplayingCallContext(paramCallHistoryEntry, paramSQLRecoverableException);
/*     */ 
/* 436 */       if (paramCallHistoryEntry.replayContext != null)
/*     */       {
/* 438 */         localObject2 = (TxnReplayableBase)this.failoverMngr.getConnectionProxy();
/*     */ 
/* 440 */         localObject3 = (OracleConnection)((TxnReplayableBase)localObject2).getDelegate();
/* 441 */         ((OracleConnection)localObject3).setReplayContext(paramCallHistoryEntry.replayContext);
/* 442 */         for (Object localObject6 : paramCallHistoryEntry.replayContext)
/*     */         {
/* 444 */           if (localObject6 != null);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 455 */       Object localObject2 = paramCallHistoryEntry.method.invoke(paramCallHistoryEntry.jdbcProxy, paramCallHistoryEntry.args);
/* 456 */       localObject1 = localObject2;
/*     */ 
/* 462 */       if ((localObject2 instanceof TxnReplayableBase))
/*     */       {
/* 464 */         localObject3 = this.failoverMngr.getReplayLifecycle();
/*     */ 
/* 466 */         if ((localObject3 == TxnFailoverManagerImpl.ReplayLifecycle.REPLAYING) && (localObject2 != null) && (paramCallHistoryEntry.result != null))
/*     */         {
/* 470 */           ??? = ((TxnReplayableBase)localObject2).getDelegate();
/* 471 */           ((TxnReplayableBase)paramCallHistoryEntry.result).setDelegate(???);
/* 472 */           localObject1 = paramCallHistoryEntry.result;
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (InvocationTargetException localInvocationTargetException)
/*     */     {
/* 478 */       Object localObject3 = localInvocationTargetException.getCause();
/*     */ 
/* 483 */       if ((localObject3 instanceof BatchUpdateException))
/*     */       {
/* 488 */         ??? = ((BatchUpdateException)localObject3).getNextException();
/*     */ 
/* 490 */         if ((??? != null) && ((??? instanceof SQLRecoverableException)))
/* 491 */           localObject3 = ???;
/*     */       }
/*     */       Object localObject5;
/* 495 */       if ((localObject3 instanceof SQLRecoverableException))
/*     */       {
/* 497 */         ??? = (SQLRecoverableException)localObject3;
/*     */ 
/* 499 */         localObject5 = ((SQLRecoverableException)???).getCause();
/* 500 */         if (localObject5 == null)
/*     */         {
/* 502 */           ??? = ((SQLRecoverableException)???).getErrorCode();
/* 503 */           if ((??? == 603) && (((SQLRecoverableException)???).getMessage().indexOf("ORA-29791") != -1))
/*     */           {
/* 508 */             paramSQLRecoverableException.setNextException((SQLException)???);
/* 509 */             this.failoverMngr.disableReplayAndThrowException(paramCallHistoryEntry.method, 390, "Replay failed because of active transaction during replay", paramSQLRecoverableException);
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 517 */         throw ((Throwable)???);
/*     */       }
/*     */ 
/* 521 */       if ((localObject3 instanceof SQLException))
/*     */       {
/* 523 */         ??? = (SQLException)localObject3;
/*     */ 
/* 525 */         localObject5 = this.failoverMngr.getReplayLifecycle();
/*     */ 
/* 532 */         if (((SQLException)???).getErrorCode() == 17290) {
/* 533 */           throw ((Throwable)???);
/*     */         }
/*     */ 
/* 538 */         if ((localObject5 == TxnFailoverManagerImpl.ReplayLifecycle.INTERNALLY_DISABLED) && (this.failoverMngr.didReplayingLastCallDisableReplay))
/*     */         {
/* 540 */           throw ((Throwable)???);
/*     */         }
/* 542 */         if ((paramCallHistoryEntry.callException == null) || (((SQLException)???).getErrorCode() != paramCallHistoryEntry.callException.getErrorCode()))
/*     */         {
/* 551 */           paramSQLRecoverableException.setNextException((SQLException)???);
/*     */ 
/* 553 */           this.failoverMngr.disableReplayAndThrowException(paramCallHistoryEntry.method, 389, "Replay failed because of error code or message mismatch", paramSQLRecoverableException);
/*     */         }
/* 569 */         else if (localObject5 == TxnFailoverManagerImpl.ReplayLifecycle.REPLAYING_LASTCALL) {
/* 570 */           throw ((Throwable)???);
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/* 577 */         this.failoverMngr.disableReplayAndThrowException(paramCallHistoryEntry.method, 370, "Replay disabled", paramSQLRecoverableException);
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Throwable localThrowable)
/*     */     {
/* 589 */       localThrowable.printStackTrace();
/*     */ 
/* 592 */       this.failoverMngr.disableReplayAndThrowException(paramCallHistoryEntry.method, 370, "Replay disabled", paramSQLRecoverableException);
/*     */     }
/*     */ 
/* 599 */     TxnFailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*     */ 
/* 601 */     switch (1.$SwitchMap$oracle$jdbc$replay$driver$TxnFailoverManagerImpl$ReplayLifecycle[localReplayLifecycle.ordinal()])
/*     */     {
/*     */     case 2:
/*     */     case 4:
/* 607 */       this.failoverMngr.throwReplayExceptionInternal(0, null, null);
/*     */     }
/*     */ 
/* 610 */     return localObject1;
/*     */   }
/*     */ 
/*     */   public void addToSameProxyList(TxnFailoverManagerImpl.CallHistoryEntry paramCallHistoryEntry)
/*     */   {
/* 615 */     paramCallHistoryEntry.prevEntrySameProxy = this.tailSameProxy;
/* 616 */     paramCallHistoryEntry.nextEntrySameProxy = null;
/*     */ 
/* 618 */     if (this.tailSameProxy != null) {
/* 619 */       this.tailSameProxy.nextEntrySameProxy = paramCallHistoryEntry;
/*     */     }
/* 621 */     this.tailSameProxy = paramCallHistoryEntry;
/*     */ 
/* 624 */     if (this.headSameProxy == null)
/* 625 */       this.headSameProxy = paramCallHistoryEntry;
/*     */   }
/*     */ 
/*     */   public void removeFromSameProxyList(TxnFailoverManagerImpl.CallHistoryEntry paramCallHistoryEntry)
/*     */   {
/* 630 */     if (paramCallHistoryEntry.nextEntrySameProxy != null) {
/* 631 */       paramCallHistoryEntry.nextEntrySameProxy.prevEntrySameProxy = paramCallHistoryEntry.prevEntrySameProxy;
/*     */     }
/*     */ 
/* 634 */     if (paramCallHistoryEntry.prevEntrySameProxy != null) {
/* 635 */       paramCallHistoryEntry.prevEntrySameProxy.nextEntrySameProxy = paramCallHistoryEntry.nextEntrySameProxy;
/*     */     }
/*     */ 
/* 638 */     if (this.headSameProxy == paramCallHistoryEntry) {
/* 639 */       this.headSameProxy = paramCallHistoryEntry.nextEntrySameProxy;
/*     */     }
/* 641 */     if (this.tailSameProxy == paramCallHistoryEntry)
/* 642 */       this.tailSameProxy = paramCallHistoryEntry.prevEntrySameProxy;
/*     */   }
/*     */ 
/*     */   public void purgeSameProxyList()
/*     */   {
/* 647 */     if (this.failoverMngr != null)
/*     */     {
/* 649 */       HashSet localHashSet = new HashSet();
/*     */ 
/* 652 */       for (Object localObject = this; 
/* 654 */         (localObject != null) && ((localObject instanceof TxnReplayableBase)) && (!(localObject instanceof ReplayableConnection)); 
/* 656 */         localObject = ((TxnReplayableBase)localObject).getCreator())
/*     */       {
/* 658 */         localHashSet.add(localObject);
/*     */       }
/*     */ 
/* 662 */       this.failoverMngr.purgeForSameProxy(localHashSet, this.headSameProxy);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setReplayingCallContext(TxnFailoverManagerImpl.CallHistoryEntry paramCallHistoryEntry, SQLRecoverableException paramSQLRecoverableException)
/*     */   {
/* 669 */     this.replayingCallEntry = paramCallHistoryEntry;
/* 670 */     this.originalError = paramSQLRecoverableException;
/*     */   }
/*     */ 
/*     */   public synchronized void setFailoverManager(TxnFailoverManagerImpl paramTxnFailoverManagerImpl)
/*     */   {
/* 675 */     this.failoverMngr = paramTxnFailoverManagerImpl;
/*     */   }
/*     */ 
/*     */   public synchronized TxnFailoverManagerImpl getFailoverManager()
/*     */   {
/* 680 */     return this.failoverMngr;
/*     */   }
/*     */ 
/*     */   private boolean isReplayFailure(Throwable paramThrowable)
/*     */   {
/* 690 */     boolean bool = false;
/*     */ 
/* 692 */     if ((paramThrowable instanceof SQLException))
/*     */     {
/* 694 */       int i = ((SQLException)paramThrowable).getErrorCode();
/* 695 */       if ((i >= 370) && (i < 400))
/*     */       {
/* 697 */         bool = true;
/*     */       }
/*     */     }
/* 700 */     return bool;
/*     */   }
/*     */ 
/*     */   protected boolean assertThrowablesMatch(Throwable paramThrowable1, Throwable paramThrowable2)
/*     */   {
/* 707 */     boolean bool1 = paramThrowable2 == null ? false : paramThrowable1.getClass().getName().equals(paramThrowable2.getClass().getName());
/*     */     boolean bool2;
/* 716 */     if (((paramThrowable1 instanceof SQLException)) && (bool1))
/*     */     {
/* 719 */       bool2 = ((SQLException)paramThrowable1).getErrorCode() == ((SQLException)paramThrowable2).getErrorCode();
/*     */     }
/* 725 */     else if (bool1)
/*     */     {
/* 728 */       String str1 = paramThrowable1.getMessage();
/* 729 */       String str2 = paramThrowable2.getMessage();
/* 730 */       bool2 = ((str1 == null) && (str2 == null)) || ((str1 != null) && (str2 != null) && (paramThrowable1.getMessage().equals(paramThrowable2.getMessage())));
/*     */     }
/*     */     else
/*     */     {
/* 738 */       bool2 = false;
/*     */     }
/*     */ 
/* 742 */     return bool2;
/*     */   }
/*     */ 
/*     */   public String toString() {
/* 746 */     return getDelegate().toString();
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.replay.driver.TxnReplayableBase
 * JD-Core Version:    0.6.2
 */