/*      */ package oracle.jdbc.replay.driver;
/*      */ 
/*      */ import java.lang.reflect.Method;
/*      */ import java.sql.CallableStatement;
/*      */ import java.sql.Connection;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.SQLRecoverableException;
/*      */ import java.sql.Statement;
/*      */ import java.util.Arrays;
/*      */ import java.util.EnumSet;
/*      */ import java.util.HashSet;
/*      */ import java.util.Set;
/*      */ import java.util.concurrent.ExecutorService;
/*      */ import java.util.concurrent.Executors;
/*      */ import java.util.concurrent.ThreadFactory;
/*      */ import oracle.jdbc.LogicalTransactionId;
/*      */ import oracle.jdbc.LogicalTransactionIdEvent;
/*      */ import oracle.jdbc.LogicalTransactionIdEventListener;
/*      */ import oracle.jdbc.driver.DatabaseError;
/*      */ import oracle.jdbc.internal.OracleConnection;
/*      */ import oracle.jdbc.internal.OracleConnection.ChecksumMode;
/*      */ import oracle.jdbc.internal.OracleConnection.ReplayOperation;
/*      */ import oracle.jdbc.internal.OracleConnection.TransactionState;
/*      */ import oracle.jdbc.internal.ReplayContext;
/*      */ import oracle.jdbc.replay.internal.ConnectionInitializationCallback;
/*      */ import oracle.jdbc.replay.internal.OracleDataSource;
/*      */ 
/*      */ class TxnFailoverManagerImpl
/*      */   implements TxnFailoverManager, LogicalTransactionIdEventListener
/*      */ {
/*      */   private static final String MONITOR_TXN = "BEGIN DBMS_APP_CONT_PRVT.MONITOR_TXN; END;";
/*      */   private static final String BEGIN_REPLAY = "BEGIN DBMS_APP_CONT_PRVT.BEGIN_REPLAY; END;";
/*      */   private static final String END_REPLAY = "BEGIN DBMS_APP_CONT_PRVT.END_REPLAY; END;";
/*      */   private CallHistoryEntry head;
/*      */   private CallHistoryEntry tail;
/*  165 */   private ReplayLifecycle lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
/*      */   private static final int DIRECTIVE_ENQUEUE_CALL = 1;
/*      */   private static final int DIRECTIVE_REQ_SCOPE_CRSR = 2;
/*      */   private static final int DIRECTIVE_REPLAY_ENABLED = 4;
/*      */   private static final int DIRECTIVE_EMPTY_QUEUE = 8;
/*      */   private Object replayResult;
/*      */   private long requestStartTime;
/*  193 */   private long replayInitiationTimeout = 300L;
/*      */   private static final int REPLAY_RETRIES = 3;
/*  197 */   private int replayRetries = 0;
/*      */ 
/*  200 */   private LogicalTransactionId ltxid = null;
/*      */ 
/*  203 */   private LogicalTransactionId oldLtxidForPrepareReplay = null;
/*      */ 
/*  208 */   private ReplayContext[] replayContext = null;
/*      */   private ReplayContext cxtBeforePrepareReplay;
/*  213 */   private OracleDataSource replayDataSource = null;
/*      */   private TxnReplayableBase connectionProxy;
/*      */   private String connectionProxyName;
/*      */   private Method callCausingReplayError;
/*      */   private int replayErrorCode;
/*      */   private String replayErrorMessage;
/*  228 */   private boolean doNotAbortConn = false;
/*      */ 
/*  231 */   private boolean isReplayInDynamicMode = true;
/*      */   private static final int QUEUE_NUMBER = 2;
/*      */   private static final int NOT_IN_QUEUE = -1;
/*  238 */   private static int activeQueues = 2;
/*      */   private static final int INIT_EMPTY_COUNT = 0;
/*      */   private static final int NA_EMPTY_COUNT = -1;
/*      */   private static final int REQ_SCOPE_EMPTY_COUNT = 2147483647;
/*  248 */   private int[] queueEmptyCounts = new int[2];
/*      */ 
/*  253 */   boolean seenRoundtripCallInRequest = false;
/*      */ 
/*  259 */   boolean didReplayingLastCallDisableReplay = false;
/*      */ 
/*  263 */   short nestedLevelOfTopLevelCalls = 0;
/*      */ 
/*  269 */   private static final HashSet<String> postExecuteGetCalls = new HashSet(Arrays.asList(new String[] { "getGeneratedKeys", "getMoreResults", "getResultSet", "getUpdateCount", "getMetaData", "getArray", "getBigDecimal", "getBlob", "getBoolean", "getByte", "getBytes", "getCharacterStream", "getClob", "getDate", "getDouble", "getFloat", "getInt", "getLong", "getNCharacterStream", "getNClob", "getNString", "getObject", "getRef", "getRowId", "getShort", "getSQLXML", "getString", "getTime", "getTimestamp", "getURL", "wasNull", "getReturnResultSet", "getARRAY", "getAsciiStream", "getBFILE", "getBfile", "getBinaryStream", "getBLOB", "getCHAR", "getCLOB", "getCursor", "getCustomDatum", "getORAData", "getAnyDataEmbeddedObject", "getDATE", "getNUMBER", "getOPAQUE", "getOracleObject", "getRAW", "getREF", "getROWID", "getSTRUCT", "getINTERVALYM", "getINTERVALDS", "getTIMESTAMP", "getTIMESTAMPTZ", "getTIMESTAMPLTZ", "getUnicodeStream", "getPlsqlIndexTable", "getOraclePlsqlIndexTable" }));
/*      */   private static final String NULL_METHOD_NAME = "NULL METHOD";
/*  344 */   private static final ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactory()
/*      */   {
/*      */     private static final String THREAD_NAME = "OJDBC-AC-WORKER-THREAD";
/*      */ 
/*      */     public Thread newThread(Runnable paramAnonymousRunnable)
/*      */     {
/*  352 */       Thread localThread = new Thread(null, paramAnonymousRunnable, "OJDBC-AC-WORKER-THREAD");
/*      */ 
/*  354 */       localThread.setPriority(5);
/*  355 */       localThread.setDaemon(true);
/*      */ 
/*  357 */       return localThread;
/*      */     } } );
/*      */   private static final String PREPARE_REPLAY = "DECLARE PROCEDURE PREPARE_REPLAY_WRAPPER(ltxid IN RAW, is_replay IN NUMBER, ac IN NUMBER, fncode IN BINARY_INTEGER, sql_text IN VARCHAR2, is_committed OUT NUMBER, is_embedded OUT NUMBER) IS attempting_replay BOOLEAN; auto_commit BOOLEAN; committed BOOLEAN; embedded BOOLEAN; BEGIN if is_replay = 1 then attempting_replay := true; else attempting_replay := false; end if; if ac = 1 then auto_commit := true; else auto_commit := false; end if; DBMS_APP_CONT_PRVT.PREPARE_REPLAY(ltxid, attempting_replay, auto_commit, fncode, sql_text, committed, embedded); if committed then is_committed := 1; else is_committed := 0; end if; if embedded then is_embedded := 1; else is_embedded := 0; end if; END; BEGIN PREPARE_REPLAY_WRAPPER(?,?,?,?,?,?,?); END;";
/* 2400 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */ 
/*      */   private TxnFailoverManagerImpl(TxnReplayableBase paramTxnReplayableBase, OracleDataSource paramOracleDataSource) throws SQLException {
/*  367 */     this.connectionProxy = paramTxnReplayableBase;
/*  368 */     this.connectionProxyName = this.connectionProxy.thisProxyNameInLog;
/*  369 */     this.replayDataSource = paramOracleDataSource;
/*      */ 
/*  373 */     OracleConnection localOracleConnection = (OracleConnection)paramTxnReplayableBase.getDelegate();
/*      */ 
/*  380 */     this.ltxid = localOracleConnection.getLogicalTransactionId();
/*  381 */     this.replayContext = null;
/*      */ 
/*  383 */     activeQueues = 2;
/*  384 */     this.queueEmptyCounts = new int[2];
/*  385 */     for (int i = 0; i < activeQueues; i++) {
/*  386 */       this.queueEmptyCounts[i] = 0;
/*      */     }
/*  388 */     localOracleConnection.addLogicalTransactionIdEventListener(this);
/*      */   }
/*      */ 
/*      */   static TxnFailoverManager getFailoverManager(TxnReplayableBase paramTxnReplayableBase, OracleDataSource paramOracleDataSource)
/*      */     throws SQLException
/*      */   {
/*  407 */     return new TxnFailoverManagerImpl(paramTxnReplayableBase, paramOracleDataSource);
/*      */   }
/*      */ 
/*      */   private void append(CallHistoryEntry paramCallHistoryEntry)
/*      */   {
/*  416 */     paramCallHistoryEntry.prevEntry = this.tail;
/*  417 */     paramCallHistoryEntry.nextEntry = null;
/*      */ 
/*  419 */     if (this.tail != null) {
/*  420 */       this.tail.nextEntry = paramCallHistoryEntry;
/*      */     }
/*  422 */     this.tail = paramCallHistoryEntry;
/*      */ 
/*  425 */     if (this.head == null) {
/*  426 */       this.head = paramCallHistoryEntry;
/*      */     }
/*      */ 
/*  429 */     JDBCReplayable localJDBCReplayable = (JDBCReplayable)paramCallHistoryEntry.jdbcProxy;
/*  430 */     localJDBCReplayable.addToSameProxyList(paramCallHistoryEntry);
/*      */   }
/*      */ 
/*      */   private void remove(CallHistoryEntry paramCallHistoryEntry)
/*      */   {
/*  435 */     if (paramCallHistoryEntry.nextEntry != null) {
/*  436 */       paramCallHistoryEntry.nextEntry.prevEntry = paramCallHistoryEntry.prevEntry;
/*      */     }
/*  438 */     if (paramCallHistoryEntry.prevEntry != null) {
/*  439 */       paramCallHistoryEntry.prevEntry.nextEntry = paramCallHistoryEntry.nextEntry;
/*      */     }
/*  441 */     if (this.head == paramCallHistoryEntry) {
/*  442 */       this.head = paramCallHistoryEntry.nextEntry;
/*      */     }
/*  444 */     if (this.tail == paramCallHistoryEntry) {
/*  445 */       this.tail = paramCallHistoryEntry.prevEntry;
/*      */     }
/*      */ 
/*  448 */     JDBCReplayable localJDBCReplayable = (JDBCReplayable)paramCallHistoryEntry.jdbcProxy;
/*  449 */     localJDBCReplayable.removeFromSameProxyList(paramCallHistoryEntry);
/*      */   }
/*      */ 
/*      */   CallHistoryEntry record(Object paramObject, Method paramMethod, Object[] paramArrayOfObject, String paramString)
/*      */   {
/*  459 */     if ((this.tail != null) && (this.tail.method != null) && ("started".equals(this.tail.callStatus)))
/*      */     {
/*  462 */       this.nestedLevelOfTopLevelCalls = ((short)(this.nestedLevelOfTopLevelCalls + 1));
/*      */ 
/*  467 */       return null;
/*      */     }
/*      */ 
/*  470 */     synchronized (this)
/*      */     {
/*  472 */       CallHistoryEntry localCallHistoryEntry = new CallHistoryEntry(paramObject, paramMethod, paramArrayOfObject, paramString);
/*      */ 
/*  477 */       append(localCallHistoryEntry);
/*      */ 
/*  481 */       return localCallHistoryEntry;
/*      */     }
/*      */   }
/*      */ 
/*      */   private String dumpHistory()
/*      */   {
/*  489 */     String str = "Dump History: \n";
/*  490 */     if (this.head != null)
/*      */     {
/*  492 */       CallHistoryEntry localCallHistoryEntry = this.head;
/*      */ 
/*  494 */       for (; ; localCallHistoryEntry = localCallHistoryEntry.nextEntry)
/*      */       {
/*  496 */         str = str + localCallHistoryEntry.toString();
/*  497 */         if (localCallHistoryEntry == this.tail)
/*      */           break;
/*      */       }
/*      */     }
/*  501 */     return str;
/*      */   }
/*      */ 
/*      */   void update(Object paramObject1, CallHistoryEntry paramCallHistoryEntry, Object paramObject2, String paramString, long paramLong, SQLException paramSQLException)
/*      */   {
/*  516 */     if (this.nestedLevelOfTopLevelCalls > 0)
/*      */     {
/*  519 */       this.nestedLevelOfTopLevelCalls = ((short)(this.nestedLevelOfTopLevelCalls - 1));
/*      */ 
/*  523 */       return; } 
/*      */ ReplayContext[] arrayOfReplayContext1 = null;
/*  527 */     int i = 0;
/*  528 */     ReplayContext[] arrayOfReplayContext2 = null;
/*  529 */     int j = -1;
/*  530 */     int k = 0;
/*  531 */     int m = 0;
/*  532 */     boolean bool = false;
/*      */     Object localObject2;
/*      */     int i2;
/*      */     CallHistoryEntry localCallHistoryEntry1;
/*      */     try { Object localObject1 = (OracleConnection)this.connectionProxy.getDelegate();
/*      */ 
/*  537 */       arrayOfReplayContext1 = ((OracleConnection)localObject1).getReplayContext();
/*      */ 
/*  547 */       localObject1 = paramCallHistoryEntry == null ? this.tail : paramCallHistoryEntry;
/*  548 */       if (i == 0)
/*      */       {
/*  551 */         if (arrayOfReplayContext1 != null)
/*      */         {
/*  556 */           this.replayContext = arrayOfReplayContext1;
/*  557 */           arrayOfReplayContext2 = new ReplayContext[arrayOfReplayContext1.length];
/*      */ 
/*  561 */           if (arrayOfReplayContext1.length > 0)
/*      */           {
/*  565 */             this.seenRoundtripCallInRequest = true;
/*      */           }
/*      */ 
/*  578 */           for (n = 0; n < arrayOfReplayContext1.length; n++)
/*      */           {
/*  580 */             localObject2 = arrayOfReplayContext1[n];
/*  581 */             i1 = (int)((ReplayContext)localObject2).getDirectives();
/*  582 */             i2 = ((ReplayContext)localObject2).getQueue();
/*      */ 
/*  587 */             if ((i1 & 0x4) == 0)
/*      */             {
/*  591 */               i = 1;
/*      */ 
/*  596 */               if (this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL) {
/*  597 */                 this.didReplayingLastCallDisableReplay = true;
/*      */               }
/*      */ 
/*  600 */               l1 = ((ReplayContext)localObject2).getErrorCode();
/*      */ 
/*  603 */               disableReplayInternal(((CallHistoryEntry)localObject1).method, 384, "Replay disabled by server Continuity Management", null);
/*      */               return;
/*      */             }
/*      */ 
/*  616 */             if ((i1 & 0x8) == 8)
/*      */             {
/*  621 */               this.queueEmptyCounts[i2] += 1;
/*      */             }
/*      */ 
/*  627 */             assert (((i1 & 0x1) == 1) || (!bool)) : "AC runtime: the server doesn't send ENQUEUE for all the RPCs of the same JDBC call";
/*      */ 
/*  630 */             if ((i1 & 0x1) == 1)
/*      */             {
/*  634 */               arrayOfReplayContext2[n] = localObject2;
/*      */ 
/*  637 */               j = i2;
/*  638 */               k = this.queueEmptyCounts[i2];
/*  639 */               bool = true;
/*      */             }
/*      */ 
/*  643 */             if ((i1 & 0x2) == 2)
/*      */             {
/*  648 */               m = 1;
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*      */         }
/*      */         else
/*      */         {
/*  659 */           if (((CallHistoryEntry)localObject1).replayContext != null) {
/*      */             return;
/*      */           }
/*  662 */           j = -1;
/*  663 */           k = 0;
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  668 */         disableReplayInternal(((CallHistoryEntry)localObject1).method, 383, "Replay disabled because getting replay context failed", null);
/*      */       }
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/*      */       int n;
/*      */       int i1;
/*      */       long l1;
/*  543 */       i = 1;
/*      */ 
/*  547 */       localCallHistoryEntry1 = paramCallHistoryEntry == null ? this.tail : paramCallHistoryEntry;
/*  548 */       if (i == 0)
/*      */       {
/*  551 */         if (arrayOfReplayContext1 != null)
/*      */         {
/*  556 */           this.replayContext = arrayOfReplayContext1;
/*  557 */           arrayOfReplayContext2 = new ReplayContext[arrayOfReplayContext1.length];
/*      */ 
/*  561 */           if (arrayOfReplayContext1.length > 0)
/*      */           {
/*  565 */             this.seenRoundtripCallInRequest = true;
/*      */           }
/*      */ 
/*  578 */           for (n = 0; n < arrayOfReplayContext1.length; n++)
/*      */           {
/*  580 */             localObject2 = arrayOfReplayContext1[n];
/*  581 */             i1 = (int)((ReplayContext)localObject2).getDirectives();
/*  582 */             i2 = ((ReplayContext)localObject2).getQueue();
/*      */ 
/*  587 */             if ((i1 & 0x4) == 0)
/*      */             {
/*  591 */               i = 1;
/*      */ 
/*  596 */               if (this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL) {
/*  597 */                 this.didReplayingLastCallDisableReplay = true;
/*      */               }
/*      */ 
/*  600 */               l1 = ((ReplayContext)localObject2).getErrorCode();
/*      */ 
/*  603 */               disableReplayInternal(localCallHistoryEntry1.method, 384, "Replay disabled by server Continuity Management", null);
/*      */               return;
/*      */             }
/*      */ 
/*  616 */             if ((i1 & 0x8) == 8)
/*      */             {
/*  621 */               this.queueEmptyCounts[i2] += 1;
/*      */             }
/*      */ 
/*  627 */             assert (((i1 & 0x1) == 1) || (!bool)) : "AC runtime: the server doesn't send ENQUEUE for all the RPCs of the same JDBC call";
/*      */ 
/*  630 */             if ((i1 & 0x1) == 1)
/*      */             {
/*  634 */               arrayOfReplayContext2[n] = localObject2;
/*      */ 
/*  637 */               j = i2;
/*  638 */               k = this.queueEmptyCounts[i2];
/*  639 */               bool = true;
/*      */             }
/*      */ 
/*  643 */             if ((i1 & 0x2) == 2)
/*      */             {
/*  648 */               m = 1;
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*      */         }
/*      */         else
/*      */         {
/*  659 */           if (localCallHistoryEntry1.replayContext != null) {
/*      */             return;
/*      */           }
/*  662 */           j = -1;
/*  663 */           k = 0;
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  668 */         disableReplayInternal(localCallHistoryEntry1.method, 383, "Replay disabled because getting replay context failed", null);
/*      */       }
/*      */     }
/*      */     finally
/*      */     {
/*  547 */       CallHistoryEntry localCallHistoryEntry2 = paramCallHistoryEntry == null ? this.tail : paramCallHistoryEntry;
/*  548 */       if (i == 0)
/*      */       {
/*  551 */         if (arrayOfReplayContext1 != null)
/*      */         {
/*  556 */           this.replayContext = arrayOfReplayContext1;
/*  557 */           arrayOfReplayContext2 = new ReplayContext[arrayOfReplayContext1.length];
/*      */ 
/*  561 */           if (arrayOfReplayContext1.length > 0)
/*      */           {
/*  565 */             this.seenRoundtripCallInRequest = true;
/*      */           }
/*      */ 
/*  578 */           for (int i4 = 0; i4 < arrayOfReplayContext1.length; i4++)
/*      */           {
/*  580 */             ReplayContext localReplayContext2 = arrayOfReplayContext1[i4];
/*  581 */             int i5 = (int)localReplayContext2.getDirectives();
/*  582 */             int i6 = localReplayContext2.getQueue();
/*      */ 
/*  587 */             if ((i5 & 0x4) == 0)
/*      */             {
/*  591 */               i = 1;
/*      */ 
/*  596 */               if (this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL) {
/*  597 */                 this.didReplayingLastCallDisableReplay = true;
/*      */               }
/*      */ 
/*  600 */               long l2 = localReplayContext2.getErrorCode();
/*      */ 
/*  603 */               disableReplayInternal(localCallHistoryEntry2.method, 384, "Replay disabled by server Continuity Management", null);
/*      */ 
/*  609 */               return;
/*      */             }
/*      */ 
/*  616 */             if ((i5 & 0x8) == 8)
/*      */             {
/*  621 */               this.queueEmptyCounts[i6] += 1;
/*      */             }
/*      */ 
/*  627 */             assert (((i5 & 0x1) == 1) || (!bool)) : "AC runtime: the server doesn't send ENQUEUE for all the RPCs of the same JDBC call";
/*      */ 
/*  630 */             if ((i5 & 0x1) == 1)
/*      */             {
/*  634 */               arrayOfReplayContext2[i4] = localReplayContext2;
/*      */ 
/*  637 */               j = i6;
/*  638 */               k = this.queueEmptyCounts[i6];
/*  639 */               bool = true;
/*      */             }
/*      */ 
/*  643 */             if ((i5 & 0x2) == 2)
/*      */             {
/*  648 */               m = 1;
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*      */         }
/*      */         else
/*      */         {
/*  659 */           if (localCallHistoryEntry2.replayContext != null) {
/*  660 */             return;
/*      */           }
/*  662 */           j = -1;
/*  663 */           k = 0;
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  668 */         disableReplayInternal(localCallHistoryEntry2.method, 383, "Replay disabled because getting replay context failed", null);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  677 */     if ((this.lifecycle != ReplayLifecycle.INTERNALLY_DISABLED) && (this.tail != null))
/*      */     {
/*  679 */       localCallHistoryEntry1 = paramCallHistoryEntry == null ? this.tail : paramCallHistoryEntry;
/*  680 */       synchronized (this)
/*      */       {
/*  682 */         localObject2 = (localCallHistoryEntry1 == null) || (localCallHistoryEntry1.method == null) ? "NULL METHOD" : localCallHistoryEntry1.method.getName();
/*      */ 
/*  687 */         localCallHistoryEntry1.result = paramObject2;
/*  688 */         localCallHistoryEntry1.checksum = paramLong;
/*      */         ReplayContext[] arrayOfReplayContext3;
/*  693 */         if (arrayOfReplayContext2 != null)
/*      */         {
/*  695 */           if (localCallHistoryEntry1.replayContext == null) {
/*  696 */             localCallHistoryEntry1.replayContext = arrayOfReplayContext2;
/*      */           }
/*      */           else
/*      */           {
/*  703 */             arrayOfReplayContext3 = new ReplayContext[localCallHistoryEntry1.replayContext.length + arrayOfReplayContext2.length];
/*      */ 
/*  705 */             System.arraycopy(localCallHistoryEntry1.replayContext, 0, arrayOfReplayContext3, 0, localCallHistoryEntry1.replayContext.length);
/*      */ 
/*  707 */             System.arraycopy(arrayOfReplayContext2, 0, arrayOfReplayContext3, localCallHistoryEntry1.replayContext.length, arrayOfReplayContext2.length);
/*  708 */             localCallHistoryEntry1.replayContext = arrayOfReplayContext3;
/*      */           }
/*      */         }
/*  711 */         localCallHistoryEntry1.callException = paramSQLException;
/*      */ 
/*  714 */         localCallHistoryEntry1.queueId = j;
/*  715 */         localCallHistoryEntry1.queueEmptyCount = k;
/*  716 */         localCallHistoryEntry1.serverAsksToEnqueue = bool;
/*      */ 
/*  723 */         localCallHistoryEntry1.callStatus = paramString;
/*      */ 
/*  727 */         if (arrayOfReplayContext2 != null) {
/*  728 */           for (ReplayContext localReplayContext1 : arrayOfReplayContext2)
/*      */           {
/*  730 */             if (localReplayContext1 != null);
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  742 */       if ((!isSessionStateConsistencyDynamic()) && (m != 0))
/*      */       {
/*  746 */         ??? = ((TxnReplayableResultSet)localCallHistoryEntry1.jdbcProxy).creatorCallEntry;
/*      */ 
/*  751 */         ((CallHistoryEntry)???).queueEmptyCount = 2147483647;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   synchronized void purge()
/*      */   {
/*  760 */     for (CallHistoryEntry localCallHistoryEntry = this.head; 
/*  761 */       localCallHistoryEntry != null; 
/*  762 */       localCallHistoryEntry = localCallHistoryEntry.nextEntry)
/*  763 */       remove(localCallHistoryEntry);
/*      */   }
/*      */ 
/*      */   synchronized void purgeForSameProxy(Set<Object> paramSet, CallHistoryEntry paramCallHistoryEntry)
/*      */   {
/*  774 */     Object localObject1 = paramCallHistoryEntry == null ? null : paramCallHistoryEntry.jdbcProxy;
/*      */ 
/*  782 */     for (CallHistoryEntry localCallHistoryEntry = paramCallHistoryEntry; 
/*  783 */       localCallHistoryEntry != null; 
/*  784 */       localCallHistoryEntry = localCallHistoryEntry.nextEntrySameProxy)
/*      */     {
/*  786 */       Object localObject2 = localCallHistoryEntry.result;
/*      */ 
/*  788 */       if ((localObject2 != null) && ((localObject2 instanceof JDBCReplayable)) && (!paramSet.contains(localObject2)))
/*      */       {
/*  792 */         JDBCReplayable localJDBCReplayable = (JDBCReplayable)localObject2;
/*  793 */         localJDBCReplayable.purgeSameProxyList();
/*      */ 
/*  796 */         paramSet.add(localJDBCReplayable);
/*      */       }
/*      */ 
/*  801 */       remove(localCallHistoryEntry);
/*      */     }
/*      */   }
/*      */ 
/*      */   synchronized boolean isEmpty()
/*      */   {
/*  807 */     return this.head == null;
/*      */   }
/*      */ 
/*      */   Object handleOutage(SQLRecoverableException paramSQLRecoverableException)
/*      */     throws SQLException
/*      */   {
/*  871 */     synchronized (this)
/*      */     {
/*  873 */       this.replayRetries = 0;
/*      */       do
/*      */       {
/*      */         try
/*      */         {
/*  898 */           return handleOutageInternal(paramSQLRecoverableException, this.replayRetries);
/*      */         }
/*      */         catch (SQLRecoverableException localSQLRecoverableException)
/*      */         {
/*  902 */           localReplayLifecycle = this.lifecycle;
/*      */ 
/*  905 */           switch (3.$SwitchMap$oracle$jdbc$replay$driver$TxnFailoverManagerImpl$ReplayLifecycle[localReplayLifecycle.ordinal()])
/*      */           {
/*      */           case 1:
/*      */           case 2:
/*      */           case 3:
/*  912 */             this.replayRetries += 1;
/*      */           case 4:
/*      */           case 5:
/*      */           case 6:
/*      */           case 7:
/*      */           case 8:
/*      */           }
/*      */ 
/*      */         }
/*      */         catch (SQLException localSQLException)
/*      */         {
/*  929 */           ReplayLifecycle localReplayLifecycle = this.lifecycle;
/*      */ 
/*  932 */           switch (3.$SwitchMap$oracle$jdbc$replay$driver$TxnFailoverManagerImpl$ReplayLifecycle[localReplayLifecycle.ordinal()])
/*      */           {
/*      */           case 8:
/*  936 */             this.replayRetries += 1;
/*      */ 
/*  938 */             this.lifecycle = ReplayLifecycle.REPLAYING;
/*      */           case 4:
/*      */           case 5:
/*      */           case 6:
/*      */           case 3:
/*      */           case 1:
/*      */           case 2:
/*      */           case 7:
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*  950 */         if (this.didReplayingLastCallDisableReplay)
/*      */         {
/*  959 */           throw localSQLException;
/*      */         }
/*      */ 
/*  964 */         throwOriginalExceptionWithReplayError(this.replayErrorCode, this.replayErrorMessage, paramSQLRecoverableException);
/*      */ 
/*  973 */         this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
/*      */ 
/*  978 */         throw localSQLException;
/*      */       }
/*      */ 
/*  987 */       while (this.replayRetries <= 3);
/*      */ 
/*  991 */       disableReplayAndThrowOriginalError(null, 378, "Replay disabled because maximum number of retries is exceeded", paramSQLRecoverableException);
/*      */ 
/*  997 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   synchronized Object handleOutageInternal(SQLRecoverableException paramSQLRecoverableException, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1011 */     this.didReplayingLastCallDisableReplay = false;
/*      */ 
/* 1014 */     ReplayLifecycle localReplayLifecycle = this.lifecycle;
/*      */ 
/* 1020 */     if ((this.lifecycle != ReplayLifecycle.ENABLED_NOT_REPLAYING) && (this.lifecycle != ReplayLifecycle.REPLAYING) && (this.lifecycle != ReplayLifecycle.REPLAYING_LASTCALL) && (this.lifecycle != ReplayLifecycle.REPLAYING_CALLBACK))
/*      */     {
/* 1026 */       if (this.replayErrorCode == 0)
/*      */       {
/* 1028 */         this.doNotAbortConn = true;
/* 1029 */         this.replayErrorCode = 370;
/* 1030 */         this.replayErrorMessage = "Replay disabled";
/*      */       }
/*      */ 
/* 1033 */       throwReplayExceptionInternal(this.replayErrorCode, this.replayErrorMessage, paramSQLRecoverableException);
/*      */     }
/*      */ 
/* 1038 */     OracleConnection localOracleConnection1 = (OracleConnection)this.connectionProxy.getDelegate();
/*      */ 
/* 1045 */     short s = localOracleConnection1.getExecutingRPCFunctionCode();
/*      */ 
/* 1053 */     String str1 = localOracleConnection1.getExecutingRPCSQL();
/*      */ 
/* 1068 */     ReplayContext localReplayContext = localOracleConnection1.getLastReplayContext();
/* 1069 */     if (localReplayContext != null) {
/* 1070 */       this.cxtBeforePrepareReplay = localReplayContext;
/*      */     }
/*      */ 
/* 1081 */     OracleConnection localOracleConnection2 = (OracleConnection)this.replayDataSource.getConnectionNoProxy(((TxnReplayableConnection)this.connectionProxy).originalUser, ((TxnReplayableConnection)this.connectionProxy).originalPasswd);
/*      */ 
/* 1086 */     if (localOracleConnection2 == null)
/*      */     {
/* 1089 */       disableReplayAndThrowException(null, 382, "Replay disabled because Failover_Retries is exceeded", paramSQLRecoverableException);
/*      */     }
/*      */ 
/* 1102 */     this.connectionProxy.setDelegate(localOracleConnection2);
/*      */ 
/* 1105 */     localOracleConnection2.setChecksumMode(OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_BINDS);
/*      */ 
/* 1108 */     this.oldLtxidForPrepareReplay = this.ltxid;
/*      */ 
/* 1116 */     this.ltxid = localOracleConnection2.getLogicalTransactionId();
/*      */ 
/* 1119 */     localOracleConnection2.addLogicalTransactionIdEventListener(this);
/*      */ 
/* 1130 */     String str2 = this.tail.method.getName();
/*      */ 
/* 1133 */     localOracleConnection2.setReplayContext(new ReplayContext[] { this.cxtBeforePrepareReplay });
/*      */ 
/* 1135 */     boolean bool = prepareReplay(localOracleConnection2, paramSQLRecoverableException, s, str1);
/*      */ 
/* 1143 */     if (bool)
/*      */     {
/* 1145 */       if (isSessionStateConsistencyDynamic())
/*      */       {
/* 1149 */         if (str2.equals("execute"))
/* 1150 */           return Boolean.valueOf(false);
/* 1151 */         if (str2.equals("commit")) {
/* 1152 */           return null;
/*      */         }
/* 1154 */         return null;
/*      */       }
/*      */ 
/* 1175 */       this.queueEmptyCounts[1] += 1;
/*      */     }
/*      */ 
/* 1185 */     long l = System.currentTimeMillis();
/*      */ 
/* 1188 */     if (this.requestStartTime + this.replayInitiationTimeout * 1000L < l)
/*      */     {
/* 1191 */       disableReplayAndThrowException(null, 377, "Replay disabled because ReplayInitiationTimeout is exceeded", paramSQLRecoverableException);
/*      */     }
/*      */ 
/* 1206 */     localOracleConnection2.getReplayContext();
/*      */ 
/* 1209 */     this.lifecycle = ReplayLifecycle.REPLAYING_CALLBACK;
/*      */ 
/* 1218 */     ConnectionInitializationCallback localConnectionInitializationCallback = this.replayDataSource.getConnectionInitializationCallback();
/*      */ 
/* 1220 */     if (localConnectionInitializationCallback != null)
/*      */     {
/*      */       try
/*      */       {
/* 1225 */         localConnectionInitializationCallback.initialize((Connection)this.connectionProxy);
/*      */       }
/*      */       catch (SQLRecoverableException localSQLRecoverableException)
/*      */       {
/* 1231 */         throw localSQLRecoverableException;
/*      */       }
/*      */       catch (SQLException localSQLException)
/*      */       {
/* 1236 */         disableReplayAndThrowException(null, 379, "Replay disabled because Init callback failed", paramSQLRecoverableException);
/*      */       }
/*      */ 
/* 1243 */       EnumSet localEnumSet = localOracleConnection2.getTransactionState();
/*      */ 
/* 1247 */       if (localEnumSet.contains(OracleConnection.TransactionState.TRANSACTION_STARTED))
/*      */       {
/* 1249 */         disableReplayAndThrowException(null, 380, "Replay disabled because of open transaction in Init callback", paramSQLRecoverableException);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1257 */     this.lifecycle = ReplayLifecycle.REPLAYING;
/*      */ 
/* 1267 */     beginReplay(localOracleConnection2, paramSQLRecoverableException);
/*      */ 
/* 1272 */     this.replayResult = replayAllBeforeLastCall(paramSQLRecoverableException);
/*      */ 
/* 1276 */     if ((this.tail.replayContext == null) || (this.tail.replayContext.length == 0))
/*      */     {
/* 1279 */       endReplay(localOracleConnection2, paramSQLRecoverableException);
/*      */     }
/*      */     else
/*      */     {
/* 1286 */       localOracleConnection2.registerEndReplayCallback(new EndReplayCallback(this, localOracleConnection2, paramSQLRecoverableException));
/*      */     }
/*      */ 
/* 1289 */     if (!bool)
/*      */     {
/* 1294 */       if (this.tail != null) {
/* 1295 */         this.replayResult = ((JDBCReplayable)this.tail.jdbcProxy).replayOneCall(this.tail, paramSQLRecoverableException);
/*      */       }
/*      */ 
/*      */     }
/* 1301 */     else if (!isSessionStateConsistencyDynamic())
/*      */     {
/* 1312 */       this.tail.callStatus = "completed";
/* 1313 */       this.tail.queueId = 1;
/* 1314 */       this.tail.queueEmptyCount = this.queueEmptyCounts[1];
/* 1315 */       this.tail.serverAsksToEnqueue = false;
/*      */ 
/* 1319 */       if (str2.equals("execute"))
/* 1320 */         this.replayResult = Boolean.valueOf(false);
/* 1321 */       else if (str2.equals("commit"))
/* 1322 */         this.replayResult = null;
/*      */       else {
/* 1324 */         this.replayResult = null;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1334 */     if (this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL) {
/* 1335 */       this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
/*      */     }
/*      */ 
/* 1341 */     return this.replayResult;
/*      */   }
/*      */ 
/*      */   private synchronized Object replayAllBeforeLastCall(SQLRecoverableException paramSQLRecoverableException)
/*      */     throws SQLException
/*      */   {
/* 1348 */     Object localObject = null;
/*      */ 
/* 1350 */     for (CallHistoryEntry localCallHistoryEntry = this.head; 
/* 1351 */       localCallHistoryEntry != this.tail; 
/* 1352 */       localCallHistoryEntry = localCallHistoryEntry.nextEntry)
/*      */     {
/* 1354 */       String str1 = localCallHistoryEntry.method == null ? "NULL METHOD" : localCallHistoryEntry.method.getName();
/*      */ 
/* 1356 */       TxnReplayableBase localTxnReplayableBase = (TxnReplayableBase)localCallHistoryEntry.jdbcProxy;
/* 1357 */       String str2 = localTxnReplayableBase.thisProxyNameInLog;
/*      */ 
/* 1394 */       if (((isSessionStateConsistencyDynamic()) && ((localCallHistoryEntry.replayContext == null) || (localCallHistoryEntry.serverAsksToEnqueue))) || ((!isSessionStateConsistencyDynamic()) && (localTxnReplayableBase.isCreatingCallReplayable) && (((localCallHistoryEntry.replayContext == null) && (!postExecuteGetCalls.contains(str1))) || ((localCallHistoryEntry.replayContext == null) && (postExecuteGetCalls.contains(str1)) && (localTxnReplayableBase.isCurrentExecuteReplayable)) || ((localCallHistoryEntry.serverAsksToEnqueue) && (localCallHistoryEntry.replayContext != null) && (localCallHistoryEntry.queueId >= 0) && (localCallHistoryEntry.queueId < this.queueEmptyCounts.length) && (localCallHistoryEntry.queueEmptyCount == this.queueEmptyCounts[localCallHistoryEntry.queueId])) || (localCallHistoryEntry.queueEmptyCount == 2147483647))))
/*      */       {
/* 1422 */         localObject = localTxnReplayableBase.replayOneCall(localCallHistoryEntry, paramSQLRecoverableException);
/*      */ 
/* 1426 */         if ((!isSessionStateConsistencyDynamic()) && ((localTxnReplayableBase instanceof TxnReplayableStatement)) && (str1.startsWith("execute")))
/*      */         {
/* 1431 */           localTxnReplayableBase.isCurrentExecuteReplayable = true;
/*      */         }
/*      */ 
/* 1436 */         if ((!isSessionStateConsistencyDynamic()) && (localCallHistoryEntry.result != null) && ((localCallHistoryEntry.result instanceof TxnReplayableBase)))
/*      */         {
/* 1440 */           ((TxnReplayableBase)localCallHistoryEntry.result).isCreatingCallReplayable = true;
/*      */         }
/*      */ 
/* 1445 */         if ((this.lifecycle != ReplayLifecycle.ENABLED_NOT_REPLAYING) && (this.lifecycle != ReplayLifecycle.REPLAYING) && (this.lifecycle != ReplayLifecycle.REPLAYING_LASTCALL) && (this.lifecycle != ReplayLifecycle.REPLAYING_CALLBACK))
/*      */         {
/* 1449 */           throwReplayExceptionInternal(this.replayErrorCode, this.replayErrorMessage, paramSQLRecoverableException);
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/* 1459 */         if ((!isSessionStateConsistencyDynamic()) && ((localTxnReplayableBase instanceof TxnReplayableStatement)) && (str1.startsWith("execute")))
/*      */         {
/* 1464 */           localTxnReplayableBase.isCurrentExecuteReplayable = false;
/*      */         }
/*      */ 
/* 1469 */         if ((!isSessionStateConsistencyDynamic()) && (localCallHistoryEntry.result != null) && ((localCallHistoryEntry.result instanceof TxnReplayableBase)))
/*      */         {
/* 1473 */           ((TxnReplayableBase)localCallHistoryEntry.result).isCreatingCallReplayable = false;
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1479 */     return localObject;
/*      */   }
/*      */ 
/*      */   ReplayLifecycle getReplayLifecycle()
/*      */   {
/* 1484 */     return this.lifecycle;
/*      */   }
/*      */ 
/*      */   void setDataSource(OracleDataSource paramOracleDataSource)
/*      */   {
/* 1489 */     this.replayDataSource = paramOracleDataSource;
/*      */   }
/*      */ 
/*      */   void setReplayInitiationTimeout(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1495 */     this.replayInitiationTimeout = paramInt;
/*      */   }
/*      */ 
/*      */   boolean isSessionStateConsistencyDynamic()
/*      */   {
/* 1500 */     return this.isReplayInDynamicMode;
/*      */   }
/*      */ 
/*      */   void setSessionStateConsistency(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 1506 */     this.isReplayInDynamicMode = (!paramBoolean);
/*      */   }
/*      */ 
/*      */   synchronized void beginRequest()
/*      */     throws SQLException
/*      */   {
/* 1516 */     if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED)
/*      */     {
/* 1519 */       return;
/*      */     }
/*      */ 
/* 1522 */     if (this.lifecycle != ReplayLifecycle.INTERNALLY_DISABLED) {
/* 1523 */       throw DatabaseError.createSqlException(391);
/*      */     }
/*      */ 
/* 1528 */     this.requestStartTime = System.currentTimeMillis();
/*      */ 
/* 1531 */     OracleConnection localOracleConnection = (OracleConnection)this.connectionProxy.getDelegate();
/*      */ 
/* 1543 */     localOracleConnection.getReplayContext();
/*      */ 
/* 1547 */     if (this.isReplayInDynamicMode) {
/* 1548 */       localOracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED));
/*      */     }
/*      */     else
/*      */     {
/* 1552 */       localOracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED));
/*      */     }
/*      */ 
/* 1562 */     EnumSet localEnumSet = localOracleConnection.getTransactionState();
/*      */ 
/* 1567 */     if ((localEnumSet.contains(OracleConnection.TransactionState.TRANSACTION_STARTED)) && (!localEnumSet.contains(OracleConnection.TransactionState.TRANSACTION_READONLY)))
/*      */     {
/* 1573 */       SQLException localSQLException = DatabaseError.createSqlException(392);
/*      */ 
/* 1577 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1581 */     this.replayErrorCode = 0;
/* 1582 */     this.replayErrorMessage = "";
/* 1583 */     this.callCausingReplayError = null;
/*      */ 
/* 1586 */     this.seenRoundtripCallInRequest = false;
/*      */ 
/* 1589 */     localOracleConnection.setChecksumMode(OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_BINDS);
/*      */ 
/* 1591 */     this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
/*      */   }
/*      */ 
/*      */   synchronized void endRequest()
/*      */     throws SQLException
/*      */   {
/* 1604 */     OracleConnection localOracleConnection = (OracleConnection)this.connectionProxy.getDelegate();
/*      */ 
/* 1608 */     localOracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_END));
/*      */ 
/* 1616 */     EnumSet localEnumSet = localOracleConnection.getTransactionState();
/*      */ 
/* 1621 */     if ((localEnumSet.contains(OracleConnection.TransactionState.TRANSACTION_STARTED)) && (!localEnumSet.contains(OracleConnection.TransactionState.TRANSACTION_READONLY)))
/*      */     {
/*      */       try
/*      */       {
/* 1628 */         localOracleConnection.rollback();
/*      */       }
/*      */       catch (SQLException localSQLException1)
/*      */       {
/*      */       }
/*      */ 
/* 1636 */       SQLException localSQLException2 = DatabaseError.createSqlException(393);
/*      */ 
/* 1640 */       throw localSQLException2;
/*      */     }
/*      */ 
/* 1645 */     if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED)
/*      */     {
/* 1649 */       return;
/*      */     }
/*      */ 
/* 1654 */     if ((this.lifecycle == ReplayLifecycle.INTERNALLY_DISABLED) || (this.lifecycle == ReplayLifecycle.EXTERNALLY_DISABLED))
/*      */     {
/* 1659 */       this.lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
/*      */ 
/* 1661 */       return;
/*      */     }
/*      */ 
/* 1665 */     disableReplayInternal(null, 381, "Replay disabled after endRequest is called", null);
/*      */   }
/*      */ 
/*      */   void disableReplay()
/*      */     throws SQLException
/*      */   {
/* 1680 */     if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED)
/*      */     {
/* 1683 */       return;
/*      */     }
/*      */ 
/* 1686 */     disableReplayInternal(null, 370, "Replay disabled", null);
/*      */ 
/* 1691 */     this.lifecycle = ReplayLifecycle.EXTERNALLY_DISABLED;
/*      */   }
/*      */ 
/*      */   void disableReplayInternal(Method paramMethod, int paramInt, String paramString, SQLRecoverableException paramSQLRecoverableException)
/*      */   {
/* 1710 */     ReplayLifecycle localReplayLifecycle = this.lifecycle;
/*      */ 
/* 1712 */     OracleConnection localOracleConnection = (OracleConnection)this.connectionProxy.getDelegate();
/*      */ 
/* 1717 */     if (this.lifecycle != ReplayLifecycle.ALWAYS_DISABLED) {
/* 1718 */       this.lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
/*      */     }
/*      */ 
/* 1721 */     purge();
/*      */ 
/* 1724 */     this.replayErrorCode = paramInt;
/* 1725 */     this.replayErrorMessage = paramString;
/*      */ 
/* 1727 */     this.callCausingReplayError = paramMethod;
/*      */ 
/* 1730 */     for (int i = 0; i < activeQueues; i++) {
/* 1731 */       this.queueEmptyCounts[i] = 0;
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/* 1737 */       localOracleConnection.setChecksumMode(OracleConnection.ChecksumMode.NO_CHECKSUM);
/*      */ 
/* 1749 */       if (!this.seenRoundtripCallInRequest)
/*      */       {
/* 1751 */         if (!this.isReplayInDynamicMode)
/*      */         {
/* 1755 */           localOracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC));
/*      */         }
/*      */         else
/*      */         {
/* 1763 */           localOracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN));
/*      */         }
/*      */ 
/*      */       }
/* 1779 */       else if (!this.isReplayInDynamicMode)
/*      */       {
/* 1783 */         localOracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC));
/*      */       }
/*      */       else
/*      */       {
/* 1790 */         localOracleConnection.setReplayOperations(EnumSet.noneOf(OracleConnection.ReplayOperation.class));
/*      */       }
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/*      */     }
/*      */   }
/*      */ 
/*      */   void failReplayInternal(Method paramMethod, int paramInt, String paramString, SQLRecoverableException paramSQLRecoverableException)
/*      */   {
/* 1809 */     ReplayLifecycle localReplayLifecycle = this.lifecycle;
/*      */ 
/* 1813 */     if ((this.lifecycle == ReplayLifecycle.REPLAYING) || (this.lifecycle == ReplayLifecycle.REPLAYING_CALLBACK) || (this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL))
/*      */     {
/* 1816 */       this.lifecycle = ReplayLifecycle.INTERNALLY_FAILED;
/*      */     }
/*      */ 
/* 1819 */     this.replayErrorCode = paramInt;
/* 1820 */     this.replayErrorMessage = paramString;
/*      */ 
/* 1822 */     this.callCausingReplayError = paramMethod;
/*      */   }
/*      */ 
/*      */   void throwReplayExceptionInternal(int paramInt, String paramString, SQLRecoverableException paramSQLRecoverableException)
/*      */     throws SQLException
/*      */   {
/* 1835 */     if (paramInt == 0) {
/* 1836 */       return;
/*      */     }
/* 1838 */     String str = this.callCausingReplayError == null ? "" : this.callCausingReplayError.getName();
/*      */ 
/* 1842 */     SQLException localSQLException = DatabaseError.createSqlException(this.replayErrorCode, str);
/*      */ 
/* 1845 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   void disableReplayAndThrowException(Method paramMethod, int paramInt, String paramString, SQLRecoverableException paramSQLRecoverableException)
/*      */     throws SQLException
/*      */   {
/* 1865 */     disableReplayInternal(paramMethod, paramInt, paramString, paramSQLRecoverableException);
/*      */ 
/* 1867 */     throwReplayExceptionInternal(paramInt, paramString, paramSQLRecoverableException);
/*      */   }
/*      */ 
/*      */   void disableReplayAndThrowOriginalError(Method paramMethod, int paramInt, String paramString, SQLRecoverableException paramSQLRecoverableException)
/*      */     throws SQLException
/*      */   {
/* 1877 */     disableReplayInternal(paramMethod, paramInt, paramString, paramSQLRecoverableException);
/*      */ 
/* 1879 */     throwOriginalExceptionWithReplayError(paramInt, paramString, paramSQLRecoverableException);
/*      */   }
/*      */ 
/*      */   void failReplayAndThrowException(Method paramMethod, int paramInt, String paramString, SQLRecoverableException paramSQLRecoverableException)
/*      */     throws SQLException
/*      */   {
/* 1897 */     failReplayInternal(paramMethod, paramInt, paramString, paramSQLRecoverableException);
/*      */ 
/* 1899 */     throwReplayExceptionInternal(paramInt, paramString, paramSQLRecoverableException);
/*      */   }
/*      */ 
/*      */   void throwOriginalExceptionWithReplayError(int paramInt, String paramString, SQLRecoverableException paramSQLRecoverableException)
/*      */     throws SQLRecoverableException
/*      */   {
/* 1934 */     if (!this.doNotAbortConn)
/*      */     {
/* 1937 */       killConnectionBeforeReplayDisabledException();
/*      */     }
/* 1939 */     String str = this.callCausingReplayError == null ? "" : this.callCausingReplayError.getName();
/*      */ 
/* 1944 */     SQLException localSQLException = DatabaseError.createSqlException(this.replayErrorCode, str);
/*      */ 
/* 1949 */     paramSQLRecoverableException.setNextException(localSQLException);
/*      */ 
/* 1954 */     throw paramSQLRecoverableException;
/*      */   }
/*      */ 
/*      */   void killConnectionBeforeReplayDisabledException()
/*      */   {
/* 1959 */     final OracleConnection localOracleConnection = (OracleConnection)this.connectionProxy.getDelegate();
/*      */     try
/*      */     {
/* 1964 */       localOracleConnection.abort();
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/* 1975 */       executor.submit(new Runnable()
/*      */       {
/*      */         public void run()
/*      */         {
/* 1980 */           TxnFailoverManagerImpl.this.closePhysicalConnection(localOracleConnection);
/*      */         }
/*      */       });
/*      */     }
/*      */     catch (Exception localException)
/*      */     {
/*      */     }
/*      */   }
/*      */ 
/*      */   void enableTxnMonitoring(OracleConnection paramOracleConnection)
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/* 2000 */       Statement localStatement = paramOracleConnection.createStatement();
/*      */ 
/* 2002 */       localStatement.execute("BEGIN DBMS_APP_CONT_PRVT.MONITOR_TXN; END;");
/*      */ 
/* 2005 */       localStatement.close();
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/* 2010 */       disableReplayInternal(null, 374, "Replay disabled because transaction monitoring failed to be enabled", null);
/*      */ 
/* 2017 */       this.lifecycle = ReplayLifecycle.ALWAYS_DISABLED;
/*      */ 
/* 2020 */       throw DatabaseError.createSqlException(395);
/*      */     }
/*      */   }
/*      */ 
/*      */   void beginReplay(OracleConnection paramOracleConnection, SQLRecoverableException paramSQLRecoverableException)
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/* 2033 */       Statement localStatement = paramOracleConnection.createStatement();
/*      */ 
/* 2035 */       localStatement.execute("BEGIN DBMS_APP_CONT_PRVT.BEGIN_REPLAY; END;");
/*      */ 
/* 2038 */       localStatement.close();
/* 2039 */       paramOracleConnection.setReplayingMode(true);
/* 2040 */       this.lifecycle = ReplayLifecycle.REPLAYING;
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/* 2045 */       disableReplayAndThrowException(null, 375, "Replay disabled because server begin_replay call failed", paramSQLRecoverableException);
/*      */     }
/*      */   }
/*      */ 
/*      */   void endReplay(OracleConnection paramOracleConnection, SQLRecoverableException paramSQLRecoverableException)
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/* 2061 */       Statement localStatement = paramOracleConnection.createStatement();
/*      */ 
/* 2063 */       localStatement.execute("BEGIN DBMS_APP_CONT_PRVT.END_REPLAY; END;");
/*      */ 
/* 2066 */       localStatement.close();
/* 2067 */       paramOracleConnection.setReplayingMode(false);
/*      */ 
/* 2072 */       paramOracleConnection.setReplayOperations(EnumSet.noneOf(OracleConnection.ReplayOperation.class));
/* 2073 */       if (!this.isReplayInDynamicMode) {
/* 2074 */         paramOracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED));
/*      */       }
/*      */       else
/*      */       {
/* 2079 */         paramOracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED));
/*      */       }
/*      */ 
/* 2083 */       paramOracleConnection.getReplayContext();
/*      */ 
/* 2085 */       this.lifecycle = ReplayLifecycle.REPLAYING_LASTCALL;
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/* 2090 */       disableReplayAndThrowException(null, 376, "Replay disabled because server end_replay call failed", paramSQLRecoverableException);
/*      */     }
/*      */   }
/*      */ 
/*      */   boolean prepareReplay(OracleConnection paramOracleConnection, SQLRecoverableException paramSQLRecoverableException, short paramShort, String paramString)
/*      */     throws SQLException
/*      */   {
/* 2148 */     boolean bool1 = false;
/* 2149 */     boolean bool2 = false;
/*      */     try
/*      */     {
/* 2173 */       if (!this.isReplayInDynamicMode) {
/* 2174 */         paramOracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_END, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC));
/*      */       }
/*      */ 
/* 2178 */       CallableStatement localCallableStatement = paramOracleConnection.prepareCall("DECLARE PROCEDURE PREPARE_REPLAY_WRAPPER(ltxid IN RAW, is_replay IN NUMBER, ac IN NUMBER, fncode IN BINARY_INTEGER, sql_text IN VARCHAR2, is_committed OUT NUMBER, is_embedded OUT NUMBER) IS attempting_replay BOOLEAN; auto_commit BOOLEAN; committed BOOLEAN; embedded BOOLEAN; BEGIN if is_replay = 1 then attempting_replay := true; else attempting_replay := false; end if; if ac = 1 then auto_commit := true; else auto_commit := false; end if; DBMS_APP_CONT_PRVT.PREPARE_REPLAY(ltxid, attempting_replay, auto_commit, fncode, sql_text, committed, embedded); if committed then is_committed := 1; else is_committed := 0; end if; if embedded then is_embedded := 1; else is_embedded := 0; end if; END; BEGIN PREPARE_REPLAY_WRAPPER(?,?,?,?,?,?,?); END;");
/*      */ 
/* 2181 */       localCallableStatement.setBytes(1, this.oldLtxidForPrepareReplay.getBytes());
/*      */ 
/* 2195 */       localCallableStatement.setInt(2, this.seenRoundtripCallInRequest ? 1 : 0);
/*      */ 
/* 2198 */       localCallableStatement.setInt(3, paramOracleConnection.getAutoCommit() ? 1 : 0);
/* 2199 */       localCallableStatement.setInt(4, paramShort);
/* 2200 */       localCallableStatement.setString(5, paramString);
/*      */ 
/* 2204 */       localCallableStatement.registerOutParameter(6, -7);
/* 2205 */       localCallableStatement.registerOutParameter(7, -7);
/*      */ 
/* 2207 */       localCallableStatement.execute();
/*      */ 
/* 2209 */       bool1 = localCallableStatement.getBoolean(6);
/* 2210 */       bool2 = localCallableStatement.getBoolean(7);
/*      */ 
/* 2214 */       localCallableStatement.close();
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/* 2221 */       localSQLException.printStackTrace();
/* 2222 */       disableReplayAndThrowException(null, 385, "Replay disabled because server prepare_replay call failed", paramSQLRecoverableException);
/*      */     }
/*      */ 
/* 2231 */     if (!bool2) {
/* 2232 */       return bool1;
/*      */     }
/*      */ 
/* 2236 */     disableReplayAndThrowException(null, 386, "Replay disabled because of embedded commit", paramSQLRecoverableException);
/*      */ 
/* 2242 */     return false;
/*      */   }
/*      */ 
/*      */   JDBCReplayable getConnectionProxy()
/*      */   {
/* 2248 */     return this.connectionProxy;
/*      */   }
/*      */ 
/*      */   private boolean isReplayFailure(SQLException paramSQLException)
/*      */   {
/* 2253 */     boolean bool = false;
/*      */ 
/* 2255 */     if ((paramSQLException instanceof SQLException))
/*      */     {
/* 2257 */       int i = paramSQLException.getErrorCode();
/* 2258 */       if ((i >= 370) && (i < 400))
/*      */       {
/* 2260 */         bool = true;
/*      */       }
/*      */     }
/* 2263 */     return bool;
/*      */   }
/*      */ 
/*      */   private void closePhysicalConnection(Connection paramConnection)
/*      */   {
/*      */     try
/*      */     {
/* 2270 */       paramConnection.close();
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/*      */     }
/*      */   }
/*      */ 
/*      */   LogicalTransactionId getLogicalTransactionId()
/*      */   {
/* 2280 */     return this.ltxid;
/*      */   }
/*      */ 
/*      */   void setLogicalTransactionId(LogicalTransactionId paramLogicalTransactionId)
/*      */   {
/* 2287 */     this.ltxid = paramLogicalTransactionId;
/*      */   }
/*      */ 
/*      */   public void onLogicalTransactionIdEvent(LogicalTransactionIdEvent paramLogicalTransactionIdEvent)
/*      */   {
/* 2298 */     LogicalTransactionId localLogicalTransactionId = paramLogicalTransactionIdEvent.getLogicalTransactionId();
/*      */ 
/* 2302 */     setLogicalTransactionId(localLogicalTransactionId);
/*      */   }
/*      */ 
/*      */   ReplayContext[] getReplayContext()
/*      */   {
/* 2307 */     return this.replayContext;
/*      */   }
/*      */ 
/*      */   void setReplayContext(ReplayContext[] paramArrayOfReplayContext)
/*      */   {
/* 2314 */     this.replayContext = paramArrayOfReplayContext;
/*      */   }
/*      */ 
/*      */   void addActiveQueues(int paramInt)
/*      */   {
/* 2329 */     int i = (paramInt + 1 - this.queueEmptyCounts.length) / 2 * 2;
/*      */ 
/* 2331 */     int j = this.queueEmptyCounts.length + i;
/* 2332 */     int[] arrayOfInt = new int[j];
/* 2333 */     System.arraycopy(this.queueEmptyCounts, 0, arrayOfInt, 0, this.queueEmptyCounts.length);
/*      */ 
/* 2336 */     for (int k = this.queueEmptyCounts.length; k <= paramInt; k++) {
/* 2337 */       arrayOfInt[k] = 0;
/*      */     }
/*      */ 
/* 2340 */     for (k = paramInt + 1; k <= j; k++) {
/* 2341 */       arrayOfInt[k] = 0;
/*      */     }
/*      */ 
/* 2344 */     synchronized (this)
/*      */     {
/* 2346 */       this.queueEmptyCounts = arrayOfInt;
/* 2347 */       activeQueues = j;
/*      */     }
/*      */   }
/*      */ 
/*      */   static enum ReplayLifecycle
/*      */   {
/*  155 */     ENABLED_NOT_REPLAYING, 
/*  156 */     INTERNALLY_FAILED, 
/*  157 */     INTERNALLY_DISABLED, 
/*  158 */     ALWAYS_DISABLED, 
/*  159 */     EXTERNALLY_DISABLED, 
/*  160 */     REPLAYING_CALLBACK, 
/*  161 */     REPLAYING, 
/*  162 */     REPLAYING_LASTCALL;
/*      */   }
/*      */ 
/*      */   static class CallHistoryEntry
/*      */   {
/*      */     Object jdbcProxy;
/*      */     Method method;
/*      */     Object[] args;
/*      */     Object result;
/*      */     String callStatus;
/*      */     long checksum;
/*      */     boolean openAcrossPurge;
/*      */     int queueId;
/*      */     int queueEmptyCount;
/*      */     ReplayContext[] replayContext;
/*      */     boolean serverAsksToEnqueue;
/*      */     SQLException callException;
/*   80 */     CallHistoryEntry nextEntry = null;
/*   81 */     CallHistoryEntry prevEntry = null;
/*      */ 
/*   84 */     CallHistoryEntry nextEntrySameProxy = null;
/*   85 */     CallHistoryEntry prevEntrySameProxy = null;
/*      */ 
/*      */     CallHistoryEntry(Object paramObject, Method paramMethod, Object[] paramArrayOfObject, String paramString)
/*      */     {
/*   90 */       this.jdbcProxy = paramObject;
/*   91 */       this.method = paramMethod;
/*   92 */       this.args = paramArrayOfObject;
/*   93 */       this.result = null;
/*   94 */       this.callStatus = paramString;
/*      */ 
/*   96 */       this.openAcrossPurge = false;
/*      */     }
/*      */ 
/*      */     public String toString() {
/*  100 */       String str = "CallHistoryEntry: method.getName()=" + this.method.getName() + ", queueId=" + this.queueId + ", queueEmptyCount=" + this.queueEmptyCount + ", serverAsksToEnqueue=" + this.serverAsksToEnqueue + ", replayContext=" + this.replayContext;
/*      */ 
/*  104 */       if (this.replayContext != null)
/*      */       {
/*  106 */         for (int i = 0; i < this.replayContext.length; i++)
/*  107 */           str = str + this.replayContext[i];
/*      */       }
/*  109 */       return str + "\n";
/*      */     }
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.replay.driver.TxnFailoverManagerImpl
 * JD-Core Version:    0.6.2
 */