/*      */ package oracle.jdbc.replay.driver;
/*      */ 
/*      */ import java.io.InputStream;
/*      */ import java.io.Reader;
/*      */ import java.lang.reflect.Method;
/*      */ import java.sql.Array;
/*      */ import java.sql.Blob;
/*      */ import java.sql.CallableStatement;
/*      */ import java.sql.Clob;
/*      */ import java.sql.Connection;
/*      */ import java.sql.NClob;
/*      */ import java.sql.ParameterMetaData;
/*      */ import java.sql.PreparedStatement;
/*      */ import java.sql.Ref;
/*      */ import java.sql.ResultSet;
/*      */ import java.sql.ResultSetMetaData;
/*      */ import java.sql.RowId;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.SQLRecoverableException;
/*      */ import java.sql.SQLXML;
/*      */ import java.sql.Statement;
/*      */ import java.sql.Struct;
/*      */ import java.util.EnumSet;
/*      */ import oracle.jdbc.internal.OracleConnection;
/*      */ import oracle.jdbc.internal.OracleConnection.TransactionState;
/*      */ import oracle.jdbc.internal.OracleStatement.SqlKind;
/*      */ import oracle.jdbc.proxy.annotation.GetCreator;
/*      */ import oracle.jdbc.proxy.annotation.GetDelegate;
/*      */ import oracle.jdbc.proxy.annotation.Methods;
/*      */ import oracle.jdbc.proxy.annotation.OnError;
/*      */ import oracle.jdbc.proxy.annotation.Post;
/*      */ import oracle.jdbc.proxy.annotation.Pre;
/*      */ import oracle.jdbc.proxy.annotation.ProxyFor;
/*      */ import oracle.jdbc.proxy.annotation.ProxyResult;
/*      */ import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
/*      */ import oracle.jdbc.proxy.annotation.SetDelegate;
/*      */ 
/*      */ @ProxyFor({CallableStatement.class, PreparedStatement.class, Statement.class, oracle.jdbc.OracleCallableStatement.class, oracle.jdbc.OraclePreparedStatement.class, oracle.jdbc.OracleStatement.class, oracle.jdbc.internal.OracleCallableStatement.class, oracle.jdbc.internal.OraclePreparedStatement.class, oracle.jdbc.internal.OracleStatement.class})
/*      */ public abstract class NonTxnReplayableStatement extends NonTxnReplayableBase
/*      */   implements Replayable
/*      */ {
/* 1114 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */ 
/*      */   @Pre
/*      */   protected void preForAll(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*      */   {
/*   84 */     super.preForAll(paramMethod, paramObject, paramArrayOfObject);
/*      */   }
/*      */ 
/*      */   @Pre
/*      */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="execute", args={}), @oracle.jdbc.proxy.annotation.Signature(name="execute", args={String.class}), @oracle.jdbc.proxy.annotation.Signature(name="execute", args={String.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="execute", args={String.class, int[].class}), @oracle.jdbc.proxy.annotation.Signature(name="execute", args={String.class, String[].class})})
/*      */   protected void preForExecute(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*      */   {
/*   99 */     FailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*      */ 
/*  101 */     if (localReplayLifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
/*  102 */       return;
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  108 */       oracle.jdbc.internal.OracleStatement localOracleStatement = (oracle.jdbc.internal.OracleStatement)getDelegate();
/*  109 */       OracleStatement.SqlKind localSqlKind = localOracleStatement.getSqlKind();
/*      */ 
/*  116 */       if ((localSqlKind.isSELECT()) || (localSqlKind.isPlsqlOrCall()) || (localSqlKind == OracleStatement.SqlKind.ALTER_SESSION) || (localSqlKind == OracleStatement.SqlKind.UNINITIALIZED))
/*      */       {
/*  123 */         preForAll(paramMethod, paramObject, paramArrayOfObject);
/*      */       }
/*  127 */       else if (localSqlKind.isDML())
/*      */       {
/*  129 */         if (this.failoverMngr != null) {
/*  130 */           this.failoverMngr.disableReplayInternal(paramMethod, 371, "Replay disabled because of active transaction", null);
/*      */         }
/*      */ 
/*      */       }
/*  143 */       else if (localSqlKind.isOTHER())
/*      */       {
/*  145 */         if (this.failoverMngr != null)
/*  146 */           this.failoverMngr.disableReplayInternal(paramMethod, 372, "Replay disabled because of nonreplayable call", null);
/*      */       }
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/*      */     }
/*      */   }
/*      */ 
/*      */   @Pre
/*      */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="executeUpdate", args={}), @oracle.jdbc.proxy.annotation.Signature(name="executeUpdate", args={String.class}), @oracle.jdbc.proxy.annotation.Signature(name="executeUpdate", args={String.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="executeUpdate", args={String.class, int[].class}), @oracle.jdbc.proxy.annotation.Signature(name="executeUpdate", args={String.class, String[].class})})
/*      */   protected void preForExecuteUpdate(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*      */   {
/*  175 */     FailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*      */ 
/*  177 */     if (localReplayLifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
/*  178 */       return;
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  185 */       oracle.jdbc.internal.OracleStatement localOracleStatement = (oracle.jdbc.internal.OracleStatement)getDelegate();
/*  186 */       OracleStatement.SqlKind localSqlKind = localOracleStatement.getSqlKind();
/*      */ 
/*  189 */       if (localSqlKind.isPlsqlOrCall())
/*      */       {
/*  191 */         preForAll(paramMethod, paramObject, paramArrayOfObject);
/*      */       }
/*  193 */       else if (this.failoverMngr != null)
/*  194 */         this.failoverMngr.disableReplayInternal(paramMethod, 371, "Replay disabled because of active transaction", null);
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/*      */     }
/*      */   }
/*      */ 
/*      */   @Pre
/*      */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="executeBatch", args={})})
/*      */   protected void preForExecuteBatch(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*      */   {
/*  216 */     FailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*      */ 
/*  218 */     if (localReplayLifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
/*  219 */       return;
/*      */     }
/*      */ 
/*  224 */     if (this.failoverMngr != null)
/*  225 */       this.failoverMngr.disableReplayInternal(paramMethod, 372, "Replay disabled because of nonreplayable call", null);
/*      */   }
/*      */ 
/*      */   @Pre
/*      */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="setAsciiStream", args={String.class, InputStream.class}), @oracle.jdbc.proxy.annotation.Signature(name="setAsciiStream", args={String.class, InputStream.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="setAsciiStream", args={String.class, InputStream.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="setBinaryStream", args={String.class, InputStream.class}), @oracle.jdbc.proxy.annotation.Signature(name="setBinaryStream", args={String.class, InputStream.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="setBinaryStream", args={String.class, InputStream.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="setCharacterStream", args={String.class, Reader.class}), @oracle.jdbc.proxy.annotation.Signature(name="setCharacterStream", args={String.class, Reader.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="setCharacterStream", args={String.class, Reader.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="setNCharacterStream", args={String.class, Reader.class}), @oracle.jdbc.proxy.annotation.Signature(name="setNCharacterStream", args={String.class, Reader.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="setAsciiStream", args={int.class, InputStream.class}), @oracle.jdbc.proxy.annotation.Signature(name="setAsciiStream", args={int.class, InputStream.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="setAsciiStream", args={int.class, InputStream.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="setBinaryStream", args={int.class, InputStream.class}), @oracle.jdbc.proxy.annotation.Signature(name="setBinaryStream", args={int.class, InputStream.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="setBinaryStream", args={int.class, InputStream.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="setCharacterStream", args={int.class, Reader.class}), @oracle.jdbc.proxy.annotation.Signature(name="setCharacterStream", args={int.class, Reader.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="setCharacterStream", args={int.class, Reader.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="setNCharacterStream", args={int.class, Reader.class}), @oracle.jdbc.proxy.annotation.Signature(name="setNCharacterStream", args={int.class, Reader.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="setUnicodeStream", args={int.class, InputStream.class}), @oracle.jdbc.proxy.annotation.Signature(name="setAsciiStreamAtName", args={String.class, InputStream.class}), @oracle.jdbc.proxy.annotation.Signature(name="setAsciiStreamAtName", args={String.class, InputStream.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="setAsciiStreamAtName", args={String.class, InputStream.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="setBinaryStreamAtName", args={String.class, InputStream.class}), @oracle.jdbc.proxy.annotation.Signature(name="setBinaryStreamAtName", args={String.class, InputStream.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="setBinaryStreamAtName", args={String.class, InputStream.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="setCharacterStreamAtName", args={String.class, Reader.class}), @oracle.jdbc.proxy.annotation.Signature(name="setCharacterStreamAtName", args={String.class, Reader.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="setCharacterStreamAtName", args={String.class, Reader.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="setNCharacterStreamAtName", args={String.class, Reader.class}), @oracle.jdbc.proxy.annotation.Signature(name="setNCharacterStreamAtName", args={String.class, Reader.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="setUnicodeStreamAtName", args={String.class, InputStream.class})})
/*      */   protected void preForSetStreams(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*      */   {
/*  318 */     FailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*      */ 
/*  320 */     if (localReplayLifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
/*  321 */       return;
/*      */     }
/*      */ 
/*  326 */     if (this.failoverMngr != null)
/*  327 */       this.failoverMngr.disableReplayInternal(paramMethod, 372, "Replay disabled because of nonreplayable call", null);
/*      */   }
/*      */ 
/*      */   @Pre
/*      */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="setObject", args={String.class, Object.class}), @oracle.jdbc.proxy.annotation.Signature(name="setObject", args={String.class, Object.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="setObject", args={String.class, Object.class, int.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="setObject", args={int.class, Object.class}), @oracle.jdbc.proxy.annotation.Signature(name="setObject", args={int.class, Object.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="setObject", args={int.class, Object.class, int.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="setObjectAtName", args={String.class, Object.class}), @oracle.jdbc.proxy.annotation.Signature(name="setObjectAtName", args={String.class, Object.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="setObjectAtName", args={String.class, Object.class, int.class, int.class})})
/*      */   protected void preForSetObjects(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*      */   {
/*  368 */     FailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*      */ 
/*  370 */     if (localReplayLifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
/*  371 */       return;
/*      */     }
/*      */ 
/*  375 */     if (((paramArrayOfObject[1] instanceof InputStream)) || ((paramArrayOfObject[1] instanceof Reader)))
/*      */     {
/*  378 */       if (this.failoverMngr != null)
/*  379 */         this.failoverMngr.disableReplayInternal(paramMethod, 372, "Replay disabled because of nonreplayable call", null);
/*      */     }
/*      */   }
/*      */ 
/*      */   @Post
/*      */   protected Object postForAll(Method paramMethod, Object paramObject)
/*      */   {
/*  395 */     return super.postForAll(paramMethod, paramObject);
/*      */   }
/*      */ 
/*      */   @Post
/*      */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="execute", args={}), @oracle.jdbc.proxy.annotation.Signature(name="execute", args={String.class}), @oracle.jdbc.proxy.annotation.Signature(name="execute", args={String.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="execute", args={String.class, int[].class}), @oracle.jdbc.proxy.annotation.Signature(name="execute", args={String.class, String[].class})})
/*      */   protected boolean postForExecute(Method paramMethod, boolean paramBoolean)
/*      */   {
/*  409 */     FailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*      */ 
/*  412 */     switch (1.$SwitchMap$oracle$jdbc$replay$driver$FailoverManagerImpl$ReplayLifecycle[localReplayLifecycle.ordinal()])
/*      */     {
/*      */     case 1:
/*      */     case 2:
/*  418 */       doPostWhenRecordingExecutes(paramMethod, Boolean.valueOf(paramBoolean), null);
/*  419 */       break;
/*      */     case 3:
/*      */     case 4:
/*      */     case 5:
/*      */     case 6:
/*      */     case 7:
/*  427 */       break;
/*      */     case 8:
/*  432 */       doPostWhenReplayingExecutes(paramMethod, Boolean.valueOf(paramBoolean), null);
/*      */     }
/*      */ 
/*  435 */     return paramBoolean;
/*      */   }
/*      */ 
/*      */   @Post
/*      */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="executeUpdate", args={}), @oracle.jdbc.proxy.annotation.Signature(name="executeUpdate", args={String.class}), @oracle.jdbc.proxy.annotation.Signature(name="executeUpdate", args={String.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="executeUpdate", args={String.class, int[].class}), @oracle.jdbc.proxy.annotation.Signature(name="executeUpdate", args={String.class, String[].class})})
/*      */   protected int postForExecuteUpdate(Method paramMethod, int paramInt)
/*      */   {
/*  449 */     FailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*      */ 
/*  452 */     switch (1.$SwitchMap$oracle$jdbc$replay$driver$FailoverManagerImpl$ReplayLifecycle[localReplayLifecycle.ordinal()])
/*      */     {
/*      */     case 1:
/*      */     case 2:
/*  458 */       doPostWhenRecordingExecutes(paramMethod, Integer.valueOf(paramInt), null);
/*  459 */       break;
/*      */     case 3:
/*      */     case 4:
/*      */     case 5:
/*      */     case 6:
/*      */     case 7:
/*  467 */       break;
/*      */     case 8:
/*  472 */       doPostWhenReplayingExecutes(paramMethod, Integer.valueOf(paramInt), null);
/*      */     }
/*      */ 
/*  475 */     return paramInt;
/*      */   }
/*      */ 
/*      */   @Post
/*      */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="executeQuery", args={}), @oracle.jdbc.proxy.annotation.Signature(name="executeQuery", args={String.class})})
/*      */   protected ResultSet postForExecuteQuery(Method paramMethod, ResultSet paramResultSet)
/*      */   {
/*  487 */     if ((paramResultSet instanceof NonTxnReplayableBase))
/*      */     {
/*  489 */       localObject = (NonTxnReplayableBase)paramResultSet;
/*  490 */       ((NonTxnReplayableBase)localObject).setFailoverManager(getFailoverManager());
/*      */     }
/*      */ 
/*  493 */     Object localObject = this.failoverMngr.getReplayLifecycle();
/*      */ 
/*  496 */     switch (1.$SwitchMap$oracle$jdbc$replay$driver$FailoverManagerImpl$ReplayLifecycle[localObject.ordinal()])
/*      */     {
/*      */     case 1:
/*      */     case 2:
/*  502 */       doPostWhenRecordingExecutes(paramMethod, paramResultSet, null);
/*  503 */       break;
/*      */     case 3:
/*      */     case 4:
/*      */     case 5:
/*      */     case 6:
/*      */     case 7:
/*  511 */       break;
/*      */     case 8:
/*  516 */       doPostWhenReplayingExecutes(paramMethod, paramResultSet, null);
/*      */     }
/*      */ 
/*  519 */     return paramResultSet;
/*      */   }
/*      */ 
/*      */   @Post
/*      */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="close", args={})})
/*      */   protected void postForClose(Method paramMethod)
/*      */   {
/*  527 */     FailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*      */ 
/*  530 */     switch (1.$SwitchMap$oracle$jdbc$replay$driver$FailoverManagerImpl$ReplayLifecycle[localReplayLifecycle.ordinal()])
/*      */     {
/*      */     case 1:
/*  534 */       doPostWhenRecordingClose(paramMethod, null);
/*  535 */       break;
/*      */     case 3:
/*      */     case 4:
/*      */     case 5:
/*      */     case 6:
/*      */     case 7:
/*  543 */       break;
/*      */     case 2:
/*      */     case 8:
/*      */     }
/*      */ 
/*  552 */     this.isClosedAndNoReplay = true;
/*      */   }
/*      */ 
/*      */   @OnError(SQLException.class)
/*      */   protected void onErrorVoidForAll(Method paramMethod, SQLException paramSQLException)
/*      */     throws SQLException
/*      */   {
/*  559 */     super.onErrorVoidForAll(paramMethod, paramSQLException);
/*      */   }
/*      */ 
/*      */   @OnError(SQLException.class)
/*      */   protected Object onErrorForAll(Method paramMethod, SQLException paramSQLException)
/*      */     throws SQLException
/*      */   {
/*  566 */     return super.onErrorForAll(paramMethod, paramSQLException);
/*      */   }
/*      */ 
/*      */   @OnError(SQLException.class)
/*      */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="close", args={})})
/*      */   protected void onErrorVoidForClose(Method paramMethod, SQLException paramSQLException)
/*      */     throws SQLException
/*      */   {
/*  575 */     if ((paramSQLException instanceof SQLRecoverableException)) {
/*  576 */       return;
/*      */     }
/*  578 */     super.onErrorVoidForAll(paramMethod, paramSQLException);
/*      */   }
/*      */ 
/*      */   @OnError(SQLException.class)
/*      */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="execute", args={}), @oracle.jdbc.proxy.annotation.Signature(name="execute", args={String.class}), @oracle.jdbc.proxy.annotation.Signature(name="execute", args={String.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="execute", args={String.class, int[].class}), @oracle.jdbc.proxy.annotation.Signature(name="execute", args={String.class, String[].class})})
/*      */   protected boolean onErrorForExecute(Method paramMethod, SQLException paramSQLException)
/*      */     throws SQLException
/*      */   {
/*  594 */     if (this.isClosedAndNoReplay) {
/*  595 */       throw paramSQLException;
/*      */     }
/*      */ 
/*  604 */     FailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*      */ 
/*  606 */     if (((paramSQLException instanceof SQLRecoverableException)) && (localReplayLifecycle == FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING))
/*      */     {
/*      */       try
/*      */       {
/*  612 */         oracle.jdbc.internal.OracleStatement localOracleStatement = (oracle.jdbc.internal.OracleStatement)getDelegate();
/*  613 */         OracleStatement.SqlKind localSqlKind = localOracleStatement.getSqlKind();
/*      */ 
/*  617 */         if (localSqlKind.isPlsqlOrCall())
/*      */         {
/*  621 */           this.failoverMngr.disableReplayInternal(paramMethod, 373, "Replay disabled because outage occurred during PL/SQL execution", null);
/*      */         }
/*  629 */         else if (localSqlKind.isDML())
/*      */         {
/*  631 */           if (this.failoverMngr != null) {
/*  632 */             this.failoverMngr.disableReplayInternal(paramMethod, 371, "Replay disabled because of active transaction", null);
/*      */           }
/*      */ 
/*      */         }
/*  645 */         else if ((localSqlKind.isOTHER()) && (localSqlKind != OracleStatement.SqlKind.ALTER_SESSION))
/*      */         {
/*  648 */           if (this.failoverMngr != null) {
/*  649 */             this.failoverMngr.disableReplayInternal(paramMethod, 372, "Replay disabled because of nonreplayable call", null);
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */       catch (SQLException localSQLException)
/*      */       {
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  665 */     return ((Boolean)super.onErrorForAll(paramMethod, paramSQLException)).booleanValue();
/*      */   }
/*      */ 
/*      */   @GetDelegate
/*      */   protected abstract Object getDelegate();
/*      */ 
/*      */   @SetDelegate
/*      */   protected abstract void setDelegate(Object paramObject);
/*      */ 
/*      */   @GetCreator
/*      */   protected abstract Object getCreator();
/*      */ 
/*      */   public void fillInChecksum(FailoverManagerImpl.CallHistoryEntry paramCallHistoryEntry)
/*      */     throws SQLException
/*      */   {
/*  687 */     oracle.jdbc.internal.OracleStatement localOracleStatement = (oracle.jdbc.internal.OracleStatement)getDelegate();
/*      */ 
/*  690 */     long l = localOracleStatement.getChecksum();
/*  691 */     String str = (paramCallHistoryEntry == null) || (paramCallHistoryEntry.method == null) ? "NULL METHOD" : paramCallHistoryEntry.method.getName();
/*      */ 
/*  699 */     this.failoverMngr.update(this, paramCallHistoryEntry, paramCallHistoryEntry.result, paramCallHistoryEntry.callStatus, l, paramCallHistoryEntry.scn, paramCallHistoryEntry.callException);
/*      */   }
/*      */ 
/*      */   public Object replayOneCall(FailoverManagerImpl.CallHistoryEntry paramCallHistoryEntry, SQLRecoverableException paramSQLRecoverableException)
/*      */     throws SQLException
/*      */   {
/*  712 */     if (paramCallHistoryEntry.scn != -1L)
/*      */     {
/*  714 */       oracle.jdbc.internal.OracleStatement localOracleStatement = (oracle.jdbc.internal.OracleStatement)getDelegate();
/*  715 */       localOracleStatement.setSnapshotSCN(paramCallHistoryEntry.scn);
/*      */ 
/*  717 */       String str = (paramCallHistoryEntry == null) || (paramCallHistoryEntry.method == null) ? "NULL METHOD" : paramCallHistoryEntry.method.getName();
/*      */     }
/*      */ 
/*  725 */     return super.replayOneCall(paramCallHistoryEntry, paramSQLRecoverableException);
/*      */   }
/*      */ 
/*      */   protected void doPostWhenReplaying(Method paramMethod, Object paramObject, SQLException paramSQLException)
/*      */   {
/*      */     try
/*      */     {
/*  736 */       FailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*      */ 
/*  738 */       switch (1.$SwitchMap$oracle$jdbc$replay$driver$FailoverManagerImpl$ReplayLifecycle[localReplayLifecycle.ordinal()])
/*      */       {
/*      */       case 8:
/*  748 */         if (this.replayingCallEntry.checksum != 0L)
/*      */         {
/*  750 */           oracle.jdbc.internal.OracleStatement localOracleStatement = (oracle.jdbc.internal.OracleStatement)getDelegate();
/*      */ 
/*  755 */           long l = localOracleStatement.getChecksum();
/*  756 */           String str = (this.replayingCallEntry == null) || (this.replayingCallEntry.method == null) ? "NULL METHOD" : this.replayingCallEntry.method.getName();
/*      */ 
/*  763 */           if (this.replayingCallEntry.checksum != l)
/*      */           {
/*  766 */             this.failoverMngr.disableReplayAndThrowException(this.replayingCallEntry.method, 388, "Replay failed because of checksum mismatch", this.originalError);
/*      */           }
/*      */         }
/*      */         break;
/*      */       case 2:
/*      */       }
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void doPostWhenReplayingExecutes(Method paramMethod, Object paramObject, SQLException paramSQLException)
/*      */   {
/*      */     try
/*      */     {
/*  793 */       FailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*      */ 
/*  795 */       switch (1.$SwitchMap$oracle$jdbc$replay$driver$FailoverManagerImpl$ReplayLifecycle[localReplayLifecycle.ordinal()])
/*      */       {
/*      */       case 8:
/*  799 */         doPostWhenReplaying(paramMethod, paramObject, paramSQLException);
/*  800 */         break;
/*      */       case 2:
/*  805 */         oracle.jdbc.internal.OracleStatement localOracleStatement = (oracle.jdbc.internal.OracleStatement)getDelegate();
/*  806 */         OracleStatement.SqlKind localSqlKind = localOracleStatement.getSqlKind();
/*      */ 
/*  811 */         if (localSqlKind.isPlsqlOrCall())
/*      */         {
/*  815 */           this.failoverMngr.disableReplayInternal(this.replayingCallEntry.method, 373, "Replay disabled because outage occurred during PL/SQL execution", this.originalError);
/*      */         }
/*      */         break;
/*      */       }
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/*      */     }
/*      */   }
/*      */ 
/*      */   boolean okToPurgeSameProxyList()
/*      */   {
/*  833 */     boolean bool = false;
/*      */     try
/*      */     {
/*  837 */       oracle.jdbc.internal.OracleStatement localOracleStatement = (oracle.jdbc.internal.OracleStatement)getDelegate();
/*  838 */       OracleStatement.SqlKind localSqlKind = localOracleStatement.getSqlKind();
/*      */ 
/*  841 */       if (localSqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
/*  842 */         bool = true;
/*      */       }
/*  845 */       else if ((localSqlKind.isSELECT()) && (localSqlKind != OracleStatement.SqlKind.SELECT_FOR_UPDATE))
/*      */       {
/*  850 */         for (FailoverManagerImpl.CallHistoryEntry localCallHistoryEntry = this.headSameProxy; 
/*  851 */           localCallHistoryEntry != null; 
/*  852 */           localCallHistoryEntry = localCallHistoryEntry.nextEntrySameProxy)
/*      */         {
/*  854 */           String str = localCallHistoryEntry.method == null ? "NULL METHOD" : localCallHistoryEntry.method.getName();
/*      */ 
/*  857 */           if ((("execute".equals(str)) || ("executeQuery".equals(str))) && (localCallHistoryEntry.scn > 0L))
/*      */           {
/*  861 */             bool = true;
/*  862 */             break;
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  879 */       return bool;
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/*  869 */       localSQLException = 
/*  879 */         localSQLException;
/*      */ 
/*  873 */       bool = false;
/*      */ 
/*  879 */       return bool; } finally {  } return bool;
/*      */   }
/*      */ 
/*      */   protected void doPostWhenRecordingClose(Method paramMethod, SQLException paramSQLException)
/*      */   {
/*  887 */     if (okToPurgeSameProxyList())
/*  888 */       purgeSameProxyList();
/*      */   }
/*      */ 
/*      */   protected void doPostWhenRecordingExecutes(Method paramMethod, Object paramObject, SQLException paramSQLException)
/*      */   {
/*      */     try
/*      */     {
/*  897 */       oracle.jdbc.internal.OracleStatement localOracleStatement = (oracle.jdbc.internal.OracleStatement)getDelegate();
/*  898 */       OracleConnection localOracleConnection = (OracleConnection)localOracleStatement.getConnection();
/*  899 */       OracleStatement.SqlKind localSqlKind = localOracleStatement.getSqlKind();
/*      */ 
/*  901 */       long l1 = 0L;
/*  902 */       long l2 = -1L;
/*  903 */       String str = paramMethod == null ? "NULL METHOD" : paramMethod.getName();
/*      */ 
/*  907 */       if ((localSqlKind.isSELECT()) || (localSqlKind.isPlsqlOrCall()) || (localSqlKind == OracleStatement.SqlKind.ALTER_SESSION))
/*      */       {
/*  911 */         EnumSet localEnumSet = localOracleConnection.getTransactionState();
/*      */ 
/*  924 */         if ((localEnumSet.contains(OracleConnection.TransactionState.TRANSACTION_INTENTION)) || ((localEnumSet.contains(OracleConnection.TransactionState.TRANSACTION_STARTED)) && (!localEnumSet.contains(OracleConnection.TransactionState.TRANSACTION_READONLY))))
/*      */         {
/*  931 */           this.failoverMngr.disableReplayInternal(paramMethod, 371, "Replay disabled because of transaction", null);
/*      */         }
/*      */         else
/*      */         {
/*  944 */           l1 = 0L;
/*      */ 
/*  947 */           if ((!this.failoverMngr.isReplayInCurrentMode()) && (localSqlKind.isPlsqlOrCall()))
/*      */           {
/*  949 */             this.failoverMngr.setReplayInCurrentMode();
/*      */           }
/*      */ 
/*  952 */           l2 = this.failoverMngr.isReplayInCurrentMode() ? -1L : localOracleConnection.getCurrentSCN();
/*      */         }
/*      */ 
/*  959 */         if (this.failoverMngr.getReplayLifecycle() == FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING)
/*      */         {
/*  964 */           this.failoverMngr.update(this, null, paramObject, "completed", l1, l2, paramSQLException);
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/*  973 */         this.failoverMngr.update(this, null, paramObject, "completed", l1, l2, paramSQLException);
/*      */ 
/*  984 */         this.failoverMngr.disableReplayInternal(paramMethod, 372, "Replay disabled because of nonreplayable call", null);
/*      */       }
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/*      */     }
/*      */   }
/*      */ 
/*      */   @ProxyResult(ProxyResultPolicy.MANUAL)
/*      */   public Connection getConnection()
/*      */   {
/* 1006 */     return (Connection)getCreator();
/*      */   }
/*      */ 
/*      */   @ProxyResult(ProxyResultPolicy.MANUAL)
/*      */   public <T> T unwrap(Class<T> paramClass)
/*      */     throws SQLException
/*      */   {
/* 1013 */     return getDelegate();
/*      */   }
/*      */ 
/*      */   @ProxyResult(ProxyResultPolicy.CREATE_CACHE)
/*      */   public abstract ResultSet executeQuery(String paramString)
/*      */     throws SQLException;
/*      */ 
/*      */   @ProxyResult(ProxyResultPolicy.CREATE_CACHE)
/*      */   public abstract ResultSet executeQuery()
/*      */     throws SQLException;
/*      */ 
/*      */   @ProxyResult(ProxyResultPolicy.CREATE)
/*      */   public abstract ResultSetMetaData getMetaData()
/*      */     throws SQLException;
/*      */ 
/*      */   @ProxyResult(ProxyResultPolicy.CREATE)
/*      */   public abstract ParameterMetaData getParameterMetaData()
/*      */     throws SQLException;
/*      */ 
/*      */   @ProxyResult(ProxyResultPolicy.CREATE)
/*      */   public abstract Array getArray(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   @ProxyResult(ProxyResultPolicy.CREATE)
/*      */   public abstract Array getArray(String paramString)
/*      */     throws SQLException;
/*      */ 
/*      */   @ProxyResult(ProxyResultPolicy.CREATE)
/*      */   public abstract Blob getBlob(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   @ProxyResult(ProxyResultPolicy.CREATE)
/*      */   public abstract Blob getBlob(String paramString)
/*      */     throws SQLException;
/*      */ 
/*      */   @ProxyResult(ProxyResultPolicy.CREATE)
/*      */   public abstract Clob getClob(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   @ProxyResult(ProxyResultPolicy.CREATE)
/*      */   public abstract Clob getClob(String paramString)
/*      */     throws SQLException;
/*      */ 
/*      */   @ProxyResult(ProxyResultPolicy.CREATE)
/*      */   public abstract NClob getNClob(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   @ProxyResult(ProxyResultPolicy.CREATE)
/*      */   public abstract NClob getNClob(String paramString)
/*      */     throws SQLException;
/*      */ 
/*      */   @ProxyResult(ProxyResultPolicy.CREATE)
/*      */   public abstract Ref getRef(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   @ProxyResult(ProxyResultPolicy.CREATE)
/*      */   public abstract Ref getRef(String paramString)
/*      */     throws SQLException;
/*      */ 
/*      */   @ProxyResult(ProxyResultPolicy.CREATE)
/*      */   public abstract RowId getRowId(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   @ProxyResult(ProxyResultPolicy.CREATE)
/*      */   public abstract RowId getRowId(String paramString)
/*      */     throws SQLException;
/*      */ 
/*      */   @ProxyResult(ProxyResultPolicy.CREATE)
/*      */   public abstract Struct getStruct(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   @ProxyResult(ProxyResultPolicy.CREATE)
/*      */   public abstract Struct getStruct(String paramString)
/*      */     throws SQLException;
/*      */ 
/*      */   @ProxyResult(ProxyResultPolicy.CREATE)
/*      */   public abstract SQLXML getSQLXML(int paramInt)
/*      */     throws SQLException;
/*      */ 
/*      */   @ProxyResult(ProxyResultPolicy.CREATE)
/*      */   public abstract SQLXML getSQLXML(String paramString)
/*      */     throws SQLException;
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.replay.driver.NonTxnReplayableStatement
 * JD-Core Version:    0.6.2
 */