/*     */ package oracle.jdbc.replay.driver;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.SQLRecoverableException;
/*     */ import java.sql.Statement;
/*     */ import oracle.jdbc.internal.OracleStatement;
/*     */ import oracle.jdbc.proxy.annotation.GetCreator;
/*     */ import oracle.jdbc.proxy.annotation.GetDelegate;
/*     */ import oracle.jdbc.proxy.annotation.Methods;
/*     */ import oracle.jdbc.proxy.annotation.OnError;
/*     */ import oracle.jdbc.proxy.annotation.Post;
/*     */ import oracle.jdbc.proxy.annotation.Pre;
/*     */ import oracle.jdbc.proxy.annotation.ProxyFor;
/*     */ import oracle.jdbc.proxy.annotation.ProxyResult;
/*     */ import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
/*     */ import oracle.jdbc.proxy.annotation.SetDelegate;
/*     */ 
/*     */ @ProxyFor({ResultSet.class, oracle.jdbc.OracleResultSet.class, oracle.jdbc.internal.OracleResultSet.class})
/*     */ @ProxyResult(ProxyResultPolicy.CREATE)
/*     */ public abstract class NonTxnReplayableResultSet extends NonTxnReplayableBase
/*     */   implements Replayable
/*     */ {
/* 440 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */ 
/*     */   @Pre
/*     */   protected void preForAll(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/*  63 */     super.preForAll(paramMethod, paramObject, paramArrayOfObject);
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="deleteRow", args={}), @oracle.jdbc.proxy.annotation.Signature(name="insertRow", args={}), @oracle.jdbc.proxy.annotation.Signature(name="updateRow", args={})})
/*     */   protected void preForRowUpdates(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/*  75 */     FailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*     */ 
/*  77 */     if (localReplayLifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
/*  78 */       return;
/*     */     }
/*     */ 
/*  82 */     if (this.failoverMngr != null)
/*  83 */       this.failoverMngr.disableReplayInternal(paramMethod, 371, "Replay disabled because of active transaction", null);
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="updateAsciiStream", args={String.class, java.io.InputStream.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateAsciiStream", args={String.class, java.io.InputStream.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateAsciiStream", args={String.class, java.io.InputStream.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateBinaryStream", args={String.class, java.io.InputStream.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateBinaryStream", args={String.class, java.io.InputStream.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateBinaryStream", args={String.class, java.io.InputStream.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateCharacterStream", args={String.class, java.io.Reader.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateCharacterStream", args={String.class, java.io.Reader.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateCharacterStream", args={String.class, java.io.Reader.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateNCharacterStream", args={String.class, java.io.Reader.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateNCharacterStream", args={String.class, java.io.Reader.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateAsciiStream", args={int.class, java.io.InputStream.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateAsciiStream", args={int.class, java.io.InputStream.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateAsciiStream", args={int.class, java.io.InputStream.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateBinaryStream", args={int.class, java.io.InputStream.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateBinaryStream", args={int.class, java.io.InputStream.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateBinaryStream", args={int.class, java.io.InputStream.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateCharacterStream", args={int.class, java.io.Reader.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateCharacterStream", args={int.class, java.io.Reader.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateCharacterStream", args={int.class, java.io.Reader.class, long.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateNCharacterStream", args={int.class, java.io.Reader.class}), @oracle.jdbc.proxy.annotation.Signature(name="updateNCharacterStream", args={int.class, java.io.Reader.class, long.class})})
/*     */   protected void preForUpdateStreams(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/* 148 */     FailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*     */ 
/* 150 */     if (localReplayLifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
/* 151 */       return;
/*     */     }
/*     */ 
/* 155 */     if (this.failoverMngr != null)
/* 156 */       this.failoverMngr.disableReplayInternal(paramMethod, 371, "Replay disabled because of active transaction", null);
/*     */   }
/*     */ 
/*     */   @Post
/*     */   protected void postForAll(Method paramMethod)
/*     */   {
/* 172 */     postForAll(paramMethod, null);
/*     */   }
/*     */ 
/*     */   @Post
/*     */   protected Object postForAll(Method paramMethod, Object paramObject)
/*     */   {
/* 178 */     return super.postForAll(paramMethod, paramObject);
/*     */   }
/*     */ 
/*     */   @Post
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="next", args={})})
/*     */   protected boolean postForNext(Method paramMethod, boolean paramBoolean)
/*     */   {
/* 186 */     FailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*     */ 
/* 189 */     switch (1.$SwitchMap$oracle$jdbc$replay$driver$FailoverManagerImpl$ReplayLifecycle[localReplayLifecycle.ordinal()])
/*     */     {
/*     */     case 1:
/*     */     case 2:
/* 195 */       doPostWhenRecordingNext(paramMethod, Boolean.valueOf(paramBoolean), null);
/* 196 */       break;
/*     */     case 3:
/*     */     case 4:
/*     */     case 5:
/*     */     case 6:
/*     */     case 7:
/* 204 */       break;
/*     */     case 8:
/* 208 */       doPostWhenReplaying(paramMethod, Boolean.valueOf(paramBoolean), null);
/*     */     }
/*     */ 
/* 211 */     return paramBoolean;
/*     */   }
/*     */ 
/*     */   @Post
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="close", args={})})
/*     */   protected void postForClose(Method paramMethod)
/*     */   {
/* 219 */     FailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*     */ 
/* 222 */     switch (1.$SwitchMap$oracle$jdbc$replay$driver$FailoverManagerImpl$ReplayLifecycle[localReplayLifecycle.ordinal()])
/*     */     {
/*     */     case 1:
/* 226 */       doPostWhenRecordingClose(paramMethod, null);
/* 227 */       break;
/*     */     case 3:
/*     */     case 4:
/*     */     case 5:
/*     */     case 6:
/*     */     case 7:
/* 235 */       break;
/*     */     case 2:
/*     */     case 8:
/*     */     }
/*     */   }
/*     */ 
/*     */   @OnError(SQLException.class)
/*     */   protected void onErrorVoidForAll(Method paramMethod, SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/* 247 */     onErrorForAll(paramMethod, paramSQLException);
/*     */   }
/*     */ 
/*     */   @OnError(SQLException.class)
/*     */   protected Object onErrorForAll(Method paramMethod, SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/* 254 */     return super.onErrorForAll(paramMethod, paramSQLException);
/*     */   }
/*     */ 
/*     */   @OnError(SQLException.class)
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="last", args={})})
/*     */   protected boolean onErrorForLast(Method paramMethod, SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/* 264 */     if (this.isClosedAndNoReplay) {
/* 265 */       throw paramSQLException;
/*     */     }
/* 267 */     FailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*     */ 
/* 269 */     if (((paramSQLException instanceof SQLRecoverableException)) && (localReplayLifecycle == FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING))
/*     */     {
/* 274 */       this.failoverMngr.disableReplayInternal(paramMethod, 372, "Replay disabled because of nonreplayable call", null);
/*     */     }
/*     */ 
/* 281 */     return ((Boolean)super.onErrorForAll(paramMethod, paramSQLException)).booleanValue();
/*     */   }
/*     */ 
/*     */   @GetDelegate
/*     */   protected abstract Object getDelegate();
/*     */ 
/*     */   @SetDelegate
/*     */   protected abstract void setDelegate(Object paramObject);
/*     */ 
/*     */   @GetCreator
/*     */   protected abstract Object getCreator();
/*     */ 
/*     */   public void fillInChecksum(FailoverManagerImpl.CallHistoryEntry paramCallHistoryEntry)
/*     */     throws SQLException
/*     */   {
/* 303 */     OracleStatement localOracleStatement = (OracleStatement)((NonTxnReplayableBase)getCreator()).getDelegate();
/*     */ 
/* 307 */     long l = localOracleStatement.getChecksum();
/*     */ 
/* 312 */     this.failoverMngr.update(this, paramCallHistoryEntry, paramCallHistoryEntry.result, paramCallHistoryEntry.callStatus, l, paramCallHistoryEntry.scn, paramCallHistoryEntry.callException);
/*     */   }
/*     */ 
/*     */   public Object replayOneCall(FailoverManagerImpl.CallHistoryEntry paramCallHistoryEntry, SQLRecoverableException paramSQLRecoverableException)
/*     */     throws SQLException
/*     */   {
/* 321 */     Object localObject = super.replayOneCall(paramCallHistoryEntry, paramSQLRecoverableException);
/*     */ 
/* 324 */     return localObject;
/*     */   }
/*     */ 
/*     */   protected void doPostWhenRecordingNext(Method paramMethod, Object paramObject, SQLException paramSQLException)
/*     */   {
/* 332 */     long l = 0L;
/*     */ 
/* 334 */     OracleStatement localOracleStatement = (OracleStatement)((NonTxnReplayableBase)getCreator()).getDelegate();
/*     */     try
/*     */     {
/* 340 */       l = localOracleStatement.getChecksum();
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 344 */       l = 0L;
/*     */     }
/*     */ 
/* 349 */     this.failoverMngr.update(this, null, paramObject, "completed", l, -1L, paramSQLException);
/*     */   }
/*     */ 
/*     */   protected void doPostWhenRecordingClose(Method paramMethod, SQLException paramSQLException)
/*     */   {
/* 356 */     NonTxnReplayableStatement localNonTxnReplayableStatement = (NonTxnReplayableStatement)getCreator();
/*     */ 
/* 360 */     if (localNonTxnReplayableStatement.okToPurgeSameProxyList()) {
/* 361 */       purgeSameProxyList();
/*     */     }
/*     */ 
/* 364 */     this.isClosedAndNoReplay = true;
/*     */   }
/*     */ 
/*     */   protected void doPostWhenReplaying(Method paramMethod, Object paramObject, SQLException paramSQLException)
/*     */   {
/*     */     try
/*     */     {
/* 375 */       FailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*     */ 
/* 377 */       switch (1.$SwitchMap$oracle$jdbc$replay$driver$FailoverManagerImpl$ReplayLifecycle[localReplayLifecycle.ordinal()])
/*     */       {
/*     */       case 8:
/* 387 */         if (this.replayingCallEntry.checksum != 0L)
/*     */         {
/* 389 */           OracleStatement localOracleStatement = (OracleStatement)((NonTxnReplayableBase)getCreator()).getDelegate();
/*     */ 
/* 395 */           long l = localOracleStatement.getChecksum();
/*     */ 
/* 399 */           if (this.replayingCallEntry.checksum != l)
/*     */           {
/* 401 */             this.failoverMngr.disableReplayAndThrowException(this.replayingCallEntry.method, 388, "Replay failed because of checksum mismatch", this.originalError);
/*     */           }
/*     */         }
/*     */         break;
/*     */       case 2:
/*     */       }
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.MANUAL)
/*     */   public Statement getStatement()
/*     */   {
/* 429 */     return (Statement)getCreator();
/*     */   }
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.MANUAL)
/*     */   public <T> T unwrap(Class<T> paramClass)
/*     */     throws SQLException
/*     */   {
/* 436 */     return getDelegate();
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.replay.driver.NonTxnReplayableResultSet
 * JD-Core Version:    0.6.2
 */