/*     */ package oracle.jdbc.replay.driver;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.sql.Array;
/*     */ import java.sql.Blob;
/*     */ import java.sql.CallableStatement;
/*     */ import java.sql.Clob;
/*     */ import java.sql.Connection;
/*     */ import java.sql.NClob;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.SQLXML;
/*     */ import java.sql.Savepoint;
/*     */ import java.sql.Statement;
/*     */ import java.sql.Struct;
/*     */ import java.util.EnumSet;
/*     */ import oracle.jdbc.OracleSavepoint;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection.TransactionState;
/*     */ import oracle.jdbc.proxy.annotation.GetCreator;
/*     */ import oracle.jdbc.proxy.annotation.GetDelegate;
/*     */ import oracle.jdbc.proxy.annotation.Methods;
/*     */ import oracle.jdbc.proxy.annotation.OnError;
/*     */ import oracle.jdbc.proxy.annotation.Post;
/*     */ import oracle.jdbc.proxy.annotation.Pre;
/*     */ import oracle.jdbc.proxy.annotation.ProxyFor;
/*     */ import oracle.jdbc.proxy.annotation.ProxyLocale;
/*     */ import oracle.jdbc.proxy.annotation.ProxyResult;
/*     */ import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
/*     */ import oracle.jdbc.proxy.annotation.SetDelegate;
/*     */ import oracle.jdbc.replay.internal.OracleDataSource;
/*     */ import oracle.jdbc.replay.internal.ReplayableConnection;
/*     */ import oracle.sql.ARRAY;
/*     */ 
/*     */ @ProxyFor({Connection.class, oracle.jdbc.OracleConnection.class, oracle.jdbc.internal.OracleConnection.class})
/*     */ @ProxyLocale
/*     */ public abstract class NonTxnReplayableConnection extends NonTxnReplayableBase
/*     */   implements Replayable, ReplayableConnection
/*     */ {
/*  71 */   String originalUser = "";
/*  72 */   String originalPasswd = "";
/*     */ 
/* 620 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */ 
/*     */   @Pre
/*     */   protected void preForAll(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/*  81 */     super.preForAll(paramMethod, paramObject, paramArrayOfObject);
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="commit", args={}), @oracle.jdbc.proxy.annotation.Signature(name="commit", args={EnumSet.class}), @oracle.jdbc.proxy.annotation.Signature(name="rollback", args={}), @oracle.jdbc.proxy.annotation.Signature(name="rollback", args={Savepoint.class}), @oracle.jdbc.proxy.annotation.Signature(name="setSavepoint", args={}), @oracle.jdbc.proxy.annotation.Signature(name="setSavepoint", args={String.class}), @oracle.jdbc.proxy.annotation.Signature(name="releaseSavepoint", args={Savepoint.class}), @oracle.jdbc.proxy.annotation.Signature(name="oracleRollback", args={OracleSavepoint.class}), @oracle.jdbc.proxy.annotation.Signature(name="oracleSetSavepoint", args={}), @oracle.jdbc.proxy.annotation.Signature(name="oracleSetSavepoint", args={String.class}), @oracle.jdbc.proxy.annotation.Signature(name="oracleReleaseSavepoint", args={OracleSavepoint.class})})
/*     */   protected void preForTxnControl(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/* 102 */     FailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*     */ 
/* 104 */     if (localReplayLifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
/* 105 */       return;
/*     */     }
/* 107 */     String str = paramMethod == null ? "NULL METHOD" : paramMethod.getName();
/*     */ 
/* 118 */     if (this.failoverMngr != null)
/*     */     {
/* 120 */       int i = 0;
/*     */       try
/*     */       {
/* 124 */         oracle.jdbc.internal.OracleConnection localOracleConnection = (oracle.jdbc.internal.OracleConnection)getDelegate();
/*     */ 
/* 126 */         EnumSet localEnumSet = localOracleConnection.getTransactionState();
/*     */ 
/* 134 */         if ((localEnumSet.contains(OracleConnection.TransactionState.TRANSACTION_STARTED)) && (!localEnumSet.contains(OracleConnection.TransactionState.TRANSACTION_READONLY)))
/*     */         {
/* 138 */           i = 1;
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (SQLException localSQLException)
/*     */       {
/* 144 */         i = 1;
/*     */       }
/*     */       finally
/*     */       {
/* 148 */         if (i != 0)
/*     */         {
/* 150 */           this.failoverMngr.disableReplayInternal(paramMethod, 371, "Replay disabled because of active transaction", null);
/*     */         }
/*     */         else
/*     */         {
/* 157 */           super.preForAll(paramMethod, paramObject, paramArrayOfObject);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="abort", args={}), @oracle.jdbc.proxy.annotation.Signature(name="close", args={}), @oracle.jdbc.proxy.annotation.Signature(name="close", args={int.class}), @oracle.jdbc.proxy.annotation.Signature(name="close", args={java.util.Properties.class})})
/*     */   protected void preForClosure(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/* 181 */     this.isClosedAndNoReplay = true;
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="cancel", args={})})
/*     */   protected void preForCancel(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/*     */   }
/*     */ 
/*     */   @Post
/*     */   protected void postForAll(Method paramMethod)
/*     */   {
/* 197 */     postForAll(paramMethod, null);
/*     */   }
/*     */ 
/*     */   @Post
/*     */   protected Object postForAll(Method paramMethod, Object paramObject)
/*     */   {
/* 203 */     return super.postForAll(paramMethod, paramObject);
/*     */   }
/*     */ 
/*     */   @Post
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="abort", args={}), @oracle.jdbc.proxy.annotation.Signature(name="close", args={}), @oracle.jdbc.proxy.annotation.Signature(name="close", args={int.class}), @oracle.jdbc.proxy.annotation.Signature(name="close", args={java.util.Properties.class})})
/*     */   protected void postForClosure(Method paramMethod)
/*     */   {
/*     */   }
/*     */ 
/*     */   @Post
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="cancel", args={})})
/*     */   protected void postForCancel(Method paramMethod)
/*     */   {
/*     */   }
/*     */ 
/*     */   @OnError(SQLException.class)
/*     */   protected void onErrorVoidForAll(Method paramMethod, SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/* 233 */     super.onErrorVoidForAll(paramMethod, paramSQLException);
/*     */   }
/*     */ 
/*     */   @OnError(SQLException.class)
/*     */   protected Object onErrorForAll(Method paramMethod, SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/* 240 */     return super.onErrorForAll(paramMethod, paramSQLException);
/*     */   }
/*     */ 
/*     */   @GetDelegate
/*     */   protected abstract Object getDelegate();
/*     */ 
/*     */   @SetDelegate
/*     */   protected abstract void setDelegate(Object paramObject);
/*     */ 
/*     */   @GetCreator
/*     */   protected abstract Object getCreator();
/*     */ 
/*     */   public void setReplayInitiationTimeout(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 267 */     this.failoverMngr.setReplayInitiationTimeout(paramInt);
/*     */   }
/*     */ 
/*     */   public void initialize(OracleDataSource paramOracleDataSource, String paramString1, String paramString2)
/*     */     throws SQLException
/*     */   {
/* 275 */     FailoverManagerImpl localFailoverManagerImpl = (FailoverManagerImpl)FailoverManagerImpl.getFailoverManager(this, paramOracleDataSource);
/*     */ 
/* 278 */     setFailoverManager(localFailoverManagerImpl);
/*     */ 
/* 281 */     this.originalUser = paramString1;
/* 282 */     this.originalPasswd = paramString2;
/*     */   }
/*     */ 
/*     */   public void beginRequest()
/*     */     throws SQLException
/*     */   {
/* 294 */     this.failoverMngr.beginRequest();
/*     */   }
/*     */ 
/*     */   public void endRequest()
/*     */     throws SQLException
/*     */   {
/* 304 */     this.failoverMngr.endRequest();
/*     */   }
/*     */ 
/*     */   public void disableReplay()
/*     */     throws SQLException
/*     */   {
/* 314 */     this.failoverMngr.disableReplay();
/*     */   }
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.CREATE_CACHE)
/*     */   public ARRAY createARRAY(String paramString, Object paramObject)
/*     */     throws SQLException
/*     */   {
/*     */     Object localObject1;
/* 331 */     if ((paramObject != null) && ((paramObject instanceof Object[])))
/*     */     {
/* 333 */       localObject2 = (Object[])paramObject;
/* 334 */       if (localObject2.length > 0)
/*     */       {
/* 336 */         Object[] arrayOfObject = new Object[localObject2.length];
/* 337 */         int i = 0;
/* 338 */         for (Object localObject4 : localObject2)
/*     */         {
/* 340 */           if ((localObject4 instanceof NonTxnReplayableBase))
/*     */           {
/* 342 */             arrayOfObject[(i++)] = ((NonTxnReplayableBase)localObject4).getDelegate();
/*     */           }
/*     */           else
/* 345 */             arrayOfObject[(i++)] = localObject4;
/*     */         }
/* 347 */         localObject1 = arrayOfObject;
/*     */       }
/*     */       else {
/* 350 */         localObject1 = paramObject;
/*     */       }
/*     */     } else {
/* 353 */       localObject1 = paramObject;
/*     */     }
/* 355 */     Object localObject2 = null;
/*     */     try
/*     */     {
/* 359 */       localObject2 = oracle.jdbc.internal.OracleConnection.class.getMethod("createARRAY", new Class[] { String.class, Object.class });
/*     */     }
/*     */     catch (Exception localException)
/*     */     {
/* 365 */       throw DatabaseError.createSqlException(1, "Cannot create ARRAY instance");
/*     */     }
/*     */ 
/* 369 */     preForAll((Method)localObject2, this, new Object[] { paramString, localObject1 });
/*     */     try
/*     */     {
/* 373 */       oracle.jdbc.internal.OracleConnection localOracleConnection = (oracle.jdbc.internal.OracleConnection)getDelegate();
/*     */ 
/* 375 */       ARRAY localARRAY = localOracleConnection.createARRAY(paramString, localObject1);
/*     */ 
/* 377 */       return (ARRAY)postForAll((Method)localObject2, localARRAY);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 381 */       return (ARRAY)postForAll((Method)localObject2, onErrorForAll((Method)localObject2, localSQLException));
/*     */     }
/*     */   }
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.CREATE_CACHE)
/*     */   public Array createOracleArray(String paramString, Object paramObject)
/*     */     throws SQLException
/*     */   {
/* 389 */     return createARRAY(paramString, paramObject);
/*     */   }
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.CREATE_CACHE)
/*     */   public Array createArrayOf(String paramString, Object[] paramArrayOfObject)
/*     */     throws SQLException
/*     */   {
/*     */     Object[] arrayOfObject1;
/* 399 */     if ((paramArrayOfObject != null) && (paramArrayOfObject.length > 0))
/*     */     {
/* 401 */       arrayOfObject1 = new Object[paramArrayOfObject.length];
/* 402 */       int i = 0;
/* 403 */       for (Object localObject : paramArrayOfObject)
/*     */       {
/* 405 */         if ((localObject instanceof NonTxnReplayableBase))
/*     */         {
/* 407 */           arrayOfObject1[(i++)] = ((NonTxnReplayableBase)localObject).getDelegate();
/*     */         }
/*     */         else
/* 410 */           arrayOfObject1[(i++)] = localObject;
/*     */       }
/*     */     }
/*     */     else {
/* 414 */       arrayOfObject1 = paramArrayOfObject;
/*     */     }
/* 416 */     Method localMethod = null;
/*     */     try
/*     */     {
/* 420 */       localMethod = Connection.class.getDeclaredMethod("createArrayOf", new Class[] { String.class, [Ljava.lang.Object.class });
/*     */     }
/*     */     catch (Exception localException)
/*     */     {
/* 426 */       throw DatabaseError.createSqlException(1, "Cannot create Array instance");
/*     */     }
/*     */ 
/* 430 */     preForAll(localMethod, this, new Object[] { paramString, arrayOfObject1 });
/*     */     try
/*     */     {
/* 434 */       Connection localConnection = (Connection)getDelegate();
/*     */ 
/* 436 */       Array localArray = localConnection.createArrayOf(paramString, arrayOfObject1);
/*     */ 
/* 438 */       return (Array)postForAll(localMethod, localArray);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 442 */       return (Array)postForAll(localMethod, onErrorForAll(localMethod, localSQLException));
/*     */     }
/*     */   }
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.CREATE_CACHE)
/*     */   public Struct createStruct(String paramString, Object[] paramArrayOfObject)
/*     */     throws SQLException
/*     */   {
/*     */     Object[] arrayOfObject1;
/* 453 */     if ((paramArrayOfObject != null) && (paramArrayOfObject.length > 0))
/*     */     {
/* 455 */       arrayOfObject1 = new Object[paramArrayOfObject.length];
/* 456 */       int i = 0;
/* 457 */       for (Object localObject : paramArrayOfObject)
/*     */       {
/* 459 */         if ((localObject instanceof NonTxnReplayableBase))
/*     */         {
/* 461 */           arrayOfObject1[(i++)] = ((NonTxnReplayableBase)localObject).getDelegate();
/*     */         }
/*     */         else
/* 464 */           arrayOfObject1[(i++)] = localObject;
/*     */       }
/*     */     }
/*     */     else {
/* 468 */       arrayOfObject1 = paramArrayOfObject;
/*     */     }
/* 470 */     Method localMethod = null;
/*     */     try
/*     */     {
/* 474 */       localMethod = Connection.class.getDeclaredMethod("createStruct", new Class[] { String.class, [Ljava.lang.Object.class });
/*     */     }
/*     */     catch (Exception localException)
/*     */     {
/* 480 */       throw DatabaseError.createSqlException(1, "Cannot create Struct instance");
/*     */     }
/*     */ 
/* 484 */     preForAll(localMethod, this, new Object[] { paramString, arrayOfObject1 });
/*     */     try
/*     */     {
/* 488 */       Connection localConnection = (Connection)getDelegate();
/*     */ 
/* 490 */       Struct localStruct = localConnection.createStruct(paramString, arrayOfObject1);
/*     */ 
/* 492 */       return (Struct)postForAll(localMethod, localStruct);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 496 */       return (Struct)postForAll(localMethod, onErrorForAll(localMethod, localSQLException));
/*     */     }
/*     */   }
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.CREATE_CACHE)
/*     */   public abstract Blob createBlob()
/*     */     throws SQLException;
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.CREATE_CACHE)
/*     */   public abstract Clob createClob()
/*     */     throws SQLException;
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.CREATE_CACHE)
/*     */   public abstract NClob createNClob()
/*     */     throws SQLException;
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.CREATE_CACHE)
/*     */   public abstract SQLXML createSQLXML()
/*     */     throws SQLException;
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.CREATE_CACHE)
/*     */   public abstract Statement createStatement()
/*     */     throws SQLException;
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.CREATE_CACHE)
/*     */   public abstract Statement createStatement(int paramInt1, int paramInt2)
/*     */     throws SQLException;
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.CREATE_CACHE)
/*     */   public abstract Statement createStatement(int paramInt1, int paramInt2, int paramInt3)
/*     */     throws SQLException;
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.CREATE_CACHE)
/*     */   public abstract CallableStatement prepareCall(String paramString)
/*     */     throws SQLException;
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.CREATE_CACHE)
/*     */   public abstract CallableStatement prepareCall(String paramString, int paramInt1, int paramInt2)
/*     */     throws SQLException;
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.CREATE_CACHE)
/*     */   public abstract CallableStatement prepareCall(String paramString, int paramInt1, int paramInt2, int paramInt3)
/*     */     throws SQLException;
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.CREATE_CACHE)
/*     */   public abstract PreparedStatement prepareStatement(String paramString)
/*     */     throws SQLException;
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.CREATE_CACHE)
/*     */   public abstract PreparedStatement prepareStatement(String paramString, int paramInt)
/*     */     throws SQLException;
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.CREATE_CACHE)
/*     */   public abstract PreparedStatement prepareStatement(String paramString, int[] paramArrayOfInt)
/*     */     throws SQLException;
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.CREATE_CACHE)
/*     */   public abstract PreparedStatement prepareStatement(String paramString, int paramInt1, int paramInt2)
/*     */     throws SQLException;
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.CREATE_CACHE)
/*     */   public abstract PreparedStatement prepareStatement(String paramString, int paramInt1, int paramInt2, int paramInt3)
/*     */     throws SQLException;
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.CREATE_CACHE)
/*     */   public abstract PreparedStatement prepareStatement(String paramString, String[] paramArrayOfString)
/*     */     throws SQLException;
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.CREATE)
/*     */   public abstract Savepoint setSavepoint()
/*     */     throws SQLException;
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.CREATE)
/*     */   public abstract Savepoint setSavepoint(String paramString)
/*     */     throws SQLException;
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.MANUAL)
/*     */   public <T> T unwrap(Class<T> paramClass)
/*     */     throws SQLException
/*     */   {
/* 593 */     return getDelegate();
/*     */   }
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.MANUAL)
/*     */   public abstract Connection _getPC();
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.CREATE)
/*     */   public abstract OracleSavepoint oracleSetSavepoint()
/*     */     throws SQLException;
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.CREATE)
/*     */   public abstract OracleSavepoint oracleSetSavepoint(String paramString)
/*     */     throws SQLException;
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.MANUAL)
/*     */   public oracle.jdbc.OracleConnection unwrap()
/*     */   {
/* 616 */     return ((oracle.jdbc.internal.OracleConnection)getDelegate()).unwrap();
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.replay.driver.NonTxnReplayableConnection
 * JD-Core Version:    0.6.2
 */