/*     */ package oracle.jdbc.replay.driver;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.io.Reader;
/*     */ import java.io.Writer;
/*     */ import java.lang.reflect.Method;
/*     */ import java.sql.Clob;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.jdbc.proxy.annotation.GetCreator;
/*     */ import oracle.jdbc.proxy.annotation.GetDelegate;
/*     */ import oracle.jdbc.proxy.annotation.Methods;
/*     */ import oracle.jdbc.proxy.annotation.OnError;
/*     */ import oracle.jdbc.proxy.annotation.Post;
/*     */ import oracle.jdbc.proxy.annotation.Pre;
/*     */ import oracle.jdbc.proxy.annotation.ProxyFor;
/*     */ import oracle.jdbc.proxy.annotation.ProxyResult;
/*     */ import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
/*     */ import oracle.jdbc.proxy.annotation.SetDelegate;
/*     */ import oracle.sql.ClobDBAccess;
/*     */ 
/*     */ @ProxyFor({Clob.class, oracle.jdbc.OracleClob.class, oracle.jdbc.internal.OracleClob.class})
/*     */ public abstract class NonTxnReplayableClob extends NonTxnReplayableBase
/*     */   implements Replayable
/*     */ {
/*  48 */   private static final Method GETASCIISTREAM_METHOD = getGetAsciiStreamMethod();
/*  49 */   private static final Method GETASCIISTREAM_LONG_METHOD = getGetAsciiStreamLongMethod();
/*  50 */   private static final Method GETCHARSTREAM_METHOD = getGetCharacterStreamMethod();
/*  51 */   private static final Method GETCHARSTREAM_LONG_METHOD = getGetCharacterStreamLongMethod();
/*  52 */   private static final Method GETCHARSTREAM_LONG_LONG_METHOD = getGetCharacterStreamLongLongMethod();
/*  53 */   private static final Method SETASCIISTREAM_LONG_METHOD = getSetAsciiStreamLongMethod();
/*  54 */   private static final Method SETCHARSTREAM_LONG_METHOD = getSetCharacterStreamLongMethod();
/*     */ 
/*  56 */   protected boolean isFreed = false;
/*     */ 
/* 583 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */ 
/*     */   private static final Method getGetAsciiStreamMethod()
/*     */   {
/*     */     try
/*     */     {
/*  63 */       return oracle.jdbc.internal.OracleClob.class.getMethod("getAsciiStream", new Class[0]);
/*     */     }
/*     */     catch (Exception localException) {
/*     */     }
/*  67 */     return null;
/*     */   }
/*     */ 
/*     */   private static final Method getGetAsciiStreamLongMethod()
/*     */   {
/*     */     try
/*     */     {
/*  75 */       return oracle.jdbc.internal.OracleClob.class.getMethod("getAsciiStream", new Class[] { Long.TYPE });
/*     */     }
/*     */     catch (Exception localException) {
/*     */     }
/*  79 */     return null;
/*     */   }
/*     */ 
/*     */   private static final Method getGetCharacterStreamMethod()
/*     */   {
/*     */     try
/*     */     {
/*  87 */       return oracle.jdbc.internal.OracleClob.class.getMethod("getCharacterStream", new Class[0]);
/*     */     }
/*     */     catch (Exception localException) {
/*     */     }
/*  91 */     return null;
/*     */   }
/*     */ 
/*     */   private static final Method getGetCharacterStreamLongMethod()
/*     */   {
/*     */     try
/*     */     {
/*  99 */       return oracle.jdbc.internal.OracleClob.class.getMethod("getCharacterStream", new Class[] { Long.TYPE });
/*     */     }
/*     */     catch (Exception localException) {
/*     */     }
/* 103 */     return null;
/*     */   }
/*     */ 
/*     */   private static final Method getGetCharacterStreamLongLongMethod()
/*     */   {
/*     */     try
/*     */     {
/* 111 */       return oracle.jdbc.internal.OracleClob.class.getMethod("getCharacterStream", new Class[] { Long.TYPE, Long.TYPE });
/*     */     }
/*     */     catch (Exception localException) {
/*     */     }
/* 115 */     return null;
/*     */   }
/*     */ 
/*     */   private static final Method getSetAsciiStreamLongMethod()
/*     */   {
/*     */     try
/*     */     {
/* 123 */       return oracle.jdbc.internal.OracleClob.class.getMethod("setAsciiStream", new Class[] { Long.TYPE });
/*     */     }
/*     */     catch (Exception localException) {
/*     */     }
/* 127 */     return null;
/*     */   }
/*     */ 
/*     */   private static final Method getSetCharacterStreamLongMethod()
/*     */   {
/*     */     try
/*     */     {
/* 135 */       return oracle.jdbc.internal.OracleClob.class.getMethod("setCharacterStream", new Class[] { Long.TYPE });
/*     */     }
/*     */     catch (Exception localException) {
/*     */     }
/* 139 */     return null;
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   protected void preForAll(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/* 149 */     super.preForAll(paramMethod, paramObject, paramArrayOfObject);
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="free", args={})})
/*     */   protected void preForFree(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/* 159 */     this.isFreed = true;
/* 160 */     super.preForAll(paramMethod, paramObject, paramArrayOfObject);
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="setString", args={long.class, String.class}), @oracle.jdbc.proxy.annotation.Signature(name="setString", args={long.class, String.class, int.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="truncate", args={long.class})})
/*     */   protected void preForClobWrites(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/* 173 */     FailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*     */ 
/* 175 */     if (localReplayLifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
/* 176 */       return;
/*     */     }
/*     */ 
/* 180 */     if (this.failoverMngr != null)
/* 181 */       this.failoverMngr.disableReplayInternal(paramMethod, 371, "Replay disabled because of active transaction", null);
/*     */   }
/*     */ 
/*     */   @Post
/*     */   protected Object postForAll(Method paramMethod, Object paramObject)
/*     */   {
/* 198 */     if ((paramObject instanceof NonTxnReplayableBase))
/*     */     {
/* 200 */       NonTxnReplayableBase localNonTxnReplayableBase = (NonTxnReplayableBase)paramObject;
/* 201 */       localNonTxnReplayableBase.setFailoverManager(getFailoverManager());
/*     */     }
/*     */ 
/* 204 */     return super.postForAll(paramMethod, paramObject);
/*     */   }
/*     */ 
/*     */   @OnError(SQLException.class)
/*     */   protected void onErrorVoidForAll(Method paramMethod, SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/* 211 */     super.onErrorVoidForAll(paramMethod, paramSQLException);
/*     */   }
/*     */ 
/*     */   @OnError(SQLException.class)
/*     */   protected Object onErrorForAll(Method paramMethod, SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/* 218 */     return super.onErrorForAll(paramMethod, paramSQLException);
/*     */   }
/*     */ 
/*     */   @GetDelegate
/*     */   protected abstract Object getDelegate();
/*     */ 
/*     */   @SetDelegate
/*     */   protected abstract void setDelegate(Object paramObject);
/*     */ 
/*     */   @GetCreator
/*     */   protected abstract Object getCreator();
/*     */ 
/*     */   public InputStream getAsciiStream()
/*     */     throws SQLException
/*     */   {
/* 240 */     if (GETASCIISTREAM_METHOD == null)
/*     */     {
/* 242 */       throw DatabaseError.createSqlException(1, "Cannot get ascii stream");
/*     */     }
/*     */ 
/* 246 */     Method localMethod = GETASCIISTREAM_METHOD;
/*     */ 
/* 248 */     preForAll(localMethod, this, new Object[0]);
/*     */     try
/*     */     {
/* 252 */       oracle.jdbc.internal.OracleClob localOracleClob = (oracle.jdbc.internal.OracleClob)getDelegate();
/*     */       Object localObject;
/* 255 */       if (this.isFreed)
/*     */       {
/* 257 */         localObject = DatabaseError.createSqlException(localOracleClob.getInternalConnection(), 192);
/*     */ 
/* 260 */         ((SQLException)localObject).fillInStackTrace();
/* 261 */         throw ((Throwable)localObject);
/*     */       }
/*     */ 
/* 266 */       if (localOracleClob.canReadBasicLobDataInLocator())
/*     */       {
/* 268 */         localObject = localOracleClob.getAsciiStream();
/*     */       }
/*     */       else
/*     */       {
/* 272 */         localObject = localOracleClob.getDBAccess().newInputStream((oracle.jdbc.internal.OracleClob)this, localOracleClob.getBufferSize(), 0L);
/*     */       }
/*     */ 
/* 275 */       return (InputStream)postForAll(localMethod, localObject);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 279 */       return (InputStream)postForAll(localMethod, onErrorForAll(localMethod, localSQLException));
/*     */     }
/*     */   }
/*     */ 
/*     */   public InputStream getAsciiStream(long paramLong) throws SQLException
/*     */   {
/* 285 */     if (GETASCIISTREAM_LONG_METHOD == null)
/*     */     {
/* 287 */       throw DatabaseError.createSqlException(1, "Cannot get ascii stream");
/*     */     }
/*     */ 
/* 291 */     Method localMethod = GETASCIISTREAM_LONG_METHOD;
/*     */ 
/* 293 */     preForAll(localMethod, this, new Object[0]);
/*     */     try
/*     */     {
/* 297 */       oracle.jdbc.internal.OracleClob localOracleClob = (oracle.jdbc.internal.OracleClob)getDelegate();
/*     */       Object localObject;
/* 300 */       if (this.isFreed)
/*     */       {
/* 302 */         localObject = DatabaseError.createSqlException(localOracleClob.getInternalConnection(), 192);
/*     */ 
/* 305 */         ((SQLException)localObject).fillInStackTrace();
/* 306 */         throw ((Throwable)localObject);
/*     */       }
/*     */ 
/* 311 */       if (localOracleClob.canReadBasicLobDataInLocator())
/*     */       {
/* 313 */         localObject = localOracleClob.getAsciiStream(paramLong);
/*     */       }
/*     */       else
/*     */       {
/* 317 */         localObject = localOracleClob.getDBAccess().newInputStream((oracle.jdbc.internal.OracleClob)this, localOracleClob.getBufferSize(), paramLong);
/*     */       }
/*     */ 
/* 320 */       return (InputStream)postForAll(localMethod, localObject);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 324 */       return (InputStream)postForAll(localMethod, onErrorForAll(localMethod, localSQLException));
/*     */     }
/*     */   }
/*     */ 
/*     */   public Reader getCharacterStream() throws SQLException
/*     */   {
/* 330 */     if (GETCHARSTREAM_METHOD == null)
/*     */     {
/* 332 */       throw DatabaseError.createSqlException(1, "Cannot get character stream");
/*     */     }
/*     */ 
/* 336 */     Method localMethod = GETCHARSTREAM_METHOD;
/*     */ 
/* 338 */     preForAll(localMethod, this, new Object[0]);
/*     */     try
/*     */     {
/* 342 */       oracle.jdbc.internal.OracleClob localOracleClob = (oracle.jdbc.internal.OracleClob)getDelegate();
/*     */       Object localObject;
/* 345 */       if (this.isFreed)
/*     */       {
/* 347 */         localObject = DatabaseError.createSqlException(localOracleClob.getInternalConnection(), 192);
/*     */ 
/* 350 */         ((SQLException)localObject).fillInStackTrace();
/* 351 */         throw ((Throwable)localObject);
/*     */       }
/*     */ 
/* 356 */       if (localOracleClob.canReadBasicLobDataInLocator())
/*     */       {
/* 358 */         localObject = localOracleClob.getCharacterStream();
/*     */       }
/*     */       else
/*     */       {
/* 362 */         localObject = localOracleClob.getDBAccess().newReader((oracle.jdbc.internal.OracleClob)this, localOracleClob.getBufferSize(), 0L);
/*     */       }
/*     */ 
/* 365 */       return (Reader)postForAll(localMethod, localObject);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 369 */       return (Reader)postForAll(localMethod, onErrorForAll(localMethod, localSQLException));
/*     */     }
/*     */   }
/*     */ 
/*     */   public Reader getCharacterStream(long paramLong) throws SQLException
/*     */   {
/* 375 */     if (GETCHARSTREAM_LONG_METHOD == null)
/*     */     {
/* 377 */       throw DatabaseError.createSqlException(1, "Cannot get character stream");
/*     */     }
/*     */ 
/* 381 */     Method localMethod = GETCHARSTREAM_LONG_METHOD;
/*     */ 
/* 383 */     preForAll(localMethod, this, new Object[0]);
/*     */     try
/*     */     {
/* 387 */       oracle.jdbc.internal.OracleClob localOracleClob = (oracle.jdbc.internal.OracleClob)getDelegate();
/*     */       Object localObject;
/* 390 */       if (this.isFreed)
/*     */       {
/* 392 */         localObject = DatabaseError.createSqlException(localOracleClob.getInternalConnection(), 192);
/*     */ 
/* 395 */         ((SQLException)localObject).fillInStackTrace();
/* 396 */         throw ((Throwable)localObject);
/*     */       }
/*     */ 
/* 401 */       if (localOracleClob.canReadBasicLobDataInLocator())
/*     */       {
/* 403 */         localObject = localOracleClob.getCharacterStream(paramLong);
/*     */       }
/*     */       else
/*     */       {
/* 407 */         localObject = localOracleClob.getDBAccess().newReader((oracle.jdbc.internal.OracleClob)this, localOracleClob.getBufferSize(), paramLong);
/*     */       }
/*     */ 
/* 410 */       return (Reader)postForAll(localMethod, localObject);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 414 */       return (Reader)postForAll(localMethod, onErrorForAll(localMethod, localSQLException));
/*     */     }
/*     */   }
/*     */ 
/*     */   public Reader getCharacterStream(long paramLong1, long paramLong2)
/*     */     throws SQLException
/*     */   {
/* 421 */     if (GETCHARSTREAM_LONG_LONG_METHOD == null)
/*     */     {
/* 423 */       throw DatabaseError.createSqlException(1, "Cannot get character stream");
/*     */     }
/*     */ 
/* 427 */     Method localMethod = GETCHARSTREAM_LONG_LONG_METHOD;
/*     */ 
/* 429 */     preForAll(localMethod, this, new Object[0]);
/*     */     try
/*     */     {
/* 433 */       oracle.jdbc.internal.OracleClob localOracleClob = (oracle.jdbc.internal.OracleClob)getDelegate();
/*     */       Object localObject;
/* 436 */       if (this.isFreed)
/*     */       {
/* 438 */         localObject = DatabaseError.createSqlException(localOracleClob.getInternalConnection(), 192);
/*     */ 
/* 441 */         ((SQLException)localObject).fillInStackTrace();
/* 442 */         throw ((Throwable)localObject);
/*     */       }
/*     */ 
/* 447 */       if (localOracleClob.canReadBasicLobDataInLocator())
/*     */       {
/* 449 */         localObject = localOracleClob.getCharacterStream(paramLong1, paramLong2);
/*     */       }
/*     */       else
/*     */       {
/* 453 */         long l = localOracleClob.length();
/* 454 */         if ((paramLong1 < 1L) || (paramLong2 < 0L) || (paramLong1 > l) || (paramLong1 - 1L + paramLong2 > l))
/*     */         {
/* 456 */           SQLException localSQLException2 = DatabaseError.createSqlException(localOracleClob.getInternalConnection(), 68);
/*     */ 
/* 459 */           localSQLException2.fillInStackTrace();
/* 460 */           throw localSQLException2;
/*     */         }
/*     */ 
/* 463 */         localObject = localOracleClob.getDBAccess().newReader((oracle.jdbc.internal.OracleClob)this, localOracleClob.getBufferSize(), paramLong1, paramLong2);
/*     */       }
/*     */ 
/* 466 */       return (Reader)postForAll(localMethod, localObject);
/*     */     }
/*     */     catch (SQLException localSQLException1)
/*     */     {
/* 470 */       return (Reader)postForAll(localMethod, onErrorForAll(localMethod, localSQLException1));
/*     */     }
/*     */   }
/*     */ 
/*     */   public OutputStream setAsciiStream(long paramLong) throws SQLException
/*     */   {
/* 476 */     if (SETASCIISTREAM_LONG_METHOD == null)
/*     */     {
/* 478 */       throw DatabaseError.createSqlException(1, "Cannot set ascii stream");
/*     */     }
/*     */ 
/* 482 */     Method localMethod = SETASCIISTREAM_LONG_METHOD;
/*     */ 
/* 484 */     preForAll(localMethod, this, new Object[0]);
/*     */     try
/*     */     {
/* 488 */       oracle.jdbc.internal.OracleClob localOracleClob = (oracle.jdbc.internal.OracleClob)getDelegate();
/*     */ 
/* 491 */       if (this.isFreed)
/*     */       {
/* 493 */         localObject = DatabaseError.createSqlException(localOracleClob.getInternalConnection(), 192);
/*     */ 
/* 496 */         ((SQLException)localObject).fillInStackTrace();
/* 497 */         throw ((Throwable)localObject);
/*     */       }
/*     */ 
/* 500 */       Object localObject = localOracleClob.getDBAccess().newOutputStream((oracle.jdbc.internal.OracleClob)this, localOracleClob.getBufferSize(), paramLong, true);
/*     */ 
/* 503 */       return (OutputStream)postForAll(localMethod, localObject);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 507 */       return (OutputStream)postForAll(localMethod, onErrorForAll(localMethod, localSQLException));
/*     */     }
/*     */   }
/*     */ 
/*     */   public Writer setCharacterStream(long paramLong) throws SQLException
/*     */   {
/* 513 */     if (SETCHARSTREAM_LONG_METHOD == null)
/*     */     {
/* 515 */       throw DatabaseError.createSqlException(1, "Cannot set character stream");
/*     */     }
/*     */ 
/* 519 */     Method localMethod = SETCHARSTREAM_LONG_METHOD;
/*     */ 
/* 521 */     preForAll(localMethod, this, new Object[0]);
/*     */     try
/*     */     {
/* 525 */       oracle.jdbc.internal.OracleClob localOracleClob = (oracle.jdbc.internal.OracleClob)getDelegate();
/*     */ 
/* 528 */       if (this.isFreed)
/*     */       {
/* 530 */         localObject = DatabaseError.createSqlException(localOracleClob.getInternalConnection(), 192);
/*     */ 
/* 533 */         ((SQLException)localObject).fillInStackTrace();
/* 534 */         throw ((Throwable)localObject);
/*     */       }
/*     */ 
/* 537 */       Object localObject = localOracleClob.getDBAccess().newWriter((oracle.jdbc.internal.OracleClob)this, localOracleClob.getBufferSize(), paramLong, true);
/*     */ 
/* 540 */       return (Writer)postForAll(localMethod, localObject);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 544 */       return (Writer)postForAll(localMethod, onErrorForAll(localMethod, localSQLException));
/*     */     }
/*     */   }
/*     */ 
/*     */   public OutputStream getAsciiOutputStream()
/*     */     throws SQLException
/*     */   {
/* 551 */     return setAsciiStream(1L);
/*     */   }
/*     */ 
/*     */   public OutputStream getAsciiOutputStream(long paramLong)
/*     */     throws SQLException
/*     */   {
/* 557 */     return setAsciiStream(paramLong);
/*     */   }
/*     */ 
/*     */   public Writer getCharacterOutputStream()
/*     */     throws SQLException
/*     */   {
/* 563 */     return setCharacterStream(1L);
/*     */   }
/*     */ 
/*     */   public Writer getCharacterOutputStream(long paramLong)
/*     */     throws SQLException
/*     */   {
/* 569 */     return setCharacterStream(paramLong);
/*     */   }
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.MANUAL)
/*     */   public OracleConnection getInternalConnection()
/*     */     throws SQLException
/*     */   {
/* 576 */     oracle.jdbc.internal.OracleClob localOracleClob = (oracle.jdbc.internal.OracleClob)getDelegate();
/*     */ 
/* 579 */     return localOracleClob.getInternalConnection();
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.replay.driver.NonTxnReplayableClob
 * JD-Core Version:    0.6.2
 */