/*     */ package oracle.jdbc.replay.driver;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.lang.reflect.Method;
/*     */ import java.sql.Blob;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.jdbc.proxy.annotation.GetCreator;
/*     */ import oracle.jdbc.proxy.annotation.GetDelegate;
/*     */ import oracle.jdbc.proxy.annotation.Methods;
/*     */ import oracle.jdbc.proxy.annotation.OnError;
/*     */ import oracle.jdbc.proxy.annotation.Post;
/*     */ import oracle.jdbc.proxy.annotation.Pre;
/*     */ import oracle.jdbc.proxy.annotation.ProxyFor;
/*     */ import oracle.jdbc.proxy.annotation.ProxyResult;
/*     */ import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
/*     */ import oracle.jdbc.proxy.annotation.SetDelegate;
/*     */ import oracle.sql.BlobDBAccess;
/*     */ 
/*     */ @ProxyFor({Blob.class, oracle.jdbc.OracleBlob.class, oracle.jdbc.internal.OracleBlob.class})
/*     */ public abstract class NonTxnReplayableBlob extends NonTxnReplayableBase
/*     */   implements Replayable
/*     */ {
/*  48 */   private static final Method GETBINSTREAM_METHOD = getGetBinaryStreamMethod();
/*  49 */   private static final Method GETBINSTREAM_LONG_METHOD = getGetBinaryStreamLongMethod();
/*  50 */   private static final Method GETBINSTREAM_LONG_LONG_METHOD = getGetBinaryStreamLongLongMethod();
/*  51 */   private static final Method SETBINSTREAM_LONG_METHOD = getSetBinaryStreamLongMethod();
/*     */ 
/*  53 */   protected boolean isFreed = false;
/*     */ 
/* 405 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */ 
/*     */   private static final Method getGetBinaryStreamMethod()
/*     */   {
/*     */     try
/*     */     {
/*  60 */       return oracle.jdbc.internal.OracleBlob.class.getMethod("getBinaryStream", new Class[0]);
/*     */     }
/*     */     catch (Exception localException) {
/*     */     }
/*  64 */     return null;
/*     */   }
/*     */ 
/*     */   private static final Method getGetBinaryStreamLongMethod()
/*     */   {
/*     */     try
/*     */     {
/*  72 */       return oracle.jdbc.internal.OracleBlob.class.getMethod("getBinaryStream", new Class[] { Long.TYPE });
/*     */     }
/*     */     catch (Exception localException) {
/*     */     }
/*  76 */     return null;
/*     */   }
/*     */ 
/*     */   private static final Method getGetBinaryStreamLongLongMethod()
/*     */   {
/*     */     try
/*     */     {
/*  84 */       return oracle.jdbc.internal.OracleBlob.class.getMethod("getBinaryStream", new Class[] { Long.TYPE, Long.TYPE });
/*     */     }
/*     */     catch (Exception localException) {
/*     */     }
/*  88 */     return null;
/*     */   }
/*     */ 
/*     */   private static final Method getSetBinaryStreamLongMethod()
/*     */   {
/*     */     try
/*     */     {
/*  96 */       return oracle.jdbc.internal.OracleBlob.class.getMethod("setBinaryStream", new Class[] { Long.TYPE });
/*     */     }
/*     */     catch (Exception localException) {
/*     */     }
/* 100 */     return null;
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   protected void preForAll(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/* 110 */     super.preForAll(paramMethod, paramObject, paramArrayOfObject);
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="free", args={})})
/*     */   protected void preForFree(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/* 120 */     this.isFreed = true;
/* 121 */     super.preForAll(paramMethod, paramObject, paramArrayOfObject);
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   @Methods(signatures={@oracle.jdbc.proxy.annotation.Signature(name="setBytes", args={long.class, byte[].class}), @oracle.jdbc.proxy.annotation.Signature(name="setBytes", args={long.class, byte[].class, int.class, int.class}), @oracle.jdbc.proxy.annotation.Signature(name="truncate", args={long.class})})
/*     */   protected void preForBlobWrites(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/* 134 */     FailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*     */ 
/* 136 */     if (localReplayLifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
/* 137 */       return;
/*     */     }
/*     */ 
/* 141 */     if (this.failoverMngr != null)
/* 142 */       this.failoverMngr.disableReplayInternal(paramMethod, 371, "Replay disabled because of active transaction", null);
/*     */   }
/*     */ 
/*     */   @Post
/*     */   protected Object postForAll(Method paramMethod, Object paramObject)
/*     */   {
/* 159 */     if ((paramObject instanceof NonTxnReplayableBase))
/*     */     {
/* 161 */       NonTxnReplayableBase localNonTxnReplayableBase = (NonTxnReplayableBase)paramObject;
/* 162 */       localNonTxnReplayableBase.setFailoverManager(getFailoverManager());
/*     */     }
/*     */ 
/* 165 */     return super.postForAll(paramMethod, paramObject);
/*     */   }
/*     */ 
/*     */   @OnError(SQLException.class)
/*     */   protected void onErrorVoidForAll(Method paramMethod, SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/* 172 */     super.onErrorVoidForAll(paramMethod, paramSQLException);
/*     */   }
/*     */ 
/*     */   @OnError(SQLException.class)
/*     */   protected Object onErrorForAll(Method paramMethod, SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/* 179 */     return super.onErrorForAll(paramMethod, paramSQLException);
/*     */   }
/*     */ 
/*     */   @GetDelegate
/*     */   protected abstract Object getDelegate();
/*     */ 
/*     */   @SetDelegate
/*     */   protected abstract void setDelegate(Object paramObject);
/*     */ 
/*     */   @GetCreator
/*     */   protected abstract Object getCreator();
/*     */ 
/*     */   public InputStream getBinaryStream()
/*     */     throws SQLException
/*     */   {
/* 201 */     if (GETBINSTREAM_METHOD == null)
/*     */     {
/* 203 */       throw DatabaseError.createSqlException(1, "Cannot get binary stream");
/*     */     }
/*     */ 
/* 207 */     Method localMethod = GETBINSTREAM_METHOD;
/*     */ 
/* 209 */     preForAll(localMethod, this, new Object[0]);
/*     */     try
/*     */     {
/* 213 */       oracle.jdbc.internal.OracleBlob localOracleBlob = (oracle.jdbc.internal.OracleBlob)getDelegate();
/*     */       Object localObject;
/* 216 */       if (this.isFreed)
/*     */       {
/* 218 */         localObject = DatabaseError.createSqlException(localOracleBlob.getInternalConnection(), 192);
/*     */ 
/* 221 */         ((SQLException)localObject).fillInStackTrace();
/* 222 */         throw ((Throwable)localObject);
/*     */       }
/*     */ 
/* 227 */       if (localOracleBlob.canReadBasicLobDataInLocator())
/*     */       {
/* 229 */         localObject = localOracleBlob.getBinaryStream();
/*     */       }
/*     */       else
/*     */       {
/* 233 */         localObject = localOracleBlob.getDBAccess().newInputStream((oracle.jdbc.internal.OracleBlob)this, localOracleBlob.getBufferSize(), 0L);
/*     */       }
/*     */ 
/* 236 */       return (InputStream)postForAll(localMethod, localObject);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 240 */       return (InputStream)postForAll(localMethod, onErrorForAll(localMethod, localSQLException));
/*     */     }
/*     */   }
/*     */ 
/*     */   public InputStream getBinaryStream(long paramLong) throws SQLException
/*     */   {
/* 246 */     if (GETBINSTREAM_LONG_METHOD == null)
/*     */     {
/* 248 */       throw DatabaseError.createSqlException(1, "Cannot get binary stream");
/*     */     }
/*     */ 
/* 252 */     Method localMethod = GETBINSTREAM_LONG_METHOD;
/*     */ 
/* 254 */     preForAll(localMethod, this, new Object[0]);
/*     */     try
/*     */     {
/* 258 */       oracle.jdbc.internal.OracleBlob localOracleBlob = (oracle.jdbc.internal.OracleBlob)getDelegate();
/*     */       Object localObject;
/* 261 */       if (this.isFreed)
/*     */       {
/* 263 */         localObject = DatabaseError.createSqlException(localOracleBlob.getInternalConnection(), 192);
/*     */ 
/* 266 */         ((SQLException)localObject).fillInStackTrace();
/* 267 */         throw ((Throwable)localObject);
/*     */       }
/*     */ 
/* 272 */       if (localOracleBlob.canReadBasicLobDataInLocator())
/*     */       {
/* 274 */         localObject = localOracleBlob.getBinaryStream(paramLong);
/*     */       }
/*     */       else
/*     */       {
/* 278 */         localObject = localOracleBlob.getDBAccess().newInputStream((oracle.jdbc.internal.OracleBlob)this, localOracleBlob.getBufferSize(), paramLong);
/*     */       }
/*     */ 
/* 281 */       return (InputStream)postForAll(localMethod, localObject);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 285 */       return (InputStream)postForAll(localMethod, onErrorForAll(localMethod, localSQLException));
/*     */     }
/*     */   }
/*     */ 
/*     */   public InputStream getBinaryStream(long paramLong1, long paramLong2)
/*     */     throws SQLException
/*     */   {
/* 292 */     if (GETBINSTREAM_LONG_LONG_METHOD == null)
/*     */     {
/* 294 */       throw DatabaseError.createSqlException(1, "Cannot get binary stream");
/*     */     }
/*     */ 
/* 298 */     Method localMethod = GETBINSTREAM_LONG_LONG_METHOD;
/*     */ 
/* 300 */     preForAll(localMethod, this, new Object[0]);
/*     */     try
/*     */     {
/* 304 */       oracle.jdbc.internal.OracleBlob localOracleBlob = (oracle.jdbc.internal.OracleBlob)getDelegate();
/*     */       Object localObject;
/* 307 */       if (this.isFreed)
/*     */       {
/* 309 */         localObject = DatabaseError.createSqlException(localOracleBlob.getInternalConnection(), 192);
/*     */ 
/* 312 */         ((SQLException)localObject).fillInStackTrace();
/* 313 */         throw ((Throwable)localObject);
/*     */       }
/*     */ 
/* 318 */       if (localOracleBlob.canReadBasicLobDataInLocator())
/*     */       {
/* 320 */         localObject = localOracleBlob.getBinaryStream(paramLong1, paramLong2);
/*     */       }
/*     */       else
/*     */       {
/* 324 */         long l = localOracleBlob.length();
/* 325 */         if ((paramLong1 < 1L) || (paramLong2 < 0L) || (paramLong1 > l) || (paramLong1 - 1L + paramLong2 > l))
/*     */         {
/* 327 */           SQLException localSQLException2 = DatabaseError.createSqlException(localOracleBlob.getInternalConnection(), 68);
/*     */ 
/* 330 */           localSQLException2.fillInStackTrace();
/* 331 */           throw localSQLException2;
/*     */         }
/*     */ 
/* 334 */         localObject = localOracleBlob.getDBAccess().newInputStream((oracle.jdbc.internal.OracleBlob)this, localOracleBlob.getBufferSize(), paramLong1, paramLong2);
/*     */       }
/*     */ 
/* 337 */       return (InputStream)postForAll(localMethod, localObject);
/*     */     }
/*     */     catch (SQLException localSQLException1)
/*     */     {
/* 341 */       return (InputStream)postForAll(localMethod, onErrorForAll(localMethod, localSQLException1));
/*     */     }
/*     */   }
/*     */ 
/*     */   public OutputStream setBinaryStream(long paramLong) throws SQLException
/*     */   {
/* 347 */     if (SETBINSTREAM_LONG_METHOD == null)
/*     */     {
/* 349 */       throw DatabaseError.createSqlException(1, "Cannot set binary stream");
/*     */     }
/*     */ 
/* 353 */     Method localMethod = SETBINSTREAM_LONG_METHOD;
/*     */ 
/* 355 */     preForAll(localMethod, this, new Object[0]);
/*     */     try
/*     */     {
/* 359 */       oracle.jdbc.internal.OracleBlob localOracleBlob = (oracle.jdbc.internal.OracleBlob)getDelegate();
/*     */ 
/* 362 */       if (this.isFreed)
/*     */       {
/* 364 */         localObject = DatabaseError.createSqlException(localOracleBlob.getInternalConnection(), 192);
/*     */ 
/* 367 */         ((SQLException)localObject).fillInStackTrace();
/* 368 */         throw ((Throwable)localObject);
/*     */       }
/*     */ 
/* 371 */       Object localObject = localOracleBlob.getDBAccess().newOutputStream((oracle.jdbc.internal.OracleBlob)this, localOracleBlob.getBufferSize(), paramLong, true);
/*     */ 
/* 374 */       return (OutputStream)postForAll(localMethod, localObject);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 378 */       return (OutputStream)postForAll(localMethod, onErrorForAll(localMethod, localSQLException));
/*     */     }
/*     */   }
/*     */ 
/*     */   public OutputStream getBinaryOutputStream()
/*     */     throws SQLException
/*     */   {
/* 385 */     return setBinaryStream(1L);
/*     */   }
/*     */ 
/*     */   public OutputStream getBinaryOutputStream(long paramLong)
/*     */     throws SQLException
/*     */   {
/* 391 */     return setBinaryStream(paramLong);
/*     */   }
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.MANUAL)
/*     */   public OracleConnection getInternalConnection()
/*     */     throws SQLException
/*     */   {
/* 398 */     oracle.jdbc.internal.OracleBlob localOracleBlob = (oracle.jdbc.internal.OracleBlob)getDelegate();
/*     */ 
/* 401 */     return localOracleBlob.getInternalConnection();
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.replay.driver.NonTxnReplayableBlob
 * JD-Core Version:    0.6.2
 */