/*     */ package oracle.jdbc.replay.driver;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.lang.reflect.Method;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.jdbc.proxy.annotation.GetCreator;
/*     */ import oracle.jdbc.proxy.annotation.GetDelegate;
/*     */ import oracle.jdbc.proxy.annotation.OnError;
/*     */ import oracle.jdbc.proxy.annotation.Post;
/*     */ import oracle.jdbc.proxy.annotation.Pre;
/*     */ import oracle.jdbc.proxy.annotation.ProxyFor;
/*     */ import oracle.jdbc.proxy.annotation.ProxyResult;
/*     */ import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
/*     */ import oracle.jdbc.proxy.annotation.SetDelegate;
/*     */ import oracle.sql.BfileDBAccess;
/*     */ 
/*     */ @ProxyFor({oracle.jdbc.OracleBfile.class, oracle.jdbc.internal.OracleBfile.class})
/*     */ public abstract class NonTxnReplayableBfile extends NonTxnReplayableBase
/*     */   implements Replayable
/*     */ {
/*  44 */   private static final Method GETBINSTREAM_METHOD = getGetBinaryStreamMethod();
/*  45 */   private static final Method GETBINSTREAM_LONG_METHOD = getGetBinaryStreamLongMethod();
/*     */   private static final int MAX_CHUNK_SIZE = 32512;
/* 188 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */ 
/*     */   private static final Method getGetBinaryStreamMethod()
/*     */   {
/*     */     try
/*     */     {
/*  54 */       return oracle.jdbc.internal.OracleBfile.class.getMethod("getBinaryStream", new Class[0]);
/*     */     }
/*     */     catch (Exception localException) {
/*     */     }
/*  58 */     return null;
/*     */   }
/*     */ 
/*     */   private static final Method getGetBinaryStreamLongMethod()
/*     */   {
/*     */     try
/*     */     {
/*  66 */       return oracle.jdbc.internal.OracleBfile.class.getMethod("getBinaryStream", new Class[] { Long.TYPE });
/*     */     }
/*     */     catch (Exception localException) {
/*     */     }
/*  70 */     return null;
/*     */   }
/*     */ 
/*     */   @Pre
/*     */   protected void preForAll(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/*  80 */     super.preForAll(paramMethod, paramObject, paramArrayOfObject);
/*     */   }
/*     */ 
/*     */   @Post
/*     */   protected Object postForAll(Method paramMethod, Object paramObject)
/*     */   {
/*  87 */     if ((paramObject instanceof NonTxnReplayableBase))
/*     */     {
/*  89 */       NonTxnReplayableBase localNonTxnReplayableBase = (NonTxnReplayableBase)paramObject;
/*  90 */       localNonTxnReplayableBase.setFailoverManager(getFailoverManager());
/*     */     }
/*     */ 
/*  93 */     return super.postForAll(paramMethod, paramObject);
/*     */   }
/*     */ 
/*     */   @OnError(SQLException.class)
/*     */   protected void onErrorVoidForAll(Method paramMethod, SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/* 100 */     super.onErrorVoidForAll(paramMethod, paramSQLException);
/*     */   }
/*     */ 
/*     */   @OnError(SQLException.class)
/*     */   protected Object onErrorForAll(Method paramMethod, SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/* 107 */     return super.onErrorForAll(paramMethod, paramSQLException);
/*     */   }
/*     */   @GetDelegate
/*     */   protected abstract Object getDelegate();
/*     */ 
/*     */   @SetDelegate
/*     */   protected abstract void setDelegate(Object paramObject);
/*     */ 
/*     */   @GetCreator
/*     */   protected abstract Object getCreator();
/*     */ 
/* 121 */   public InputStream getBinaryStream() throws SQLException { if (GETBINSTREAM_METHOD == null)
/*     */     {
/* 123 */       throw DatabaseError.createSqlException(1, "Cannot get binary stream");
/*     */     }
/*     */ 
/* 127 */     Method localMethod = GETBINSTREAM_METHOD;
/*     */ 
/* 129 */     preForAll(localMethod, this, new Object[0]);
/*     */     try
/*     */     {
/* 133 */       oracle.jdbc.internal.OracleBfile localOracleBfile = (oracle.jdbc.internal.OracleBfile)getDelegate();
/*     */ 
/* 136 */       InputStream localInputStream = localOracleBfile.getDBAccess().newInputStream((oracle.jdbc.internal.OracleBfile)this, 32512, 0L);
/*     */ 
/* 140 */       return (InputStream)postForAll(localMethod, localInputStream);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 144 */       return (InputStream)postForAll(localMethod, onErrorForAll(localMethod, localSQLException));
/*     */     } }
/*     */ 
/*     */   public InputStream getBinaryStream(long paramLong)
/*     */     throws SQLException
/*     */   {
/* 150 */     if (GETBINSTREAM_LONG_METHOD == null)
/*     */     {
/* 152 */       throw DatabaseError.createSqlException(1, "Cannot get binary stream");
/*     */     }
/*     */ 
/* 156 */     Method localMethod = GETBINSTREAM_LONG_METHOD;
/*     */ 
/* 158 */     preForAll(localMethod, this, new Object[0]);
/*     */     try
/*     */     {
/* 162 */       oracle.jdbc.internal.OracleBfile localOracleBfile = (oracle.jdbc.internal.OracleBfile)getDelegate();
/*     */ 
/* 165 */       InputStream localInputStream = localOracleBfile.getDBAccess().newInputStream((oracle.jdbc.internal.OracleBfile)this, 32512, paramLong);
/*     */ 
/* 169 */       return (InputStream)postForAll(localMethod, localInputStream);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 173 */       return (InputStream)postForAll(localMethod, onErrorForAll(localMethod, localSQLException));
/*     */     }
/*     */   }
/*     */ 
/*     */   @ProxyResult(ProxyResultPolicy.MANUAL)
/*     */   public OracleConnection getInternalConnection()
/*     */     throws SQLException
/*     */   {
/* 181 */     oracle.jdbc.internal.OracleBfile localOracleBfile = (oracle.jdbc.internal.OracleBfile)getDelegate();
/*     */ 
/* 184 */     return localOracleBfile.getInternalConnection();
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.replay.driver.NonTxnReplayableBfile
 * JD-Core Version:    0.6.2
 */