/*     */ package oracle.jdbc.replay.driver;
/*     */ 
/*     */ import java.lang.reflect.InvocationHandler;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.sql.DatabaseMetaData;
/*     */ import java.sql.ParameterMetaData;
/*     */ import java.sql.ResultSetMetaData;
/*     */ import java.sql.RowId;
/*     */ import java.sql.SQLData;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.SQLInput;
/*     */ import java.sql.SQLRecoverableException;
/*     */ import java.sql.SQLXML;
/*     */ import java.util.HashSet;
/*     */ import oracle.jdbc.AdditionalDatabaseMetaData;
/*     */ import oracle.jdbc.OracleParameterMetaData;
/*     */ import oracle.jdbc.OracleTypeMetaData;
/*     */ import oracle.jdbc.OracleTypeMetaData.Array;
/*     */ import oracle.jdbc.OracleTypeMetaData.Opaque;
/*     */ import oracle.jdbc.OracleTypeMetaData.Struct;
/*     */ import oracle.jdbc.proxy.annotation.GetCreator;
/*     */ import oracle.jdbc.proxy.annotation.GetDelegate;
/*     */ import oracle.jdbc.proxy.annotation.OnError;
/*     */ import oracle.jdbc.proxy.annotation.Post;
/*     */ import oracle.jdbc.proxy.annotation.Pre;
/*     */ import oracle.jdbc.proxy.annotation.ProxyFor;
/*     */ import oracle.jdbc.proxy.annotation.SetDelegate;
/*     */ import oracle.jdbc.replay.ReplayableConnection;
/*     */ 
/*     */ @ProxyFor({DatabaseMetaData.class, ParameterMetaData.class, ResultSetMetaData.class, RowId.class, SQLData.class, SQLInput.class, SQLXML.class, AdditionalDatabaseMetaData.class, OracleParameterMetaData.class, oracle.jdbc.OracleResultSetMetaData.class, OracleTypeMetaData.class, OracleTypeMetaData.Array.class, OracleTypeMetaData.Opaque.class, OracleTypeMetaData.Struct.class, oracle.jdbc.internal.OracleResultSetMetaData.class})
/*     */ public abstract class NonTxnReplayableBase
/*     */   implements Replayable, InvocationHandler
/*     */ {
/*     */   protected FailoverManagerImpl failoverMngr;
/*  66 */   protected FailoverManagerImpl.CallHistoryEntry headSameProxy = null;
/*  67 */   protected FailoverManagerImpl.CallHistoryEntry tailSameProxy = null;
/*     */ 
/*  70 */   protected FailoverManagerImpl.CallHistoryEntry replayingCallEntry = null;
/*     */ 
/*  73 */   protected SQLRecoverableException originalError = null;
/*     */   protected static final int SVR_TXN_IN_REPLAY_ERROR_CODE1 = 603;
/*     */   protected static final int SVR_TXN_IN_REPLAY_ERROR_CODE2 = 29791;
/*  85 */   protected boolean isClosedAndNoReplay = false;
/*     */ 
/* 553 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */ 
/*     */   @Pre
/*     */   protected void preForAll(Method paramMethod, Object paramObject, Object[] paramArrayOfObject)
/*     */   {
/*  95 */     FailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*     */ 
/*  98 */     switch (1.$SwitchMap$oracle$jdbc$replay$driver$FailoverManagerImpl$ReplayLifecycle[localReplayLifecycle.ordinal()])
/*     */     {
/*     */     case 1:
/* 101 */       this.failoverMngr.record(this, paramMethod, paramArrayOfObject, "started");
/*     */ 
/* 103 */       break;
/*     */     case 2:
/*     */     case 3:
/*     */     case 4:
/*     */     case 5:
/*     */     case 6:
/*     */     case 7:
/*     */     case 8:
/*     */     }
/*     */   }
/*     */ 
/*     */   @Post
/*     */   protected void postForAll(Method paramMethod)
/*     */   {
/* 119 */     postForAll(paramMethod, null);
/*     */   }
/*     */ 
/*     */   @Post
/*     */   protected Object postForAll(Method paramMethod, Object paramObject)
/*     */   {
/* 126 */     if ((paramObject instanceof NonTxnReplayableBase))
/*     */     {
/* 128 */       localObject = (NonTxnReplayableBase)paramObject;
/* 129 */       ((NonTxnReplayableBase)localObject).setFailoverManager(getFailoverManager());
/*     */     }
/*     */ 
/* 132 */     Object localObject = this.failoverMngr.getReplayLifecycle();
/*     */ 
/* 135 */     switch (1.$SwitchMap$oracle$jdbc$replay$driver$FailoverManagerImpl$ReplayLifecycle[localObject.ordinal()])
/*     */     {
/*     */     case 1:
/*     */     case 8:
/* 141 */       doPostWhenRecording(paramMethod, paramObject, null);
/* 142 */       break;
/*     */     case 2:
/*     */     case 3:
/*     */     case 4:
/*     */     case 5:
/*     */     case 7:
/* 150 */       break;
/*     */     case 6:
/* 155 */       doPostWhenReplaying(paramMethod, paramObject, null);
/*     */     }
/*     */ 
/* 158 */     return paramObject;
/*     */   }
/*     */ 
/*     */   protected void doPostWhenRecording(Method paramMethod, Object paramObject, SQLException paramSQLException)
/*     */   {
/* 170 */     this.failoverMngr.update(this, null, paramObject, "completed", 0L, -1L, paramSQLException);
/*     */   }
/*     */ 
/*     */   protected void doPostWhenReplaying(Method paramMethod, Object paramObject, SQLException paramSQLException)
/*     */   {
/*     */   }
/*     */ 
/*     */   @OnError(SQLException.class)
/*     */   protected void onErrorVoidForAll(Method paramMethod, SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/* 188 */     onErrorForAll(paramMethod, paramSQLException);
/*     */   }
/*     */ 
/*     */   @OnError(SQLException.class)
/*     */   protected Object onErrorForAll(Method paramMethod, SQLException paramSQLException)
/*     */     throws SQLException
/*     */   {
/* 196 */     if (this.isClosedAndNoReplay) {
/* 197 */       throw paramSQLException;
/*     */     }
/* 199 */     if ((paramSQLException instanceof SQLRecoverableException))
/*     */     {
/* 201 */       localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*     */ 
/* 203 */       switch (1.$SwitchMap$oracle$jdbc$replay$driver$FailoverManagerImpl$ReplayLifecycle[localReplayLifecycle.ordinal()])
/*     */       {
/*     */       case 1:
/*     */       case 3:
/*     */       case 4:
/*     */       case 5:
/* 211 */         return this.failoverMngr.replayAll((SQLRecoverableException)paramSQLException);
/*     */       case 2:
/*     */       case 6:
/*     */       case 7:
/*     */       case 8:
/*     */       }
/*     */ 
/* 221 */       throw paramSQLException;
/*     */     }
/*     */ 
/* 228 */     FailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*     */ 
/* 230 */     switch (1.$SwitchMap$oracle$jdbc$replay$driver$FailoverManagerImpl$ReplayLifecycle[localReplayLifecycle.ordinal()])
/*     */     {
/*     */     case 1:
/*     */     case 8:
/* 235 */       doPostWhenRecording(paramMethod, null, paramSQLException);
/*     */ 
/* 237 */       break;
/*     */     case 2:
/*     */     case 3:
/*     */     case 4:
/*     */     case 5:
/*     */     case 6:
/*     */     case 7:
/*     */     }
/*     */ 
/* 249 */     throw paramSQLException;
/*     */   }
/*     */ 
/*     */   @GetDelegate
/*     */   protected abstract Object getDelegate();
/*     */ 
/*     */   @SetDelegate
/*     */   protected abstract void setDelegate(Object paramObject);
/*     */ 
/*     */   @GetCreator
/*     */   protected abstract Object getCreator();
/*     */ 
/*     */   public void fillInChecksum(FailoverManagerImpl.CallHistoryEntry paramCallHistoryEntry)
/*     */     throws SQLException
/*     */   {
/*     */   }
/*     */ 
/*     */   public Object replayOneCall(FailoverManagerImpl.CallHistoryEntry paramCallHistoryEntry, SQLRecoverableException paramSQLRecoverableException)
/*     */     throws SQLException
/*     */   {
/* 309 */     Object localObject1 = null;
/*     */     try
/*     */     {
/* 314 */       ((InvocationHandler)paramCallHistoryEntry.jdbcProxy).setReplayingCallContext(paramCallHistoryEntry, paramSQLRecoverableException);
/*     */ 
/* 317 */       Object localObject2 = paramCallHistoryEntry.method.invoke(paramCallHistoryEntry.jdbcProxy, paramCallHistoryEntry.args);
/* 318 */       localObject1 = localObject2;
/*     */ 
/* 324 */       if ((localObject2 instanceof NonTxnReplayableBase))
/*     */       {
/* 326 */         localObject3 = this.failoverMngr.getReplayLifecycle();
/*     */ 
/* 328 */         if ((localObject3 == FailoverManagerImpl.ReplayLifecycle.REPLAYING) && (localObject2 != null) && (paramCallHistoryEntry.result != null))
/*     */         {
/* 332 */           localObject4 = ((NonTxnReplayableBase)localObject2).getDelegate();
/* 333 */           ((NonTxnReplayableBase)paramCallHistoryEntry.result).setDelegate(localObject4);
/* 334 */           localObject1 = paramCallHistoryEntry.result;
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (InvocationTargetException localInvocationTargetException)
/*     */     {
/*     */       Object localObject4;
/* 340 */       Object localObject3 = localInvocationTargetException.getCause();
/*     */ 
/* 345 */       if ((localObject3 instanceof SQLRecoverableException))
/*     */       {
/* 347 */         localObject4 = (SQLRecoverableException)localObject3;
/*     */ 
/* 350 */         throw ((Throwable)localObject4);
/*     */       }
/*     */ 
/* 354 */       if ((localObject3 instanceof SQLException))
/*     */       {
/* 356 */         localObject4 = (SQLException)localObject3;
/*     */ 
/* 358 */         int i = ((SQLException)localObject4).getErrorCode();
/*     */ 
/* 360 */         if (i == 29791)
/*     */         {
/* 364 */           this.failoverMngr.disableReplayAndThrowException(paramCallHistoryEntry.method, 390, "Replay failed because of active transaction during replay", paramSQLRecoverableException);
/*     */         }
/* 372 */         else if ((paramCallHistoryEntry.callException == null) || (i != paramCallHistoryEntry.callException.getErrorCode()))
/*     */         {
/* 374 */           this.failoverMngr.disableReplayAndThrowException(paramCallHistoryEntry.method, 389, "Replay failed because of error code or message mismatch", paramSQLRecoverableException);
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/* 385 */         this.failoverMngr.disableReplayAndThrowException(paramCallHistoryEntry.method, 370, "Replay disabled", paramSQLRecoverableException);
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Throwable localThrowable)
/*     */     {
/* 396 */       localThrowable.printStackTrace();
/*     */ 
/* 399 */       this.failoverMngr.disableReplayAndThrowException(paramCallHistoryEntry.method, 370, "Replay disabled", paramSQLRecoverableException);
/*     */     }
/*     */ 
/* 406 */     FailoverManagerImpl.ReplayLifecycle localReplayLifecycle = this.failoverMngr.getReplayLifecycle();
/*     */ 
/* 408 */     switch (1.$SwitchMap$oracle$jdbc$replay$driver$FailoverManagerImpl$ReplayLifecycle[localReplayLifecycle.ordinal()])
/*     */     {
/*     */     case 2:
/*     */     case 4:
/* 414 */       this.failoverMngr.throwReplayExceptionInternal(0, null, null);
/*     */     }
/*     */ 
/* 417 */     return localObject1;
/*     */   }
/*     */ 
/*     */   public void addToSameProxyList(FailoverManagerImpl.CallHistoryEntry paramCallHistoryEntry)
/*     */   {
/* 422 */     paramCallHistoryEntry.prevEntrySameProxy = this.tailSameProxy;
/* 423 */     paramCallHistoryEntry.nextEntrySameProxy = null;
/*     */ 
/* 425 */     if (this.tailSameProxy != null) {
/* 426 */       this.tailSameProxy.nextEntrySameProxy = paramCallHistoryEntry;
/*     */     }
/* 428 */     this.tailSameProxy = paramCallHistoryEntry;
/*     */ 
/* 431 */     if (this.headSameProxy == null)
/* 432 */       this.headSameProxy = paramCallHistoryEntry;
/*     */   }
/*     */ 
/*     */   public void removeFromSameProxyList(FailoverManagerImpl.CallHistoryEntry paramCallHistoryEntry)
/*     */   {
/* 437 */     if (paramCallHistoryEntry.nextEntrySameProxy != null) {
/* 438 */       paramCallHistoryEntry.nextEntrySameProxy.prevEntrySameProxy = paramCallHistoryEntry.prevEntrySameProxy;
/*     */     }
/*     */ 
/* 441 */     if (paramCallHistoryEntry.prevEntrySameProxy != null) {
/* 442 */       paramCallHistoryEntry.prevEntrySameProxy.nextEntrySameProxy = paramCallHistoryEntry.nextEntrySameProxy;
/*     */     }
/*     */ 
/* 445 */     if (this.headSameProxy == paramCallHistoryEntry) {
/* 446 */       this.headSameProxy = paramCallHistoryEntry.nextEntrySameProxy;
/*     */     }
/* 448 */     if (this.tailSameProxy == paramCallHistoryEntry)
/* 449 */       this.tailSameProxy = paramCallHistoryEntry.prevEntrySameProxy;
/*     */   }
/*     */ 
/*     */   public void purgeSameProxyList()
/*     */   {
/* 454 */     if (this.failoverMngr != null)
/*     */     {
/* 456 */       HashSet localHashSet = new HashSet();
/*     */ 
/* 459 */       for (Object localObject = this; 
/* 461 */         (localObject != null) && ((localObject instanceof NonTxnReplayableBase)) && (!(localObject instanceof ReplayableConnection)); 
/* 463 */         localObject = ((NonTxnReplayableBase)localObject).getCreator())
/*     */       {
/* 465 */         localHashSet.add(localObject);
/*     */       }
/*     */ 
/* 469 */       this.failoverMngr.purgeForSameProxy(localHashSet, this.headSameProxy);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setReplayingCallContext(FailoverManagerImpl.CallHistoryEntry paramCallHistoryEntry, SQLRecoverableException paramSQLRecoverableException)
/*     */   {
/* 476 */     this.replayingCallEntry = paramCallHistoryEntry;
/* 477 */     this.originalError = paramSQLRecoverableException;
/*     */   }
/*     */ 
/*     */   public synchronized void setFailoverManager(FailoverManagerImpl paramFailoverManagerImpl)
/*     */   {
/* 482 */     this.failoverMngr = paramFailoverManagerImpl;
/*     */   }
/*     */ 
/*     */   public synchronized FailoverManagerImpl getFailoverManager()
/*     */   {
/* 487 */     return this.failoverMngr;
/*     */   }
/*     */ 
/*     */   private boolean isReplayFailure(Throwable paramThrowable)
/*     */   {
/* 497 */     boolean bool = false;
/*     */ 
/* 499 */     if ((paramThrowable instanceof SQLException))
/*     */     {
/* 501 */       int i = ((SQLException)paramThrowable).getErrorCode();
/* 502 */       if ((i >= 370) && (i < 400))
/*     */       {
/* 504 */         bool = true;
/*     */       }
/*     */     }
/* 507 */     return bool;
/*     */   }
/*     */ 
/*     */   protected boolean assertThrowablesMatch(Throwable paramThrowable1, Throwable paramThrowable2)
/*     */   {
/* 514 */     boolean bool1 = paramThrowable2 == null ? false : paramThrowable1.getClass().getName().equals(paramThrowable2.getClass().getName());
/*     */     boolean bool2;
/* 523 */     if (((paramThrowable1 instanceof SQLException)) && (bool1))
/*     */     {
/* 526 */       bool2 = ((SQLException)paramThrowable1).getErrorCode() == ((SQLException)paramThrowable2).getErrorCode();
/*     */     }
/* 532 */     else if (bool1)
/*     */     {
/* 535 */       String str1 = paramThrowable1.getMessage();
/* 536 */       String str2 = paramThrowable2.getMessage();
/* 537 */       bool2 = ((str1 == null) && (str2 == null)) || ((str1 != null) && (str2 != null) && (paramThrowable1.getMessage().equals(paramThrowable2.getMessage())));
/*     */     }
/*     */     else
/*     */     {
/* 545 */       bool2 = false;
/*     */     }
/*     */ 
/* 549 */     return bool2;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.replay.driver.NonTxnReplayableBase
 * JD-Core Version:    0.6.2
 */