/*      */ package oracle.jdbc.replay.driver;
/*      */ 
/*      */ import java.lang.reflect.Method;
/*      */ import java.sql.Connection;
/*      */ import java.sql.ResultSet;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.SQLRecoverableException;
/*      */ import java.sql.Statement;
/*      */ import java.util.EnumSet;
/*      */ import java.util.HashSet;
/*      */ import java.util.Set;
/*      */ import java.util.concurrent.ExecutorService;
/*      */ import java.util.concurrent.Executors;
/*      */ import java.util.concurrent.ThreadFactory;
/*      */ import oracle.jdbc.driver.DatabaseError;
/*      */ import oracle.jdbc.internal.OracleConnection;
/*      */ import oracle.jdbc.internal.OracleConnection.ChecksumMode;
/*      */ import oracle.jdbc.internal.OracleConnection.TransactionState;
/*      */ import oracle.jdbc.replay.internal.ConnectionInitializationCallback;
/*      */ import oracle.jdbc.replay.internal.OracleDataSource;
/*      */ 
/*      */ class FailoverManagerImpl
/*      */   implements FailoverManager
/*      */ {
/*      */   private static final String MONITOR_TXN = "BEGIN DBMS_APP_CONT_PRVT.MONITOR_TXN; END;";
/*      */   private static final String BEGIN_REPLAY = "BEGIN DBMS_APP_CONT_PRVT.BEGIN_REPLAY; END;";
/*      */   private static final String END_REPLAY = "BEGIN DBMS_APP_CONT_PRVT.END_REPLAY; END;";
/*      */   private CallHistoryEntry head;
/*      */   private CallHistoryEntry tail;
/*  132 */   private ReplayLifecycle lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
/*      */ 
/*  137 */   private boolean replayInCurrentMode = false;
/*      */   private Object replayResult;
/*      */   private long requestStartTime;
/*  146 */   private long replayInitiationTimeout = 900L;
/*      */   private static final int REPLAY_RETRIES = 3;
/*  150 */   private int replayRetries = 0;
/*      */ 
/*  152 */   private OracleDataSource replayDataSource = null;
/*      */   private NonTxnReplayableBase connectionProxy;
/*      */   private Method callCausingReplayError;
/*      */   private int replayErrorCode;
/*      */   private String replayErrorMessage;
/*  169 */   private static final ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactory()
/*      */   {
/*      */     private static final String THREAD_NAME = "OJDBC-AC-WORKER-THREAD";
/*      */ 
/*      */     public Thread newThread(Runnable paramAnonymousRunnable)
/*      */     {
/*  177 */       Thread localThread = new Thread(null, paramAnonymousRunnable, "OJDBC-AC-WORKER-THREAD");
/*      */ 
/*  179 */       localThread.setPriority(5);
/*  180 */       localThread.setDaemon(true);
/*      */ 
/*  182 */       return localThread;
/*      */     }
/*      */   });
/*      */ 
/* 1247 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */ 
/*      */   private FailoverManagerImpl(NonTxnReplayableBase paramNonTxnReplayableBase, OracleDataSource paramOracleDataSource) throws SQLException
/*      */   {
/*  193 */     this.connectionProxy = paramNonTxnReplayableBase;
/*  194 */     this.replayDataSource = paramOracleDataSource;
/*      */ 
/*  201 */     enableTxnMonitoring((OracleConnection)this.connectionProxy.getDelegate());
/*      */   }
/*      */ 
/*      */   static FailoverManager getFailoverManager(NonTxnReplayableBase paramNonTxnReplayableBase, OracleDataSource paramOracleDataSource)
/*      */     throws SQLException
/*      */   {
/*  211 */     return new FailoverManagerImpl(paramNonTxnReplayableBase, paramOracleDataSource);
/*      */   }
/*      */ 
/*      */   private void append(CallHistoryEntry paramCallHistoryEntry)
/*      */   {
/*  220 */     paramCallHistoryEntry.prevEntry = this.tail;
/*  221 */     paramCallHistoryEntry.nextEntry = null;
/*      */ 
/*  223 */     if (this.tail != null) {
/*  224 */       this.tail.nextEntry = paramCallHistoryEntry;
/*      */     }
/*  226 */     this.tail = paramCallHistoryEntry;
/*      */ 
/*  229 */     if (this.head == null) {
/*  230 */       this.head = paramCallHistoryEntry;
/*      */     }
/*      */ 
/*  233 */     Replayable localReplayable = (Replayable)paramCallHistoryEntry.jdbcProxy;
/*  234 */     localReplayable.addToSameProxyList(paramCallHistoryEntry);
/*      */   }
/*      */ 
/*      */   private void remove(CallHistoryEntry paramCallHistoryEntry)
/*      */   {
/*  239 */     if (paramCallHistoryEntry.nextEntry != null) {
/*  240 */       paramCallHistoryEntry.nextEntry.prevEntry = paramCallHistoryEntry.prevEntry;
/*      */     }
/*  242 */     if (paramCallHistoryEntry.prevEntry != null) {
/*  243 */       paramCallHistoryEntry.prevEntry.nextEntry = paramCallHistoryEntry.nextEntry;
/*      */     }
/*  245 */     if (this.head == paramCallHistoryEntry) {
/*  246 */       this.head = paramCallHistoryEntry.nextEntry;
/*      */     }
/*  248 */     if (this.tail == paramCallHistoryEntry) {
/*  249 */       this.tail = paramCallHistoryEntry.prevEntry;
/*      */     }
/*      */ 
/*  252 */     Replayable localReplayable = (Replayable)paramCallHistoryEntry.jdbcProxy;
/*  253 */     localReplayable.removeFromSameProxyList(paramCallHistoryEntry);
/*      */   }
/*      */ 
/*      */   CallHistoryEntry record(Object paramObject, Method paramMethod, Object[] paramArrayOfObject, String paramString)
/*      */   {
/*  262 */     synchronized (this)
/*      */     {
/*  264 */       String str = paramMethod == null ? "NULL METHOD" : paramMethod.getName();
/*  265 */       StringBuilder localStringBuilder = new StringBuilder();
/*  266 */       if ((paramArrayOfObject != null) && (paramArrayOfObject.length > 0))
/*      */       {
/*  268 */         for (int i = 0; i < paramArrayOfObject.length - 1; i++)
/*      */         {
/*  270 */           localStringBuilder.append(paramArrayOfObject[i]);
/*  271 */           localStringBuilder.append(",");
/*      */         }
/*  273 */         localStringBuilder.append(paramArrayOfObject[(paramArrayOfObject.length - 1)]);
/*      */       }
/*      */ 
/*  278 */       CallHistoryEntry localCallHistoryEntry = new CallHistoryEntry(paramObject, paramMethod, paramArrayOfObject, paramString);
/*      */ 
/*  283 */       append(localCallHistoryEntry);
/*      */ 
/*  287 */       return localCallHistoryEntry;
/*      */     }
/*      */   }
/*      */ 
/*      */   void update(Object paramObject1, CallHistoryEntry paramCallHistoryEntry, Object paramObject2, String paramString, long paramLong1, long paramLong2, SQLException paramSQLException)
/*      */   {
/*  303 */     synchronized (this)
/*      */     {
/*  305 */       CallHistoryEntry localCallHistoryEntry = paramCallHistoryEntry == null ? this.tail : paramCallHistoryEntry;
/*  306 */       String str = (localCallHistoryEntry == null) || (localCallHistoryEntry.method == null) ? "NULL METHOD" : localCallHistoryEntry.method.getName();
/*      */ 
/*  313 */       localCallHistoryEntry.result = paramObject2;
/*  314 */       localCallHistoryEntry.checksum = paramLong1;
/*  315 */       localCallHistoryEntry.scn = paramLong2;
/*  316 */       localCallHistoryEntry.callException = paramSQLException;
/*      */ 
/*  319 */       localCallHistoryEntry.callStatus = paramString;
/*      */     }
/*      */   }
/*      */ 
/*      */   synchronized void purge()
/*      */   {
/*  329 */     for (CallHistoryEntry localCallHistoryEntry = this.head; 
/*  330 */       localCallHistoryEntry != null; 
/*  331 */       localCallHistoryEntry = localCallHistoryEntry.nextEntry)
/*  332 */       remove(localCallHistoryEntry);
/*      */   }
/*      */ 
/*      */   synchronized void purgeForSameProxy(Set<Object> paramSet, CallHistoryEntry paramCallHistoryEntry)
/*      */   {
/*  341 */     Object localObject1 = paramCallHistoryEntry == null ? null : paramCallHistoryEntry.jdbcProxy;
/*      */ 
/*  349 */     for (CallHistoryEntry localCallHistoryEntry = paramCallHistoryEntry; 
/*  350 */       localCallHistoryEntry != null; 
/*  351 */       localCallHistoryEntry = localCallHistoryEntry.nextEntrySameProxy)
/*      */     {
/*  353 */       Object localObject2 = localCallHistoryEntry.result;
/*      */ 
/*  355 */       if ((localObject2 != null) && ((localObject2 instanceof Replayable)) && (!paramSet.contains(localObject2)))
/*      */       {
/*  359 */         Replayable localReplayable = (Replayable)localObject2;
/*  360 */         localReplayable.purgeSameProxyList();
/*      */ 
/*  363 */         paramSet.add(localReplayable);
/*      */       }
/*      */ 
/*  368 */       remove(localCallHistoryEntry);
/*      */     }
/*      */   }
/*      */ 
/*      */   synchronized boolean isEmpty()
/*      */   {
/*  376 */     return this.head == null;
/*      */   }
/*      */ 
/*      */   void fillInAllChecksums()
/*      */     throws SQLException
/*      */   {
/*  382 */     synchronized (this)
/*      */     {
/*  396 */       HashSet localHashSet = new HashSet();
/*  397 */       for (CallHistoryEntry localCallHistoryEntry = this.tail.prevEntry; 
/*  398 */         localCallHistoryEntry != null; 
/*  399 */         localCallHistoryEntry = localCallHistoryEntry.prevEntry)
/*      */       {
/*  403 */         if (!localHashSet.contains(localCallHistoryEntry.jdbcProxy))
/*      */         {
/*  407 */           NonTxnReplayableBase localNonTxnReplayableBase = (NonTxnReplayableBase)localCallHistoryEntry.jdbcProxy;
/*      */ 
/*  409 */           localNonTxnReplayableBase.fillInChecksum(localCallHistoryEntry);
/*      */ 
/*  411 */           localHashSet.add(localCallHistoryEntry.jdbcProxy);
/*      */ 
/*  418 */           if ((localCallHistoryEntry.jdbcProxy instanceof ResultSet))
/*  419 */             localHashSet.add(localNonTxnReplayableBase.getCreator());
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   Object replayAll(SQLRecoverableException paramSQLRecoverableException)
/*      */     throws SQLException
/*      */   {
/*  429 */     synchronized (this)
/*      */     {
/*  431 */       this.replayRetries = 0;
/*      */       do
/*      */       {
/*      */         try
/*      */         {
/*  456 */           return replayAllInternal(paramSQLRecoverableException, this.replayRetries);
/*      */         }
/*      */         catch (SQLRecoverableException localSQLRecoverableException)
/*      */         {
/*  460 */           localReplayLifecycle = this.lifecycle;
/*      */ 
/*  463 */           switch (3.$SwitchMap$oracle$jdbc$replay$driver$FailoverManagerImpl$ReplayLifecycle[localReplayLifecycle.ordinal()])
/*      */           {
/*      */           case 1:
/*      */           case 2:
/*      */           case 3:
/*  470 */             this.replayRetries += 1;
/*      */           case 4:
/*      */           case 5:
/*      */           case 6:
/*      */           case 7:
/*      */           case 8:
/*      */           }
/*      */ 
/*      */         }
/*      */         catch (SQLException localSQLException)
/*      */         {
/*  487 */           ReplayLifecycle localReplayLifecycle = this.lifecycle;
/*      */ 
/*  490 */           switch (3.$SwitchMap$oracle$jdbc$replay$driver$FailoverManagerImpl$ReplayLifecycle[localReplayLifecycle.ordinal()])
/*      */           {
/*      */           case 8:
/*  494 */             this.replayRetries += 1;
/*      */ 
/*  496 */             this.lifecycle = ReplayLifecycle.REPLAYING;
/*      */           case 4:
/*      */           case 5:
/*      */           case 6:
/*      */           case 3:
/*      */           case 1:
/*      */           case 2:
/*      */           case 7:
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*  508 */         throwOriginalExceptionWithReplayError(this.replayErrorCode, this.replayErrorMessage, paramSQLRecoverableException);
/*      */ 
/*  516 */         throw localSQLException;
/*      */       }
/*      */ 
/*  525 */       while (this.replayRetries <= 3);
/*      */ 
/*  529 */       disableReplayAndThrowOriginalError(null, 378, "Replay disabled because maximum number of retries is exceeded", paramSQLRecoverableException);
/*      */ 
/*  535 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   synchronized Object replayAllInternal(SQLRecoverableException paramSQLRecoverableException, int paramInt)
/*      */     throws SQLException
/*      */   {
/*  548 */     ReplayLifecycle localReplayLifecycle = this.lifecycle;
/*      */ 
/*  552 */     if ((this.lifecycle != ReplayLifecycle.ENABLED_NOT_REPLAYING) && (this.lifecycle != ReplayLifecycle.REPLAYING) && (this.lifecycle != ReplayLifecycle.REPLAYING_LASTCALL) && (this.lifecycle != ReplayLifecycle.REPLAYING_CALLBACK))
/*      */     {
/*  556 */       throwReplayExceptionInternal(this.replayErrorCode, this.replayErrorMessage, paramSQLRecoverableException);
/*      */     }
/*      */ 
/*  568 */     OracleConnection localOracleConnection = (OracleConnection)this.replayDataSource.getConnectionNoProxy(((NonTxnReplayableConnection)this.connectionProxy).originalUser, ((NonTxnReplayableConnection)this.connectionProxy).originalPasswd);
/*      */ 
/*  573 */     if (localOracleConnection == null)
/*      */     {
/*  576 */       disableReplayAndThrowException(null, 382, "Replay disabled because Failover_Retries is exceeded", paramSQLRecoverableException);
/*      */     }
/*      */ 
/*  586 */     long l = System.currentTimeMillis();
/*      */ 
/*  589 */     if (this.requestStartTime + this.replayInitiationTimeout * 1000L < l)
/*      */     {
/*  592 */       disableReplayAndThrowException(null, 377, "Replay disabled because ReplayInitiationTimeout is exceeded", paramSQLRecoverableException);
/*      */     }
/*      */ 
/*  603 */     this.connectionProxy.setDelegate(localOracleConnection);
/*      */ 
/*  606 */     localOracleConnection.setChecksumMode(OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_ALL);
/*      */ 
/*  609 */     this.lifecycle = ReplayLifecycle.REPLAYING_CALLBACK;
/*      */ 
/*  618 */     ConnectionInitializationCallback localConnectionInitializationCallback = this.replayDataSource.getConnectionInitializationCallback();
/*      */ 
/*  620 */     if (localConnectionInitializationCallback != null)
/*      */     {
/*      */       try
/*      */       {
/*  625 */         localConnectionInitializationCallback.initialize((Connection)this.connectionProxy);
/*      */       }
/*      */       catch (SQLException localSQLException)
/*      */       {
/*  631 */         disableReplayAndThrowException(null, 379, "Replay disabled because Init callback failed", paramSQLRecoverableException);
/*      */       }
/*      */ 
/*  638 */       EnumSet localEnumSet = localOracleConnection.getTransactionState();
/*      */ 
/*  642 */       if (localEnumSet.contains(OracleConnection.TransactionState.TRANSACTION_STARTED))
/*      */       {
/*  644 */         disableReplayAndThrowException(null, 380, "Replay disabled because of open transaction in Init callback", paramSQLRecoverableException);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  652 */     this.lifecycle = ReplayLifecycle.REPLAYING;
/*      */ 
/*  657 */     if (paramInt == 0) {
/*  658 */       fillInAllChecksums();
/*      */     }
/*  660 */     beginReplay(localOracleConnection, paramSQLRecoverableException);
/*      */ 
/*  665 */     this.replayResult = replayAllBeforeLastCall(paramSQLRecoverableException);
/*      */ 
/*  669 */     endReplay(localOracleConnection, paramSQLRecoverableException);
/*      */ 
/*  674 */     if (this.tail != null) {
/*  675 */       this.replayResult = ((Replayable)this.tail.jdbcProxy).replayOneCall(this.tail, paramSQLRecoverableException);
/*      */     }
/*      */ 
/*  678 */     this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
/*      */ 
/*  684 */     return this.replayResult;
/*      */   }
/*      */ 
/*      */   private synchronized Object replayAllBeforeLastCall(SQLRecoverableException paramSQLRecoverableException)
/*      */     throws SQLException
/*      */   {
/*  691 */     Object localObject = null;
/*      */ 
/*  693 */     for (CallHistoryEntry localCallHistoryEntry = this.head; 
/*  694 */       localCallHistoryEntry != this.tail; 
/*  695 */       localCallHistoryEntry = localCallHistoryEntry.nextEntry)
/*      */     {
/*  697 */       Replayable localReplayable = (Replayable)localCallHistoryEntry.jdbcProxy;
/*      */ 
/*  701 */       localObject = localReplayable.replayOneCall(localCallHistoryEntry, paramSQLRecoverableException);
/*      */ 
/*  704 */       if ((this.lifecycle != ReplayLifecycle.ENABLED_NOT_REPLAYING) && (this.lifecycle != ReplayLifecycle.REPLAYING) && (this.lifecycle != ReplayLifecycle.REPLAYING_LASTCALL) && (this.lifecycle != ReplayLifecycle.REPLAYING_CALLBACK))
/*      */       {
/*  708 */         throwReplayExceptionInternal(this.replayErrorCode, this.replayErrorMessage, paramSQLRecoverableException);
/*      */       }
/*      */     }
/*      */ 
/*  712 */     return localObject;
/*      */   }
/*      */ 
/*      */   boolean isReplayInCurrentMode()
/*      */   {
/*  717 */     return this.replayInCurrentMode;
/*      */   }
/*      */ 
/*      */   void setReplayInCurrentMode()
/*      */   {
/*  722 */     this.replayInCurrentMode = true;
/*      */   }
/*      */ 
/*      */   ReplayLifecycle getReplayLifecycle()
/*      */   {
/*  727 */     return this.lifecycle;
/*      */   }
/*      */ 
/*      */   void setDataSource(OracleDataSource paramOracleDataSource)
/*      */   {
/*  732 */     this.replayDataSource = paramOracleDataSource;
/*      */   }
/*      */ 
/*      */   void setReplayInitiationTimeout(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  738 */     this.replayInitiationTimeout = paramInt;
/*      */   }
/*      */ 
/*      */   void beginRequest()
/*      */     throws SQLException
/*      */   {
/*  748 */     if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED)
/*      */     {
/*  751 */       return;
/*      */     }
/*      */ 
/*  754 */     if (this.lifecycle != ReplayLifecycle.INTERNALLY_DISABLED) {
/*  755 */       throw DatabaseError.createSqlException(391);
/*      */     }
/*      */ 
/*  760 */     this.requestStartTime = System.currentTimeMillis();
/*      */ 
/*  763 */     OracleConnection localOracleConnection = (OracleConnection)this.connectionProxy.getDelegate();
/*      */ 
/*  767 */     EnumSet localEnumSet = localOracleConnection.getTransactionState();
/*      */ 
/*  772 */     if ((localEnumSet.contains(OracleConnection.TransactionState.TRANSACTION_STARTED)) && (!localEnumSet.contains(OracleConnection.TransactionState.TRANSACTION_READONLY)))
/*      */     {
/*  778 */       SQLException localSQLException = DatabaseError.createSqlException(392);
/*      */ 
/*  782 */       throw localSQLException;
/*      */     }
/*      */ 
/*  786 */     this.replayErrorCode = 0;
/*  787 */     this.replayErrorMessage = "";
/*  788 */     this.callCausingReplayError = null;
/*      */ 
/*  791 */     localOracleConnection.setChecksumMode(OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_ALL);
/*      */ 
/*  793 */     this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
/*      */   }
/*      */ 
/*      */   void endRequest()
/*      */     throws SQLException
/*      */   {
/*  806 */     OracleConnection localOracleConnection = (OracleConnection)this.connectionProxy.getDelegate();
/*      */ 
/*  810 */     EnumSet localEnumSet = localOracleConnection.getTransactionState();
/*      */ 
/*  815 */     if ((localEnumSet.contains(OracleConnection.TransactionState.TRANSACTION_STARTED)) && (!localEnumSet.contains(OracleConnection.TransactionState.TRANSACTION_READONLY)))
/*      */     {
/*      */       try
/*      */       {
/*  822 */         localOracleConnection.rollback();
/*      */       }
/*      */       catch (SQLException localSQLException1)
/*      */       {
/*      */       }
/*      */ 
/*  830 */       SQLException localSQLException2 = DatabaseError.createSqlException(393);
/*      */ 
/*  834 */       throw localSQLException2;
/*      */     }
/*      */ 
/*  839 */     if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED)
/*      */     {
/*  843 */       return;
/*      */     }
/*      */ 
/*  848 */     if ((this.lifecycle == ReplayLifecycle.INTERNALLY_DISABLED) || (this.lifecycle == ReplayLifecycle.EXTERNALLY_DISABLED))
/*      */     {
/*  853 */       this.lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
/*      */ 
/*  855 */       return;
/*      */     }
/*      */ 
/*  859 */     disableReplayInternal(null, 381, "Replay disabled after endRequest is called", null);
/*      */   }
/*      */ 
/*      */   void disableReplay()
/*      */     throws SQLException
/*      */   {
/*  874 */     if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED)
/*      */     {
/*  877 */       return;
/*      */     }
/*      */ 
/*  880 */     disableReplayInternal(null, 370, "Replay disabled", null);
/*      */ 
/*  885 */     this.lifecycle = ReplayLifecycle.EXTERNALLY_DISABLED;
/*      */   }
/*      */ 
/*      */   void disableReplayInternal(Method paramMethod, int paramInt, String paramString, SQLRecoverableException paramSQLRecoverableException)
/*      */   {
/*  904 */     ReplayLifecycle localReplayLifecycle = this.lifecycle;
/*      */ 
/*  906 */     OracleConnection localOracleConnection = (OracleConnection)this.connectionProxy.getDelegate();
/*      */ 
/*  911 */     if (this.lifecycle != ReplayLifecycle.ALWAYS_DISABLED) {
/*  912 */       this.lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
/*      */     }
/*      */ 
/*  915 */     purge();
/*      */ 
/*  918 */     this.replayErrorCode = paramInt;
/*  919 */     this.replayErrorMessage = paramString;
/*      */ 
/*  921 */     this.callCausingReplayError = paramMethod;
/*      */     try
/*      */     {
/*  927 */       localOracleConnection.setChecksumMode(OracleConnection.ChecksumMode.NO_CHECKSUM);
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/*      */     }
/*      */   }
/*      */ 
/*      */   void failReplayInternal(Method paramMethod, int paramInt, String paramString, SQLRecoverableException paramSQLRecoverableException)
/*      */   {
/*  942 */     ReplayLifecycle localReplayLifecycle = this.lifecycle;
/*      */ 
/*  946 */     if ((this.lifecycle == ReplayLifecycle.REPLAYING) || (this.lifecycle == ReplayLifecycle.REPLAYING_CALLBACK) || (this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL))
/*      */     {
/*  949 */       this.lifecycle = ReplayLifecycle.INTERNALLY_FAILED;
/*      */     }
/*      */ 
/*  952 */     this.replayErrorCode = paramInt;
/*  953 */     this.replayErrorMessage = paramString;
/*      */ 
/*  955 */     this.callCausingReplayError = paramMethod;
/*      */   }
/*      */ 
/*      */   void throwReplayExceptionInternal(int paramInt, String paramString, SQLRecoverableException paramSQLRecoverableException)
/*      */     throws SQLException
/*      */   {
/*  968 */     if (paramInt == 0) {
/*  969 */       return;
/*      */     }
/*  971 */     String str = this.callCausingReplayError == null ? "" : this.callCausingReplayError.getName();
/*      */ 
/*  975 */     SQLException localSQLException = DatabaseError.createSqlException(this.replayErrorCode, str);
/*      */ 
/*  978 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   void disableReplayAndThrowException(Method paramMethod, int paramInt, String paramString, SQLRecoverableException paramSQLRecoverableException)
/*      */     throws SQLException
/*      */   {
/*  998 */     disableReplayInternal(paramMethod, paramInt, paramString, paramSQLRecoverableException);
/*      */ 
/* 1000 */     throwReplayExceptionInternal(paramInt, paramString, paramSQLRecoverableException);
/*      */   }
/*      */ 
/*      */   void disableReplayAndThrowOriginalError(Method paramMethod, int paramInt, String paramString, SQLRecoverableException paramSQLRecoverableException)
/*      */     throws SQLException
/*      */   {
/* 1010 */     disableReplayInternal(paramMethod, paramInt, paramString, paramSQLRecoverableException);
/*      */ 
/* 1012 */     throwOriginalExceptionWithReplayError(paramInt, paramString, paramSQLRecoverableException);
/*      */   }
/*      */ 
/*      */   void failReplayAndThrowException(Method paramMethod, int paramInt, String paramString, SQLRecoverableException paramSQLRecoverableException)
/*      */     throws SQLException
/*      */   {
/* 1030 */     failReplayInternal(paramMethod, paramInt, paramString, paramSQLRecoverableException);
/*      */ 
/* 1032 */     throwReplayExceptionInternal(paramInt, paramString, paramSQLRecoverableException);
/*      */   }
/*      */ 
/*      */   void throwOriginalExceptionWithReplayError(int paramInt, String paramString, SQLRecoverableException paramSQLRecoverableException)
/*      */     throws SQLRecoverableException
/*      */   {
/* 1069 */     killConnectionBeforeReplayDisabledException();
/*      */ 
/* 1071 */     String str = this.callCausingReplayError == null ? "" : this.callCausingReplayError.getName();
/*      */ 
/* 1076 */     SQLException localSQLException = DatabaseError.createSqlException(this.replayErrorCode, str);
/*      */ 
/* 1081 */     paramSQLRecoverableException.setNextException(localSQLException);
/*      */ 
/* 1084 */     throw paramSQLRecoverableException;
/*      */   }
/*      */ 
/*      */   void killConnectionBeforeReplayDisabledException()
/*      */   {
/* 1089 */     final OracleConnection localOracleConnection = (OracleConnection)this.connectionProxy.getDelegate();
/*      */     try
/*      */     {
/* 1094 */       localOracleConnection.abort();
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/* 1105 */       executor.submit(new Runnable()
/*      */       {
/*      */         public void run()
/*      */         {
/* 1110 */           FailoverManagerImpl.this.closePhysicalConnection(localOracleConnection);
/*      */         }
/*      */       });
/*      */     }
/*      */     catch (Exception localException)
/*      */     {
/*      */     }
/*      */   }
/*      */ 
/*      */   void enableTxnMonitoring(OracleConnection paramOracleConnection)
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/* 1130 */       Statement localStatement = paramOracleConnection.createStatement();
/*      */ 
/* 1133 */       localStatement.execute("BEGIN DBMS_APP_CONT_PRVT.MONITOR_TXN; END;");
/*      */ 
/* 1136 */       localStatement.close();
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/* 1141 */       disableReplayInternal(null, 374, "Replay disabled because transaction monitoring failed to be enabled", null);
/*      */ 
/* 1148 */       this.lifecycle = ReplayLifecycle.ALWAYS_DISABLED;
/*      */ 
/* 1151 */       throw DatabaseError.createSqlException(395);
/*      */     }
/*      */   }
/*      */ 
/*      */   void beginReplay(OracleConnection paramOracleConnection, SQLRecoverableException paramSQLRecoverableException)
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/* 1164 */       Statement localStatement = paramOracleConnection.createStatement();
/*      */ 
/* 1167 */       localStatement.execute("BEGIN DBMS_APP_CONT_PRVT.BEGIN_REPLAY; END;");
/*      */ 
/* 1170 */       localStatement.close();
/*      */ 
/* 1172 */       this.lifecycle = ReplayLifecycle.REPLAYING;
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/* 1177 */       disableReplayAndThrowException(null, 375, "Replay disabled because server begin_replay call failed", paramSQLRecoverableException);
/*      */     }
/*      */   }
/*      */ 
/*      */   void endReplay(OracleConnection paramOracleConnection, SQLRecoverableException paramSQLRecoverableException)
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/* 1193 */       Statement localStatement = paramOracleConnection.createStatement();
/*      */ 
/* 1196 */       localStatement.execute("BEGIN DBMS_APP_CONT_PRVT.END_REPLAY; END;");
/*      */ 
/* 1199 */       localStatement.close();
/*      */ 
/* 1201 */       this.lifecycle = ReplayLifecycle.REPLAYING_LASTCALL;
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/* 1206 */       disableReplayAndThrowException(null, 376, "Replay disabled because server end_replay call failed", paramSQLRecoverableException);
/*      */     }
/*      */   }
/*      */ 
/*      */   Replayable getConnectionProxy()
/*      */   {
/* 1216 */     return this.connectionProxy;
/*      */   }
/*      */ 
/*      */   private boolean isReplayFailure(SQLException paramSQLException)
/*      */   {
/* 1221 */     boolean bool = false;
/*      */ 
/* 1223 */     if ((paramSQLException instanceof SQLException))
/*      */     {
/* 1225 */       int i = paramSQLException.getErrorCode();
/* 1226 */       if ((i >= 370) && (i < 400))
/*      */       {
/* 1228 */         bool = true;
/*      */       }
/*      */     }
/* 1231 */     return bool;
/*      */   }
/*      */ 
/*      */   private void closePhysicalConnection(Connection paramConnection)
/*      */   {
/*      */     try
/*      */     {
/* 1238 */       paramConnection.close();
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/*      */     }
/*      */   }
/*      */ 
/*      */   static enum ReplayLifecycle
/*      */   {
/*  122 */     ENABLED_NOT_REPLAYING, 
/*  123 */     INTERNALLY_FAILED, 
/*  124 */     INTERNALLY_DISABLED, 
/*  125 */     ALWAYS_DISABLED, 
/*  126 */     EXTERNALLY_DISABLED, 
/*  127 */     REPLAYING_CALLBACK, 
/*  128 */     REPLAYING, 
/*  129 */     REPLAYING_LASTCALL;
/*      */   }
/*      */ 
/*      */   static class CallHistoryEntry
/*      */   {
/*      */     Object jdbcProxy;
/*      */     Method method;
/*      */     Object[] args;
/*      */     Object result;
/*      */     String callStatus;
/*      */     long scn;
/*      */     long checksum;
/*      */     SQLException callException;
/*   62 */     CallHistoryEntry nextEntry = null;
/*   63 */     CallHistoryEntry prevEntry = null;
/*      */ 
/*   66 */     CallHistoryEntry nextEntrySameProxy = null;
/*   67 */     CallHistoryEntry prevEntrySameProxy = null;
/*      */ 
/*      */     CallHistoryEntry(Object paramObject, Method paramMethod, Object[] paramArrayOfObject, String paramString)
/*      */     {
/*   72 */       this.jdbcProxy = paramObject;
/*   73 */       this.method = paramMethod;
/*   74 */       this.args = paramArrayOfObject;
/*   75 */       this.result = null;
/*   76 */       this.callStatus = paramString;
/*      */     }
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.replay.driver.FailoverManagerImpl
 * JD-Core Version:    0.6.2
 */