/*      */ package oracle.jdbc.replay;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.io.ObjectInputStream;
/*      */ import java.io.ObjectOutputStream;
/*      */ import java.io.PrintWriter;
/*      */ import java.io.Serializable;
/*      */ import java.security.AccessController;
/*      */ import java.security.PrivilegedAction;
/*      */ import java.sql.Connection;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.SQLFeatureNotSupportedException;
/*      */ import java.util.Hashtable;
/*      */ import java.util.Properties;
/*      */ import java.util.concurrent.atomic.AtomicBoolean;
/*      */ import java.util.logging.Logger;
/*      */ import javax.naming.Context;
/*      */ import javax.naming.Name;
/*      */ import javax.naming.NamingException;
/*      */ import javax.naming.Reference;
/*      */ import javax.naming.Referenceable;
/*      */ import javax.naming.StringRefAddr;
/*      */ import javax.naming.spi.ObjectFactory;
/*      */ import oracle.jdbc.internal.OracleConnection;
/*      */ import oracle.jdbc.internal.OracleConnection.ChecksumMode;
/*      */ import oracle.jdbc.proxy.ProxyFactory;
/*      */ import oracle.jdbc.replay.driver.NonTxnReplayableArray;
/*      */ import oracle.jdbc.replay.driver.NonTxnReplayableBase;
/*      */ import oracle.jdbc.replay.driver.NonTxnReplayableBfile;
/*      */ import oracle.jdbc.replay.driver.NonTxnReplayableBlob;
/*      */ import oracle.jdbc.replay.driver.NonTxnReplayableClob;
/*      */ import oracle.jdbc.replay.driver.NonTxnReplayableConnection;
/*      */ import oracle.jdbc.replay.driver.NonTxnReplayableNClob;
/*      */ import oracle.jdbc.replay.driver.NonTxnReplayableOpaque;
/*      */ import oracle.jdbc.replay.driver.NonTxnReplayableOthers;
/*      */ import oracle.jdbc.replay.driver.NonTxnReplayableRef;
/*      */ import oracle.jdbc.replay.driver.NonTxnReplayableResultSet;
/*      */ import oracle.jdbc.replay.driver.NonTxnReplayableStatement;
/*      */ import oracle.jdbc.replay.driver.NonTxnReplayableStruct;
/*      */ import oracle.jdbc.replay.driver.TxnReplayableArray;
/*      */ import oracle.jdbc.replay.driver.TxnReplayableBase;
/*      */ import oracle.jdbc.replay.driver.TxnReplayableBfile;
/*      */ import oracle.jdbc.replay.driver.TxnReplayableBlob;
/*      */ import oracle.jdbc.replay.driver.TxnReplayableClob;
/*      */ import oracle.jdbc.replay.driver.TxnReplayableConnection;
/*      */ import oracle.jdbc.replay.driver.TxnReplayableNClob;
/*      */ import oracle.jdbc.replay.driver.TxnReplayableOpaque;
/*      */ import oracle.jdbc.replay.driver.TxnReplayableOthers;
/*      */ import oracle.jdbc.replay.driver.TxnReplayableRef;
/*      */ import oracle.jdbc.replay.driver.TxnReplayableResultSet;
/*      */ import oracle.jdbc.replay.driver.TxnReplayableSqlxml;
/*      */ import oracle.jdbc.replay.driver.TxnReplayableStatement;
/*      */ import oracle.jdbc.replay.driver.TxnReplayableStruct;
/*      */ import oracle.jdbc.replay.internal.ConnectionInitializationCallback;
/*      */ import oracle.jdbc.replay.internal.ReplayableConnection;
/*      */ 
/*      */ public class OracleDataSourceImpl
/*      */   implements oracle.jdbc.replay.internal.OracleDataSource, Serializable, Referenceable, ObjectFactory
/*      */ {
/*      */   private static final long serialVersionUID = 5634196469087099680L;
/*   84 */   private static ProxyFactory PROXY_FACTORY = null;
/*      */ 
/*   87 */   private static ProxyFactory NON_TXN_PROXY_FACTORY = null;
/*      */ 
/*   89 */   private static final Object proxyFactoryLock = new Object();
/*      */ 
/*   92 */   private oracle.jdbc.pool.OracleDataSource ods = null;
/*      */ 
/*   95 */   private oracle.jdbc.pool.OracleDataSource odsReconnectOnly = null;
/*      */ 
/*   97 */   private String user = null;
/*   98 */   private String password = null;
/*   99 */   private String url = null;
/*  100 */   private String serverName = null;
/*  101 */   private int portNumber = 0;
/*  102 */   private String databaseName = null;
/*  103 */   private String dataSourceName = null;
/*  104 */   private String description = null;
/*  105 */   private String networkProtocol = null;
/*  106 */   private String roleName = null;
/*      */ 
/*  111 */   private Properties connectionProperties = null;
/*  112 */   private Properties reconnectionProperties = null;
/*      */ 
/*  115 */   private int maxStatements = 0;
/*  116 */   private boolean implicitCachingEnabled = false;
/*  117 */   private boolean explicitCachingEnabled = false;
/*      */ 
/*  119 */   private ConnectionInitializationCallback connectionInitializationCallback = null;
/*      */ 
/*  121 */   private AtomicBoolean isFirstConnection = new AtomicBoolean(true);
/*      */   private static final String RECONNECT_DELAY_PROPERTY = "AUTH_FAILOVER_DELAY";
/*      */   private static final String RECONNECT_RETRIES_PROPERTY = "AUTH_FAILOVER_RETRIES";
/*  130 */   private int reconnectDelay = 10;
/*      */ 
/*  135 */   private int reconnectRetries = 30;
/*      */   private static final String FAILOVER_TYPE_PROPERTY = "AUTH_FAILOVER_TYPE";
/*      */   private static final int FAILOVER_TYPE_TRANSACTION = 8;
/*      */   private static final int SESSION_STATE_CONSISTENCY_STATIC = 16;
/*  154 */   private boolean isTransactionReplayEnabled = false;
/*      */   private static final String SESSION_STATE_PROPERTY = "AUTH_SESSION_STATE_CONSISTENCY";
/*  160 */   private boolean isReplayInDynamicMode = true;
/*      */   private static final String INITIATION_TIMEOUT_PROPERTY = "AUTH_FAILOVER_REPLAYTIMEOUT";
/*  168 */   private int replayInitiationTimeout = 300;
/*      */   private static final String CHECKSUM_PROPERTY = "oracle.jdbc.calculateChecksum";
/*  177 */   private final String clientChecksum12x = OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_BINDS.toString();
/*      */ 
/*  179 */   private final String clientChecksum11203x = OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_ALL.toString();
/*      */   private static final String IGNORE_AC_CONTEXT_PROPERTY = "oracle.jdbc.ignoreReplayContextFromAuthentication";
/*      */   private static final String AC_11203_COMPATIBLE_SYSTEM_PROPERTY = "oracle.jdbc.AC11203Compatible";
/* 1236 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */ 
/*      */   public OracleDataSourceImpl()
/*      */   {
/*      */     try
/*      */     {
/*  246 */       this.ods = new oracle.jdbc.pool.OracleDataSource();
/*  247 */       this.odsReconnectOnly = new oracle.jdbc.pool.OracleDataSource();
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/*      */     }
/*      */   }
/*      */ 
/*      */   public Connection getConnection() throws SQLException {
/*  255 */     return getConnection(this.user, this.password);
/*      */   }
/*      */ 
/*      */   public Connection getConnection(String paramString1, String paramString2)
/*      */     throws SQLException
/*      */   {
/*  272 */     return getConnectionInternal(paramString1, paramString2, true);
/*      */   }
/*      */ 
/*      */   public Connection getConnectionNoProxy(String paramString1, String paramString2)
/*      */     throws SQLException
/*      */   {
/*  280 */     int i = 1;
/*  281 */     Connection localConnection = null;
/*  282 */     Object localObject1 = null;
/*      */     do
/*      */     {
/*      */       try
/*      */       {
/*  290 */         localObject1 = null;
/*      */ 
/*  292 */         localConnection = getConnectionInternal(paramString1, paramString2, false);
/*      */       }
/*      */       catch (Exception localException)
/*      */       {
/*  296 */         localConnection = null;
/*  297 */         localObject1 = localException;
/*      */       }
/*      */       finally
/*      */       {
/*  302 */         if ((localConnection != null) && (localObject1 == null)) {
/*  303 */           return localConnection;
/*      */         }
/*  305 */         i++;
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/*  311 */         if (this.reconnectDelay > 0)
/*      */         {
/*  314 */           Thread.sleep(this.reconnectDelay * 1000);
/*      */         }
/*      */       }
/*      */       catch (InterruptedException localInterruptedException)
/*      */       {
/*      */       }
/*      */     }
/*      */ 
/*  322 */     while (i <= this.reconnectRetries);
/*      */ 
/*  327 */     return null;
/*      */   }
/*      */ 
/*      */   private Connection getConnectionInternal(String paramString1, String paramString2, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  336 */     Connection localConnection1 = null;
/*      */ 
/*  338 */     if (this.isFirstConnection.get())
/*      */     {
/*  342 */       setConnectionProperty("oracle.jdbc.calculateChecksum", this.clientChecksum12x);
/*      */ 
/*  354 */       this.reconnectionProperties.setProperty("oracle.jdbc.ignoreReplayContextFromAuthentication", "true");
/*  355 */       this.odsReconnectOnly.setConnectionProperties(this.reconnectionProperties);
/*      */     }
/*      */ 
/*  358 */     if (paramBoolean) {
/*  359 */       localConnection1 = this.ods.getConnection(paramString1, paramString2);
/*      */     }
/*      */     else
/*      */     {
/*  363 */       localConnection1 = this.odsReconnectOnly.getConnection(paramString1, paramString2);
/*      */     }
/*  365 */     int i = 0;
/*      */ 
/*  367 */     OracleConnection localOracleConnection = (OracleConnection)localConnection1;
/*  368 */     Properties localProperties = localOracleConnection.getServerSessionInfo();
/*      */ 
/*  370 */     String str1 = localProperties.getProperty("AUTH_FAILOVER_DELAY");
/*      */ 
/*  372 */     if ((str1 != null) && (!"".equals(str1)))
/*      */     {
/*  374 */       int j = Integer.parseInt(str1);
/*  375 */       if (j > 0) {
/*  376 */         this.reconnectDelay = j;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  383 */     String str2 = localProperties.getProperty("AUTH_FAILOVER_RETRIES");
/*      */ 
/*  385 */     if ((str2 != null) && (!"".equals(str2)))
/*      */     {
/*  387 */       int k = Integer.parseInt(str2);
/*  388 */       if (k > 0) {
/*  389 */         this.reconnectRetries = k;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  396 */     String str3 = localProperties.getProperty("AUTH_FAILOVER_TYPE");
/*      */ 
/*  398 */     if ((str3 != null) && (!"".equals(str3)))
/*      */     {
/*      */       int m;
/*      */       try
/*      */       {
/*  403 */         m = Integer.parseInt(str3);
/*      */       }
/*      */       catch (NumberFormatException localNumberFormatException)
/*      */       {
/*  407 */         m = 0;
/*      */       }
/*      */ 
/*  410 */       this.isTransactionReplayEnabled = ((m & 0x8) == 8);
/*      */ 
/*  412 */       this.isReplayInDynamicMode = ((m & 0x10) == 0);
/*      */     }
/*      */ 
/*  416 */     String str4 = localProperties.getProperty("AUTH_FAILOVER_REPLAYTIMEOUT");
/*      */ 
/*  418 */     if ((str4 != null) && (!"".equals(str4))) {
/*  419 */       this.replayInitiationTimeout = Integer.parseInt(str4);
/*      */     }
/*      */ 
/*  428 */     i = localOracleConnection.getVersionNumber();
/*      */ 
/*  430 */     if (i < 11203)
/*      */     {
/*  437 */       paramBoolean = false;
/*      */     }
/*  441 */     else if ((i >= 12100) && (!this.isTransactionReplayEnabled))
/*      */     {
/*  449 */       paramBoolean = false;
/*      */     }
/*  452 */     else if ((i >= 11203) && (i < 12100))
/*      */     {
/*  454 */       boolean bool = "true".equalsIgnoreCase(getSystemProperty("oracle.jdbc.AC11203Compatible", "false"));
/*      */ 
/*  457 */       if (bool)
/*      */       {
/*  462 */         localConnection1.close();
/*      */ 
/*  466 */         setConnectionProperty("oracle.jdbc.calculateChecksum", this.clientChecksum11203x);
/*      */ 
/*  470 */         localConnection1 = this.ods.getConnection(paramString1, paramString2);
/*      */ 
/*  472 */         synchronized (proxyFactoryLock)
/*      */         {
/*  474 */           PROXY_FACTORY = NON_TXN_PROXY_FACTORY;
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/*  484 */         paramBoolean = false;
/*      */       }
/*      */     }
/*      */ 
/*  488 */     this.isFirstConnection.set(false);
/*      */ 
/*  492 */     if (paramBoolean)
/*      */     {
/*  494 */       Connection localConnection2 = (Connection)PROXY_FACTORY.proxyFor(localConnection1);
/*  495 */       ??? = (ReplayableConnection)localConnection2;
/*      */ 
/*  499 */       ((ReplayableConnection)???).initialize(this, paramString1, paramString2);
/*      */ 
/*  503 */       if (i >= 12100)
/*      */       {
/*  505 */         ((ReplayableConnection)???).setReplayInitiationTimeout(this.replayInitiationTimeout);
/*  506 */         ((ReplayableConnection)???).setSessionStateConsistency(!this.isReplayInDynamicMode);
/*      */       }
/*      */ 
/*  513 */       ((OracleConnection)localConnection1).getReplayContext();
/*      */ 
/*  515 */       return localConnection2;
/*      */     }
/*      */ 
/*  519 */     return localConnection1;
/*      */   }
/*      */ 
/*      */   public PrintWriter getLogWriter() throws SQLException
/*      */   {
/*  524 */     return null;
/*      */   }
/*      */ 
/*      */   public void setLogWriter(PrintWriter paramPrintWriter) throws SQLException
/*      */   {
/*      */   }
/*      */ 
/*      */   public void setLoginTimeout(int paramInt) throws SQLException
/*      */   {
/*      */   }
/*      */ 
/*      */   public int getLoginTimeout() throws SQLException
/*      */   {
/*  537 */     return 0;
/*      */   }
/*      */ 
/*      */   public String getUser()
/*      */   {
/*  542 */     return this.user;
/*      */   }
/*      */ 
/*      */   public void setUser(String paramString)
/*      */     throws SQLException
/*      */   {
/*  549 */     this.user = paramString;
/*      */ 
/*  551 */     this.ods.setUser(paramString);
/*  552 */     this.odsReconnectOnly.setUser(paramString);
/*      */   }
/*      */ 
/*      */   public String getPassword()
/*      */   {
/*  557 */     return this.password;
/*      */   }
/*      */ 
/*      */   public void setPassword(String paramString) throws SQLException
/*      */   {
/*  562 */     this.password = paramString;
/*      */ 
/*  564 */     this.ods.setPassword(paramString);
/*  565 */     this.odsReconnectOnly.setPassword(paramString);
/*      */   }
/*      */ 
/*      */   public String getURL()
/*      */   {
/*  570 */     return this.url;
/*      */   }
/*      */ 
/*      */   public void setURL(String paramString)
/*      */     throws SQLException
/*      */   {
/*  577 */     this.url = paramString;
/*      */ 
/*  579 */     this.ods.setURL(paramString);
/*  580 */     this.odsReconnectOnly.setURL(paramString);
/*      */   }
/*      */ 
/*      */   public void setServerName(String paramString)
/*      */     throws SQLException
/*      */   {
/*  593 */     this.serverName = paramString;
/*      */ 
/*  595 */     this.ods.setServerName(paramString);
/*  596 */     this.odsReconnectOnly.setServerName(paramString);
/*      */   }
/*      */ 
/*      */   public String getServerName()
/*      */   {
/*  606 */     return this.serverName;
/*      */   }
/*      */ 
/*      */   public void setPortNumber(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  619 */     this.portNumber = paramInt;
/*      */ 
/*  621 */     this.ods.setPortNumber(paramInt);
/*  622 */     this.odsReconnectOnly.setPortNumber(paramInt);
/*      */   }
/*      */ 
/*      */   public int getPortNumber()
/*      */   {
/*  632 */     return this.portNumber;
/*      */   }
/*      */ 
/*      */   public void setDatabaseName(String paramString)
/*      */     throws SQLException
/*      */   {
/*  645 */     this.databaseName = paramString;
/*      */ 
/*  647 */     this.ods.setDatabaseName(paramString);
/*  648 */     this.odsReconnectOnly.setDatabaseName(paramString);
/*      */   }
/*      */ 
/*      */   public String getDatabaseName()
/*      */   {
/*  658 */     return this.databaseName;
/*      */   }
/*      */ 
/*      */   public void setDataSourceName(String paramString)
/*      */     throws SQLException
/*      */   {
/*  670 */     this.dataSourceName = paramString;
/*      */ 
/*  672 */     this.ods.setDataSourceName(paramString);
/*  673 */     this.odsReconnectOnly.setDataSourceName(paramString);
/*      */   }
/*      */ 
/*      */   public String getDataSourceName()
/*      */   {
/*  683 */     return this.dataSourceName;
/*      */   }
/*      */ 
/*      */   public void setDescription(String paramString)
/*      */     throws SQLException
/*      */   {
/*  695 */     this.description = paramString;
/*      */ 
/*  697 */     this.ods.setDescription(paramString);
/*  698 */     this.odsReconnectOnly.setDescription(paramString);
/*      */   }
/*      */ 
/*      */   public String getDescription()
/*      */   {
/*  708 */     return this.description;
/*      */   }
/*      */ 
/*      */   public void setNetworkProtocol(String paramString)
/*      */     throws SQLException
/*      */   {
/*  720 */     this.networkProtocol = paramString;
/*      */ 
/*  722 */     this.ods.setNetworkProtocol(paramString);
/*  723 */     this.odsReconnectOnly.setNetworkProtocol(paramString);
/*      */   }
/*      */ 
/*      */   public String getNetworkProtocol()
/*      */   {
/*  733 */     return this.networkProtocol;
/*      */   }
/*      */ 
/*      */   public void setRoleName(String paramString)
/*      */     throws SQLException
/*      */   {
/*  746 */     this.roleName = paramString;
/*      */   }
/*      */ 
/*      */   public String getRoleName()
/*      */   {
/*  759 */     return this.roleName;
/*      */   }
/*      */ 
/*      */   public void registerConnectionInitializationCallback(ConnectionInitializationCallback paramConnectionInitializationCallback)
/*      */     throws SQLException
/*      */   {
/*  775 */     if (paramConnectionInitializationCallback == null) {
/*  776 */       throw new NullPointerException("callback has to be non-null");
/*      */     }
/*  778 */     this.connectionInitializationCallback = paramConnectionInitializationCallback;
/*      */   }
/*      */ 
/*      */   public void unregisterConnectionInitializationCallback(ConnectionInitializationCallback paramConnectionInitializationCallback)
/*      */     throws SQLException
/*      */   {
/*  793 */     this.connectionInitializationCallback = null;
/*      */   }
/*      */ 
/*      */   public ConnectionInitializationCallback getConnectionInitializationCallback()
/*      */   {
/*  800 */     return this.connectionInitializationCallback;
/*      */   }
/*      */ 
/*      */   public Properties getConnectionProperties()
/*      */   {
/*  810 */     return this.connectionProperties;
/*      */   }
/*      */ 
/*      */   public String getConnectionProperty(String paramString)
/*      */   {
/*  823 */     return this.connectionProperties.getProperty(paramString);
/*      */   }
/*      */ 
/*      */   public void setConnectionProperty(String paramString1, String paramString2)
/*      */     throws SQLException
/*      */   {
/*  843 */     if ((paramString2 == null) || (paramString2.equals(""))) {
/*  844 */       throw new IllegalArgumentException();
/*      */     }
/*  846 */     if (this.connectionProperties == null) {
/*  847 */       this.connectionProperties = new Properties();
/*      */     }
/*  849 */     if (this.reconnectionProperties == null) {
/*  850 */       this.reconnectionProperties = new Properties();
/*      */     }
/*  852 */     this.connectionProperties.setProperty(paramString1, paramString2);
/*  853 */     this.reconnectionProperties.setProperty(paramString1, paramString2);
/*      */ 
/*  856 */     this.ods.setConnectionProperties(this.connectionProperties);
/*  857 */     this.odsReconnectOnly.setConnectionProperties(this.reconnectionProperties);
/*      */   }
/*      */ 
/*      */   public void setConnectionProperties(Properties paramProperties)
/*      */     throws SQLException
/*      */   {
/*  875 */     if (paramProperties == null) {
/*  876 */       this.connectionProperties = null;
/*  877 */       this.reconnectionProperties = null;
/*      */     }
/*      */     else {
/*  880 */       this.connectionProperties = ((Properties)paramProperties.clone());
/*  881 */       this.reconnectionProperties = ((Properties)paramProperties.clone());
/*      */     }
/*      */ 
/*  890 */     setConnectionProperty("oracle.jdbc.calculateChecksum", this.clientChecksum12x);
/*      */ 
/*  894 */     this.reconnectionProperties.setProperty("oracle.jdbc.ignoreReplayContextFromAuthentication", "true");
/*  895 */     this.odsReconnectOnly.setConnectionProperties(this.reconnectionProperties);
/*      */   }
/*      */ 
/*      */   public void setMaxStatements(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  914 */     this.maxStatements = paramInt;
/*      */ 
/*  916 */     this.ods.setMaxStatements(paramInt);
/*  917 */     this.odsReconnectOnly.setMaxStatements(paramInt);
/*      */   }
/*      */ 
/*      */   public int getMaxStatements()
/*      */     throws SQLException
/*      */   {
/*  925 */     return this.maxStatements;
/*      */   }
/*      */ 
/*      */   public void setImplicitCachingEnabled(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  939 */     this.implicitCachingEnabled = paramBoolean;
/*      */ 
/*  941 */     this.ods.setImplicitCachingEnabled(paramBoolean);
/*  942 */     this.odsReconnectOnly.setImplicitCachingEnabled(paramBoolean);
/*      */   }
/*      */ 
/*      */   public boolean getImplicitCachingEnabled()
/*      */     throws SQLException
/*      */   {
/*  952 */     return this.implicitCachingEnabled;
/*      */   }
/*      */ 
/*      */   public void setExplicitCachingEnabled(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  967 */     this.explicitCachingEnabled = paramBoolean;
/*      */ 
/*  969 */     this.ods.setExplicitCachingEnabled(paramBoolean);
/*  970 */     this.odsReconnectOnly.setExplicitCachingEnabled(paramBoolean);
/*      */   }
/*      */ 
/*      */   public boolean getExplicitCachingEnabled()
/*      */     throws SQLException
/*      */   {
/*  978 */     return this.explicitCachingEnabled;
/*      */   }
/*      */ 
/*      */   public Reference getReference()
/*      */     throws NamingException
/*      */   {
/*  986 */     Reference localReference = new Reference(getClass().getName(), "oracle.jdbc.replay.OracleDataSourceImpl", null);
/*      */ 
/*  989 */     if (this.user != null) {
/*  990 */       localReference.add(new StringRefAddr("user", this.user));
/*      */     }
/*  992 */     if (this.password != null) {
/*  993 */       localReference.add(new StringRefAddr("password", this.password));
/*      */     }
/*  995 */     if (this.url != null) {
/*  996 */       localReference.add(new StringRefAddr("url", this.url));
/*      */     }
/*  998 */     if (this.serverName != null) {
/*  999 */       localReference.add(new StringRefAddr("serverName", this.serverName));
/*      */     }
/* 1001 */     localReference.add(new StringRefAddr("portNumber", Integer.toString(this.portNumber)));
/*      */ 
/* 1004 */     if (this.databaseName != null) {
/* 1005 */       localReference.add(new StringRefAddr("databaseName", this.databaseName));
/*      */     }
/* 1007 */     if (this.dataSourceName != null) {
/* 1008 */       localReference.add(new StringRefAddr("dataSourceName", this.dataSourceName.toString()));
/*      */     }
/*      */ 
/* 1011 */     if (this.description != null) {
/* 1012 */       localReference.add(new StringRefAddr("description", this.description.toString()));
/*      */     }
/*      */ 
/* 1015 */     if (this.networkProtocol != null) {
/* 1016 */       localReference.add(new StringRefAddr("networkProtocol", this.networkProtocol.toString()));
/*      */     }
/*      */ 
/* 1020 */     if (this.roleName != null) {
/* 1021 */       localReference.add(new StringRefAddr("roleName", this.roleName));
/*      */     }
/*      */ 
/* 1025 */     if (this.connectionProperties.size() > 0) {
/* 1026 */       localReference.add(new StringRefAddr("connectionProperties", this.connectionProperties.toString()));
/*      */     }
/*      */ 
/* 1030 */     if (this.maxStatements != 0) {
/* 1031 */       localReference.add(new StringRefAddr("maxStatements", Integer.toString(this.maxStatements)));
/*      */     }
/*      */ 
/* 1034 */     if (this.implicitCachingEnabled) {
/* 1035 */       localReference.add(new StringRefAddr("implicitCachingEnabled", "true"));
/*      */     }
/* 1037 */     if (this.explicitCachingEnabled) {
/* 1038 */       localReference.add(new StringRefAddr("explicitCachingEnabled", "true"));
/*      */     }
/* 1040 */     return localReference;
/*      */   }
/*      */ 
/*      */   private void writeObject(ObjectOutputStream paramObjectOutputStream)
/*      */     throws IOException
/*      */   {
/* 1051 */     paramObjectOutputStream.defaultWriteObject();
/*      */   }
/*      */ 
/*      */   private void readObject(ObjectInputStream paramObjectInputStream)
/*      */     throws IOException, ClassNotFoundException, SQLException
/*      */   {
/* 1062 */     paramObjectInputStream.defaultReadObject();
/*      */   }
/*      */ 
/*      */   public Object getObjectInstance(Object paramObject, Name paramName, Context paramContext, Hashtable<?, ?> paramHashtable)
/*      */     throws Exception
/*      */   {
/* 1071 */     Reference localReference = (Reference)paramObject;
/* 1072 */     String str1 = localReference.getClassName();
/* 1073 */     OracleDataSourceImpl localOracleDataSourceImpl = null;
/*      */ 
/* 1075 */     if ((str1.equals("oracle.jdbc.replay.OracleDataSource")) || (str1.equals("oracle.jdbc.replay.OracleDataSourceImpl")))
/*      */     {
/* 1078 */       localOracleDataSourceImpl = new OracleDataSourceImpl();
/*      */     }
/*      */ 
/* 1081 */     if (localOracleDataSourceImpl == null) {
/* 1082 */       return null;
/*      */     }
/*      */ 
/* 1085 */     StringRefAddr localStringRefAddr = (StringRefAddr)localReference.get("user");
/* 1086 */     if (localStringRefAddr != null) {
/* 1087 */       localOracleDataSourceImpl.setUser((String)localStringRefAddr.getContent());
/*      */     }
/* 1089 */     localStringRefAddr = (StringRefAddr)localReference.get("password");
/* 1090 */     if (localStringRefAddr != null) {
/* 1091 */       localOracleDataSourceImpl.setPassword((String)localStringRefAddr.getContent());
/*      */     }
/* 1093 */     localStringRefAddr = (StringRefAddr)localReference.get("url");
/* 1094 */     if (localStringRefAddr != null) {
/* 1095 */       localOracleDataSourceImpl.setURL((String)localStringRefAddr.getContent());
/*      */     }
/* 1097 */     localStringRefAddr = (StringRefAddr)localReference.get("serverName");
/* 1098 */     if (localStringRefAddr != null) {
/* 1099 */       localOracleDataSourceImpl.setServerName((String)localStringRefAddr.getContent());
/*      */     }
/* 1101 */     localStringRefAddr = (StringRefAddr)localReference.get("portNumber");
/* 1102 */     if (localStringRefAddr != null) {
/* 1103 */       localOracleDataSourceImpl.setPortNumber(Integer.parseInt((String)localStringRefAddr.getContent()));
/*      */     }
/* 1105 */     localStringRefAddr = (StringRefAddr)localReference.get("databaseName");
/* 1106 */     if (localStringRefAddr != null) {
/* 1107 */       localOracleDataSourceImpl.setDatabaseName((String)localStringRefAddr.getContent());
/*      */     }
/* 1109 */     localStringRefAddr = (StringRefAddr)localReference.get("dataSourceName");
/* 1110 */     if (localStringRefAddr != null) {
/* 1111 */       localOracleDataSourceImpl.setDataSourceName((String)localStringRefAddr.getContent());
/*      */     }
/* 1113 */     localStringRefAddr = (StringRefAddr)localReference.get("description");
/* 1114 */     if (localStringRefAddr != null) {
/* 1115 */       localOracleDataSourceImpl.setDescription((String)localStringRefAddr.getContent());
/*      */     }
/* 1117 */     localStringRefAddr = (StringRefAddr)localReference.get("networkProtocol");
/* 1118 */     if (localStringRefAddr != null) {
/* 1119 */       localOracleDataSourceImpl.setNetworkProtocol((String)localStringRefAddr.getContent());
/*      */     }
/* 1121 */     localStringRefAddr = (StringRefAddr)localReference.get("roleName");
/* 1122 */     if (localStringRefAddr != null) {
/* 1123 */       localOracleDataSourceImpl.setRoleName((String)localStringRefAddr.getContent());
/*      */     }
/* 1125 */     localStringRefAddr = (StringRefAddr)localReference.get("connectionProperties");
/*      */     String str2;
/* 1126 */     if (localStringRefAddr != null)
/*      */     {
/* 1128 */       str2 = (String)localStringRefAddr.getContent();
/* 1129 */       Properties localProperties = new Properties();
/*      */ 
/* 1133 */       String[] arrayOfString1 = str2.substring(1, str2.length() - 1).split(", ");
/*      */ 
/* 1135 */       for (String str3 : arrayOfString1)
/*      */       {
/* 1138 */         String[] arrayOfString3 = str3.split("=");
/* 1139 */         localProperties.setProperty(arrayOfString3[0], arrayOfString3[1]);
/*      */       }
/* 1141 */       localOracleDataSourceImpl.setConnectionProperties(localProperties);
/*      */     }
/*      */ 
/* 1144 */     localStringRefAddr = (StringRefAddr)localReference.get("maxStatements");
/* 1145 */     if (localStringRefAddr != null) {
/* 1146 */       localOracleDataSourceImpl.setMaxStatements(Integer.parseInt((String)localStringRefAddr.getContent()));
/*      */     }
/* 1148 */     localStringRefAddr = (StringRefAddr)localReference.get("implicitCachingEnabled");
/* 1149 */     if (localStringRefAddr != null)
/*      */     {
/* 1151 */       str2 = (String)localStringRefAddr.getContent();
/* 1152 */       if (str2.equalsIgnoreCase("true"))
/* 1153 */         localOracleDataSourceImpl.setImplicitCachingEnabled(true);
/*      */       else {
/* 1155 */         localOracleDataSourceImpl.setImplicitCachingEnabled(false);
/*      */       }
/*      */     }
/* 1158 */     localStringRefAddr = (StringRefAddr)localReference.get("explicitCachingEnabled");
/* 1159 */     if (localStringRefAddr != null)
/*      */     {
/* 1161 */       str2 = (String)localStringRefAddr.getContent();
/* 1162 */       if (str2.equalsIgnoreCase("true"))
/* 1163 */         localOracleDataSourceImpl.setExplicitCachingEnabled(true);
/*      */       else {
/* 1165 */         localOracleDataSourceImpl.setExplicitCachingEnabled(false);
/*      */       }
/*      */     }
/* 1168 */     return localOracleDataSourceImpl;
/*      */   }
/*      */ 
/*      */   public boolean isWrapperFor(Class<?> paramClass)
/*      */     throws SQLException
/*      */   {
/* 1185 */     return false;
/*      */   }
/*      */ 
/*      */   public <T> T unwrap(Class<T> paramClass)
/*      */     throws SQLException
/*      */   {
/* 1202 */     if ((paramClass.isInterface()) && (paramClass.isInstance(this)))
/* 1203 */       return this;
/* 1204 */     return null;
/*      */   }
/*      */ 
/*      */   public Logger getParentLogger()
/*      */     throws SQLFeatureNotSupportedException
/*      */   {
/* 1212 */     return Logger.getLogger("oracle");
/*      */   }
/*      */ 
/*      */   private String getSystemProperty(String paramString1, String paramString2)
/*      */   {
/* 1217 */     if (paramString1 != null)
/*      */     {
/* 1219 */       final String str1 = paramString1;
/* 1220 */       final String str2 = paramString2;
/* 1221 */       final String[] arrayOfString = { paramString2 };
/* 1222 */       AccessController.doPrivileged(new PrivilegedAction()
/*      */       {
/*      */         public Object run()
/*      */         {
/* 1226 */           arrayOfString[0] = System.getProperty(str1, str2);
/* 1227 */           return null;
/*      */         }
/*      */       });
/* 1230 */       return arrayOfString[0];
/*      */     }
/* 1232 */     return paramString2;
/*      */   }
/*      */ 
/*      */   static
/*      */   {
/*  194 */     synchronized (proxyFactoryLock)
/*      */     {
/*  196 */       if (PROXY_FACTORY == null)
/*      */       {
/*  206 */         NON_TXN_PROXY_FACTORY = ProxyFactory.createProxyFactory(new Class[] { NonTxnReplayableBase.class, NonTxnReplayableConnection.class, NonTxnReplayableStatement.class, NonTxnReplayableResultSet.class, NonTxnReplayableArray.class, NonTxnReplayableBfile.class, NonTxnReplayableBlob.class, NonTxnReplayableClob.class, NonTxnReplayableNClob.class, NonTxnReplayableOpaque.class, NonTxnReplayableRef.class, NonTxnReplayableStruct.class, NonTxnReplayableOthers.class });
/*      */ 
/*  222 */         PROXY_FACTORY = ProxyFactory.createProxyFactory(new Class[] { TxnReplayableBase.class, TxnReplayableConnection.class, TxnReplayableStatement.class, TxnReplayableResultSet.class, TxnReplayableArray.class, TxnReplayableBfile.class, TxnReplayableBlob.class, TxnReplayableClob.class, TxnReplayableNClob.class, TxnReplayableOpaque.class, TxnReplayableRef.class, TxnReplayableSqlxml.class, TxnReplayableStruct.class, TxnReplayableOthers.class });
/*      */       }
/*      */     }
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.replay.OracleDataSourceImpl
 * JD-Core Version:    0.6.2
 */