/*      */ package oracle.jdbc.proxy;
/*      */ 
/*      */ import java.lang.ref.Reference;
/*      */ import java.lang.ref.ReferenceQueue;
/*      */ import java.lang.ref.WeakReference;
/*      */ import java.util.AbstractCollection;
/*      */ import java.util.AbstractMap.SimpleEntry;
/*      */ import java.util.AbstractSet;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Arrays;
/*      */ import java.util.Collection;
/*      */ import java.util.ConcurrentModificationException;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import java.util.Map.Entry;
/*      */ import java.util.NoSuchElementException;
/*      */ import java.util.Set;
/*      */ 
/*      */ public class WeakIdentityHashMap<K, V>
/*      */   implements Map<K, V>
/*      */ {
/*      */   private static final int DEFAULT_INITIAL_CAPACITY = 16;
/*      */   private static final int MAXIMUM_CAPACITY = 1073741824;
/*      */   private static final float DEFAULT_LOAD_FACTOR = 0.75F;
/*      */   Entry<K, V>[] table;
/*      */   private int size;
/*      */   private int threshold;
/*      */   private final float loadFactor;
/*  170 */   private final ReferenceQueue<Object> queue = new ReferenceQueue();
/*      */   private static final int CALLS_BEFORE_NEXT_EXPUNGE = 10;
/*  177 */   private int callsBeforeNextExpunge = 10;
/*      */   volatile int modCount;
/*  264 */   private static final Object NULL_KEY = new Object();
/*      */ 
/*  842 */   private transient Set<Map.Entry<K, V>> entrySet = null;
/*      */ 
/*  849 */   volatile transient Set<K> keySet = null;
/*  850 */   volatile transient Collection<V> values = null;
/*      */ 
/*      */   private Entry<K, V>[] newTable(int paramInt)
/*      */   {
/*  192 */     return (Entry[])new Entry[paramInt];
/*      */   }
/*      */ 
/*      */   public WeakIdentityHashMap(int paramInt, float paramFloat)
/*      */   {
/*  205 */     if (paramInt < 0) {
/*  206 */       throw new IllegalArgumentException(new StringBuilder().append("Illegal Initial Capacity: ").append(paramInt).toString());
/*      */     }
/*  208 */     if (paramInt > 1073741824) {
/*  209 */       paramInt = 1073741824;
/*      */     }
/*  211 */     if ((paramFloat <= 0.0F) || (Float.isNaN(paramFloat))) {
/*  212 */       throw new IllegalArgumentException(new StringBuilder().append("Illegal Load factor: ").append(paramFloat).toString());
/*      */     }
/*  214 */     int i = 1;
/*  215 */     while (i < paramInt)
/*  216 */       i <<= 1;
/*  217 */     this.table = newTable(i);
/*  218 */     this.loadFactor = paramFloat;
/*  219 */     this.threshold = ((int)(i * paramFloat));
/*      */   }
/*      */ 
/*      */   public WeakIdentityHashMap(int paramInt)
/*      */   {
/*  230 */     this(paramInt, 0.75F);
/*      */   }
/*      */ 
/*      */   public WeakIdentityHashMap()
/*      */   {
/*  238 */     this.loadFactor = 0.75F;
/*  239 */     this.threshold = 16;
/*  240 */     this.table = newTable(16);
/*      */   }
/*      */ 
/*      */   public WeakIdentityHashMap(Map<? extends K, ? extends V> paramMap)
/*      */   {
/*  254 */     this(Math.max((int)(paramMap.size() / 0.75F) + 1, 16), 0.75F);
/*      */ 
/*  256 */     putAll(paramMap);
/*      */   }
/*      */ 
/*      */   private static Object maskNull(Object paramObject)
/*      */   {
/*  270 */     return paramObject == null ? NULL_KEY : paramObject;
/*      */   }
/*      */ 
/*      */   static Object unmaskNull(Object paramObject)
/*      */   {
/*  277 */     return paramObject == NULL_KEY ? null : paramObject;
/*      */   }
/*      */ 
/*      */   private static boolean eq(Object paramObject1, Object paramObject2)
/*      */   {
/*  284 */     return paramObject1 == paramObject2;
/*      */   }
/*      */ 
/*      */   private static int indexFor(int paramInt1, int paramInt2)
/*      */   {
/*  291 */     return paramInt1 & paramInt2 - 1;
/*      */   }
/*      */ 
/*      */   private void expungeStaleEntries()
/*      */   {
/*      */     Reference localReference;
/*  298 */     while ((localReference = this.queue.poll()) != null)
/*  299 */       synchronized (this.queue)
/*      */       {
/*  301 */         Entry localEntry1 = (Entry)localReference;
/*  302 */         int i = indexFor(localEntry1.hash, this.table.length);
/*      */ 
/*  304 */         Object localObject1 = this.table[i];
/*  305 */         Object localObject2 = localObject1;
/*  306 */         while (localObject2 != null) {
/*  307 */           Entry localEntry2 = localObject2.next;
/*  308 */           if (localObject2 == localEntry1) {
/*  309 */             if (localObject1 == localEntry1)
/*  310 */               this.table[i] = localEntry2;
/*      */             else {
/*  312 */               ((Entry)localObject1).next = localEntry2;
/*      */             }
/*      */ 
/*  315 */             localEntry1.value = null;
/*  316 */             this.size -= 1;
/*  317 */             break;
/*      */           }
/*  319 */           localObject1 = localObject2;
/*  320 */           localObject2 = localEntry2;
/*      */         }
/*      */       }
/*      */   }
/*      */ 
/*      */   private Entry<K, V>[] getTable()
/*      */   {
/*  330 */     expungeStaleEntries();
/*  331 */     return this.table;
/*      */   }
/*      */ 
/*      */   public int size()
/*      */   {
/*  341 */     if (this.size == 0)
/*  342 */       return 0;
/*  343 */     expungeStaleEntries();
/*  344 */     return this.size;
/*      */   }
/*      */ 
/*      */   public boolean isEmpty()
/*      */   {
/*  354 */     return size() == 0;
/*      */   }
/*      */ 
/*      */   public V get(Object paramObject)
/*      */   {
/*  375 */     if (this.callsBeforeNextExpunge-- < 0) {
/*  376 */       expungeStaleEntries();
/*  377 */       this.callsBeforeNextExpunge = 10;
/*      */     }
/*      */ 
/*  380 */     Object localObject = maskNull(paramObject);
/*  381 */     int i = System.identityHashCode(localObject);
/*  382 */     Entry[] arrayOfEntry = getTable();
/*  383 */     int j = indexFor(i, arrayOfEntry.length);
/*  384 */     Entry localEntry = arrayOfEntry[j];
/*  385 */     while (localEntry != null) {
/*  386 */       if ((localEntry.hash == i) && (eq(localObject, localEntry.get())))
/*  387 */         return localEntry.value;
/*  388 */       localEntry = localEntry.next;
/*      */     }
/*  390 */     return null;
/*      */   }
/*      */ 
/*      */   public boolean containsKey(Object paramObject)
/*      */   {
/*  402 */     return getEntry(paramObject) != null;
/*      */   }
/*      */ 
/*      */   Entry<K, V> getEntry(Object paramObject)
/*      */   {
/*  410 */     Object localObject = maskNull(paramObject);
/*  411 */     int i = System.identityHashCode(localObject);
/*  412 */     Entry[] arrayOfEntry = getTable();
/*  413 */     int j = indexFor(i, arrayOfEntry.length);
/*  414 */     Entry localEntry = arrayOfEntry[j];
/*  415 */     while ((localEntry != null) && ((localEntry.hash != i) || (!eq(localObject, localEntry.get()))))
/*  416 */       localEntry = localEntry.next;
/*  417 */     return localEntry;
/*      */   }
/*      */ 
/*      */   public V put(K paramK, V paramV)
/*      */   {
/*  433 */     if (this.callsBeforeNextExpunge-- < 0) {
/*  434 */       expungeStaleEntries();
/*  435 */       this.callsBeforeNextExpunge = 10;
/*      */     }
/*      */ 
/*  438 */     Object localObject1 = maskNull(paramK);
/*  439 */     int i = System.identityHashCode(localObject1);
/*  440 */     Entry[] arrayOfEntry = getTable();
/*  441 */     int j = indexFor(i, arrayOfEntry.length);
/*      */ 
/*  443 */     for (Entry localEntry = arrayOfEntry[j]; localEntry != null; localEntry = localEntry.next) {
/*  444 */       if ((i == localEntry.hash) && (eq(localObject1, localEntry.get()))) {
/*  445 */         Object localObject2 = localEntry.value;
/*  446 */         if (paramV != localObject2)
/*  447 */           localEntry.value = paramV;
/*  448 */         return localObject2;
/*      */       }
/*      */     }
/*      */ 
/*  452 */     this.modCount += 1;
/*  453 */     localEntry = arrayOfEntry[j];
/*  454 */     arrayOfEntry[j] = new Entry(localObject1, paramV, this.queue, i, localEntry);
/*  455 */     if (++this.size >= this.threshold)
/*  456 */       resize(arrayOfEntry.length * 2);
/*  457 */     return null;
/*      */   }
/*      */ 
/*      */   void resize(int paramInt)
/*      */   {
/*  475 */     Entry[] arrayOfEntry1 = getTable();
/*  476 */     int i = arrayOfEntry1.length;
/*  477 */     if (i == 1073741824) {
/*  478 */       this.threshold = 2147483647;
/*  479 */       return;
/*      */     }
/*      */ 
/*  482 */     Entry[] arrayOfEntry2 = newTable(paramInt);
/*  483 */     transfer(arrayOfEntry1, arrayOfEntry2);
/*  484 */     this.table = arrayOfEntry2;
/*      */ 
/*  491 */     if (this.size >= this.threshold / 2) {
/*  492 */       this.threshold = ((int)(paramInt * this.loadFactor));
/*      */     } else {
/*  494 */       expungeStaleEntries();
/*  495 */       transfer(arrayOfEntry2, arrayOfEntry1);
/*  496 */       this.table = arrayOfEntry1;
/*      */     }
/*      */   }
/*      */ 
/*      */   private void transfer(Entry<K, V>[] paramArrayOfEntry1, Entry<K, V>[] paramArrayOfEntry2)
/*      */   {
/*  502 */     for (int i = 0; i < paramArrayOfEntry1.length; i++) {
/*  503 */       Object localObject1 = paramArrayOfEntry1[i];
/*  504 */       paramArrayOfEntry1[i] = null;
/*  505 */       while (localObject1 != null) {
/*  506 */         Entry localEntry = ((Entry)localObject1).next;
/*  507 */         Object localObject2 = ((Entry)localObject1).get();
/*  508 */         if (localObject2 == null) {
/*  509 */           ((Entry)localObject1).next = null;
/*  510 */           ((Entry)localObject1).value = null;
/*  511 */           this.size -= 1;
/*      */         } else {
/*  513 */           int j = indexFor(((Entry)localObject1).hash, paramArrayOfEntry2.length);
/*  514 */           ((Entry)localObject1).next = paramArrayOfEntry2[j];
/*  515 */           paramArrayOfEntry2[j] = localObject1;
/*      */         }
/*  517 */         localObject1 = localEntry;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void putAll(Map<? extends K, ? extends V> paramMap)
/*      */   {
/*  531 */     int i = paramMap.size();
/*  532 */     if (i == 0) {
/*  533 */       return;
/*      */     }
/*      */ 
/*  544 */     if (i > this.threshold) {
/*  545 */       int j = (int)(i / this.loadFactor + 1.0F);
/*  546 */       if (j > 1073741824)
/*  547 */         j = 1073741824;
/*  548 */       int k = this.table.length;
/*  549 */       while (k < j)
/*  550 */         k <<= 1;
/*  551 */       if (k > this.table.length) {
/*  552 */         resize(k);
/*      */       }
/*      */     }
/*  555 */     for (Map.Entry localEntry : paramMap.entrySet())
/*  556 */       put(localEntry.getKey(), localEntry.getValue());
/*      */   }
/*      */ 
/*      */   public V remove(Object paramObject)
/*      */   {
/*  580 */     Object localObject1 = maskNull(paramObject);
/*  581 */     int i = System.identityHashCode(localObject1);
/*  582 */     Entry[] arrayOfEntry = getTable();
/*  583 */     int j = indexFor(i, arrayOfEntry.length);
/*  584 */     Object localObject2 = arrayOfEntry[j];
/*  585 */     Object localObject3 = localObject2;
/*      */ 
/*  587 */     while (localObject3 != null) {
/*  588 */       Entry localEntry = localObject3.next;
/*  589 */       if ((i == localObject3.hash) && (eq(localObject1, localObject3.get()))) {
/*  590 */         this.modCount += 1;
/*  591 */         this.size -= 1;
/*  592 */         if (localObject2 == localObject3)
/*  593 */           arrayOfEntry[j] = localEntry;
/*      */         else
/*  595 */           ((Entry)localObject2).next = localEntry;
/*  596 */         return localObject3.value;
/*      */       }
/*  598 */       localObject2 = localObject3;
/*  599 */       localObject3 = localEntry;
/*      */     }
/*      */ 
/*  602 */     return null;
/*      */   }
/*      */ 
/*      */   boolean removeMapping(Object paramObject)
/*      */   {
/*  607 */     if (!(paramObject instanceof Map.Entry))
/*  608 */       return false;
/*  609 */     Entry[] arrayOfEntry = getTable();
/*  610 */     Map.Entry localEntry = (Map.Entry)paramObject;
/*  611 */     Object localObject1 = maskNull(localEntry.getKey());
/*  612 */     int i = System.identityHashCode(localObject1);
/*  613 */     int j = indexFor(i, arrayOfEntry.length);
/*  614 */     Object localObject2 = arrayOfEntry[j];
/*  615 */     Object localObject3 = localObject2;
/*      */ 
/*  617 */     while (localObject3 != null) {
/*  618 */       Entry localEntry1 = localObject3.next;
/*  619 */       if ((i == localObject3.hash) && (localObject3.equals(localEntry))) {
/*  620 */         this.modCount += 1;
/*  621 */         this.size -= 1;
/*  622 */         if (localObject2 == localObject3)
/*  623 */           arrayOfEntry[j] = localEntry1;
/*      */         else
/*  625 */           ((Entry)localObject2).next = localEntry1;
/*  626 */         return true;
/*      */       }
/*  628 */       localObject2 = localObject3;
/*  629 */       localObject3 = localEntry1;
/*      */     }
/*      */ 
/*  632 */     return false;
/*      */   }
/*      */ 
/*      */   public void clear()
/*      */   {
/*  642 */     while (this.queue.poll() != null);
/*  645 */     this.modCount += 1;
/*  646 */     Arrays.fill(this.table, null);
/*  647 */     this.size = 0;
/*      */ 
/*  652 */     while (this.queue.poll() != null);
/*      */   }
/*      */ 
/*      */   public boolean containsValue(Object paramObject)
/*      */   {
/*  665 */     if (paramObject == null) {
/*  666 */       return containsNullValue();
/*      */     }
/*  668 */     Entry[] arrayOfEntry = getTable();
/*  669 */     for (int i = arrayOfEntry.length; i-- > 0; )
/*  670 */       for (Entry localEntry = arrayOfEntry[i]; localEntry != null; localEntry = localEntry.next)
/*  671 */         if (paramObject.equals(localEntry.value))
/*  672 */           return true;
/*  673 */     return false;
/*      */   }
/*      */ 
/*      */   private boolean containsNullValue()
/*      */   {
/*  680 */     Entry[] arrayOfEntry = getTable();
/*  681 */     for (int i = arrayOfEntry.length; i-- > 0; )
/*  682 */       for (Entry localEntry = arrayOfEntry[i]; localEntry != null; localEntry = localEntry.next)
/*  683 */         if (localEntry.value == null)
/*  684 */           return true;
/*  685 */     return false;
/*      */   }
/*      */ 
/*      */   public Set<K> keySet()
/*      */   {
/*  866 */     Set localSet = this.keySet;
/*  867 */     return this.keySet = new KeySet(null);
/*      */   }
/*      */ 
/*      */   public Collection<V> values()
/*      */   {
/*  911 */     Collection localCollection = this.values;
/*  912 */     return this.values = new Values(null);
/*      */   }
/*      */ 
/*      */   public Set<Map.Entry<K, V>> entrySet()
/*      */   {
/*  948 */     Set localSet = this.entrySet;
/*  949 */     return this.entrySet = new EntrySet(null);
/*      */   }
/*      */ 
/*      */   public boolean equals(Object paramObject)
/*      */   {
/* 1018 */     if (paramObject == this) {
/* 1019 */       return true;
/*      */     }
/* 1021 */     if (!(paramObject instanceof Map))
/* 1022 */       return false;
/* 1023 */     Map localMap = (Map)paramObject;
/* 1024 */     if (localMap.size() != size())
/* 1025 */       return false;
/*      */     try
/*      */     {
/* 1028 */       Iterator localIterator = entrySet().iterator();
/* 1029 */       while (localIterator.hasNext()) {
/* 1030 */         Map.Entry localEntry = (Map.Entry)localIterator.next();
/* 1031 */         Object localObject1 = localEntry.getKey();
/* 1032 */         Object localObject2 = localEntry.getValue();
/* 1033 */         if (localObject2 == null) {
/* 1034 */           if ((localMap.get(localObject1) != null) || (!localMap.containsKey(localObject1)))
/* 1035 */             return false;
/*      */         }
/* 1037 */         else if (!localObject2.equals(localMap.get(localObject1)))
/* 1038 */           return false;
/*      */       }
/*      */     }
/*      */     catch (ClassCastException localClassCastException) {
/* 1042 */       return false;
/*      */     } catch (NullPointerException localNullPointerException) {
/* 1044 */       return false;
/*      */     }
/*      */ 
/* 1047 */     return true;
/*      */   }
/*      */ 
/*      */   public int hashCode()
/*      */   {
/* 1068 */     int i = 0;
/* 1069 */     Iterator localIterator = entrySet().iterator();
/* 1070 */     while (localIterator.hasNext())
/* 1071 */       i += ((Map.Entry)localIterator.next()).hashCode();
/* 1072 */     return i;
/*      */   }
/*      */ 
/*      */   public String toString()
/*      */   {
/* 1088 */     Iterator localIterator = entrySet().iterator();
/* 1089 */     if (!localIterator.hasNext()) {
/* 1090 */       return "{}";
/*      */     }
/* 1092 */     StringBuilder localStringBuilder = new StringBuilder();
/* 1093 */     localStringBuilder.append('{');
/*      */     while (true) {
/* 1095 */       Map.Entry localEntry = (Map.Entry)localIterator.next();
/* 1096 */       Object localObject1 = localEntry.getKey();
/* 1097 */       Object localObject2 = localEntry.getValue();
/* 1098 */       localStringBuilder.append(localObject1 == this ? "(this Map)" : localObject1);
/* 1099 */       localStringBuilder.append('=');
/* 1100 */       localStringBuilder.append(localObject2 == this ? "(this Map)" : localObject2);
/* 1101 */       if (!localIterator.hasNext())
/* 1102 */         return localStringBuilder.append('}').toString();
/* 1103 */       localStringBuilder.append(", ");
/*      */     }
/*      */   }
/*      */ 
/*      */   protected Object clone()
/*      */     throws CloneNotSupportedException
/*      */   {
/* 1114 */     WeakIdentityHashMap localWeakIdentityHashMap = (WeakIdentityHashMap)super.clone();
/* 1115 */     localWeakIdentityHashMap.keySet = null;
/* 1116 */     localWeakIdentityHashMap.values = null;
/* 1117 */     return localWeakIdentityHashMap;
/*      */   }
/*      */ 
/*      */   private class EntrySet extends AbstractSet<Map.Entry<K, V>>
/*      */   {
/*      */     private EntrySet()
/*      */     {
/*      */     }
/*      */ 
/*      */     public Iterator<Map.Entry<K, V>> iterator()
/*      */     {
/*  954 */       return new WeakIdentityHashMap.EntryIterator(WeakIdentityHashMap.this, null);
/*      */     }
/*      */ 
/*      */     public boolean contains(Object paramObject) {
/*  958 */       if (!(paramObject instanceof Map.Entry))
/*  959 */         return false;
/*  960 */       Map.Entry localEntry = (Map.Entry)paramObject;
/*  961 */       WeakIdentityHashMap.Entry localEntry1 = WeakIdentityHashMap.this.getEntry(localEntry.getKey());
/*  962 */       return (localEntry1 != null) && (localEntry1.equals(localEntry));
/*      */     }
/*      */ 
/*      */     public boolean remove(Object paramObject) {
/*  966 */       return WeakIdentityHashMap.this.removeMapping(paramObject);
/*      */     }
/*      */ 
/*      */     public int size() {
/*  970 */       return WeakIdentityHashMap.this.size();
/*      */     }
/*      */ 
/*      */     public void clear() {
/*  974 */       WeakIdentityHashMap.this.clear();
/*      */     }
/*      */ 
/*      */     private List<Map.Entry<K, V>> deepCopy() {
/*  978 */       ArrayList localArrayList = new ArrayList(size());
/*      */ 
/*  980 */       for (Map.Entry localEntry : this)
/*  981 */         localArrayList.add(new AbstractMap.SimpleEntry(localEntry));
/*  982 */       return localArrayList;
/*      */     }
/*      */ 
/*      */     public Object[] toArray() {
/*  986 */       return deepCopy().toArray();
/*      */     }
/*      */ 
/*      */     public <T> T[] toArray(T[] paramArrayOfT) {
/*  990 */       return deepCopy().toArray(paramArrayOfT);
/*      */     }
/*      */   }
/*      */ 
/*      */   private class Values extends AbstractCollection<V>
/*      */   {
/*      */     private Values()
/*      */     {
/*      */     }
/*      */ 
/*      */     public Iterator<V> iterator()
/*      */     {
/*  917 */       return new WeakIdentityHashMap.ValueIterator(WeakIdentityHashMap.this, null);
/*      */     }
/*      */ 
/*      */     public int size() {
/*  921 */       return WeakIdentityHashMap.this.size();
/*      */     }
/*      */ 
/*      */     public boolean contains(Object paramObject) {
/*  925 */       return WeakIdentityHashMap.this.containsValue(paramObject);
/*      */     }
/*      */ 
/*      */     public void clear() {
/*  929 */       WeakIdentityHashMap.this.clear();
/*      */     }
/*      */   }
/*      */ 
/*      */   private class KeySet extends AbstractSet<K>
/*      */   {
/*      */     private KeySet()
/*      */     {
/*      */     }
/*      */ 
/*      */     public Iterator<K> iterator()
/*      */     {
/*  872 */       return new WeakIdentityHashMap.KeyIterator(WeakIdentityHashMap.this, null);
/*      */     }
/*      */ 
/*      */     public int size() {
/*  876 */       return WeakIdentityHashMap.this.size();
/*      */     }
/*      */ 
/*      */     public boolean contains(Object paramObject) {
/*  880 */       return WeakIdentityHashMap.this.containsKey(paramObject);
/*      */     }
/*      */ 
/*      */     public boolean remove(Object paramObject) {
/*  884 */       if (WeakIdentityHashMap.this.containsKey(paramObject)) {
/*  885 */         WeakIdentityHashMap.this.remove(paramObject);
/*  886 */         return true;
/*      */       }
/*      */ 
/*  889 */       return false;
/*      */     }
/*      */ 
/*      */     public void clear() {
/*  893 */       WeakIdentityHashMap.this.clear();
/*      */     }
/*      */   }
/*      */ 
/*      */   private class EntryIterator extends WeakIdentityHashMap<K, V>.HashIterator<Map.Entry<K, V>>
/*      */   {
/*      */     private EntryIterator()
/*      */     {
/*  834 */       super();
/*      */     }
/*  836 */     public Map.Entry<K, V> next() { return nextEntry(); }
/*      */ 
/*      */   }
/*      */ 
/*      */   private class KeyIterator extends WeakIdentityHashMap<K, V>.HashIterator<K>
/*      */   {
/*      */     private KeyIterator()
/*      */     {
/*  828 */       super();
/*      */     }
/*  830 */     public K next() { return nextEntry().getKey(); }
/*      */ 
/*      */   }
/*      */ 
/*      */   private class ValueIterator extends WeakIdentityHashMap<K, V>.HashIterator<V>
/*      */   {
/*      */     private ValueIterator()
/*      */     {
/*  822 */       super();
/*      */     }
/*  824 */     public V next() { return nextEntry().value; }
/*      */ 
/*      */   }
/*      */ 
/*      */   private abstract class HashIterator<T>
/*      */     implements Iterator<T>
/*      */   {
/*      */     private int index;
/*  753 */     private WeakIdentityHashMap.Entry<K, V> entry = null;
/*  754 */     private WeakIdentityHashMap.Entry<K, V> lastReturned = null;
/*  755 */     private int expectedModCount = WeakIdentityHashMap.this.modCount;
/*      */ 
/*  761 */     private Object nextKey = null;
/*      */ 
/*  767 */     private Object currentKey = null;
/*      */ 
/*      */     HashIterator() {
/*  770 */       this.index = (WeakIdentityHashMap.this.isEmpty() ? 0 : WeakIdentityHashMap.this.table.length);
/*      */     }
/*      */ 
/*      */     public boolean hasNext() {
/*  774 */       WeakIdentityHashMap.Entry[] arrayOfEntry = WeakIdentityHashMap.this.table;
/*      */ 
/*  776 */       while (this.nextKey == null) {
/*  777 */         WeakIdentityHashMap.Entry localEntry = this.entry;
/*  778 */         int i = this.index;
/*  779 */         while ((localEntry == null) && (i > 0))
/*  780 */           localEntry = arrayOfEntry[(--i)];
/*  781 */         this.entry = localEntry;
/*  782 */         this.index = i;
/*  783 */         if (localEntry == null) {
/*  784 */           this.currentKey = null;
/*  785 */           return false;
/*      */         }
/*  787 */         this.nextKey = localEntry.get();
/*  788 */         if (this.nextKey == null)
/*  789 */           this.entry = this.entry.next;
/*      */       }
/*  791 */       return true;
/*      */     }
/*      */ 
/*      */     protected WeakIdentityHashMap.Entry<K, V> nextEntry()
/*      */     {
/*  796 */       if (WeakIdentityHashMap.this.modCount != this.expectedModCount)
/*  797 */         throw new ConcurrentModificationException();
/*  798 */       if ((this.nextKey == null) && (!hasNext())) {
/*  799 */         throw new NoSuchElementException();
/*      */       }
/*  801 */       this.lastReturned = this.entry;
/*  802 */       this.entry = this.entry.next;
/*  803 */       this.currentKey = this.nextKey;
/*  804 */       this.nextKey = null;
/*  805 */       return this.lastReturned;
/*      */     }
/*      */ 
/*      */     public void remove() {
/*  809 */       if (this.lastReturned == null)
/*  810 */         throw new IllegalStateException();
/*  811 */       if (WeakIdentityHashMap.this.modCount != this.expectedModCount) {
/*  812 */         throw new ConcurrentModificationException();
/*      */       }
/*  814 */       WeakIdentityHashMap.this.remove(this.currentKey);
/*  815 */       this.expectedModCount = WeakIdentityHashMap.this.modCount;
/*  816 */       this.lastReturned = null;
/*  817 */       this.currentKey = null;
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class Entry<K, V> extends WeakReference<Object>
/*      */     implements Map.Entry<K, V>
/*      */   {
/*      */     V value;
/*      */     final int hash;
/*      */     Entry<K, V> next;
/*      */ 
/*      */     Entry(Object paramObject, V paramV, ReferenceQueue<Object> paramReferenceQueue, int paramInt, Entry<K, V> paramEntry)
/*      */     {
/*  703 */       super(paramReferenceQueue);
/*  704 */       this.value = paramV;
/*  705 */       this.hash = paramInt;
/*  706 */       this.next = paramEntry;
/*      */     }
/*      */ 
/*      */     public K getKey()
/*      */     {
/*  711 */       return WeakIdentityHashMap.unmaskNull(get());
/*      */     }
/*      */ 
/*      */     public V getValue() {
/*  715 */       return this.value;
/*      */     }
/*      */ 
/*      */     public V setValue(V paramV) {
/*  719 */       Object localObject = this.value;
/*  720 */       this.value = paramV;
/*  721 */       return localObject;
/*      */     }
/*      */ 
/*      */     public boolean equals(Object paramObject) {
/*  725 */       if (!(paramObject instanceof Map.Entry))
/*  726 */         return false;
/*  727 */       Map.Entry localEntry = (Map.Entry)paramObject;
/*  728 */       Object localObject1 = getKey();
/*  729 */       Object localObject2 = localEntry.getKey();
/*  730 */       if (localObject1 == localObject2) {
/*  731 */         Object localObject3 = getValue();
/*  732 */         Object localObject4 = localEntry.getValue();
/*  733 */         if ((localObject3 == localObject4) || ((localObject3 != null) && (localObject3.equals(localObject4))))
/*  734 */           return true;
/*      */       }
/*  736 */       return false;
/*      */     }
/*      */ 
/*      */     public int hashCode() {
/*  740 */       Object localObject1 = getKey();
/*  741 */       Object localObject2 = getValue();
/*  742 */       return (localObject1 == null ? 0 : System.identityHashCode(localObject1)) ^ (localObject2 == null ? 0 : localObject2.hashCode());
/*      */     }
/*      */ 
/*      */     public String toString()
/*      */     {
/*  747 */       return getKey() + "=" + getValue();
/*      */     }
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.proxy.WeakIdentityHashMap
 * JD-Core Version:    0.6.2
 */