/*     */ package oracle.jdbc.proxy;
/*     */ 
/*     */ import org.objectweb.asm.MethodVisitor;
/*     */ import org.objectweb.asm.Type;
/*     */ 
/*     */ class Utils
/*     */ {
/*     */   static String makeSlashed(Class paramClass)
/*     */   {
/*  53 */     return makeSlashed(paramClass.getName());
/*     */   }
/*     */ 
/*     */   static String makeSlashed(String paramString)
/*     */   {
/*  58 */     return paramString.replace('.', '/');
/*     */   }
/*     */ 
/*     */   static String makeSlashed(String paramString1, String paramString2)
/*     */   {
/*  63 */     return new StringBuilder().append(makeSlashed(paramString1)).append('/').append(paramString2).toString();
/*     */   }
/*     */ 
/*     */   static String makeType(Class paramClass)
/*     */   {
/*  68 */     return makeType(paramClass.getName());
/*     */   }
/*     */ 
/*     */   static String makeType(String paramString)
/*     */   {
/*  73 */     String str = makeSlashed(paramString);
/*     */ 
/*  75 */     if ("boolean".equals(str)) {
/*  76 */       return "Z";
/*     */     }
/*  78 */     if ("char".equals(str)) {
/*  79 */       return "C";
/*     */     }
/*  81 */     if ("byte".equals(str)) {
/*  82 */       return "B";
/*     */     }
/*  84 */     if ("short".equals(str)) {
/*  85 */       return "S";
/*     */     }
/*  87 */     if ("int".equals(str)) {
/*  88 */       return "I";
/*     */     }
/*  90 */     if ("long".equals(str)) {
/*  91 */       return "J";
/*     */     }
/*  93 */     if ("float".equals(str)) {
/*  94 */       return "F";
/*     */     }
/*  96 */     if ("double".equals(str)) {
/*  97 */       return "D";
/*     */     }
/*  99 */     if ("void".equals(str)) {
/* 100 */       return "V";
/*     */     }
/* 102 */     if (str.startsWith("[")) {
/* 103 */       return str;
/*     */     }
/* 105 */     return new StringBuilder().append('L').append(str).append(';').toString();
/*     */   }
/*     */ 
/*     */   static String makeSignature(Class[] paramArrayOfClass, Class paramClass)
/*     */   {
/* 111 */     StringBuilder localStringBuilder = new StringBuilder();
/* 112 */     localStringBuilder.append('(');
/*     */ 
/* 114 */     for (Class localClass : paramArrayOfClass) {
/* 115 */       localStringBuilder.append(makeType(makeSlashed(localClass.getName())));
/*     */     }
/* 117 */     localStringBuilder.append(')').append(makeType(makeSlashed(paramClass.getName())));
/* 118 */     return localStringBuilder.toString();
/*     */   }
/*     */ 
/*     */   static String[] makeThrowables(Class[] paramArrayOfClass)
/*     */   {
/* 123 */     int i = paramArrayOfClass.length;
/*     */     String[] arrayOfString;
/* 125 */     if (0 == i) {
/* 126 */       arrayOfString = null;
/*     */     }
/*     */     else {
/* 129 */       arrayOfString = new String[i];
/* 130 */       for (int j = 0; j < i; j++) {
/* 131 */         arrayOfString[j] = makeSlashed(paramArrayOfClass[j].getName());
/*     */       }
/*     */     }
/* 134 */     return arrayOfString;
/*     */   }
/*     */ 
/*     */   static int loadOpcode(Class paramClass)
/*     */   {
/* 139 */     String str = paramClass.getName();
/* 140 */     if (("boolean".equals(str)) || ("byte".equals(str)) || ("char".equals(str)) || ("short".equals(str)) || ("int".equals(str)))
/*     */     {
/* 145 */       return 21;
/*     */     }
/* 147 */     if ("long".equals(str)) {
/* 148 */       return 22;
/*     */     }
/* 150 */     if ("float".equals(str)) {
/* 151 */       return 23;
/*     */     }
/* 153 */     if ("double".equals(str)) {
/* 154 */       return 24;
/*     */     }
/* 156 */     return 25;
/*     */   }
/*     */ 
/*     */   static int storeOpcode(Class paramClass)
/*     */   {
/* 161 */     String str = paramClass.getName();
/* 162 */     if (("boolean".equals(str)) || ("byte".equals(str)) || ("char".equals(str)) || ("short".equals(str)) || ("int".equals(str)))
/*     */     {
/* 167 */       return 54;
/*     */     }
/* 169 */     if ("long".equals(str)) {
/* 170 */       return 55;
/*     */     }
/* 172 */     if ("float".equals(str)) {
/* 173 */       return 56;
/*     */     }
/* 175 */     if ("double".equals(str)) {
/* 176 */       return 57;
/*     */     }
/* 178 */     return 58;
/*     */   }
/*     */ 
/*     */   static int returnOpcode(Class paramClass)
/*     */   {
/* 183 */     String str = paramClass.getName();
/* 184 */     if (("boolean".equals(str)) || ("byte".equals(str)) || ("char".equals(str)) || ("short".equals(str)) || ("int".equals(str)))
/*     */     {
/* 189 */       return 172;
/*     */     }
/* 191 */     if ("long".equals(str)) {
/* 192 */       return 173;
/*     */     }
/* 194 */     if ("float".equals(str)) {
/* 195 */       return 174;
/*     */     }
/* 197 */     if ("double".equals(str)) {
/* 198 */       return 175;
/*     */     }
/* 200 */     if ("void".equals(str)) {
/* 201 */       return 177;
/*     */     }
/* 203 */     return 176;
/*     */   }
/*     */ 
/*     */   static int varSize(Class paramClass)
/*     */   {
/* 208 */     String str = paramClass.getName();
/* 209 */     if (("double".equals(str)) || ("long".equals(str))) {
/* 210 */       return 2;
/*     */     }
/* 212 */     return 1;
/*     */   }
/*     */ 
/*     */   static void cast(MethodVisitor paramMethodVisitor, Class paramClass1, Class paramClass2)
/*     */   {
/* 219 */     boolean bool1 = isPrimitive(paramClass1);
/* 220 */     boolean bool2 = isPrimitive(paramClass2);
/*     */ 
/* 222 */     if ((!bool1) && (bool2))
/* 223 */       autoUnbox(paramMethodVisitor, paramClass2);
/* 224 */     else if ((bool1) && (!bool2))
/* 225 */       autoBox(paramMethodVisitor, paramClass1);
/* 226 */     else if ((!bool1) && (!bool2) && (!paramClass1.equals(paramClass2)))
/* 227 */       paramMethodVisitor.visitTypeInsn(192, makeSlashed(paramClass2));
/*     */   }
/*     */ 
/*     */   static boolean isPrimitive(Class paramClass)
/*     */   {
/* 232 */     return (Boolean.TYPE.equals(paramClass)) || (Character.TYPE.equals(paramClass)) || (Byte.TYPE.equals(paramClass)) || (Short.TYPE.equals(paramClass)) || (Integer.TYPE.equals(paramClass)) || (Long.TYPE.equals(paramClass)) || (Float.TYPE.equals(paramClass)) || (Double.TYPE.equals(paramClass));
/*     */   }
/*     */ 
/*     */   static void autoBox(MethodVisitor paramMethodVisitor, Class paramClass)
/*     */   {
/* 245 */     if (Boolean.TYPE.equals(paramClass)) {
/* 246 */       paramMethodVisitor.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
/*     */     }
/* 252 */     else if (Character.TYPE.equals(paramClass)) {
/* 253 */       paramMethodVisitor.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
/*     */     }
/* 259 */     else if (Byte.TYPE.equals(paramClass)) {
/* 260 */       paramMethodVisitor.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
/*     */     }
/* 266 */     else if (Short.TYPE.equals(paramClass)) {
/* 267 */       paramMethodVisitor.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
/*     */     }
/* 273 */     else if (Integer.TYPE.equals(paramClass)) {
/* 274 */       paramMethodVisitor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
/*     */     }
/* 280 */     else if (Long.TYPE.equals(paramClass)) {
/* 281 */       paramMethodVisitor.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
/*     */     }
/* 287 */     else if (Float.TYPE.equals(paramClass)) {
/* 288 */       paramMethodVisitor.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
/*     */     }
/* 294 */     else if (Double.TYPE.equals(paramClass))
/* 295 */       paramMethodVisitor.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
/*     */   }
/*     */ 
/*     */   static void autoUnbox(MethodVisitor paramMethodVisitor, Class paramClass)
/*     */   {
/* 304 */     if (Boolean.TYPE.equals(paramClass))
/*     */     {
/* 306 */       paramMethodVisitor.visitTypeInsn(192, "java/lang/Boolean");
/*     */ 
/* 310 */       paramMethodVisitor.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
/*     */     }
/* 317 */     else if (Character.TYPE.equals(paramClass))
/*     */     {
/* 319 */       paramMethodVisitor.visitTypeInsn(192, "java/lang/Character");
/*     */ 
/* 323 */       paramMethodVisitor.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
/*     */     }
/* 330 */     else if (Byte.TYPE.equals(paramClass))
/*     */     {
/* 332 */       paramMethodVisitor.visitTypeInsn(192, "java/lang/Byte");
/*     */ 
/* 336 */       paramMethodVisitor.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B");
/*     */     }
/* 343 */     else if (Short.TYPE.equals(paramClass))
/*     */     {
/* 345 */       paramMethodVisitor.visitTypeInsn(192, "java/lang/Short");
/*     */ 
/* 349 */       paramMethodVisitor.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S");
/*     */     }
/* 356 */     else if (Integer.TYPE.equals(paramClass))
/*     */     {
/* 358 */       paramMethodVisitor.visitTypeInsn(192, "java/lang/Integer");
/*     */ 
/* 362 */       paramMethodVisitor.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I");
/*     */     }
/* 369 */     else if (Long.TYPE.equals(paramClass))
/*     */     {
/* 371 */       paramMethodVisitor.visitTypeInsn(192, "java/lang/Long");
/*     */ 
/* 375 */       paramMethodVisitor.visitMethodInsn(182, "java/lang/Long", "longValue", "()J");
/*     */     }
/* 382 */     else if (Float.TYPE.equals(paramClass))
/*     */     {
/* 384 */       paramMethodVisitor.visitTypeInsn(192, "java/lang/Float");
/*     */ 
/* 388 */       paramMethodVisitor.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F");
/*     */     }
/* 395 */     else if (Double.TYPE.equals(paramClass))
/*     */     {
/* 397 */       paramMethodVisitor.visitTypeInsn(192, "java/lang/Double");
/*     */ 
/* 401 */       paramMethodVisitor.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
/*     */     }
/*     */     else
/*     */     {
/* 409 */       paramMethodVisitor.visitTypeInsn(192, makeSlashed(paramClass));
/*     */     }
/*     */   }
/*     */ 
/*     */   static void loadClass(MethodVisitor paramMethodVisitor, Class paramClass)
/*     */   {
/* 416 */     String str = paramClass.getName();
/*     */ 
/* 418 */     if ("boolean".equals(str)) {
/* 419 */       paramMethodVisitor.visitFieldInsn(178, "java/lang/Boolean", "TYPE", "Ljava/lang/Class;");
/*     */     }
/* 425 */     else if ("char".equals(str)) {
/* 426 */       paramMethodVisitor.visitFieldInsn(178, "java/lang/Character", "TYPE", "Ljava/lang/Class;");
/*     */     }
/* 432 */     else if ("byte".equals(str)) {
/* 433 */       paramMethodVisitor.visitFieldInsn(178, "java/lang/Byte", "TYPE", "Ljava/lang/Class;");
/*     */     }
/* 439 */     else if ("short".equals(str)) {
/* 440 */       paramMethodVisitor.visitFieldInsn(178, "java/lang/Short", "TYPE", "Ljava/lang/Class;");
/*     */     }
/* 446 */     else if ("int".equals(str)) {
/* 447 */       paramMethodVisitor.visitFieldInsn(178, "java/lang/Integer", "TYPE", "Ljava/lang/Class;");
/*     */     }
/* 453 */     else if ("long".equals(str)) {
/* 454 */       paramMethodVisitor.visitFieldInsn(178, "java/lang/Long", "TYPE", "Ljava/lang/Class;");
/*     */     }
/* 460 */     else if ("float".equals(str)) {
/* 461 */       paramMethodVisitor.visitFieldInsn(178, "java/lang/Float", "TYPE", "Ljava/lang/Class;");
/*     */     }
/* 467 */     else if ("double".equals(str)) {
/* 468 */       paramMethodVisitor.visitFieldInsn(178, "java/lang/Double", "TYPE", "Ljava/lang/Class;");
/*     */     }
/*     */     else
/*     */     {
/* 475 */       paramMethodVisitor.visitLdcInsn(Type.getType(paramClass));
/*     */     }
/*     */   }
/*     */ 
/*     */   static void loadConst(MethodVisitor paramMethodVisitor, int paramInt) {
/* 480 */     switch (paramInt) {
/*     */     case 0:
/* 482 */       paramMethodVisitor.visitInsn(3); return;
/*     */     case 1:
/* 483 */       paramMethodVisitor.visitInsn(4); return;
/*     */     case 2:
/* 484 */       paramMethodVisitor.visitInsn(5); return;
/*     */     case 3:
/* 485 */       paramMethodVisitor.visitInsn(6); return;
/*     */     case 4:
/* 486 */       paramMethodVisitor.visitInsn(7); return;
/*     */     case 5:
/* 487 */       paramMethodVisitor.visitInsn(8); return;
/*     */     }
/*     */ 
/* 490 */     if ((paramInt >= -128) && (paramInt <= 127))
/*     */     {
/* 492 */       paramMethodVisitor.visitIntInsn(16, paramInt);
/* 493 */       return;
/*     */     }
/*     */ 
/* 496 */     throw new RuntimeException(new StringBuilder().append("do not know how to load ").append(paramInt).toString());
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.proxy.Utils
 * JD-Core Version:    0.6.2
 */