/*     */ package oracle.jdbc.proxy;
/*     */ 
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ 
/*     */ public class ProxyFactory
/*     */ {
/*  31 */   final AnnotationsRegistry annotationsRegistry = new AnnotationsRegistry();
/*  32 */   private final GeneratedProxiesRegistry generatedRegistry = new GeneratedProxiesRegistry();
/*  33 */   private final Map<Class, Class> delegateClassToProxyClass = Collections.synchronizedMap(new HashMap());
/*  34 */   private final Map<Object, WeakReference<Object>> delegateToProxy = Collections.synchronizedMap(new WeakIdentityHashMap());
/*  35 */   private final Map<Class, Class> delegateToMostSuitableIface = Collections.synchronizedMap(new HashMap());
/*     */ 
/*  37 */   private static final Object STALE_DELEGATE = new Object();
/*     */ 
/*  39 */   private static final Class EMPTY_VALUE = EMPTY_CLASS.class;
/*     */ 
/* 434 */   private static final ExtractDelegatePermission EXTRACT_DELEGATE_PERMISSION = new ExtractDelegatePermission();
/*     */ 
/*     */   public static ProxyFactory createProxyFactory(Class[] paramArrayOfClass)
/*     */   {
/*  50 */     ProxyFactory localProxyFactory = new ProxyFactory();
/*  51 */     localProxyFactory.annotationsRegistry.register(paramArrayOfClass);
/*  52 */     return localProxyFactory;
/*     */   }
/*     */ 
/*     */   public static ProxyFactory createJDBCProxyFactory(Class[] paramArrayOfClass)
/*     */   {
/*  66 */     ProxyFactory localProxyFactory = new ProxyFactory();
/*  67 */     localProxyFactory.annotationsRegistry.register(new Class[] { NullProxy.class });
/*  68 */     localProxyFactory.annotationsRegistry.register(paramArrayOfClass);
/*  69 */     return localProxyFactory;
/*     */   }
/*     */ 
/*     */   public final boolean isProxied(Class paramClass)
/*     */   {
/*  79 */     return this.annotationsRegistry.containsKey(paramClass);
/*     */   }
/*     */ 
/*     */   public final <T> T proxyFor(T paramT)
/*     */   {
/*  91 */     return proxyFor(paramT, this);
/*     */   }
/*     */ 
/*     */   public final <T> T proxyFor(T paramT, Object paramObject)
/*     */   {
/* 105 */     return proxyForCache(paramT, paramObject, null, null);
/*     */   }
/*     */ 
/*     */   public final <T> T proxyForCreate(T paramT, Object paramObject, Map<Object, WeakReference<Object>> paramMap, Method paramMethod)
/*     */   {
/* 138 */     if (null == paramT) {
/* 139 */       return null;
/*     */     }
/*     */ 
/* 142 */     if ((paramT instanceof _Proxy_)) {
/* 143 */       return paramT;
/*     */     }
/* 145 */     Class localClass1 = paramT.getClass();
/* 146 */     Class localClass2 = findMostSuitableIface(localClass1);
/*     */ 
/* 149 */     if ((null != paramMethod) && (null != localClass2) && 
/* 150 */       (!paramMethod.getReturnType().isAssignableFrom(localClass2))) {
/* 151 */       return paramT;
/*     */     }
/* 153 */     AnnotationsRegistry.Value localValue = this.annotationsRegistry.get(localClass2);
/* 154 */     if (null == localValue) {
/* 155 */       return paramT;
/*     */     }
/* 157 */     if (null == paramMap) {
/* 158 */       paramMap = localValue.isProxyLocale() ? new WeakIdentityHashMap() : this.delegateToProxy;
/*     */     }
/*     */ 
/* 162 */     Class localClass3 = getProxyClass(localClass2, localClass1);
/* 163 */     if (null == localClass3) {
/* 164 */       return createProxy(localClass2, paramT, paramObject, paramMap);
/*     */     }
/*     */     try
/*     */     {
/* 168 */       return localClass3.getConstructor(new Class[] { localClass2, Object.class, ProxyFactory.class, Map.class }).newInstance(new Object[] { paramT, paramObject, this, paramMap });
/*     */     }
/*     */     catch (NoSuchMethodException localNoSuchMethodException)
/*     */     {
/* 177 */       throw new RuntimeException(localNoSuchMethodException);
/*     */     }
/*     */     catch (IllegalAccessException localIllegalAccessException)
/*     */     {
/* 181 */       throw new RuntimeException(localIllegalAccessException);
/*     */     }
/*     */     catch (InvocationTargetException localInvocationTargetException)
/*     */     {
/* 185 */       throw new RuntimeException(localInvocationTargetException);
/*     */     }
/*     */     catch (InstantiationException localInstantiationException)
/*     */     {
/* 189 */       throw new RuntimeException(localInstantiationException);
/*     */     }
/*     */   }
/*     */ 
/*     */   public final <T> T proxyForCache(T paramT, Object paramObject, Map<Object, WeakReference<Object>> paramMap, Method paramMethod)
/*     */   {
/* 223 */     if (null == paramT) {
/* 224 */       return null;
/*     */     }
/*     */ 
/* 227 */     if ((paramT instanceof _Proxy_)) {
/* 228 */       return paramT;
/*     */     }
/* 230 */     Class localClass1 = paramT.getClass();
/* 231 */     Class localClass2 = findMostSuitableIface(localClass1);
/*     */ 
/* 234 */     if ((null != paramMethod) && (null != localClass2) && 
/* 235 */       (!paramMethod.getReturnType().isAssignableFrom(localClass2))) {
/* 236 */       return paramT;
/*     */     }
/* 238 */     AnnotationsRegistry.Value localValue = this.annotationsRegistry.get(localClass2);
/* 239 */     if (null == localValue) {
/* 240 */       return paramT;
/*     */     }
/*     */ 
/* 243 */     Method localMethod1 = localValue.getProxyAccessGetter();
/* 244 */     Method localMethod2 = localValue.getProxyAccessSetter();
/*     */ 
/* 246 */     if (null == paramMap) {
/* 247 */       paramMap = localValue.isProxyLocale() ? new WeakIdentityHashMap() : this.delegateToProxy;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 252 */       if (null != localMethod1) {
/* 253 */         localObject1 = localMethod1.invoke(paramT, new Object[0]);
/* 254 */         if (null != localObject1)
/* 255 */           return localObject1;
/*     */       }
/*     */       else {
/* 258 */         localObject1 = (WeakReference)paramMap.get(paramT);
/* 259 */         if (null != localObject1) {
/* 260 */           localObject2 = ((WeakReference)localObject1).get();
/* 261 */           if (null != localObject2) {
/* 262 */             if (STALE_DELEGATE == localObject2) {
/* 263 */               throw new RuntimeException("stale delegate");
/*     */             }
/* 265 */             return localObject2;
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/* 270 */       Object localObject1 = getProxyClass(localClass2, localClass1);
/* 271 */       if (null == localObject1) {
/* 272 */         localObject2 = createProxy(localClass2, paramT, paramObject, paramMap);
/*     */ 
/* 274 */         if (null != localMethod2)
/* 275 */           localMethod2.invoke(paramT, new Object[] { localObject2 });
/*     */         else {
/* 277 */           paramMap.put(paramT, new WeakReference(localObject2));
/*     */         }
/* 279 */         return localObject2;
/*     */       }
/*     */ 
/* 282 */       Object localObject2 = ((Class)localObject1).getConstructor(new Class[] { localClass2, Object.class, ProxyFactory.class, Map.class }).newInstance(new Object[] { paramT, paramObject, this, paramMap });
/*     */ 
/* 289 */       if (null != localMethod2)
/* 290 */         localMethod2.invoke(paramT, new Object[] { localObject2 });
/*     */       else {
/* 292 */         paramMap.put(paramT, new WeakReference(localObject2));
/*     */       }
/* 294 */       return localObject2;
/*     */     }
/*     */     catch (NoSuchMethodException localNoSuchMethodException)
/*     */     {
/* 298 */       throw new RuntimeException(localNoSuchMethodException);
/*     */     }
/*     */     catch (IllegalAccessException localIllegalAccessException) {
/* 301 */       throw new RuntimeException(localIllegalAccessException);
/*     */     }
/*     */     catch (InvocationTargetException localInvocationTargetException) {
/* 304 */       throw new RuntimeException(localInvocationTargetException);
/*     */     }
/*     */     catch (InstantiationException localInstantiationException) {
/* 307 */       throw new RuntimeException(localInstantiationException);
/*     */     }
/*     */   }
/*     */ 
/*     */   public final <T> T proxyForCreateCache(T paramT, Object paramObject, Map<Object, WeakReference<Object>> paramMap, Method paramMethod)
/*     */   {
/* 342 */     if (null == paramT) {
/* 343 */       return null;
/*     */     }
/*     */ 
/* 346 */     if ((paramT instanceof _Proxy_)) {
/* 347 */       return paramT;
/*     */     }
/* 349 */     Class localClass1 = paramT.getClass();
/* 350 */     Class localClass2 = findMostSuitableIface(localClass1);
/*     */ 
/* 353 */     if ((null != paramMethod) && (null != localClass2) && 
/* 354 */       (!paramMethod.getReturnType().isAssignableFrom(localClass2))) {
/* 355 */       return paramT;
/*     */     }
/* 357 */     AnnotationsRegistry.Value localValue = this.annotationsRegistry.get(localClass2);
/* 358 */     if (null == localValue) {
/* 359 */       return paramT;
/*     */     }
/* 361 */     if (null == paramMap) {
/* 362 */       paramMap = localValue.isProxyLocale() ? new WeakIdentityHashMap() : this.delegateToProxy;
/*     */     }
/*     */ 
/* 366 */     Method localMethod = localValue.getProxyAccessSetter();
/*     */ 
/* 368 */     Class localClass3 = getProxyClass(localClass2, localClass1);
/*     */     try
/*     */     {
/* 371 */       if (null == localClass3) {
/* 372 */         localObject = createProxy(localClass2, paramT, paramObject, paramMap);
/*     */ 
/* 374 */         if (null != localMethod)
/* 375 */           localMethod.invoke(paramT, new Object[] { localObject });
/*     */         else {
/* 377 */           paramMap.put(paramT, new WeakReference(localObject));
/*     */         }
/* 379 */         return localObject;
/*     */       }
/*     */ 
/* 382 */       Object localObject = localClass3.getConstructor(new Class[] { localClass2, Object.class, ProxyFactory.class, Map.class }).newInstance(new Object[] { paramT, paramObject, this, paramMap });
/*     */ 
/* 389 */       if (null != localMethod)
/* 390 */         localMethod.invoke(paramT, new Object[] { localObject });
/*     */       else {
/* 392 */         paramMap.put(paramT, new WeakReference(localObject));
/*     */       }
/* 394 */       return localObject;
/*     */     }
/*     */     catch (NoSuchMethodException localNoSuchMethodException)
/*     */     {
/* 398 */       throw new RuntimeException(localNoSuchMethodException);
/*     */     }
/*     */     catch (IllegalAccessException localIllegalAccessException) {
/* 401 */       throw new RuntimeException(localIllegalAccessException);
/*     */     }
/*     */     catch (InvocationTargetException localInvocationTargetException) {
/* 404 */       throw new RuntimeException(localInvocationTargetException);
/*     */     }
/*     */     catch (InstantiationException localInstantiationException) {
/* 407 */       throw new RuntimeException(localInstantiationException);
/*     */     }
/*     */   }
/*     */ 
/*     */   public <T> void updateDelegate(Object paramObject, T paramT1, T paramT2)
/*     */   {
/* 430 */     this.delegateToProxy.put(paramT1, new WeakReference(STALE_DELEGATE));
/* 431 */     this.delegateToProxy.put(paramT2, new WeakReference(paramObject));
/*     */   }
/*     */ 
/*     */   public static final Object extractDelegate(_Proxy_ param_Proxy_)
/*     */   {
/* 448 */     SecurityManager localSecurityManager = System.getSecurityManager();
/* 449 */     if (null != localSecurityManager) {
/* 450 */       localSecurityManager.checkPermission(EXTRACT_DELEGATE_PERMISSION);
/*     */     }
/* 452 */     return param_Proxy_._getDelegate_();
/*     */   }
/*     */ 
/*     */   private <T> T createProxy(Class paramClass, T paramT, Object paramObject, Map<Object, WeakReference<Object>> paramMap)
/*     */   {
/* 469 */     if (null == paramClass) {
/* 470 */       return paramT;
/*     */     }
/* 472 */     AnnotationsRegistry.Value localValue = this.annotationsRegistry.get(paramClass);
/*     */ 
/* 474 */     Class localClass = localValue.getSuperclass();
/*     */ 
/* 476 */     GeneratedProxiesRegistry.Value localValue1 = this.generatedRegistry.get(paramClass, localClass);
/*     */ 
/* 479 */     Constructor localConstructor = null == localValue1 ? prepareProxy(paramClass, localClass) : localValue1.getConstructor();
/*     */     try
/*     */     {
/* 486 */       return localConstructor.newInstance(new Object[] { paramT, paramObject, this, paramMap });
/*     */     }
/*     */     catch (InvocationTargetException localInvocationTargetException)
/*     */     {
/* 490 */       throw new RuntimeException(localInvocationTargetException.getTargetException());
/*     */     }
/*     */     catch (IllegalAccessException localIllegalAccessException)
/*     */     {
/* 494 */       throw new RuntimeException(localIllegalAccessException);
/*     */     }
/*     */     catch (InstantiationException localInstantiationException)
/*     */     {
/* 498 */       throw new RuntimeException(localInstantiationException);
/*     */     }
/*     */   }
/*     */ 
/*     */   private Constructor prepareProxy(Class paramClass1, Class paramClass2)
/*     */   {
/* 506 */     Class localClass = null;
/*     */     try
/*     */     {
/* 511 */       localClass = Class.forName(new GeneratedProxiesRegistry.Key(paramClass1, paramClass2).toString());
/*     */     }
/*     */     catch (ClassNotFoundException localClassNotFoundException)
/*     */     {
/* 517 */       localClass = ClassGenerator.generate(paramClass1, paramClass2, this.annotationsRegistry);
/*     */     }
/*     */ 
/*     */     Constructor localConstructor;
/*     */     try
/*     */     {
/* 527 */       localConstructor = localClass.getConstructor(new Class[] { paramClass1, Object.class, ProxyFactory.class, Map.class });
/*     */     }
/*     */     catch (NoSuchMethodException localNoSuchMethodException)
/*     */     {
/* 535 */       throw new RuntimeException(localNoSuchMethodException);
/*     */     }
/*     */ 
/* 538 */     this.generatedRegistry.put(paramClass1, paramClass2, new GeneratedProxiesRegistry.Value(null, null, localClass, localConstructor));
/*     */ 
/* 545 */     return localConstructor;
/*     */   }
/*     */ 
/*     */   private Class getProxyClass(Class paramClass1, Class paramClass2)
/*     */   {
/* 552 */     if (null == paramClass2) {
/* 553 */       return null;
/*     */     }
/*     */ 
/* 557 */     Object localObject = (Class)this.delegateClassToProxyClass.get(paramClass2);
/* 558 */     if (null != localObject) {
/* 559 */       return EMPTY_VALUE != localObject ? localObject : null;
/*     */     }
/*     */ 
/* 562 */     if (null == paramClass1) {
/* 563 */       return null;
/*     */     }
/* 565 */     localObject = this.generatedRegistry.get(paramClass1, this.annotationsRegistry.get(paramClass1).getSuperclass());
/*     */ 
/* 570 */     if (null == localObject) {
/* 571 */       return null;
/*     */     }
/* 573 */     Class localClass = ((GeneratedProxiesRegistry.Value)localObject).getClazz();
/*     */ 
/* 576 */     this.delegateClassToProxyClass.put(paramClass2, null != localClass ? localClass : EMPTY_VALUE);
/*     */ 
/* 578 */     return localClass;
/*     */   }
/*     */ 
/*     */   private Class findMostSuitableIface(Class paramClass)
/*     */   {
/* 590 */     if (null == paramClass) {
/* 591 */       return null;
/*     */     }
/*     */ 
/* 596 */     Class localClass1 = (Class)this.delegateToMostSuitableIface.get(paramClass);
/* 597 */     if (null != localClass1) {
/* 598 */       return EMPTY_VALUE != localClass1 ? localClass1 : null;
/*     */     }
/*     */ 
/* 601 */     int i = -1;
/* 602 */     Object localObject = null;
/* 603 */     for (Class localClass2 : this.annotationsRegistry.keySet())
/*     */     {
/* 605 */       int j = intersectionCardinality(paramClass, localClass2);
/* 606 */       if ((j >= 1) && 
/* 608 */         (j > i))
/*     */       {
/* 612 */         i = j;
/* 613 */         localObject = localClass2;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 618 */     this.delegateToMostSuitableIface.put(paramClass, null != localObject ? localObject : EMPTY_VALUE);
/*     */ 
/* 620 */     return localObject;
/*     */   }
/*     */ 
/*     */   private int intersectionCardinality(Class paramClass1, Class paramClass2)
/*     */   {
/* 627 */     HashSet localHashSet1 = new HashSet();
/*     */ 
/* 630 */     collectIfaces(paramClass2, localHashSet1);
/*     */ 
/* 632 */     HashSet localHashSet2 = new HashSet();
/*     */ 
/* 635 */     collectIfaces(paramClass1, localHashSet2);
/*     */ 
/* 637 */     int i = localHashSet1.size();
/* 638 */     localHashSet1.removeAll(localHashSet2);
/*     */ 
/* 640 */     if (localHashSet1.size() > 0) {
/* 641 */       return -1;
/*     */     }
/* 643 */     return i;
/*     */   }
/*     */ 
/*     */   private void collectIfaces(Class paramClass, Set<Class> paramSet)
/*     */   {
/* 650 */     if (paramClass.isInterface()) {
/* 651 */       paramSet.add(paramClass);
/*     */     }
/* 653 */     for (Class localClass : paramClass.getInterfaces()) {
/* 654 */       collectIfaces(localClass, paramSet);
/*     */     }
/* 656 */     ??? = paramClass.getSuperclass();
/* 657 */     if (null != ???)
/* 658 */       collectIfaces((Class)???, paramSet);
/*     */   }
/*     */ 
/*     */   private static final class EMPTY_CLASS
/*     */   {
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.proxy.ProxyFactory
 * JD-Core Version:    0.6.2
 */