package oracle.jdbc.proxy;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class ProxyExport
{
  public static void main(String[] paramArrayOfString)
    throws ClassNotFoundException, IOException
  {
    if (0 == paramArrayOfString.length)
    {
      System.out.println("Usage:");
      System.out.println("java -classpath ojdbc6.jar oracle.jdbc.proxy.ProxyExport [-d dir] class1 class2 class3 ...");
      System.out.println("  dir - directory to store exported proxy classes");
      System.out.println("  class1 class2 class3 ... - superclasses equipped with @ProxyFor annotation");
      return;
    }

    int i = 0;
    String str1 = "";

    if ("-d".equals(paramArrayOfString[0]))
    {
      if (paramArrayOfString.length < 2)
      {
        System.out.println("wrong directory");
        return;
      }

      str1 = paramArrayOfString[1];
      i = 2;

      if (!new File(str1).exists())
      {
        System.out.println("target directory does not exist");
        return;
      }

      if ((0 != str1.length()) && (!str1.endsWith(File.separator))) {
        str1 = str1 + File.separator;
      }
    }
    ArrayList localArrayList = new ArrayList();
    for (; i < paramArrayOfString.length; i++) {
      localArrayList.add(Class.forName(paramArrayOfString[i]));
    }
    ProxyFactory localProxyFactory = ProxyFactory.createProxyFactory((Class[])localArrayList.toArray(new Class[0]));

    AnnotationsRegistry localAnnotationsRegistry = localProxyFactory.annotationsRegistry;

    for (AnnotationsRegistry.Value localValue : localAnnotationsRegistry.values())
    {
      localClass1 = localValue.getSuperclass();
      for (Class localClass2 : localValue.getIfacesToProxy())
      {
        GeneratedProxiesRegistry.Key localKey = new GeneratedProxiesRegistry.Key(localClass2, localClass1);

        byte[] arrayOfByte = ClassGenerator.generateBytecode(localKey, localProxyFactory.annotationsRegistry);

        String str2 = localKey.makePathname();

        int j = str2.lastIndexOf(File.separator);
        if (-1 != j)
        {
          localObject = str2.substring(0, j);
          new File(str1 + (String)localObject).mkdirs();
        }

        Object localObject = new BufferedOutputStream(new FileOutputStream(str1 + str2));

        ((BufferedOutputStream)localObject).write(arrayOfByte);
        ((BufferedOutputStream)localObject).close();
      }
    }
    Class localClass1;
  }
}

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.proxy.ProxyExport
 * JD-Core Version:    0.6.2
 */