/*     */ package oracle.jdbc.proxy;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Arrays;
/*     */ 
/*     */ class MethodSignature
/*     */ {
/*     */   private final String name;
/*     */   private final Class[] parameterTypes;
/*     */   private final Class returnType;
/*  90 */   private Integer hashCode = null;
/*     */ 
/*     */   MethodSignature(Method paramMethod)
/*     */   {
/*  39 */     this.name = paramMethod.getName();
/*  40 */     this.parameterTypes = paramMethod.getParameterTypes();
/*  41 */     this.returnType = paramMethod.getReturnType();
/*     */   }
/*     */ 
/*     */   MethodSignature(String paramString, Class[] paramArrayOfClass, Class paramClass)
/*     */   {
/*  55 */     this.name = paramString;
/*  56 */     this.parameterTypes = paramArrayOfClass;
/*  57 */     this.returnType = paramClass;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object paramObject)
/*     */   {
/*  62 */     if (null == paramObject) {
/*  63 */       return false;
/*     */     }
/*  65 */     if (!(paramObject instanceof MethodSignature)) {
/*  66 */       return false;
/*     */     }
/*  68 */     MethodSignature localMethodSignature = (MethodSignature)paramObject;
/*  69 */     if (this == localMethodSignature) {
/*  70 */       return true;
/*     */     }
/*  72 */     if (!this.name.equals(localMethodSignature.name)) {
/*  73 */       return false;
/*     */     }
/*  75 */     if (!Arrays.deepEquals(this.parameterTypes, localMethodSignature.parameterTypes)) {
/*  76 */       return false;
/*     */     }
/*  78 */     if ((null != this.returnType) && (null != localMethodSignature.returnType) && (!this.returnType.equals(localMethodSignature.returnType)))
/*     */     {
/*  81 */       throw new RuntimeException("methods \"" + this.name + "\" have the same signature \"" + this.parameterTypes + "\" but different return types: \"" + this.returnType + "\" and \"" + localMethodSignature.returnType + '"');
/*     */     }
/*     */ 
/*  87 */     return true;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/*  94 */     if (null == this.hashCode)
/*     */     {
/*  96 */       this.hashCode = new Integer(23);
/*  97 */       this.hashCode = Integer.valueOf(HashUtil.hash(this.hashCode.intValue(), this.name));
/*  98 */       this.hashCode = Integer.valueOf(HashUtil.hash(this.hashCode.intValue(), this.parameterTypes));
/*     */     }
/* 100 */     return this.hashCode.intValue();
/*     */   }
/*     */ 
/*     */   String getName()
/*     */   {
/* 108 */     return this.name;
/*     */   }
/*     */ 
/*     */   Class[] getParameterTypes()
/*     */   {
/* 116 */     return this.parameterTypes;
/*     */   }
/*     */ 
/*     */   Class getReturnType()
/*     */   {
/* 124 */     return this.returnType;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.proxy.MethodSignature
 * JD-Core Version:    0.6.2
 */