/*     */ package oracle.jdbc.proxy;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
/*     */ import org.objectweb.asm.ClassWriter;
/*     */ import org.objectweb.asm.Label;
/*     */ import org.objectweb.asm.MethodVisitor;
/*     */ import org.objectweb.asm.Type;
/*     */ 
/*     */ class MethodGenerator
/*     */ {
/*  68 */   private static long ids = 0L;
/*  69 */   private final String methodObject = new StringBuilder().append("methodObject").append(ids++).toString();
/*     */   private final String proxyName;
/*     */   private final String ifaceName;
/*     */   private final String superclassName;
/*     */   private final String proxyType;
/*     */   private final String ifaceType;
/*     */   private final Method method;
/*     */   private final ClassGenerator.AnnotationsForIface annotationsForIface;
/*     */   private final boolean callDelegate;
/*     */   private final boolean returns;
/*     */   private final Class[] parameterTypes;
/*     */   private final Class[] exceptionTypes;
/*     */   private final Class returnType;
/*     */   private final String methodName;
/*     */   private final String signature;
/*     */   private final String[] throwables;
/* 112 */   private final List<Class> exceptionsToCatch = new ReadOnlyList()
/*     */   {
/*     */     public Class get(int paramAnonymousInt)
/*     */     {
/* 117 */       return 0 == paramAnonymousInt ? RuntimeException.class : MethodGenerator.this.exceptionTypes[(paramAnonymousInt - 1)];
/*     */     }
/*     */ 
/*     */     public int size()
/*     */     {
/* 124 */       return MethodGenerator.this.exceptionTypes.length + 1;
/*     */     }
/* 112 */   };
/*     */ 
/*     */   MethodGenerator(ClassGenerator paramClassGenerator, Method paramMethod, boolean paramBoolean)
/*     */   {
/*  87 */     this.proxyName = paramClassGenerator.getProxyName();
/*  88 */     this.ifaceName = paramClassGenerator.getIfaceName();
/*  89 */     this.superclassName = paramClassGenerator.getSuperclassName();
/*  90 */     this.ifaceType = paramClassGenerator.getIfaceType();
/*  91 */     this.proxyType = paramClassGenerator.getProxyType();
/*  92 */     this.method = paramMethod;
/*  93 */     this.annotationsForIface = paramClassGenerator.getAnnotationsForIface();
/*  94 */     this.callDelegate = paramBoolean;
/*  95 */     this.parameterTypes = paramMethod.getParameterTypes();
/*  96 */     this.exceptionTypes = paramMethod.getExceptionTypes();
/*  97 */     this.returnType = paramMethod.getReturnType();
/*  98 */     this.returns = (!"void".equals(this.returnType.getName()));
/*  99 */     this.methodName = paramMethod.getName();
/* 100 */     this.signature = Utils.makeSignature(this.parameterTypes, this.returnType);
/* 101 */     this.throwables = Utils.makeThrowables(this.exceptionTypes);
/*     */   }
/*     */ 
/*     */   String getMethodObject()
/*     */   {
/* 109 */     return this.methodObject;
/*     */   }
/*     */ 
/*     */   private Method getMethodPre()
/*     */   {
/* 130 */     AnnotationsRegistry.Value localValue = this.annotationsForIface.getValue();
/*     */ 
/* 133 */     if (null == localValue) {
/* 134 */       return null;
/*     */     }
/* 136 */     return localValue.getMethodPre(this.annotationsForIface.getIface(), new MethodSignature(this.method));
/*     */   }
/*     */ 
/*     */   private boolean isResultProxied()
/*     */   {
/* 143 */     if (!hasAssignableProxyForReturnType(this.returnType, this.annotationsForIface.getRegistry().keySet())) {
/* 144 */       return false;
/*     */     }
/* 146 */     AnnotationsRegistry.Value localValue = this.annotationsForIface.getValue();
/*     */ 
/* 149 */     if (null == localValue) {
/* 150 */       return false;
/*     */     }
/* 152 */     boolean bool = localValue.belongsToIfaceToProxy(this.annotationsForIface.getIface(), new MethodSignature(this.method));
/*     */ 
/* 157 */     return (bool) && (ProxyResultPolicy.MANUAL != getProxyResultPolicy());
/*     */   }
/*     */ 
/*     */   private final boolean hasAssignableProxyForReturnType(Class paramClass, Set<Class> paramSet)
/*     */   {
/* 162 */     for (Class localClass : paramSet) {
/* 163 */       if (paramClass.isAssignableFrom(localClass)) return true;
/*     */     }
/* 165 */     return false;
/*     */   }
/*     */ 
/*     */   private boolean isMethodPreDefined()
/*     */   {
/* 170 */     return null != getMethodPre();
/*     */   }
/*     */ 
/*     */   private Method getMethodVoidPost()
/*     */   {
/* 175 */     AnnotationsRegistry.Value localValue = this.annotationsForIface.getValue();
/*     */ 
/* 178 */     if (null == localValue) {
/* 179 */       return null;
/*     */     }
/* 181 */     return localValue.getMethodVoidPost(this.annotationsForIface.getIface(), new MethodSignature(this.method));
/*     */   }
/*     */ 
/*     */   private boolean isMethodVoidPostDefined()
/*     */   {
/* 188 */     return null != getMethodVoidPost();
/*     */   }
/*     */ 
/*     */   private Method getMethodReturningPost()
/*     */   {
/* 193 */     AnnotationsRegistry.Value localValue = this.annotationsForIface.getValue();
/*     */ 
/* 196 */     if (null == localValue) {
/* 197 */       return null;
/*     */     }
/* 199 */     return localValue.getMethodReturningPost(this.annotationsForIface.getIface(), new MethodSignature(this.method));
/*     */   }
/*     */ 
/*     */   private boolean isMethodReturningPostDefined()
/*     */   {
/* 206 */     return null != getMethodReturningPost();
/*     */   }
/*     */ 
/*     */   private Method getMethodVoidOnError(Class paramClass)
/*     */   {
/* 212 */     AnnotationsRegistry.Value localValue = this.annotationsForIface.getValue();
/*     */ 
/* 215 */     if (null == localValue) {
/* 216 */       return null;
/*     */     }
/* 218 */     Map localMap = localValue.getMapVoidOnError(this.annotationsForIface.getIface(), new MethodSignature(this.method));
/*     */ 
/* 223 */     if (null == localMap) {
/* 224 */       return null;
/*     */     }
/* 226 */     return (Method)localMap.get(paramClass);
/*     */   }
/*     */ 
/*     */   private boolean isMethodVoidOnErrorDefined()
/*     */   {
/* 231 */     boolean bool = false;
/*     */ 
/* 233 */     for (Class localClass : this.exceptionsToCatch) {
/* 234 */       if (null != getMethodVoidOnError(localClass))
/* 235 */         bool = true;
/*     */     }
/* 237 */     return bool;
/*     */   }
/*     */ 
/*     */   private Method getMethodReturningOnError(Class paramClass)
/*     */   {
/* 243 */     AnnotationsRegistry.Value localValue = this.annotationsForIface.getValue();
/*     */ 
/* 246 */     if (null == localValue) {
/* 247 */       return null;
/*     */     }
/* 249 */     Map localMap = localValue.getMapReturningOnError(this.annotationsForIface.getIface(), new MethodSignature(this.method));
/*     */ 
/* 254 */     if (null == localMap) {
/* 255 */       return null;
/*     */     }
/* 257 */     return (Method)localMap.get(paramClass);
/*     */   }
/*     */ 
/*     */   private boolean isMethodReturningOnErrorDefined()
/*     */   {
/* 262 */     boolean bool = false;
/*     */ 
/* 264 */     for (Class localClass : this.exceptionsToCatch) {
/* 265 */       if (null != getMethodReturningOnError(localClass))
/* 266 */         bool = true;
/*     */     }
/* 268 */     return bool;
/*     */   }
/*     */ 
/*     */   private boolean isMethodOnErrorDefined()
/*     */   {
/* 273 */     return this.returns ? isMethodReturningOnErrorDefined() : isMethodVoidOnErrorDefined();
/*     */   }
/*     */ 
/*     */   private boolean isMethodPostDefined()
/*     */   {
/* 280 */     return this.returns ? isMethodReturningPostDefined() : isMethodVoidPostDefined();
/*     */   }
/*     */ 
/*     */   final Method getMethodPost()
/*     */   {
/* 286 */     return this.returns ? getMethodReturningPost() : getMethodVoidPost();
/*     */   }
/*     */ 
/*     */   boolean isAnyInterceptorDefined()
/*     */   {
/* 293 */     return (isMethodPreDefined()) || (isMethodVoidPostDefined()) || (isMethodReturningPostDefined()) || (isMethodVoidOnErrorDefined()) || (isMethodReturningOnErrorDefined());
/*     */   }
/*     */ 
/*     */   ProxyResultPolicy getProxyResultPolicy()
/*     */   {
/* 302 */     AnnotationsRegistry.Value localValue = this.annotationsForIface.getValue();
/*     */ 
/* 305 */     if (null == localValue) {
/* 306 */       return ProxyResultPolicy.CACHE;
/*     */     }
/* 308 */     return localValue.getProxyResultPolicy(this.method);
/*     */   }
/*     */ 
/*     */   void generate(ClassWriter paramClassWriter)
/*     */   {
/* 347 */     MethodVisitor localMethodVisitor = paramClassWriter.visitMethod(this.method.isVarArgs() ? 129 : 1, this.methodName, this.signature, null, this.throwables);
/*     */ 
/* 354 */     localMethodVisitor.visitCode();
/*     */ 
/* 356 */     Label localLabel1 = new Label();
/* 357 */     Label localLabel2 = new Label();
/* 358 */     Label localLabel3 = new Label();
/* 359 */     Label localLabel4 = new Label();
/*     */ 
/* 367 */     int j = 1;
/*     */     Object localObject2;
/* 369 */     for (localObject2 : this.parameterTypes) {
/* 370 */       j += Utils.varSize((Class)localObject2);
/*     */     }
/* 372 */     int i = j;
/*     */     Label[] arrayOfLabel1;
/*     */     int k;
/*     */     Object localObject1;
/* 376 */     if (isMethodOnErrorDefined())
/*     */     {
/* 378 */       j = this.exceptionsToCatch.size();
/* 379 */       arrayOfLabel1 = new Label[j];
/*     */ 
/* 381 */       for (k = 0; k < j; k++)
/*     */       {
/* 383 */         Class localClass = (Class)this.exceptionsToCatch.get(k);
/*     */ 
/* 385 */         localObject1 = this.returns ? getMethodReturningOnError(localClass) : getMethodVoidOnError(localClass);
/*     */ 
/* 389 */         if (null != localObject1)
/*     */         {
/* 392 */           localMethodVisitor.visitTryCatchBlock(localLabel3, localLabel4, arrayOfLabel1[k] =  = new Label(), Utils.makeSlashed((Class)this.exceptionsToCatch.get(k)));
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 400 */       arrayOfLabel1 = null;
/*     */     }
/* 402 */     localMethodVisitor.visitLabel(localLabel1);
/* 403 */     localMethodVisitor.visitLabel(localLabel3);
/*     */ 
/* 406 */     if (isMethodPreDefined())
/*     */     {
/* 408 */       localMethodVisitor.visitVarInsn(25, 0);
/*     */ 
/* 410 */       localMethodVisitor.visitFieldInsn(178, this.proxyName, getMethodObject(), "Ljava/lang/reflect/Method;");
/*     */ 
/* 416 */       localMethodVisitor.visitVarInsn(25, 0);
/*     */ 
/* 419 */       j = this.parameterTypes.length;
/*     */ 
/* 421 */       if ((this.method.isVarArgs()) && (1 == j)) {
/* 422 */         localMethodVisitor.visitVarInsn(25, 1);
/* 423 */       } else if (0 == j) {
/* 424 */         localMethodVisitor.visitFieldInsn(178, this.proxyName, "zeroLengthObjectArray", "[Ljava/lang/Object;");
/*     */       }
/*     */       else
/*     */       {
/* 431 */         Utils.loadConst(localMethodVisitor, j);
/* 432 */         localMethodVisitor.visitTypeInsn(189, "java/lang/Object");
/*     */ 
/* 434 */         k = 1; for (i1 = 0; i1 < j; i1++)
/*     */         {
/* 436 */           localObject1 = this.parameterTypes[i1];
/*     */ 
/* 438 */           localMethodVisitor.visitInsn(89);
/* 439 */           Utils.loadConst(localMethodVisitor, i1);
/* 440 */           localMethodVisitor.visitVarInsn(Utils.loadOpcode((Class)localObject1), k);
/* 441 */           Utils.autoBox(localMethodVisitor, (Class)localObject1);
/* 442 */           localMethodVisitor.visitInsn(83);
/* 443 */           k += Utils.varSize((Class)localObject1);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 448 */       localMethodVisitor.visitMethodInsn(183, this.superclassName, getMethodPre().getName(), "(Ljava/lang/reflect/Method;Ljava/lang/Object;[Ljava/lang/Object;)V");
/*     */     }
/*     */ 
/* 465 */     if (isMethodPostDefined())
/*     */     {
/* 467 */       localMethodVisitor.visitVarInsn(25, 0);
/*     */ 
/* 469 */       localMethodVisitor.visitFieldInsn(178, this.proxyName, getMethodObject(), "Ljava/lang/reflect/Method;");
/*     */     }
/*     */ 
/* 476 */     boolean bool = isResultProxied();
/*     */ 
/* 478 */     if ((this.returns) && (bool))
/*     */     {
/* 480 */       localMethodVisitor.visitVarInsn(25, 0);
/* 481 */       localMethodVisitor.visitFieldInsn(180, this.proxyName, "proxyFactory", Utils.makeType(ProxyFactory.class.getName()));
/*     */     }
/*     */ 
/* 488 */     localMethodVisitor.visitVarInsn(25, 0);
/*     */ 
/* 490 */     if (this.callDelegate) {
/* 491 */       localMethodVisitor.visitFieldInsn(180, this.proxyName, "delegate", this.ifaceType);
/*     */     }
/*     */ 
/* 497 */     loadDelegateParams(localMethodVisitor);
/*     */ 
/* 499 */     localMethodVisitor.visitMethodInsn(this.callDelegate ? 185 : 183, this.callDelegate ? this.ifaceName : this.superclassName, this.methodName, this.signature);
/*     */ 
/* 505 */     if ((this.returns) && (bool))
/*     */     {
/* 507 */       Utils.cast(localMethodVisitor, this.returnType, Object.class);
/*     */ 
/* 509 */       localMethodVisitor.visitVarInsn(25, 0);
/*     */ 
/* 511 */       localMethodVisitor.visitVarInsn(25, 0);
/* 512 */       localMethodVisitor.visitFieldInsn(180, this.proxyName, "proxyCache", "Ljava/util/Map;");
/*     */ 
/* 518 */       localMethodVisitor.visitFieldInsn(178, this.proxyName, getMethodObject(), "Ljava/lang/reflect/Method;");
/*     */       String str;
/* 525 */       switch (2.$SwitchMap$oracle$jdbc$proxy$annotation$ProxyResultPolicy[getProxyResultPolicy().ordinal()]) {
/*     */       case 1:
/* 527 */         str = "proxyForCreate"; break;
/*     */       case 2:
/* 528 */         str = "proxyForCache"; break;
/*     */       case 3:
/* 529 */         str = "proxyForCreateCache"; break;
/*     */       default:
/* 530 */         throw new RuntimeException("internal error");
/*     */       }
/*     */ 
/* 533 */       localMethodVisitor.visitMethodInsn(182, Utils.makeSlashed(ProxyFactory.class.getName()), str, "(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/Map;Ljava/lang/reflect/Method;)Ljava/lang/Object;");
/*     */     }
/*     */ 
/* 540 */     if (isMethodPostDefined())
/*     */     {
/* 542 */       if (this.returns) {
/* 543 */         Utils.cast(localMethodVisitor, bool ? Object.class : this.returnType, getMethodPost().getParameterTypes()[1]);
/*     */       }
/*     */ 
/* 548 */       localMethodVisitor.visitMethodInsn(182, this.superclassName, getMethodPost().getName(), new StringBuilder().append("(Ljava/lang/reflect/Method;").append(this.returns ? Utils.makeType(getMethodPost().getParameterTypes()[1]) : "").append(")").append(Utils.makeType(getMethodPost().getReturnType())).toString());
/*     */ 
/* 556 */       if (this.returns)
/* 557 */         Utils.cast(localMethodVisitor, getMethodPost().getReturnType(), this.returnType);
/*     */     }
/* 559 */     else if (this.returns) {
/* 560 */       Utils.cast(localMethodVisitor, bool ? Object.class : this.returnType, this.returnType);
/*     */     }
/*     */ 
/* 565 */     localMethodVisitor.visitLabel(localLabel4);
/* 566 */     localMethodVisitor.visitInsn(Utils.returnOpcode(this.returnType));
/*     */     Label[] arrayOfLabel2;
/*     */     Label[] arrayOfLabel3;
/* 569 */     if (isMethodOnErrorDefined())
/*     */     {
/* 571 */       m = this.exceptionsToCatch.size();
/* 572 */       arrayOfLabel2 = new Label[m];
/* 573 */       arrayOfLabel3 = new Label[m];
/*     */ 
/* 575 */       for (i1 = 0; i1 < m; i1++)
/*     */       {
/* 577 */         localObject1 = (Class)this.exceptionsToCatch.get(i1);
/*     */ 
/* 579 */         localObject2 = this.returns ? getMethodReturningOnError((Class)localObject1) : getMethodVoidOnError((Class)localObject1);
/*     */ 
/* 583 */         if (null != localObject2)
/*     */         {
/* 586 */           localMethodVisitor.visitLabel(arrayOfLabel1[i1]);
/*     */ 
/* 588 */           localMethodVisitor.visitFrame(4, 0, null, 1, new Object[] { Utils.makeSlashed((Class)localObject1) });
/*     */ 
/* 595 */           localMethodVisitor.visitVarInsn(58, i);
/*     */ 
/* 597 */           localMethodVisitor.visitLabel(arrayOfLabel2[i1] =  = new Label());
/*     */ 
/* 606 */           localMethodVisitor.visitVarInsn(25, 0);
/*     */ 
/* 608 */           localMethodVisitor.visitFieldInsn(178, this.proxyName, getMethodObject(), "Ljava/lang/reflect/Method;");
/*     */ 
/* 614 */           if ((this.returns) && (isMethodPostDefined()))
/*     */           {
/* 616 */             localMethodVisitor.visitVarInsn(25, 0);
/*     */ 
/* 618 */             localMethodVisitor.visitFieldInsn(178, this.proxyName, getMethodObject(), "Ljava/lang/reflect/Method;");
/*     */           }
/*     */ 
/* 625 */           localMethodVisitor.visitVarInsn(25, i);
/*     */ 
/* 627 */           localMethodVisitor.visitMethodInsn(182, this.superclassName, ((Method)localObject2).getName(), new StringBuilder().append("(Ljava/lang/reflect/Method;").append(Utils.makeType(localObject2.getParameterTypes()[1].getName())).append(")").append(Utils.makeType(((Method)localObject2).getReturnType().getName())).toString());
/*     */ 
/* 635 */           if ((this.returns) && (isMethodPostDefined()))
/*     */           {
/* 637 */             Utils.cast(localMethodVisitor, ((Method)localObject2).getReturnType(), getMethodPost().getParameterTypes()[1]);
/*     */ 
/* 642 */             localMethodVisitor.visitMethodInsn(182, this.superclassName, getMethodPost().getName(), new StringBuilder().append("(Ljava/lang/reflect/Method;").append(Utils.makeType(getMethodPost().getParameterTypes()[1].getName())).append(")").append(Utils.makeType(getMethodPost().getReturnType().getName())).toString());
/*     */ 
/* 650 */             Utils.cast(localMethodVisitor, getMethodPost().getReturnType(), this.returnType);
/*     */           }
/*     */           else {
/* 653 */             Utils.cast(localMethodVisitor, ((Method)localObject2).getReturnType(), this.returnType);
/*     */           }
/* 655 */           localMethodVisitor.visitInsn(Utils.returnOpcode(this.returnType));
/*     */ 
/* 657 */           localMethodVisitor.visitLabel(arrayOfLabel3[i1] =  = new Label());
/*     */         }
/*     */       }
/*     */     }
/*     */     else {
/* 662 */       arrayOfLabel2 = arrayOfLabel3 = null;
/*     */     }
/* 664 */     localMethodVisitor.visitLabel(localLabel2);
/*     */ 
/* 667 */     int m = 0;
/*     */ 
/* 669 */     localMethodVisitor.visitLocalVariable("this", this.proxyType, null, localLabel1, localLabel2, m++);
/*     */ 
/* 677 */     for (int i1 = 0; 
/* 678 */       i1 < this.parameterTypes.length; 
/* 679 */       i1++) {
/* 680 */       localMethodVisitor.visitLocalVariable(new StringBuilder().append("arg").append(i1).toString(), Utils.makeType(this.parameterTypes[i1]), null, localLabel1, localLabel2, m);
/*     */ 
/* 679 */       m += Utils.varSize(this.parameterTypes[i1]);
/*     */     }
/*     */ 
/* 688 */     if (isMethodOnErrorDefined())
/*     */     {
/* 690 */       if (i != m) {
/* 691 */         throw new RuntimeException("wrong exception index");
/*     */       }
/* 693 */       i1 = this.exceptionsToCatch.size();
/* 694 */       for (int i3 = 0; i3 < i1; i3++)
/*     */       {
/* 696 */         localObject2 = (Class)this.exceptionsToCatch.get(i3);
/*     */ 
/* 698 */         Method localMethod = this.returns ? getMethodReturningOnError((Class)localObject2) : getMethodVoidOnError((Class)localObject2);
/*     */ 
/* 702 */         if (null != localMethod)
/*     */         {
/* 705 */           localMethodVisitor.visitLocalVariable("e", Utils.makeType((Class)this.exceptionsToCatch.get(i3)), null, arrayOfLabel2[i3], arrayOfLabel3[i3], i);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 715 */     localMethodVisitor.visitMaxs(0, 0);
/* 716 */     localMethodVisitor.visitEnd();
/*     */   }
/*     */ 
/*     */   private void loadDelegateParams(MethodVisitor paramMethodVisitor)
/*     */   {
/* 721 */     String str1 = Utils.makeSlashed(_Proxy_.class.getName());
/*     */ 
/* 723 */     int i = 1; for (int j = 0; 
/* 724 */       j < this.parameterTypes.length; 
/* 725 */       j++)
/*     */     {
/* 727 */       Class localClass1 = this.parameterTypes[j];
/* 728 */       String str2 = Utils.makeSlashed(localClass1.getName());
/* 729 */       int k = 0;
/*     */ 
/* 731 */       for (Object localObject1 = this.annotationsForIface.getRegistry().values().iterator(); ((Iterator)localObject1).hasNext(); ) { localObject2 = (AnnotationsRegistry.Value)((Iterator)localObject1).next();
/* 732 */         for (Class localClass2 : ((AnnotationsRegistry.Value)localObject2).getIfacesToProxy())
/* 733 */           if (localClass1.isAssignableFrom(localClass2))
/*     */           {
/* 735 */             k = 1;
/* 736 */             break;
/*     */           }
/*     */       }
/*     */       Object localObject2;
/* 739 */       if (k != 0)
/*     */       {
/* 741 */         paramMethodVisitor.visitVarInsn(Utils.loadOpcode(localClass1), i);
/* 742 */         paramMethodVisitor.visitTypeInsn(193, str1);
/* 743 */         localObject1 = new Label();
/* 744 */         paramMethodVisitor.visitJumpInsn(153, (Label)localObject1);
/* 745 */         paramMethodVisitor.visitVarInsn(Utils.loadOpcode(localClass1), i);
/* 746 */         paramMethodVisitor.visitTypeInsn(192, str1);
/* 747 */         paramMethodVisitor.visitMethodInsn(185, str1, "_getDelegate_", "()Ljava/lang/Object;");
/*     */ 
/* 752 */         paramMethodVisitor.visitTypeInsn(192, str2);
/* 753 */         localObject2 = new Label();
/* 754 */         paramMethodVisitor.visitJumpInsn(167, (Label)localObject2);
/* 755 */         paramMethodVisitor.visitLabel((Label)localObject1);
/* 756 */         paramMethodVisitor.visitFrame(3, 0, null, 0, null);
/* 757 */         paramMethodVisitor.visitVarInsn(Utils.loadOpcode(localClass1), i);
/* 758 */         paramMethodVisitor.visitLabel((Label)localObject2);
/* 759 */         paramMethodVisitor.visitFrame(4, 0, null, 1, new Object[] { str2 });
/*     */       }
/*     */       else {
/* 762 */         paramMethodVisitor.visitVarInsn(Utils.loadOpcode(localClass1), i);
/*     */       }
/* 725 */       i += Utils.varSize(this.parameterTypes[j]);
/*     */     }
/*     */   }
/*     */ 
/*     */   void initializeMethodObject(MethodVisitor paramMethodVisitor)
/*     */   {
/* 768 */     int i = this.parameterTypes.length;
/* 769 */     paramMethodVisitor.visitLdcInsn(Type.getType(Utils.makeType(this.method.getDeclaringClass().getName())));
/* 770 */     paramMethodVisitor.visitLdcInsn(this.methodName);
/* 771 */     Utils.loadConst(paramMethodVisitor, i);
/* 772 */     paramMethodVisitor.visitTypeInsn(189, "java/lang/Class");
/*     */ 
/* 774 */     for (int j = 0; j < i; j++)
/*     */     {
/* 776 */       paramMethodVisitor.visitInsn(89);
/* 777 */       Utils.loadConst(paramMethodVisitor, j);
/* 778 */       Utils.loadClass(paramMethodVisitor, this.parameterTypes[j]);
/* 779 */       paramMethodVisitor.visitInsn(83);
/*     */     }
/*     */ 
/* 782 */     paramMethodVisitor.visitMethodInsn(182, "java/lang/Class", "getDeclaredMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;");
/*     */ 
/* 788 */     paramMethodVisitor.visitFieldInsn(179, this.proxyName, getMethodObject(), "Ljava/lang/reflect/Method;");
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.proxy.MethodGenerator
 * JD-Core Version:    0.6.2
 */