/*     */ package oracle.jdbc.proxy;
/*     */ 
/*     */ import java.lang.reflect.Array;
/*     */ 
/*     */ class HashUtil
/*     */ {
/*     */   static final int SEED = 23;
/*     */   private static final int ODD_PRIME_NUMBER = 37;
/*     */ 
/*     */   static int hash(int paramInt, boolean paramBoolean)
/*     */   {
/*  37 */     return firstTerm(paramInt) + (paramBoolean ? 1 : 0);
/*     */   }
/*     */ 
/*     */   static int hash(int paramInt, char paramChar)
/*     */   {
/*  48 */     return firstTerm(paramInt) + paramChar;
/*     */   }
/*     */ 
/*     */   static int hash(int paramInt1, int paramInt2)
/*     */   {
/*  59 */     return firstTerm(paramInt1) + paramInt2;
/*     */   }
/*     */ 
/*     */   static int hash(int paramInt, long paramLong)
/*     */   {
/*  70 */     return firstTerm(paramInt) + (int)(paramLong ^ paramLong >>> 32);
/*     */   }
/*     */ 
/*     */   static int hash(int paramInt, float paramFloat)
/*     */   {
/*  81 */     return hash(paramInt, Float.floatToIntBits(paramFloat));
/*     */   }
/*     */ 
/*     */   static int hash(int paramInt, double paramDouble)
/*     */   {
/*  92 */     return hash(paramInt, Double.doubleToLongBits(paramDouble));
/*     */   }
/*     */ 
/*     */   static int hash(int paramInt, Object paramObject)
/*     */   {
/* 103 */     int i = paramInt;
/* 104 */     if (paramObject == null) {
/* 105 */       i = hash(i, 0);
/* 106 */     } else if (!paramObject.getClass().isArray()) {
/* 107 */       i = hash(i, paramObject.hashCode());
/*     */     }
/*     */     else {
/* 110 */       int j = Array.getLength(paramObject);
/* 111 */       for (int k = 0; k < j; k++)
/*     */       {
/* 113 */         Object localObject = Array.get(paramObject, k);
/* 114 */         i = hash(i, localObject);
/*     */       }
/*     */     }
/* 117 */     return i;
/*     */   }
/*     */ 
/*     */   private static int firstTerm(int paramInt)
/*     */   {
/* 124 */     return 37 * paramInt;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jdbc.proxy.HashUtil
 * JD-Core Version:    0.6.2
 */